/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.util;

import java.util.List;

public class StringUtils {
    private static final String LINE_SEPARATOR_KEY = "line.separator";
    private static final String SHORTENING_MARKER = "...";

    public static String null2emptyString(String value) {
        if (value != null) {
            return value;
        }
        return "";
    }

    public static String toStringOrNull(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static <T> String toString(List<T> elements) {
        return StringUtils.toString(elements, new ToStringConverter<T>(){

            @Override
            public String toString(T object) {
                if (object == null) {
                    return null;
                }
                return String.valueOf(object);
            }
        });
    }

    public static <T> String toString(List<T> elements, ToStringConverter<T> converter) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < elements.size()) {
            builder.append(converter.toString(elements.get(i)));
            if (i + 1 < elements.size()) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    public static String getLineSeparator() {
        return System.getProperty(LINE_SEPARATOR_KEY);
    }

    public static boolean isAlphaNumeric(String value) {
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphaNumericOrUnderscore(String value) {
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c != '_' && !Character.isLetterOrDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWithLetterOrUnderscore(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        char character = value.charAt(0);
        return character == '_' || Character.isLetter(character);
    }

    public static boolean isEmptyOrNull(String value) {
        return value == null || value.isEmpty();
    }

    public static String shorten(String text, int maxLength) {
        if (text.length() < maxLength) {
            return text;
        }
        int availableCharacters = maxLength - SHORTENING_MARKER.length();
        return text.substring(0, availableCharacters / 2) + SHORTENING_MARKER + text.substring(text.length() - availableCharacters / 2, text.length());
    }

    public static String getWithoutSuffix(String string, String suffix) {
        String stringNoSuffix = string;
        int suffixIndex = string.indexOf(suffix);
        if (suffixIndex >= 0) {
            stringNoSuffix = string.substring(0, suffixIndex);
        }
        return stringNoSuffix;
    }

    public static String trim(String string) {
        if (string == null) {
            return string;
        }
        return string.trim();
    }

    public static String toLowerCase(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        return string.toLowerCase();
    }

    public static interface ToStringConverter<T> {
        public String toString(T var1);
    }
}

