/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class ProjectUtils {
    private static final String RSE_INTERNAL_PROJECTS = "RemoteSystems";

    public static boolean exists(IProject project) {
        return project != null && project.exists();
    }

    public static boolean exists(String name) {
        return ProjectUtils.exists(ResourcesPlugin.getWorkspace().getRoot().getProject(name));
    }

    public static boolean isAccessible(IProject project) {
        return project != null && project.isAccessible();
    }

    public static String[] getAllOpenedProjects() {
        ArrayList<String> projects = new ArrayList<String>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists() && project.isOpen()) {
                projects.add(project.getName());
            }
            ++n2;
        }
        return projects.toArray(new String[projects.size()]);
    }

    public static boolean isInternalRSE(String projectName) {
        return projectName != null && projectName.startsWith(RSE_INTERNAL_PROJECTS);
    }
}

