/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.server;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServer;
import org.jboss.ide.eclipse.as.core.server.internal.IExtendedPropertiesProvider;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerExtendedProperties;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.express.internal.core.util.UrlUtils;

public class OpenShiftServer
extends DeployableServer
implements IURLProvider,
IExtendedPropertiesProvider {
    public static final String DEFAULT_SERVER_NAME_BASE = "ApplicationName";
    public static final String OPENSHIFT_MODE_ID = "openshift";

    public void setDefaults(IProgressMonitor monitor) {
        this.getServerWorkingCopy().setHost(UrlUtils.cutScheme(ConnectionUtils.getDefaultHostUrl()));
        this.getServerWorkingCopy().setName(OpenShiftServerUtils.getDefaultServerName(DEFAULT_SERVER_NAME_BASE));
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", OPENSHIFT_MODE_ID);
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        return Status.OK_STATUS;
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        IStatus status = this.canModifyModules(new IModule[]{module}, null);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        IModule[] parents = ServerModelUtilities.getParentModules((IServer)this.getServer(), (IModule)module);
        if (parents.length > 0) {
            return parents;
        }
        return new IModule[]{module};
    }

    public IModule[] getChildModules(IModule[] module) {
        return ServerModelUtilities.getChildModules((IModule[])module);
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public URL getModuleRootURL(IModule module) {
        String appProjString = OpenShiftServerUtils.getDeployProjectName((IServerAttributes)this.getServer());
        IProject appProj = appProjString == null ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(appProjString);
        IProject p = module.getProject();
        boolean shouldIgnore = OpenShiftServerUtils.getIgnoresContextRoot((IServerAttributes)this.getServer()) && p.equals((Object)appProj);
        return JBossServer.getModuleRootURL((IModule)module, (String)this.getServer().getHost(), (int)80, (String)(shouldIgnore ? "" : null));
    }

    public ServerExtendedProperties getExtendedProperties() {
        return new OpenShiftServerExtendedProperties((IAdaptable)this.getServer());
    }

    public boolean isUseProjectSpecificSchedulingRuleOnPublish() {
        return false;
    }
}

