/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.security;

import java.io.UnsupportedEncodingException;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.jboss.tools.openshift.express.internal.core.security.SecurePasswordStoreException;

public class SecurePasswordStore {
    private String password;
    private IStorageKey storageKey;

    public SecurePasswordStore(IStorageKey key) {
        this.storageKey = key;
    }

    public String getPassword() throws SecurePasswordStoreException {
        try {
            this.password = this.getFromPreferences(this.storageKey);
            return this.password;
        }
        catch (Exception e) {
            throw new SecurePasswordStoreException("Could get password", e);
        }
    }

    public void setPassword(String password) throws SecurePasswordStoreException {
        this.update(this.storageKey, password);
    }

    public void update(IStorageKey key, String password) throws SecurePasswordStoreException {
        if (!this.storageKey.equals(key) || this.isPasswordChanged(password)) {
            this.password = password;
            this.storageKey = key;
            this.storeInPreferences(this.password, this.storageKey);
        }
    }

    private boolean isPasswordChanged(String password) {
        if (this.password == null && password == null) {
            return false;
        }
        return this.password == null && password != null || this.password != null && password == null || !password.equals(this.password);
    }

    public void remove() throws SecurePasswordStoreException {
        try {
            ISecurePreferences node = this.getNode(this.storageKey);
            if (node == null) {
                throw new SecurePasswordStoreException("Could not remove password");
            }
            node.clear();
        }
        catch (Exception e) {
            throw new SecurePasswordStoreException("Could not remove password", e);
        }
    }

    private String getFromPreferences(IStorageKey key) throws StorageException, UnsupportedEncodingException {
        ISecurePreferences node = this.getNode(key);
        String password = node.get("password", null);
        if (password == null) {
            return null;
        }
        return new String(EncodingUtils.decodeBase64((String)password));
    }

    private void storeInPreferences(String password, IStorageKey key) throws SecurePasswordStoreException {
        if (password != null) {
            try {
                ISecurePreferences node = this.getNode(key);
                node.put("password", EncodingUtils.encodeBase64((byte[])password.getBytes()), true);
            }
            catch (Exception e) {
                throw new SecurePasswordStoreException("Could not store password", e);
            }
        }
    }

    private ISecurePreferences getNode(IStorageKey key) throws UnsupportedEncodingException {
        if (key == null) {
            return null;
        }
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        return root.node(key.getKey());
    }

    public static interface IStorageKey {
        public String getKey();

        public boolean equals(IStorageKey var1);
    }
}

