/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.connection;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.core.util.UrlUtils;

public class ConnectionURL {
    private static final Pattern MALFORMED_URL_PATTERN = Pattern.compile("(https?://)?([^@]+)@(https?://)?(.*)");
    private String username;
    private String host;
    private String scheme;
    private String url;

    private ConnectionURL(String username, String host, String scheme) throws UnsupportedEncodingException {
        this.username = username;
        this.host = host;
        this.scheme = scheme;
        this.url = UrlUtils.getUrlFor(username, host, scheme);
    }

    public String getUsername() {
        return this.username;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isDefaultHost() {
        return StringUtils.isEmpty(this.host);
    }

    public String getScheme() {
        return this.scheme;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionURL other = (ConnectionURL)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public static ConnectionURL forUsername(String username) throws UnsupportedEncodingException, MalformedURLException {
        if (StringUtils.isEmpty(username)) {
            throw new IllegalArgumentException("Username is empty");
        }
        UrlUtils.UrlPortions portions = UrlUtils.toPortions(ConnectionUtils.getDefaultHostUrl());
        return new ConnectionURL(username, null, portions.getScheme());
    }

    public static ConnectionURL forUsernameAndServer(String username, String host) throws UnsupportedEncodingException, MalformedURLException {
        if (StringUtils.isEmpty(username)) {
            throw new IllegalArgumentException("Username is empty");
        }
        if (StringUtils.isEmpty(host)) {
            throw new IllegalArgumentException("Host is empty");
        }
        UrlUtils.UrlPortions portions = UrlUtils.toPortions(host);
        return new ConnectionURL(username, portions.getHost(), portions.getScheme());
    }

    public static ConnectionURL forConnection(Connection connection) throws UnsupportedEncodingException, MalformedURLException {
        if (connection.isDefaultHost()) {
            return ConnectionURL.forUsername(connection.getUsername());
        }
        String host = ConnectionURL.getHost(connection);
        String scheme = ConnectionURL.getScheme(connection);
        return new ConnectionURL(connection.getUsername(), host, scheme);
    }

    private static String getHost(Connection connection) {
        if (connection.isDefaultHost()) {
            return null;
        }
        return UrlUtils.cutScheme(connection.getHost());
    }

    private static String getScheme(Connection connection) {
        String scheme = connection.getScheme();
        if (scheme == null) {
            scheme = "https://";
        }
        return scheme;
    }

    public static ConnectionURL forURL(String url) throws UnsupportedEncodingException, MalformedURLException {
        return ConnectionURL.forURL(new URL(ConnectionURL.correctMalformedUrl(url)));
    }

    public static ConnectionURL forURL(URL url) throws UnsupportedEncodingException {
        Assert.isLegal((url != null ? 1 : 0) != 0, (String)"url is null");
        UrlUtils.UrlPortions portions = UrlUtils.toPortions(url);
        String host = ConnectionURL.getHost(portions);
        return new ConnectionURL(portions.getUsername(), host, portions.getScheme());
    }

    private static String getHost(UrlUtils.UrlPortions portions) {
        String host = portions.getHost();
        if (StringUtils.isEmpty(host)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(portions.getHost());
        if (portions.getPort() > -1) {
            builder.append(':').append(portions.getPort());
        }
        return builder.toString();
    }

    private static String correctMalformedUrl(String url) {
        Matcher matcher = MALFORMED_URL_PATTERN.matcher(url);
        if (!matcher.matches() || matcher.groupCount() != 4) {
            return url;
        }
        if (!StringUtils.isEmpty(matcher.group(1))) {
            return url;
        }
        if (StringUtils.isEmpty(matcher.group(4))) {
            return matcher.group(3) + matcher.group(2) + '@';
        }
        return matcher.group(3) + matcher.group(2) + '@' + matcher.group(4);
    }
}

