/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views.actions;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.refactoring.SeamRefactorContributionFactory;

public class RenameComponentAction
extends Action
implements SpecialWizard {
    ISeamComponent component;

    public RenameComponentAction() {
    }

    public RenameComponentAction(ISeamComponent component) {
        this.setText(SeamCoreMessages.RENAME_SEAM_COMPONENT);
        this.component = component;
    }

    public void run() {
        if (this.component != null) {
            Shell activeShell = SeamGuiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            SeamRefactorContributionFactory.invokeRenameComponentWizard(this.component, activeShell);
        }
    }

    public int execute() {
        this.run();
        return 0;
    }

    public void setObject(Object object) {
        if (object instanceof XModelObject) {
            String name;
            ISeamComponent[] cs;
            XModelObject o = (XModelObject)object;
            IProject project = EclipseResourceUtil.getProject((XModelObject)o);
            if (project == null) {
                return;
            }
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
            if (seamProject == null) {
                return;
            }
            ISeamComponent[] iSeamComponentArray = cs = seamProject.getComponents();
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                ISeamXmlComponentDeclaration d;
                Object id;
                ISeamComponent c = iSeamComponentArray[n2];
                Set ds = c.getXmlDeclarations();
                if (ds != null && ds.size() != 0 && (id = ((SeamObject)(d = (ISeamXmlComponentDeclaration)ds.iterator().next())).getId()) == o) {
                    this.component = c;
                    break;
                }
                ++n2;
            }
            if (this.component == null && (name = o.getAttributeValue("name")) != null && name.length() > 0) {
                this.component = seamProject.getComponent(name);
            }
        }
    }
}

