/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.marker;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IMarkerResolution2;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.ui.SeamGuiPlugin;

public abstract class AbstractSeamMarkerResolution
implements IMarkerResolution2 {
    protected String label;
    protected String qualifiedName;
    protected IFile file;
    protected int start;
    protected int end;

    public AbstractSeamMarkerResolution(String label, String qualifiedName, IFile file, int start, int end) {
        this.label = label;
        this.qualifiedName = qualifiedName;
        this.file = file;
        this.start = start;
        this.end = end;
    }

    protected void deleteAnnotation() {
        try {
            ICompilationUnit original = EclipseUtil.getCompilationUnit((IFile)this.file);
            if (original == null) {
                return;
            }
            ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IJavaElement javaElement = compilationUnit.getElementAt(this.start);
            if (javaElement != null) {
                CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
                MultiTextEdit edit = new MultiTextEdit();
                change.setEdit((TextEdit)edit);
                MarkerResolutionUtils.deleteAnnotation((String)this.qualifiedName, (ICompilationUnit)compilationUnit, (IJavaElement)javaElement, (MultiTextEdit)edit);
                if (edit.hasChildren()) {
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                    original.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            compilationUnit.discardWorkingCopy();
        }
        catch (CoreException ex) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    protected boolean validateComponentName(String value) {
        ISeamProject seamProject = this.getSeamProject();
        Map errors = SeamValidatorFactory.SEAM_COMPONENT_NAME_VALIDATOR.validate((Object)value, (Object)seamProject);
        return errors.isEmpty();
    }

    protected ISeamProject getSeamProject() {
        return SeamCorePlugin.getSeamProject((IProject)this.file.getProject(), (boolean)true);
    }

    protected String generateComponentName(String className) {
        String componentName = className.toLowerCase();
        if (this.validateComponentName(componentName)) {
            return componentName;
        }
        int index = 2;
        String name = componentName;
        while (!this.validateComponentName(componentName) && index < 100) {
            name = String.valueOf(componentName) + index;
            ++index;
        }
        return name;
    }

    protected void addAnnotation(String annotationString, boolean insertName) {
        try {
            ICompilationUnit original = EclipseUtil.getCompilationUnit((IFile)this.file);
            if (original == null) {
                return;
            }
            ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IJavaElement javaElement = compilationUnit.getElementAt(this.start);
            if (javaElement != null) {
                javaElement = compilationUnit.findPrimaryType();
                String param = "";
                if (insertName) {
                    param = "(\"" + this.generateComponentName(compilationUnit.findPrimaryType().getElementName()) + "\")";
                }
                CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
                MultiTextEdit edit = new MultiTextEdit();
                change.setEdit((TextEdit)edit);
                MarkerResolutionUtils.addAnnotation((String)this.qualifiedName, (ICompilationUnit)compilationUnit, (IJavaElement)javaElement, (String)param, (MultiTextEdit)edit);
                if (edit.hasChildren()) {
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                    original.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            compilationUnit.discardWorkingCopy();
        }
        catch (CoreException ex) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    protected void addAnnotatedMethod() {
        try {
            ICompilationUnit original = EclipseUtil.getCompilationUnit((IFile)this.file);
            if (original == null) {
                return;
            }
            ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IType type = compilationUnit.findPrimaryType();
            if (type != null) {
                String annotation = MarkerResolutionUtils.getShortName((String)this.qualifiedName);
                String methodName = annotation.toLowerCase();
                CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
                MultiTextEdit edit = new MultiTextEdit();
                change.setEdit((TextEdit)edit);
                IMethod oldMethod = type.getMethod(methodName, new String[0]);
                if (oldMethod == null || !oldMethod.exists()) {
                    MarkerResolutionUtils.addImport((String)this.qualifiedName, (ICompilationUnit)compilationUnit, (MultiTextEdit)edit);
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add("@" + annotation);
                    lines.add("public void " + methodName + "() {");
                    lines.add("}");
                    MarkerResolutionUtils.addMethod(lines, (ICompilationUnit)compilationUnit, (IType)type, (MultiTextEdit)edit);
                } else {
                    MarkerResolutionUtils.addAnnotation((String)this.qualifiedName, (ICompilationUnit)compilationUnit, (IJavaElement)oldMethod, (String)"", (MultiTextEdit)edit);
                }
                if (edit.hasChildren()) {
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                    original.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
                }
                compilationUnit.discardWorkingCopy();
            }
        }
        catch (CoreException ex) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    protected void renameAnnotation(String param, String importName, boolean generate) {
        try {
            ICompilationUnit original = EclipseUtil.getCompilationUnit((IFile)this.file);
            if (original == null) {
                return;
            }
            ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IJavaElement javaElement = compilationUnit.getElementAt(this.start);
            if (javaElement != null) {
                if (generate) {
                    param = "(\"" + this.generateComponentName(compilationUnit.findPrimaryType().getElementName()) + "\")";
                }
                CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
                MultiTextEdit edit = new MultiTextEdit();
                change.setEdit((TextEdit)edit);
                MarkerResolutionUtils.updateAnnotation((String)this.qualifiedName, (ICompilationUnit)compilationUnit, (IJavaElement)javaElement, (String)param, (MultiTextEdit)edit);
                if (edit.hasChildren()) {
                    change.perform((IProgressMonitor)new NullProgressMonitor());
                    original.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            compilationUnit.discardWorkingCopy();
        }
        catch (CoreException ex) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
    }

    public String getDescription() {
        return this.label;
    }

    public Image getImage() {
        return null;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }
}

