/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.internal.project.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.jboss.tools.common.ui.IValidator;
import org.jboss.tools.seam.internal.core.project.facet.SeamValidatorFactory;

public class DataModelValidatorDelegate
implements IDataModelListener {
    protected IDataModel model = null;
    protected WizardPage page = null;
    protected Map<String, IValidator> mapPropToValidator = new HashMap<String, IValidator>();
    private List<String> validationOrder = new ArrayList<String>();

    public DataModelValidatorDelegate(IDataModel model, WizardPage page) {
        this.model = model;
        this.page = page;
        model.addListener((IDataModelListener)this);
    }

    public Map<String, String> validate() {
        HashMap<String, String> errors = new HashMap<String, String>();
        return errors;
    }

    public void propertyChanged(DataModelEvent event) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DataModelValidatorDelegate.this.validateUntillError();
            }
        });
    }

    public void validateUntillError() {
        IStatus message = this.getFirstValidationError();
        if (message == null) {
            this.page.setMessage(null);
            this.page.setErrorMessage(null);
        } else if (message.getSeverity() == 4) {
            this.page.setErrorMessage(message.getMessage());
        } else {
            this.page.setErrorMessage(null);
            this.page.setMessage(message.getMessage(), 2);
        }
        this.page.setPageComplete(this.page.getErrorMessage() == null);
    }

    public IStatus getFirstValidationError() {
        IStatus firstWarning = null;
        for (String validatorName : this.validationOrder) {
            Map errors = this.getValidator(validatorName).validate(this.model.getProperty(validatorName), (Object)this.model);
            IStatus message = (IStatus)errors.get(validatorName);
            if (message == null) continue;
            if (message.getSeverity() == 4) {
                return message;
            }
            if (message.getSeverity() != 2 || firstWarning != null) continue;
            firstWarning = message;
        }
        return firstWarning;
    }

    public IValidator getValidator(String name) {
        IValidator validator = this.mapPropToValidator.get(name);
        return validator == null ? SeamValidatorFactory.NO_ERRORS_VALIDATOR : validator;
    }

    public void addValidatorForProperty(String name, IValidator validator) {
        this.mapPropToValidator.put(name, validator);
        this.validationOrder.add(name);
    }
}

