/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.internal;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jboss.tools.feedhenry.ui.internal.FHAppLabelProvider;
import org.jboss.tools.feedhenry.ui.internal.FHApplicationContentProvider;
import org.jboss.tools.feedhenry.ui.internal.FeedHenryApplicationSelector;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;
import org.jboss.tools.feedhenry.ui.model.FeedHenryProject;

public class FeedHenryApplicationSelectionPart {
    private final FeedHenryApplicationSelector selector;
    private CheckboxTreeViewer appsList;
    private FHAppLabelProvider labelProvider;
    private FHApplicationContentProvider contentProvider;
    private String label;
    private IFilter filter;
    private IFilter disabledFilter;

    FeedHenryApplicationSelectionPart(FeedHenryApplicationSelector selector) {
        this.selector = selector;
    }

    void createContent(Composite parent) {
        Composite appsCompsite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)appsCompsite);
        GridLayoutFactory.fillDefaults().applyTo(appsCompsite);
        if (this.label != null && !this.label.isEmpty()) {
            Label title = new Label(appsCompsite, 0);
            title.setText(this.label);
            GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)title);
        }
        this.appsList = new CheckboxTreeViewer(appsCompsite);
        PixelConverter pc = new PixelConverter(this.appsList.getControl());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(pc.convertWidthInCharsToPixels(25), pc.convertHeightInCharsToPixels(10)).applyTo(this.appsList.getControl());
        this.appsList.setContentProvider(this.getContentProvider());
        this.appsList.setLabelProvider(this.getLabelProvider());
        this.appsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof FeedHenryApplication) {
                    FeedHenryApplication app = (FeedHenryApplication)element;
                    if (FeedHenryApplicationSelectionPart.this.disabledFilter == null || !FeedHenryApplicationSelectionPart.this.disabledFilter.select((Object)app)) {
                        FeedHenryApplicationSelectionPart.this.selector.selectionChanged();
                        return;
                    }
                }
                if (element instanceof FeedHenryProject) {
                    FeedHenryApplicationSelectionPart.this.setCheckStateforApps((FeedHenryProject)element, event.getChecked());
                    FeedHenryApplicationSelectionPart.this.selector.selectionChanged();
                    return;
                }
                if (event.getChecked()) {
                    event.getCheckable().setChecked(element, false);
                }
            }
        });
    }

    Object[] getCheckedElements() {
        Assert.isNotNull((Object)this.appsList, (String)"Must be called after createContent");
        return this.appsList.getCheckedElements();
    }

    void setInput(List<FeedHenryProject> projects) {
        Assert.isNotNull((Object)this.appsList, (String)"Must be called after createContent");
        this.appsList.setInput(projects);
    }

    void setLabelProvider(FHAppLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    void setContentProvider(FHApplicationContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    void setLabel(String string) {
        this.label = string;
    }

    void setProjectFilter(IFilter filter) {
        this.filter = filter;
    }

    void setDisabledFilter(IFilter filter) {
        this.disabledFilter = filter;
    }

    private IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    private IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    private void setCheckStateforApps(FeedHenryProject project, boolean state) {
        List<FeedHenryApplication> apps = project.getApplications();
        for (FeedHenryApplication application : apps) {
            if (this.filter != null && !this.filter.select((Object)application) || this.disabledFilter != null && this.disabledFilter.select((Object)application)) continue;
            this.appsList.setChecked((Object)application, state);
        }
    }
}

