/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;
import org.jboss.tools.feedhenry.ui.model.FeedHenryProject;

final class FHApplicationContentProvider
implements ITreeContentProvider {
    private List<FeedHenryProject> projects;
    private IFilter filter;

    FHApplicationContentProvider() {
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.projects = (List)newInput;
    }

    public Object[] getElements(Object inputElement) {
        if (this.filter == null) {
            return this.projects.toArray(new FeedHenryProject[this.projects.size()]);
        }
        ArrayList<FeedHenryProject> validProjects = new ArrayList<FeedHenryProject>();
        for (FeedHenryProject feedHenryProject : this.projects) {
            if (!this.hasValidApplications(feedHenryProject)) continue;
            validProjects.add(feedHenryProject);
        }
        return validProjects.toArray(new FeedHenryProject[validProjects.size()]);
    }

    public Object[] getChildren(Object parentElement) {
        FeedHenryProject prj;
        List<FeedHenryApplication> apps;
        if (parentElement instanceof FeedHenryProject && (apps = (prj = (FeedHenryProject)parentElement).getApplications()) != null) {
            if (this.filter == null) {
                return apps.toArray(new FeedHenryApplication[apps.size()]);
            }
            ArrayList<FeedHenryApplication> valids = new ArrayList<FeedHenryApplication>();
            for (FeedHenryApplication feedHenryApplication : apps) {
                if (!this.filter.select((Object)feedHenryApplication)) continue;
                valids.add(feedHenryApplication);
            }
            return valids.toArray(new FeedHenryApplication[valids.size()]);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof FeedHenryProject) {
            FeedHenryProject project = (FeedHenryProject)element;
            if (this.filter == null) {
                return project.getApplications() != null && !project.getApplications().isEmpty();
            }
            return this.hasValidApplications(project);
        }
        return false;
    }

    void setProjectFilter(IFilter filter) {
        this.filter = filter;
    }

    private boolean hasValidApplications(FeedHenryProject project) {
        List<FeedHenryApplication> apps = project.getApplications();
        for (FeedHenryApplication application : apps) {
            if (!this.filter.select((Object)application)) continue;
            return true;
        }
        return false;
    }
}

