/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.feedhenry.ui.FHPlugin;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;
import org.jboss.tools.feedhenry.ui.model.FeedHenryProject;

final class FHAppLabelProvider
extends LabelProvider
implements IFontProvider,
IColorProvider {
    private IFilter disabledFilter;

    FHAppLabelProvider() {
    }

    public String getText(Object element) {
        if (element instanceof FeedHenryProject) {
            FeedHenryProject p = (FeedHenryProject)element;
            return p.getTitle();
        }
        FeedHenryApplication app = (FeedHenryApplication)element;
        return app.getTitle();
    }

    public Image getImage(Object element) {
        if (element instanceof FeedHenryProject) {
            ImageDescriptor desc = FHPlugin.getImageDescriptor("org.jboss.tools.feedhenry.ui", "/icons/obj16/feedhenry_16.png");
            return desc.createImage();
        }
        if (element instanceof FeedHenryApplication) {
            FeedHenryApplication app = (FeedHenryApplication)element;
            if ("client_advanced_hybrid".equals(app.getType())) {
                ImageDescriptor desc = FHPlugin.getImageDescriptor("org.jboss.tools.feedhenry.ui", "/icons/obj16/cordova_16.png");
                return desc.createImage();
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
        }
        return super.getImage(element);
    }

    public Font getFont(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof FeedHenryApplication) {
            FeedHenryApplication app = (FeedHenryApplication)element;
            if (this.disabledFilter != null && this.disabledFilter.select((Object)app)) {
                return Display.getCurrent().getSystemColor(33);
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    void setDisabledItemsFilter(IFilter filter) {
        this.disabledFilter = filter;
    }
}

