/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.cordovasim.internal.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.jboss.tools.feedhenry.ui.FHPlugin;
import org.jboss.tools.feedhenry.ui.cordovasim.internal.launch.FHLaunchShortcut;
import org.jboss.tools.feedhenry.ui.cordovasim.util.FeedHenryUtil;
import org.jboss.tools.vpe.cordovasim.eclipse.launch.CordovaSimLaunchParametersUtil;
import org.jboss.tools.vpe.cordovasim.eclipse.launch.RippleProxy;

public class FHLocalLaunch
extends FHLaunchShortcut {
    private static final String FH_LOCAL_PREFIX = "(FeedHenry local)";

    @Override
    public String getLaunchPrefix() {
        return FH_LOCAL_PREFIX;
    }

    @Override
    protected void launch(IProject project, String mode) {
        try {
            ILaunchConfigurationType cordovaSimLaunchConfiguraionType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.jboss.tools.vpe.cordovasim.eclipse.cordovaSimLaunchConfigurationType");
            ILaunchConfiguration[] configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(cordovaSimLaunchConfiguraionType);
            ILaunchConfiguration existingConfiguraion = this.chooseLaunchConfiguration(configurations, project);
            if (existingConfiguraion != null) {
                existingConfiguraion.delete();
            }
            if (project != null) {
                ILaunchConfigurationWorkingCopy newConfiguration = this.createEmptyLaunchConfiguration(String.valueOf(project.getName()) + this.getLaunchPrefix());
                this.setConfigAttributes(newConfiguration, project);
                newConfiguration.doSave();
                DebugUITools.launch((ILaunchConfiguration)newConfiguration, (String)mode);
            }
        }
        catch (CoreException e) {
            FHPlugin.log(4, e.getMessage(), e);
        }
    }

    @Override
    protected void setConfigAttributes(ILaunchConfigurationWorkingCopy launchConfiguration, IProject project) {
        if (project != null) {
            launchConfiguration.setAttribute(".PROJECT", project.getName());
            launchConfiguration.setAttribute("org.jboss.tools.vpe.cordovasim.eclipse.START_PAGE", this.getStartPage(project));
            launchConfiguration.setAttribute("org.jboss.tools.vpe.cordovasim.eclipse.FH", this.getLaunchPrefix());
            launchConfiguration.setAttribute("org.jboss.tools.vpe.cordovasim.eclipse.PROXY", RippleProxy.DISABLED.getValue());
        }
    }

    private String getStartPage(IProject project) {
        String startPage = CordovaSimLaunchParametersUtil.getDefaultStartPageFromConfigXml((IProject)project);
        return FeedHenryUtil.addDefaultServerParameter(startPage);
    }
}

