/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.feedhenry.ui.cordova.internal;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.thym.ui.util.DirectorySelectionGroup;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.jboss.tools.feedhenry.ui.internal.FeedHenryApplicationSelector;
import org.jboss.tools.feedhenry.ui.model.FeedHenryApplication;

public class FHApplicationSelectionPage
extends WizardPage
implements FeedHenryApplicationSelector.SelectionChangeCallback {
    private FeedHenryApplicationSelector appSelector;
    private final IStructuredSelection currentSelection;
    private DirectorySelectionGroup destinationDirectoryGroup;
    private WorkingSetGroup workingSetGroup;

    protected FHApplicationSelectionPage(IStructuredSelection selection) {
        super("FeedHenry Application Selection Page");
        this.currentSelection = selection;
        this.setTitle("FeedHenry Application Import");
        this.setDescription("Import a Cordova application from FeedHenry");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        GridLayoutFactory.fillDefaults().applyTo(workArea);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)workArea);
        this.appSelector = new FeedHenryApplicationSelector();
        this.appSelector.setProjectsFilter(new IFilter(){

            public boolean select(Object toTest) {
                return toTest instanceof FeedHenryApplication;
            }
        }).setLabel("Select applications:").setSelectionChangeCallback(this).setDisabledProjectsFilter(new IFilter(){

            public boolean select(Object toTest) {
                if (!(toTest instanceof FeedHenryApplication)) {
                    return false;
                }
                FeedHenryApplication app = (FeedHenryApplication)toTest;
                return !app.getType().equals("client_advanced_hybrid") || app.findEclipseProject() != null;
            }
        }).createSelectorUI(workArea);
        this.destinationDirectoryGroup = new DirectorySelectionGroup(workArea, 0);
        this.destinationDirectoryGroup.setText("Destination:");
        GridDataFactory.fillDefaults().applyTo((Control)this.destinationDirectoryGroup);
        this.destinationDirectoryGroup.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FHApplicationSelectionPage.this.setPageComplete(FHApplicationSelectionPage.this.isValid());
            }
        });
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            Path p = new Path(userHome);
            this.destinationDirectoryGroup.setDefaultValue(p.append("/git").toString());
        }
        this.createWorkingSetGroup();
        this.appSelector.retrieveProjects((IRunnableContext)this.getContainer());
        this.restoreWidgetValues();
        this.setPageComplete(false);
        Dialog.applyDialogFont((Control)workArea);
    }

    public List<FeedHenryApplication> getSelectedApplications() {
        return this.appSelector.getSelectedApplications();
    }

    public String getWorkingPath() {
        return this.destinationDirectoryGroup.getValue();
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup.getSelectedWorkingSets();
    }

    @Override
    public void selectionChanged(List<FeedHenryApplication> newSelection) {
        this.setPageComplete(this.isValid());
    }

    private void createWorkingSetGroup() {
        String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.wst.jsdt.ui.JavaWorkingSetPage"};
        this.workingSetGroup = new WorkingSetGroup((Composite)this.getControl(), this.currentSelection, workingSetIds);
    }

    private boolean isValid() {
        List<FeedHenryApplication> selected = this.getSelectedApplications();
        if (selected == null || selected.isEmpty()) {
            this.setErrorMessage("Please select a project to import");
            return false;
        }
        String dest = this.getWorkingPath();
        if (dest == null || dest.isEmpty()) {
            this.setErrorMessage("Specify a destination directory");
            return false;
        }
        if (!DirectorySelectionGroup.isValidDirectory((File)new File(dest))) {
            this.setErrorMessage(NLS.bind((String)"{0} is not a valid directory", (Object)dest));
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        for (FeedHenryApplication app : selected) {
            if (app.findEclipseProject() != null) {
                this.setErrorMessage(NLS.bind((String)"Application {0} already exist in the workspace", (Object)app.getTitle()));
                return false;
            }
            IStatus nameStatus = workspace.validateName(app.getEclipseProjectName(), 4);
            if (!nameStatus.isOK()) {
                this.setErrorMessage(nameStatus.getMessage());
                return false;
            }
            IProject handle = workspace.getRoot().getProject(app.getEclipseProjectName());
            Path prjPath = new Path(dest);
            File prjDirFile = (prjPath = prjPath.append(app.getEclipseProjectName())).toFile();
            if (prjDirFile.isDirectory() && prjDirFile.list().length > 0) {
                this.setErrorMessage(NLS.bind((String)"\"{0}\" directory already exists and is not empty", (Object)prjPath.toString()));
                return false;
            }
            IStatus locationStatus = workspace.validateProjectLocation(handle, (IPath)prjPath);
            if (locationStatus.isOK()) continue;
            this.setErrorMessage(locationStatus.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void restoreWidgetValues() {
        this.destinationDirectoryGroup.restoreHistory(this.getDialogSettings());
    }

    void saveWidgetValues() {
        this.destinationDirectoryGroup.saveHistory(this.getDialogSettings());
    }
}

