/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.ui.JBossJaxrsUIPlugin;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateCategory;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.wizards.JaxrsElementCreationUtils;
import org.jboss.tools.ws.jaxrs.ui.wizards.JaxrsResourceCreationMessages;
import ui.internal.org.atteo.evo.inflector.English;

public class JaxrsResourceCreationWizardPage
extends NewClassWizardPage {
    private String targetClass = "";
    private Text targetClassText = null;
    private Status targetClassStatus = new Status(0, "org.jboss.tools.ws.jaxrs.ui", null);
    private Button browseClassesButton = null;
    private Text resourcePathText = null;
    private Status resourcePathStatus = new Status(0, "org.jboss.tools.ws.jaxrs.ui", null);
    private String resourcePath = "";
    private TableViewer mediaTypesList = null;
    private List<String> mediaTypes = new ArrayList<String>();
    private Button addMediaTypesButton = null;
    private Button removeMediaTypesButton = null;
    private Composite methodStubsContainer = null;
    private boolean includeFindByIdMethod = false;
    private boolean includeListAllMethod = false;
    private boolean includeCreateMethod = false;
    private boolean includeUpdateMethod = false;
    private boolean includeDeleteByIdMethod = false;
    private JavaTypeCompletionProcessor targetClassCompletionProcessor = new JavaTypeCompletionProcessor(true, false, true);

    public JaxrsResourceCreationWizardPage() {
        this.setTitle(JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_Title);
        this.setDescription(JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_Description);
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        IJavaElement selectedJavaElement = this.getInitialJavaElement(selection);
        if (selectedJavaElement instanceof ICompilationUnit) {
            this.setDefaultValues((ICompilationUnit)selectedJavaElement);
        } else if (selectedJavaElement instanceof IType) {
            this.setDefaultValues((IType)selectedJavaElement);
        } else if (selection.getFirstElement() instanceof UriPathTemplateCategory) {
            this.setDefaultValues((UriPathTemplateCategory)selection.getFirstElement());
        }
        this.mediaTypes.add("application/xml");
        this.mediaTypes.add("application/json");
    }

    private void setDefaultValues(ICompilationUnit compilationUnit) {
        IType primaryType = compilationUnit.findPrimaryType();
        if (primaryType != null && (this.getTargetClass() == null || this.getTargetClass().isEmpty())) {
            this.setDefaultValues(primaryType);
        }
    }

    private void setDefaultValues(IType type) {
        this.setTargetClass(type.getFullyQualifiedName());
        this.setResourcePath(this.buildResourcePath(type));
        ICompilationUnit compilationUnit = type.getCompilationUnit();
        IPackageFragment suggestedPackage = JaxrsElementCreationUtils.getSuggestedPackage(compilationUnit);
        this.setPackageFragment(suggestedPackage, true);
        String typeName = String.valueOf(type.getElementName()) + "Endpoint";
        String typeFullyQualifiedName = String.valueOf(suggestedPackage.getElementName()) + "." + typeName;
        try {
            if (this.getJavaProject() != null && this.getJavaProject().findType(typeFullyQualifiedName) == null) {
                this.setTypeName(typeName, true);
            }
        }
        catch (JavaModelException e) {
            Logger.error("Failed to check if project contains type '" + typeName + "'", e);
        }
    }

    private void setDefaultValues(UriPathTemplateCategory category) {
        IJavaProject javaProject = category.getJavaProject();
        try {
            IPackageFragmentRoot[] packageFragmentRoots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            int n = packageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                if (packageFragmentRoot.getKind() == 1) {
                    this.setPackageFragmentRoot(packageFragmentRoot, true);
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Logger.error("Failed to set the default values from project '" + javaProject.getElementName() + "'", e);
        }
    }

    protected IStatus containerChanged() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            this.targetClassCompletionProcessor.setPackageFragment(root.getPackageFragment(""));
        }
        return super.containerChanged();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, 4);
        this.createPackageControls(composite, 4);
        this.createSeparator(composite, 4);
        this.createTargetClassControls(composite);
        this.createSeparator(composite, 4);
        this.createTypeNameControls(composite, 4);
        this.createResourcePathControls(composite);
        this.createMediaTypesControls(composite);
        this.createResourceMethodStubsControls(composite);
        this.createCommentControls(composite, 4);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.doStatusUpdate();
    }

    private void createResourcePathControls(Composite composite) {
        Label resourcePathLabel = new Label(composite, 0);
        resourcePathLabel.setText("Resource path:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)resourcePathLabel);
        this.resourcePathText = new Text(composite, 2048);
        this.resourcePathText.setText(this.resourcePath);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.resourcePathText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)new Label(composite, 0));
        this.resourcePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JaxrsResourceCreationWizardPage.this.onResourcePathChange();
            }
        });
    }

    private void createTargetClassControls(Composite composite) {
        Label targetClassLabel = new Label(composite, 0);
        targetClassLabel.setText("Target entity:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)targetClassLabel);
        this.targetClassText = new Text(composite, 2048);
        this.targetClassText.setText(this.targetClass);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.targetClassText);
        this.browseClassesButton = new Button(composite, 0);
        this.browseClassesButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.browseClassesButton);
        this.browseClassesButton.addSelectionListener(this.onBrowseTargetClasses());
        ControlContentAssistHelper.createTextContentAssistant((Text)this.targetClassText, (IContentAssistProcessor)this.targetClassCompletionProcessor);
        this.targetClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JaxrsResourceCreationWizardPage.this.onTargetClassChange();
            }
        });
    }

    private void onTargetClassChange() {
        this.setTargetClass(this.targetClassText.getText());
        if (this.targetClass == null || this.targetClass.isEmpty()) {
            this.setAllMethodStubsButtonsEnabled(false);
        } else if (!this.targetClass.isEmpty()) {
            this.setAllMethodStubsButtonsEnabled(true);
        }
    }

    private void onResourcePathChange() {
        this.setResourcePath(this.resourcePathText.getText());
    }

    private void createResourceMethodStubsControls(Composite composite) {
        Label methodStubsLabel = new Label(composite, 0);
        methodStubsLabel.setText("Which JAX-RS Resource Method stubs would you like to create ?");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(4, 1).grab(true, false).applyTo((Control)methodStubsLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)new Label(composite, 0));
        this.methodStubsContainer = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 0).applyTo(this.methodStubsContainer);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 3).grab(true, false).applyTo((Control)this.methodStubsContainer);
        Button includeFindByIdMethodButton = new Button(this.methodStubsContainer, 32);
        includeFindByIdMethodButton.setText("findById()");
        includeFindByIdMethodButton.setSelection(this.isIncludeFindByIdMethod());
        includeFindByIdMethodButton.addSelectionListener((SelectionListener)new ButtonSelectionListener(){

            @Override
            public void selectionChanged(boolean value) {
                JaxrsResourceCreationWizardPage.this.includeFindByIdMethod = value;
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)includeFindByIdMethodButton);
        Button includeListAllMethodButton = new Button(this.methodStubsContainer, 32);
        includeListAllMethodButton.setText("listAll()");
        includeListAllMethodButton.setSelection(this.isIncludeListAllMethod());
        includeListAllMethodButton.addSelectionListener((SelectionListener)new ButtonSelectionListener(){

            @Override
            public void selectionChanged(boolean value) {
                JaxrsResourceCreationWizardPage.this.includeListAllMethod = value;
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)includeListAllMethodButton);
        Button includeCreateMethodButton = new Button(this.methodStubsContainer, 32);
        includeCreateMethodButton.setText("create()");
        includeCreateMethodButton.setSelection(this.isIncludeCreateMethod());
        includeCreateMethodButton.addSelectionListener((SelectionListener)new ButtonSelectionListener(){

            @Override
            public void selectionChanged(boolean value) {
                JaxrsResourceCreationWizardPage.this.includeCreateMethod = value;
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)includeCreateMethodButton);
        Button includeUpdateMethodButton = new Button(this.methodStubsContainer, 32);
        includeUpdateMethodButton.setText("update()");
        includeUpdateMethodButton.setSelection(this.isIncludeUpdateMethod());
        includeUpdateMethodButton.addSelectionListener((SelectionListener)new ButtonSelectionListener(){

            @Override
            public void selectionChanged(boolean value) {
                JaxrsResourceCreationWizardPage.this.includeUpdateMethod = value;
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)includeUpdateMethodButton);
        Button includeDeleteByIdMethodButton = new Button(this.methodStubsContainer, 32);
        includeDeleteByIdMethodButton.setText("deleteById()");
        includeDeleteByIdMethodButton.setSelection(this.isIncludeDeleteByIdMethod());
        includeDeleteByIdMethodButton.addSelectionListener((SelectionListener)new ButtonSelectionListener(){

            @Override
            public void selectionChanged(boolean value) {
                JaxrsResourceCreationWizardPage.this.includeDeleteByIdMethod = value;
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)includeDeleteByIdMethodButton);
        if (this.targetClass == null || this.targetClass.isEmpty()) {
            this.setAllMethodStubsButtonsEnabled(false);
        }
    }

    public void setAllMethodStubsButtonsEnabled(boolean enabled) {
        if (this.methodStubsContainer != null) {
            Control[] controlArray = this.methodStubsContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(enabled);
                ++n2;
            }
        }
    }

    private void createMediaTypesControls(Composite composite) {
        Label mediaTypesLabel = new Label(composite, 0);
        mediaTypesLabel.setText("Media types:");
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)mediaTypesLabel);
        this.mediaTypesList = new TableViewer(composite, 2050);
        this.mediaTypesList.setComparator(new ViewerComparator());
        this.mediaTypesList.setLabelProvider((IBaseLabelProvider)new MediaTypesLabelProvider());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 4).applyTo(this.mediaTypesList.getControl());
        for (String mediaType : this.mediaTypes) {
            this.mediaTypesList.add((Object)mediaType);
        }
        this.addMediaTypesButton = new Button(composite, 0);
        this.addMediaTypesButton.setText("Add...");
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)this.addMediaTypesButton);
        this.addMediaTypesButton.addSelectionListener(this.onAddMediaTypes());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)new Label(composite, 0));
        this.removeMediaTypesButton = new Button(composite, 0);
        this.removeMediaTypesButton.setText("Remove");
        this.removeMediaTypesButton.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)this.removeMediaTypesButton);
        this.removeMediaTypesButton.addSelectionListener(this.onRemoveMediaTypes());
        this.mediaTypesList.addSelectionChangedListener(this.onMediaTypesSelectionChanged());
    }

    private ISelectionChangedListener onMediaTypesSelectionChanged() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    JaxrsResourceCreationWizardPage.this.removeMediaTypesButton.setEnabled(false);
                } else {
                    JaxrsResourceCreationWizardPage.this.removeMediaTypesButton.setEnabled(true);
                }
            }
        };
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus, this.resourcePathStatus, this.targetClassStatus};
        this.updateStatus(status);
    }

    private SelectionListener onBrowseTargetClasses() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IType selectedType;
                    IWizardContainer context = JaxrsResourceCreationWizardPage.this.getWizard().getContainer();
                    IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JaxrsResourceCreationWizardPage.this.getPackageFragmentRoot()});
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)JaxrsResourceCreationWizardPage.this.getShell(), (IRunnableContext)context, (IJavaSearchScope)searchScope, (int)512, (boolean)false);
                    int result = dialog.open();
                    if (result == 0 && (selectedType = (IType)dialog.getResult()[0]) != null) {
                        JaxrsResourceCreationWizardPage.this.setDefaultValues(selectedType);
                    }
                }
                catch (JavaModelException e1) {
                    Logger.error("Failed to open the source folder selection dialog", e1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener onAddMediaTypes() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog mediaTypesSelectionDialog = new ElementListSelectionDialog(JaxrsResourceCreationWizardPage.this.getShell(), (ILabelProvider)new MediaTypesLabelProvider());
                mediaTypesSelectionDialog.setTitle("Media Types Selection");
                mediaTypesSelectionDialog.setMessage("Select one or more media types to be supported by the JAX-RS Resource:");
                mediaTypesSelectionDialog.setMultipleSelection(true);
                mediaTypesSelectionDialog.setElements(new Object[]{"application/atom+xml", "application/x-www-form-urlencoded", "application/octet-stream", "application/xml", "application/json", "application/svg+xml", "application/xhtml+xml", "multipart/form-data", "text/html", "text/plain", "text/xml", "*", "*/*"});
                int returnCode = mediaTypesSelectionDialog.open();
                if (returnCode == 0) {
                    Object[] selectedMediaTypes;
                    Object[] objectArray = selectedMediaTypes = mediaTypesSelectionDialog.getResult();
                    int n = selectedMediaTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selectedMediaType = objectArray[n2];
                        JaxrsResourceCreationWizardPage.this.addMediaType((String)selectedMediaType);
                        ++n2;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener onRemoveMediaTypes() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selectedMediatypes = (IStructuredSelection)JaxrsResourceCreationWizardPage.this.mediaTypesList.getSelection();
                Iterator selectedMediatypeIterator = selectedMediatypes.iterator();
                while (selectedMediatypeIterator.hasNext()) {
                    JaxrsResourceCreationWizardPage.this.removeMediaType(selectedMediatypeIterator.next().toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private void addMediaType(String selectedMediaType) {
        if (!this.mediaTypes.contains(selectedMediaType)) {
            this.mediaTypes.add(selectedMediaType);
            Collections.sort(this.mediaTypes);
            this.mediaTypesList.add((Object)selectedMediaType);
        }
    }

    private void removeMediaType(String selectedMediaType) {
        if (this.mediaTypes.contains(selectedMediaType)) {
            this.mediaTypes.remove(selectedMediaType);
            this.mediaTypesList.remove((Object)selectedMediaType);
        }
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        if (this.resourcePathText != null && this.resourcePathText.getText() != null && !this.resourcePathText.getText().equals(this.resourcePath)) {
            this.resourcePathText.setText(resourcePath);
        }
        this.resourcePathStatus = this.resourcePath == null ? new Status(2, "org.jboss.tools.ws.jaxrs.ui", JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_EmptyResourcePath) : new Status(0, "org.jboss.tools.ws.jaxrs.ui", null);
        this.doStatusUpdate();
    }

    public List<String> getMediaTypes() {
        return this.mediaTypes;
    }

    public boolean isIncludeFindByIdMethod() {
        return this.includeFindByIdMethod;
    }

    public void setIncludeFindByIdMethod(boolean includeFindByIdMethod) {
        this.includeFindByIdMethod = includeFindByIdMethod;
    }

    public boolean isIncludeListAllMethod() {
        return this.includeListAllMethod;
    }

    public void setIncludeListAllMethod(boolean includeListAllMethod) {
        this.includeListAllMethod = includeListAllMethod;
    }

    public boolean isIncludeCreateMethod() {
        return this.includeCreateMethod;
    }

    public void setIncludeCreateMethod(boolean includeCreateMethod) {
        this.includeCreateMethod = includeCreateMethod;
    }

    public boolean isIncludeUpdateMethod() {
        return this.includeUpdateMethod;
    }

    public void setIncludeUpdateMethod(boolean includeUpdateMethod) {
        this.includeUpdateMethod = includeUpdateMethod;
    }

    public boolean isIncludeDeleteByIdMethod() {
        return this.includeDeleteByIdMethod;
    }

    public void setIncludeDeleteByIdMethod(boolean includeDeleteByIdMethod) {
        this.includeDeleteByIdMethod = includeDeleteByIdMethod;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(String targetClass) {
        if (targetClass == null || targetClass.isEmpty()) {
            this.setAllMethodStubsButtonsEnabled(false);
        } else {
            this.setAllMethodStubsButtonsEnabled(true);
        }
        if (targetClass != null && targetClass.equals(this.targetClass)) {
            return;
        }
        this.targetClass = targetClass;
        if (this.targetClassText != null && this.targetClassText.getText() != null && !this.targetClassText.getText().equals(this.targetClass)) {
            this.targetClassText.setText(targetClass);
        }
        try {
            this.targetClassStatus = this.targetClass != null && !this.targetClass.isEmpty() && this.getJavaProject() != null && this.getJavaProject().findType(this.targetClass) == null ? new Status(4, "org.jboss.tools.ws.jaxrs.ui", JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_InvalidTargetClass) : new Status(0, "org.jboss.tools.ws.jaxrs.ui", null);
            this.doStatusUpdate();
        }
        catch (JavaModelException e) {
            Logger.error("Unable to validate Target Class", e);
        }
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, false, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        JaxrsElementCreationUtils.addAnnotation((IMember)newType, "javax.ws.rs.Path", Arrays.asList(this.resourcePath), imports);
        if (this.getJavaProject() != null && this.getJavaProject().findType("javax.enterprise.context.RequestScoped") != null) {
            JaxrsElementCreationUtils.addAnnotation((IMember)newType, "javax.enterprise.context.RequestScoped", null, imports);
        }
        this.createMethodStubs(newType, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    void createMethodStubs(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws JavaModelException {
        IMethod createdMethod;
        String contents;
        if (this.targetClass == null || this.targetClass.isEmpty()) {
            return;
        }
        String targetClassSimpleName = JaxrsElementCreationUtils.getSimpleName(this.targetClass);
        String targetClassParamName = targetClassSimpleName.toLowerCase();
        if (this.targetClass != null && !this.targetClass.isEmpty()) {
            imports.addImport(this.targetClass);
        }
        imports.addImport("javax.ws.rs.core.Response");
        imports.addImport("javax.ws.rs.core.UriBuilder");
        if (this.isIncludeCreateMethod()) {
            imports.addImport("javax.ws.rs.POST");
            contents = this.getCreateMethodBody(type, targetClassSimpleName, targetClassParamName);
            createdMethod = type.createMethod(contents, null, true, monitor);
            if (!this.mediaTypes.isEmpty()) {
                JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.Consumes", this.mediaTypes, imports);
            }
            JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.POST", null, imports);
            this.addMethodComments(createdMethod);
        }
        if (this.isIncludeFindByIdMethod()) {
            imports.addImport("javax.ws.rs.GET");
            imports.addImport("javax.ws.rs.core.Response.Status");
            imports.addImport("javax.ws.rs.PathParam");
            contents = NLS.bind((String)JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_FindByIdMethodSkeleton, (Object[])new String[]{targetClassSimpleName, targetClassParamName});
            createdMethod = type.createMethod(contents, null, true, monitor);
            if (!this.mediaTypes.isEmpty()) {
                JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.Produces", this.mediaTypes, imports);
            }
            JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.Path", Arrays.asList("/{id:[0-9][0-9]*}"), imports);
            JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.GET", null, imports);
            this.addMethodComments(createdMethod);
        }
        if (this.isIncludeListAllMethod()) {
            imports.addImport("javax.ws.rs.GET");
            imports.addImport("java.util.List");
            imports.addImport("javax.ws.rs.QueryParam");
            contents = NLS.bind((String)JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_ListAllMethodSkeleton, (Object[])new String[]{targetClassSimpleName, English.plural(targetClassParamName)});
            createdMethod = type.createMethod(contents, null, true, monitor);
            if (!this.mediaTypes.isEmpty()) {
                JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.Produces", this.mediaTypes, imports);
            }
            JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.GET", null, imports);
            this.addMethodComments(createdMethod);
        }
        if (this.isIncludeUpdateMethod()) {
            imports.addImport("javax.ws.rs.PUT");
            contents = NLS.bind((String)JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_UpdateMethodSkeleton, (Object[])new String[]{targetClassSimpleName, targetClassParamName});
            createdMethod = type.createMethod(contents, null, true, monitor);
            if (!this.mediaTypes.isEmpty()) {
                JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.Consumes", this.mediaTypes, imports);
            }
            JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.Path", Arrays.asList("/{id:[0-9][0-9]*}"), imports);
            JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.PUT", null, imports);
            this.addMethodComments(createdMethod);
        }
        if (this.isIncludeDeleteByIdMethod()) {
            imports.addImport("javax.ws.rs.DELETE");
            imports.addImport("javax.ws.rs.PathParam");
            contents = NLS.bind((String)JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_DeleteByIdMethodSkeleton, (Object[])new String[]{targetClassSimpleName, targetClassParamName});
            createdMethod = type.createMethod(contents, null, true, monitor);
            JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.Path", Arrays.asList("/{id:[0-9][0-9]*}"), imports);
            JaxrsElementCreationUtils.addAnnotation((IMember)createdMethod, "javax.ws.rs.DELETE", null, imports);
            this.addMethodComments(createdMethod);
        }
    }

    private String getCreateMethodBody(IType type, String targetClassSimpleName, String targetClassParamName) {
        try {
            IType targetType = JdtUtils.resolveType((String)this.targetClass, (IJavaProject)this.getJavaProject(), (IProgressMonitor)new NullProgressMonitor());
            IMethod expectedMethod = targetType.getMethod("getId", new String[0]);
            if (expectedMethod != null && expectedMethod.exists()) {
                return NLS.bind((String)JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_CreateMethodSkeleton_complete, (Object[])new String[]{targetClassSimpleName, targetClassParamName, type.getElementName(), targetClassSimpleName});
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to find class '{}' in project's classpath.", e, this.targetClass);
        }
        return NLS.bind((String)JaxrsResourceCreationMessages.JaxrsResourceCreationWizardPage_CreateMethodSkeleton_partial, (Object[])new String[]{targetClassSimpleName, targetClassParamName, type.getElementName(), targetClassSimpleName});
    }

    private void addMethodComments(IMethod method) {
        if (this.isAddComments()) {
            try {
                String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)method.getJavaProject());
                String comment = CodeGeneration.getMethodComment((IMethod)method, null, (String)lineDelimiter);
                if (comment != null) {
                    IBuffer buf = method.getCompilationUnit().getBuffer();
                    buf.replace(method.getSourceRange().getOffset(), 0, comment);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    public String buildResourcePath(IType selectedType) {
        return "/" + English.plural(selectedType.getElementName().toLowerCase());
    }

    private static class ButtonSelectionListener
    implements SelectionListener {
        private ButtonSelectionListener() {
        }

        public void selectionChanged(boolean value) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.selectionChanged(((Button)e.getSource()).getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private static final class MediaTypesLabelProvider
    implements ILabelProvider {
        private MediaTypesLabelProvider() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Image getImage(Object element) {
            return JBossJaxrsUIPlugin.getDefault().getImage("filter_mapping_in_out.png");
        }
    }
}

