/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsNameBinding;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsNameBindingValidatorDelegate
extends AbstractJaxrsElementValidatorDelegate<JaxrsNameBinding> {
    public JaxrsNameBindingValidatorDelegate(IMarkerManager markerManager) {
        super(markerManager);
    }

    @Override
    void internalValidate(JaxrsNameBinding nameBinding, CompilationUnit ast) throws CoreException {
        Logger.debug("Validating element {}", nameBinding);
        this.validateRetentionAnnotation(nameBinding, ast);
        this.validateTargetAnnotation(nameBinding, ast);
    }

    private void validateTargetAnnotation(JaxrsNameBinding nameBinding, CompilationUnit ast) throws CoreException {
        Annotation targetAnnotation = nameBinding.getTargetAnnotation();
        if (targetAnnotation == null) {
            ISourceRange range = ((IType)nameBinding.getJavaElement()).getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)nameBinding, range, JaxrsValidationMessages.NAME_BINDING_MISSING_TARGET_ANNOTATION, new String[0], JaxrsPreferences.NAME_BINDING_MISSING_TARGET_ANNOTATION, 7);
        } else {
            List annotationValues = targetAnnotation.getValues("value");
            List<String> expectedValues = Arrays.asList(ElementType.METHOD.name(), ElementType.TYPE.name());
            if (!CollectionUtils.containsInAnyOrder(annotationValues, expectedValues)) {
                ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)targetAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
                this.markerManager.addMarker((JaxrsBaseElement)nameBinding, range, JaxrsValidationMessages.NAME_BINDING_INVALID_TARGET_ANNOTATION_VALUE, new String[0], JaxrsPreferences.NAME_BINDING_INVALID_TARGET_ANNOTATION_VALUE, 8);
            }
        }
    }

    private void validateRetentionAnnotation(JaxrsNameBinding nameBinding, CompilationUnit ast) throws CoreException {
        Annotation retentionAnnotation = nameBinding.getRetentionAnnotation();
        if (retentionAnnotation == null) {
            ISourceRange range = ((IType)nameBinding.getJavaElement()).getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)nameBinding, range, JaxrsValidationMessages.NAME_BINDING_MISSING_RETENTION_ANNOTATION, new String[0], JaxrsPreferences.NAME_BINDING_MISSING_RETENTION_ANNOTATION, 5);
        } else if (retentionAnnotation.getValue() != null && !retentionAnnotation.getValue().equals(RetentionPolicy.RUNTIME.name())) {
            ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)retentionAnnotation.getJavaAnnotation(), (String)"value", (CompilationUnit)ast);
            this.markerManager.addMarker((JaxrsBaseElement)nameBinding, range, JaxrsValidationMessages.NAME_BINDING_INVALID_RETENTION_ANNOTATION_VALUE, new String[0], JaxrsPreferences.NAME_BINDING_INVALID_RETENTION_ANNOTATION_VALUE, 6);
        }
    }
}

