/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.spring.template;

import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringUrlTemplate
extends VpeAbstractTemplate {
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement urlContainer = VisualDomUtil.createBorderlessContainer((nsIDOMDocument)visualDocument);
        if (sourceElement.hasAttribute("value") && !sourceElement.hasAttribute("var")) {
            String valueAttribute = sourceElement.getAttribute("value");
            StringBuilder url = new StringBuilder(valueAttribute);
            boolean hasParams = valueAttribute.contains("?");
            NodeList childNodes = sourceElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                String childTemplateName = VpeTemplateManager.getInstance().getTemplateName(pageContext, childNode);
                if ("spring:param".equals(childTemplateName)) {
                    url.append(hasParams ? (char)'&' : '?');
                    hasParams = true;
                    this.appendParam(url, (Element)childNode);
                }
                ++i;
            }
            urlContainer.appendChild((nsIDOMNode)visualDocument.createTextNode(url.toString()));
        }
        return new VpeCreationData((nsIDOMNode)urlContainer);
    }

    private void appendParam(StringBuilder url, Element paramElement) {
        if (paramElement.hasAttribute("name")) {
            url.append(paramElement.getAttribute("name"));
            if (paramElement.hasAttribute("value")) {
                url.append('=').append(paramElement.getAttribute("value"));
            }
        }
    }
}

