/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.command;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.livereload.ui.internal.command.LiveReloadServerConfigurationDialogModel;
import org.jboss.tools.livereload.ui.internal.configuration.LiveReloadServerConfigurationMessages;
import org.jboss.tools.livereload.ui.internal.util.ImageRepository;

public class LiveReloadServerConfigurationDialog
extends MessageDialog {
    private Button enableScriptInjectionButton;
    private Button enableRemoteConnectionsButton;
    private final LiveReloadServerConfigurationDialogModel model;
    private final DataBindingContext dbc = new DataBindingContext();

    public LiveReloadServerConfigurationDialog(LiveReloadServerConfigurationDialogModel model, String dialogTitle, String dialogMessage) {
        super(Display.getDefault().getActiveShell(), dialogTitle, ImageRepository.getInstance().getImage("livereload_wiz.png"), dialogMessage, 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.model = model;
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.enableScriptInjectionButton = new Button(container, 32);
        this.enableScriptInjectionButton.setText(LiveReloadServerConfigurationMessages.ENABLE_SCRIPT_INJECTION_LABEL);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.enableScriptInjectionButton);
        IObservableValue enableScriptInjectionObservable = BeanProperties.value((String)"scriptInjectionEnabled").observe((Object)this.model);
        ISWTObservableValue enableScriptInjectionButtonSelection = WidgetProperties.selection().observe((Widget)this.enableScriptInjectionButton);
        this.dbc.bindValue((IObservableValue)enableScriptInjectionButtonSelection, enableScriptInjectionObservable);
        this.enableRemoteConnectionsButton = new Button(container, 32);
        this.enableRemoteConnectionsButton.setText(LiveReloadServerConfigurationMessages.ALLOW_REMOTE_CONNECTIONS_LABEL);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.enableRemoteConnectionsButton);
        IObservableValue enableRemoteConnectionsObservable = BeanProperties.value((String)"remoteConnectionsAllowed").observe((Object)this.model);
        ISWTObservableValue enableRemoteConnectionsButtonSelection = WidgetProperties.selection().observe((Widget)this.enableRemoteConnectionsButton);
        this.dbc.bindValue((IObservableValue)enableRemoteConnectionsButtonSelection, enableRemoteConnectionsObservable);
        return container;
    }
}

