/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.core.classpath;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.ws.core.JBossWSCorePlugin;
import org.jboss.tools.ws.core.classpath.JBossWSRuntime;
import org.jboss.tools.ws.core.classpath.JBossWSRuntimeListConverter;
import org.jboss.tools.ws.core.facet.delegate.IJBossWSFacetDataModelProperties;
import org.jboss.tools.ws.core.messages.JBossWSCoreMessages;

public class JBossWSRuntimeManager {
    private static JBossWSRuntimeListConverter converter = new JBossWSRuntimeListConverter();
    private Map<String, JBossWSRuntime> runtimes = new HashMap<String, JBossWSRuntime>();

    private JBossWSRuntimeManager() {
        this.load();
    }

    public static JBossWSRuntimeManager getInstance() {
        return JBossWSRuntimeManagerHolder.INSTANCE;
    }

    public JBossWSRuntime[] getRuntimes() {
        Collection<JBossWSRuntime> c = this.runtimes.values();
        return c.toArray(new JBossWSRuntime[this.runtimes.size()]);
    }

    public void addRuntime(JBossWSRuntime runtime) {
        JBossWSRuntime oldDefaultRuntime;
        if (this.runtimes.size() == 0) {
            runtime.setDefault(true);
        }
        if ((oldDefaultRuntime = this.getDefaultRuntime()) != null && runtime.isDefault()) {
            oldDefaultRuntime.setDefault(false);
        }
        this.runtimes.put(runtime.getName(), runtime);
        this.save();
    }

    public void addRuntime(String name, String path, String version, boolean defaultRt) {
        JBossWSRuntime jbossWSRt = new JBossWSRuntime();
        jbossWSRt.setHomeDir(path);
        jbossWSRt.setName(name);
        jbossWSRt.setVersion(version);
        jbossWSRt.setDefault(defaultRt);
        this.addRuntime(jbossWSRt);
    }

    public JBossWSRuntime findRuntimeByName(String name) {
        for (JBossWSRuntime jbossWSRuntime : this.runtimes.values()) {
            if (!jbossWSRuntime.getName().equals(name)) continue;
            return jbossWSRuntime;
        }
        return null;
    }

    public List<String> getAllRuntimeJars(JBossWSRuntime rt) {
        List<String> jarList = new ArrayList<String>();
        if (rt != null) {
            if (rt.isUserConfigClasspath()) {
                jarList.addAll(rt.getLibraries());
            } else {
                Path wsPath = new Path(rt.getHomeDir());
                if (wsPath != null) {
                    IPath libPath = wsPath.append(JBossWSCoreMessages.Dir_Lib);
                    List<File> libs = this.getJarsOfFolder(libPath.toFile());
                    libPath = wsPath.append(JBossWSCoreMessages.Dir_Client);
                    List<File> clientJars = this.getJarsOfFolder(libPath.toFile());
                    jarList = this.mergeTwoList(libs, clientJars);
                }
            }
        }
        return jarList;
    }

    private List<File> getJarsOfFolder(File folder) {
        ArrayList<File> jars = new ArrayList<File>();
        if (folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                    jars.add(file);
                } else if (folder.isDirectory()) {
                    jars.addAll(this.getJarsOfFolder(file));
                }
                ++n2;
            }
        }
        return jars;
    }

    private List<String> mergeTwoList(List<File> jarList1, List<File> jarList2) {
        ArrayList<String> rtList = new ArrayList<String>();
        ArrayList<String> distinctFileNames = new ArrayList<String>();
        for (File jarFile : jarList1) {
            distinctFileNames.add(jarFile.getName());
            rtList.add(jarFile.getAbsolutePath());
        }
        for (File jarFile : jarList2) {
            if (distinctFileNames.contains(jarFile.getName())) continue;
            rtList.add(jarFile.getAbsolutePath());
        }
        return rtList;
    }

    public void removeRuntime(JBossWSRuntime rt) {
        this.runtimes.remove(rt.getName());
    }

    public void save() {
        JBossWSCorePlugin.getDefault().getPreferenceStore().setValue(JBossWSCoreMessages.WS_Location, converter.getString(this.runtimes));
        IPreferenceStore store = JBossWSCorePlugin.getDefault().getPreferenceStore();
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDefaultRuntime(JBossWSRuntime runtime) {
        JBossWSRuntime[] runtimes = this.getRuntimes();
        int i = 0;
        while (i < runtimes.length) {
            runtimes[i].setDefault(false);
            ++i;
        }
        runtime.setDefault(true);
    }

    public JBossWSRuntime getDefaultRuntime() {
        for (JBossWSRuntime rt : this.runtimes.values()) {
            if (!rt.isDefault()) continue;
            return rt;
        }
        return null;
    }

    public List<String> getRuntimeNames() {
        JBossWSRuntime[] rts = this.getRuntimes();
        ArrayList<String> result = new ArrayList<String>();
        JBossWSRuntime[] jBossWSRuntimeArray = rts;
        int n = rts.length;
        int n2 = 0;
        while (n2 < n) {
            JBossWSRuntime jbossWSRuntime = jBossWSRuntimeArray[n2];
            result.add(jbossWSRuntime.getName());
            ++n2;
        }
        return result;
    }

    public List<String> getAllRuntimeNames() {
        JBossWSRuntime[] rts = this.getRuntimes();
        ArrayList<String> result = new ArrayList<String>();
        JBossWSRuntime[] jBossWSRuntimeArray = rts;
        int n = rts.length;
        int n2 = 0;
        while (n2 < n) {
            JBossWSRuntime jbossWSRuntime = jBossWSRuntimeArray[n2];
            result.add(jbossWSRuntime.getName());
            ++n2;
        }
        return result;
    }

    public void changeRuntimeName(String oldName, String newName) {
        JBossWSRuntime o = this.findRuntimeByName(oldName);
        if (o == null) {
            return;
        }
        o.setName(newName);
        this.onRuntimeNameChanged(oldName, newName);
    }

    private void onRuntimeNameChanged(String oldName, String newName) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jbossws.core");
        Set facetedProjects = null;
        try {
            facetedProjects = ProjectFacetsManager.getFacetedProjects((IProjectFacet)facet);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (IFacetedProject facetedProject : facetedProjects) {
            QualifiedName qRuntimeName = IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME;
            String name = null;
            try {
                name = facetedProject.getProject().getPersistentProperty(qRuntimeName);
                if (name == null || !name.equals(oldName)) continue;
                facetedProject.getProject().setPersistentProperty(qRuntimeName, newName);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isRuntimeUsed(String name) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jbossws.core");
        Set facetedProjects = null;
        try {
            facetedProjects = ProjectFacetsManager.getFacetedProjects((IProjectFacet)facet);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (IFacetedProject facetedProject : facetedProjects) {
            QualifiedName qRuntimeName = IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME;
            try {
                if (!name.equals(facetedProject.getProject().getPersistentProperty(qRuntimeName))) continue;
                return true;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void load() {
        IPreferenceStore ps = JBossWSCorePlugin.getDefault().getPreferenceStore();
        String runtimeListString = ps.getString(JBossWSCoreMessages.WS_Location);
        this.runtimes = converter.getMap(runtimeListString);
    }

    /* synthetic */ JBossWSRuntimeManager(JBossWSRuntimeManager jBossWSRuntimeManager) {
        this();
    }

    static class JBossWSRuntimeManagerHolder {
        private static final JBossWSRuntimeManager INSTANCE = new JBossWSRuntimeManager(null);

        JBossWSRuntimeManagerHolder() {
        }
    }
}

