/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.launch;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IUserPrompter;
import org.jboss.ide.eclipse.as.core.server.UserPrompter;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.FullPublishJobScheduler;

public class ServerHotCodeReplaceListener
implements IJavaHotCodeReplaceListener {
    public static final int EVENT_HCR_FAIL = 1013;
    public static final int EVENT_HCR_OBSOLETE = 1014;
    public static final String PROPERTY_HOTCODE_REPLACE_OVERRIDE = "org.jboss.ide.eclipse.as.wtp.core.server.launch.OverrideHotCodeReplace";
    public static final String PROPERTY_HOTCODE_BEHAVIOR = "org.jboss.ide.eclipse.as.wtp.core.server.launch.hotCodeReplace";
    public static final int PROMPT = 0;
    public static final int RESTART_MODULE = 1;
    public static final int RESTART_SERVER = 2;
    public static final int CONTINUE = 3;
    public static final int TERMINATE = 4;
    private IServer server;

    public ServerHotCodeReplaceListener(IServer server, ILaunch launch) {
        this.server = server;
    }

    public void hotCodeReplaceSucceeded(IJavaDebugTarget arg0) {
    }

    public void hotCodeReplaceFailed(IJavaDebugTarget target, DebugException exception) {
        this.hotCodeError(1013, target, (Exception)exception);
    }

    public void obsoleteMethods(IJavaDebugTarget target) {
        this.hotCodeError(1014, target, null);
    }

    protected void hotCodeError(int code, IJavaDebugTarget target, Exception exception) {
        Object result;
        int behavior = this.server.getAttribute(PROPERTY_HOTCODE_BEHAVIOR, 0);
        if (behavior == 0 && (result = this.getPrompter().promptUser(code, this.server, exception)) instanceof Integer) {
            behavior = (Integer)result;
        }
        if (behavior == 1) {
            this.restartModules();
        } else if (behavior == 2) {
            this.restartServer();
        } else if (behavior == 4) {
            this.server.stop(true);
        }
    }

    protected void restartModules() {
        new FullPublishJobScheduler(this.server, this.server.getModules()).schedule();
    }

    protected void restartServer() {
        this.server.restart(this.server.getMode(), new IServer.IOperationListener(){

            public void done(IStatus result) {
            }
        });
    }

    public IUserPrompter getPrompter() {
        return UserPrompter.getDefaultPrompter();
    }
}

