/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal.text;

import java.util.Hashtable;
import org.eclipse.sapphire.ui.forms.swt.internal.text.IHyperlinkSegment;
import org.eclipse.sapphire.ui.forms.swt.internal.text.SelectionData;
import org.eclipse.sapphire.ui.forms.swt.internal.text.TextSegment;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.forms.HyperlinkSettings;

public class TextHyperlinkSegment
extends TextSegment
implements IHyperlinkSegment {
    private String href;
    private String tooltipText;
    private HyperlinkSettings settings;

    public TextHyperlinkSegment(String text, HyperlinkSettings settings, String fontId) {
        super(text, fontId);
        this.settings = settings;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public void paint(GC gc, boolean hover, Hashtable resourceTable, boolean selected, SelectionData selData, Rectangle repaintRegion) {
        Color newFg;
        boolean rolloverMode = this.settings.getHyperlinkUnderlineMode() == 2;
        this.underline = this.settings.getHyperlinkUnderlineMode() == 3;
        Color savedFg = gc.getForeground();
        Color color = newFg = hover ? this.settings.getActiveForeground() : this.settings.getForeground();
        if (newFg != null) {
            gc.setForeground(newFg);
        }
        super.paint(gc, hover, resourceTable, selected, rolloverMode, selData, repaintRegion);
        gc.setForeground(savedFg);
    }

    @Override
    protected void drawText(GC gc, String s, int clipX, int clipY) {
        gc.drawText(s, clipX, clipY, true);
    }

    @Override
    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String tooltip) {
        this.tooltipText = tooltip;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isFocusSelectable(Hashtable resourceTable) {
        return true;
    }

    @Override
    public boolean setFocus(Hashtable resourceTable, boolean direction) {
        return true;
    }
}

