/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.jdt.integration.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.UserLibrary;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbLibFileSet;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNodeWithProperties;
import org.jboss.ide.eclipse.archives.jdt.integration.model.IArchiveLibFileSet;

public class ArchiveLibFileSetImpl
extends ArchiveNodeImpl
implements IArchiveLibFileSet {
    private IClasspathEntry[] entries = null;
    private DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] wrappers = null;

    public ArchiveLibFileSetImpl() {
        this(new XbLibFileSet());
    }

    public ArchiveLibFileSetImpl(XbLibFileSet delegate) {
        super((XbPackageNodeWithProperties)delegate);
    }

    public String getId() {
        return this.getFileSetDelegate().getId();
    }

    public void setId(String id) {
        this.getFileSetDelegate().setId(id);
        this.resetScanner();
    }

    public boolean matchesPath(IPath globalPath) {
        return this.matchesPath(globalPath, false);
    }

    public boolean matchesPath(IPath path, boolean inWorkspace) {
        return false;
    }

    public DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] getMatches(IPath path) {
        this.prime();
        ArrayList<DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper> temp = new ArrayList<DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper>();
        int i = 0;
        while (i < this.wrappers.length) {
            if (this.wrappers[i].getWrapperPath().equals((Object)path)) {
                temp.add(this.wrappers[i]);
            }
            ++i;
        }
        return temp.toArray(new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[temp.size()]);
    }

    public synchronized DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] findMatchingPaths() {
        this.prime();
        return this.wrappers == null ? new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[]{} : this.wrappers;
    }

    private synchronized void prime() {
        if (this.entries == null) {
            UserLibrary lib = JavaModelManager.getUserLibraryManager().getUserLibrary(this.getFileSetDelegate().getId());
            if (lib != null) {
                this.entries = lib.getEntries();
                ArrayList<DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper> list = new ArrayList<DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper>();
                int i = 0;
                while (i < this.entries.length) {
                    DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper fw = new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper(this.entries[i].getPath().toFile(), this.entries[i].getPath(), this.getRootArchiveRelativePath(), this.entries[i].getPath().lastSegment());
                    list.add(fw);
                    ++i;
                }
                this.wrappers = list.toArray(new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[list.size()]);
            } else {
                this.entries = new IClasspathEntry[0];
                this.wrappers = new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[0];
            }
        }
    }

    public int getNodeType() {
        return 2;
    }

    public IPath getRootArchiveRelativePath() {
        return this.getParent().getRootArchiveRelativePath();
    }

    public void resetScanner() {
        this.entries = null;
        this.wrappers = null;
    }

    public boolean validateModel() {
        return this.getAllChildren().length == 0;
    }

    public boolean canBuild() {
        return super.canBuild();
    }

    protected XbLibFileSet getFileSetDelegate() {
        return (XbLibFileSet)this.nodeDelegate;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{id=");
        sb.append(this.getFileSetDelegate().getId());
        return sb.toString();
    }
}

