/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.reporting;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.common.reporting.IProblemReporter;
import org.jboss.tools.common.reporting.ProblemBuffer;
import org.jboss.tools.common.reporting.ProblemReporterFactory;

public class ProblemReportingHelper {
    public static final ProblemBuffer buffer = new ProblemBuffer();

    public static void reportProblem(String plugin, Throwable throwable) {
        String message = throwable == null ? null : throwable.getLocalizedMessage();
        ProblemReportingHelper.reportProblem(plugin, message, throwable);
    }

    public static void reportProblem(String plugin, String message, Throwable throwable) {
        if (message == null) {
            throw new IllegalArgumentException("Message parameter cannot be null");
        }
        Status status = new Status(4, plugin, 0, message, throwable);
        ProblemReportingHelper.reportProblem((IStatus)status);
    }

    public static void reportProblem(IStatus status) {
        if (status == null) {
            ProblemReportingHelper.reportProblem("org.jboss.tools.common", new IllegalArgumentException("Parameter 'status' cannot be null"));
            return;
        }
        IProblemReporter reporter = ProblemReporterFactory.getInstance().getProblemReporter();
        reporter.reportProblem(status);
    }
}

