/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;
import org.eclipse.sapphire.modeling.xml.VirtualChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.services.PossibleTypesService;

public final class StandardImpliedXmlElementBindingImpl
extends ElementPropertyBinding {
    private XmlPath path;
    private Resource resource;

    public void init(Property property) {
        super.init(property);
        if (((PossibleTypesService)property.service(PossibleTypesService.class)).types().size() > 1) {
            throw new IllegalStateException();
        }
        String pathString = "";
        XmlElementBinding xmlElementBindingAnnotation = (XmlElementBinding)property.definition().getAnnotation(XmlElementBinding.class);
        if (xmlElementBindingAnnotation != null) {
            if (xmlElementBindingAnnotation.mappings().length > 0) {
                throw new IllegalStateException();
            }
            pathString = xmlElementBindingAnnotation.path();
        } else {
            XmlBinding xmlBindingAnnotation = (XmlBinding)property.definition().getAnnotation(XmlBinding.class);
            pathString = xmlBindingAnnotation != null ? xmlBindingAnnotation.path() : property.name();
        }
        this.path = new XmlPath(pathString, ((XmlResource)property.element().resource()).getXmlNamespaceResolver());
    }

    public ElementType type(Resource resource) {
        return this.property().definition().getType();
    }

    public Resource read() {
        if (this.resource == null) {
            XmlResource parentXmlResource = (XmlResource)this.property().element().resource();
            this.resource = new VirtualChildXmlResource(parentXmlResource, this.path);
        }
        return this.resource;
    }
}

