/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.validation;

import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.internal.ui.Trace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public abstract class AbstractValidator
implements IValidator,
ISourceValidator,
IValidatorJob {
    private IDocument fDocument;

    private void setDocument(IDocument doc) {
        this.fDocument = doc;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    public void connect(IDocument document) {
        this.setDocument(document);
    }

    public void disconnect(IDocument document) {
        this.setDocument(null);
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        IFile file;
        if (this.getDocument() == null) {
            return;
        }
        if (!(reporter instanceof IncrementalReporter)) {
            return;
        }
        if (!(this.getDocument() instanceof IStructuredDocument)) {
            return;
        }
        reporter.removeAllMessages((IValidator)this);
        String[] delta = helper.getURIs();
        if (delta.length > 0 && (file = this.getFile(delta[0])) != null && AngularProject.hasAngularNature((IProject)file.getProject())) {
            IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions();
            this.validate(reporter, file, regions);
        }
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        IFile file;
        if (this.getDocument() == null) {
            return;
        }
        if (!(reporter instanceof IncrementalReporter)) {
            return;
        }
        if (!(this.getDocument() instanceof IStructuredDocument)) {
            return;
        }
        reporter.removeAllMessages((IValidator)this);
        String[] delta = helper.getURIs();
        if (delta.length > 0 && (file = this.getFile(delta[0])) != null && AngularProject.hasAngularNature((IProject)file.getProject())) {
            IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
            this.validate(reporter, file, regions);
        }
    }

    private void validate(IReporter reporter, IFile file, IStructuredDocumentRegion[] regions) {
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                if (model == null) {
                    model = StructuredModelManager.getModelManager().getModelForRead(file);
                }
                if (model != null) {
                    int i = 0;
                    while (i < regions.length) {
                        this.validate(regions[i], reporter, file, model);
                        ++i;
                    }
                }
            }
            catch (Throwable e) {
                Trace.trace((byte)3, e.getMessage(), e);
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private void validate(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter, IFile file, IStructuredModel model) {
        if (structuredDocumentRegion == null) {
            return;
        }
        this.doValidate(structuredDocumentRegion, reporter, file, model);
    }

    protected abstract void doValidate(IStructuredDocumentRegion var1, IReporter var2, IFile var3, IStructuredModel var4);

    private IFile getFile(String delta) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(delta));
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        IStatus status = Status.OK_STATUS;
        try {
            this.validate(helper, reporter);
        }
        catch (ValidationException e) {
            Trace.trace((byte)3, "Error while angular validation", e);
            status = new Status(4, "org.eclipse.angularjs.core", 4, e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }
}

