/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.layer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.meta.action.impl.XActionImpl;
import org.jboss.tools.common.meta.action.impl.XActionListImpl;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.layer.VEntityImpl;
import org.jboss.tools.common.verification.vrules.layer.VObjectImpl;

public class VModelImpl
implements VModel {
    private XModel model;
    XModelMetaData meta;
    private IProject project;
    private Map<String, VEntity> entities;
    private static XActionItem.Acceptor acceptor1 = new XActionItem.Acceptor(){

        public boolean accepts(XActionItem item) {
            return item.getName().charAt(0) != '[';
        }
    };

    public VModelImpl(XModel model) {
        this.model = model;
        this.meta = model.getMetaData();
        this.project = (IProject)model.getProperties().get("project");
        this.entities = new HashMap<String, VEntity>();
    }

    public boolean isMain() {
        return this.project == null;
    }

    @Override
    public Object getManagerKey() {
        return this.model;
    }

    @Override
    public VEntity getEntity(String name) {
        VEntity entity = this.entities.get(name);
        if (entity == null) {
            entity = new VEntityImpl(this.meta, name, this);
            this.entities.put(name, entity);
        }
        return entity;
    }

    @Override
    public VObject getObjectByPath(String path) {
        XModelObject o = this.model.getByPath(path);
        return o == null ? null : new VObjectImpl(o, this);
    }

    @Override
    public VObject[] getRootObjects() {
        return new VObject[]{new VObjectImpl(this.model.getRoot(), this)};
    }

    public XActionListImpl createGlobalActionList(XModelEntity entity) {
        XActionList global = (XActionList)this.model.getMetaData().getGlobalActions().getItem("VerifyActions");
        XActionListImpl entityActions = (XActionListImpl)entity.getActionList();
        XActionListImpl verifyActions = (XActionListImpl)entityActions.getItem("VerifyActions");
        if (verifyActions == null) {
            verifyActions = (XActionListImpl)global.copy(acceptor1);
            entityActions.addActionItem((XActionItem)verifyActions);
        }
        return verifyActions;
    }

    public XActionListImpl getGlobalActionList(XModelEntity entity) {
        XActionListImpl verifyActions = (XActionListImpl)entity.getActionList().getItem("VerifyActions");
        return verifyActions;
    }

    public XActionListImpl createRuleSetActionList(XModelEntity entity, VRuleSet ruleSet) {
        this.createGlobalActionList(entity);
        return null;
    }

    public void createRuleAction(XModelEntity entity, VRule rule) {
        this.createRuleSetActionList(entity, rule.getRuleSet());
    }

    public void createRuleActionInh(XModelEntity entity, VRule rule) {
        this.createRuleAction(entity, rule);
        Iterator ancestors = this.getAncestors(entity.getName()).iterator();
        while (ancestors.hasNext()) {
            String n = ancestors.next().toString();
            XModelEntity ent = this.model.getMetaData().getEntity(n);
            if (ent == null) continue;
            this.createRuleAction(ent, rule);
        }
    }

    private Set getAncestors(String name) {
        return this.model.getMetaData().getParentInfo().getAncestors(name);
    }

    public XActionListImpl getRuleSetActionList(XModelEntity entity, String ruleSetName) {
        XActionListImpl verifyActions = this.getGlobalActionList(entity);
        if (verifyActions == null) {
            return null;
        }
        XActionListImpl dynamicList = (XActionListImpl)verifyActions.getItem("DynamicActions");
        XActionListImpl ruleSetList = (XActionListImpl)dynamicList.getItem(ruleSetName);
        return ruleSetList;
    }

    public void updateRuleSetActionList(VRuleSet ruleSet, String oldName) {
    }

    public void removeRuleSetActionList(VRuleSet ruleSet) {
    }

    public void removeRuleSetActionList(XModelEntity entity, VRuleSet ruleSet) {
    }

    public XActionImpl getRuleAction(XModelEntity entity, String ruleSetName, String ruleName) {
        XActionListImpl ruleSetList = this.getRuleSetActionList(entity, ruleSetName);
        if (ruleSetList == null) {
            return null;
        }
        XActionListImpl dynamicList2 = (XActionListImpl)ruleSetList.getItem("DynamicActions");
        XActionImpl ruleAction = (XActionImpl)dynamicList2.getItem(ruleName);
        return ruleAction;
    }

    public void updateRuleAction(VRule rule, String oldName) {
    }

    public void removeRuleAction(VRule rule) {
    }

    public void removeRuleAction(XModelEntity entity, VRule rule) {
    }

    public void removeRuleActionInh(XModelEntity entity, VRule rule) {
    }

    @Override
    public IType getValidType(String className) {
        if (this.project == null) {
            return null;
        }
        IType type = EclipseResourceUtil.getValidType((IProject)this.project, (String)className);
        if (type != null) {
            return type;
        }
        if (EclipseResourceUtil.isContainedInOutput((IProject)this.project, (String)className)) {
            return EclipseResourceUtil.getValidType((IProject)this.project, (String)"java.lang.Class");
        }
        return null;
    }
}

