/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.jboss.tools.common.validation.CommonValidationPlugin;
import org.osgi.framework.Bundle;

public abstract class AbstractTemporaryAnnotation
extends Annotation
implements IAnnotationPresentation {
    private static final int WARNING_LAYER;
    private static final int ERROR_LAYER;
    private String problemType;
    private Map<String, Object> fAttributes = new HashMap<String, Object>();
    private int seveirty = WARNING_LAYER;

    static {
        AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
        WARNING_LAYER = AbstractTemporaryAnnotation.computeLayer("org.eclipse.wst.sse.ui.temp.warning", lookup);
        ERROR_LAYER = AbstractTemporaryAnnotation.computeLayer("org.eclipse.wst.sse.ui.temp.error", lookup);
    }

    private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
        Annotation annotation = new Annotation(annotationType, false, null);
        AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
        if (preference != null) {
            return preference.getPresentationLayer() + 1;
        }
        return 1;
    }

    public AbstractTemporaryAnnotation(String type, String problemType, boolean isPersistent, String text, boolean warning) {
        super(type, isPersistent, text);
        this.setProblemType(problemType);
        this.seveirty = warning ? WARNING_LAYER : ERROR_LAYER;
    }

    public int getLayer() {
        return 0;
    }

    protected abstract String getWarningIconPath();

    protected abstract String getErrorIconPath();

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        String path = this.seveirty == WARNING_LAYER ? this.getWarningIconPath() : this.getErrorIconPath();
        Image image = CommonValidationPlugin.getDefault().getWorkbench().getSharedImages().getImage(path);
        if (image == null || image.isDisposed()) {
            URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.ui.ide"), (IPath)new Path(path), null);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
            WorkbenchImages.declareImage((String)path, (ImageDescriptor)descriptor, (boolean)true);
            image = CommonValidationPlugin.getDefault().getWorkbench().getSharedImages().getImage(path);
        }
        ImageUtilities.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000, (int)128);
    }

    public Object getAttribute(String key) {
        return this.fAttributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.fAttributes.put(key, value);
    }

    public String getProblemType() {
        return this.problemType;
    }

    public void setProblemType(String problemType) {
        this.problemType = problemType;
    }
}

