/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core.tree;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.JMXActivator;
import org.jboss.tools.jmx.core.tree.DomainNode;
import org.jboss.tools.jmx.core.tree.MBeansNode;
import org.jboss.tools.jmx.core.tree.Node;

public class Root
extends Node {
    private IConnectionWrapper connection;
    private MBeansNode mbeansNode;

    public Root(IConnectionWrapper connection) {
        super(null);
        this.connection = connection;
        this.mbeansNode = new MBeansNode(this);
        this.addChild(this.mbeansNode);
    }

    public String toString() {
        return this.connection != null ? this.connection.toString() : "Root";
    }

    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public IConnectionWrapper getConnection() {
        return this.connection;
    }

    public boolean containsDomain(String domain) {
        return this.getDomainNode(domain) != null;
    }

    public DomainNode getDomainNode(String domain) {
        Node[] nodes;
        Node[] nodeArray = nodes = this.mbeansNode.getChildren();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            DomainNode domainNode;
            Node node = nodeArray[n2];
            if (node instanceof DomainNode && domain.equals((domainNode = (DomainNode)node).getDomain())) {
                return domainNode;
            }
            ++n2;
        }
        return null;
    }

    public void refresh() {
        IConnectionWrapper wrapper = this.connection;
        if (wrapper != null) {
            try {
                wrapper.disconnect();
                wrapper.connect();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public MBeansNode getMBeansNode() {
        return this.mbeansNode;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public void connect() {
        if (this.connection != null) {
            try {
                this.connection.connect();
            }
            catch (Exception e) {
                Status status = new Status(2, "org.jboss.tools.jmx.core", "Failed to connect to " + this.connection + ". " + e, (Throwable)e);
                JMXActivator.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

