/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core.link;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.core.link.AngularLink;
import org.eclipse.angularjs.core.link.AngularLinkHelper;
import org.eclipse.angularjs.core.utils.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import tern.eclipse.ide.core.IIDETernProject;
import tern.scriptpath.ITernScriptPath;

public class AngularLinkResource {
    private static final String SEPARATOR = ";";
    private List<AngularLink> elementLinks;
    private AngularLink resourceLink;
    private final IResource resource;

    public AngularLinkResource(IResource resource, String resourceInfo) throws CoreException {
        this.resource = resource;
        if (resourceInfo != null) {
            String[] infos = resourceInfo.split(SEPARATOR);
            ITernScriptPath scriptPath = null;
            String module = null;
            String controller = null;
            String elementId = null;
            IIDETernProject ternProject = AngularProject.getTernProject(resource.getProject());
            int i = 0;
            while (i < infos.length) {
                switch (i % 4) {
                    case 0: {
                        scriptPath = ternProject.getScriptPath(infos[i]);
                        break;
                    }
                    case 1: {
                        module = infos[i].trim();
                        break;
                    }
                    case 2: {
                        controller = infos[i].trim();
                        break;
                    }
                    case 3: {
                        elementId = infos[i].trim();
                        this.addLink(scriptPath, module, controller, elementId);
                    }
                }
                ++i;
            }
        }
    }

    public void addLink(ITernScriptPath scriptPath, String module, String controller, String elementId) {
        if (scriptPath == null) {
            return;
        }
        if (!StringUtils.isEmpty(elementId)) {
            if (this.elementLinks == null) {
                this.elementLinks = new ArrayList<AngularLink>();
            }
            this.elementLinks.add(new AngularLink(elementId, scriptPath, module, controller));
        } else {
            this.resourceLink = new AngularLink(elementId, scriptPath, module, controller);
        }
    }

    public IResource getResource() {
        return this.resource;
    }

    public AngularLink getResourceLink() {
        return this.resourceLink;
    }

    public List<AngularLink> getElementLinks() {
        return this.elementLinks;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.resourceLink != null) {
            this.write(this.resourceLink, s);
        }
        if (this.elementLinks != null) {
            for (AngularLink link : this.elementLinks) {
                this.write(link, s);
            }
        }
        return s.toString();
    }

    private void write(AngularLink link, StringBuilder s) {
        s.append(link.getScriptPath().getPath());
        s.append(SEPARATOR);
        this.write(link.getModule(), s);
        s.append(SEPARATOR);
        this.write(link.getController(), s);
        s.append(SEPARATOR);
        this.write(link.getElementId(), s);
    }

    private void write(String value, StringBuilder s) {
        if (StringUtils.isEmpty(value)) {
            s.append(" ");
        } else {
            s.append(value);
        }
    }

    public void save() throws CoreException {
        this.resource.setPersistentProperty(AngularLinkHelper.CONTROLLER_INFO, this.toString());
        this.resource.setSessionProperty(AngularLinkHelper.CONTROLLER_INFO, (Object)this);
    }
}

