/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimePathChangeListener;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.core.util.RuntimePathPreferenceIO;

public class RuntimeModel {
    public static final String RUNTIME_PATHS = "runtimePaths";
    private ListenerList runtimePathChangeChangeListeners;
    private Set<RuntimePath> runtimePaths;
    private IEclipsePreferences preferences;

    public RuntimeModel() {
        this.runtimePaths = new HashSet<RuntimePath>();
    }

    public RuntimeModel(IEclipsePreferences preferences) {
        this.preferences = preferences;
        this.reloadRuntimePathsFromPreferences();
    }

    public void reloadRuntimePathsFromPreferences() {
        String runtimes = this.preferences.get(RUNTIME_PATHS, null);
        this.runtimePaths = runtimes != null && !runtimes.isEmpty() ? RuntimePathPreferenceIO.loadRuntimePathsFromPreferenceString(runtimes) : new HashSet<RuntimePath>();
        this.fireRuntimePathsChanged();
    }

    public void saveRuntimePaths() {
        if (this.runtimePaths == null || this.preferences == null) {
            return;
        }
        try {
            String runtimes = RuntimePathPreferenceIO.getPreferenceOutputString(this.runtimePaths);
            this.preferences.put(RUNTIME_PATHS, runtimes);
            this.preferences.flush();
            this.fireRuntimePathsChanged();
        }
        catch (Exception e) {
            RuntimeCoreActivator.pluginLog().logError((Throwable)e);
        }
    }

    public synchronized void setRuntimePaths(RuntimePath[] set) {
        if (set == null) {
            this.reloadRuntimePathsFromPreferences();
        } else {
            HashSet<RuntimePath> s = new HashSet<RuntimePath>();
            s.addAll(Arrays.asList(set));
            this.runtimePaths = s;
            this.saveRuntimePaths();
        }
    }

    public void addRuntimePath(RuntimePath path) {
        this.runtimePaths.add(path);
        this.saveRuntimePaths();
    }

    public void removeRuntimePath(RuntimePath path) {
        this.runtimePaths.remove(path);
        this.saveRuntimePaths();
    }

    public synchronized RuntimePath[] getRuntimePaths() {
        return this.runtimePaths.toArray(new RuntimePath[this.runtimePaths.size()]);
    }

    public synchronized void addRuntimePathChangeListener(IRuntimePathChangeListener listener) {
        if (this.runtimePathChangeChangeListeners == null) {
            this.runtimePathChangeChangeListeners = new ListenerList();
        }
        this.runtimePathChangeChangeListeners.add((Object)listener);
    }

    public synchronized void removeRuntimePathChangeListener(IRuntimePathChangeListener listener) {
        if (this.runtimePathChangeChangeListeners == null) {
            return;
        }
        this.runtimePathChangeChangeListeners.remove((Object)listener);
    }

    private void fireRuntimePathsChanged() {
        if (this.runtimePathChangeChangeListeners != null) {
            Object[] listeners;
            Object[] objectArray = listeners = this.runtimePathChangeChangeListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                IRuntimePathChangeListener runtimePathChangeChangeListener = (IRuntimePathChangeListener)listener;
                runtimePathChangeChangeListener.changed();
                ++n2;
            }
        }
    }
}

