/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.extract.internal.xpl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import org.jboss.tools.runtime.core.extract.internal.xpl.TarEntry;
import org.jboss.tools.runtime.core.extract.internal.xpl.TarException;
import org.jboss.tools.runtime.core.extract.internal.xpl.TarInputStream;

public class TarFile {
    private File file;
    protected TarInputStream entryEnumerationStream;
    protected TarEntry curEntry;
    private TarInputStream entryStream;

    public TarFile(File file) throws TarException, IOException {
        this.file = file;
        InputStream in = new FileInputStream(file);
        try {
            in = new GZIPInputStream(in);
        }
        catch (IOException iOException) {
            ((InputStream)in).close();
            in = new FileInputStream(file);
        }
        this.entryEnumerationStream = new TarInputStream(in);
        this.curEntry = this.entryEnumerationStream.getNextEntry();
    }

    public void close() throws IOException {
        this.entryEnumerationStream.close();
    }

    public TarFile(String filename) throws TarException, IOException {
        this(new File(filename));
    }

    public Enumeration entries() {
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return TarFile.this.curEntry != null;
            }

            public Object nextElement() {
                TarEntry oldEntry = TarFile.this.curEntry;
                try {
                    TarFile.this.curEntry = TarFile.this.entryEnumerationStream.getNextEntry();
                }
                catch (TarException tarException) {
                    TarFile.this.curEntry = null;
                }
                catch (IOException iOException) {
                    TarFile.this.curEntry = null;
                }
                return oldEntry;
            }
        };
    }

    public InputStream getInputStream(TarEntry entry) throws TarException, IOException {
        if (this.entryStream == null || !this.entryStream.skipToEntry(entry)) {
            InputStream in = new FileInputStream(this.file);
            try {
                in = new GZIPInputStream(in);
            }
            catch (IOException iOException) {
                in = new FileInputStream(this.file);
            }
            this.entryStream = new TarInputStream(in, entry){

                @Override
                public void close() {
                }
            };
        }
        if (this.entryStream == null) {
            System.out.println("huh?");
        }
        return this.entryStream;
    }

    public String getName() {
        return this.file.getPath();
    }
}

