/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.parser.token;

import org.jboss.tools.common.el.core.parser.Tokenizer;
import org.jboss.tools.common.el.internal.core.parser.token.ConstantTokenDescription;

public class UnaryTokenDescription
extends ConstantTokenDescription {
    public static final int UNARY = 15;
    public static UnaryTokenDescription INSTANCE = new UnaryTokenDescription();
    private static final String[] OPS_2 = new String[]{"not", "empty"};

    public UnaryTokenDescription() {
        super("!", 15);
        this.addContent("--");
        this.addContent("++");
        this.addContent("+");
        this.addContent("-");
    }

    @Override
    public boolean isStart(Tokenizer tokenizer, int offset) {
        if (super.isStart(tokenizer, offset)) {
            return true;
        }
        int end = -1;
        int i = 0;
        while (end < 0 && i < OPS_2.length) {
            if (tokenizer.startsWith(OPS_2[i])) {
                end = offset + OPS_2[i].length();
            }
            ++i;
        }
        if (end < 0) {
            return false;
        }
        char ch = tokenizer.lookUpChar(end);
        return Character.isWhitespace(ch) || ch == '\u0000' || ch == '(' || !Character.isJavaIdentifierPart(ch);
    }

    @Override
    public boolean read(Tokenizer tokenizer, int offset) {
        if (super.isStart(tokenizer, offset)) {
            return super.read(tokenizer, offset);
        }
        int end = -1;
        int i = 0;
        while (end < 0 && i < OPS_2.length) {
            if (tokenizer.startsWith(OPS_2[i])) {
                end = offset + OPS_2[i].length();
            }
            ++i;
        }
        tokenizer.addToken(this.getType(), offset, end);
        return true;
    }
}

