/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.resolver.SimpleELContext;
import org.jboss.tools.common.el.core.resolver.Var;

public class ELContextImpl
extends SimpleELContext {
    static List<Var> EMPTY = Collections.emptyList();
    protected List<Var> allVars = new ArrayList<Var>();
    protected ELReference[] elReferences;
    protected List<ELReference> elReferenceSet;

    @Override
    public synchronized Var[] getVars() {
        List<Var> external = this.getExternalVars();
        if (external.isEmpty()) {
            return this.allVars.toArray(new Var[this.allVars.size()]);
        }
        if (this.allVars.isEmpty()) {
            return external.toArray(new Var[this.allVars.size()]);
        }
        ArrayList<Var> result = new ArrayList<Var>();
        result.addAll(this.allVars);
        result.addAll(external);
        return result.toArray(new Var[this.allVars.size()]);
    }

    public List<Var> getExternalVars() {
        return EMPTY;
    }

    public synchronized void addVar(Region region, Var var) {
        var.setRegion(region);
        this.allVars.add(var);
    }

    @Override
    public synchronized Var[] getVars(int offset) {
        if (offset < 0) {
            return this.getVars();
        }
        ArrayList<Var> result = new ArrayList<Var>();
        for (Var var : this.allVars) {
            Region region = var.getRegion();
            if (offset < region.getOffset() || offset > region.getOffset() + region.getLength()) continue;
            result.add(var);
        }
        List<Var> external = this.getExternalVars();
        if (!external.isEmpty()) {
            result.addAll(external);
        }
        return result.toArray(new Var[result.size()]);
    }

    public List<Var> getAllVars() {
        return this.allVars;
    }

    public void setAllVars(List<Var> allVars) {
        this.allVars = allVars;
    }

    @Override
    public synchronized ELReference[] getELReferences() {
        if (this.elReferences == null) {
            if (this.elReferenceSet == null || this.elReferenceSet.isEmpty()) {
                return EMPTY_ARRAY;
            }
            this.elReferences = this.elReferenceSet.toArray(new ELReference[0]);
        }
        return this.elReferences;
    }

    public synchronized void addELReference(ELReference reference) {
        if (this.elReferenceSet == null) {
            this.elReferenceSet = new ArrayList<ELReference>();
        }
        this.elReferenceSet.add(reference);
        this.elReferences = null;
    }

    @Override
    public synchronized ELReference getELReference(int offset) {
        if (this.elReferenceSet != null) {
            for (ELReference ref : this.elReferenceSet) {
                if (ref.getStartPosition() > offset || ref.getStartPosition() + ref.getLength() <= offset) continue;
                return ref;
            }
        }
        return null;
    }

    @Override
    public synchronized Collection<ELReference> getELReferences(IRegion region) {
        ArrayList<ELReference> references = new ArrayList<ELReference>();
        if (this.elReferenceSet != null) {
            for (ELReference ref : this.elReferenceSet) {
                if (region.getOffset() + region.getLength() < ref.getStartPosition() || region.getOffset() > ref.getStartPosition() + ref.getLength()) continue;
                references.add(ref);
            }
        }
        return references;
    }
}

