/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.descriptors;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.controls.TernModuleOptionsPanel;
import tern.eclipse.ide.internal.ui.descriptors.TernModuleImage;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.descriptors.ITernModuleDescriptorManager;
import tern.eclipse.ide.ui.descriptors.ITernModuleImage;
import tern.eclipse.ide.ui.descriptors.options.ITernModuleOptionFactory;
import tern.eclipse.jface.TernImagesRegistry;
import tern.server.ITernModule;
import tern.server.protocol.completions.TernCompletionItem;
import tern.utils.StringUtils;

public class TernModuleDescriptorManager
implements ITernModuleDescriptorManager,
IRegistryChangeListener {
    private static final String EXTENSION_TERN_MODULE_DESCRIPTORS = "ternModuleDescriptors";
    private static final TernModuleDescriptorManager INSTANCE = new TernModuleDescriptorManager();
    private static final String IMAGE_DIR = "tern-images";
    private Map<String, ITernModuleImage> ternModuleImages;
    private Map<String, ITernModuleOptionFactory> ternModuleOptionFactories;
    private boolean registryListenerIntialized = false;
    private HashMap<ImageDescriptor, URL> fURLMap = new HashMap();
    private final File fTempDir = this.getTempDir();
    private int fImageCount = 0;

    public static TernModuleDescriptorManager getManager() {
        return INSTANCE;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.ui", EXTENSION_TERN_MODULE_DESCRIPTORS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleTernDescriptorDelta(delta);
                ++n2;
            }
        }
    }

    @Override
    public Image getImage(String id) {
        ITernModuleImage descriptor = this.getTernModuleImage(id);
        if (descriptor != null) {
            return descriptor.getImage();
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(String id) {
        ITernModuleImage descriptor = this.getTernModuleImage(id);
        if (descriptor != null) {
            return descriptor.getImageDescriptor();
        }
        return null;
    }

    @Override
    public Composite createOptionsPanel(Composite parent, ITernModule module, IProject project) {
        return new TernModuleOptionsPanel(parent, module, project);
    }

    @Override
    public ITernModuleImage getTernModuleImage(String id) {
        if (this.ternModuleImages == null) {
            this.loadTernDescriptors();
        }
        return this.ternModuleImages.get(id);
    }

    @Override
    public ITernModuleOptionFactory getTernModuleOptionFactory(String id) {
        if (this.ternModuleOptionFactories == null) {
            this.loadTernDescriptors();
        }
        return this.ternModuleOptionFactories.get(id);
    }

    private synchronized void loadTernDescriptors() {
        if (this.ternModuleImages != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .ternModuleDescriptors extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.ui", EXTENSION_TERN_MODULE_DESCRIPTORS);
        HashMap<String, ITernModuleOptionFactory> optionFactories = new HashMap<String, ITernModuleOptionFactory>();
        HashMap<String, ITernModuleImage> images = new HashMap<String, ITernModuleImage>();
        this.addTernDescriptors(cf, images, optionFactories);
        this.addRegistryListenerIfNeeded();
        this.ternModuleImages = images;
        this.ternModuleOptionFactories = optionFactories;
        Trace.trace((byte)7, "-<- Done loading .ternModuleDescriptors extension point -<-");
    }

    private synchronized void addTernDescriptors(IConfigurationElement[] cf, Map<String, ITernModuleImage> images, Map<String, ITernModuleOptionFactory> optionFactories) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                if ("optionFactory".equals(ce.getName())) {
                    String id = ce.getAttribute("id");
                    ITernModuleOptionFactory factory = (ITernModuleOptionFactory)ce.createExecutableExtension("class");
                    optionFactories.put(id, factory);
                } else if ("image".equals(ce.getName())) {
                    TernModuleImage ternDescriptor = new TernModuleImage(ce);
                    images.put(ternDescriptor.getId(), ternDescriptor);
                }
                Trace.trace((byte)7, "  Loaded ternDescriptor: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load ternDescriptor: " + ce.getAttribute("id"), t);
            }
            ++n2;
        }
    }

    protected void handleTernDescriptorDelta(IExtensionDelta delta) {
        if (this.ternModuleImages == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        HashMap<String, ITernModuleOptionFactory> optionFactories = new HashMap<String, ITernModuleOptionFactory>();
        HashMap<String, ITernModuleImage> images = new HashMap<String, ITernModuleImage>();
        if (delta.getKind() == 1) {
            this.addTernDescriptors(cf, images, optionFactories);
        }
        this.ternModuleImages = images;
        this.ternModuleOptionFactories = optionFactories;
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.ui");
        this.registryListenerIntialized = true;
    }

    public void initialize() {
    }

    @Override
    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        if (this.fTempDir != null) {
            this.delete(this.fTempDir);
        }
        this.fURLMap = null;
    }

    @Override
    public Image getImage(TernCompletionItem item) {
        Image image = TernImagesRegistry.getImage((TernCompletionItem)item, (boolean)true);
        if (image != null) {
            return image;
        }
        String origin = item.getOrigin();
        if (!StringUtils.isEmpty((String)origin)) {
            image = this.getImage(origin);
        }
        return image != null ? image : TernImagesRegistry.getImage((String)"tern.eclipse.jface.IMG_UNKNOWN");
    }

    @Override
    public ImageDescriptor getImageDescriptor(TernCompletionItem item) {
        ImageDescriptor descriptor = TernImagesRegistry.getImageDescriptor((TernCompletionItem)item, (boolean)true);
        if (descriptor != null) {
            return descriptor;
        }
        String origin = item.getOrigin();
        if (!StringUtils.isEmpty((String)origin)) {
            descriptor = this.getImageDescriptor(origin);
        }
        return descriptor != null ? descriptor : TernImagesRegistry.getImageDescriptor((String)"tern.eclipse.jface.IMG_UNKNOWN");
    }

    private File getTempDir() {
        File imageDir;
        block5: {
            try {
                imageDir = TernUIPlugin.getDefault().getStateLocation().append(IMAGE_DIR).toFile();
                if (imageDir.exists()) {
                    this.delete(imageDir);
                }
                if (!imageDir.exists()) {
                    imageDir.mkdir();
                }
                if (imageDir.isDirectory()) break block5;
                Trace.trace((byte)3, "Failed to create image directory " + imageDir.toString());
                return null;
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }
        return imageDir;
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            int i = 0;
            while (i < listFiles.length) {
                this.delete(listFiles[i]);
                ++i;
            }
        }
        file.delete();
    }

    @Override
    public URL getImageURL(ImageDescriptor descriptor) {
        if (this.fTempDir == null) {
            return null;
        }
        URL url = this.fURLMap.get(descriptor);
        if (url != null) {
            return url;
        }
        File imageFile = this.getNewFile();
        ImageData imageData = descriptor.getImageData();
        if (imageData == null) {
            return null;
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        loader.save(imageFile.getAbsolutePath(), 5);
        try {
            url = imageFile.toURI().toURL();
            this.fURLMap.put(descriptor, url);
            return url;
        }
        catch (MalformedURLException e) {
            Trace.trace((byte)3, "Failed to create image directory ", e);
            return null;
        }
    }

    private File getNewFile() {
        File file;
        while ((file = new File(this.fTempDir, String.valueOf(String.valueOf(this.getImageCount())) + ".png")).exists()) {
        }
        return file;
    }

    private synchronized int getImageCount() {
        return this.fImageCount++;
    }
}

