/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.forge.arquillian.container.Container;
import org.jboss.forge.arquillian.container.Dependency;
import org.jboss.tools.arquillian.core.internal.container.ContainerParser;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.refactoring.RangeComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddProfilesRefactoring
extends Refactoring {
    private IProject project;
    private List<String> profiles;

    public AddProfilesRefactoring(IProject project, List<String> profiles) {
        this.project = project;
        this.profiles = profiles;
    }

    public String getName() {
        return "Add Arquillian profiles";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean isMavenProject;
        boolean bl = isMavenProject = this.project != null && this.project.hasNature("org.eclipse.m2e.core.maven2Nature");
        if (!isMavenProject) {
            Status status = new Status(4, "org.jboss.tools.arquillian.ui", "The project is not a valid maven project");
            return RefactoringStatus.create((IStatus)status);
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = this.checkInitialConditions(pm);
        if (!status.isOK()) {
            return status;
        }
        IFile file = this.getFile();
        if (file == null || !file.exists()) {
            Status s = new Status(4, "org.jboss.tools.arquillian.ui", "The pom.xml file does not exist");
            return RefactoringStatus.create((IStatus)s);
        }
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(this.project, (IProgressMonitor)new NullProgressMonitor());
        if (facade == null) {
            Status s = new Status(4, "org.jboss.tools.arquillian.ui", "The project is not a valid maven project");
            return RefactoringStatus.create((IStatus)s);
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IFile file = this.getFile();
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(this.project, (IProgressMonitor)new NullProgressMonitor());
        MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
        ArrayList<AddProfiles> operations = new ArrayList<AddProfiles>();
        if (this.profiles != null) {
            operations.add(new AddProfiles(mavenProject, this.profiles));
        }
        PomEdits.CompoundOperation compound = new PomEdits.CompoundOperation(operations.toArray(new PomEdits.Operation[0]));
        return this.createChange(file, (PomEdits.Operation)compound, this.getName());
    }

    private Change createChange(IFile file, PomEdits.Operation operation, String label) throws CoreException {
        IStructuredModel model = null;
        try {
            TextChange change;
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            IStructuredDocument document = model.getStructuredDocument();
            boolean existing = AddProfilesRefactoring.isOpened((IDocument)document);
            IStructuredModel tempModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor("org.eclipse.m2e.core.pomFile");
            tempModel.getStructuredDocument().setText((Object)StructuredModelManager.getModelManager(), document.get());
            IStructuredDocument tempDocument = tempModel.getStructuredDocument();
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple((IDOMModel)tempModel, operation)});
            TextChange textChange = change = this.createChange(existing ? null : file, (IDocument)document, (IDocument)tempDocument, label);
            return textChange;
        }
        catch (Exception e) {
            ArquillianUIActivator.log(e);
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.arquillian.ui", "An error occurred creating change", (Throwable)e));
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private TextChange createChange(IFile oldFile, IDocument oldDocument, IDocument newDocument, String label) {
        DocumentChange change = oldFile == null ? new DocumentChange(label, oldDocument) : new TextFileChange(label, oldFile);
        MultiTextEdit textEdit = new MultiTextEdit();
        change.setEdit((TextEdit)textEdit);
        String newText = newDocument.get();
        String oldText = oldDocument.get();
        if (!newText.equals(oldText)) {
            RangeDifference[] differences;
            RangeComparator right = new RangeComparator(oldText);
            RangeComparator left = new RangeComparator(newText);
            RangeDifference[] rangeDifferenceArray = differences = RangeDifferencer.findDifferences((IRangeComparator)right, (IRangeComparator)left);
            int n = differences.length;
            int n2 = 0;
            while (n2 < n) {
                RangeDifference difference = rangeDifferenceArray[n2];
                int rightStart = difference.rightStart();
                int rightEnd = difference.rightEnd();
                String text = newText.substring(rightStart, rightEnd);
                int leftStart = difference.leftStart();
                int leftLength = difference.leftLength();
                textEdit.addChild((TextEdit)new ReplaceEdit(leftStart, leftLength, text));
                ++n2;
            }
        }
        return change;
    }

    private static boolean isOpened(IDocument document) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IDocument doc;
                    IEditorReference ref = iEditorReferenceArray[n6];
                    IEditorPart editor = ref.getEditor(false);
                    if (editor != null && (doc = (IDocument)editor.getAdapter(IDocument.class)) != null && doc.equals(document)) {
                        return true;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private IFile getFile() throws CoreException {
        if (this.project == null || !this.project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            return null;
        }
        return this.project.getFile("pom.xml");
    }

    public IProject getProject() {
        return this.project;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<String> profiles) {
        this.profiles = profiles;
    }

    private static class AddProfiles
    implements PomEdits.Operation {
        private MavenProject mavenProject;
        private List<String> profiles;

        public AddProfiles(MavenProject mavenProject, List<String> profiles) {
            this.mavenProject = mavenProject;
            this.profiles = profiles;
        }

        public void process(Document document) {
            List allProfiles;
            List<String> selectedProfiles = this.profiles;
            if (selectedProfiles == null || selectedProfiles.size() <= 0) {
                return;
            }
            ArrayList<Container> selectedContainers = new ArrayList<Container>();
            Model projectModel = this.mavenProject.getModel();
            try {
                allProfiles = ArquillianUtility.getProfiles((Model)projectModel);
            }
            catch (CoreException e) {
                ArquillianUIActivator.log(e);
                return;
            }
            for (Container container : ContainerParser.getContainers()) {
                if (!selectedProfiles.contains(container.getId()) || allProfiles.contains(container.getId())) continue;
                selectedContainers.add(container);
            }
            if (selectedContainers.size() <= 0) {
                return;
            }
            Element root = document.getDocumentElement();
            Element profiles = PomEdits.getChild((Element)root, (String[])new String[]{"profiles"});
            for (Container container : selectedContainers) {
                this.generateProfile(profiles, container);
            }
        }

        private void generateProfile(Element profiles, Container container) {
            if (container == null) {
                return;
            }
            String id = container.getId();
            Element profile = PomEdits.createElement((Element)profiles, (String)"profile");
            Element idEl = PomEdits.getChild((Element)profile, (String[])new String[]{"id"});
            PomEdits.setText((Element)idEl, (String)id);
            Element dependencies = PomEdits.getChild((Element)profile, (String[])new String[]{"dependencies"});
            String version = this.getVersion(container.getGroup_id(), container.getArtifact_id());
            PomHelper.addOrUpdateDependency((Element)dependencies, (String)container.getGroup_id(), (String)container.getArtifact_id(), (String)version, null, null, null);
            List deps = container.getDependencies();
            if (deps != null) {
                for (Dependency fd : deps) {
                    version = this.isManaged(fd.getGroup_id(), fd.getArtifact_id()) ? null : this.getVersion(fd.getGroup_id(), fd.getArtifact_id());
                    PomHelper.addOrUpdateDependency((Element)dependencies, (String)fd.getGroup_id(), (String)fd.getArtifact_id(), (String)version, null, null, null);
                }
            }
            PomEdits.format((Node)profile);
        }

        private String getVersion(String gid, String aid) {
            String coords = String.valueOf(gid) + ":" + aid + ":[0,)";
            return ArquillianUtility.getHighestVersion((String)coords);
        }

        private boolean isManaged(String groupId, String artifactId) {
            DependencyManagement depMgmt = this.mavenProject.getDependencyManagement();
            List mgmtDeps = depMgmt.getDependencies();
            for (org.apache.maven.model.Dependency mgmtDep : mgmtDeps) {
                if (!groupId.equals(mgmtDep.getGroupId()) || !artifactId.equals(mgmtDep.getArtifactId())) continue;
                return true;
            }
            return false;
        }
    }
}

