/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.model;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Unique;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Fact;
import org.eclipse.sapphire.modeling.annotations.Facts;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.jboss.tools.arquillian.editor.internal.model.Configuration;
import org.jboss.tools.arquillian.editor.internal.model.ModeType;
import org.jboss.tools.arquillian.editor.internal.model.Protocol;
import org.jboss.tools.arquillian.editor.internal.services.ContainerProfilesService;
import org.jboss.tools.arquillian.editor.internal.services.ContainerQualifierPossibleValuesService;

public interface Container
extends Element {
    public static final ElementType TYPE = new ElementType(Container.class);
    @Label(standard="Qualifier")
    @Facts(value={@Fact(statement="Must be unique between containers and groups."), @Fact(statement="Used to select which container to run.")})
    @XmlBinding(path="@qualifier")
    @Required
    @Unique
    @Services(value={@Service(impl=ContainerQualifierPossibleValuesService.class), @Service(impl=ContainerProfilesService.class)})
    public static final ValueProperty PROP_QUALIFIER = new ValueProperty(TYPE, "Qualifier");
    @Type(base=Boolean.class)
    @Label(standard="Default")
    @XmlBinding(path="@default")
    @DefaultValue(text="false")
    public static final ValueProperty PROP_DEFAULT = new ValueProperty(TYPE, "Default");
    @Label(standard="Mode")
    @XmlBinding(path="@mode")
    @Type(base=ModeType.class)
    public static final ValueProperty PROP_MODE = new ValueProperty(TYPE, "Mode");
    @Type(base=Configuration.class)
    @Label(standard="Configuration")
    @CountConstraint(max=1)
    @XmlBinding(path="configuration")
    public static final ImpliedElementProperty PROP_CONFIGURATION = new ImpliedElementProperty(TYPE, "Configuration");
    @Type(base=Protocol.class)
    @Label(standard="Protocol")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="protocol", type=Protocol.class)})
    public static final ListProperty PROP_PROTOCOL = new ListProperty(TYPE, "Protocol");

    public Value<String> getQualifier();

    public void setQualifier(String var1);

    public Value<Boolean> getDefault();

    public void setDefault(String var1);

    public void setDefault(Boolean var1);

    public Value<String> getMode();

    public void setMode(String var1);

    public Configuration getConfiguration();

    public ElementList<Protocol> getProtocols();
}

