/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xpl;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkBuilder;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.HyperlinkDefinition;

public class BaseHyperlinkDetector
implements IHyperlinkDetector {
    public IHyperlink[] getHyperlinks(ITextViewer textViewer, IRegion region) {
        IHyperlink[] hyperlinks = null;
        if (textViewer != null && textViewer.getDocument() != null) {
            String contentType = this.getContentType(textViewer.getDocument());
            IHyperlinkRegion partition = this.getPartition(textViewer.getDocument(), region.getOffset());
            hyperlinks = partition == null ? null : this.getHyperlinks(textViewer, region, contentType, partition);
        }
        return hyperlinks;
    }

    public IHyperlink[] getHyperlinks(ITextViewer textViewer, IRegion region, String contentType, IHyperlinkRegion partition) {
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
        if (textViewer != null && textViewer.getDocument() != null) {
            HyperlinkDefinition[] defs = HyperlinkBuilder.getInstance().getHyperlinkDefinitions(contentType, partition.getType());
            if (defs == null) {
                return null;
            }
            int i = 0;
            while (i < defs.length) {
                IHyperlink hyperlink = defs[i].createHyperlink();
                if (!hyperlinks.contains(hyperlink)) {
                    if (hyperlink instanceof AbstractHyperlink) {
                        ((AbstractHyperlink)hyperlink).setDocument(textViewer.getDocument());
                        ((AbstractHyperlink)hyperlink).setOffset(region.getOffset());
                        ((AbstractHyperlink)hyperlink).setRegion((IRegion)partition);
                    }
                    hyperlinks.add(hyperlink);
                }
                ++i;
            }
        }
        return hyperlinks.size() == 0 ? null : hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    protected String getContentType(IDocument document) {
        String type = null;
        IModelManager mgr = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = mgr.getExistingModelForRead(document);
            if (model != null) {
                type = model.getContentTypeIdentifier();
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return type;
    }

    protected IHyperlinkRegion getPartition(IDocument document, int offset) {
        IHyperlinkRegion[] regions = this.getPartitions(document, offset);
        return regions != null && regions.length > 0 ? regions[0] : null;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] hyperlinks = this.getHyperlinks(textViewer, region);
        if (hyperlinks != null && hyperlinks.length > 0 && !canShowMultipleHyperlinks) {
            hyperlinks = new IHyperlink[]{hyperlinks[0]};
        }
        return hyperlinks;
    }

    protected IHyperlinkRegion[] getPartitions(IDocument document, int offset) {
        return new IHyperlinkRegion[0];
    }
}

