/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.IConstants;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Messages;
import org.jboss.tools.jmx.jvmmonitor.tools.Activator;

public class Tools
implements IEclipsePreferences.IPreferenceChangeListener,
IConstants {
    private static Tools tools;
    private boolean isReady = this.validateClassPathAndLibraryPath();
    private boolean hasAddedToClasspath = false;
    private String jdkHomeDirectoryAddedToClasspath = null;

    private Tools() {
        if (!this.isReady) {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.jmx.jvmmonitor.tools");
            prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.configureClassPathAndLibraryPath();
            this.isReady = this.validateClassPathAndLibraryPath();
        }
    }

    public static synchronized Tools getInstance() {
        if (tools == null) {
            tools = new Tools();
        }
        return tools;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("org.jboss.tools.jmx.jvmmonitor.tools.jdkVMInstall".equals(event.getKey()) && !this.isReady) {
            this.configureClassPathAndLibraryPath();
            this.isReady = this.validateClassPathAndLibraryPath();
        }
    }

    public String getDirectoryAddedToClasspath() {
        try {
            if (this.jdkHomeDirectoryAddedToClasspath != null) {
                return new File(this.jdkHomeDirectoryAddedToClasspath).getCanonicalPath();
            }
        }
        catch (IOException iOException) {}
        return this.jdkHomeDirectoryAddedToClasspath;
    }

    public boolean runningJavaHomeAddedToClasspath() {
        String javaHome = this.findJdkRootFromJavaHome();
        if (javaHome == null) {
            return false;
        }
        try {
            String canonical = new File(javaHome).getCanonicalPath();
            return canonical.equals(this.getDirectoryAddedToClasspath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean hasModifiedClasspath() {
        return this.hasAddedToClasspath;
    }

    protected Properties invokeGetAgentProperties(Object virtualMachine) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("getAgentProperties", new Class[0]);
            return (Properties)method.invoke(virtualMachine, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected synchronized Object invokeGetMonitoredHost(String name) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.MonitoredHost");
            Method method = clazz.getDeclaredMethod("getMonitoredHost", String.class);
            return method.invoke(null, name);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Set<Integer> invokeActiveVms(Object monitoredHost) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.MonitoredHost");
            Method method = clazz.getDeclaredMethod("activeVms", new Class[0]);
            return (Set)method.invoke(monitoredHost, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeVmIdentifier(String vmId) throws JvmCoreException {
        try {
            Constructor<?> clazz = Class.forName("sun.jvmstat.monitor.VmIdentifier").getConstructor(String.class);
            return clazz.newInstance(vmId);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected synchronized Object invokeGetMonitoredVm(Object monitoredHost, Object vmIdentifier) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.MonitoredHost");
            Class<?> clazz2 = Class.forName("sun.jvmstat.monitor.VmIdentifier");
            Method method = clazz.getDeclaredMethod("getMonitoredVm", clazz2);
            return method.invoke(monitoredHost, vmIdentifier);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeFindByName(Object monitoredVm, String name) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.MonitoredVm");
            Method method = clazz.getDeclaredMethod("findByName", String.class);
            return method.invoke(monitoredVm, name);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeGetValue(Object monitor) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.jvmstat.monitor.Monitor");
            Method method = clazz.getDeclaredMethod("getValue", new Class[0]);
            return method.invoke(monitor, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeAttach(int pid) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("attach", String.class);
            return method.invoke(null, String.valueOf(pid));
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getCause().getMessage(), t);
        }
    }

    protected void invokeDetach(Object vm) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("detach", new Class[0]);
            method.invoke(vm, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    protected Object invokeGetSystemProperties(Object vm) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
            Method method = clazz.getDeclaredMethod("getSystemProperties", new Class[0]);
            return method.invoke(vm, new Object[0]);
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void invokeLoadAgent(Object virtualMachine, String path, String options) throws JvmCoreException {
        block3: {
            block4: {
                try {
                    clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
                    method = clazz.getDeclaredMethod("loadAgent", new Class[]{String.class, String.class});
                    method.invoke(virtualMachine, new Object[]{path, options});
                    break block3;
                }
                catch (Throwable t) {
                    message = t.getMessage();
                    if (message != null) break block4;
                    cause = t.getCause();
                    ** while (cause != null)
                }
lbl-1000:
                // 1 sources

                {
                    message = cause.getMessage();
                    if (message != null) break;
                    cause = cause.getCause();
                    continue;
                }
            }
            throw new JvmCoreException(4, message, t);
        }
    }

    protected InputStream invokeHeapHisto(Object virtualMachine, boolean isLive) throws JvmCoreException {
        try {
            Class<?> clazz = Class.forName("sun.tools.attach.HotSpotVirtualMachine");
            Method method = clazz.getDeclaredMethod("heapHisto", Object[].class);
            Object[] arg = new Object[]{isLive ? "-live" : "-all"};
            return (InputStream)method.invoke(virtualMachine, new Object[]{arg});
        }
        catch (Throwable t) {
            throw new JvmCoreException(4, t.getMessage(), t);
        }
    }

    public String validateJdkRootDirectory(String jdkRootDirectory) {
        if (jdkRootDirectory == null || jdkRootDirectory.trim().isEmpty()) {
            return Messages.NoJdkDirectoryFoundMsg;
        }
        File directory = new File(jdkRootDirectory);
        if (!directory.exists() || !directory.isDirectory()) {
            return Messages.directoryNotExistMsg;
        }
        File toolsJarFile = new File(String.valueOf(jdkRootDirectory) + TOOLS_JAR);
        if (!toolsJarFile.exists()) {
            return Messages.notJdkRootDirectoryMsg;
        }
        String libraryPath = Tools.getJreLibraryPath(jdkRootDirectory);
        if (libraryPath == null) {
            return Messages.notJdkRootDirectoryMsg;
        }
        return null;
    }

    private IVMInstall[] getAllInstalls() {
        ArrayList<IVMInstall> all = new ArrayList<IVMInstall>();
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType type = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = type.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall install = iVMInstallArray[n4];
                all.add(install);
                ++n4;
            }
            ++n2;
        }
        return all.toArray(new IVMInstall[all.size()]);
    }

    private int compareJavaVersions(String version0, String version1) {
        int[] arg1majorMinor;
        int[] arg0majorMinor = this.getMajorMinor(version0);
        if (arg0majorMinor[0] < (arg1majorMinor = this.getMajorMinor(version1))[0]) {
            return -1;
        }
        if (arg0majorMinor[0] > arg1majorMinor[0]) {
            return 1;
        }
        if (arg0majorMinor[1] < arg1majorMinor[1]) {
            return -1;
        }
        if (arg0majorMinor[1] > arg1majorMinor[1]) {
            return 1;
        }
        return 0;
    }

    public IVMInstall[] getAllCompatibleInstalls() {
        String currentVersion = System.getProperty("java.version");
        ArrayList<IVMInstall2> compat = new ArrayList<IVMInstall2>();
        IVMInstall[] all = this.getAllInstalls();
        int i = 0;
        while (i < all.length) {
            String vers;
            if (all[i] instanceof IVMInstall2 && this.compareJavaVersions(currentVersion, vers = ((IVMInstall2)all[i]).getJavaVersion()) >= 0) {
                compat.add((IVMInstall2)all[i]);
            }
            ++i;
        }
        Comparator<IVMInstall2> comparator = new Comparator<IVMInstall2>(){

            @Override
            public int compare(IVMInstall2 arg0, IVMInstall2 arg1) {
                String arg0vers = arg0.getJavaVersion();
                String arg1vers = arg1.getJavaVersion();
                return Tools.this.compareJavaVersions(arg0vers, arg1vers);
            }
        };
        Collections.sort(compat, comparator);
        Collections.reverse(compat);
        return compat.toArray(new IVMInstall[compat.size()]);
    }

    private int[] getMajorMinor(String version) {
        Matcher m = Pattern.compile("^(\\d+)\\.(\\d+)\\..*").matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed version string");
        }
        return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))};
    }

    private IVMInstall findFirstValidVMInstall() {
        IVMInstall[] all = this.getAllCompatibleInstalls();
        int i = 0;
        while (i < all.length) {
            String jdkRootDirectory = all[i].getInstallLocation().getPath();
            if (this.validateJdkRootDirectory(jdkRootDirectory) == null) {
                Activator.log(1, NLS.bind((String)Messages.jdkRootDirectoryFoundMsg, (Object)jdkRootDirectory), new Exception());
                return all[i];
            }
            ++i;
        }
        Activator.log(2, Messages.jdkRootDirectoryNotFoundMsg, new Exception());
        return null;
    }

    public String findJdkRootFromJavaHome() {
        String javaHome = System.getProperty("java.home");
        for (File directory : Tools.getPossibleJdkRootDirectory(javaHome)) {
            String path = directory.getPath();
            if (this.validateJdkRootDirectory(path) != null) continue;
            Activator.log(1, NLS.bind((String)Messages.jdkRootDirectoryFoundMsg, (Object)path), new Exception());
            return path;
        }
        return null;
    }

    private static List<File> getPossibleJdkRootDirectory(String javaHome) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (Platform.getOS().equals("macosx")) {
            int index = javaHome.indexOf("JavaVirtualMachines");
            if (index == -1) {
                return dirs;
            }
            String javaVirtualMachinesPath = javaHome.substring(0, index + "JavaVirtualMachines".length());
            File dir = new File(javaVirtualMachinesPath);
            Tools.collectDirs(dirs, dir, 3);
            return dirs;
        }
        File parentDir = new File(String.valueOf(javaHome) + File.separator + "..");
        dirs.add(parentDir);
        if (parentDir.exists()) {
            File[] fileArray = parentDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    dirs.add(file);
                }
                ++n2;
            }
        }
        return dirs;
    }

    private static void collectDirs(List<File> dirs, File dir, int depth) {
        if (depth > 0) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    dirs.add(file);
                    Tools.collectDirs(dirs, file, depth - 1);
                }
                ++n2;
            }
        }
    }

    private boolean validateClassPathAndLibraryPath() {
        try {
            this.invokeGetMonitoredHost("localhost");
        }
        catch (JvmCoreException jvmCoreException) {
            return false;
        }
        return true;
    }

    private IVMInstall findHomeDirFromPreferences() {
        IVMInstall found;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.jmx.jvmmonitor.tools");
        String vm = prefs.get("org.jboss.tools.jmx.jvmmonitor.tools.jdkVMInstall", null);
        if (vm != null && (found = Tools.findVMInstall(vm)) != null) {
            return found;
        }
        return null;
    }

    private static IVMInstall findVMInstall(String id) {
        if (id != null) {
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            IVMInstall ret = null;
            int i = 0;
            while (i < types.length) {
                ret = types[i].findVMInstall(id);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    private static IVMInstall findVMByInstallLocation(String home) {
        if (home != null) {
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstall[] installs = types[i].getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    if (home.equals(installs[j].getInstallLocation())) {
                        return installs[j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private String findHomeDirectoryToAddToClasspath() {
        IVMInstall vmi;
        String jdkRootDirectory = this.findJdkRootFromJavaHome();
        if ((jdkRootDirectory == null || jdkRootDirectory.trim().isEmpty()) && (vmi = this.findSecondaryVMInstall()) != null) {
            jdkRootDirectory = vmi.getInstallLocation().getAbsolutePath();
        }
        return jdkRootDirectory;
    }

    public IVMInstall findSecondaryVMInstall() {
        IVMInstall vmi = this.findHomeDirFromPreferences();
        if (vmi == null) {
            vmi = this.findFirstValidVMInstall();
        }
        return vmi;
    }

    private void configureClassPathAndLibraryPath() {
        String jdkRootDirectory = this.findHomeDirectoryToAddToClasspath();
        String error = this.validateJdkRootDirectory(jdkRootDirectory);
        if (error != null) {
            return;
        }
        try {
            this.addClassPath(jdkRootDirectory);
        }
        catch (Throwable t) {
            Activator.log(4, Messages.addingClassPathFailedMsg, t);
            return;
        }
        try {
            Tools.addLibraryPath(jdkRootDirectory);
        }
        catch (Throwable t) {
            Activator.log(4, Messages.addingLibraryPathFailedMsg, t);
            return;
        }
    }

    public IVMInstall findActiveVM() {
        String javaHome = System.getProperty("java.home");
        return Tools.findVMByInstallLocation(javaHome);
    }

    public boolean hasActiveVMInstall() {
        return this.findActiveVM() != null;
    }

    private static String getJreLibraryPath(String jdkRootDirectory) {
        String[] stringArray = LIBRARY_PATHS;
        int n = LIBRARY_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File attachLibraryFile = new File(String.valueOf(jdkRootDirectory) + path + File.separator + System.mapLibraryName("attach"));
            if (attachLibraryFile.exists()) {
                return String.valueOf(jdkRootDirectory) + path;
            }
            ++n2;
        }
        return null;
    }

    private void addClassPath(String jdkRootDirectory) throws Throwable {
        File file = new File(String.valueOf(jdkRootDirectory) + TOOLS_JAR);
        URL toolsJarUrl = file.toURI().toURL();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)ClassLoader.getSystemClassLoader(), toolsJarUrl);
        Activator.log(1, NLS.bind((String)Messages.classPathAddedMsg, (Object)file.getPath()), new Exception());
        this.jdkHomeDirectoryAddedToClasspath = jdkRootDirectory;
        this.hasAddedToClasspath = true;
    }

    private static void addLibraryPath(String jdkRootDirectory) throws Throwable {
        String libraryPath = System.getProperty("java.library.path");
        String jreLibraryPath = Tools.getJreLibraryPath(jdkRootDirectory);
        System.setProperty("java.library.path", String.valueOf(libraryPath) + File.pathSeparator + jreLibraryPath);
        Class<ClassLoader> clazz = ClassLoader.class;
        Field field = clazz.getDeclaredField("sys_paths");
        field.setAccessible(true);
        field.set(clazz, null);
    }
}

