/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.lint;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.ITernResultProcessor;
import tern.server.protocol.TernDoc;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.lint.TernLintQuery;

public class TernLintResultProcessor
implements ITernResultProcessor<ITernLintCollector> {
    public static final TernLintResultProcessor INSTANCE = new TernLintResultProcessor();

    @Override
    public void process(TernDoc doc, IJSONObjectHelper jsonObjectHelper, Object jsonObject, ITernLintCollector collector) {
        if (!(jsonObject instanceof JsonObject)) {
            return;
        }
        JsonArray messages = (JsonArray)((JsonObject)jsonObject).get("messages");
        if (messages != null) {
            TernLintQuery query = (TernLintQuery)doc.getQuery();
            if (query.isGroupByFiles()) {
                JsonObject filesObject = null;
                String file = null;
                for (JsonValue files : messages) {
                    filesObject = (JsonObject)files;
                    file = jsonObjectHelper.getText(filesObject.get("file"));
                    collector.startLint(file);
                    JsonArray messagesFile = (JsonArray)filesObject.get("messages");
                    if (messagesFile != null) {
                        this.addMessages(jsonObjectHelper, messagesFile, collector);
                    }
                    collector.endLint(file);
                }
            } else {
                this.addMessages(jsonObjectHelper, messages, collector);
            }
        }
    }

    protected void addMessages(IJSONObjectHelper jsonObjectHelper, JsonArray messages, ITernLintCollector collector) {
        String message = null;
        String severity = null;
        String file = null;
        JsonObject messageObject = null;
        for (JsonValue value : messages) {
            messageObject = (JsonObject)value;
            message = jsonObjectHelper.getText(messageObject.get("message"));
            severity = jsonObjectHelper.getText(messageObject.get("severity"));
            Long startCh = jsonObjectHelper.getCh(messageObject, "from");
            Long endCh = jsonObjectHelper.getCh(messageObject, "to");
            file = jsonObjectHelper.getText(messageObject.get("file"));
            collector.addMessage(message, startCh, endCh, severity, file);
        }
    }
}

