(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    return mod(require("tern/lib/infer"), require("tern/lib/tern"));
  if (typeof define == "function" && define.amd) // AMD
    return define([ "tern/lib/infer", "tern/lib/tern" ], mod);
  mod(tern, tern);
})(function(infer, tern) {
  "use strict";

  tern.registerPlugin("dojotoolkit_1.6", function(server, options) {
    server._dojo = {};
    return {
      defs : defs
    };
  });

  var defs = {"!name":"dojotoolkit","dijit":{"_masterTT":{},"_curFocus":{},"_prevFocus":{},"_activeStack":{"!type":"[]"},"_justMouseDowned":{"!type":"bool"},"_clearActiveWidgetsTimer":{},"defaultDuration":{"!type":"number"},"registry":{"!doc":"A list of widgets on a page."},"_widgetTypeCtr":{},"placementRegistry":{},"_frames":{},"_XhtmlRoles":{"!type":"+RegExp"},"dijit-all":{"!doc":"A rollup that includes every dijit. You probably don't need this."},"dijit":{"!doc":"A roll-up for common dijit methods"},"demos":{"!doc":"Home of the official dijit demo code"},"robot":{},"robotx":{},"_underlay":{"!type":"fn(kwArgs: ?)","!doc":"A shared instance of a <code>dijit.DialogUnderlay</code>"},"showTooltip":{"!type":"fn(innerHTML: string, aroundNode: +Node, position?: [string])","!doc":"Display tooltip w/specified contents in specified position.\nSee description of dijit.Tooltip.defaultPosition for details on position parameter.\nIf position is not specified then dijit.Tooltip.defaultPosition is used."},"hideTooltip":{"!type":"fn(aroundNode: ?)","!doc":"Hide the tooltip"},"_connectOnUseEventHandler":{"!type":"fn(event: +Event)"},"isCollapsed":{"!type":"fn() -> bool","!doc":"Returns true if there is no text selected"},"getBookmark":{"!type":"fn() -> []","!doc":"Retrieves a bookmark that can be used with moveToBookmark to return to the same range"},"moveToBookmark":{"!type":"fn(bookmark: ?)","!doc":"Moves current selection to a bookmark"},"getFocus":{"!type":"fn(menu?: +dijit._Widget, openedForWindow?: +Window)","!doc":"Returns the current focus and selection.\nCalled when a popup appears (either a top level menu or a dialog),\nor when a toolbar/menubar receives focus"},"focus":{"!type":"fn(handle: ?)","!doc":"Sets the focused node and the selection according to argument.\nTo set focus to an iframe's content, pass in the iframe itself."},"registerIframe":{"!type":"fn(iframe: +Node)","!doc":"Registers listeners on the specified iframe so that any click\nor focus event on that iframe (or anything in it) is reported\nas a focus/click event on the &lt;iframe&gt; itself."},"registerWin":{"!type":"fn(targetWindow?: +Window, effectiveNode?: +Node)","!doc":"Registers listeners on the specified window (either the main\nwindow or an iframe's window) to detect when the user has clicked somewhere\nor focused somewhere."},"_onBlurNode":{"!type":"fn(node: +Node)","!doc":"Called when focus leaves a node.\nUsually ignored, _unless_ it *isn't* follwed by touching another node,\nwhich indicates that we tabbed off the last field on the page,\nin which case every widget is marked inactive"},"_onTouchNode":{"!type":"fn(node: +Node)","!doc":"Callback when node is focused or mouse-downed"},"_onFocusNode":{"!type":"fn(node: +Node)","!doc":"Callback when node is focused"},"_setStack":{"!type":"fn(newStack: ?)","!doc":"The stack of active widgets has changed.  Send out appropriate events and records new stack."},"getUniqueId":{"!type":"fn(widgetType: string) -> string","!doc":"Generates a unique id for a given widgetType"},"findWidgets":{"!type":"fn(root: +Node)","!doc":"Search subtree under root, putting found widgets in outAry.\nDoesn't search for nested widgets (ie, widgets inside other widgets)"},"byId":{"!type":"fn(id: string) -> +dijit._Widget","!doc":"Returns a widget by it's id, or if passed a widget, no-op (like dojo.byId())"},"byNode":{"!type":"fn(node: +Node) -> +dijit._Widget","!doc":"Returns the widget corresponding to the given DOMNode"},"getEnclosingWidget":{"!type":"fn(node: +Node)","!doc":"Returns the widget whose DOM tree contains the specified DOMNode, or null if\nthe node is not contained within the DOM tree of any widget"},"_isElementShown":{"!type":"fn(elem: +Element)"},"isTabNavigable":{"!type":"fn(elem: +Element) -> bool","!doc":"Tests if an element is tab-navigable"},"_getTabNavigable":{"!type":"fn(root: +Node)","!doc":"Finds descendants of the specified root node."},"getFirstInTabbingOrder":{"!type":"fn(root: string) -> +Node","!doc":"Finds the descendant of the specified root node\nthat is first in the tabbing order"},"getLastInTabbingOrder":{"!type":"fn(root: string) -> +Node","!doc":"Finds the descendant of the specified root node\nthat is last in the tabbing order"},"getViewport":{"!type":"fn()","!doc":"Returns the dimensions and scroll position of the viewable area of a browser window"},"__Position":{"!type":"fn()"},"placeOnScreen":{"!type":"fn(node: +Node, pos: +dijit.__Position, corners: [string], padding?: +dijit.__Position)","!doc":"Positions one of the node's corners at specified position\nsuch that node is fully visible in viewport."},"_place":{"!type":"fn(node: +Node, choices: [], layoutNode: fn())","!doc":"Given a list of spots to put node, put it at the first spot where it fits,\nof if it doesn't fit anywhere then the place with the least overflow"},"placeOnScreenAroundNode":{"!type":"fn(node: +Node, aroundNode: +Node, aroundCorners: ?, layoutNode?: fn())","!doc":"Position node adjacent or kitty-corner to aroundNode\nsuch that it's fully visible in viewport."},"__Rectangle":{"!type":"fn()"},"placeOnScreenAroundRectangle":{"!type":"fn(node: +Node, aroundRect: +dijit.__Rectangle, aroundCorners: ?, layoutNode: fn())","!doc":"Like dijit.placeOnScreenAroundNode(), except that the &quot;around&quot;\nparameter is an arbitrary rectangle on the screen (x, y, width, height)\ninstead of a dom node."},"_placeOnScreenAroundRect":{"!type":"fn(node: +Node, x: number, y: number, width: number, height: number, aroundCorners: ?, layoutNode: fn())","!doc":"Like dijit.placeOnScreenAroundNode(), except it accepts coordinates\nof a rectangle to place node adjacent to."},"placeOnScreenAroundElement":{"!type":"fn(node: +Node, aroundElement: ?, aroundCorners: ?, layoutNode: fn())","!doc":"Like dijit.placeOnScreenAroundNode(), except it accepts an arbitrary object\nfor the &quot;around&quot; argument and finds a proper processor to place a node."},"scrollIntoView":{"!type":"fn(node: +Node)","!doc":"Scroll the passed node into view, if it is not."},"hasWaiRole":{"!type":"fn(elem: +Element, role: string)","!doc":"Determines if an element has a particular non-XHTML role."},"getWaiRole":{"!type":"fn(elem: +Element)","!doc":"Gets the non-XHTML role for an element (which should be a wai role)."},"setWaiRole":{"!type":"fn(elem: +Element, role: string)","!doc":"Sets the role on an element."},"removeWaiRole":{"!type":"fn(elem: +Element, role: string)","!doc":"Removes the specified non-XHTML role from an element.\nRemoves role attribute if no specific role provided (for backwards compat.)"},"hasWaiState":{"!type":"fn(elem: +Element, state: string)","!doc":"Determines if an element has a given state."},"getWaiState":{"!type":"fn(elem: +Element, state: string)","!doc":"Gets the value of a state on an element."},"setWaiState":{"!type":"fn(elem: +Element, state: string, value: string)","!doc":"Sets a state on an element."},"removeWaiState":{"!type":"fn(elem: +Element, state: string)","!doc":"Removes a state from an element."},"getDocumentWindow":{"!type":"fn(doc: ?) -> +Window","!doc":"Get window object associated with document doc"},"selectInputText":{"!type":"fn(element: +Node, start?: number, stop?: number)","!doc":"Select text in the input element argument, from start (default 0), to stop (default end)."},"CheckedMenuItem":{"!type":"fn()","prototype":{"!proto":"dijit.MenuItem.prototype","!doc":"A checkbox-like menu item for toggling on and off","templatePath":{},"checked":{"!doc":"Our checked state","!type":"bool"},"_setCheckedAttr":{"!type":"fn(checked: bool)","!doc":"Hook so attr('checked', bool) works.\nSets the class and state for the check box."},"onChange":{"!type":"fn(checked: bool)","!doc":"User defined function to handle check/uncheck events"},"_onClick":{"!type":"fn(e: +Event)","!doc":"Clicking this item just toggles its state"}}},"ColorPalette":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A keyboard accessible color-picking widget","defaultTimeout":{"!doc":"Number of milliseconds before a held key or button becomes typematic","!type":"number"},"timeoutChangeRate":{"!doc":"Fraction of time used to change the typematic timer between events\n1.0 means that each typematic event fires at defaultTimeout intervals\n&lt; 1.0 means that each typematic event fires at an increasing faster rate","!type":"number"},"palette":{"!doc":"Size of grid, either &quot;7x10&quot; or &quot;3x4&quot;.","!type":"string"},"value":{"!doc":"The value of the selected color.","!type":"string"},"_currentFocus":{"!doc":"Index of the currently focused color.","!type":"+Integer"},"_xDim":{"!doc":"This is the number of colors horizontally across.","!type":"+Integer"},"_yDim":{"!doc":"/\t\tThis is the number of colors vertically down.","!type":"+Integer"},"templatePath":{"!doc":"Path to the template of this widget.","!type":"string"},"tabIndex":{"!doc":"Widget tab index.","!type":"string"},"postCreate":{"!type":"fn()"},"focus":{"!type":"fn()","!doc":"Focus this ColorPalette.  Puts focus on the first swatch."},"onChange":{"!type":"fn(color: string)","!doc":"Callback when a color is selected."},"_focusFirst":{"!type":"fn()","!doc":"Focus the first cell in the color picker,\nor the previously selected cell, if there is one"},"_onDivNodeFocus":{"!type":"fn(evt: ?)","!doc":"Handler for when focus goes to the ColorPalette itself.\nShifts focus to the first color or the previously selected\ncolor."},"_onFocus":{"!type":"fn()","!doc":"Handler for when the ColorPalette or a color cell inside of it get focus"},"_onBlur":{"!type":"fn()","!doc":"Handler for when the ColorPalette and the color cell inside of it lose focus"},"_onCellDijitclick":{"!type":"fn(evt: +Event)","!doc":"Handler for click, enter key &amp; space key. Selects the color."},"_onCellMouseEnter":{"!type":"fn(evt: +Event)","!doc":"Handler for onMouseOver. Put focus on the color under the mouse."},"_onCellFocus":{"!type":"fn(evt: +Event)","!doc":"Handler for onFocus of a cell. Removes highlight of\nthe color that just lost focus, and highlights\nthe new color."},"_setCurrent":{"!type":"fn(node: +Node)","!doc":"Called when a color is hovered or focused."},"_onCellBlur":{"!type":"fn(evt: +Event)","!doc":"needed for Firefox 2 on Mac OS X"},"_removeCellHighlight":{"!type":"fn(index: ?)","!doc":"Removes the hover CSS class for the specified cell"},"_selectColor":{"!type":"fn(selectNode: ?)","!doc":"This selects a color. It triggers the onChange event\narea:\nThe area node that covers the color being selected."},"_navigateByKey":{"!type":"fn(increment: +How, typeCount: +How)","!doc":"This is the callback for typematic.\nIt changes the focus and the highlighed color."}},"_palettes":{"!doc":"This represents the value of the colors.\nThe first level is a hashmap of the different arrays available\nThe next two dimensions represent the columns and rows of colors.","7x10":{"!type":"[]"},"3x4":{"!type":"[]"}},"_imagePaths":{"!doc":"This is stores the path to the palette images","7x10":{},"3x4":{}},"_paletteCoords":{"!doc":"This is a map that is used to calculate the coordinates of the\nimages that make up the palette.","leftOffset":{"!type":"number"},"topOffset":{"!type":"number"},"cWidth":{"!type":"number"},"cHeight":{"!type":"number"}},"_paletteDims":{"!doc":"Size of the supported palettes for alignment purposes.","7x10":{"width":{"!type":"string"},"height":{"!type":"string"}},"3x4":{"width":{"!type":"string"},"height":{"!type":"string"}}}},"Declaration":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"The Declaration widget allows a developer to declare new widget\nclasses directly from a snippet of markup.","_noScript":{"!doc":"Flag to parser to leave alone the script tags contained inside of me","!type":"bool"},"widgetClass":{"!doc":"Name of class being declared, ex: &quot;acme.myWidget&quot;","!type":"string"},"defaults":{},"mixins":{"!doc":"List containing the prototype for this widget, and also any mixins,\nex: [&quot;dijit._Widget&quot;, &quot;dijit._Container&quot;]","!type":"[string]"},"buildRendering":{"!type":"fn()"}}},"Dialog":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"A modal dialog Widget","templateString":{},"templatePath":{},"attributeMap":{},"open":{"!doc":"True if Dialog is currently displayed on screen.","!type":"bool"},"refocus":{"!doc":"A Toggle to modify the default focus behavior of a Dialog, which\nis to re-focus the element which had focus before being opened.\nFalse will disable refocusing. Default: true","!type":"bool"},"autofocus":{"!doc":"A Toggle to modify the default focus behavior of a Dialog, which\nis to focus on the first dialog element after opening the dialog.\nFalse will disable autofocusing. Default: true","!type":"bool"},"_firstFocusItem":{"!doc":"DomNode\nThe pointer to the first focusable node in the dialog.\nSet by <code>dijit._DialogMixin._getFocusItems</code>.","!type":"+[readonly]"},"_lastFocusItem":{"!doc":"DomNode\nThe pointer to which node has focus prior to our dialog.\nSet by <code>dijit._DialogMixin._getFocusItems</code>.","!type":"+[readonly]"},"doLayout":{"!doc":"Don't change this parameter from the default value.\nThis ContentPane parameter doesn't make sense for Dialog, since Dialog\nis never a child of a layout container, nor can you specify the size of\nDialog in order to control the size of an inner widget.","!type":"bool"},"draggable":{"!doc":"Toggles the moveable aspect of the Dialog. If true, Dialog\ncan be dragged by it's title. If false it will remain centered\nin the viewport.","!type":"bool"},"_fixSizes":{"!doc":"Does this Dialog attempt to restore the width and height after becoming too small?","!type":"bool"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"onLoad":{"!type":"fn()","!doc":"Called when data has been loaded from an href.\nUnlike most other callbacks, this function can be connected to (via <code>dojo.connect</code>)\nbut should *not* be overriden."},"_endDrag":{"!type":"fn(e: ?)","!doc":"Called after dragging the Dialog. Calculates the relative offset\nof the Dialog in relation to the viewport."},"_setup":{"!type":"fn()","!doc":"Stuff we need to do before showing the Dialog for the first\ntime (but we defer it until right beforehand, for\nperformance reasons)."},"uninitialize":{"!type":"fn()"},"_size":{"!type":"fn()","!doc":"Make sure the dialog is small enough to fit in viewport."},"_position":{"!type":"fn()","!doc":"Position modal dialog in the viewport. If no relative offset\nin the viewport has been determined (by dragging, for instance),\ncenter the node. Otherwise, use the Dialog's stored relative offset,\nand position the node to top: left: values based on the viewport."},"_onKey":{"!type":"fn(evt: +Event)","!doc":"Handles the keyboard events for accessibility reasons"},"show":{"!type":"fn()","!doc":"Display the dialog"},"hide":{"!type":"fn()","!doc":"Hide the dialog"},"layout":{"!type":"fn()","!doc":"Position the Dialog and the underlay"},"destroy":{"!type":"fn()"},"_onCloseEnter":{"!type":"fn()","!doc":"Called when user hovers over close icon"},"_onCloseLeave":{"!type":"fn()","!doc":"Called when user stops hovering over close icon"}},"duration":{"!doc":"The time in milliseconds it takes the dialog to fade in and out","!type":"+Integer"}},"DialogUnderlay":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"The component that blocks the screen behind a `dijit.Dialog`","templateString":{"!type":"string"},"dialogId":{"!doc":"Id of the dialog.... DialogUnderlay's id is based on this id","!type":"string"},"class":{"!doc":"This class name is used on the DialogUnderlay node, in addition to dijitDialogUnderlay","!type":"string"},"_setDialogIdAttr":{"!type":"fn(id: ?)"},"_setClassAttr":{"!type":"fn(clazz: ?)"},"postCreate":{"!type":"fn()","!doc":"Append the underlay to the body"},"layout":{"!type":"fn()","!doc":"Sets the background to the size of the viewport"},"show":{"!type":"fn()","!doc":"Show the dialog underlay"},"hide":{"!type":"fn()","!doc":"Hides the dialog underlay"},"uninitialize":{"!type":"fn()"}},"attributeMap":{"id":{"!type":"string"}}},"Editor":{"!type":"fn()","prototype":{"!proto":"dijit._editor.RichText.prototype","!doc":"A rich text Editing widget","plugins":{"!doc":"A list of plugin names (as strings) or instances (as objects)\nfor this widget.\n\nWhen declared in markup, it might look like:\n\tplugins=&quot;['bold',{name:'dijit._editor.plugins.FontChoice', command:'fontName', generic:true}]&quot;","!type":"[+Object]"},"extraPlugins":{"!doc":"A list of extra plugin names which will be appended to plugins array\n\n\nthe following 3 functions are required to make the editor play nice under a layout widget, see #4070","!type":"[+Object]"},"editActionInterval":{"!doc":"When using customUndo, not every keystroke will be saved as a step.\nInstead typing (including delete) will be grouped together: after\na user stops typing for editActionInterval seconds, a step will be\nsaved; if a user resume typing within editActionInterval seconds,\nthe timeout will be restarted. By default, editActionInterval is 3\nseconds.\nend of custom undo/redo support","!type":"+Integer"},"_steps":{"!type":"[]"},"_undoedSteps":{"!type":"[]"},"constructor":{"!type":"fn()","!doc":"Runs on widget initialization to setup arrays etc."},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"addPlugin":{"!type":"fn(plugin: string, index?: +Integer)","!doc":"takes a plugin name as a string or a plugin instance and\nadds it to the toolbar and associates it with this editor\ninstance. The resulting plugin is added to the Editor's\nplugins array. If index is passed, it's placed in the plugins\narray at that index. No big magic, but a nice helper for\npassing in plugin names via markup."},"startup":{"!type":"fn()","!doc":"Exists to make Editor work as a child of a layout widget.\nDevelopers don't need to call this method."},"resize":{"!type":"fn(size: ?)","!doc":"Resize the editor to the specified size, see <code>dijit.layout._LayoutWidget.resize</code>"},"layout":{"!type":"fn()","!doc":"Called from <code>dijit.layout._LayoutWidget.resize</code>.  This shouldn't be called directly"},"_onIEMouseDown":{"!type":"fn(e: +Event)","!doc":"IE only to prevent 2 clicks to focus"},"onBeforeDeactivate":{"!type":"fn(e: ?)","!doc":"Called on IE right before focus is lost.   Saves the selected range."},"beginEditing":{"!type":"fn(cmd: ?)","!doc":"Called to note that the user has started typing alphanumeric characters, if it's not already noted.\nDeals with saving undo; see editActionInterval parameter."},"execCommand":{"!type":"fn(cmd: ?)","!doc":"Main handler for executing any commands to the editor, like paste, bold, etc.\nCalled by plugins, but not meant to be called by end users."},"queryCommandEnabled":{"!type":"fn(cmd: ?)","!doc":"Returns true if specified editor command is enabled.\nUsed by the plugins to know when to highlight/not highlight buttons."},"focus":{"!type":"fn()","!doc":"Set focus inside the editor"},"_moveToBookmark":{"!type":"fn(b: ?)","!doc":"Selects the text specified in bookmark b"},"_changeToStep":{"!type":"fn(from: ?, to: ?)","!doc":"Reverts editor to &quot;to&quot; setting, from the undo stack."},"undo":{"!type":"fn()","!doc":"Handler for editor undo (ex: ctrl-z) operation"},"redo":{"!type":"fn()","!doc":"Handler for editor redo (ex: ctrl-y) operation"},"endEditing":{"!type":"fn(ignore_caret: ?)","!doc":"Called to note that the user has stopped typing alphanumeric characters, if it's not already noted.\nDeals with saving undo; see editActionInterval parameter."},"_getBookmark":{"!type":"fn()","!doc":"Get the currently selected text"},"_beginEditing":{"!type":"fn(cmd: ?)","!doc":"Called when the user starts typing alphanumeric characters.\nDeals with saving undo; see editActionInterval parameter."},"_endEditing":{"!type":"fn(ignore_caret: ?)","!doc":"Called when the user stops typing alphanumeric characters.\nDeals with saving undo; see editActionInterval parameter."},"onKeyDown":{"!type":"fn(e: ?)","!doc":"Handler for onkeydown event."},"_onBlur":{"!type":"fn()","!doc":"Called from focus manager when focus has moved away from this editor"},"_saveSelection":{"!type":"fn()","!doc":"Save the currently selected text in _savedSelection attribute"},"_restoreSelection":{"!type":"fn()","!doc":"Re-select the text specified in _savedSelection attribute;\nsee _saveSelection()."},"_onFocus":{"!type":"fn()","!doc":"Called from focus manager when focus has moved into this editor"},"onClick":{"!type":"fn()","!doc":"Handler for when editor is clicked"}},"customUndo":{"!doc":"Whether we shall use custom undo/redo support instead of the native\nbrowser support. By default, we only enable customUndo for IE, as it\nhas broken native undo/redo support. Note: the implementation does\nsupport other browsers which have W3C DOM2 Range API implemented.","!type":"bool"}},"_editor":{"html":{},"range":{},"escapeXml":{"!type":"fn(str: string, noSingleQuotes?: bool) -> string","!doc":"Adds escape sequences for special characters in XML: &amp;&lt;&gt;&quot;'\nOptionally skips escapes for single quotes"},"getNodeHtml":{"!type":"fn(node: +Node)"},"getChildrenHtml":{"!type":"fn(dom: +Node) -> string","!doc":"Returns the html content of a DomNode and children"},"_Plugin":{"!type":"fn()","prototype":{"editor":{"!doc":"Points to the parent editor","!type":"+dijit.Editor"},"iconClassPrefix":{"!doc":"The CSS class name for the button node is formed from <code>iconClassPrefix</code> and <code>command</code>","!type":"string"},"button":{"!doc":"Pointer to <code>dijit.form.Button</code> or other widget (ex: <code>dijit.form.FilteringSelect</code>) that controls this plugin.\nIf not specified, will be created on initialization according to <code>buttonClass</code>","!type":"+dijit._Widget"},"command":{"!doc":"String like &quot;insertUnorderedList&quot;, &quot;outdent&quot;, &quot;justifyCenter&quot;, etc. that represents an editor command.\nPassed to editor.execCommand() if <code>useDefaultCommand</code> is true.","!type":"string"},"useDefaultCommand":{"!doc":"If true, this plugin executes by calling Editor.execCommand() with the argument specified in <code>command</code>.","!type":"bool"},"constructor":{"!type":"fn(args?: ?, node?: +Node)"},"getLabel":{"!type":"fn(key: string) -> string","!doc":"Returns the label to use for the button"},"_initButton":{"!type":"fn(props: ?)","!doc":"Initialize the button that will control this plugin.\nThis code only works for plugins controlling built-in commands in the editor."},"destroy":{"!type":"fn()","!doc":"Destroy this plugin"},"connect":{"!type":"fn(o: ?, f: ?, tf: ?)","!doc":"Make a dojo.connect() that is automatically disconnected when this plugin is destroyed.\nSimilar to <code>dijit._Widget.connect</code>."},"updateState":{"!type":"fn()","!doc":"Change state of the plugin to respond to events in the editor."},"setEditor":{"!type":"fn(editor: +dijit.Editor)","!doc":"Tell the plugin which Editor it is associated with."},"setToolbar":{"!type":"fn(toolbar: +dijit.Toolbar)","!doc":"Tell the plugin to add itself to the toolbar (if there is a button associated with the plugin)."}},"buttonClass":{"!doc":"Class\nClass for button to control this plugin.   This is used to instantiate the button, unless <code>button</code> itself\nis specified directly.","!type":"+dijit._Widget"}},"RichText":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"dijit._editor.RichText is the core of dijit.Editor, which provides basic\nWYSIWYG editing features.","inheritWidth":{"!doc":"whether to inherit the parent's width or simply use 100%","!type":"bool"},"focusOnLoad":{"!doc":"Focus into this widget when the page is loaded","!type":"bool"},"name":{"!doc":"Specifies the name of a (hidden) &lt;textarea&gt; node on the page that's used to save\nthe editor content on page leave.   Used to restore editor contents after navigating\nto a new page and then hitting the back button.","!type":"string"},"styleSheets":{"!doc":"semicolon (&quot;;&quot;) separated list of css files for the editing area","!type":"string"},"_content":{"!doc":"temporary content storage","!type":"string"},"height":{"!doc":"Set height to fix the editor at a specific height, with scrolling.\nBy default, this is 300px.  If you want to have the editor always\nresizes to accommodate the content, use AlwaysShowToolbar plugin\nand set height=&quot;&quot;.  If this editor is used within a layout widget,\nset height=&quot;100%&quot;.","!type":"string"},"minHeight":{"!doc":"The minimum height that the editor should have.","!type":"string"},"isClosed":{"!type":"bool"},"isLoaded":{"!type":"bool"},"_SEPARATOR":{"!doc":"Used to concat contents from multiple editors into a single string,\nso they can be saved into a single &lt;textarea&gt; node.  See &quot;name&quot; attribute.","!type":"string"},"onLoadDeferred":{"!doc":"Deferred which is fired when the editor finishes loading","!type":"+dojo.Deferred"},"isTabIndent":{"!doc":"Make tab key and shift-tab indent and outdent rather than navigating.\nCaution: sing this makes web pages inaccessible to users unable to use a mouse.","!type":"bool"},"disableSpellCheck":{"!doc":"When true, disables the browser's native spell checking, if supported.\nWorks only in Firefox.","!type":"bool"},"events":{"!doc":"events which should be connected to the underlying editing area","!type":"[string]"},"captureEvents":{"!doc":"Events which should be connected to the underlying editing\narea, events in this array will be addListener with\ncapture=true.\nTODO: looking at the code I don't see any distinction between events and captureEvents,\nso get rid of this for 2.0 if not sooner","!type":"[string]"},"_editorCommandsLocalized":{"!type":"bool"},"_local2NativeFormatNames":{},"_native2LocalFormatNames":{},"_localizedIframeTitles":{},"disabled":{"!doc":"The editor is disabled; the text cannot be changed.","!type":"bool"},"_mozSettingProps":{"!type":"[]"},"updateInterval":{"!type":"number"},"_updateTimer":{},"_qcaCache":{},"constructor":{"!type":"fn(params: ?)","!doc":"dijit._editor.RichText is the core of dijit.Editor, which provides basic\nWYSIWYG editing features."},"postCreate":{"!type":"fn()"},"setupDefaultShortcuts":{"!type":"fn()","!doc":"Add some default key handlers"},"_localizeEditorCommands":{"!type":"fn()","!doc":"When IE is running in a non-English locale, the API actually changes,\nso that we have to say (for example) danraku instead of p (for paragraph).\nHandle that here."},"open":{"!type":"fn(element?: +Node)","!doc":"Transforms the node referenced in this.domNode into a rich text editing\nnode."},"_getIframeDocTxt":{"!type":"fn(html: string)","!doc":"Generates text of the document inside the iframe (ie, &lt;html&gt;....editor content...&lt;/html&gt;"},"_drawIframe":{"!type":"fn(html: string)","!doc":"Draws an iFrame using the existing one if one exists.\nUsed by Firefox only.  See open() for code for other browsers."},"_applyEditingAreaStyleSheets":{"!type":"fn()","!doc":"apply the specified css files in styleSheets"},"addStyleSheet":{"!type":"fn(uri: +dojo._Url)","!doc":"add an external stylesheet for the editing area"},"removeStyleSheet":{"!type":"fn(uri: +dojo._Url)","!doc":"remove an external stylesheet for the editing area"},"_setDisabledAttr":{"!type":"fn(value: bool)"},"onLoad":{"!type":"fn(e: +Event)","!doc":"Handler after the content of the document finishes loading."},"onKeyDown":{"!type":"fn(e: +Event)","!doc":"Handler for onkeydown event"},"onKeyUp":{"!type":"fn(e: ?)","!doc":"Handler for onkeyup event"},"setDisabled":{"!type":"fn(disabled: bool)","!doc":"Deprecated, use attr('disabled', ...) instead."},"_setValueAttr":{"!type":"fn(value: string)","!doc":"Registers that attr(&quot;value&quot;, foo) should call setValue(foo)"},"_getDisableSpellCheckAttr":{"!type":"fn()"},"_setDisableSpellCheckAttr":{"!type":"fn(disabled: bool)"},"onKeyPress":{"!type":"fn(e: ?)","!doc":"Handle the various key events"},"addKeyHandler":{"!type":"fn(key: string, ctrl: bool, shift: bool, handler: fn())","!doc":"Add a handler for a keyboard shortcut"},"onKeyPressed":{"!type":"fn()","!doc":"Handler for after the user has pressed a key, and the display has been updated.\n(Runs on a timer so that it runs after the display is updated)"},"onClick":{"!type":"fn(e: +Event)","!doc":"Handler for when the user clicks."},"_onIEMouseDown":{"!type":"fn(e: +Event)","!doc":"IE only to prevent 2 clicks to focus"},"_onBlur":{"!type":"fn(e: ?)","!doc":"Called from focus manager when focus has moved away from this editor"},"_onFocus":{"!type":"fn(e: +Event)","!doc":"Called from focus manager when focus has moved into this editor"},"blur":{"!type":"fn()","!doc":"Remove focus from this instance."},"focus":{"!type":"fn()","!doc":"Move focus to this editor"},"onDisplayChanged":{"!type":"fn(e: +Event)","!doc":"This event will be fired everytime the display context\nchanges and the result needs to be reflected in the UI."},"onNormalizedDisplayChanged":{"!type":"fn()","!doc":"This event is fired every updateInterval ms or more"},"onChange":{"!type":"fn(newContent: ?)","!doc":"This is fired if and only if the editor loses focus and\nthe content is changed."},"_normalizeCommand":{"!type":"fn(cmd: string)","!doc":"Used as the advice function by dojo.connect to map our\nnormalized set of commands to those supported by the target\nbrowser."},"queryCommandAvailable":{"!type":"fn(command: string)","!doc":"Tests whether a command is supported by the host. Clients\nSHOULD check whether a command is supported before attempting\nto use it, behaviour for unsupported commands is undefined."},"_queryCommandAvailable":{"!type":"fn(command: string)","!doc":"See queryCommandAvailable()."},"execCommand":{"!type":"fn(command: string, argument: +An)","!doc":"Executes a command in the Rich Text area"},"queryCommandEnabled":{"!type":"fn(command: string)","!doc":"Check whether a command is enabled or not."},"queryCommandState":{"!type":"fn(command: ?)","!doc":"Check the state of a given command and returns true or false."},"queryCommandValue":{"!type":"fn(command: ?)","!doc":"Check the value of a given command. This matters most for\ncustom selections and complex values like font value setting."},"_sCall":{"!type":"fn(name: ?, args: ?)","!doc":"Run the named method of dijit._editor.selection over the\ncurrent editor instance's window, with the passed args."},"placeCursorAtStart":{"!type":"fn()","!doc":"Place the cursor at the start of the editing area."},"placeCursorAtEnd":{"!type":"fn()","!doc":"Place the cursor at the end of the editing area."},"getValue":{"!type":"fn(nonDestructive?: bool)","!doc":"Return the current content of the editing area (post filters\nare applied).  Users should call attr('value') instead."},"_getValueAttr":{"!type":"fn()","!doc":"Hook to make attr(&quot;value&quot;) work"},"setValue":{"!type":"fn(html: string)","!doc":"This function sets the content. No undo history is preserved.\nUsers should use attr('value', ...) instead."},"replaceValue":{"!type":"fn(html: string)","!doc":"This function set the content while trying to maintain the undo stack\n(now only works fine with Moz, this is identical to setValue in all\nother browsers)"},"_preFilterContent":{"!type":"fn(html: string)","!doc":"Filter the input before setting the content of the editing\narea. DOM pre-filtering may happen after this\nstring-based filtering takes place but as of 1.2, this is not\nguaranteed for operations such as the inserthtml command."},"_preDomFilterContent":{"!type":"fn(dom: +Node)","!doc":"filter the input's live DOM. All filter operations should be\nconsidered to be &quot;live&quot; and operating on the DOM that the user\nwill be interacting with in their editing session."},"_postFilterContent":{"!type":"fn(dom?: +DomNode, nonDestructive?: bool)","!doc":"filter the output after getting the content of the editing area"},"_saveContent":{"!type":"fn(e: +Event)","!doc":"Saves the content in an onunload event if the editor has not been closed"},"escapeXml":{"!type":"fn(str: string, noSingleQuotes: bool) -> string","!doc":"Adds escape sequences for special characters in XML: &amp;&lt;&gt;&quot;'\nOptionally skips escapes for single quotes"},"getNodeHtml":{"!type":"fn(node: +Node) -> string","!doc":"Deprecated.   Use dijit._editor._getNodeHtml() instead."},"getNodeChildrenHtml":{"!type":"fn(dom: +Node)","!doc":"Deprecated.   Use dijit._editor.getChildrenHtml() instead."},"close":{"!type":"fn(save: bool)","!doc":"Kills the editor and optionally writes back the modified contents to the\nelement from which it originated."},"destroyRendering":{"!type":"fn()","!doc":"stub"},"destroy":{"!type":"fn()"},"_removeMozBogus":{"!type":"fn(html: string) -> string","!doc":"Post filter to remove unwanted HTML attributes generated by mozilla"},"_removeSafariBogus":{"!type":"fn(html: string) -> string","!doc":"Post filter to remove unwanted HTML attributes generated by webkit"},"_fixContentForMoz":{"!type":"fn(html: string)","!doc":"Pre-filter for mozilla."},"_preFixUrlAttributes":{"!type":"fn(html: string)","!doc":"Pre-filter to do fixing to href attributes on &lt;a&gt; and &lt;img&gt; tags"}}},"plugins":{"AlwaysShowToolbar":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"For auto-expanding editors, this plugin will keep the\neditor's toolbar visible even when the top of the editor\nhas scrolled off the top of the viewport (usually when editing a long\ndocument).","_handleScroll":{"!doc":"Enables/disables the handler for scroll events","!type":"bool"},"_lastHeight":{"!doc":"Height in px of the editor at the last time we did sizing","!type":"+Integer"},"setEditor":{"!type":"fn(e: ?)"},"enable":{"!type":"fn(d: ?)","!doc":"Enable plugin.  Called when Editor has finished initializing."},"_updateHeight":{"!type":"fn()","!doc":"Updates the height of the editor area to fit the contents."},"globalOnScrollHandler":{"!type":"fn()","!doc":"Handler for scroll events that bubbled up to &lt;html&gt;"},"destroy":{"!type":"fn()"}}},"EnterKeyHandling":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"This plugin tries to make all browsers have identical behavior\nwhen the user presses the ENTER key.\nSpecifically, it fixes the double-spaced line problem on IE.","blockNodeForEnter":{"!doc":"this property decides the behavior of Enter key. It can be either P,\nDIV, BR, or empty (which means disable this feature). Anything else\nwill trigger errors.","!type":"string"},"bogusHtmlContent":{"!doc":"HTML to stick into a new empty block","!type":"string"},"blockNodes":{"!doc":"Regex for testing if a given tag is a block level (display:block) tag","!type":"+Regex"},"constructor":{"!type":"fn(args: ?)"},"setEditor":{"!type":"fn(editor: ?)"},"onKeyPressed":{"!type":"fn(e: ?)","!doc":"Handler for keypress events."},"handleEnterKey":{"!type":"fn(e: ?)","!doc":"Handler for enter key events."},"removeTrailingBr":{"!type":"fn(container: ?)","!doc":"If last child of container is a &lt;br&gt;, then remove it."},"_fixNewLineBehaviorForIE":{"!type":"fn(d: ?) -> +HTMLStyleElement","!doc":"Insert CSS so &lt;p&gt; nodes don't have spacing around them,\nthus hiding the fact that ENTER key on IE is creating new\nparagraphs"},"regularPsToSingleLinePs":{"!type":"fn(element: ?, noWhiteSpaceInEmptyP: ?)","!doc":"Converts a &lt;p&gt; node containing &lt;br&gt;'s into multiple &lt;p&gt; nodes."},"singleLinePsToRegularPs":{"!type":"fn(element: ?)","!doc":"Called as post-filter.\nApparently collapses adjacent &lt;p&gt; nodes into a single &lt;p&gt;\nnodes with &lt;br&gt; separating each line."}}},"FontChoice":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"This plugin provides three dropdowns for setting font information in the editor","_uniqueId":{"!type":"number"},"useDefaultCommand":{"!type":"bool"},"_initButton":{"!type":"fn()"},"updateState":{"!type":"fn()"},"setToolbar":{"!type":"fn()"}},"buttonClass":{}},"LinkDialog":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"This plugin provides dialogs for inserting links and images into the editor","useDefaultCommand":{"!type":"bool"},"urlRegExp":{"!doc":"Used for validating input as correct URL","!type":"string"},"linkDialogTemplate":{"!doc":"Template for contents of TooltipDialog to pick URL\n,\n\n//TODO we don't show this state anymore\nupdateState: function(){\n// summary: change shading on button if we are over a link (or not)\n\nvar _e = this.editor;\nif(!_e || !_e.isLoaded){ return; }\nif(this.button){\n// display button differently if there is an existing link associated with the current selection\nvar hasA = dojo.withGlobal(this.editor.window, &quot;hasAncestorElement&quot;, dijit._editor.selection, [this.tag]);\nthis.button.attr('checked', hasA);\n}\n}","!type":"string"},"_initButton":{"!type":"fn()"},"_setContent":{"!type":"fn(staticPanel: ?)","!doc":"Helper for _initButton above.   Not sure why it's a separate method."},"setValue":{"!type":"fn(args: ?)","!doc":"Callback from the dialog when user presses &quot;set&quot; button."},"_onCloseDialog":{"!type":"fn()","!doc":"Handler for close event on the dialog"},"_onOpenDialog":{"!type":"fn()","!doc":"Handler for when the dialog is opened.\nIf the caret is currently in a URL then populate the URL's info into the dialog."}},"buttonClass":{}},"TabIndent":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"This plugin is used to allow the use of the tab and shift-tab keys\nto indent/outdent list items.  This overrides the default behavior\nof moving focus from/to the toolbar","useDefaultCommand":{"!type":"bool"},"command":{"!type":"string"},"_initButton":{"!type":"fn()"},"updateState":{"!type":"fn()"}},"buttonClass":{}},"TextColor":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"This plugin provides dropdown color pickers for setting text color and background color","constructor":{"!type":"fn()"}},"buttonClass":{}},"ToggleDir":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"This plugin is used to toggle direction of the edited document,\nindependent of what direction the whole page is.","useDefaultCommand":{"!type":"bool"},"command":{"!type":"string"},"_initButton":{"!type":"fn()"},"updateState":{"!type":"fn()"},"_toggleDir":{"!type":"fn()","!doc":"Handler for button click events, to switch the text direction of the editor"}},"buttonClass":{}}},"selection":{"getType":{"!type":"fn()","!doc":"Get the selection type (like dojo.doc.select.type in IE)."},"getSelectedText":{"!type":"fn()","!doc":"Return the text (no html tags) included in the current selection or null if no text is selected"},"getSelectedHtml":{"!type":"fn()","!doc":"Return the html of the current selection or null if unavailable"},"getSelectedElement":{"!type":"fn()","!doc":"Retrieves the selected element (if any), just in the case that\na single element (object like and image or a table) is\nselected."},"getParentElement":{"!type":"fn()","!doc":"Get the parent element of the current selection"},"hasAncestorElement":{"!type":"fn(tagName: string)","!doc":"Check whether current selection has a  parent element which is\nof type tagName (or one of the other specified tagName)"},"getAncestorElement":{"!type":"fn(tagName: string)","!doc":"Return the parent element of the current selection which is of\ntype tagName (or one of the other specified tagName)"},"isTag":{"!type":"fn(node: +Node, tags: [])"},"getParentOfType":{"!type":"fn(node: +Node, tags: [])"},"collapse":{"!type":"fn(beginning: bool)","!doc":"clear current selection"},"remove":{"!type":"fn()","!doc":"delete current selection"},"selectElementChildren":{"!type":"fn(element: +Node, nochangefocus?: bool)","!doc":"clear previous selection and select the content of the node\n(excluding the node itself)"},"selectElement":{"!type":"fn(element: +Node, nochangefocus?: bool)","!doc":"clear previous selection and select element (including all its children)"}}},"InlineEditBox":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"An element with in-line edit capabilitites","editing":{"!doc":"Is the node currently in edit mode?","!type":"bool"},"autoSave":{"!doc":"Changing the value automatically saves it; don't have to push save button\n(and save button isn't even displayed)","!type":"bool"},"buttonSave":{"!doc":"Save button label","!type":"string"},"buttonCancel":{"!doc":"Cancel button label","!type":"string"},"renderAsHtml":{"!doc":"Set this to true if the specified Editor's value should be interpreted as HTML\nrather than plain text (ex: <code>dijit.Editor</code>)","!type":"bool"},"editor":{"!doc":"Class name for Editor widget","!type":"string"},"editorParams":{"!doc":"Set of parameters for editor, like {required: true}"},"width":{"!doc":"Width of editor.  By default it's width=100% (ie, block mode).","!type":"string"},"value":{"!doc":"The display value of the widget in read-only mode","!type":"string"},"noValueIndicator":{"!doc":"The text that gets displayed when there is no value (so that the user has a place to click to edit)","!type":"string"},"onChange":{"!type":"fn(value: ?)","!doc":"Set this handler to be notified of changes to value."},"onCancel":{"!type":"fn()","!doc":"Set this handler to be notified when editing is cancelled."},"constructor":{"!type":"fn()","!doc":"Sets up private arrays etc."},"postMixInProperties":{"!type":"fn()"},"setDisabled":{"!type":"fn(disabled: bool)","!doc":"Deprecated.   Use attr('disable', ...) instead."},"_setDisabledAttr":{"!type":"fn(disabled: bool)","!doc":"Hook to make attr(&quot;disabled&quot;, ...) work.\nSet disabled state of widget."},"_onMouseOver":{"!type":"fn()","!doc":"Handler for onmouseover event."},"_onMouseOut":{"!type":"fn()","!doc":"Handler for onmouseout event."},"_onClick":{"!type":"fn(e: +Event)","!doc":"Handler for onclick event."},"edit":{"!type":"fn()","!doc":"Display the editor widget in place of the original (read only) markup."},"_showText":{"!type":"fn(focus: bool)","!doc":"Revert to display mode, and optionally focus on display node"},"save":{"!type":"fn(focus: bool)","!doc":"Save the contents of the editor and revert to display mode."},"setValue":{"!type":"fn(val: string)","!doc":"Deprecated.   Use attr('value', ...) instead."},"_setValueAttr":{"!type":"fn(val: string)","!doc":"Hook to make attr(&quot;value&quot;, ...) work.\nInserts specified HTML value into this node, or an &quot;input needed&quot; character if node is blank."},"getValue":{"!type":"fn()","!doc":"Deprecated.   Use attr('value') instead."},"cancel":{"!type":"fn(focus: bool)","!doc":"Revert to display mode, discarding any changes made in the editor"}}},"_InlineEditor":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Internal widget used by InlineEditBox, displayed when in editing mode\nto display the editor and maybe save/cancel buttons.  Calling code should\nconnect to save/cancel methods to detect when editing is finished\n\nHas mainly the same parameters as InlineEditBox, plus these values:\n\nstyle: Object\nSet of CSS attributes of display node, to replicate in editor\n\nvalue: String\nValue as an HTML string or plain text string, depending on renderAsHTML flag","templatePath":{},"widgetsInTemplate":{"!type":"bool"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"getValue":{"!type":"fn()","!doc":"Return the [display] value of the edit widget"},"_onKeyPress":{"!type":"fn(e: ?)","!doc":"Handler for keypress in the edit box (see template)."},"_onBlur":{"!type":"fn()","!doc":"Called when focus moves outside the editor"},"_onChange":{"!type":"fn()","!doc":"Called when the underlying widget fires an onChange event,\nwhich means that the user has finished entering the value"},"enableSave":{"!type":"fn()","!doc":"User overridable function returning a Boolean to indicate\nif the Save button should be enabled or not - usually due to invalid conditions"},"focus":{"!type":"fn()","!doc":"Focus on the edit widget."}}},"_MenuBase":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Base class for Menu and MenuBar","parentMenu":{"!doc":"pointer to menu that displayed me","!type":"+dijit._Widget"},"popupDelay":{"!doc":"number of milliseconds before hovering (without clicking) causes the popup to automatically open.","!type":"+Integer"},"startup":{"!type":"fn()"},"onExecute":{"!type":"fn()","!doc":"Attach point for notification about when a menu item has been executed.\nThis is an internal mechanism used for Menus to signal to their parent to\nclose them, because they are about to execute the onClick handler.   In\ngeneral developers should not attach to or override this method."},"onCancel":{"!type":"fn(closeAll: bool)","!doc":"Attach point for notification about when the user cancels the current menu\nThis is an internal mechanism used for Menus to signal to their parent to\nclose them.  In general developers should not attach to or override this method."},"_moveToPopup":{"!type":"fn(evt: +Event)","!doc":"This handles the right arrow key (left arrow key on RTL systems),\nwhich will either open a submenu, or move to the next item in the\nancestor MenuBar"},"onItemHover":{"!type":"fn(item: +MenuItem)","!doc":"Called when cursor is over a MenuItem."},"_onChildBlur":{"!type":"fn(item: ?)","!doc":"Called when a child MenuItem becomes inactive because focus\nhas been removed from the MenuItem *and* it's descendant menus."},"onItemUnhover":{"!type":"fn(item: +MenuItem)","!doc":"Callback fires when mouse exits a MenuItem"},"_stopPopupTimer":{"!type":"fn()","!doc":"Cancels the popup timer because the user has stop hovering\non the MenuItem, etc."},"_getTopMenu":{"!type":"fn()","!doc":"Returns the top menu in this chain of Menus"},"onItemClick":{"!type":"fn(item: +dijit._Widget, evt: +Event)","!doc":"Handle clicks on an item."},"_openPopup":{"!type":"fn()","!doc":"Open the popup to the side of/underneath the current menu item"},"onOpen":{"!type":"fn(e: +Event)","!doc":"Callback when this menu is opened.\nThis is called by the popup manager as notification that the menu\nwas opened."},"onClose":{"!type":"fn()","!doc":"Callback when this menu is closed.\nThis is called by the popup manager as notification that the menu\nwas closed."},"_onFocus":{"!type":"fn()","!doc":"Called when this Menu gets focus from:\n1) clicking it\n2) tabbing into it\n3) being opened by a parent menu.\nThis is not called just from mouse hover."},"_onBlur":{"!type":"fn()","!doc":"Called when focus is moved away from this Menu and it's submenus."},"_onDescendantExecute":{"!type":"fn()","!doc":"Called when submenu is clicked.  Close hierarchy of menus."}}},"Menu":{"!type":"fn()","prototype":{"!proto":"dijit._MenuBase.prototype","templatePath":{},"targetNodeIds":{"!doc":"Array of dom node ids of nodes to attach to.\nFill this with nodeIds upon widget creation and it becomes context menu for those nodes.","!type":"[string]"},"contextMenuForWindow":{"!doc":"If true, right clicking anywhere on the window will cause this context menu to open.\nIf false, must specify targetNodeIds.","!type":"bool"},"leftClickToOpen":{"!doc":"If true, menu will open on left click instead of right click, similiar to a file menu.","!type":"bool"},"_contextMenuWithMouse":{"!doc":"Used to record mouse and keyboard events to determine if a context\nmenu is being opened with the keyboard or the mouse.","!type":"bool"},"constructor":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"_onKeyPress":{"!type":"fn(evt: +Event)","!doc":"Handle keyboard based menu navigation."},"_iframeContentWindow":{"!type":"fn(iframe_el: +HTMLIFrameElement) -> +Window","!doc":"Returns the window reference of the passed iframe"},"_iframeContentDocument":{"!type":"fn(iframe_el: +HTMLIFrameElement) -> +HTMLDocument","!doc":"Returns a reference to the document object inside iframe_el"},"bindDomNode":{"!type":"fn(node: string)","!doc":"Attach menu to given node"},"unBindDomNode":{"!type":"fn(nodeName: string)","!doc":"Detach menu from given node"},"_contextKey":{"!type":"fn(e: ?)","!doc":"Code to handle popping up editor using F10 key rather than mouse"},"_contextMouse":{"!type":"fn(e: ?)","!doc":"Helper to remember when we opened the context menu with the mouse instead\nof with the keyboard"},"_openMyself":{"!type":"fn(e: +Event)","!doc":"Internal function for opening myself when the user\ndoes a right-click or something similar"},"uninitialize":{"!type":"fn()"},"getPlaceholders":{"!type":"fn(label?: string) -> [+dojox.widget.PlaceholderMenuItem]","!doc":"returns an array of placeholders with the given label.  There\ncan be multiples."}}},"MenuBar":{"!type":"fn()","prototype":{"!proto":"dijit._MenuBase.prototype","!doc":"A menu bar, listing menu choices horizontally, like the \"File\" menu in most desktop applications","templatePath":{},"_isMenuBar":{"!doc":"This is a MenuBar widget, not a (vertical) Menu widget.","!type":"bool"},"constructor":{"!type":"fn()","!doc":"Sets up local variables etc."},"postCreate":{"!type":"fn()"},"focusChild":{"!type":"fn(item: ?)"},"_onKeyPress":{"!type":"fn(evt: +Event)","!doc":"Handle keyboard based menu navigation."}}},"_MenuBarItemMixin":{"!type":"fn()","prototype":{"templatePath":{},"attributeMap":{}}},"MenuBarItem":{"!type":"fn()","prototype":{"!proto":"dijit.MenuItem.prototype","!doc":"Item in a MenuBar that's clickable, and doesn't spawn a submenu when pressed (or hovered)"}},"MenuItem":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A line item in a Menu Widget","templatePath":{},"attributeMap":{},"label":{"!doc":"Menu text","!type":"string"},"iconClass":{"!doc":"Class to apply to DOMNode to make it display an icon.","!type":"string"},"accelKey":{"!doc":"Text for the accelerator (shortcut) key combination.\nNote that although Menu can display accelerator keys there\nis no infrastructure to actually catch and execute these\naccelerators.","!type":"string"},"disabled":{"!doc":"If true, the menu item is disabled.\nIf false, the menu item is enabled.","!type":"bool"},"_fillContent":{"!type":"fn(source: +Node)"},"postCreate":{"!type":"fn()"},"_onHover":{"!type":"fn()","!doc":"Handler when mouse is moved onto menu item"},"_onUnhover":{"!type":"fn()","!doc":"Handler when mouse is moved off of menu item,\npossibly to a child menu, or maybe to a sibling\nmenuitem or somewhere else entirely."},"_onClick":{"!type":"fn(evt: ?)","!doc":"Internal handler for click events on MenuItem."},"onClick":{"!type":"fn(evt: +Event)","!doc":"User defined function to handle clicks"},"focus":{"!type":"fn()","!doc":"Focus on this MenuItem"},"_onFocus":{"!type":"fn()","!doc":"This is called by the focus manager when focus\ngoes to this MenuItem or a child menu."},"_setSelected":{"!type":"fn(selected: ?)","!doc":"Indicate that this node is the currently selected one"},"setLabel":{"!type":"fn(content: string)","!doc":"Deprecated.   Use attr('label', ...) instead."},"setDisabled":{"!type":"fn(disabled: bool)","!doc":"Deprecated.   Use attr('disabled', bool) instead."},"_setDisabledAttr":{"!type":"fn(value: bool)","!doc":"Hook for attr('disabled', ...) to work.\nEnable or disable this menu item."},"_setAccelKeyAttr":{"!type":"fn(value: string)","!doc":"Hook for attr('accelKey', ...) to work.\nSet accelKey on this menu item."}}},"MenuSeparator":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A line between two menu items","templatePath":{},"postCreate":{"!type":"fn()"},"isFocusable":{"!type":"fn() -> bool","!doc":"Override to always return false"}}},"PopupMenuBarItem":{"!type":"fn()","prototype":{"!proto":"dijit.PopupMenuItem.prototype","!doc":"Item in a MenuBar like \"File\" or \"Edit\", that spawns a submenu when pressed (or hovered)"}},"PopupMenuItem":{"!type":"fn()","prototype":{"!proto":"dijit.MenuItem.prototype","_fillContent":{"!type":"fn()","!doc":"When Menu is declared in markup, this code gets the menu label and\nthe popup widget from the srcNodeRef."},"startup":{"!type":"fn()"},"destroyDescendants":{"!type":"fn()"}}},"ProgressBar":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A progress indication widget, showing the amount completed\n(often the percentage completed) of a task.","progress":{"!doc":"(Percentage or Number)\nNumber or percentage indicating amount of task completed.\nWith &quot;%&quot;: percentage value, 0% &lt;= progress &lt;= 100%, or\nwithout &quot;%&quot;: absolute value, 0 &lt;= progress &lt;= maximum\nTODO: rename to value for 2.0","!type":"string"},"maximum":{"!doc":"Max sample number","!type":"+Float"},"places":{"!doc":"Number of places to show in values; 0 by default","!type":"number"},"indeterminate":{"!doc":"If false: show progress value (number or percentage).\nIf true: show that a process is underway but that the amount completed is unknown.","!type":"bool"},"templatePath":{},"_indeterminateHighContrastImagePath":{"!doc":"URL to image to use for indeterminate progress bar when display is in high contrast mode","!type":"+dojo._URL"},"postCreate":{"!type":"fn()"},"update":{"!type":"fn(attributes?: ?)","!doc":"Change attributes of ProgressBar, similar to attr(hash)."},"report":{"!type":"fn(percent: +float)","!doc":"Generates message to show inside progress bar (normally indicating amount of task completed).\nMay be overridden."},"onChange":{"!type":"fn()","!doc":"Callback fired when progress updates."}}},"TitlePane":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"A pane with a title on top, that can be expanded or collapsed.","title":{"!doc":"Title of the pane","!type":"string"},"open":{"!doc":"Whether pane is opened or closed.","!type":"bool"},"baseClass":{"!doc":"The root className to use for the various states of this widget","!type":"string"},"templatePath":{},"attributeMap":{},"postCreate":{"!type":"fn()"},"_setOpenAttr":{"!type":"fn(open: bool)","!doc":"Hook to make attr(&quot;open&quot;, boolean) control the open/closed state of the pane."},"_setContentAttr":{"!type":"fn(content: ?)","!doc":"Hook to make attr(&quot;content&quot;, ...) work.\nTypically called when an href is loaded.  Our job is to make the animation smooth."},"toggle":{"!type":"fn()","!doc":"Switches between opened and closed state"},"_setCss":{"!type":"fn()","!doc":"Set the open/close css state for the TitlePane"},"_onTitleKey":{"!type":"fn(e: +Event)","!doc":"Handler for when user hits a key"},"_onTitleEnter":{"!type":"fn()","!doc":"Handler for when someone hovers over my title"},"_onTitleLeave":{"!type":"fn()","!doc":"Handler when someone stops hovering over my title"},"_handleFocus":{"!type":"fn(e: +Event)","!doc":"Handle blur and focus for this widget"},"setTitle":{"!type":"fn(title: string)","!doc":"Deprecated.  Use attr('title', ...) instead."}},"duration":{"!doc":"Time in milliseconds to fade in/fade out","!type":"+Integer"}},"Toolbar":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A Toolbar widget, used to hold things like `dijit.Editor` buttons","templateString":{"!type":"string"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"}}},"ToolbarSeparator":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A spacer between two `dijit.Toolbar` items","templateString":{"!type":"string"},"postCreate":{"!type":"fn()"},"isFocusable":{"!type":"fn()","!doc":"This widget isn't focusable, so pass along that fact."}}},"_MasterTooltip":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Internal widget that holds the actual tooltip markup,\nwhich occurs once per page.\nCalled by Tooltip widgets which are just containers to hold\nthe markup","templatePath":{},"postCreate":{"!type":"fn()"},"show":{"!type":"fn(innerHTML: string, aroundNode: +Node, position?: [string])","!doc":"Display tooltip w/specified contents to right of specified node\n(To left if there's no space on the right, or if LTR==right)"},"orient":{"!type":"fn(node: +Node, aroundCorner: string, tooltipCorner: string)","!doc":"Private function to set CSS for tooltip node based on which position it's in.\nThis is called by the dijit popup code."},"_onShow":{"!type":"fn()","!doc":"Called at end of fade-in operation"},"hide":{"!type":"fn(aroundNode: ?)","!doc":"Hide the tooltip"},"_onHide":{"!type":"fn()","!doc":"Called at end of fade-out operation"}},"duration":{"!doc":"Milliseconds to fade in/fade out","!type":"+Integer"}},"Tooltip":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","label":{"!doc":"Text to display in the tooltip.\nSpecified as innerHTML when creating the widget from markup.","!type":"string"},"showDelay":{"!doc":"Number of milliseconds to wait after hovering over/focusing on the object, before\nthe tooltip is displayed.","!type":"+Integer"},"connectId":{"!doc":"Id's of domNodes to attach the tooltip to.\nWhen user hovers over any of the specified dom nodes, the tooltip will appear.\n\nNote: Currently connectId can only be specified on initialization, it cannot\nbe changed via attr('connectId', ...)\n\nNote: in 2.0 this will be renamed to connectIds for less confusion.","!type":"[string]"},"position":{"!doc":"See description of <code>dijit.Tooltip.defaultPosition</code> for details on position parameter.","!type":"[string]"},"_setConnectIdAttr":{"!type":"fn(ids: ?)"},"postCreate":{"!type":"fn()"},"_onTargetMouseEnter":{"!type":"fn(e: +Event)","!doc":"Handler for mouseenter event on the target node"},"_onTargetMouseLeave":{"!type":"fn(e: +Event)","!doc":"Handler for mouseleave event on the target node"},"_onTargetFocus":{"!type":"fn(e: +Event)","!doc":"Handler for focus event on the target node"},"_onTargetBlur":{"!type":"fn(e: +Event)","!doc":"Handler for blur event on the target node"},"_onHover":{"!type":"fn(e: +Event)","!doc":"Despite the name of this method, it actually handles both hover and focus\nevents on the target node, setting a timer to show the tooltip."},"_onUnHover":{"!type":"fn(e: +Event)","!doc":"Despite the name of this method, it actually handles both mouseleave and blur\nevents on the target node, hiding the tooltip."},"open":{"!type":"fn(target: +Node)","!doc":"Display the tooltip; usually not called directly."},"close":{"!type":"fn()","!doc":"Hide the tooltip or cancel timer for show of tooltip"},"uninitialize":{"!type":"fn()"}},"defaultPosition":{"!type":"[]"}},"TooltipDialog":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"Pops up a dialog that appears like a Tooltip","title":{"!doc":"Description of tooltip dialog (required for a11y)","!type":"string"},"doLayout":{"!doc":"Don't change this parameter from the default value.\nThis ContentPane parameter doesn't make sense for TooltipDialog, since TooltipDialog\nis never a child of a layout container, nor can you specify the size of\nTooltipDialog in order to control the size of an inner widget.","!type":"bool"},"autofocus":{"!doc":"A Toggle to modify the default focus behavior of a Dialog, which\nis to focus on the first dialog element after opening the dialog.\nFalse will disable autofocusing. Default: true","!type":"bool"},"baseClass":{"!doc":"The root className to use for the various states of this widget","!type":"string"},"_firstFocusItem":{"!doc":"DomNode\nThe pointer to the first focusable node in the dialog.\nSet by <code>dijit._DialogMixin._getFocusItems</code>.","!type":"+[readonly]"},"_lastFocusItem":{"!doc":"DomNode\nThe pointer to which node has focus prior to our dialog.\nSet by <code>dijit._DialogMixin._getFocusItems</code>.","!type":"+[readonly]"},"templateString":{},"templatePath":{},"postCreate":{"!type":"fn()"},"orient":{"!type":"fn(node: +Node, aroundCorner: string, corner: string)","!doc":"Configure widget to be displayed in given position relative to the button.\nThis is called from the dijit.popup code, and should not be called\ndirectly."},"onOpen":{"!type":"fn(pos: ?)","!doc":"Called when dialog is displayed.\nThis is called from the dijit.popup code, and should not be called directly."},"onClose":{"!type":"fn()","!doc":"Called when dialog is hidden.\nThis is called from the dijit.popup code, and should not be called directly."},"_onKey":{"!type":"fn(evt: +Event)","!doc":"Handler for keyboard events"}}},"_TreeNode":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Single node within a tree.   This class is used internally\nby Tree and should not be accessed directly.","item":{"!doc":"the dojo.data entry this tree represents","!type":"+dojo.data.Item"},"isTreeNode":{"!doc":"Indicates that this is a TreeNode.   Used by <code>dijit.Tree</code> only,\nshould not be accessed directly.","!type":"bool"},"label":{"!doc":"Text of this tree node","!type":"string"},"isExpandable":{"!doc":"This node has children, so show the expando node (+ sign)","!type":"bool"},"isExpanded":{"!doc":"This node is currently expanded (ie, opened)","!type":"bool"},"state":{"!doc":"Dynamic loading-related stuff.\nWhen an empty folder node appears, it is &quot;UNCHECKED&quot; first,\nthen after dojo.data query it becomes &quot;LOADING&quot; and, finally &quot;LOADED&quot;","!type":"string"},"templatePath":{},"indent":{"!doc":"Levels from this node to the root node","!type":"+Integer"},"postCreate":{"!type":"fn()"},"_setIndentAttr":{"!type":"fn(indent: ?)","!doc":"Tell this node how many levels it should be indented"},"markProcessing":{"!type":"fn()","!doc":"Visually denote that tree is loading data, etc."},"unmarkProcessing":{"!type":"fn()","!doc":"Clear markup from markProcessing() call"},"_updateItemClasses":{"!type":"fn(item: ?)","!doc":"Set appropriate CSS classes for icon and label dom node\n(used to allow for item updates to change respective CSS)"},"_updateLayout":{"!type":"fn()","!doc":"Set appropriate CSS classes for this.domNode"},"_setExpando":{"!type":"fn(processing: bool)","!doc":"Set the right image for the expando node"},"expand":{"!type":"fn()","!doc":"Show my children"},"collapse":{"!type":"fn()","!doc":"Collapse this node (if it's expanded)"},"setLabelNode":{"!type":"fn(label: ?)","!doc":"Sets the label"},"setChildItems":{"!type":"fn(items: [+Object])","!doc":"Sets the child items of this node, removing/adding nodes\nfrom current children to match specified items[] array."},"removeChild":{"!type":"fn(node: +treeNode)"},"makeExpandable":{"!type":"fn()","!doc":"if this node wasn't already showing the expando node,\nturn it into one and call _setExpando()"},"_onLabelFocus":{"!type":"fn(evt: ?)","!doc":"Called when this node is focused (possibly programatically)"},"_onLabelBlur":{"!type":"fn(evt: ?)","!doc":"Called when focus was moved away from this node, either to\nanother TreeNode or away from the Tree entirely.\nNote that we aren't using _onFocus/_onBlur builtin to dijit\nbecause _onBlur() isn't called when focus is moved to my child TreeNode."},"setSelected":{"!type":"fn(selected: bool)","!doc":"A Tree has a (single) currently selected node.\nMark that this node is/isn't that currently selected node."},"_onMouseEnter":{"!type":"fn(evt: ?)","!doc":"Handler for onmouseenter event on a node"},"_onMouseLeave":{"!type":"fn(evt: ?)","!doc":"Handler for onmouseenter event on a node"}}},"Tree":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"This widget displays hierarchical data from a store.","store":{"!doc":"Deprecated.  Use &quot;model&quot; parameter instead.\nThe store to get data to display in the tree.","!type":"string"},"model":{"!doc":"Interface to read tree data, get notifications of changes to tree data,\nand for handling drop operations (i.e drag and drop onto the tree)","!type":"+dijit.Tree.model"},"query":{"!doc":"Deprecated.  User should specify query to the model directly instead.\nSpecifies datastore query to return the root item or top items for the tree.","!type":"+anything"},"label":{"!doc":"Deprecated.  Use dijit.tree.ForestStoreModel directly instead.\nUsed in conjunction with query parameter.\nIf a query is specified (rather than a root node id), and a label is also specified,\nthen a fake root node is created and displayed, with this label.","!type":"string"},"showRoot":{"!doc":"Should the root node be displayed, or hidden?","!type":"bool"},"childrenAttr":{"!doc":"Deprecated.   This information should be specified in the model.\nOne ore more attributes that holds children of a tree node","!type":"[string]"},"openOnClick":{"!doc":"If true, clicking a folder node's label will open it, rather than calling onClick()","!type":"bool"},"openOnDblClick":{"!doc":"If true, double-clicking a folder node's label will open it, rather than calling onDblClick()","!type":"bool"},"templatePath":{},"persist":{"!doc":"Enables/disables use of cookies for state saving.","!type":"bool"},"dndController":{"!doc":"Class name to use as as the dnd controller.  Specifying this class enables DnD.\nGenerally you should specify this as &quot;dijit.tree.dndSource&quot;.","!type":"string"},"dndParams":{"!type":"[]"},"dragThreshold":{"!doc":"Number of pixels mouse moves before it's considered the start of a drag operation","!type":"+Integer"},"betweenThreshold":{"!doc":"Set to a positive value to allow drag and drop &quot;between&quot; nodes.\n\nIf during DnD mouse is over a (target) node but less than betweenThreshold\npixels from the bottom edge, dropping the the dragged node will make it\nthe next sibling of the target node, rather than the child.\n\nSimilarly, if mouse is over a target node but less that betweenThreshold\npixels from the top edge, dropping the dragged node will make it\nthe target node's previous sibling rather than the target node's child.","!type":"+Integer"},"onDndDrop":{"!type":"fn()","!doc":"Parameter to dndController, see <code>dijit.tree.dndSource.onDndDrop</code>.\nGenerally this doesn't need to be set."},"itemCreator":{"!type":"fn()","!doc":"Parameter to dndController, see <code>dijit.tree.dndSource.itemCreator</code>.\nGenerally this doesn't need to be set."},"onDndCancel":{"!type":"fn()","!doc":"Parameter to dndController, see <code>dijit.tree.dndSource.onDndCancel</code>.\nGenerally this doesn't need to be set."},"checkAcceptance":{"!type":"fn(source: +dijit.tree._dndSource, nodes: [+DOMNode]) -> bool","!doc":"Checks if the Tree itself can accept nodes from this source"},"checkItemAcceptance":{"!type":"fn(target: +Node, source: +dijit.tree.dndSource, position: string) -> bool","!doc":"Stub function to be overridden if one wants to check for the ability to drop at the node/item level"},"_publish":{"!type":"fn(topicName: string, message: ?)","!doc":"Publish a message for this widget/topic"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"_store2model":{"!type":"fn()","!doc":"User specified a store&amp;query rather than model, so create model from store/query"},"_load":{"!type":"fn()","!doc":"Initial load of the tree.\nLoad root node (possibly hidden) and it's children."},"mayHaveChildren":{"!type":"fn(item: +dojo.data.Item)","!doc":"Deprecated.   This should be specified on the model itself.\n\nOverridable function to tell if an item has or may have children.\nControls whether or not +/- expando icon is shown.\n(For efficiency reasons we may not want to check if an element actually\nhas children until user clicks the expando node)"},"getItemChildren":{"!type":"fn(parentItem: +dojo.data.Item, onComplete: fn(items))","!doc":"Deprecated.   This should be specified on the model itself.\n\nOverridable function that return array of child items of given parent item,\nor if parentItem==null then return top items in tree"},"getLabel":{"!type":"fn(item: +dojo.data.Item) -> string","!doc":"Overridable function to get the label for a tree node (given the item)"},"getIconClass":{"!type":"fn(item: +dojo.data.Item, opened: bool)","!doc":"Overridable function to return CSS class name to display icon"},"getLabelClass":{"!type":"fn(item: +dojo.data.Item, opened: bool)","!doc":"Overridable function to return CSS class name to display label"},"getIconStyle":{"!type":"fn(item: +dojo.data.Item, opened: bool)","!doc":"Overridable function to return CSS styles to display icon"},"getLabelStyle":{"!type":"fn(item: +dojo.data.Item, opened: bool)","!doc":"Overridable function to return CSS styles to display label"},"_onKeyPress":{"!type":"fn(e: +Event)","!doc":"Translates keypress events into commands for the controller"},"_onEnterKey":{"!type":"fn(message: ?)"},"_onDownArrow":{"!type":"fn(message: ?)","!doc":"down arrow pressed; get next visible node, set focus there"},"_onUpArrow":{"!type":"fn(message: ?)","!doc":"Up arrow pressed; move to previous visible node"},"_onRightArrow":{"!type":"fn(message: ?)","!doc":"Right arrow pressed; go to child node"},"_onLeftArrow":{"!type":"fn(message: ?)","!doc":"Left arrow pressed.\nIf not collapsed, collapse, else move to parent."},"_onHomeKey":{"!type":"fn()","!doc":"Home key pressed; get first visible node, and set focus there"},"_onEndKey":{"!type":"fn(message: ?)","!doc":"End key pressed; go to last visible node."},"_onLetterKeyNav":{"!type":"fn(message: ?)","!doc":"Letter key pressed; search for node starting with first char = key"},"_onClick":{"!type":"fn(e: +Event)","!doc":"Translates click events into commands for the controller to process"},"_onDblClick":{"!type":"fn(e: +Event)","!doc":"Translates double-click events into commands for the controller to process"},"_onExpandoClick":{"!type":"fn(message: ?)","!doc":"User clicked the +/- icon; expand or collapse my children."},"onClick":{"!type":"fn(item: +dojo.data, node: +TreeNode)","!doc":"Callback when a tree node is clicked"},"onDblClick":{"!type":"fn(item: +dojo.data, node: +TreeNode)","!doc":"Callback when a tree node is double-clicked"},"onOpen":{"!type":"fn(item: +dojo.data, node: +TreeNode)","!doc":"Callback when a node is opened"},"onClose":{"!type":"fn(item: +dojo.data, node: +TreeNode)","!doc":"Callback when a node is closed"},"_getNextNode":{"!type":"fn(node: ?) -> +_TreeNode","!doc":"Get next visible node"},"_getRootOrFirstNode":{"!type":"fn()","!doc":"Get first visible node"},"_collapseNode":{"!type":"fn(node: +_TreeNode)","!doc":"Called when the user has requested to collapse the node"},"_expandNode":{"!type":"fn(node: +_TreeNode)","!doc":"Called when the user has requested to expand the node"},"focusNode":{"!type":"fn(node: +_tree.Node)","!doc":"Focus on the specified node (which must be visible)"},"_onNodeFocus":{"!type":"fn(node: +dijit._Widget)","!doc":"Called when a TreeNode gets focus, either by user clicking\nit, or programatically by arrow key handling code."},"_onNodeMouseEnter":{"!type":"fn(node: +dijit._Widget)","!doc":"Called when mouse is over a node (onmouseenter event)"},"_onNodeMouseLeave":{"!type":"fn(node: +dijit._Widget)","!doc":"Called when mouse is over a node (onmouseenter event)"},"_onItemChange":{"!type":"fn(item: +Item)","!doc":"Processes notification of a change to an item's scalar values like label"},"_onItemChildrenChange":{"!type":"fn(parent: +dojo.data.Item, newChildrenList: [+dojo.data.Item])","!doc":"Processes notification of a change to an item's children"},"_onItemDelete":{"!type":"fn(item: +Item)","!doc":"Processes notification of a deletion of an item"},"_initState":{"!type":"fn()","!doc":"Load in which nodes should be opened automatically"},"_state":{"!type":"fn(item: ?, expanded: ?)","!doc":"Query or set expanded state for an item,"},"_saveState":{"!type":"fn()","!doc":"Create and save a cookie with the currently expanded nodes identifiers"},"destroy":{"!type":"fn()"},"destroyRecursive":{"!type":"fn()"},"_createTreeNode":{"!type":"fn(args: ?)","!doc":"creates a TreeNode"}}},"Calendar":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A simple GUI for choosing a date in the context of a monthly calendar.","templatePath":{},"value":{"!doc":"The currently selected Date","!type":"+Date"},"datePackage":{"!doc":"JavaScript namespace to find Calendar routines.  Uses Gregorian Calendar routines\nat dojo.date by default.","!type":"string"},"dayWidth":{"!doc":"How to represent the days of the week in the calendar header. See dojo.date.locale","!type":"string"},"setValue":{"!type":"fn(value: +Date)","!doc":"Deprecated.   Used attr('value', ...) instead."},"_getValueAttr":{"!type":"fn(value: string)","!doc":"Hook so attr('value') works."},"_setValueAttr":{"!type":"fn(value: +Date)","!doc":"Hook to make attr(&quot;value&quot;, ...) work."},"_setText":{"!type":"fn(node: ?, text: ?)","!doc":"This just sets the content of node to the specified text.\nCan't do &quot;node.innerHTML=text&quot; because of an IE bug w/tables, see #3434."},"_populateGrid":{"!type":"fn()","!doc":"Fills in the calendar grid with each day (1-31)"},"goToToday":{"!type":"fn()","!doc":"Sets calendar's value to today's date"},"constructor":{"!type":"fn(args: ?)"},"postCreate":{"!type":"fn()"},"_adjustDisplay":{"!type":"fn(part: string, amount: number)","!doc":"Moves calendar forwards or backwards by months or years"},"_onDayClick":{"!type":"fn(evt: +Event)","!doc":"Handler for when user clicks a day"},"_onDayMouseOver":{"!type":"fn(evt: +Event)","!doc":"Handler for when user clicks a day"},"_onDayMouseOut":{"!type":"fn(evt: +Event)","!doc":"Handler for when user clicks a day"},"onValueSelected":{"!type":"fn(date: +Date)","!doc":"Notification that a date cell was selected.  It may be the same as the previous value."},"onChange":{"!type":"fn(date: +Date)","!doc":"Called only when the selected date has changed"},"isDisabledDate":{"!type":"fn(dateObject: +Date, locale?: string) -> bool","!doc":"May be overridden to disable certain dates in the calendar e.g. <code>isDisabledDate=dojo.date.locale.isWeekend</code>"},"getClassForDate":{"!type":"fn(dateObject: +Date, locale?: string) -> string","!doc":"May be overridden to return CSS classes to associate with the date entry for the given dateObject,\nfor example to indicate a holiday in specified locale."}}},"_Contained":{"!type":"fn()","prototype":{"getParent":{"!type":"fn()","!doc":"Returns the parent widget of this widget, assuming the parent\nimplements dijit._Container"},"_getSibling":{"!type":"fn(which: +Either) -> +null","!doc":"Returns next or previous sibling"},"getPreviousSibling":{"!type":"fn() -> +Mixed","!doc":"Returns null if this is the first child of the parent,\notherwise returns the next element sibling to the &quot;left&quot;."},"getNextSibling":{"!type":"fn() -> +Mixed","!doc":"Returns null if this is the last child of the parent,\notherwise returns the next element sibling to the &quot;right&quot;."},"getIndexInParent":{"!type":"fn() -> number","!doc":"Returns the index of this widget within its container parent.\nIt returns -1 if the parent does not exist, or if the parent\nis not a dijit._Container"}}},"_Container":{"!type":"fn()","prototype":{"!doc":"Mixin for widgets that contain a set of widget children.","isContainer":{"!doc":"Just a flag indicating that this widget descends from dijit._Container","!type":"bool"},"buildRendering":{"!type":"fn()"},"addChild":{"!type":"fn(widget: +dijit._Widget, insertIndex?: number)","!doc":"Makes the given widget a child of this widget."},"removeChild":{"!type":"fn(widget: +dijit._Widget)","!doc":"Removes the passed widget instance from this widget but does\nnot destroy it.  You can also pass in an integer indicating\nthe index within the container to remove"},"_nextElement":{"!type":"fn(node: ?)","!doc":"Find the next (non-text, non-comment etc) node"},"_firstElement":{"!type":"fn(node: ?)","!doc":"Find the first (non-text, non-comment etc) node"},"getChildren":{"!type":"fn() -> [+Widget]","!doc":"Returns array of children widgets."},"hasChildren":{"!type":"fn() -> bool","!doc":"Returns true if widget has children, i.e. if this.containerNode contains something."},"destroyDescendants":{"!type":"fn(preserveDom: bool)","!doc":"Destroys all the widgets inside this.containerNode,\nbut not this widget itself"},"_getSiblingOfChild":{"!type":"fn(child: +dijit._Widget, dir: number)","!doc":"Get the next or previous widget sibling of child"},"getIndexOfChild":{"!type":"fn(child: +dijit._Widget) -> number","!doc":"Gets the index of the child in this container or -1 if not found"}}},"_DialogMixin":{"!type":"fn()","prototype":{"!doc":"This provides functions useful to Dialog and TooltipDialog","execute":{"!type":"fn(formContents: ?)","!doc":"Callback when the user hits the submit button.\nOverride this method to handle Dialog execution."},"onCancel":{"!type":"fn()","!doc":"Called when user has pressed the Dialog's cancel button, to notify container."},"onExecute":{"!type":"fn()","!doc":"Called when user has pressed the dialog's OK button, to notify container."},"_onSubmit":{"!type":"fn()","!doc":"Callback when user hits submit button\ntype:\nprotected"},"_getFocusItems":{"!type":"fn(dialogNode: +Node)","!doc":"Find focusable Items each time a dialog is opened,\nsetting _firstFocusItem and _lastFocusItem"}},"attributeMap":{}},"_KeyNavContainer":{"!type":"fn()","prototype":{"!proto":"dijit._Container.prototype","!doc":"A _Container with keyboard navigation of its children.","focusedChild":{"!doc":"The currently focused child widget, or null if there isn't one","!type":"+dijit._Widget"},"tabIndex":{"!doc":"Tab index of the container; same as HTML tabindex attribute.\nNote then when user tabs into the container, focus is immediately\nmoved to the first item in the container.","!type":"+Integer"},"_keyNavCodes":{},"connectKeyNavHandlers":{"!type":"fn(prevKeyCodes: [+dojo.keys], nextKeyCodes: [+dojo.keys])","!doc":"Call in postCreate() to attach the keyboard handlers\nto the container.\npreKeyCodes: dojo.keys[]\nKey codes for navigating to the previous child."},"startupKeyNavChildren":{"!type":"fn()","!doc":"Call in startup() to set child tabindexes to -1"},"addChild":{"!type":"fn(widget: +dijit._Widget, insertIndex?: number)","!doc":"Add a child to our _Container"},"focus":{"!type":"fn()","!doc":"Default focus() implementation: focus the first child."},"focusFirstChild":{"!type":"fn()","!doc":"Focus the first focusable child in the container."},"focusNext":{"!type":"fn()","!doc":"Focus the next widget or focal node (for widgets\nwith multiple focal nodes) within this container."},"focusPrev":{"!type":"fn()","!doc":"Focus the previous widget or focal node (for widgets\nwith multiple focal nodes) within this container."},"focusChild":{"!type":"fn(widget: +dijit._Widget, node?: +Node)","!doc":"Focus widget. Optionally focus 'node' within widget."},"_startupChild":{"!type":"fn(widget: +dijit._Widget)","!doc":"Set tabindex=&quot;-1&quot; on focusable widgets so that we\ncan focus them programmatically and by clicking.\nConnect focus and blur handlers."},"_connectNode":{"!type":"fn(node: +Element)","!doc":"Monitor focus and blur events on the node"},"_onContainerFocus":{"!type":"fn(evt: ?)","!doc":"Handler for when the container gets focus"},"_onBlur":{"!type":"fn(evt: ?)"},"_onContainerKeypress":{"!type":"fn(evt: ?)","!doc":"When a key is pressed, if it's an arrow key etc. then\nit's handled here."},"_onNodeFocus":{"!type":"fn(evt: ?)","!doc":"Handler for onfocus event on a child node"},"_onNodeBlur":{"!type":"fn(evt: ?)","!doc":"Handler for onblur event on a child node"},"_onChildBlur":{"!type":"fn(widget: +dijit._Widget)","!doc":"Called when focus leaves a child widget to go\nto a sibling widget."},"_getFirstFocusableChild":{"!type":"fn()","!doc":"Returns first child that can be focused"},"_getNextFocusableChild":{"!type":"fn(child: +dijit._Widget, dir: +Integer)","!doc":"Returns the next or previous focusable child, compared\nto &quot;child&quot;"}}},"_Widget":{"!type":"fn()","prototype":{"!doc":"Base class for all dijit widgets.","dojoAttachEvent":{"!type":"string"},"dojoAttachPoint":{"!type":"string"},"waiRole":{"!type":"string"},"waiState":{"!type":"string"},"id":{"!doc":"A unique, opaque ID string that can be assigned by users or by the\nsystem. If the developer passes an ID which is known not to be\nunique, the specified ID is ignored and the system-generated ID is\nused instead.","!type":"string"},"lang":{"!doc":"Rarely used.  Overrides the default Dojo locale used to render this widget,\nas defined by the [HTML LANG](http://www.w3.org/TR/html401/struct/dirlang.html#adef-lang) attribute.\nValue must be among the list of locales specified during by the Dojo bootstrap,\nformatted according to [RFC 3066](http://www.ietf.org/rfc/rfc3066.txt) (like en-us).","!type":"string"},"dir":{"!doc":"Unsupported by Dijit, but here for completeness.  Dijit only supports setting text direction on the\nentire document.\nBi-directional support, as defined by the [HTML DIR](http://www.w3.org/TR/html401/struct/dirlang.html#adef-dir)\nattribute. Either left-to-right &quot;ltr&quot; or right-to-left &quot;rtl&quot;.","!type":"string"},"class":{"!doc":"HTML class attribute","!type":"string"},"style":{"!doc":"HTML style attributes as cssText string or name/value hash","!type":"string"},"title":{"!doc":"HTML title attribute, used to specify the title of tabs, accordion panes, etc.","!type":"string"},"srcNodeRef":{"!doc":"pointer to original dom node","!type":"+Node"},"domNode":{"!doc":"This is our visible representation of the widget! Other DOM\nNodes may by assigned to other properties, usually through the\ntemplate system's dojoAttachPoint syntax, but the domNode\nproperty is the canonical &quot;top level&quot; node in widget UI.","!type":"+Node"},"containerNode":{"!doc":"Designates where children of the source dom node will be placed.\n&quot;Children&quot; in this case refers to both dom nodes and widgets.\nFor example, for myWidget:\n\n\t&lt;div dojoType=myWidget&gt;\n\t\t&lt;b&gt; here's a plain dom node\n\t\t&lt;span dojoType=subWidget&gt;and a widget&lt;/span&gt;\n\t\t&lt;i&gt; and another plain dom node &lt;/i&gt;\n\t&lt;/div&gt;\n\ncontainerNode would point to:\n\n\t\t&lt;b&gt; here's a plain dom node\n\t\t&lt;span dojoType=subWidget&gt;and a widget&lt;/span&gt;\n\t\t&lt;i&gt; and another plain dom node &lt;/i&gt;\n\nIn templated widgets, &quot;containerNode&quot; is set via a\ndojoAttachPoint assignment.\n\ncontainerNode must be defined for any widget that accepts innerHTML\n(like ContentPane or BorderContainer or even Button), and conversely\nis null for widgets that don't, like TextBox.","!type":"+Node"},"_started":{"!doc":"startup() has completed.","!type":"bool"},"_blankGif":{"!doc":"Path to a blank 1x1 image.\nUsed by &lt;img&gt; nodes in templates that really get their image via CSS background-image.","!type":"string"},"_attrPairNames":{},"nodesWithKeyClick":{"!doc":"List of nodes that correctly handle click events via native browser support,\nand don't need dijit's help","!type":"[string]"},"region":{"!type":"string"},"splitter":{"!type":"bool"},"minSize":{"!type":"number"},"layoutAlign":{"!type":"string"},"sizeMin":{"!type":"number"},"sizeShare":{"!type":"number"},"selected":{"!type":"bool"},"closable":{"!type":"bool"},"observer":{"!type":"string"},"dragRestriction":{"!type":"bool"},"column":{"!type":"string"},"group":{"!type":"string"},"slideFrom":{"!type":"string"},"toggleSplitterOpen":{"!type":"bool"},"toggleSplitterClosedThreshold":{"!type":"number"},"toggleSplitterOpenSize":{"!type":"string"},"onClick":{"!type":"fn(event: +mouse)","!doc":"Connect to this function to receive notifications of mouse click events."},"onDblClick":{"!type":"fn(event: +mouse)","!doc":"Connect to this function to receive notifications of mouse double click events."},"onKeyDown":{"!type":"fn(event: +key)","!doc":"Connect to this function to receive notifications of keys being pressed down."},"onKeyPress":{"!type":"fn(event: +key)","!doc":"Connect to this function to receive notifications of printable keys being typed."},"onKeyUp":{"!type":"fn(event: +key)","!doc":"Connect to this function to receive notifications of keys being released."},"onMouseDown":{"!type":"fn(event: +mouse)","!doc":"Connect to this function to receive notifications of when the mouse button is pressed down."},"onMouseMove":{"!type":"fn(event: +mouse)","!doc":"Connect to this function to receive notifications of when the mouse moves over nodes contained within this widget."},"onMouseOut":{"!type":"fn(event: +mouse)","!doc":"Connect to this function to receive notifications of when the mouse moves off of nodes contained within this widget."},"onMouseOver":{"!type":"fn(event: +mouse)","!doc":"Connect to this function to receive notifications of when the mouse moves onto nodes contained within this widget."},"onMouseLeave":{"!type":"fn(event: +mouse)","!doc":"Connect to this function to receive notifications of when the mouse moves off of this widget."},"onMouseEnter":{"!type":"fn(event: +mouse)","!doc":"Connect to this function to receive notifications of when the mouse moves onto this widget."},"onMouseUp":{"!type":"fn(event: +mouse)","!doc":"Connect to this function to receive notifications of when the mouse button is released."},"postscript":{"!type":"fn(params?: ?, srcNodeRef: +DomNode)","!doc":"Kicks off widget instantiation.  See create() for details."},"create":{"!type":"fn(params?: ?, srcNodeRef?: +DomNode)","!doc":"Kick off the life-cycle of a widget"},"_applyAttributes":{"!type":"fn()","!doc":"Step during widget creation to copy all widget attributes to the\nDOM as per attributeMap and _setXXXAttr functions."},"postMixInProperties":{"!type":"fn()","!doc":"Called after the parameters to the widget have been read-in,\nbut before the widget template is instantiated. Especially\nuseful to set properties that are referenced in the widget\ntemplate."},"buildRendering":{"!type":"fn()","!doc":"Construct the UI for this widget, setting this.domNode.  Most\nwidgets will mixin <code>dijit._Templated</code>, which implements this\nmethod."},"postCreate":{"!type":"fn()","!doc":"Called after a widget's dom has been setup"},"startup":{"!type":"fn()","!doc":"Called after a widget's children, and other widgets on the page, have been created.\nProvides an opportunity to manipulate any children before they are displayed.\nThis is useful for composite widgets that need to control or layout sub-widgets.\nMany layout widgets can use this as a wiring phase."},"destroyRecursive":{"!type":"fn(preserveDom?: bool)","!doc":"Destroy this widget and it's descendants. This is the generic\n&quot;destructor&quot; function that all widget users should call to\ncleanly discard with a widget. Once a widget is destroyed, it's\nremoved from the manager object."},"destroy":{"!type":"fn(preserveDom: bool)","!doc":"Destroy this widget, but not its descendants.\nWill, however, destroy internal widgets such as those used within a template."},"destroyRendering":{"!type":"fn(preserveDom?: bool)","!doc":"Destroys the DOM nodes associated with this widget"},"destroyDescendants":{"!type":"fn(preserveDom?: bool)","!doc":"Recursively destroy the children of this widget and their\ndescendants."},"uninitialize":{"!type":"fn()","!doc":"Stub function. Override to implement custom widget tear-down\nbehavior."},"onFocus":{"!type":"fn()","!doc":"Called when the widget becomes &quot;active&quot; because\nit or a widget inside of it either has focus, or has recently\nbeen clicked."},"onBlur":{"!type":"fn()","!doc":"Called when the widget stops being &quot;active&quot; because\nfocus moved to something outside of it, or the user\nclicked somewhere outside of it, or the widget was\nhidden."},"_onFocus":{"!type":"fn(e: ?)","!doc":"This is where widgets do processing for when they are active,\nsuch as changing CSS classes.  See onFocus() for more details."},"_onBlur":{"!type":"fn()","!doc":"This is where widgets do processing for when they stop being active,\nsuch as changing CSS classes.  See onBlur() for more details."},"_onConnect":{"!type":"fn(event: string)","!doc":"Called when someone connects to one of my handlers.\n&quot;Turn on&quot; that handler if it isn't active yet.\n\nThis is also called for every single initialization parameter\nso need to do nothing for parameters like &quot;id&quot;."},"_setClassAttr":{"!type":"fn(value: string)","!doc":"Custom setter for the CSS &quot;class&quot; attribute"},"_setStyleAttr":{"!type":"fn(value: string)","!doc":"Sets the style attribut of the widget according to value,\nwhich is either a hash like {height: &quot;5px&quot;, width: &quot;3px&quot;}\nor a plain string"},"setAttribute":{"!type":"fn(attr: string, value: +anything)","!doc":"Deprecated.  Use attr() instead."},"_attrToDom":{"!type":"fn(attr: string, value: string)","!doc":"Reflect a widget attribute (title, tabIndex, duration etc.) to\nthe widget DOM, as specified in attributeMap."},"attr":{"!type":"fn(name: string, value?: ?)","!doc":"Set or get properties on a widget instance."},"_getAttrNames":{"!type":"fn(name: ?)","!doc":"Helper function for Widget.attr().\nCaches attribute name values so we don't do the string ops every time."},"toString":{"!type":"fn() -> string","!doc":"Returns a string that represents the widget. When a widget is\ncast to a string, this method will be used to generate the\noutput. Currently, it does not implement any sort of reversable\nserialization."},"getDescendants":{"!type":"fn() -> []","!doc":"Returns all the widgets that contained by this, i.e., all widgets underneath this.containerNode.\nThis method should generally be avoided as it returns widgets declared in templates, which are\nsupposed to be internal/hidden, but it's left here for back-compat reasons."},"getChildren":{"!type":"fn()","!doc":"Returns all the widgets contained by this, i.e., all widgets underneath this.containerNode.\nDoes not return nested widgets, nor widgets that are part of this widget's template."},"connect":{"!type":"fn(obj: +Object, event: string, method: string)","!doc":"Connects specified obj/event to specified method of this object\nand registers for disconnect() on widget destroy."},"disconnect":{"!type":"fn(handles: ?)","!doc":"Disconnects handle created by this.connect.\nAlso removes handle from this widget's list of connects"},"isLeftToRight":{"!type":"fn() -> bool","!doc":"Checks the page for text direction"},"isFocusable":{"!type":"fn()","!doc":"Return true if this widget can currently be focused\nand false if not"},"placeAt":{"!type":"fn(reference: string, position?: string)","!doc":"Place this widget's domNode reference somewhere in the DOM based\non standard dojo.place conventions, or passing a Widget reference that\ncontains and addChild member."},"_onShow":{"!type":"fn()","!doc":"Internal method called when this widget is made visible.\nSee <code>onShow</code> for details."},"onShow":{"!type":"fn()","!doc":"Called when this widget becomes the selected pane in a\n<code>dijit.layout.TabContainer</code>, <code>dijit.layout.StackContainer</code>,\n<code>dijit.layout.AccordionContainer</code>, etc.\n\nAlso called to indicate display of a <code>dijit.Dialog</code>, <code>dijit.TooltipDialog</code>, or <code>dijit.TitlePane</code>."},"onHide":{"!type":"fn()","!doc":"Called when another widget becomes the selected pane in a\n<code>dijit.layout.TabContainer</code>, <code>dijit.layout.StackContainer</code>,\n<code>dijit.layout.AccordionContainer</code>, etc.\n\nAlso called to indicate hide of a <code>dijit.Dialog</code>, <code>dijit.TooltipDialog</code>, or <code>dijit.TitlePane</code>."},"onClose":{"!type":"fn() -> bool","!doc":"Callback if someone tries to close the child, child will be closed if func returns true"},"maxSize":{}},"attributeMap":{"!doc":"attributeMap sets up a &quot;binding&quot; between attributes (aka properties)\nof the widget and the widget's DOM.\nChanges to widget attributes listed in attributeMap will be\nreflected into the DOM.\n\nFor example, calling attr('title', 'hello')\non a TitlePane will automatically cause the TitlePane's DOM to update\nwith the new title.\n\nattributeMap is a hash where the key is an attribute of the widget,\nand the value reflects a binding to a:\n\n- DOM node attribute\n\t\tfocus: {node: &quot;focusNode&quot;, type: &quot;attribute&quot;}\nMaps this.focus to this.focusNode.focus\n\n- DOM node innerHTML\n\t\ttitle: { node: &quot;titleNode&quot;, type: &quot;innerHTML&quot; }\nMaps this.title to this.titleNode.innerHTML\n\n- DOM node CSS class\n\t\tmyClass: { node: &quot;domNode&quot;, type: &quot;class&quot; }\nMaps this.myClass to this.domNode.className\n\nIf the value is an array, then each element in the array matches one of the\nformats of the above list.\n\nThere are also some shorthands for backwards compatibility:\n- string --&gt; { node: string, type: &quot;attribute&quot; }, for example:\n\t&quot;focusNode&quot; ---&gt; { node: &quot;focusNode&quot;, type: &quot;attribute&quot; }\n- &quot;&quot; --&gt; { node: &quot;domNode&quot;, type: &quot;attribute&quot; }","id":{"!type":"string"},"dir":{"!type":"string"},"lang":{"!type":"string"},"class":{"!type":"string"},"style":{"!type":"string"},"title":{"!type":"string"}},"_deferredConnects":{"!doc":"attributeMap addendum for event handlers that should be connected only on first use","onClick":{"!type":"string"},"onDblClick":{"!type":"string"},"onKeyDown":{"!type":"string"},"onKeyPress":{"!type":"string"},"onKeyUp":{"!type":"string"},"onMouseMove":{"!type":"string"},"onMouseDown":{"!type":"string"},"onMouseOut":{"!type":"string"},"onMouseOver":{"!type":"string"},"onMouseLeave":{"!type":"string"},"onMouseEnter":{"!type":"string"},"onMouseUp":{"!type":"string"}}},"_Templated":{"!type":"fn()","prototype":{"!doc":"Mixin for widgets that are instantiated from a template","templateString":{"!doc":"A string that represents the widget template. Pre-empts the\ntemplatePath. In builds that have their strings &quot;interned&quot;, the\ntemplatePath is converted to an inline templateString, thereby\npreventing a synchronous network call.","!type":"string"},"templatePath":{"!doc":"Path to template (HTML file) for this widget relative to dojo.baseUrl","!type":"string"},"widgetsInTemplate":{"!doc":"Should we parse the template to find widgets that might be\ndeclared in markup inside it?  False by default.","!type":"bool"},"_skipNodeCache":{"!type":"bool"},"_stringRepl":{"!type":"fn(tmpl: ?)","!doc":"Does substitution of ${foo} type properties in template string"},"buildRendering":{"!type":"fn()","!doc":"Construct the UI for this widget from a template, setting this.domNode."},"_fillContent":{"!type":"fn(source: +Node)","!doc":"Relocate source contents to templated container node.\nthis.containerNode must be able to receive children, or exceptions will be thrown."},"_attachTemplateNodes":{"!type":"fn(rootNode: +DomNode, getAttrFunc?: fn())","!doc":"Iterate through the template and attach functions and nodes accordingly."}},"_templateCache":{},"getCachedTemplate":{"!type":"fn(templatePath: string, templateString?: string, alwaysUseString: ?) -> string","!doc":"Static method to get a template based on the templatePath or\ntemplateString key"},"_sanitizeTemplateString":{"!type":"fn(tString: string) -> string","!doc":"Strips &lt;?xml ...?&gt; declarations so that external SVG and XML\ndocuments can be added to a document without worry. Also, if the string\nis an HTML document, only the part inside the body tag is returned."}},"_TimePicker":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A graphical time picker.\nThis widget is used internally by other widgets and is not accessible\nas a standalone widget.","templatePath":{},"baseClass":{"!doc":"The root className to use for the various states of this widget","!type":"string"},"clickableIncrement":{"!doc":"ISO-8601 string representing the amount by which\nevery clickable element in the time picker increases.\nSet in local time, without a time zone.\nExample: <code>T00:15:00</code> creates 15 minute increments\nMust divide dijit._TimePicker.visibleIncrement evenly","!type":"string"},"visibleIncrement":{"!doc":"ISO-8601 string representing the amount by which\nevery element with a visible time in the time picker increases.\nSet in local time, without a time zone.\nExample: <code>T01:00:00</code> creates text in every 1 hour increment","!type":"string"},"visibleRange":{"!doc":"ISO-8601 string representing the range of this TimePicker.\nThe TimePicker will only display times in this range.\nExample: <code>T05:00:00</code> displays 5 hours of options","!type":"string"},"value":{"!doc":"Date to display.\nDefaults to current time and date.\nCan be a Date object or an ISO-8601 string.\nIf you specify the GMT time zone (<code>-01:00</code>),\nthe time will be converted to the local time in the local time zone.\nOtherwise, the time is considered to be in the local time zone.\nIf you specify the date and isDate is true, the date is used.\nExample: if your local time zone is <code>GMT -05:00</code>,\n<code>T10:00:00</code> becomes <code>T10:00:00-05:00</code> (considered to be local time),\n<code>T10:00:00-01:00</code> becomes <code>T06:00:00-05:00</code> (4 hour difference),\n<code>T10:00:00Z</code> becomes <code>T05:00:00-05:00</code> (5 hour difference between Zulu and local time)\n<code>yyyy-mm-ddThh:mm:ss</code> is the format to set the date and time\nExample: <code>2007-06-01T09:00:00</code>","!type":"string"},"_visibleIncrement":{"!type":"number"},"_clickableIncrement":{"!type":"number"},"_totalIncrements":{"!type":"number"},"constraints":{"!doc":"Specifies valid range of times (start time, end time)","!type":"+dijit._TimePicker.__Constraints"},"_filterString":{"!doc":"The string to filter by","!type":"string"},"serialize":{"!type":"fn(val: +Date, options?: ?)","!doc":"User overridable function used to convert the attr('value') result to a String"},"setValue":{"!type":"fn(value: +Date)","!doc":"Deprecated.  Used attr('value') instead."},"_setValueAttr":{"!type":"fn(date: +Date)","!doc":"Hook so attr('value', ...) works."},"onOpen":{"!type":"fn(best: +Whether)","!doc":"This is called by the popup manager when a TimeTextBox is displayed on the screen"},"isDisabledDate":{"!type":"fn(dateObject: +Date, locale?: string) -> bool","!doc":"May be overridden to disable certain dates in the TimePicker e.g. <code>isDisabledDate=dojo.date.locale.isWeekend</code>\ntype:\nextension"},"_getFilteredNodes":{"!type":"fn(start: number, maxNum: number, before: bool)","!doc":"Returns an array of nodes with the filter applied.  At most maxNum nodes\nwill be returned - but fewer may be returned as well.  If the\nbefore parameter is set to true, then it will return the elements\nbefore the given index"},"_showText":{"!type":"fn()","!doc":"Displays the relevant choices in the drop down list"},"postCreate":{"!type":"fn()"},"_buttonMouse":{"!type":"fn(e: +Event)","!doc":"Handler for mouse button presses"},"_createOption":{"!type":"fn(index: number)","!doc":"Creates a clickable time option"},"_onOptionSelected":{"!type":"fn(tgt: ?)","!doc":"Called when user clicks an option in the drop down list"},"onValueSelected":{"!type":"fn(time: +Date)","!doc":"Notification that a time was selected.  It may be the same as the previous value."},"_highlightOption":{"!type":"fn(node: +node, highlight: bool)","!doc":"Turns on/off hover effect on a node based on mouse out/over event"},"onmouseover":{"!type":"fn(e: +Event)","!doc":"Handler for onmouseover event"},"onmouseout":{"!type":"fn(e: +Event)","!doc":"Handler for onmouseout event"},"_mouseWheeled":{"!type":"fn(e: +Event)","!doc":"Handle the mouse wheel events"},"_onArrowUp":{"!type":"fn(count: ?)","!doc":"Handler for up arrow key."},"_onArrowDown":{"!type":"fn(count: ?)","!doc":"Handler for up arrow key."},"handleKey":{"!type":"fn(e: +Event)","!doc":"Called from <code>dijit.form._DateTimeTextBox</code> to pass a keypress event\nfrom the <code>dijit.form.TimeTextBox</code> to be handled in this widget"}},"__Constraints":{"!type":"fn()","prototype":{"!proto":"dojo.date.locale.__FormatOptions.prototype","clickableIncrement":{"!doc":"See <code>dijit._TimePicker.clickableIncrement</code>","!type":"string"},"visibleIncrement":{"!doc":"See <code>dijit._TimePicker.visibleIncrement</code>","!type":"string"},"visibleRange":{"!doc":"See <code>dijit._TimePicker.visibleRange</code>","!type":"string"}}}},"_base":{"focus":{},"manager":{},"place":{},"popup":{},"scroll":{},"sniff":{},"typematic":{},"wai":{},"window":{}},"WidgetSet":{"!type":"fn()","prototype":{"!doc":"A set of widgets indexed by id. A default instance of this class is\navailable as `dijit.registry`","constructor":{"!type":"fn()"},"add":{"!type":"fn(widget: +dijit._Widget)","!doc":"Add a widget to this list. If a duplicate ID is detected, a error is thrown."},"remove":{"!type":"fn(id: string)","!doc":"Remove a widget from this WidgetSet. Does not destroy the widget; simply\nremoves the reference."},"forEach":{"!type":"fn(func: fn())","!doc":"Call specified function for each widget in this set."},"filter":{"!type":"fn(filter: fn()) -> +dijit.WidgetSet","!doc":"Filter down this WidgetSet to a smaller new WidgetSet\nWorks the same as <code>dojo.filter</code> and <code>dojo.NodeList.filter</code>"},"byId":{"!type":"fn(id: string) -> +dijit._Widget","!doc":"Find a widget in this list by it's id."},"byClass":{"!type":"fn(cls: string) -> +dijit.WidgetSet","!doc":"Reduce this widgetset to a new WidgetSet of a particular declaredClass"}}},"_tabElements":{"area":{"!type":"bool"},"button":{"!type":"bool"},"input":{"!type":"bool"},"object":{"!type":"bool"},"select":{"!type":"bool"},"textarea":{"!type":"bool"}},"BackgroundIframe":{"!type":"fn(node: +Node)","!doc":"For IE z-index schenanigans. id attribute is required.","prototype":{"destroy":{"!type":"fn()","!doc":"destroy the iframe"}}},"popup":{"__OpenArgs":{"!type":"fn()"}},"typematic":{"!doc":"These functions are used to repetitively call a user specified callback\nmethod when a specific key or mouse click over a specific DOM node is\nheld down for a specific amount of time.\nOnly 1 such event is allowed to occur on the browser page at 1 time.","_fireEventAndReload":{"!type":"fn()"},"trigger":{"!type":"fn(evt: +Event, _this: ?, node: +Node, callback: fn(), obj: ?, subsequentDelay: number, initialDelay: number)","!doc":"Start a timed, repeating callback sequence.\nIf already started, the function call is ignored.\nThis method is not normally called by the user but can be\nwhen the normal listener code is insufficient."},"stop":{"!type":"fn()","!doc":"Stop an ongoing timed, repeating callback sequence."},"addKeyListener":{"!type":"fn(node: +Node, keyObject: ?, _this: ?, callback: fn(), subsequentDelay: number, initialDelay: number)","!doc":"Start listening for a specific typematic key.\nSee also the trigger method for other parameters."},"addMouseListener":{"!type":"fn(node: +Node, _this: ?, callback: fn(), subsequentDelay: number, initialDelay: number)","!doc":"Start listening for a typematic mouse click.\nSee the trigger method for other parameters."},"addListener":{"!type":"fn(mouseNode: +Node, keyNode: +Node, keyObject: ?, _this: ?, callback: fn(), subsequentDelay: number, initialDelay: number)","!doc":"Start listening for a specific typematic key and mouseclick.\nThis is a thin wrapper to addKeyListener and addMouseListener.\nSee the addMouseListener and addKeyListener methods for other parameters."}},"wai":{"onload":{"!type":"fn()","!doc":"Detects if we are in high-contrast mode or not"}},"range":{"BlockTagNames":{"!type":"+RegExp"},"_w3c":{},"getIndex":{"!type":"fn(node: +Node, parent: +Node)"},"getNode":{"!type":"fn(index: [], parent: +Node)"},"getCommonAncestor":{"!type":"fn(n1: ?, n2: ?)"},"getAncestor":{"!type":"fn(node: +Node, regex?: +RegEx, root?: +Node)"},"getBlockAncestor":{"!type":"fn(node: +Node, regex?: +RegEx, root?: +Node)"},"atBeginningOfContainer":{"!type":"fn(container: +Node, node: +Node, offset: number)"},"atEndOfContainer":{"!type":"fn(container: +Node, node: +Node, offset: number)"},"adjacentNoneTextNode":{"!type":"fn(startnode: ?, next: ?)"},"create":{"!type":"fn()"},"getSelection":{"!type":"fn(win: ?, ignoreUpdate?: bool)"},"W3CRange":{"!type":"fn()","prototype":{"constructor":{"!type":"fn()"},"_updateInternal":{"!type":"fn()"},"setStart":{"!type":"fn(node: ?, offset: ?)"},"setEnd":{"!type":"fn(node: ?, offset: ?)"},"setStartAfter":{"!type":"fn(node: ?, offset: ?)"},"setStartBefore":{"!type":"fn(node: ?, offset: ?)"},"setEndAfter":{"!type":"fn(node: ?, offset: ?)"},"setEndBefore":{"!type":"fn(node: ?, offset: ?)"},"_setPoint":{"!type":"fn(what: ?, node: ?, offset: ?, ext: ?)"},"_getIERange":{"!type":"fn()"},"getBookmark":{"!type":"fn(body: ?)"},"_select":{"!type":"fn()"},"deleteContents":{"!type":"fn()"},"cloneRange":{"!type":"fn()"},"detach":{"!type":"fn()"}}},"ie":{"cachedSelection":{},"selection":{"!type":"fn(win: ?)"},"decomposeControlRange":{"!type":"fn(range: ?)"},"getEndPoint":{"!type":"fn(range: ?, end: ?)"},"setEndPoint":{"!type":"fn(range: ?, container: ?, offset: ?)"},"decomposeTextRange":{"!type":"fn(range: ?)"},"setRange":{"!type":"fn(range: ?, startContainter: ?, startOffset: ?, endContainter: ?, endOffset: ?, collapsed: ?)"}}},"_tree":{"dndSource":{}},"form":{"!doc":"Form and input related widgets","Slider":{},"Button":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormWidget.prototype","!doc":"Basically the same thing as a normal HTML button, but with special styling.","label":{"!doc":"String\nText to display in button.\nIf the label is hidden (showLabel=false) then and no title has\nbeen specified, then label is also set as title attribute of icon.","!type":"+HTML"},"showLabel":{"!doc":"Set this to true to hide the label text and display only the icon.\n(If showLabel=false then iconClass must be specified.)\nEspecially useful for toolbars.\nIf showLabel=true, the label will become the title (a.k.a. tooltip/hint) of the icon.\n\nThe exception case is for computers in high-contrast mode, where the label\nwill still be displayed, since the icon doesn't appear.","!type":"bool"},"iconClass":{"!doc":"Class to apply to div in button to make it display an icon","!type":"string"},"type":{"!doc":"Defines the type of button.  &quot;button&quot;, &quot;submit&quot;, or &quot;reset&quot;.","!type":"string"},"baseClass":{"!type":"string"},"templatePath":{},"attributeMap":{},"_onClick":{"!type":"fn(e: +Event)","!doc":"Internal function to handle click actions"},"_onButtonClick":{"!type":"fn(e: +Event)","!doc":"Handler when the user activates the button portion.\nIf is activated via a keystroke, stop the event unless is submit or reset."},"_setValueAttr":{"!type":"fn(value: string)"},"_fillContent":{"!type":"fn(source: +Node)"},"postCreate":{"!type":"fn()"},"_setShowLabelAttr":{"!type":"fn(val: ?)"},"onClick":{"!type":"fn(e: +Event) -> bool","!doc":"Callback for when button is clicked.\nIf type=&quot;submit&quot;, return true to perform submit, or false to cancel it.\ntype:\ncallback"},"_clicked":{"!type":"fn(e: +Event)","!doc":"Internal overridable function for when the button is clicked"},"setLabel":{"!type":"fn(content: string)","!doc":"Deprecated.  Use attr('label', ...) instead."},"_setLabelAttr":{"!type":"fn(content: string)","!doc":"Hook for attr('label', ...) to work."}}},"DropDownButton":{"!type":"fn()","prototype":{"!proto":"dijit.form.Button.prototype","!doc":"A button with a drop down","baseClass":{"!type":"string"},"templatePath":{},"_fillContent":{"!type":"fn()"},"startup":{"!type":"fn()"},"destroyDescendants":{"!type":"fn()"},"_onArrowClick":{"!type":"fn(e: +Event)","!doc":"Handler for when the user mouse clicks on menu popup node"},"_onDropDownClick":{"!type":"fn(e: +Event)"},"_onDropDownKeydown":{"!type":"fn(e: +Event)"},"_onDropDownBlur":{"!type":"fn(e: +Event)"},"_onKey":{"!type":"fn(e: +Event)","!doc":"Handler when the user presses a key on drop down widget"},"_onBlur":{"!type":"fn()","!doc":"Called magically when focus has shifted away from this widget and it's dropdown"},"_toggleDropDown":{"!type":"fn()","!doc":"Toggle the drop-down widget; if it is up, close it; if not, open it."},"_openDropDown":{"!type":"fn()"},"_closeDropDown":{"!type":"fn(focus: bool)"}}},"ComboButton":{"!type":"fn()","prototype":{"!proto":"dijit.form.DropDownButton.prototype","!doc":"A combination button and drop-down button.\nUsers can click one side to \"press\" the button, or click an arrow\nicon to display the drop down.","templatePath":{},"attributeMap":{},"optionsTitle":{"!doc":"Text that describes the options menu (accessibility)","!type":"string"},"baseClass":{"!type":"string"},"_focusedNode":{},"postCreate":{"!type":"fn()"},"focusFocalNode":{"!type":"fn(node: ?)","!doc":"Focus the focal node node."},"hasNextFocalNode":{"!type":"fn()","!doc":"Returns true if this widget has no node currently\nfocused or if there is a node following the focused one.\nFalse is returned if the last node has focus."},"focusNext":{"!type":"fn()","!doc":"Focus the focal node following the current node with focus,\nor the first one if no node currently has focus."},"hasPrevFocalNode":{"!type":"fn()","!doc":"Returns true if this widget has no node currently\nfocused or if there is a node before the focused one.\nFalse is returned if the first node has focus."},"focusPrev":{"!type":"fn()","!doc":"Focus the focal node before the current node with focus\nor the last one if no node currently has focus."},"getFocalNodes":{"!type":"fn()","!doc":"Returns an array of focal nodes for this widget."},"_onNodeFocus":{"!type":"fn(evt: ?)"},"_onNodeBlur":{"!type":"fn(evt: ?)"},"_onBlur":{"!type":"fn()"}}},"ToggleButton":{"!type":"fn()","prototype":{"!proto":"dijit.form.Button.prototype","!doc":"A button that can be in two states (checked or not).\nCan be base class for things like tabs or checkbox or radio buttons","baseClass":{"!type":"string"},"checked":{"!doc":"Corresponds to the native HTML &lt;input&gt; element's attribute.\nIn markup, specified as &quot;checked='checked'&quot; or just &quot;checked&quot;.\nTrue if the button is depressed, or the checkbox is checked,\nor the radio button is selected, etc.","!type":"bool"},"attributeMap":{},"_clicked":{"!type":"fn(evt: +Event)"},"_setCheckedAttr":{"!type":"fn(value: bool)"},"setChecked":{"!type":"fn(checked: bool)","!doc":"Deprecated.   Use attr('checked', true/false) instead."},"reset":{"!type":"fn()","!doc":"Reset the widget's value to what it was at initialization time"}}},"CheckBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.ToggleButton.prototype","!doc":"Same as an HTML checkbox, but with fancy styling.","templatePath":{},"baseClass":{"!type":"string"},"type":{"!doc":"type attribute on &lt;input&gt; node.\nOverrides <code>dijit.form.Button.type</code>.   Users should not change this value.","!type":"string"},"value":{"!doc":"As an initialization parameter, equivalent to value field on normal checkbox\n(if checked, the value is passed as the value when form is submitted).\n\nHowever, attr('value') will return either the string or false depending on\nwhether or not the checkbox is checked.\n\nattr('value', string) will check the checkbox and change the value to the\nspecified string\n\nattr('value', boolean) will change the checked state.","!type":"string"},"_setValueAttr":{"!type":"fn(newValue: string)","!doc":"Handler for value= attribute to constructor, and also calls to\nattr('value', val)."},"_getValueAttr":{"!type":"fn()","!doc":"Hook so attr('value') works."},"postMixInProperties":{"!type":"fn()"},"_fillContent":{"!type":"fn(source: +Node)"},"reset":{"!type":"fn()"},"_onFocus":{"!type":"fn()"},"_onBlur":{"!type":"fn()"}}},"RadioButton":{"!type":"fn()","prototype":{"!proto":"dijit.form.CheckBox.prototype","!doc":"Same as an HTML radio, but with fancy styling.","type":{"!type":"string"},"baseClass":{"!type":"string"},"_setCheckedAttr":{"!type":"fn(value: bool)"},"_clicked":{"!type":"fn(e: +Event)"}}},"_ComboBoxDataStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"Inefficient but small data store specialized for inlined `dijit.form.ComboBox` data","constructor":{"!type":"fn(root: +Node)"},"getValue":{"!type":"fn(item: +item, attribute: ?, defaultValue?: +value)"},"isItemLoaded":{"!type":"fn(something: +anything)"},"getFeatures":{"!type":"fn()"},"_fetchItems":{"!type":"fn(args: ?, findCallback: fn(), errorCallback: fn())","!doc":"See dojo.data.util.simpleFetch.fetch()"},"close":{"!type":"fn(request: +dojo.data.api.Request)"},"getLabel":{"!type":"fn(item: +item)"},"getIdentity":{"!type":"fn(item: +item)"},"fetchItemByIdentity":{"!type":"fn(args: ?)","!doc":"Given the identity of an item, this method returns the item that has\nthat identity through the onItem callback.\nRefer to dojo.data.api.Identity.fetchItemByIdentity() for more details."},"fetchSelectedItem":{"!type":"fn()","!doc":"Get the option marked as selected, like <code>&lt;option selected&gt;</code>.\nNot part of dojo.data API."}}},"ComboBoxMixin":{"!type":"fn()","prototype":{"!doc":"Implements the base functionality for ComboBox/FilteringSelect","item":{"!doc":"This is the item returned by the dojo.data.store implementation that\nprovides the data for this cobobox, it's the currently selected item."},"store":{"!doc":"Reference to data provider object used by this ComboBox"},"fetchProperties":{"!doc":"Mixin to the dojo.data store's fetch.\nFor example, to set the sort order of the ComboBox menu, pass:\n\t{ sort: {attribute:&quot;name&quot;,descending: true} }\nTo override the default queryOptions so that deep=false, do:\n\t{ queryOptions: {ignoreCase: true, deep: false} }"},"query":{"!doc":"A query that can be passed to 'store' to initially filter the items,\nbefore doing further filtering based on <code>searchAttr</code> and the key.\nAny reference to the <code>searchAttr</code> is ignored."},"autoComplete":{"!doc":"If user types in a partial string, and then tab out of the <code>&lt;input&gt;</code> box,\nautomatically copy the first entry displayed in the drop down list to\nthe <code>&lt;input&gt;</code> field","!type":"bool"},"highlightMatch":{"!doc":"One of: &quot;first&quot;, &quot;all&quot; or &quot;none&quot;.\n\nIf the ComboBox/FilteringSelect opens with the search results and the searched\nstring can be found, it will be highlighted.  If set to &quot;all&quot;\nthen will probably want to change <code>queryExpr</code> parameter to '*${0}*'\n\nHighlighting is only performed when <code>labelType</code> is &quot;text&quot;, so as to not\ninterfere with any HTML markup an HTML label might contain.","!type":"string"},"searchDelay":{"!doc":"Delay in milliseconds between when user types something and we start\nsearching based on that value","!type":"+Integer"},"searchAttr":{"!doc":"Search for items in the data store where this attribute (in the item)\nmatches what the user typed","!type":"string"},"labelAttr":{"!doc":"The entries in the drop down list come from this attribute in the\ndojo.data items.\nIf not specified, the searchAttr attribute is used instead.","!type":"string"},"labelType":{"!doc":"Specifies how to interpret the labelAttr in the data store items.\nCan be &quot;html&quot; or &quot;text&quot;.","!type":"string"},"queryExpr":{"!doc":"This specifies what query ComboBox/FilteringSelect sends to the data store,\nbased on what the user has typed.  Changing this expression will modify\nwhether the drop down shows only exact matches, a &quot;starting with&quot; match,\netc.   Use it in conjunction with highlightMatch.\ndojo.data query expression pattern.\n<code>${0}</code> will be substituted for the user text.\n<code>*</code> is used for wildcards.\n<code>${0}*</code> means &quot;starts with&quot;, <code>*${0}*</code> means &quot;contains&quot;, <code>${0}</code> means &quot;is&quot;","!type":"string"},"ignoreCase":{"!doc":"Set true if the ComboBox/FilteringSelect should ignore case when matching possible items","!type":"bool"},"hasDownArrow":{"!doc":"Set this textbox to have a down arrow button, to display the drop down list.\nDefaults to true.","!type":"bool"},"templatePath":{},"baseClass":{"!type":"string"},"_getCaretPos":{"!type":"fn(element: +Node)"},"_setCaretPos":{"!type":"fn(element: +Node, location: number)"},"_setDisabledAttr":{"!type":"fn(value: bool)"},"_onKeyPress":{"!type":"fn(evt: +Event)","!doc":"Handles keyboard events"},"_autoCompleteText":{"!type":"fn(text: string)","!doc":"Fill in the textbox with the first item from the drop down\nlist, and highlight the characters that were\nauto-completed. For example, if user typed &quot;CA&quot; and the\ndrop down list appeared, the textbox would be changed to\n&quot;California&quot; and &quot;ifornia&quot; would be highlighted."},"_openResultList":{"!type":"fn(results: ?, dataObject: ?)"},"_showResultList":{"!type":"fn()"},"_hideResultList":{"!type":"fn()"},"_setBlurValue":{"!type":"fn()"},"_onBlur":{"!type":"fn()","!doc":"Called magically when focus has shifted away from this widget and it's drop down"},"_announceOption":{"!type":"fn(node: +Node)","!doc":"a11y code that puts the highlighted option in the textbox.\nThis way screen readers will know what is happening in the\nmenu."},"_selectOption":{"!type":"fn(evt: +Event)"},"_doSelect":{"!type":"fn(tgt: ?)","!doc":"Menu callback function, called when an item in the menu is selected."},"_onArrowMouseDown":{"!type":"fn(evt: ?)","!doc":"Callback when arrow is clicked"},"_startSearchFromInput":{"!type":"fn()"},"_getQueryString":{"!type":"fn(text: string)"},"_startSearch":{"!type":"fn(key: string)"},"_setMaxOptions":{"!type":"fn(size: ?, request: ?)"},"_getValueField":{"!type":"fn()"},"_arrowPressed":{"!type":"fn()"},"_arrowIdle":{"!type":"fn()"},"compositionend":{"!type":"fn(evt: +Event)","!doc":"When inputting characters using an input method, such as\nAsian languages, it will generate this event instead of\nonKeyDown event.\nNote: this event is only triggered in FF (not in IE)"},"constructor":{"!type":"fn()"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()","!doc":"Subclasses must call this method from their postCreate() methods"},"uninitialize":{"!type":"fn()"},"_getMenuLabelFromItem":{"!type":"fn(item: +Item)"},"doHighlight":{"!type":"fn(label: string, find: string)","!doc":"Highlights the string entered by the user in the menu.  By default this\nhighlights the first occurence found. Override this method\nto implement your custom highlighing."},"_escapeHtml":{"!type":"fn(str: string) -> string","!doc":"Adds escape sequences for special characters in XML: &amp;&lt;&gt;&quot;'"},"open":{"!type":"fn()","!doc":"Opens the drop down menu.  TODO: rename to _open."},"reset":{"!type":"fn()"}},"pageSize":{"!doc":"Argument to data provider.\nSpecifies number of search results per page (before hitting &quot;next&quot; button)","!type":"+Integer"}},"_ComboBoxMenu":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Focus-less menu for internal use in `dijit.form.ComboBox`","templateString":{"!type":"string"},"_messages":{"!doc":"Holds &quot;next&quot; and &quot;previous&quot; text for paging buttons on drop down"},"postMixInProperties":{"!type":"fn()"},"_setValueAttr":{"!type":"fn(value: ?)"},"onChange":{"!type":"fn(value: ?)","!doc":"Notifies ComboBox/FilteringSelect that user clicked an option in the drop down menu.\nProbably should be called onSelect."},"onPage":{"!type":"fn(direction: number)","!doc":"Notifies ComboBox/FilteringSelect that user clicked to advance to next/previous page."},"postCreate":{"!type":"fn()"},"onClose":{"!type":"fn()","!doc":"Callback from dijit.popup code to this widget, notifying it that it closed"},"_createOption":{"!type":"fn(item: ?, labelFunc: ?)","!doc":"Creates an option to appear on the popup menu subclassed by\n<code>dijit.form.FilteringSelect</code>."},"createOptions":{"!type":"fn(results: [], dataObject: +dojo.data, labelFunc: fn())","!doc":"Fills in the items in the drop down list"},"clearResultList":{"!type":"fn()","!doc":"Clears the entries in the drop down list, but of course keeps the previous and next buttons."},"_onMouseDown":{"!type":"fn(evt: +Event)"},"_onMouseUp":{"!type":"fn(evt: +Event)"},"_onMouseOver":{"!type":"fn(evt: +Event)"},"_onMouseOut":{"!type":"fn(evt: +Event)"},"_focusOptionNode":{"!type":"fn(node: +Node)","!doc":"Does the actual highlight."},"_blurOptionNode":{"!type":"fn()","!doc":"Removes highlight on highlighted option."},"_highlightNextOption":{"!type":"fn()","!doc":"Highlight the item just below the current selection.\nIf nothing selected, highlight first option."},"highlightFirstOption":{"!type":"fn()","!doc":"Highlight the first real item in the list (not Previous Choices)."},"highlightLastOption":{"!type":"fn()","!doc":"Highlight the last real item in the list (not More Choices)."},"_highlightPrevOption":{"!type":"fn()","!doc":"Highlight the item just above the current selection.\nIf nothing selected, highlight last option (if\nyou select Previous and try to keep scrolling up the list)."},"_page":{"!type":"fn(up: bool)","!doc":"Handles page-up and page-down keypresses"},"pageUp":{"!type":"fn()","!doc":"Handles pageup keypress.\nTODO: just call _page directly from handleKey()."},"pageDown":{"!type":"fn()","!doc":"Handles pagedown keypress.\nTODO: just call _page directly from handleKey()."},"getHighlightedOption":{"!type":"fn()","!doc":"Returns the highlighted option."},"handleKey":{"!type":"fn(key: ?)"}}},"ComboBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.ValidationTextBox.prototype","!doc":"Auto-completing text box, and base class for dijit.form.FilteringSelect.","_setValueAttr":{"!type":"fn(value: string, priorityChange?: bool)","!doc":"Hook so attr('value', value) works."}}},"CurrencyTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.NumberTextBox.prototype","!doc":"A validating currency textbox","currency":{"!doc":"the [ISO4217](http://en.wikipedia.org/wiki/ISO_4217) currency code, a three letter sequence like &quot;USD&quot;","!type":"string"},"constraints":{"!doc":"Minimum/maximum amount allowed.","!type":"+dijit.form.CurrencyTextBox.__Constraints"},"parse":{"!type":"fn(value: string, constraints: +dojo.currency.__ParseOptions) -> number","!doc":"Parses string as a Currency, according to constraints"},"postMixInProperties":{"!type":"fn()"}},"regExpGen":{},"_formatter":{},"__Constraints":{"!type":"fn()","prototype":{"!proto":"dijit.form.NumberTextBox.__Constraints.prototype"}}},"DateTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form._DateTimeTextBox.prototype","!doc":"A validating, serializable, range-bound date text box with a drop down calendar","baseClass":{"!type":"string"},"popupClass":{"!type":"string"},"_selector":{"!type":"string"},"value":{"!doc":"The value of this widget as a JavaScript Date object, with only year/month/day specified.\n\nExample:\n\tnew dijit.form.DateTextBox({value: new Date(2009,1,20)})\n\nWhen passed to the parser in markup, must be specified according to locale-independent\n<code>dojo.date.stamp.fromISOString</code> format.\n\nExample:\n\t&lt;input dojotype='dijit.form.DateTextBox' value='2009-01-20'&gt;\nvalue.toString()=&quot;NaN&quot;","!type":"+Date"}}},"FilteringSelect":{"!type":"fn()","prototype":{"!proto":"dijit.form.MappedTextBox.prototype","!doc":"An enhanced version of the HTML SELECT tag, populated dynamically","_isvalid":{"!type":"bool"},"required":{"!doc":"True if user is required to enter a value into this field.","!type":"bool"},"_lastDisplayedValue":{"!type":"string"},"isValid":{"!type":"fn() -> +#5974"},"_callbackSetLabel":{"!type":"fn(result: [], dataObject: ?, priorityChange?: bool)","!doc":"Callback function that dynamically sets the label of the\nComboBox"},"_openResultList":{"!type":"fn(results: ?, dataObject: ?)"},"_getValueAttr":{"!type":"fn()","!doc":"Hook for attr('value') to work."},"_getValueField":{"!type":"fn()"},"_setValue":{"!type":"fn(value: string, displayedValue: string, priorityChange?: bool)","!doc":"Internal function for setting the displayed value and hidden value.\nDiffers from _setValueAttr() in that _setValueAttr() only takes a single\nvalue argument, and has to look up the displayed value from that."},"_setValueAttr":{"!type":"fn(value: string, priorityChange?: bool)","!doc":"Hook so attr('value', value) works."},"_setValueFromItem":{"!type":"fn(item: +item, priorityChange?: bool)","!doc":"Set the displayed valued in the input box, and the hidden value\nthat gets submitted, based on a dojo.data store item."},"labelFunc":{"!type":"fn(item: +item, store: +dojo.data.store)","!doc":"Computes the label to display based on the dojo.data store item."},"_doSelect":{"!type":"fn(tgt: +Event)","!doc":"Overrides ComboBox._doSelect(), the method called when an item in the menu is selected."},"_getDisplayQueryString":{"!type":"fn(text: string)"},"_setDisplayedValueAttr":{"!type":"fn(label: string, priorityChange?: bool)","!doc":"Hook so attr('displayedValue', label) works."},"postMixInProperties":{"!type":"fn()"},"undo":{"!type":"fn()"}}},"Form":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Widget corresponding to HTML form tag, for validation and serialization","name":{"!doc":"Name of form for scripting.","!type":"string"},"action":{"!doc":"Server-side form handler.","!type":"string"},"method":{"!doc":"HTTP method used to submit the form, either &quot;GET&quot; or &quot;POST&quot;.","!type":"string"},"encType":{"!doc":"Encoding type for the form, ex: application/x-www-form-urlencoded.","!type":"string"},"accept-charset":{"!doc":"List of supported charsets.","!type":"string"},"accept":{"!doc":"List of MIME types for file upload.","!type":"string"},"target":{"!doc":"Target frame for the document to be opened in.","!type":"string"},"templateString":{"!type":"string"},"attributeMap":{},"postMixInProperties":{"!type":"fn()"},"execute":{"!type":"fn(formContents: ?)","!doc":"Deprecated: use submit()"},"onExecute":{"!type":"fn()","!doc":"Deprecated: use onSubmit()"},"_setEncTypeAttr":{"!type":"fn(value: string)"},"postCreate":{"!type":"fn()"},"onReset":{"!type":"fn(e?: +Event) -> bool","!doc":"Callback when user resets the form. This method is intended\nto be over-ridden. When the <code>reset</code> method is called\nprogrammatically, the return value from <code>onReset</code> is used\nto compute whether or not resetting should proceed"},"_onReset":{"!type":"fn(e: ?)"},"_onSubmit":{"!type":"fn(e: ?)"},"onSubmit":{"!type":"fn(e?: +Event) -> bool","!doc":"Callback when user submits the form."},"submit":{"!type":"fn()","!doc":"programmatically submit form if and only if the <code>onSubmit</code> returns true"}}},"HorizontalRule":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Hash marks for `dijit.form.HorizontalSlider`","templateString":{"!type":"string"},"count":{"!doc":"Number of hash marks to generate","!type":"+Integer"},"container":{"!doc":"For HorizontalSlider, this is either &quot;topDecoration&quot; or &quot;bottomDecoration&quot;,\nand indicates whether this rule goes above or below the slider.","!type":"string"},"ruleStyle":{"!doc":"CSS style to apply to individual hash marks","!type":"string"},"_positionPrefix":{"!type":"string"},"_positionSuffix":{"!type":"string"},"_suffix":{"!type":"string"},"_isHorizontal":{"!doc":"VerticalRule will override this...","!type":"bool"},"_genHTML":{"!type":"fn(pos: ?, ndx: ?)"},"postCreate":{"!type":"fn()"}}},"HorizontalRuleLabels":{"!type":"fn()","prototype":{"!proto":"dijit.form.HorizontalRule.prototype","!doc":"Labels for `dijit.form.HorizontalSlider`","templateString":{"!type":"string"},"labelStyle":{"!doc":"CSS style to apply to individual text labels","!type":"string"},"labels":{"!doc":"Array of text labels to render - evenly spaced from left-to-right or bottom-to-top.\nAlternately, minimum and maximum can be specified, to get numeric labels.","!type":"[string]"},"numericMargin":{"!doc":"Number of generated numeric labels that should be rendered as '' on the ends when labels[] are not specified","!type":"+Integer"},"minimum":{"!type":"number"},"maximum":{"!type":"number"},"_positionPrefix":{"!type":"string"},"_labelPrefix":{"!type":"string"},"_suffix":{"!type":"string"},"_calcPosition":{"!type":"fn(pos: ?)","!doc":"Returns the value to be used in HTML for the label as part of the left: attribute"},"_genHTML":{"!type":"fn(pos: ?, ndx: ?)"},"getLabels":{"!type":"fn()","!doc":"Overridable function to return array of labels to use for this slider.\nCan specify a getLabels() method instead of a labels[] array, or min/max attributes."},"postMixInProperties":{"!type":"fn()"}},"constraints":{"!doc":"pattern, places, lang, et al (see dojo.number) for generated numeric labels when labels[] are not specified","pattern":{"!type":"string"}}},"HorizontalSlider":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormValueWidget.prototype","!doc":"A form widget that allows one to select a value with a horizontally draggable handle","templatePath":{},"value":{"!type":"number"},"showButtons":{"!doc":"Show increment/decrement buttons at the ends of the slider?","!type":"bool"},"minimum":{"!doc":"The minimum value the slider can be set to.","!type":"+Integer"},"maximum":{"!doc":"The maximum value the slider can be set to.","!type":"+Integer"},"pageIncrement":{"!doc":"If discreteValues is also specified, this indicates the amount of clicks (ie, snap positions)\nthat the slider handle is moved via pageup/pagedown keys.\nIf discreteValues is not specified, it indicates the number of pixels.","!type":"+Integer"},"clickSelect":{"!doc":"If clicking the slider bar changes the value or not","!type":"bool"},"widgetsInTemplate":{"!type":"bool"},"attributeMap":{},"baseClass":{"!type":"string"},"_mousePixelCoord":{"!type":"string"},"_pixelCount":{"!type":"string"},"_startingPixelCoord":{"!type":"string"},"_startingPixelCount":{"!type":"string"},"_handleOffsetCoord":{"!type":"string"},"_progressPixelSize":{"!type":"string"},"_onKeyPress":{"!type":"fn(e: +Event)"},"_onHandleClick":{"!type":"fn(e: ?)"},"_isReversed":{"!type":"fn()","!doc":"Returns true if direction is from right to left"},"_onBarClick":{"!type":"fn(e: ?)"},"_setPixelValue":{"!type":"fn(pixelValue: number, maxPixels: number, priorityChange: bool)"},"_setValueAttr":{"!type":"fn(value: number, priorityChange: bool)","!doc":"Hook so attr('value', value) works."},"_bumpValue":{"!type":"fn(signedChange: ?)"},"_onClkBumper":{"!type":"fn(val: ?)"},"_onClkIncBumper":{"!type":"fn()"},"_onClkDecBumper":{"!type":"fn()"},"decrement":{"!type":"fn(e: ?)","!doc":"Decrement slider by 1 unit"},"increment":{"!type":"fn(e: ?)","!doc":"Increment slider by 1 unit"},"_mouseWheeled":{"!type":"fn(evt: +Event)","!doc":"Event handler for mousewheel where supported"},"startup":{"!type":"fn()"},"_typematicCallback":{"!type":"fn(count: number, button: ?, e: +Event)"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"}},"discreteValues":{"!doc":"If specified, indicates that the slider handle has only 'discreteValues' possible positions,\nand that after dragging the handle, it will snap to the nearest possible position.\nThus, the slider has only 'discreteValues' possible values.\n\nFor example, if minimum=10, maxiumum=30, and discreteValues=3, then the slider handle has\nthree possible positions, representing values 10, 20, or 30.\n\nIf discreteValues is not specified or if it's value is higher than the number of pixels\nin the slider bar, then the slider handle can be moved freely, and the slider's value will be\ncomputed/reported based on pixel position (in this case it will likely be fractional,\nsuch as 123.456789).","!type":"+Integer"},"slideDuration":{"!doc":"The time in ms to take to animate the slider handle from 0% to 100%,\nwhen clicking the slider bar to make the handle move.","!type":"number"}},"_SliderMover":{"!type":"fn()","prototype":{"!proto":"dojo.dnd.Mover.prototype","onMouseMove":{"!type":"fn(e: ?)"},"destroy":{"!type":"fn(e: ?)"}}},"MappedTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.ValidationTextBox.prototype","!doc":"A dijit.form.ValidationTextBox subclass which provides a base class for widgets that have\na visible formatted display value, and a serializable\nvalue in a hidden input field which is actually sent to the server.","postMixInProperties":{"!type":"fn()"},"serialize":{"!type":"fn(val: +anything, options?: ?) -> string","!doc":"Overridable function used to convert the attr('value') result to a canonical\n(non-localized) string.  For example, will print dates in ISO format, and\nnumbers the same way as they are represented in javascript."},"toString":{"!type":"fn() -> string","!doc":"Returns widget as a printable string using the widget's value"},"validate":{"!type":"fn()"},"buildRendering":{"!type":"fn()"},"_setDisabledAttr":{"!type":"fn(value: bool)"},"reset":{"!type":"fn()"}}},"MultiSelect":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormWidget.prototype","!doc":"Widget version of a <select multiple=true> element,\nfor selecting multiple options.","size":{"!doc":"Number of elements to display on a page\nNOTE: may be removed in version 2.0, since elements may have variable height;\nset the size via style=&quot;...&quot; or CSS class names instead.\n\n\nfor Form","!type":"number"},"templateString":{"!type":"string"},"attributeMap":{},"_multiValue":{"!type":"bool"},"reset":{"!type":"fn()","!doc":"Reset the widget's value to what it was at initialization time"},"addSelected":{"!type":"fn(select: +dijit.form.MultiSelect)","!doc":"Move the selected nodes of a passed Select widget\ninstance to this Select widget."},"getSelected":{"!type":"fn() -> bool","!doc":"Access the NodeList of the selected options directly"},"_getValueAttr":{"!type":"fn()","!doc":"Hook so attr('value') works."},"_setValueAttr":{"!type":"fn(values: [])","!doc":"Hook so attr('value', values) works."},"invertSelection":{"!type":"fn(onChange: bool)","!doc":"Invert the selection"},"_onChange":{"!type":"fn(e: +Event)"},"resize":{"!type":"fn(size: ?)"},"postCreate":{"!type":"fn()"}}},"NumberSpinner":{"!type":"fn()","prototype":{"!proto":"dijit.form._Spinner.prototype","!doc":"Extends NumberTextBox to add up/down arrows and pageup/pagedown for incremental change to the value","required":{"!type":"bool"},"adjust":{"!type":"fn(val: ?, delta: number)","!doc":"Change Number val by the given amount"},"_onKeyPress":{"!type":"fn(e: ?)"}}},"NumberTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.RangeBoundTextBox.prototype","!doc":"A validating, serializable, range-bound text box."},"__Constraints":{"!type":"fn()","prototype":{"!proto":"dijit.form.RangeBoundTextBox.__Constraints.prototype"}}},"NumberTextBoxMixin":{"!type":"fn()","prototype":{"!doc":"A mixin for all number textboxes","constraints":{"!doc":"Minimum/maximum allowed values.","!type":"+dijit.form.NumberTextBox.__Constraints"},"_formatter":{"!type":"fn(value: number, options?: +dojo.number.__FormatOptions) -> string","!doc":"_formatter() is called by format().   It's the base routine for formatting a number,\nas a string, for example converting 12345 into &quot;12,345&quot;."},"postMixInProperties":{"!type":"fn()"},"_onFocus":{"!type":"fn()"},"format":{"!type":"fn(value: number, constraints: +dojo.number.__FormatOptions)","!doc":"Formats the value as a Number, according to constraints."},"parse":{"!type":"fn(value: string, constraints: +dojo.number.__ParseOptions) -> number","!doc":"Parses the string value as a Number, according to constraints."},"_getDisplayedValueAttr":{"!type":"fn()"},"filter":{"!type":"fn(value: number) -> ","!doc":"This is called with both the display value (string), and the actual value (a number).\nWhen called with the actual value it does corrections so that '' etc. are represented as NaN.\nOtherwise it dispatches to the superclass's filter() method.\n\nSee <code>dijit.form.TextBox.filter</code> for more details."},"serialize":{"!type":"fn(value: number, options?: ?)","!doc":"Convert value (a Number) into a canonical string (ie, how the number literal is written in javascript/java/C/etc.)"},"_setValueAttr":{"!type":"fn(value: number, priorityChange?: bool, formattedValue?: string)","!doc":"Hook so attr('value', ...) works."},"_getValueAttr":{"!type":"fn()","!doc":"Hook so attr('value') works.\nReturns Number, NaN for '', or undefined for unparsable text"}},"regExpGen":{},"value":{"!doc":"The value of this NumberTextBox as a javascript Number (ie, not a String).\nIf the displayed value is blank, the value is NaN, and if the user types in\nan gibberish value (like &quot;hello world&quot;), the value is undefined\n(i.e. attr('value') returns undefined).\n\nSymetrically, attr('value', NaN) will clear the displayed value,\nwhereas attr('value', undefined) will have no effect.","!type":"number"},"editOptions":{"!doc":"Properties to mix into constraints when the value is being edited.\nThis is here because we edit the number in the format &quot;12345&quot;, which is\ndifferent than the display value (ex: &quot;12,345&quot;)","pattern":{"!type":"string"}}},"RangeBoundTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.MappedTextBox.prototype","!doc":"Base class for textbox form widgets which defines a range of valid values.","rangeMessage":{"!doc":"The message to display if value is out-of-range","!type":"string"},"constraints":{"!type":"+dijit.form.RangeBoundTextBox.__Constraints"},"rangeCheck":{"!type":"fn(primitive: number, constraints: +dijit.form.RangeBoundTextBox.__Constraints) -> bool","!doc":"Overridable function used to validate the range of the numeric input value."},"isInRange":{"!type":"fn(isFocused: bool)","!doc":"Tests if the value is in the min/max range specified in constraints"},"_isDefinitelyOutOfRange":{"!type":"fn()","!doc":"Returns true if the value is out of range and will remain\nout of range even if the user types more characters"},"_isValidSubset":{"!type":"fn()","!doc":"Overrides <code>dijit.form.ValidationTextBox._isValidSubset</code>.\nReturns true if the input is syntactically valid, and either within\nrange or could be made in range by more typing."},"isValid":{"!type":"fn(isFocused: bool)"},"getErrorMessage":{"!type":"fn(isFocused: bool) -> string"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"_setValueAttr":{"!type":"fn(value: number, priorityChange?: bool)","!doc":"Hook so attr('value', ...) works."}},"__Constraints":{"!type":"fn()"}},"SimpleTextarea":{"!type":"fn()","prototype":{"!proto":"dijit.form.TextBox.prototype","!doc":"A simple textarea that degrades, and responds to\nminimal LayoutContainer usage, and works with dijit.form.Form.\nDoesn't automatically size according to input, like Textarea.","baseClass":{"!type":"string"},"attributeMap":{},"rows":{"!doc":"The number of characters per line.","!type":"number"},"cols":{"!type":"string"},"templatePath":{},"templateString":{"!type":"string"},"_previousValue":{"!type":"string"},"postMixInProperties":{"!type":"fn()"},"filter":{"!type":"fn(value: string)"},"postCreate":{"!type":"fn()"},"_onInput":{"!type":"fn(e: ?)"}}},"TextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormValueWidget.prototype","!doc":"A base class for textbox form inputs","trim":{"!doc":"Removes leading and trailing whitespace if true.  Default is false.","!type":"bool"},"uppercase":{"!doc":"Converts all characters to uppercase if true.  Default is false.","!type":"bool"},"lowercase":{"!doc":"Converts all characters to lowercase if true.  Default is false.","!type":"bool"},"propercase":{"!doc":"Converts the first character of each word to uppercase if true.","!type":"bool"},"maxLength":{"!doc":"HTML INPUT tag maxLength declaration.","!type":"string"},"templatePath":{},"baseClass":{"!type":"string"},"attributeMap":{},"displayedValue":{"!doc":"For subclasses like ComboBox where the displayed value\n(ex: Kentucky) and the serialized value (ex: KY) are different,\nthis represents the displayed value.\n\nSetting 'displayedValue' through attr('displayedValue', ...)\nupdates 'value', and vice-versa.  Othewise 'value' is updated\nfrom 'displayedValue' periodically, like onBlur etc.\n\nTODO: move declaration to MappedTextBox?\nProblem is that ComboBox references displayedValue,\nfor benefit of FilteringSelect.\n\n\nif the textbox is blank, what value should be reported","!type":"string"},"_blankValue":{"!type":"string"},"_getValueAttr":{"!type":"fn()","!doc":"Hook so attr('value') works as we like."},"_setValueAttr":{"!type":"fn(value: +The, priorityChange?: bool, formattedValue?: string)","!doc":"Hook so attr('value', ...) works."},"getDisplayedValue":{"!type":"fn()","!doc":"Deprecated.   Use attr('displayedValue') instead."},"_getDisplayedValueAttr":{"!type":"fn()","!doc":"Hook so attr('displayedValue') works."},"setDisplayedValue":{"!type":"fn(value: string)","!doc":"Deprecated.   Use attr('displayedValue', ...) instead."},"_setDisplayedValueAttr":{"!type":"fn(value: string)","!doc":"Hook so attr('displayedValue', ...) works."},"format":{"!type":"fn(value: string, constraints: ?)","!doc":"Replacable function to convert a value to a properly formatted string."},"parse":{"!type":"fn(value: string, constraints: ?) -> string","!doc":"Replacable function to convert a formatted string to a value"},"_refreshState":{"!type":"fn()","!doc":"After the user types some characters, etc., this method is\ncalled to check the field for validity etc.  The base method\nin <code>dijit.form.TextBox</code> does nothing, but subclasses override."},"_onInput":{"!type":"fn(e: ?)"},"postCreate":{"!type":"fn()"},"filter":{"!type":"fn(val: ?)","!doc":"Auto-corrections (such as trimming) that are applied to textbox\nvalue on blur or form submit."},"_setBlurValue":{"!type":"fn()"},"_onBlur":{"!type":"fn(e: ?)"},"_onFocus":{"!type":"fn(e: ?)"},"reset":{"!type":"fn()"}}},"Textarea":{"!type":"fn()","prototype":{"!proto":"dijit.form.SimpleTextarea.prototype","!doc":"A textarea widget that adjusts it's height according to the amount of data.","cols":{"!type":"string"},"_previousNewlines":{"!type":"number"},"_strictMode":{"!type":"bool"},"_busyResizing":{"!type":"bool"},"_getHeight":{"!type":"fn(textarea: ?)"},"_onInput":{"!type":"fn()"},"_shrink":{"!type":"fn()"},"resize":{"!type":"fn()","!doc":"Resizes the textarea vertically (should be called after a style/value change)"},"_setValueAttr":{"!type":"fn()"},"postCreate":{"!type":"fn()"}}},"TimeTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form._DateTimeTextBox.prototype","!doc":"A validating, serializable, range-bound time text box with a drop down time picker","baseClass":{"!type":"string"},"popupClass":{"!type":"string"},"_selector":{"!type":"string"},"constraints":{"!type":"+dijit.form.TimeTextBox.__Constraints"},"value":{"!doc":"The value of this widget as a JavaScript Date object, with only hours/minutes/seconds specified.\n\nExample:\n\tnew dijit.form.TimeTextBox({value: dojo.date.local.fromISOString(&quot;T:12:59:59&quot;)})\n\nWhen passed to the parser in markup, must be specified according to locale-independent\n<code>dojo.date.stamp.fromISOString</code> format.\n\nExample:\n\t&lt;input dojotype='dijit.form.TimeTextBox' value='T12:34:00'&gt;\nvalue.toString()=&quot;NaN&quot;","!type":"+Date"}},"__Constraints":{"!type":"fn()","prototype":{"!proto":"dijit.form._DateTimeTextBox.__Constraints.prototype"}}},"ValidationTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.TextBox.prototype","!doc":"Base class for textbox widgets with the ability to validate content of various types and provide user feedback.","templatePath":{},"baseClass":{"!type":"string"},"required":{"!doc":"User is required to enter data into this field.","!type":"bool"},"promptMessage":{"!doc":"If defined, display this hint string immediately on focus to the textbox, if empty.\nThink of this like a tooltip that tells the user what to do, not an error message\nthat tells the user what they've done wrong.\n\nMessage disappears when user starts typing.","!type":"string"},"invalidMessage":{"!doc":"The message to display if value is invalid.\n\n\nread from the message file if not overridden","!type":"string"},"constraints":{"!doc":"user-defined object needed to pass parameters to the validator functions","!type":"+dijit.form.ValidationTextBox.__Constraints"},"regExp":{"!doc":"regular expression string used to validate the input\nDo not specify both regExp and regExpGen","!type":"string"},"state":{"!doc":"Shows current state (ie, validation result) of input (Normal, Warning, or Error)","!type":"string"},"tooltipPosition":{"!doc":"See description of <code>dijit.Tooltip.defaultPosition</code> for details on this parameter.","!type":"[string]"},"_maskValidSubsetError":{"!type":"bool"},"_message":{"!doc":"Currently displayed message","!type":"string"},"regExpGen":{"!type":"fn(constraints: +dijit.form.ValidationTextBox.__Constraints) -> string","!doc":"Overridable function used to generate regExp when dependent on constraints.\nDo not specify both regExp and regExpGen."},"_setValueAttr":{"!type":"fn()","!doc":"Hook so attr('value', ...) works."},"validator":{"!type":"fn(value: +anything, constraints: +dijit.form.ValidationTextBox.__Constraints)","!doc":"Overridable function used to validate the text input against the regular expression."},"_isValidSubset":{"!type":"fn()","!doc":"Returns true if the value is either already valid or could be made valid by appending characters.\nThis is used for validation while the user [may be] still typing."},"isValid":{"!type":"fn(isFocused: bool)","!doc":"Tests if value is valid.\nCan override with your own routine in a subclass."},"_isEmpty":{"!type":"fn(value: ?) -> bool","!doc":"Checks for whitespace"},"getErrorMessage":{"!type":"fn(isFocused: bool) -> string","!doc":"Return an error message to show if appropriate"},"getPromptMessage":{"!type":"fn(isFocused: bool) -> string","!doc":"Return a hint message to show when widget is first focused"},"validate":{"!type":"fn(isFocused: bool)","!doc":"Called by oninit, onblur, and onkeypress."},"displayMessage":{"!type":"fn(message: string)","!doc":"Overridable method to display validation errors/hints.\nBy default uses a tooltip."},"_refreshState":{"!type":"fn()"},"constructor":{"!type":"fn()"},"postMixInProperties":{"!type":"fn()"},"_setDisabledAttr":{"!type":"fn(value: bool)"},"_setRequiredAttr":{"!type":"fn(value: bool)"},"postCreate":{"!type":"fn()"},"reset":{"!type":"fn()"}},"__Constraints":{"!type":"fn()"}},"VerticalRule":{"!type":"fn()","prototype":{"!proto":"dijit.form.HorizontalRule.prototype","!doc":"Hash marks for the `dijit.form.VerticalSlider`","templateString":{"!type":"string"},"_positionPrefix":{"!type":"string"},"container":{"!doc":"This is either &quot;leftDecoration&quot; or &quot;rightDecoration&quot;,\nto indicate whether this rule goes to the left or to the right of the slider.\nNote that on RTL system, &quot;leftDecoration&quot; would actually go to the right, and vice-versa.","!type":"string"},"_isHorizontal":{"!type":"bool"}}},"VerticalRuleLabels":{"!type":"fn()","prototype":{"!proto":"dijit.form.HorizontalRuleLabels.prototype","!doc":"Labels for the `dijit.form.VerticalSlider`","templateString":{"!type":"string"},"_positionPrefix":{"!type":"string"},"_labelPrefix":{"!type":"string"},"_calcPosition":{"!type":"fn(pos: ?)"}}},"VerticalSlider":{"!type":"fn()","prototype":{"!proto":"dijit.form.HorizontalSlider.prototype","!doc":"A form widget that allows one to select a value with a vertically draggable handle","templatePath":{},"_mousePixelCoord":{"!type":"string"},"_pixelCount":{"!type":"string"},"_startingPixelCoord":{"!type":"string"},"_startingPixelCount":{"!type":"string"},"_handleOffsetCoord":{"!type":"string"},"_progressPixelSize":{"!type":"string"},"_descending":{"!doc":"Specifies if the slider values go from high-on-top (true), or low-on-top (false)\nTODO: expose this in 1.2 - the css progress/remaining bar classes need to be reversed","!type":"bool"},"startup":{"!type":"fn()"},"_isReversed":{"!type":"fn()","!doc":"Overrides HorizontalSlider._isReversed.\nIndicates if values are high on top (with low numbers on the bottom)."},"_rtlRectify":{"!type":"fn(decorationNode: +NodeList)","!doc":"Helper function on gecko.\nRectify children nodes for left/right decoration in rtl case.\nSimply switch the rule and label child for each decoration node."}}},"_DateTimeTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.RangeBoundTextBox.prototype","!doc":"Base class for validating, serializable, range-bound date or time text box.","constraints":{"!doc":"Starting / ending dates or times allowed","!type":"+dijit.form._DateTimeTextBox.__Constraints"},"datePackage":{"!doc":"JavaScript namespace to find calendar routines.  Uses Gregorian calendar routines\nat dojo.date, by default.","!type":"string"},"value":{"!doc":"The value of this widget as a JavaScript Date object.  Use attr(&quot;value&quot;) / attr(&quot;value&quot;, val) to manipulate.\nWhen passed to the parser in markup, must be specified according to <code>dojo.date.stamp.fromISOString</code>\n\n\nvalue.toString()=&quot;NaN&quot;\n\n\nused by filter() when the textbox is blank","!type":"+Date"},"_blankValue":{},"popupClass":{"!doc":"Name of the popup widget class used to select a date/time.\nSubclasses should specify this.\n\n\ndefault is no popup = text only","!type":"string"},"_selector":{"!doc":"Specifies constraints.selector passed to dojo.date functions, should be either\n&quot;date&quot; or &quot;time&quot;.\nSubclass must specify this.","!type":"string"},"format":{"!type":"fn(value: +Date, constraints: +dojo.date.locale.__FormatOptions)","!doc":"Formats the value as a Date, according to specified locale (second argument)"},"parse":{"!type":"fn(value: string, constraints: +dojo.date.locale.__FormatOptions) -> +Date","!doc":"Parses as string as a Date, according to constraints"},"serialize":{"!type":"fn(val: +anything, options?: ?)"},"constructor":{"!type":"fn(args: ?)"},"postMixInProperties":{"!type":"fn()"},"_onFocus":{"!type":"fn(evt: +Event)","!doc":"open the TimePicker popup"},"_setValueAttr":{"!type":"fn(value: +Date, priorityChange?: bool, formattedValue?: string)","!doc":"Sets the date on this textbox.  Note that <code>value</code> must be like a Javascript Date object."},"_open":{"!type":"fn()","!doc":"opens the TimePicker, and sets the onValueSelected value"},"_close":{"!type":"fn()"},"_onBlur":{"!type":"fn()","!doc":"Called magically when focus has shifted away from this widget and it's dropdown"},"_getDisplayedValueAttr":{"!type":"fn()"},"_setDisplayedValueAttr":{"!type":"fn(value: string, priorityChange?: bool)"},"destroy":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"_onKeyPress":{"!type":"fn(e: +Event)","!doc":"Handler for keypress events"}},"regExpGen":{},"compare":{},"__Constraints":{"!type":"fn()","prototype":{"!proto":"dijit.form.RangeBoundTextBox.__Constraints.prototype"}}},"_FormMixin":{"!type":"fn()","prototype":{"!doc":"Mixin for containers of form widgets (i.e. widgets that represent a single value\nand can be children of a <form> node or dijit.form.Form widget)","reset":{"!type":"fn()"},"validate":{"!type":"fn()","!doc":"returns if the form is valid - same as isValid - but\nprovides a few additional (ui-specific) features.\n1 - it will highlight any sub-widgets that are not\nvalid\n2 - it will call focus() on the first invalid\nsub-widget"},"setValues":{"!type":"fn(val: ?)"},"_setValueAttr":{"!type":"fn(obj: ?)","!doc":"Fill in form values from according to an Object (in the format returned by attr('value'))"},"getValues":{"!type":"fn()"},"_getValueAttr":{"!type":"fn()","!doc":"Returns Object representing form values."},"isValid":{"!type":"fn()","!doc":"Returns true if all of the widgets are valid"},"onValidStateChange":{"!type":"fn(isValid: ?)","!doc":"Stub function to connect to if you want to do something\n(like disable/enable a submit button) when the valid\nstate changes on the form as a whole."},"_widgetChange":{"!type":"fn(widget: ?)","!doc":"Connected to a widget's onChange function - update our\nvalid state, if needed."},"connectChildren":{"!type":"fn()","!doc":"Connects to the onChange function of all children to\ntrack valid state changes.  You can call this function\ndirectly, ex. in the event that you programmatically\nadd a widget to the form *after* the form has been\ninitialized."},"startup":{"!type":"fn()"}}},"_FormWidget":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Base class for widgets corresponding to native HTML elements such as <checkbox> or <button>,\nwhich can be children of a <form> node or a `dijit.form.Form` widget.","baseClass":{"!doc":"Root CSS class of the widget (ex: dijitTextBox), used to add CSS classes of widget\n(ex: &quot;dijitTextBox dijitTextBoxInvalid dijitTextBoxFocused dijitTextBoxInvalidFocused&quot;)\nSee _setStateClass().","!type":"string"},"name":{"!doc":"Name used when submitting form; same as &quot;name&quot; attribute or plain HTML elements","!type":"string"},"alt":{"!doc":"Corresponds to the native HTML &lt;input&gt; element's attribute.","!type":"string"},"value":{"!doc":"Corresponds to the native HTML &lt;input&gt; element's attribute.","!type":"string"},"type":{"!doc":"Corresponds to the native HTML &lt;input&gt; element's attribute.","!type":"string"},"tabIndex":{"!doc":"Order fields are traversed when user hits the tab key","!type":"+Integer"},"disabled":{"!doc":"Should this widget respond to user input?\nIn markup, this is specified as &quot;disabled='disabled'&quot;, or just &quot;disabled&quot;.","!type":"bool"},"intermediateChanges":{"!doc":"Fires onChange for each value change or only on demand","!type":"bool"},"scrollOnFocus":{"!doc":"On focus, should this widget scroll into view?","!type":"bool"},"attributeMap":{},"_onChangeActive":{"!doc":"Indicates that changes to the value should call onChange() callback.\nThis is false during widget initialization, to avoid calling onChange()\nwhen the initial value is set.","!type":"bool"},"postMixInProperties":{"!type":"fn()"},"_setDisabledAttr":{"!type":"fn(value: bool)"},"setDisabled":{"!type":"fn(disabled: bool)","!doc":"Deprecated.   Use attr('disabled', ...) instead."},"_onFocus":{"!type":"fn(e: ?)"},"_onMouse":{"!type":"fn(event: +Event)","!doc":"Sets _hovering, _active, and stateModifier properties depending on mouse state,\nthen calls setStateClass() to set appropriate CSS classes for this.domNode.\n\nTo get a different CSS class for hover, send onmouseover and onmouseout events to this method.\nTo get a different CSS class while mouse button is depressed, send onmousedown to this method."},"isFocusable":{"!type":"fn()","!doc":"Tells if this widget is focusable or not.   Used internally by dijit."},"focus":{"!type":"fn()","!doc":"Put focus on this widget"},"_setStateClass":{"!type":"fn()","!doc":"Update the visual state of the widget by setting the css classes on this.domNode\n(or this.stateNode if defined) by combining this.baseClass with\nvarious suffixes that represent the current widget state(s)."},"compare":{"!type":"fn(val1: +anything, val2: +anything)","!doc":"Compare 2 values (as returned by attr('value') for this widget)."},"onChange":{"!type":"fn(newValue: ?)","!doc":"Callback when this widget's value is changed."},"_handleOnChange":{"!type":"fn(newValue: +anything, priorityChange?: bool)","!doc":"Called when the value of the widget is set.  Calls onChange() if appropriate"},"create":{"!type":"fn()"},"destroy":{"!type":"fn()"},"setValue":{"!type":"fn(value: string)","!doc":"Deprecated.   Use attr('value', ...) instead."},"getValue":{"!type":"fn()","!doc":"Deprecated.   Use attr('value') instead."},"_layoutHack":{"!type":"fn()","!doc":"Work around table sizing bugs on FF2 by forcing redraw"}}},"_FormValueWidget":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormWidget.prototype","!doc":"Base class for widgets corresponding to native HTML elements such as <input> or <select> that have user changeable values.","readOnly":{"!doc":"Should this widget respond to user input?\nIn markup, this is specified as &quot;readOnly&quot;.\nSimilar to disabled except readOnly form values are submitted.","!type":"bool"},"attributeMap":{},"_setReadOnlyAttr":{"!type":"fn(value: bool)"},"postCreate":{"!type":"fn()"},"_setValueAttr":{"!type":"fn(newValue: +anything, priorityChange: bool)","!doc":"Hook so attr('value', value) works."},"_getValueAttr":{"!type":"fn()","!doc":"Hook so attr('value') works."},"undo":{"!type":"fn()","!doc":"Restore the value to the last value passed to onChange"},"reset":{"!type":"fn()","!doc":"Reset the widget's value to what it was at initialization time"},"_onKeyDown":{"!type":"fn(e: ?)"},"_layoutHackIE7":{"!type":"fn()","!doc":"Work around table sizing bugs on IE7 by forcing redraw"}}},"_Spinner":{"!type":"fn()","prototype":{"!proto":"dijit.form.RangeBoundTextBox.prototype","!doc":"Mixin for validation widgets with a spinner.","defaultTimeout":{"!doc":"Number of milliseconds before a held arrow key or up/down button becomes typematic","!type":"number"},"timeoutChangeRate":{"!doc":"Fraction of time used to change the typematic timer between events.\n1.0 means that each typematic event fires at defaultTimeout intervals.\n&lt; 1.0 means that each typematic event fires at an increasing faster rate.","!type":"number"},"smallDelta":{"!doc":"Adjust the value by this much when spinning using the arrow keys/buttons","!type":"number"},"largeDelta":{"!doc":"Adjust the value by this much when spinning using the PgUp/Dn keys","!type":"number"},"templatePath":{},"baseClass":{"!type":"string"},"_wheelTimer":{},"adjust":{"!type":"fn(val: ?, delta: number)","!doc":"Overridable function used to adjust a primitive value(Number/Date/...) by the delta amount specified.\nThe val is adjusted in a way that makes sense to the object type."},"_arrowState":{"!type":"fn(node: +Node, pressed: bool)","!doc":"Called when an arrow key is pressed to update the relevant CSS classes"},"_arrowPressed":{"!type":"fn(nodePressed: +Node, direction: number, increment: number)","!doc":"Handler for arrow button or arrow key being pressed"},"_arrowReleased":{"!type":"fn(node: +Node)","!doc":"Handler for arrow button or arrow key being released"},"_typematicCallback":{"!type":"fn(count: number, node: +Node, evt: +Event)"},"_mouseWheeled":{"!type":"fn(evt: +Event)","!doc":"Mouse wheel listener where supported"},"postCreate":{"!type":"fn()"}}},"_SliderMoverMax":{"!type":"fn()","prototype":{"!proto":"dijit.form._SliderMover.prototype","onMouseMove":{"!type":"fn(e: ?)"},"destroy":{"!type":"fn(e: ?)"}}},"_SliderBarMover":{"!type":"fn()","prototype":{"!proto":"dojo.dnd.Mover.prototype","onMouseMove":{"!type":"fn(e: ?)"},"destroy":{"!type":"fn()"}}}},"layout":{"!doc":"Layout related widgets","marginBox2contentBox":{"!type":"fn(node: +Node, mb: ?)","!doc":"Given the margin-box size of a node, return its content box size.\nFunctions like dojo.contentBox() but is more reliable since it doesn't have\nto wait for the browser to compute sizes."},"layoutChildren":{"!type":"fn(container: +Node, dim: ?, children: [+Object])"},"AccordionContainer":{"!type":"fn()","prototype":{"!proto":"dijit.layout.StackContainer.prototype","!doc":"Holds a set of panes where every pane's title is visible, but only one pane's content is visible at a time,\nand switching between panes is visualized by sliding the other panes up/down.","_verticalSpace":{"!doc":"Pixels of space available for the open pane\n(my content box size minus the cumulative size of all the title bars)","!type":"number"},"baseClass":{"!type":"string"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"_getTargetHeight":{"!type":"fn(node: +Node)","!doc":"For the given node, returns the height that should be\nset to achieve our vertical space (subtract any padding\nwe may have).\n\nThis is used by the animations.\n\nTODO: I don't think this works correctly in IE quirks when an elements\nstyle.height including padding and borders"},"layout":{"!type":"fn()"},"_setupChild":{"!type":"fn(child: ?)"},"removeChild":{"!type":"fn(child: ?)"},"getChildren":{"!type":"fn()"},"destroy":{"!type":"fn()"},"_transition":{"!type":"fn(newWidget?: +dijit._Widget, oldWidget?: +dijit._Widget)"},"_onKeyPress":{"!type":"fn(e: +Event, fromTitle: +dijit._Widget)","!doc":"Handle keypress events"}},"duration":{"!doc":"Amount of time (in ms) it takes to slide panes","!type":"+Integer"}},"_AccordionButton":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"The title bar to click to open up an accordion pane.\nInternal widget used by AccordionContainer.","templatePath":{},"attributeMap":{},"baseClass":{"!type":"string"},"getParent":{"!type":"fn()","!doc":"Returns the parent."},"postCreate":{"!type":"fn()"},"getTitleHeight":{"!type":"fn() -> +Integer","!doc":"Returns the height of the title dom node."},"_onTitleClick":{"!type":"fn()","!doc":"Callback when someone clicks my title."},"_onTitleEnter":{"!type":"fn()","!doc":"Callback when someone hovers over my title."},"_onTitleLeave":{"!type":"fn()","!doc":"Callback when someone stops hovering over my title."},"_onTitleKeyPress":{"!type":"fn(evt: +Event)"},"_setSelectedState":{"!type":"fn(isSelected: bool)"},"_handleFocus":{"!type":"fn(e: +Event)","!doc":"Handle the blur and focus state of this widget."},"setSelected":{"!type":"fn(isSelected: bool)","!doc":"Change the selected state on this pane."}}},"AccordionPane":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"Deprecated widget.   Use `dijit.layout.ContentPane` instead.","constructor":{"!type":"fn()"},"onSelected":{"!type":"fn()","!doc":"called when this pane is selected"}}},"BorderContainer":{"!type":"fn()","prototype":{"!proto":"dijit.layout._LayoutWidget.prototype","!doc":"Provides layout in up to 5 regions, a mandatory center with optional borders along its 4 sides.","design":{"!doc":"Which design is used for the layout:\n- &quot;headline&quot; (default) where the top and bottom extend\nthe full width of the container\n- &quot;sidebar&quot; where the left and right sides extend from top to bottom.","!type":"string"},"gutters":{"!doc":"Give each pane a border and margin.\nMargin determined by domNode.paddingLeft.\nWhen false, only resizable panes have a gutter (i.e. draggable splitter) for resizing.","!type":"bool"},"liveSplitters":{"!doc":"Specifies whether splitters resize as you drag (true) or only upon mouseup (false)","!type":"bool"},"persist":{"!doc":"Save splitter positions in a cookie.","!type":"bool"},"baseClass":{"!type":"string"},"_splitterClass":{"!doc":"Optional hook to override the default Splitter widget used by BorderContainer","!type":"string"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"_setupChild":{"!type":"fn(child: +dijit._Widget)"},"_computeSplitterThickness":{"!type":"fn(region: ?)"},"layout":{"!type":"fn()"},"addChild":{"!type":"fn(child: +dijit._Widget, insertIndex?: +Integer)"},"removeChild":{"!type":"fn(child: +dijit._Widget)"},"getChildren":{"!type":"fn()"},"getSplitter":{"!type":"fn(region: string)","!doc":"Returns the widget responsible for rendering the splitter associated with region"},"resize":{"!type":"fn(newSize: ?, currentSize: ?)"},"_layoutChildren":{"!type":"fn(changedRegion?: string)","!doc":"This is the main routine for setting size/position of each child"},"destroy":{"!type":"fn()"}}},"_Splitter":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A draggable spacer between two items in a `dijit.layout.BorderContainer`.","container":{"!doc":"Pointer to the parent BorderContainer","!type":"+dijit.layout.BorderContainer"},"child":{"!doc":"Pointer to the pane associated with this splitter","!type":"+dijit.layout._LayoutWidget"},"region":{"!doc":"Region of pane associated with this splitter.\n&quot;top&quot;, &quot;bottom&quot;, &quot;left&quot;, &quot;right&quot;.","!type":"string"},"live":{"!doc":"If true, the child's size changes and the child widget is redrawn as you drag the splitter;\notherwise, the size doesn't change until you drop the splitter (by mouse-up)","!type":"bool"},"templateString":{"!type":"string"},"postCreate":{"!type":"fn()"},"_computeMaxSize":{"!type":"fn()"},"_startDrag":{"!type":"fn(e: ?)"},"_stopDrag":{"!type":"fn(e: ?)"},"_cleanupHandlers":{"!type":"fn()"},"_onKeyPress":{"!type":"fn(e: +Event)"},"destroy":{"!type":"fn()"}}},"_Gutter":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Just a spacer div to separate side pane from center pane.\nBasically a trick to lookup the gutter/splitter width from the theme.","templateString":{"!type":"string"},"postCreate":{"!type":"fn()"}}},"ContentPane":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget that acts as a container for mixed HTML and widgets, and includes an Ajax interface","href":{"!doc":"The href of the content that displays now.\nSet this at construction if you want to load data externally when the\npane is shown.\t(Set preload=true to load it immediately.)\nChanging href after creation doesn't have any effect; use attr('href', ...);","!type":"string"},"content":{"!doc":"|| DomNode || NodeList || dijit._Widget\nThe innerHTML of the ContentPane.\nNote that the initialization parameter / argument to attr(&quot;content&quot;, ...)\ncan be a String, DomNode, Nodelist, or _Widget.","!type":"string"},"extractContent":{"!doc":"Extract visible content from inside of &lt;body&gt; .... &lt;/body&gt;.\nI.e., strip &lt;html&gt; and &lt;head&gt; (and it's contents) from the href","!type":"bool"},"parseOnLoad":{"!doc":"Parse content and create the widgets, if any.","!type":"bool"},"preventCache":{"!doc":"Prevent caching of data from href's by appending a timestamp to the href.","!type":"bool"},"preload":{"!doc":"Force load of data on initialization even if pane is hidden.","!type":"bool"},"refreshOnShow":{"!doc":"Refresh (re-download) content when pane goes from hidden to shown","!type":"bool"},"loadingMessage":{"!doc":"Message that shows while downloading","!type":"string"},"errorMessage":{"!doc":"Message that shows if an error occurs","!type":"string"},"isLoaded":{"!doc":"True if the ContentPane has data in it, either specified\nduring initialization (via href or inline content), or set\nvia attr('content', ...) / attr('href', ...)\n\nFalse if it doesn't have any content, or if ContentPane is\nstill in the process of downloading href.","!type":"bool"},"baseClass":{"!type":"string"},"doLayout":{"!doc":"- false - don't adjust size of children\n- true - if there is a single visible child widget, set it's size to\nhowever big the ContentPane is","!type":"bool"},"ioArgs":{"!doc":"Parameters to pass to xhrGet() request, for example:\n\t&lt;div dojoType=&quot;dijit.layout.ContentPane&quot; href=&quot;./bar&quot; ioArgs=&quot;{timeout: 500}&quot;&gt;"},"isContainer":{"!doc":"Just a flag indicating that this widget will call resize() on\nits children.   _LayoutWidget based widgets check for\n\n\t\tif(!this.getParent || !this.getParent()){\n\nand if getParent() returns false because !parent.isContainer,\nthen they resize themselves on initialization.","!type":"bool"},"postMixInProperties":{"!type":"fn()"},"buildRendering":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()","!doc":"See <code>dijit.layout._LayoutWidget.startup</code> for description.\nAlthough ContentPane doesn't extend _LayoutWidget, it does implement\nthe same API."},"_checkIfSingleChild":{"!type":"fn()","!doc":"Test if we have exactly one visible widget as a child,\nand if so assume that we are a container for that widget,\nand should propogate startup() and resize() calls to it.\nSkips over things like data stores since they aren't visible."},"setHref":{"!type":"fn(href: string)","!doc":"Deprecated.   Use attr('href', ...) instead."},"_setHrefAttr":{"!type":"fn(href: string)","!doc":"Hook so attr(&quot;href&quot;, ...) works."},"setContent":{"!type":"fn(data: string)","!doc":"Deprecated.   Use attr('content', ...) instead."},"_setContentAttr":{"!type":"fn(data: string)","!doc":"Hook to make attr(&quot;content&quot;, ...) work.\nReplaces old content with data content, include style classes from old content"},"_getContentAttr":{"!type":"fn()","!doc":"Hook to make attr(&quot;content&quot;) work"},"cancel":{"!type":"fn()","!doc":"Cancels an in-flight download of content"},"uninitialize":{"!type":"fn()"},"destroyRecursive":{"!type":"fn(preserveDom: bool)","!doc":"Destroy the ContentPane and its contents"},"resize":{"!type":"fn(size: ?)","!doc":"See <code>dijit.layout._LayoutWidget.resize</code> for description.\nAlthough ContentPane doesn't extend _LayoutWidget, it does implement\nthe same API."},"_isShown":{"!type":"fn()","!doc":"Returns true if the content is currently shown"},"_onShow":{"!type":"fn()","!doc":"Called when the ContentPane is made visible"},"_loadCheck":{"!type":"fn()","!doc":"Call this to load href contents if necessary."},"refresh":{"!type":"fn()","!doc":"[Re]download contents of href and display"},"_onLoadHandler":{"!type":"fn(data: ?)","!doc":"This is called whenever new content is being loaded"},"_onUnloadHandler":{"!type":"fn()","!doc":"This is called whenever the content is being unloaded"},"destroyDescendants":{"!type":"fn()","!doc":"Destroy all the widgets inside the ContentPane and empty containerNode"},"_setContent":{"!type":"fn(cont: ?, isFakeContent: ?)","!doc":"Insert the content into the container node"},"_onError":{"!type":"fn(type: ?, err: ?, consoleText: ?)"},"_scheduleLayout":{"!type":"fn()","!doc":"Call resize() on each of my child layout widgets, either now\n(if I'm currently visible) or when I become visible"},"_layoutChildren":{"!type":"fn()","!doc":"Since I am a Container widget, each of my children expects me to\ncall resize() or layout() on them."},"onLoad":{"!type":"fn(data: ?)","!doc":"Event hook, is called after everything is loaded and widgetified"},"onUnload":{"!type":"fn()","!doc":"Event hook, is called before old content is cleared"},"onDownloadStart":{"!type":"fn()","!doc":"Called before download starts."},"onContentError":{"!type":"fn(error: +Error)","!doc":"Called on DOM faults, require faults etc. in content.\n\nIn order to display an error message in the pane, return\nthe error message from this method, as an HTML string.\n\nBy default (if this method is not overriden), it returns\nnothing, so the error message is just printed to the console."},"onDownloadError":{"!type":"fn(error: +Error)","!doc":"Called when download error occurs.\n\nIn order to display an error message in the pane, return\nthe error message from this method, as an HTML string.\n\nDefault behavior (if this method is not overriden) is to display\nthe error message inside the pane."},"onDownloadEnd":{"!type":"fn()","!doc":"Called when download is finished."}}},"LayoutContainer":{"!type":"fn()","prototype":{"!proto":"dijit.layout._LayoutWidget.prototype","!doc":"Deprecated.  Use `dijit.layout.BorderContainer` instead.","baseClass":{"!type":"string"},"constructor":{"!type":"fn()"},"layout":{"!type":"fn()"},"addChild":{"!type":"fn(child: +dijit._Widget, insertIndex?: +Integer)"},"removeChild":{"!type":"fn(widget: +dijit._Widget)"}}},"LinkPane":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"A ContentPane with an href where (when declared in markup)\nthe title is specified as innerHTML rather than as a title attribute.","templateString":{"!type":"string"},"postMixInProperties":{"!type":"fn()"},"_fillContent":{"!type":"fn(source: +Node)"}}},"SplitContainer":{"!type":"fn()","prototype":{"!proto":"dijit.layout._LayoutWidget.prototype","!doc":"Deprecated.  Use `dijit.layout.BorderContainer` instead.","activeSizing":{"!doc":"If true, the children's size changes as you drag the bar;\notherwise, the sizes don't change until you drop the bar (by mouse-up)","!type":"bool"},"sizerWidth":{"!doc":"Size in pixels of the bar between each child\n\n\nFIXME: this should be a CSS attribute (at 7 because css wants it to be 7 until we fix to css)","!type":"+Integer"},"orientation":{"!doc":"either 'horizontal' or vertical; indicates whether the children are\narranged side-by-side or up/down.","!type":"string"},"persist":{"!doc":"Save splitter positions in a cookie","!type":"bool"},"baseClass":{"!type":"string"},"constructor":{"!type":"fn()"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"startup":{"!type":"fn()"},"_setupChild":{"!type":"fn(child: +dijit._Widget)"},"_onSizerMouseDown":{"!type":"fn(e: ?)"},"_addSizer":{"!type":"fn(index: ?)"},"removeChild":{"!type":"fn(widget: ?)","!doc":"Remove sizer, but only if widget is really our child and\nwe have at least one sizer to throw away"},"addChild":{"!type":"fn(child: +dijit._Widget, insertIndex?: +Integer)","!doc":"Add a child widget to the container"},"layout":{"!type":"fn()","!doc":"Do layout of panels"},"_movePanel":{"!type":"fn(panel: ?, pos: ?, size: ?)"},"_moveSlider":{"!type":"fn(slider: ?, pos: ?, size: ?)"},"_growPane":{"!type":"fn(growth: ?, pane: ?)"},"_checkSizes":{"!type":"fn()"},"beginSizing":{"!type":"fn(e: ?, i: ?)"},"changeSizing":{"!type":"fn(e: ?)"},"endSizing":{"!type":"fn(e: ?)"},"movePoint":{"!type":"fn()"},"legaliseSplitPoint":{"!type":"fn(a: ?)"},"_updateSize":{"!type":"fn()"},"_showSizingLine":{"!type":"fn()"},"_hideSizingLine":{"!type":"fn()"},"_moveSizingLine":{"!type":"fn()"},"_getCookieName":{"!type":"fn(i: ?)"},"_restoreState":{"!type":"fn()"},"_saveState":{"!type":"fn()"}}},"StackContainer":{"!type":"fn()","prototype":{"!proto":"dijit.layout._LayoutWidget.prototype","!doc":"A container that has multiple children, but shows only\none child at a time","doLayout":{"!doc":"If true, change the size of my currently displayed child to match my size","!type":"bool"},"persist":{"!doc":"Remembers the selected child across sessions\n\n\nBoolean","!type":"bool"},"baseClass":{"!type":"string"},"selectedChildWidget":{"!doc":"References the currently selected child widget, if any","!type":"+dijit._Widget"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"_setupChild":{"!type":"fn(child: +dijit._Widget)"},"addChild":{"!type":"fn(child: +dijit._Widget, insertIndex?: +Integer)"},"removeChild":{"!type":"fn(page: +dijit._Widget)"},"selectChild":{"!type":"fn(page: +dijit._Widget)","!doc":"Show the given widget (which must be one of my children)"},"_transition":{"!type":"fn(newWidget: +dijit._Widget, oldWidget: +dijit._Widget)","!doc":"Hide the old widget and display the new widget.\nSubclasses should override this."},"_adjacent":{"!type":"fn(forward: bool) -> +dijit._Widget","!doc":"Gets the next/previous child widget in this container from the current selection."},"forward":{"!type":"fn()","!doc":"Advance to next page."},"back":{"!type":"fn()","!doc":"Go back to previous page."},"_onKeyPress":{"!type":"fn(e: ?)"},"layout":{"!type":"fn()"},"_showChild":{"!type":"fn(page: +dijit._Widget)","!doc":"Show the specified child by changing it's CSS, and call _onShow()/onShow() so\nit can do any updates it needs regarding loading href's etc."},"_hideChild":{"!type":"fn(page: +dijit._Widget)","!doc":"Hide the specified child by changing it's CSS, and call _onHide() so\nit's notified."},"closeChild":{"!type":"fn(page: +dijit._Widget)","!doc":"Callback when user clicks the [X] to remove a page.\nIf onClose() returns true then remove and destroy the child."},"destroy":{"!type":"fn()"}}},"StackController":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Set of buttons to select a page in a page list.","templateString":{"!type":"string"},"containerId":{"!doc":"The id of the page container that I point to","!type":"string"},"buttonWidget":{"!doc":"The name of the button widget to create to correspond to each page","!type":"string"},"postCreate":{"!type":"fn()"},"onStartup":{"!type":"fn(info: ?)","!doc":"Called after StackContainer has finished initializing"},"destroy":{"!type":"fn()"},"onAddChild":{"!type":"fn(page: +dijit._Widget, insertIndex?: +Integer)","!doc":"Called whenever a page is added to the container.\nCreate button corresponding to the page."},"onRemoveChild":{"!type":"fn(page: +dijit._Widget)","!doc":"Called whenever a page is removed from the container.\nRemove the button corresponding to the page."},"onSelectChild":{"!type":"fn(page: +dijit._Widget)","!doc":"Called when a page has been selected in the StackContainer, either by me or by another StackController"},"onButtonClick":{"!type":"fn(page: +dijit._Widget)","!doc":"Called whenever one of my child buttons is pressed in an attempt to select a page"},"onCloseButtonClick":{"!type":"fn(page: +dijit._Widget)","!doc":"Called whenever one of my child buttons [X] is pressed in an attempt to close a page"},"adjacent":{"!type":"fn(forward: bool) -> +dijit._Widget","!doc":"Helper for onkeypress to find next/previous button"},"onkeypress":{"!type":"fn(e: +Event)","!doc":"Handle keystrokes on the page list, for advancing to next/previous button\nand closing the current page if the page is closable."},"onContainerKeyPress":{"!type":"fn(info: ?)","!doc":"Called when there was a keypress on the container"}}},"_StackButton":{"!type":"fn()","prototype":{"!proto":"dijit.form.ToggleButton.prototype","!doc":"Internal widget used by StackContainer.","tabIndex":{"!type":"string"},"postCreate":{"!type":"fn(evt: +Event)"},"onClick":{"!type":"fn(evt: +Event)","!doc":"This is for TabContainer where the tabs are &lt;span&gt; rather than button,\nso need to set focus explicitly (on some browsers)\nNote that you shouldn't override this method, but you can connect to it."},"onClickCloseButton":{"!type":"fn(evt: +Event)","!doc":"StackContainer connects to this function; if your widget contains a close button\nthen clicking it should call this function.\nNote that you shouldn't override this method, but you can connect to it."}}},"TabContainer":{"!type":"fn()","prototype":{"!proto":"dijit.layout.StackContainer.prototype","!doc":"A Container with tabs to select each child (only one of which is displayed at a time).","tabPosition":{"!doc":"Defines where tabs go relative to tab content.\n&quot;top&quot;, &quot;bottom&quot;, &quot;left-h&quot;, &quot;right-h&quot;","!type":"string"},"baseClass":{"!type":"string"},"tabStrip":{"!doc":"Defines whether the tablist gets an extra class for layouting, putting a border/shading\naround the set of tabs.","!type":"bool"},"nested":{"!doc":"If true, use styling for a TabContainer nested inside another TabContainer.\nFor tundra etc., makes tabs look like links, and hides the outer\nborder since the outer TabContainer already has a border.\n\n\noverride setting in StackContainer","!type":"bool"},"templateString":{},"templatePath":{},"_controllerWidget":{"!doc":"An optional parameter to overrider the default TabContainer controller used.","!type":"string"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"_setupChild":{"!type":"fn(tab: +dijit._Widget)"},"startup":{"!type":"fn()"},"layout":{"!type":"fn()"},"destroy":{"!type":"fn()"}}},"TabController":{"!type":"fn()","prototype":{"!proto":"dijit.layout.StackController.prototype","!doc":"Set of tabs (the things with titles and a close button, that you click to show a tab panel).\nUsed internally by `dijit.layout.TabContainer`.","templateString":{"!type":"string"},"tabPosition":{"!doc":"Defines where tabs go relative to the content.\n&quot;top&quot;, &quot;bottom&quot;, &quot;left-h&quot;, &quot;right-h&quot;","!type":"string"},"buttonWidget":{"!doc":"The name of the tab widget to create to correspond to each page","!type":"string"},"_rectifyRtlTabList":{"!type":"fn()","!doc":"Rectify the width of all tabs in rtl, otherwise the tab widths are different in IE"}}},"_TabButton":{"!type":"fn()","prototype":{"!proto":"dijit.layout._StackButton.prototype","!doc":"A tab (the thing you click to select a pane).","baseClass":{"!type":"string"},"templatePath":{},"scrollOnFocus":{"!type":"bool"},"postCreate":{"!type":"fn()"},"_onCloseButtonEnter":{"!type":"fn()","!doc":"Handler when mouse is moved over the close icon (the X)"},"_onCloseButtonLeave":{"!type":"fn()","!doc":"Handler when mouse is moved off the close icon (the X)"}}},"_LayoutWidget":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Base class for a _Container widget which is responsible for laying out its children.\nWidgets which mixin this code must define layout() to lay out the children.","baseClass":{"!doc":"This class name is applied to the widget's domNode\nand also may be used to generate names for sub nodes,\nlike for example dijitTabContainer-content.","!type":"string"},"isLayoutContainer":{"!doc":"TODO: this is unused, but maybe it *should* be used for a child to\ndetect whether the parent is going to call resize() on it or not\n(see calls to getParent() and resize() in this file)","!type":"bool"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()","!doc":"Called after all the widgets have been instantiated and their\ndom nodes have been inserted somewhere under dojo.doc.body.\n\nWidgets should override this method to do any initialization\ndependent on other widgets existing, and then call\nthis superclass method to finish things off.\n\nstartup() in subclasses shouldn't do anything\nsize related because the size of the widget hasn't been set yet."},"resize":{"!type":"fn(changeSize?: ?, resultSize?: ?)","!doc":"Call this to resize a widget, or after its size has changed."},"layout":{"!type":"fn()","!doc":"Widgets override this method to size and position their contents/children.\nWhen this is called this._contentBox is guaranteed to be set (see resize()).\n\nThis is called after startup(), and also when the widget's size has been\nchanged."},"_setupChild":{"!type":"fn(child: +dijit._Widget)","!doc":"Common setup for initial children and children which are added after startup"},"addChild":{"!type":"fn(child: +dijit._Widget, insertIndex?: +Integer)"},"removeChild":{"!type":"fn(child: +dijit._Widget)"}}}},"tree":{"__SourceArgs":{"!type":"fn()","!doc":"A dict of parameters for Tree source configuration.\nisSource: Boolean?\nCan be used as a DnD source. Defaults to true.\naccept: String[]\nList of accepted types (text strings) for a target; defaults to\n[&quot;text&quot;]\ncopyOnly: Boolean?\nCopy items, if true, use a state of Ctrl key otherwise,\ndragThreshold: Number\nThe move delay in pixels before detecting a drag; 0 by default\nbetweenThreshold: Integer\nDistance from upper/lower edge of node to allow drop to reorder nodes"},"ForestStoreModel":{"!type":"fn()","prototype":{"!proto":"dijit.tree.TreeStoreModel.prototype","!doc":"Interface between Tree and a dojo.store that doesn't have a root item,\ni.e. has multiple \"top level\" items.\n\ndescription\nUse this class to wrap a dojo.store, making all the items matching the specified query\nappear as children of a fabricated \"root item\".  If no query is specified then all the\nitems returned by fetch() on the underlying store become children of the root item.\nIt allows dijit.Tree to assume a single root item, even if the store doesn't have one.","rootId":{"!doc":"ID of fabricated root item","!type":"string"},"rootLabel":{"!doc":"Label of fabricated root item","!type":"string"},"query":{"!doc":"Specifies the set of children of the root item.","!type":"string"},"constructor":{"!type":"fn(params: ?)","!doc":"Sets up variables, etc."},"mayHaveChildren":{"!type":"fn(item: +dojo.data.Item)","!doc":"Tells if an item has or may have children.  Implementing logic here\navoids showing +/- expando icon for nodes that we know don't have children.\n(For efficiency reasons we may not want to check if an element actually\nhas children until user clicks the expando node)"},"getChildren":{"!type":"fn(parentItem: +dojo.data.Item, callback: fn(items), onError: fn)","!doc":"Calls onComplete() with array of child items of given parent item, all loaded."},"getIdentity":{"!type":"fn(item: +item)"},"getLabel":{"!type":"fn(item: +item)"},"newItem":{"!type":"fn(args?: ?, parent: +Item)","!doc":"Creates a new item.   See dojo.data.api.Write for details on args.\nUsed in drag &amp; drop when item from external source dropped onto tree."},"onNewRootItem":{"!type":"fn(args: ?)","!doc":"User can override this method to modify a new element that's being\nadded to the root of the tree, for example to add a flag like root=true"},"pasteItem":{"!type":"fn(childItem: +Item, oldParentItem: +Item, newParentItem: +Item, bCopy: bool, insertIndex?: number)","!doc":"Move or copy an item from one parent item to another.\nUsed in drag &amp; drop"},"onAddToRoot":{"!type":"fn(item: +item)","!doc":"Called when item added to root of tree; user must override this method\nto modify the item so that it matches the query for top level items"},"onLeaveRoot":{"!type":"fn(item: +item)","!doc":"Called when item removed from root of tree; user must override this method\nto modify the item so it doesn't match the query for top level items"},"_requeryTop":{"!type":"fn()"},"_onNewItem":{"!type":"fn(item: +dojo.data.Item, parentInfo: ?)","!doc":"Handler for when new items appear in the store."},"_onDeleteItem":{"!type":"fn(item: ?)","!doc":"Handler for delete notifications from underlying store"}}},"TreeStoreModel":{"!type":"fn()","prototype":{"!doc":"Implements dijit.Tree.model connecting to a store with a single\nroot item.  Any methods passed into the constructor will override\nthe ones defined here.","store":{"!doc":"Underlying store","!type":"+dojo.data.Store"},"childrenAttrs":{"!doc":"One or more attribute names (attributes in the dojo.data item) that specify that item's children","!type":"[string]"},"labelAttr":{"!doc":"If specified, get label for tree node from this attribute, rather\nthan by calling store.getLabel()","!type":"string"},"root":{"!doc":"Pointer to the root item (read only, not a parameter)","!type":"+dojo.data.Item"},"query":{"!doc":"Specifies datastore query to return the root item for the tree.\nMust only return a single item.   Alternately can just pass in pointer\nto root item.","!type":"+anything"},"constructor":{"!type":"fn(args: ?)","!doc":"Passed the arguments listed above (store, etc)"},"destroy":{"!type":"fn()"},"getRoot":{"!type":"fn(onItem: ?, onError: ?)","!doc":"Calls onItem with the root item for the tree, possibly a fabricated item.\nCalls onError on error."},"mayHaveChildren":{"!type":"fn(item: +dojo.data.Item)","!doc":"Tells if an item has or may have children.  Implementing logic here\navoids showing +/- expando icon for nodes that we know don't have children.\n(For efficiency reasons we may not want to check if an element actually\nhas children until user clicks the expando node)"},"getChildren":{"!type":"fn(parentItem: +dojo.data.Item, onComplete: fn(items), onError: fn)","!doc":"Calls onComplete() with array of child items of given parent item, all loaded."},"getIdentity":{"!type":"fn(item: +item) -> ?"},"getLabel":{"!type":"fn(item: +dojo.data.Item) -> string","!doc":"Get the label for an item"},"newItem":{"!type":"fn(args?: ?, parent: +Item)","!doc":"Creates a new item.   See <code>dojo.data.api.Write</code> for details on args.\nUsed in drag &amp; drop when item from external source dropped onto tree."},"pasteItem":{"!type":"fn(childItem: +Item, oldParentItem: +Item, newParentItem: +Item, bCopy: bool, insertIndex?: number)","!doc":"Move or copy an item from one parent item to another.\nUsed in drag &amp; drop"},"onChange":{"!type":"fn(item: +dojo.data.Item)","!doc":"Callback whenever an item has changed, so that Tree\ncan update the label, icon, etc.   Note that changes\nto an item's children or parent(s) will trigger an\nonChildrenChange() so you can ignore those changes here."},"onChildrenChange":{"!type":"fn(parent: +dojo.data.Item, newChildrenList: [+dojo.data.Item])","!doc":"Callback to do notifications about new, updated, or deleted items."},"onDelete":{"!type":"fn(parent: +dojo.data.Item, newChildrenList: [+dojo.data.Item])","!doc":"Callback when an item has been deleted."},"_onNewItem":{"!type":"fn(item: +dojo.data.Item, parentInfo: ?)","!doc":"Handler for when new items appear in the store."},"_onDeleteItem":{"!type":"fn(item: ?)","!doc":"Handler for delete notifications from underlying store"},"_onSetItem":{"!type":"fn(item: +item, attribute: ?, oldValue: ?, newValue: ?)","!doc":"Set data event on an item in the store"}}},"_dndContainer":{"!type":"fn()","!doc":"This is a base class for `dijit.tree._dndSelector`, and isn't meant to be used directly.\nIt's modeled after `dojo.dnd.Container`.","prototype":{"constructor":{"!type":"fn(tree: +Node, params: +dijit.tree.__SourceArgs)","!doc":"A constructor of the Container"},"getItem":{"!type":"fn(key: string)","!doc":"Returns a data item by it's key (id).\nCalled by dojo.dnd.Source.checkAcceptance()"},"destroy":{"!type":"fn()","!doc":"Prepares this object to be garbage-collected"},"onMouseOver":{"!type":"fn(widget: +TreeNode, evt: +Event)","!doc":"Called when mouse is moved over a TreeNode"},"onMouseOut":{"!type":"fn(widget: +TreeNode, evt: +Event)","!doc":"Called when mouse is moved away from a TreeNode"},"_changeState":{"!type":"fn(type: string, newState: string)","!doc":"Changes a named state to new state value"},"_addItemClass":{"!type":"fn(node: +Node, type: string)","!doc":"Adds a class with prefix &quot;dojoDndItem&quot;"},"_removeItemClass":{"!type":"fn(node: +Node, type: string)","!doc":"Removes a class with prefix &quot;dojoDndItem&quot;"},"onOverEvent":{"!type":"fn()","!doc":"This function is called once, when mouse is over our container"},"onOutEvent":{"!type":"fn()","!doc":"This function is called once, when mouse is out of our container"}}},"_dndSelector":{"!type":"fn()","!doc":"This is a base class for `dijit.tree.dndSource` , and isn't meant to be used directly.\nIt's based on `dojo.dnd.Selector`.","prototype":{"singular":{"!doc":"Apparently this is indicates whether a single or multiple elements are\nselected, but AFAIK Tree doesn't support multiple selection, so it doesn't\ndo anything.   (There is, however, a bunch of dead code that would only run\nif singular == true)\n\n\nis singular property","!type":"bool"},"constructor":{"!type":"fn(tree: ?, params: ?)","!doc":"Initialization"},"getSelectedNodes":{"!type":"fn()","!doc":"Returns the set of selected nodes.\nUsed by dndSource on the start of a drag."},"selectNone":{"!type":"fn() -> +self","!doc":"Unselects all items"},"destroy":{"!type":"fn()","!doc":"Prepares the object to be garbage-collected"},"onMouseDown":{"!type":"fn(e: +Event)","!doc":"Event processor for onmousedown"},"onMouseUp":{"!type":"fn(e: +Event)","!doc":"Event processor for onmouseup"},"_removeSelection":{"!type":"fn() -> +self","!doc":"Unselects all items"},"_removeAnchor":{"!type":"fn() -> +self","!doc":"Removes the Anchor CSS class from a node.\nAccording to <code>dojo.dnd.Selector</code>, anchor means that\n&quot;an item is selected, and is an anchor for a 'shift' selection&quot;.\nIt's not relevant for Tree at this point, since we don't support multiple selection."}}},"dndSource":{"!type":"fn()","!doc":"Handles drag and drop operations (as a source or a target) for `dijit.Tree`","prototype":{"isSource":{"!doc":"Can be used as a DnD source.","!type":"bool"},"accept":{"!doc":"List of accepted types (text strings) for the Tree; defaults to\n[&quot;text&quot;]","!type":"[string]"},"copyOnly":{"!doc":"Copy items, if true, use a state of Ctrl key otherwise","!type":"bool"},"dragThreshold":{"!doc":"The move delay in pixels before detecting a drag; 0 by default","!type":"number"},"betweenThreshold":{"!doc":"Distance from upper/lower edge of node to allow drop to reorder nodes","!type":"+Integer"},"constructor":{"!type":"fn(tree: +dijit.Tree, params: +dijit.tree.__SourceArgs)","!doc":"a constructor of the Tree DnD Source"},"checkAcceptance":{"!type":"fn(source: +dijit.tree.dndSource, nodes: [+DOMNode]) -> bool","!doc":"Checks if the target can accept nodes from this source"},"copyState":{"!type":"fn(keyPressed: bool) -> bool","!doc":"Returns true, if we need to copy items, false to move.\nIt is separated to be overwritten dynamically, if needed."},"destroy":{"!type":"fn()","!doc":"Prepares the object to be garbage-collected."},"_onDragMouse":{"!type":"fn(e: ?)","!doc":"Helper method for processing onmousemove/onmouseover events while drag is in progress.\nKeeps track of current drop target."},"onMouseMove":{"!type":"fn(e: +Event)","!doc":"Called for any onmousemove events over the Tree"},"onMouseDown":{"!type":"fn(e: +Event)","!doc":"Event processor for onmousedown"},"onMouseUp":{"!type":"fn(e: +Event)","!doc":"Event processor for onmouseup"},"onMouseOver":{"!type":"fn(widget: +TreeNode, e: +Event)","!doc":"Event processor for when mouse is moved over a TreeNode"},"onMouseOut":{"!type":"fn()","!doc":"Event processor for when mouse is moved away from a TreeNode"},"checkItemAcceptance":{"!type":"fn(target: +Node, source: +dijit.tree.dndSource, position: string)","!doc":"Stub function to be overridden if one wants to check for the ability to drop at the node/item level"},"onDndSourceOver":{"!type":"fn(source: ?)","!doc":"Topic event processor for /dnd/source/over, called when detected a current source."},"onDndStart":{"!type":"fn(source: ?, nodes: [+DomNode], copy: bool)","!doc":"Topic event processor for /dnd/start, called to initiate the DnD operation"},"itemCreator":{"!type":"fn(nodes: ?)","!doc":"Returns the &quot;item&quot; passed to the drop target\n(which is not necessarily a Tree, could be anything)"},"onDndDrop":{"!type":"fn(source: ?, nodes: [+DomNode], copy: bool)","!doc":"Topic event processor for /dnd/drop, called to finish the DnD operation."},"onDndCancel":{"!type":"fn()","!doc":"Topic event processor for /dnd/cancel, called to cancel the DnD operation"},"onOverEvent":{"!type":"fn()","!doc":"This method is called when mouse is moved over our container (like onmouseenter)"},"onOutEvent":{"!type":"fn()","!doc":"This method is called when mouse is moved out of our container (like onmouseleave)"},"_unmarkTargetAnchor":{"!type":"fn()","!doc":"Removes hover class of the current target anchor"},"_markDndStatus":{"!type":"fn(copy: ?)","!doc":"Changes source's state based on &quot;copy&quot; status"}}},"model":{"!type":"fn()","!doc":"Contract for any data provider object for the tree.","prototype":{"destroy":{"!type":"fn()","!doc":"Destroys this object, releasing connections to the store"},"getRoot":{"!type":"fn(onItem: ?)","!doc":"Calls onItem with the root item for the tree, possibly a fabricated item.\nThrows exception on error."},"mayHaveChildren":{"!type":"fn(item: +dojo.data.Item)","!doc":"Tells if an item has or may have children.  Implementing logic here\navoids showing +/- expando icon for nodes that we know don't have children.\n(For efficiency reasons we may not want to check if an element actually\nhas children until user clicks the expando node)"},"getChildren":{"!type":"fn(parentItem: +dojo.data.Item, onComplete: fn(items))","!doc":"Calls onComplete() with array of child items of given parent item, all loaded.\nThrows exception on error."},"getIdentity":{"!type":"fn(item: +item)","!doc":"Returns identity for an item"},"getLabel":{"!type":"fn(item: +dojo.data.Item)","!doc":"Get the label for an item"},"newItem":{"!type":"fn(args?: ?, parent?: +Item)","!doc":"Creates a new item.   See <code>dojo.data.api.Write</code> for details on args."},"pasteItem":{"!type":"fn(childItem: +Item, oldParentItem: +Item, newParentItem: +Item, bCopy: bool)","!doc":"Move or copy an item from one parent item to another.\nUsed in drag &amp; drop.\nIf oldParentItem is specified and bCopy is false, childItem is removed from oldParentItem.\nIf newParentItem is specified, childItem is attached to newParentItem."},"onChange":{"!type":"fn(item: +dojo.data.Item)","!doc":"Callback whenever an item has changed, so that Tree\ncan update the label, icon, etc.   Note that changes\nto an item's children or parent(s) will trigger an\nonChildrenChange() so you can ignore those changes here."},"onChildrenChange":{"!type":"fn(parent: +dojo.data.Item, newChildrenList: [+dojo.data.Item])","!doc":"Callback to do notifications about new, updated, or deleted items."}}}}},"dojo":{"global":{"!doc":"Alias for the global scope\n(e.g. the window object in a browser)."},"isIE":{"!type":"number"},"isOpera":{"!type":"number"},"isFF":{"!type":"number"},"isWebKit":{"!type":"number"},"NodeList-fx":{"!doc":"Adds dojo.fx animation support to dojo.query()"},"NodeList-html":{"!doc":"Adds a chainable html method to dojo.query() / Nodelist instances for setting/replacing node content"},"_scopeArgs":{"!type":"[]"},"locale":{"!doc":"the locale as defined by Dojo (read-only)"},"isBrowser":{"!type":"bool"},"isKhtml":{"!type":"number"},"isMozilla":{"!type":"number"},"isSafari":{"!type":"number"},"isChrome":{"!type":"number"},"baseUrl":{"!doc":"The root relative path to dojo.js (as a string)","!type":"string"},"isAIR":{"!type":"number"},"isMoz":{},"isQuirks":{"!type":"bool"},"_XMLHTTP_PROGIDS":{"!type":"[]"},"_windowUnloaders":{"!type":"[]"},"_name":{"!type":"string"},"_defaultContext":{"!type":"[]"},"_initFired":{"!type":"bool"},"isRhino":{"!type":"bool"},"_timeouts":{"!type":"[]"},"isSpidermonkey":{"!doc":"Detect spidermonkey","!type":"bool"},"_loadedModules":{},"_inFlightCount":{"!type":"number"},"_hasResource":{},"_loadedUrls":{"!type":"[]"},"_postLoad":{"!type":"bool"},"_loaders":{"!type":"[]"},"_unloaders":{"!type":"[]"},"_loadNotifying":{"!type":"bool"},"_global_omit_module_check":{"!type":"bool"},"requireAfterIf":{},"nonDebugProvide":{},"_xdDebugQueue":{},"_xdReqLoc":{},"_xdBundleMap":{},"_xdRealRequireLocalization":{},"_topics":{},"subscribe":{},"unsubscribe":{},"publish":{},"_ieListenersName":{"!type":"string"},"_Animation":{},"boxModel":{"!type":"string"},"_bodyLtr":{"!type":"bool"},"toJsonIndentStr":{"!type":"string"},"_delegate":{},"_blockAsync":{"!type":"bool"},"jaxer":{},"parser":{},"robot":{},"robotx":{},"tests":{"!doc":"D.O.H. Test files for Dojo unit testing."},"_defaultXhr":{},"trim":{"!type":"fn(str: string) -> string","!doc":"Trims whitespace from both sides of the string"},"_connect":{"!type":"fn(obj: ?, event: ?, context: ?, method: ?, dontFix: ?) -> +Handle"},"connect":{"!type":"fn(obj: +Object, event: string, context: +Object, method: string, dontFix: bool)","!doc":"Create a link that calls one function when another executes."},"body":{"!type":"fn() -> +Node","!doc":"Return the body element of the document\nreturn the body object associated with dojo.doc"},"blendColors":{"!type":"fn(start: +dojo.Color, end: +dojo.Color, weight: number, obj?: +dojo.Color) -> +dojo.Color","!doc":"Blend colors end and start with weight from 0 to 1, 0.5 being a 50/50 blend,\ncan reuse a previously allocated dojo.Color object for the result"},"colorFromRgb":{"!type":"fn(color: string, obj?: +dojo.Color) -> +dojo.Color","!doc":"get rgb(a) array from css-style color declarations"},"colorFromHex":{"!type":"fn(color: string, obj?: +dojo.Color) -> +dojo.Color","!doc":"converts a hex string with a '#' prefix to a color object.\nSupports 12-bit #rgb shorthand."},"colorFromArray":{"!type":"fn(a: [], obj?: +dojo.Color) -> +dojo.Color","!doc":"builds a color from 1, 2, 3, or 4 element array"},"colorFromString":{"!type":"fn(str: string, obj?: +dojo.Color)","!doc":"parses str for a color value."},"_mixin":{"!type":"fn(obj: ?, props: ?) -> ?","!doc":"Adds all properties and methods of props to obj. This addition\nis &quot;prototype extension safe&quot;, so that instances of objects\nwill not pass along prototype defaults."},"mixin":{"!type":"fn(obj: ?, props: ?) -> ?","!doc":"Adds all properties and methods of props to obj and returns the\n(now modified) obj."},"_getProp":{"!type":"fn(parts: [], create: bool, context: ?) -> +mixed"},"setObject":{"!type":"fn(name: string, value: ?, context?: ?) -> ?","!doc":"Set a property from a dot-separated string, such as &quot;A.B.C&quot;"},"getObject":{"!type":"fn(name: string, create?: bool, context?: ?) -> ?","!doc":"Get a property from a dot-separated string, such as &quot;A.B.C&quot;"},"exists":{"!type":"fn(name: string, obj?: ?) -> bool","!doc":"determine if an object supports a given method"},"eval":{"!type":"fn(scriptFragment: string) -> ?","!doc":"Perform an evaluation in the global scope. Use this rather than\ncalling 'eval()' directly."},"deprecated":{"!type":"fn(behaviour: string, extra?: string, removal?: string)","!doc":"Log a debug message to indicate that a behavior has been\ndeprecated."},"experimental":{"!type":"fn(moduleName: string, extra?: string)","!doc":"Marks code as experimental."},"_xhrObj":{"!type":"fn()","!doc":"does the work of portably generating a new XMLHTTPRequest object."},"_isDocumentOk":{"!type":"fn(http: ?) -> bool"},"_getText":{"!type":"fn(uri: +URI, fail_ok: bool) -> +null","!doc":"Read the contents of the specified uri and return those contents."},"windowUnloaded":{"!type":"fn()","!doc":"signal fired by impending window destruction. You may use\ndojo.addOnWIndowUnload() or dojo.connect() to this method to perform\npage/application cleanup methods. See dojo.addOnWindowUnload for more info."},"addOnWindowUnload":{"!type":"fn(obj?: +Object, functionName?: string)","!doc":"registers a function to be triggered when window.onunload fires.\nBe careful trying to modify the DOM or access JavaScript properties\nduring this phase of page unloading: they may not always be available.\nConsider dojo.addOnUnload() if you need to modify the DOM or do heavy\nJavaScript work."},"addOnUnload":{"!type":"fn(obj?: +Object, functionName?: string)","!doc":"registers a function to be triggered when the page unloads."},"_loadUri":{"!type":"fn(uri: string, cb: fn(), currentIsXDomain: bool, module: string) -> bool","!doc":"Internal xd loader function. Overrides loadUri() from loader.js.\nxd loading requires slightly different behavior from loadPath()."},"pushContext":{"!type":"fn(g?: +Object, d?: +MDocumentElement) -> []","!doc":"causes subsequent calls to Dojo methods to assume the\npassed object and, optionally, document as the default\nscopes to use. A 2-element array of the previous global and\ndocument are returned."},"popContext":{"!type":"fn()","!doc":"If the context stack contains elements, ensure that\nsubsequent code executes in the *previous* context to the\ncurrent context. The current context set ([global,\ndocument]) is returned."},"_inContext":{"!type":"fn(g: ?, d: ?, f: ?)"},"_loadInit":{"!type":"fn(e: ?)"},"byId":{"!type":"fn(id: ?, doc: ?) -> +Node"},"exit":{"!type":"fn(exitcode: ?)"},"_rhinoCurrentScriptViaJava":{"!type":"fn(depth: ?)"},"_spidermonkeyCurrentFile":{"!type":"fn(depth: ?)"},"_moduleHasPrefix":{"!type":"fn(module: string) -> bool","!doc":"checks to see if module has been established"},"_getModulePrefix":{"!type":"fn(module: string) -> string","!doc":"gets the prefix associated with module"},"_loadPath":{"!type":"fn(relpath: string, module?: string, cb?: fn()) -> bool","!doc":"Internal xd loader function. Overrides loadPath() from loader.js.\nxd loading requires slightly different behavior from loadPath()."},"_loadUriAndCheck":{"!type":"fn(uri: string, moduleName: string, cb?: fn()) -> bool","!doc":"calls loadUri then findModule and returns true if both succeed"},"loaded":{"!type":"fn()","!doc":"signal fired when initial environment and package loading is\ncomplete. You should use dojo.addOnLoad() instead of doing a\ndirect dojo.connect() to this method in order to handle\ninitialization tasks that require the environment to be\ninitialized. In a browser host,\tdeclarative widgets will\nbe constructed when this function\tfinishes runing."},"unloaded":{"!type":"fn()","!doc":"signal fired by impending environment destruction. You should use\ndojo.addOnUnload() instead of doing a direct dojo.connect() to this\nmethod to perform page/application cleanup methods. See\ndojo.addOnUnload for more info."},"_onto":{"!type":"fn(arr: ?, obj: ?, fn: ?)"},"addOnLoad":{"!type":"fn(obj?: ?, functionName: string)","!doc":"Registers a function to be triggered after the DOM has finished\nloading and widgets declared in markup have been instantiated.\nImages and CSS files may or may not have finished downloading when\nthe specified function is called.  (Note that widgets' CSS and HTML\ncode is guaranteed to be downloaded before said widgets are\ninstantiated.)"},"_modulesLoaded":{"!type":"fn()"},"_callLoaded":{"!type":"fn()"},"_getModuleSymbols":{"!type":"fn(modulename: string) -> []","!doc":"Converts a module name in dotted JS notation to an array\nrepresenting the path in the source tree"},"loadInit":{"!type":"fn(init: fn())","!doc":"Executes a function that needs to be executed for the loader's dojo.requireIf\nresolutions to work. This is needed mostly for the xdomain loader case where\na function needs to be executed to set up the possible values for a dojo.requireIf\ncall."},"_loadModule":{"!type":"fn()"},"require":{"!type":"fn(moduleName: string, omitModuleCheck?: bool)","!doc":"loads a Javascript module from the appropriate URI"},"provide":{"!type":"fn(resourceName: string) -> ?","!doc":"Each javascript source file must have at least one\n<code>dojo.provide()</code> call at the top of the file, corresponding to\nthe file name.  For example, <code>js/dojo/foo.js</code> must have\n<code>dojo.provide(&quot;dojo.foo&quot;);</code> before any calls to\n<code>dojo.require()</code> are made."},"platformRequire":{"!type":"fn(modMap: ?)","!doc":"require one or more modules based on which host environment\nDojo is currently operating in"},"requireIf":{"!type":"fn(condition: bool, resourceName: string)","!doc":"If the condition is true then call dojo.require() for the specified\nresource"},"registerModulePath":{"!type":"fn(module: string, prefix: string)","!doc":"maps a module name to a path"},"requireLocalization":{"!type":"fn(moduleName: string, bundleName: string, locale?: string, availableFlatLocales?: string)","!doc":"loads a bundle intelligently based on whether the module is\nlocal or xd. Overrides the local-case implementation."},"moduleUrl":{"!type":"fn(module: string, url: +dojo._Url) -> string","!doc":"Returns a <code>dojo._Url</code> object relative to a module."},"_xdDebugFileLoaded":{"!type":"fn(resourceName: ?)"},"_xdReset":{"!type":"fn()","!doc":"Internal xd loader function. Resets the xd state."},"_xdCreateResource":{"!type":"fn(contents: string, resourceName: string, resourcePath: string) -> string","!doc":"Internal xd loader function. Creates an xd module source given an\nnon-xd module contents."},"_xdExtractLoadInits":{"!type":"fn(fileContents: string)"},"_xdIsXDomainPath":{"!type":"fn(relpath: string)","!doc":"Figure out whether the path is local or x-domain\nIf there is a colon before the first / then, we have a URL with a protocol."},"_xdResourceLoaded":{"!type":"fn(res: ?)","!doc":"Internal xd loader function. Called by an xd module resource when\nit has been loaded via a script tag."},"_xdLoadFlattenedBundle":{"!type":"fn(moduleName: string, bundleName: string, locale?: string, bundleData: ?)","!doc":"Internal xd loader function. Used when loading\na flattened localized bundle via a script tag."},"_xdInitExtraLocales":{"!type":"fn()"},"xdRequireLocalization":{"!type":"fn(m: ?, b: ?, locale?: string, fLocales: ?, moduleName: string, bundleName: string, availableFlatLocales: string)","!doc":"Internal xd loader function. The xd version of dojo.requireLocalization."},"_xdUnpackDependency":{"!type":"fn(dep: []) -> ?","!doc":"Internal xd loader function. Determines what to do with a dependency\nthat was listed in an xd version of a module contents."},"_xdWalkReqs":{"!type":"fn()","!doc":"Internal xd loader function.\nWalks the requires and evaluates module resource contents in\nthe right order."},"_xdEvalReqs":{"!type":"fn(reqChain: [])","!doc":"Internal xd loader function.\nDoes a depth first, breadth second search and eval of required modules."},"_xdClearInterval":{"!type":"fn()","!doc":"Internal xd loader function.\nClears the interval timer used to check on the\nstatus of in-flight xd module resource requests."},"_xdWatchInFlight":{"!type":"fn()","!doc":"Internal xd loader function.\nMonitors in-flight requests for xd module resources."},"_xdNotifyLoaded":{"!type":"fn()"},"indexOf":{"!type":"fn(array: [], value: ?, fromIndex?: +Integer, findLast?: bool) -> number","!doc":"locates the first index of the provided value in the\npassed array. If the value is not found, -1 is returned."},"lastIndexOf":{"!type":"fn(array: [], value: ?, fromIndex?: +Integer) -> number","!doc":"locates the last index of the provided value in the passed\narray. If the value is not found, -1 is returned."},"forEach":{"!type":"fn(arr: [], callback: fn(), thisObject?: ?)","!doc":"for every item in arr, callback is invoked. Return values are ignored."},"_everyOrSome":{"!type":"fn(every: bool, arr: [], callback: fn(), thisObject?: ?) -> bool"},"every":{"!type":"fn(arr: [], callback: fn(), thisObject?: ?) -> bool","!doc":"Determines whether or not every item in arr satisfies the\ncondition implemented by callback."},"some":{"!type":"fn(arr: [], callback: fn(), thisObject?: ?) -> bool","!doc":"Determines whether or not any item in arr satisfies the\ncondition implemented by callback."},"map":{"!type":"fn(arr: [], callback: fn(), thisObject?: fn()) -> []","!doc":"applies callback to each element of arr and returns\nan Array with the results"},"filter":{"!type":"fn(arr: [], callback: fn(), thisObject?: ?) -> []","!doc":"Returns a new Array with those items from arr that match the\ncondition implemented by callback."},"disconnect":{"!type":"fn(handle: +Handle)","!doc":"Remove a link created by dojo.connect."},"_disconnect":{"!type":"fn(obj: ?, event: ?, handle: ?, listener: ?)"},"connectPublisher":{"!type":"fn(topic: string, obj: +Object, event: string) -> +Handle","!doc":"Ensure that everytime obj.event() is called, a message is published\non the topic. Returns a handle which can be passed to\ndojo.disconnect() to disable subsequent automatic publication on\nthe topic."},"fixEvent":{"!type":"fn(evt: +Event, sender: +Node)","!doc":"normalizes properties on the event object including event\nbubbling methods, keystroke normalization, and x/y positions"},"stopEvent":{"!type":"fn(evt: +Event)","!doc":"prevents propagation and clobbers the default action of the\npassed event"},"_ieDispatcher":{"!type":"fn(args: ?, sender: ?)"},"_getIeDispatcher":{"!type":"fn() -> fn"},"_fade":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation that will fade the node defined by\nargs.node from the start to end values passed (args.start\nargs.end) (end is mandatory, start is optional)"},"__FadeArgs":{"!type":"fn(node: +DOMNode, duration?: +Integer, easing?: fn())"},"fadeIn":{"!type":"fn(args: +dojo.__FadeArgs) -> +dojo.Animation","!doc":"Returns an animation that will fade node defined in 'args' from\nits current opacity to fully opaque."},"fadeOut":{"!type":"fn(args: +dojo.__FadeArgs) -> +dojo.Animation","!doc":"Returns an animation that will fade node defined in 'args'\nfrom its current opacity to fully transparent."},"_defaultEasing":{"!type":"fn(n?: +Decimal)","!doc":"The default easing function for dojo.Animation(s)"},"animateProperty":{"!type":"fn(args: +dojo.__AnimArgs) -> +dojo.Animation","!doc":"Returns an animation that will transition the properties of\nnode defined in <code>args</code> depending how they are defined in\n<code>args.properties</code>"},"anim":{"!type":"fn(node: +DOMNode, properties: ?, duration?: +Integer, easing?: fn(), onEnd?: fn(), delay?: +Integer) -> +dojo.Animation","!doc":"A simpler interface to <code>dojo.animateProperty()</code>, also returns\nan instance of <code>dojo.Animation</code> but begins the animation\nimmediately, unlike nearly every other Dojo animation API."},"isString":{"!type":"fn(it: +anything) -> bool","!doc":"Return true if it is a String"},"_destroyElement":{"!type":"fn(node: ?)","!doc":"Existing alias for <code>dojo.destroy</code>. Deprecated, will be removed\nin 2.0"},"destroy":{"!type":"fn(node: string)","!doc":"Removes a node from its parent, clobbering it and all of its\nchildren."},"isDescendant":{"!type":"fn(node: +DomNode, ancestor: +DomNode) -> bool","!doc":"Returns true if node is a descendant of ancestor"},"setSelectable":{"!type":"fn(node: +DomNode, selectable: bool)","!doc":"enable or disable selection on a node"},"place":{"!type":"fn(node: string, refNode: string, position?: string) -> +Node","!doc":"Attempt to insert node into the DOM, choosing from various positioning options.\nReturns the first argument resolved to a DOM node."},"getComputedStyle":{"!type":"fn(node: +Node) -> +CSS2Properties","!doc":"Returns a &quot;computed style&quot; object."},"_toPixelValue":{"!type":"fn(element: ?, value: ?, avalue: ?)"},"_getOpacity":{"!type":"fn(node: +Node) -> number","!doc":"Returns the current opacity of the passed node as a\nfloating-point value between 0 and 1."},"_setOpacity":{"!type":"fn(node: +Node, opacity: number) -> number","!doc":"set the opacity of the passed node portably. Returns the\nnew opacity of the node."},"style":{"!type":"fn(node: +DomNode, style?: string, value?: string)","!doc":"Accesses styles on a node. If 2 arguments are\npassed, acts as a getter. If 3 arguments are passed, acts\nas a setter."},"_getPadExtents":{"!type":"fn(n: +Node, computedStyle: ?)","!doc":"Returns object with special values specifically useful for node\nfitting."},"_getBorderExtents":{"!type":"fn(n: +Node, computedStyle: ?)","!doc":"returns an object with properties useful for noting the border\ndimensions."},"_getPadBorderExtents":{"!type":"fn(n: +Node, computedStyle: ?)","!doc":"Returns object with properties useful for box fitting with\nregards to padding."},"_getMarginExtents":{"!type":"fn(n: ?, computedStyle: ?)","!doc":"returns object with properties useful for box fitting with\nregards to box margins (i.e., the outer-box).\n\nl/t = marginLeft, marginTop, respectively\nw = total width, margin inclusive\nh = total height, margin inclusive\n\nThe w/h are used for calculating boxes.\nNormally application code will not need to invoke this\ndirectly, and will use the ...box... functions instead."},"_getMarginBox":{"!type":"fn(node: +Node, computedStyle: ?)","!doc":"returns an object that encodes the width, height, left and top\npositions of the node's margin box."},"_getContentBox":{"!type":"fn(node: ?, computedStyle: ?)","!doc":"Returns an object that encodes the width, height, left and top\npositions of the node's content box, irrespective of the\ncurrent box model."},"_getBorderBox":{"!type":"fn(node: ?, computedStyle: ?)"},"_setBox":{"!type":"fn(node: +Node, l?: number, t?: number, w?: number, h?: number, u?: string)","!doc":"sets width/height/left/top in the current (native) box-model\ndimentions. Uses the unit passed in u."},"_isButtonTag":{"!type":"fn(node: +Node)","!doc":"True if the node is BUTTON or INPUT.type=&quot;button&quot;."},"_usesBorderBox":{"!type":"fn(node: +Node) -> bool","!doc":"True if the node uses border-box layout."},"_setContentSize":{"!type":"fn(node: +Node, widthPx: number, heightPx: number, computedStyle: ?)","!doc":"Sets the size of the node's contents, irrespective of margins,\npadding, or borders."},"_setMarginBox":{"!type":"fn(node: +Node, leftPx?: number, topPx?: number, widthPx?: number, heightPx?: number, computedStyle: ?)","!doc":"sets the size of the node's margin box and placement\n(left/top), irrespective of box model. Think of it as a\npassthrough to dojo._setBox that handles box-model vagaries for\nyou."},"marginBox":{"!type":"fn(node: +DomNode, box?: ?) -> ?","!doc":"Getter/setter for the margin-box of node."},"contentBox":{"!type":"fn(node: +DomNode, box?: ?) -> ?","!doc":"Getter/setter for the content-box of node."},"_docScroll":{"!type":"fn()"},"_isBodyLtr":{"!type":"fn()"},"_getIeDocumentElementOffset":{"!type":"fn()","!doc":"returns the offset in x and y from the document body to the\nvisual edge of the page"},"_fixIeBiDiScrollLeft":{"!type":"fn(scrollLeft: +Integer) -> +Integer"},"_abs":{"!type":"fn(node: +Node, includeScroll?: bool) -> ?","!doc":"Gets the position of the passed element relative to\nthe viewport (if includeScroll==false), or relative to the\ndocument root (if includeScroll==true).\n\nReturns an object of the form:\n{ x: 100, y: 300 }\nif includeScroll is passed, the x and y values will include any\ndocument offsets that may affect the position relative to the\nviewport."},"coords":{"!type":"fn(node: +DomNode, includeScroll?: bool)","!doc":"Returns an object that measures margin box width/height and\nabsolute positioning data from dojo._abs()."},"hasAttr":{"!type":"fn(node: +DomNode, name: string) -> bool","!doc":"Returns true if the requested attribute is specified on the\ngiven element, and false otherwise."},"attr":{"!type":"fn(node: +DomNode, name: string, value?: string)","!doc":"Gets or sets an attribute on an HTML element."},"removeAttr":{"!type":"fn(node: +DomNode, name: string)","!doc":"Removes an attribute from an HTML element."},"create":{"!type":"fn(tag: string, attrs: ?, refNode?: string, pos?: string) -> +Node","!doc":"Create an element, allowing for optional attribute decoration\nand placement."},"empty":{"!type":"fn(node: +DOMNode)","!doc":"safely removes all children of the node."},"_toDom":{"!type":"fn(frag: string, doc?: +DocumentNode) -> +Node","!doc":"converts HTML string into DOM nodes."},"hasClass":{"!type":"fn(node: +DomNode, classStr: string) -> bool","!doc":"Returns whether or not the specified classes are a portion of the\nclass list currently applied to the node."},"addClass":{"!type":"fn(node: +DomNode, classStr: string)","!doc":"Adds the specified classes to the end of the class list on the\npassed node. Will not re-apply duplicate classes, except in edge\ncases when adding multiple classes at once."},"removeClass":{"!type":"fn(node: +DomNode, classStr: string)","!doc":"Removes the specified classes from node. No <code>dojo.hasClass</code>\ncheck is required."},"toggleClass":{"!type":"fn(node: +DomNode, classStr: string, condition?: bool)","!doc":"Adds a class to node if not present, or removes if present.\nPass a boolean condition if you want to explicitly add or remove."},"fromJson":{"!type":"fn(json: string) -> ?","!doc":"Parses a [JSON](http://json.org) string to return a JavaScript object.  Throws for invalid JSON strings."},"_escapeString":{"!type":"fn(str: string)","!doc":"Adds escape sequences for non-visual characters, double quote and\nbackslash and surrounds with double quotes to form a valid string\nliteral."},"toJson":{"!type":"fn(it: ?, prettyPrint?: bool, _indentStr?: string) -> +null","!doc":"Returns a [JSON](http://json.org) serialization of an object."},"isArray":{"!type":"fn(it: +anything) -> bool","!doc":"Return true if it is an Array"},"isFunction":{"!type":"fn(it: +anything) -> bool","!doc":"Return true if it is a Function"},"isObject":{"!type":"fn(it: +anything)","!doc":"Returns true if it is a JavaScript object (or an Array, a Function\nor null)"},"isArrayLike":{"!type":"fn(it: +anything) -> bool","!doc":"similar to dojo.isArray() but more permissive"},"isAlien":{"!type":"fn(it: +anything) -> bool","!doc":"Returns true if it is a built-in function or some other kind of\noddball that *should* report as a function but doesn't"},"extend":{"!type":"fn(constructor: ?, props: ?) -> ?","!doc":"Adds all properties and methods of props to constructor's\nprototype, making them available to all instances created with\nconstructor."},"_hitchArgs":{"!type":"fn(scope: ?, method: ?) -> +mixed"},"hitch":{"!type":"fn(scope: ?, method: fn()) -> fn()","!doc":"Returns a function that will only ever execute in the a given scope.\nThis allows for easy use of object member functions\nin callbacks and other places in which the &quot;this&quot; keyword may\notherwise not reference the expected scope.\nAny number of default positional arguments may be passed as parameters\nbeyond &quot;method&quot;.\nEach of these values will be used to &quot;placehold&quot; (similar to curry)\nfor the hitched function."},"delegate":{"!type":"fn(obj: +The, props: +an)","!doc":"Returns a new object which &quot;looks&quot; to obj for properties which it\ndoes not have a value for. Optionally takes a bag of properties to\nseed the returned object with initially."},"_toArray":{"!type":"fn()"},"partial":{"!type":"fn(method: fn()) -> fn()","!doc":"similar to hitch() except that the scope object is left to be\nwhatever the execution context eventually becomes."},"clone":{"!type":"fn(o: +anything) -> []","!doc":"Clones objects (including DOM nodes) and all children.\nWarning: do not clone cyclic structures."},"query":{"!type":"fn(query: string, root?: string, listCtor?: fn()) -> +dojo.NodeList"},"_filterQueryResult":{"!type":"fn(nodeList: ?, simpleFilter: ?)"},"setContext":{"!type":"fn(globalObject: ?, globalDocument: +DocumentElement)","!doc":"changes the behavior of many core Dojo functions that deal with\nnamespace and DOM lookup, changing them to work in a new global\ncontext (e.g., an iframe). The varibles dojo.global and dojo.doc\nare modified as a result of calling this function and the result of\n<code>dojo.body()</code> likewise differs."},"withGlobal":{"!type":"fn(globalObject: ?, callback: fn(), thisObject?: ?, cbArguments?: [])","!doc":"Invoke callback with globalObject as dojo.global and\nglobalObject.document as dojo.doc."},"withDoc":{"!type":"fn(documentObject: +DocumentElement, callback: fn(), thisObject?: ?, cbArguments?: [])","!doc":"Invoke callback with documentObject as dojo.doc."},"formToObject":{"!type":"fn(formNode: +DOMNode) -> ?","!doc":"dojo.formToObject returns the values encoded in an HTML form as\nstring properties in an object which it then returns. Disabled form\nelements, buttons, and other non-value form elements are skipped.\nMulti-select elements are returned as an array of string values."},"objectToQuery":{"!type":"fn(map: ?) -> string","!doc":"takes a name/value mapping object and returns a string representing\na URL-encoded version of that object."},"formToQuery":{"!type":"fn(formNode: +DOMNode) -> string","!doc":"Returns a URL-encoded string representing the form passed as either a\nnode or string ID identifying the form to serialize"},"formToJson":{"!type":"fn(formNode: +DOMNode, prettyPrint?: bool) -> string","!doc":"return a serialized JSON string from a form node or string\nID identifying the form to serialize"},"queryToObject":{"!type":"fn(str: string) -> ?","!doc":"returns an object representing a de-serialized query section of a\nURL. Query keys with multiple values are returned in an array."},"__IoArgs":{"!type":"fn()"},"__IoCallbackArgs":{"!type":"fn(args: ?, xhr: +XMLHttpRequest, url: string, query: string, handleAs: string, id: string, canDelete: bool, json: ?)"},"_ioSetArgs":{"!type":"fn(args: +dojo.__IoArgs, canceller: fn(), okHandler: fn(), errHandler: fn())","!doc":"sets up the Deferred and ioArgs property on the Deferred so it\ncan be used in an io call."},"_ioCancelAll":{"!type":"fn()","!doc":"Cancels all pending IO requests, regardless of IO type\n(xhr, script, iframe)."},"_ioWatch":{"!type":"fn(dfd: +Deferred, validCheck: fn(), ioCheck: fn(), resHandle: fn())","!doc":"watches the io request represented by dfd to see if it completes."},"_ioAddQueryToUrl":{"!type":"fn(ioArgs: +dojo.__IoCallbackArgs)","!doc":"Adds query params discovered by the io deferred construction to the URL.\nOnly use this for operations which are fundamentally GET-type operations."},"xhr":{"!type":"fn(method: string, args: +dojo.__XhrArgs, hasBody?: bool) -> +dojo.Deferred","!doc":"Sends an HTTP request with the given method."},"xhrGet":{"!type":"fn(args: +dojo.__XhrArgs) -> +dojo.Deferred","!doc":"Sends an HTTP GET request to the server."},"rawXhrPost":{"!type":"fn()"},"xhrPost":{"!type":"fn(args: +dojo.__XhrArgs) -> +dojo.Deferred","!doc":"Sends an HTTP POST request to the server. In addtion to the properties\nlisted for the dojo.__XhrArgs type, the following property is allowed:\npostData:\nString. Send raw data in the body of the POST request."},"rawXhrPut":{"!type":"fn()"},"xhrPut":{"!type":"fn(args: +dojo.__XhrArgs) -> +dojo.Deferred","!doc":"Sends an HTTP PUT request to the server. In addtion to the properties\nlisted for the dojo.__XhrArgs type, the following property is allowed:\nputData:\nString. Send raw data in the body of the PUT request."},"xhrDelete":{"!type":"fn(args: +dojo.__XhrArgs) -> +dojo.Deferred","!doc":"Sends an HTTP DELETE request to the server."},"__backArgs":{"!type":"fn(kwArgs: ?)"},"behavior":{"!type":"fn()","!doc":"Utility for unobtrusive/progressive event binding, DOM traversal,\nand manipulation."},"__cookieProps":{"!type":"fn()"},"string":{"!doc":"String utilities for Dojo","substitute":{"!type":"fn(template: string, map: +Object, transform?: fn(), thisObject?: ?)","!doc":"Performs parameterized substitutions on a string. Throws an\nexception if any parameter is unmatched."},"rep":{"!type":"fn(str: string, num: +Integer) -> string","!doc":"Efficiently replicate a string <code>n</code> times."},"pad":{"!type":"fn(text: string, size: +Integer, ch?: string, end?: bool) -> string","!doc":"Pad a string to guarantee that it is at least <code>size</code> length by\nfilling with the character <code>ch</code> at either the start or end of the\nstring. Pads at the start, by default."},"trim":{"!type":"fn(str: string) -> string","!doc":"Trims whitespace from both sides of the string"}},"date":{"stamp":{"_isoRegExp":{"!type":"+RegExp"},"fromISOString":{"!type":"fn(formattedString: string, defaultTime?: number)","!doc":"Returns a Date object given a string formatted according to a subset of the ISO-8601 standard."},"__Options":{"!type":"fn()"},"toISOString":{"!type":"fn(dateObject: +Date, options?: +dojo.date.stamp.__Options) -> string","!doc":"Format a Date object as a string according a subset of the ISO-8601 standard"}},"!doc":"Date manipulation utilities","compare":{"!type":"fn(date1: +Date, date2?: +Date, portion?: string) -> number","!doc":"Compare two date objects by date, time, or both."},"getDaysInMonth":{"!type":"fn(dateObject: +Date) -> number","!doc":"Returns the number of days in the month used by dateObject"},"isLeapYear":{"!type":"fn(dateObject: +Date) -> bool","!doc":"Determines if the year of the dateObject is a leap year"},"getTimezoneName":{"!type":"fn(dateObject: +Date) -> string","!doc":"Get the user's time zone as provided by the browser"},"add":{"!type":"fn(date: +Date, interval: string, amount: number) -> +Date","!doc":"Add to a Date in intervals of different size, from milliseconds to years"},"difference":{"!type":"fn(date1: +Date, date2?: +Date, interval?: string)","!doc":"Get the difference in a specific unit of time (e.g., number of\nmonths, weeks, days, etc.) between two dates, rounded to the\nnearest integer."},"locale":{"__FormatOptions":{"!type":"fn()"},"format":{"!type":"fn(dateObject: +Date, options?: +dojo.date.locale.__FormatOptions) -> string","!doc":"Format a Date object as a String, using locale-specific settings."},"regexp":{"!type":"fn(options?: +dojo.date.locale.__FormatOptions) -> string","!doc":"Builds the regular needed to parse a localized date"},"_parseInfo":{"!type":"fn(options?: +dojo.date.locale.__FormatOptions)"},"parse":{"!type":"fn(value: string, options?: +dojo.date.locale.__FormatOptions) -> +null","!doc":"Convert a properly formatted string to a primitive Date object,\nusing locale-specific settings."},"addCustomFormats":{"!type":"fn(packageName: string, bundleName: string)","!doc":"Add a reference to a bundle containing localized custom formats to be\nused by date/time formatting and parsing routines."},"_getGregorianBundle":{"!type":"fn(locale: string)"},"getNames":{"!type":"fn(item: string, type: string, context?: string, locale?: string)","!doc":"Used to get localized strings from dojo.cldr for day or month names."},"displayPattern":{"!type":"fn(fixedPattern: string, locale?: string)","!doc":"Provides a localized representation of a date/time pattern string"},"isWeekend":{"!type":"fn(dateObject?: +Date, locale?: string) -> bool","!doc":"Determines if the date falls on a weekend, according to local custom."},"_getDayOfYear":{"!type":"fn(dateObject: +Date) -> number","!doc":"gets the day of the year as represented by dateObject"},"_getWeekOfYear":{"!type":"fn(dateObject: +Date, firstDayOfWeek: number) -> number"}}},"doc":{"!doc":"Alias for the current document. 'dojo.doc' can be modified\nfor temporary context shifting. Also see dojo.withDoc().","selection":{},"body":{},"styleSheets":{},"documentElement":{"className":{},"style":{"fontSize":{"!type":"string"}}}},"dnd":{"!doc":"Drag and Drop resources","_empty":{},"_manager":{},"V_TRIGGER_AUTOSCROLL":{"!type":"number"},"H_TRIGGER_AUTOSCROLL":{"!type":"number"},"V_AUTOSCROLL_VALUE":{"!type":"number"},"H_AUTOSCROLL_VALUE":{"!type":"number"},"autoscroll":{},"_isMac":{"!type":"bool"},"_copyKey":{},"_uniqueId":{"!type":"number"},"_lmb":{},"common":{},"constrainedMover":{},"boxConstrainedMover":{},"parentConstrainedMover":{},"_createNode":{"!type":"fn(tag: string) -> fn()","!doc":"returns a function, which creates an element of given tag\n(SPAN by default) and sets its innerHTML to given text"},"_createTrTd":{"!type":"fn(text: string) -> +Node","!doc":"creates a TR/TD structure with given text as an innerHTML of TD"},"_createSpan":{"!type":"fn(text: string) -> +Node","!doc":"creates a SPAN element with given text as its innerHTML"},"_defaultCreator":{"!type":"fn(node: +Node) -> fn()","!doc":"takes a parent node, and returns an appropriate creator function"},"manager":{"!type":"fn() -> ?","!doc":"returns the current DnD manager, creates one if it is not created yet"},"__SourceArgs":{"!type":"fn()","!doc":"a dict of parameters for DnD Source configuration. Note that any\nproperty on Source elements may be configured, but this is the\nshort-list\nisSource: Boolean?\ncan be used as a DnD source. Defaults to true.\naccept: Array?\nlist of accepted types (text strings) for a target; defaults to\n[&quot;text&quot;]\nautoSync: Boolean\nif true refreshes the node list on every operation; false by default\ncopyOnly: Boolean?\ncopy items, if true, use a state of Ctrl key otherwise,\nsee selfCopy and selfAccept for more details\ndelay: Number\nthe move delay in pixels before detecting a drag; 0 by default\nhorizontal: Boolean?\na horizontal container, if true, vertical otherwise or when omitted\nselfCopy: Boolean?\ncopy items by default when dropping on itself,\nfalse by default, works only if copyOnly is true\nselfAccept: Boolean?\naccept its own items when copyOnly is true,\ntrue by default, works only if copyOnly is true\nwithHandles: Boolean?\nallows dragging only by handles, false by default\ngenerateText: Boolean?\ngenerate text node for drag and drop, true by default"},"getViewport":{"!type":"fn() -> ?","!doc":"returns a viewport size (visible part of the window)"},"autoScroll":{"!type":"fn(e: +Event)","!doc":"a handler for onmousemove event, which scrolls the window, if\nnecesary"},"autoScrollNodes":{"!type":"fn(e: +Event)","!doc":"a handler for onmousemove event, which scrolls the first avaialble\nDom element, it falls back to dojo.dnd.autoScroll()"},"getCopyKeyState":{"!type":"fn(e: +Event) -> bool","!doc":"abstracts away the difference between selection on Mac and PC,\nand returns the state of the &quot;copy&quot; key to be pressed."},"getUniqueId":{"!type":"fn()","!doc":"returns a unique string for use with any DOM element"},"isFormElement":{"!type":"fn(e: +Event) -> bool","!doc":"returns true, if user clicked on a form element"},"_isLmbPressed":{"!type":"fn()"},"Avatar":{"!type":"fn()","prototype":{"!doc":"an object, which represents transferred DnD items visually\nmanager: Object: a DnD manager object","constructor":{"!type":"fn(manager: ?)"},"construct":{"!type":"fn()","!doc":"a constructor function;\nit is separate so it can be (dynamically) overwritten in case of need"},"destroy":{"!type":"fn()","!doc":"a desctructor for the avatar, called to remove all references so it can be garbage-collected"},"update":{"!type":"fn()","!doc":"updates the avatar to reflect the current DnD state"},"_generateText":{"!type":"fn()","!doc":"generates a proper text to reflect copying or moving of items"}}},"Container":{"!type":"fn()","prototype":{"!doc":"a Container object, which knows when mouse hovers over it,\nand over which element it hovers","skipForm":{"!doc":"don't start the drag operation, if clicked on form elements\ndropParent: Node: node or node's id to use as the parent node for dropped items\n(must be underneath the 'node' parameter in the DOM)\n_skipStartup: Boolean: skip startup(), which collects children, for deferred initialization\n(this is used in the markup mode)","!type":"bool"},"creator":{"!doc":"a creator function, which takes a data item, and returns an object like that:\n{node: newNode, data: usedData, type: arrayOfStrings}","!type":"fn()"},"constructor":{"!type":"fn(node: +Node, params: +Object)","!doc":"a constructor of the Container"},"getItem":{"!type":"fn(key: string) -> ?","!doc":"returns a data item by its key (id)"},"setItem":{"!type":"fn(key: string, data: ?)","!doc":"associates a data item with its key (id)"},"delItem":{"!type":"fn(key: string)","!doc":"removes a data item from the map by its key (id)"},"forInItems":{"!type":"fn(f: fn(), o?: ?) -> ?","!doc":"iterates over a data map skipping members, which\nare present in the empty object (IE and/or 3rd-party libraries)."},"clearItems":{"!type":"fn()","!doc":"removes all data items from the map"},"getAllNodes":{"!type":"fn() -> +NodeList","!doc":"returns a list (an array) of all valid child nodes"},"sync":{"!type":"fn() -> +self","!doc":"synch up the node list with the data map"},"insertNodes":{"!type":"fn(data: [], before: bool, anchor: +Node) -> +self","!doc":"inserts an array of new nodes before/after an anchor node"},"destroy":{"!type":"fn()","!doc":"prepares the object to be garbage-collected"},"markupFactory":{"!type":"fn(params: ?, node: ?)"},"startup":{"!type":"fn()","!doc":"collects valid child items and populate the map"},"onMouseOver":{"!type":"fn(e: +Event)","!doc":"event processor for onmouseover"},"onMouseOut":{"!type":"fn(e: +Event)","!doc":"event processor for onmouseout"},"onSelectStart":{"!type":"fn(e: +Event)","!doc":"event processor for onselectevent and ondragevent"},"onOverEvent":{"!type":"fn()","!doc":"this function is called once, when mouse is over our container"},"onOutEvent":{"!type":"fn()","!doc":"this function is called once, when mouse is out of our container"},"_changeState":{"!type":"fn(type: string, newState: string)","!doc":"changes a named state to new state value"},"_addItemClass":{"!type":"fn(node: +Node, type: string)","!doc":"adds a class with prefix &quot;dojoDndItem&quot;"},"_removeItemClass":{"!type":"fn(node: +Node, type: string)","!doc":"removes a class with prefix &quot;dojoDndItem&quot;"},"_getChildByEvent":{"!type":"fn(e: +Event)","!doc":"gets a child, which is under the mouse at the moment, or null"},"_normalizedCreator":{"!type":"fn(item: ?, hint: ?)","!doc":"adds all necessary data to the output of the user-supplied creator function"}}},"_defaultCreatorNodes":{"ul":{"!type":"string"},"ol":{"!type":"string"},"div":{"!type":"string"},"p":{"!type":"string"}},"Manager":{"!type":"fn()","prototype":{"!doc":"the manager of DnD operations (usually a singleton)","OFFSET_X":{"!type":"number"},"OFFSET_Y":{"!type":"number"},"constructor":{"!type":"fn()"},"overSource":{"!type":"fn(source: +Object)","!doc":"called when a source detected a mouse-over conditiion"},"outSource":{"!type":"fn(source: +Object)","!doc":"called when a source detected a mouse-out conditiion"},"startDrag":{"!type":"fn(source: +Object, nodes: [], copy: bool)","!doc":"called to initiate the DnD operation"},"canDrop":{"!type":"fn(flag: ?)","!doc":"called to notify if the current target can accept items"},"stopDrag":{"!type":"fn()","!doc":"stop the DnD in progress"},"makeAvatar":{"!type":"fn()","!doc":"Makes the avatar, it is separate to be overwritten dynamically, if needed."},"updateAvatar":{"!type":"fn()","!doc":"updates the avatar, it is separate to be overwritten dynamically, if needed"},"onMouseMove":{"!type":"fn(e: +Event)","!doc":"event processor for onmousemove"},"onMouseUp":{"!type":"fn(e: +Event)","!doc":"event processor for onmouseup"},"onKeyDown":{"!type":"fn(e: +Event)","!doc":"event processor for onkeydown:\nwatching for CTRL for copy/move status, watching for ESCAPE to cancel the drag"},"onKeyUp":{"!type":"fn(e: +Event)","!doc":"event processor for onkeyup, watching for CTRL for copy/move status"},"_setCopyStatus":{"!type":"fn(copy: bool)","!doc":"changes the copy status"}}},"Moveable":{"!type":"fn()","prototype":{"!doc":"an object, which makes a node moveable\nnode: Node: a node (or node's id) to be moved\nparams: Object: an optional object with additional parameters;\nfollowing parameters are recognized:","handle":{"!doc":"a node (or node's id), which is used as a mouse handle\nif omitted, the node itself is used as a handle","!type":"+Node"},"delay":{"!doc":"delay move by this number of pixels","!type":"number"},"skip":{"!doc":"skip move of form elements\nmover: Object: a constructor of custom Mover","!type":"bool"},"constructor":{"!type":"fn(node: +Node, params: +Object)","!doc":"an object, which makes a node moveable"},"markupFactory":{"!type":"fn(params: ?, node: ?)"},"destroy":{"!type":"fn()","!doc":"stops watching for possible move, deletes all references, so the object can be garbage-collected"},"onMouseDown":{"!type":"fn(e: +Event)","!doc":"event processor for onmousedown, creates a Mover for the node"},"onMouseMove":{"!type":"fn(e: +Event)","!doc":"event processor for onmousemove, used only for delayed drags"},"onMouseUp":{"!type":"fn(e: +Event)","!doc":"event processor for onmouseup, used only for delayed drags"},"onSelectStart":{"!type":"fn(e: +Event)","!doc":"event processor for onselectevent and ondragevent"},"onDragDetected":{"!type":"fn(e: +Event)","!doc":"called when the drag is detected,\nresponsible for creation of the mover"},"onMoveStart":{"!type":"fn(mover: +dojo.dnd.Mover)","!doc":"called before every move operation"},"onMoveStop":{"!type":"fn(mover: +dojo.dnd.Mover)","!doc":"called after every move operation"},"onFirstMove":{"!type":"fn(mover: +dojo.dnd.Mover)","!doc":"called during the very first move notification,\ncan be used to initialize coordinates, can be overwritten."},"onMove":{"!type":"fn(mover: +dojo.dnd.Mover, leftTop: ?)","!doc":"called during every move notification,\nshould actually move the node, can be overwritten."},"onMoving":{"!type":"fn(mover: +dojo.dnd.Mover, leftTop: ?)","!doc":"called before every incremental move,\ncan be overwritten."},"onMoved":{"!type":"fn(mover: +dojo.dnd.Mover, leftTop: ?)","!doc":"called after every incremental move,\ncan be overwritten."}}},"Mover":{"!type":"fn()","prototype":{"!doc":"an object, which makes a node follow the mouse,\nused as a default mover, and as a base class for custom movers\nnode: Node: a node (or node's id) to be moved\ne: Event: a mouse event, which started the move;\nonly pageX and pageY properties are used\nhost: Object?: object which implements the functionality of the move,\nand defines proper events (onMoveStart and onMoveStop)","constructor":{"!type":"fn(node: +Node, e: +Event, host?: +Object)","!doc":"an object, which makes a node follow the mouse,\nused as a default mover, and as a base class for custom movers"},"onMouseMove":{"!type":"fn(e: +Event)","!doc":"event processor for onmousemove"},"onMouseUp":{"!type":"fn(e: ?)"},"onFirstMove":{"!type":"fn()","!doc":"makes the node absolute; it is meant to be called only once.\nrelative and absolutely positioned nodes are assumed to use pixel units"},"destroy":{"!type":"fn()","!doc":"stops the move, deletes all references, so the object can be garbage-collected"}}},"Selector":{"!type":"fn()","prototype":{"!proto":"dojo.dnd.Container.prototype","!doc":"a Selector object, which knows how to select its children","singular":{"!doc":"allows selection of only one element, if true\nthe rest of parameters are passed to the container\nautoSync: Boolean\nautosynchronizes the source with its list of DnD nodes,\nfalse by default","!type":"bool"},"constructor":{"!type":"fn(node: +Node, params: +Object)","!doc":"a constructor of the Selector"},"getSelectedNodes":{"!type":"fn() -> []","!doc":"returns a list (an array) of selected nodes"},"selectNone":{"!type":"fn() -> +self","!doc":"unselects all items"},"selectAll":{"!type":"fn() -> +self","!doc":"selects all items"},"deleteSelectedNodes":{"!type":"fn() -> +self","!doc":"deletes all selected items"},"forInSelectedItems":{"!type":"fn(f: fn(), o?: ?)","!doc":"iterates over selected items,\nsee dojo.dnd.Container.forInItems() for details"},"sync":{"!type":"fn() -> +self","!doc":"synch up the node list with the data map"},"insertNodes":{"!type":"fn(addSelected: bool, data: [], before: bool, anchor: +Node) -> +self","!doc":"inserts new data items (see Container's insertNodes method for details)"},"destroy":{"!type":"fn()","!doc":"prepares the object to be garbage-collected"},"markupFactory":{"!type":"fn(params: ?, node: ?)"},"onMouseDown":{"!type":"fn(e: +Event)","!doc":"event processor for onmousedown"},"onMouseUp":{"!type":"fn(e: +Event)","!doc":"event processor for onmouseup"},"onMouseMove":{"!type":"fn(e: +Event)","!doc":"event processor for onmousemove"},"onOverEvent":{"!type":"fn()","!doc":"this function is called once, when mouse is over our container"},"onOutEvent":{"!type":"fn()","!doc":"this function is called once, when mouse is out of our container"},"_removeSelection":{"!type":"fn() -> +self","!doc":"unselects all items"},"_removeAnchor":{"!type":"fn() -> +self"}}},"Source":{"!type":"fn()","prototype":{"!proto":"dojo.dnd.Selector.prototype","!doc":"a Source object, which can be used as a DnD source, or a DnD target","isSource":{"!type":"bool"},"horizontal":{"!type":"bool"},"copyOnly":{"!type":"bool"},"selfCopy":{"!type":"bool"},"selfAccept":{"!type":"bool"},"skipForm":{"!type":"bool"},"withHandles":{"!type":"bool"},"autoSync":{"!type":"bool"},"delay":{"!type":"number"},"accept":{"!type":"[]"},"generateText":{"!type":"bool"},"constructor":{"!type":"fn(node: +DOMNode, params?: +dojo.dnd.__SourceArgs)","!doc":"a constructor of the Source"},"checkAcceptance":{"!type":"fn(source: +Object, nodes: []) -> bool","!doc":"checks, if the target can accept nodes from this source"},"copyState":{"!type":"fn(keyPressed: bool, self?: bool) -> bool","!doc":"Returns true, if we need to copy items, false to move.\nIt is separated to be overwritten dynamically, if needed."},"destroy":{"!type":"fn()","!doc":"prepares the object to be garbage-collected"},"markupFactory":{"!type":"fn(params: ?, node: ?)"},"onMouseMove":{"!type":"fn(e: +Event)","!doc":"event processor for onmousemove"},"onMouseDown":{"!type":"fn(e: +Event)","!doc":"event processor for onmousedown"},"onMouseUp":{"!type":"fn(e: +Event)","!doc":"event processor for onmouseup"},"onDndSourceOver":{"!type":"fn(source: +Object)","!doc":"topic event processor for /dnd/source/over, called when detected a current source"},"onDndStart":{"!type":"fn(source: +Object, nodes: [], copy: bool)","!doc":"topic event processor for /dnd/start, called to initiate the DnD operation"},"onDndDrop":{"!type":"fn(source: +Object, nodes: [], copy: bool, target: +Object)","!doc":"topic event processor for /dnd/drop, called to finish the DnD operation"},"onDndCancel":{"!type":"fn()","!doc":"topic event processor for /dnd/cancel, called to cancel the DnD operation"},"onDrop":{"!type":"fn(source: +Object, nodes: [], copy: bool)","!doc":"called only on the current target, when drop is performed"},"onDropExternal":{"!type":"fn(source: +Object, nodes: [], copy: bool)","!doc":"called only on the current target, when drop is performed\nfrom an external source"},"onDropInternal":{"!type":"fn(nodes: [], copy: bool)","!doc":"called only on the current target, when drop is performed\nfrom the same target/source"},"onDraggingOver":{"!type":"fn()","!doc":"called during the active DnD operation, when items\nare dragged over this target, and it is not disabled"},"onDraggingOut":{"!type":"fn()","!doc":"called during the active DnD operation, when items\nare dragged away from this target, and it is not disabled"},"onOverEvent":{"!type":"fn()","!doc":"this function is called once, when mouse is over our container"},"onOutEvent":{"!type":"fn()","!doc":"this function is called once, when mouse is out of our container"},"_markTargetAnchor":{"!type":"fn(before: bool)","!doc":"assigns a class to the current target anchor based on &quot;before&quot; status"},"_unmarkTargetAnchor":{"!type":"fn()","!doc":"removes a class of the current target anchor based on &quot;before&quot; status"},"_markDndStatus":{"!type":"fn(copy: ?)","!doc":"changes source's state based on &quot;copy&quot; status"},"_legalMouseDown":{"!type":"fn(e: +Event) -> bool","!doc":"checks if user clicked on &quot;approved&quot; items"}}},"Target":{"!type":"fn()","prototype":{"!proto":"dojo.dnd.Source.prototype","!doc":"a Target object, which can be used as a DnD target","constructor":{"!type":"fn(node: ?, params: ?)","!doc":"a constructor of the Target --- see the Source constructor for details"},"markupFactory":{"!type":"fn(params: ?, node: ?)"}}},"AutoSource":{"!type":"fn()","prototype":{"!proto":"dojo.dnd.Source.prototype","!doc":"a source, which syncs its DnD nodes by default","constructor":{"!type":"fn(node: ?, params: ?)","!doc":"a constructor of the AutoSource --- see the Source constructor for details"},"markupFactory":{"!type":"fn(params: ?, node: ?)"}}},"TimedMoveable":{"!type":"fn()","prototype":{"!proto":"dojo.dnd.Moveable.prototype","!doc":"A specialized version of Moveable to support an FPS throttling.\nThis class puts an upper restriction on FPS, which may reduce\nthe CPU load. The additional parameter \"timeout\" regulates\nthe delay before actually moving the moveable object.","timeout":{"!doc":"delay move by this number of ms\naccumulating position changes during the timeout","!type":"number"},"constructor":{"!type":"fn(node: +Node, params: +Object)","!doc":"an object, which makes a node moveable with a timer"},"markupFactory":{"!type":"fn(params: ?, node: ?)"},"onMoveStop":{"!type":"fn(mover: +dojo.dnd.Mover)"},"onMove":{"!type":"fn(mover: +dojo.dnd.Mover, leftTop: ?)"}}},"_validNodes":{"div":{"!type":"number"},"p":{"!type":"number"},"td":{"!type":"number"}},"_validOverflow":{"auto":{"!type":"number"},"scroll":{"!type":"number"}},"move":{"constrainedMover":{"!type":"fn(fun: fn(), within: bool) -> ?","!doc":"returns a constrained version of dojo.dnd.Mover"},"boxConstrainedMover":{"!type":"fn(box: +Object, within: bool) -> ?","!doc":"a specialization of dojo.dnd.constrainedMover, which constrains to the specified box"},"parentConstrainedMover":{"!type":"fn(area: string, within: bool) -> ?","!doc":"a specialization of dojo.dnd.constrainedMover, which constrains to the parent node"},"constrainedMoveable":{"!type":"fn()","!doc":"an object, which makes a node moveable\nnode: Node: a node (or node's id) to be moved\nparams: Object: an optional object with additional parameters;\nfollowing parameters are recognized:","prototype":{"constraints":{"!doc":"a function, which calculates a constraint box,\nit is called in a context of the moveable object.","!type":"fn()"},"within":{"!doc":"restrict move within boundaries.\nthe rest is passed to the base class","!type":"bool"},"markupFactory":{"!type":"fn(params: ?, node: ?)"},"constructor":{"!type":"fn(node: +Node, params: +Object)","!doc":"an object, which makes a node moveable"},"onFirstMove":{"!type":"fn(mover: +dojo.dnd.Mover)","!doc":"called during the very first move notification,\ncan be used to initialize coordinates, can be overwritten."},"onMove":{"!type":"fn(mover: +dojo.dnd.Mover, leftTop: ?)","!doc":"called during every move notification,\nshould actually move the node, can be overwritten."}}},"boxConstrainedMoveable":{"!type":"fn()","!doc":"an object, which makes a node moveable\nnode: Node: a node (or node's id) to be moved\nparams: Object: an optional object with additional parameters;\nfollowing parameters are recognized:","prototype":{"box":{"!doc":"a constraint box\nthe rest is passed to the base class","!type":"+Object"},"markupFactory":{"!type":"fn(params: ?, node: ?)"},"constructor":{"!type":"fn(node: +Node, params: +Object)","!doc":"an object, which makes a node moveable"}}},"parentConstrainedMoveable":{"!type":"fn()","!doc":"an object, which makes a node moveable\nnode: Node: a node (or node's id) to be moved\nparams: Object: an optional object with additional parameters;\nfollowing parameters are recognized:","prototype":{"area":{"!doc":"a parent's area to restrict the move,\ncan be &quot;margin&quot;, &quot;border&quot;, &quot;padding&quot;, or &quot;content&quot;.\nthe rest is passed to the base class","!type":"string"},"markupFactory":{"!type":"fn(params: ?, node: ?)"},"constructor":{"!type":"fn(node: +Node, params: +Object) -> ?","!doc":"an object, which makes a node moveable"}}}}},"AdapterRegistry":{"!type":"fn(returnWrappers?: bool)","!doc":"A registry to make contextual calling/searching easier.","prototype":{"register":{"!type":"fn(name: string, check: fn(), wrap: fn(), directReturn?: bool, override?: bool)","!doc":"register a check function to determine if the wrap function or\nobject gets selected"},"match":{"!type":"fn()","!doc":"Find an adapter for the given arguments. If no suitable adapter\nis found, throws an exception. match() accepts any number of\narguments, all of which are passed to all matching functions\nfrom the registered pairs."},"unregister":{"!type":"fn(name: ?)","!doc":"Remove a named adapter from the registry"}}},"DeferredList":{"!type":"fn()","prototype":{"!proto":"dojo.Deferred.prototype","!doc":"Provides event handling for a group of Deferred objects.","constructor":{"!type":"fn(list: [], fireOnOneCallback?: bool, fireOnOneErrback?: bool, consumeErrors?: bool, canceller?: fn())","!doc":"Provides event handling for a group of Deferred objects."},"_cbDeferred":{"!type":"fn(index: ?, succeeded: ?, result: ?)","!doc":"The DeferredLists' callback handler"},"gatherResults":{"!type":"fn(deferredList: ?)","!doc":"Gathers the results of the deferreds for packaging\nas the parameters to the Deferred Lists' callback"}}},"NodeList":{"!type":"fn()","!doc":"dojo.NodeList is an of Array subclass which adds syntactic\nsugar for chaining, common iteration operations, animation, and\nnode manipulation. NodeLists are most often returned as the\nresult of dojo.query() calls.","_wrap":{},"_adaptAsMap":{},"_adaptAsForEach":{},"_adaptAsFilter":{},"_adaptWithCondition":{},"prototype":{"_anim":{"!type":"fn(obj: ?, method: ?, args: ?)"},"wipeIn":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"wipe in all elements of this NodeList. Returns an instance of dojo.Animation"},"wipeOut":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"wipe out all elements of this NodeList. Returns an instance of dojo.Animation"},"slideTo":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"slide all elements of the node list to the specified place.\nReturns an instance of dojo.Animation"},"fadeIn":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"fade in all elements of this NodeList. Returns an instance of dojo.Animation"},"fadeOut":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"fade out all elements of this NodeList. Returns an instance of dojo.Animation"},"animateProperty":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"see dojo.animateProperty(). Animate all elements of this\nNodeList across the properties specified."},"anim":{"!type":"fn(properties: ?, duration?: +Integer, easing?: fn(), onEnd?: fn(), delay?: +Integer) -> +dojo.Animation","!doc":"Animate one or more CSS properties for all nodes in this list.\nThe returned animation object will already be playing when it\nis returned. See the docs for <code>dojo.anim</code> for full details."},"html":{"!type":"fn(content: ?, params?: ?) -> +dojo.NodeList","!doc":"see <code>dojo.html.set()</code>. Set the content of all elements of this NodeList"},"slice":{"!type":"fn(begin: +Integer, end?: +Integer)","!doc":"Returns a new NodeList, maintaining this one in place"},"splice":{"!type":"fn(index: +Integer, howmany?: +Integer, item?: ?)","!doc":"Returns a new NodeList, manipulating this NodeList based on\nthe arguments passed, potentially splicing in new elements\nat an offset, optionally deleting elements"},"indexOf":{"!type":"fn(value: +Object, fromIndex?: +Integer) -> +Integer","!doc":"see dojo.indexOf(). The primary difference is that the acted-on\narray is implicitly this NodeList"},"lastIndexOf":{"!type":"fn(value: ?, fromIndex?: +Integer) -> +Integer","!doc":"see dojo.lastIndexOf(). The primary difference is that the\nacted-on array is implicitly this NodeList"},"every":{"!type":"fn(callback: fn(), thisObject?: +Object) -> bool","!doc":"see <code>dojo.every()</code> and the (Array.every\ndocs)[http://developer.mozilla.org/en/docs/Core_JavaScript_1.5_Reference:Global_Objects:Array:every].\nTakes the same structure of arguments and returns as\ndojo.every() with the caveat that the passed array is\nimplicitly this NodeList"},"some":{"!type":"fn(callback: fn(), thisObject?: +Object) -> bool","!doc":"Takes the same structure of arguments and returns as\n<code>dojo.some()</code> with the caveat that the passed array is\nimplicitly this NodeList.  See <code>dojo.some()</code> and Mozilla's\n(Array.some\ndocumentation)[http://developer.mozilla.org/en/docs/Core_JavaScript_1.5_Reference:Global_Objects:Array:some]."},"concat":{"!type":"fn(item?: ?) -> +dojo.NodeList","!doc":"Returns a new NodeList comprised of items in this NodeList\nas well as items passed in as parameters"},"map":{"!type":"fn(func: fn(), obj?: fn()) -> +dojo.NodeList","!doc":"see dojo.map(). The primary difference is that the acted-on\narray is implicitly this NodeList and the return is a\ndojo.NodeList (a subclass of Array)\n/return d.map(this, func, obj, d.NodeList); // dojo.NodeList"},"forEach":{"!type":"fn(callback: ?, thisObj: ?) -> +dojo.NodeList","!doc":"see <code>dojo.forEach()</code>. The primary difference is that the acted-on\narray is implicitly this NodeList"},"coords":{"!type":"fn() -> []","!doc":"Returns the box objects all elements in a node list as\nan Array (*not* a NodeList)"},"addClass":{"!type":"fn(className: string) -> +dojo.NodeList","!doc":"adds the specified class to every node in the list"},"removeClass":{"!type":"fn(className: string) -> +dojo.NodeList","!doc":"removes the specified class from every node in the list"},"toggleClass":{"!type":"fn(className: string, condition?: bool) -> +dojo.NodeList","!doc":"Adds a class to node if not present, or removes if present.\nPass a boolean condition if you want to explicitly add or remove."},"connect":{"!type":"fn(methodName: string, objOrFunc: +Object, funcName?: string)","!doc":"attach event handlers to every item of the NodeList. Uses dojo.connect()\nso event properties are normalized"},"empty":{"!type":"fn() -> +dojo.NodeList","!doc":"clears all content from each node in the list. Effectively\nequivalent to removing all child nodes from every item in\nthe list."},"place":{"!type":"fn(queryOrNode: string, position: string) -> +dojo.NodeList","!doc":"places elements of this node list relative to the first element matched\nby queryOrNode. Returns the original NodeList. See: <code>dojo.place</code>"},"orphan":{"!type":"fn(simpleFilter?: string) -> +dojo.NodeList","!doc":"removes elements in this list that match the simple filter\nfrom their parents and returns them as a new NodeList."},"adopt":{"!type":"fn(queryOrListOrNode: string, position?: string) -> +dojo.NodeList","!doc":"places any/all elements in queryOrListOrNode at a\nposition relative to the first element in this list.\nReturns a dojo.NodeList of the adopted elements."},"query":{"!type":"fn(queryStr: string) -> +dojo.NodeList","!doc":"Returns a new list whose memebers match the passed query,\nassuming elements of the current NodeList as the root for\neach search."},"filter":{"!type":"fn(simpleFilter: string) -> +dojo.NodeList","!doc":"&quot;masks&quot; the built-in javascript filter() method (supported\nin Dojo via <code>dojo.filter</code>) to support passing a simple\nstring filter in addition to supporting filtering function\nobjects."},"instantiate":{"!type":"fn(declaredClass: string, properties?: ?) -> +dojo.NodeList","!doc":"Create a new instance of a specified class, using the\nspecified properties and each node in the nodeList as a\nsrcNodeRef"},"at":{"!type":"fn(index: +Integer) -> +dojo.NodeList","!doc":"Returns a new NodeList comprised of items in this NodeList\nat the given index or indices."},"dtl":{"!type":"fn(template: +dojox.dtl.__StringArgs, context: +dojox.dtl.__ObjectArgs)"},"addClassFx":{"!type":"fn(cssClass: ?, args: ?) -> +dojo.Animation","!doc":"Animate the effects of adding a class to all nodes in this list.\nsee <code>dojox.fx.addClass</code>"},"removeClassFx":{"!type":"fn(cssClass: ?, args: ?) -> +dojo.Animation","!doc":"Animate the effect of removing a class to all nodes in this list.\nsee <code>dojox.fx.removeClass</code>"},"toggleClassFx":{"!type":"fn(cssClass: ?, force: ?, args: ?) -> +dojo.Animation","!doc":"Animate the effect of adding or removing a class to all nodes in this list.\nsee <code>dojox.fx.toggleClass</code>"},"sizeTo":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"size all elements of this NodeList. Returns an instance of dojo.Animation"},"slideBy":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"slide all elements of this NodeList. Returns an instance of dojo.Animation"},"highlight":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"highlight all elements of the node list.\nReturns an instance of dojo.Animation"},"fadeTo":{"!type":"fn(args: ?)","!doc":"fade all elements of the node list to a specified opacity"},"wipeTo":{"!type":"fn(args: ?)","!doc":"Wipe all elements of the NodeList to a specified width: or height:"}},"attr":{"!type":"fn(property: string, value?: string) -> +dojo.NodeList","!doc":"gets or sets the DOM attribute for every element in the\nNodeList","safetyCheck":{"!type":"fn(name: ?, value: ?)"}},"style":{"!type":"fn(property: string, value?: string) -> +dojo.NodeList","!doc":"gets or sets the CSS property for every element in the NodeList","safetyCheck":{"!type":"fn(name: ?, value: ?)"}},"addContent":{"!type":"fn(content: string, position?: string) -> +dojo.NodeList","!doc":"add a node or some HTML as a string to every item in the\nlist.  Returns the original list.","safetyCheck":{"!type":"fn(content: ?)"}}},"Color":{"!type":"fn(color: [])","!doc":"Takes a named string, hex string, array of rgb or rgba values,\nan object with r, g, b, and a properties, or another <code>dojo.Color</code> object\nand creates a new Color instance to work from.","prototype":{"r":{"!type":"number"},"g":{"!type":"number"},"b":{"!type":"number"},"a":{"!type":"number"},"_set":{"!type":"fn(r: ?, g: ?, b: ?, a: ?)"},"setColor":{"!type":"fn(color: []) -> +dojo.Color","!doc":"Takes a named string, hex string, array of rgb or rgba values,\nan object with r, g, b, and a properties, or another <code>dojo.Color</code> object\nand sets this color instance to that value."},"sanitize":{"!type":"fn() -> +dojo.Color","!doc":"makes sure that the object has correct attributes"},"toRgb":{"!type":"fn() -> []","!doc":"Returns 3 component array of rgb values"},"toRgba":{"!type":"fn() -> []","!doc":"Returns a 4 component array of rgba values"},"toHex":{"!type":"fn() -> string","!doc":"Returns a css color string in hexadecimal representation"},"toCss":{"!type":"fn(includeAlpha?: bool) -> string","!doc":"Returns a css color string in rgb(a) representation"},"toString":{"!type":"fn() -> string","!doc":"Returns a visual representation of the color"}},"named":{"black":{"!type":"[]"},"silver":{"!type":"[]"},"gray":{"!type":"[]"},"white":{"!type":"[]"},"maroon":{"!type":"[]"},"red":{"!type":"[]"},"purple":{"!type":"[]"},"fuchsia":{"!type":"[]"},"green":{"!type":"[]"},"lime":{"!type":"[]"},"olive":{"!type":"[]"},"yellow":{"!type":"[]"},"navy":{"!type":"[]"},"blue":{"!type":"[]"},"teal":{"!type":"[]"},"aqua":{"!type":"[]"},"aliceblue":{"!type":"[]"},"antiquewhite":{"!type":"[]"},"aquamarine":{"!type":"[]"},"azure":{"!type":"[]"},"beige":{"!type":"[]"},"bisque":{"!type":"[]"},"blanchedalmond":{"!type":"[]"},"blueviolet":{"!type":"[]"},"brown":{"!type":"[]"},"burlywood":{"!type":"[]"},"cadetblue":{"!type":"[]"},"chartreuse":{"!type":"[]"},"chocolate":{"!type":"[]"},"coral":{"!type":"[]"},"cornflowerblue":{"!type":"[]"},"cornsilk":{"!type":"[]"},"crimson":{"!type":"[]"},"cyan":{"!type":"[]"},"darkblue":{"!type":"[]"},"darkcyan":{"!type":"[]"},"darkgoldenrod":{"!type":"[]"},"darkgray":{"!type":"[]"},"darkgreen":{"!type":"[]"},"darkgrey":{"!type":"[]"},"darkkhaki":{"!type":"[]"},"darkmagenta":{"!type":"[]"},"darkolivegreen":{"!type":"[]"},"darkorange":{"!type":"[]"},"darkorchid":{"!type":"[]"},"darkred":{"!type":"[]"},"darksalmon":{"!type":"[]"},"darkseagreen":{"!type":"[]"},"darkslateblue":{"!type":"[]"},"darkslategray":{"!type":"[]"},"darkslategrey":{"!type":"[]"},"darkturquoise":{"!type":"[]"},"darkviolet":{"!type":"[]"},"deeppink":{"!type":"[]"},"deepskyblue":{"!type":"[]"},"dimgray":{"!type":"[]"},"dimgrey":{"!type":"[]"},"dodgerblue":{"!type":"[]"},"firebrick":{"!type":"[]"},"floralwhite":{"!type":"[]"},"forestgreen":{"!type":"[]"},"gainsboro":{"!type":"[]"},"ghostwhite":{"!type":"[]"},"gold":{"!type":"[]"},"goldenrod":{"!type":"[]"},"greenyellow":{"!type":"[]"},"grey":{"!type":"[]"},"honeydew":{"!type":"[]"},"hotpink":{"!type":"[]"},"indianred":{"!type":"[]"},"indigo":{"!type":"[]"},"ivory":{"!type":"[]"},"khaki":{"!type":"[]"},"lavender":{"!type":"[]"},"lavenderblush":{"!type":"[]"},"lawngreen":{"!type":"[]"},"lemonchiffon":{"!type":"[]"},"lightblue":{"!type":"[]"},"lightcoral":{"!type":"[]"},"lightcyan":{"!type":"[]"},"lightgoldenrodyellow":{"!type":"[]"},"lightgray":{"!type":"[]"},"lightgreen":{"!type":"[]"},"lightgrey":{"!type":"[]"},"lightpink":{"!type":"[]"},"lightsalmon":{"!type":"[]"},"lightseagreen":{"!type":"[]"},"lightskyblue":{"!type":"[]"},"lightslategray":{"!type":"[]"},"lightslategrey":{"!type":"[]"},"lightsteelblue":{"!type":"[]"},"lightyellow":{"!type":"[]"},"limegreen":{"!type":"[]"},"linen":{"!type":"[]"},"magenta":{"!type":"[]"},"mediumaquamarine":{"!type":"[]"},"mediumblue":{"!type":"[]"},"mediumorchid":{"!type":"[]"},"mediumpurple":{"!type":"[]"},"mediumseagreen":{"!type":"[]"},"mediumslateblue":{"!type":"[]"},"mediumspringgreen":{"!type":"[]"},"mediumturquoise":{"!type":"[]"},"mediumvioletred":{"!type":"[]"},"midnightblue":{"!type":"[]"},"mintcream":{"!type":"[]"},"mistyrose":{"!type":"[]"},"moccasin":{"!type":"[]"},"navajowhite":{"!type":"[]"},"oldlace":{"!type":"[]"},"olivedrab":{"!type":"[]"},"orange":{"!type":"[]"},"orangered":{"!type":"[]"},"orchid":{"!type":"[]"},"palegoldenrod":{"!type":"[]"},"palegreen":{"!type":"[]"},"paleturquoise":{"!type":"[]"},"palevioletred":{"!type":"[]"},"papayawhip":{"!type":"[]"},"peachpuff":{"!type":"[]"},"peru":{"!type":"[]"},"pink":{"!type":"[]"},"plum":{"!type":"[]"},"powderblue":{"!type":"[]"},"rosybrown":{"!type":"[]"},"royalblue":{"!type":"[]"},"saddlebrown":{"!type":"[]"},"salmon":{"!type":"[]"},"sandybrown":{"!type":"[]"},"seagreen":{"!type":"[]"},"seashell":{"!type":"[]"},"sienna":{"!type":"[]"},"skyblue":{"!type":"[]"},"slateblue":{"!type":"[]"},"slategray":{"!type":"[]"},"slategrey":{"!type":"[]"},"snow":{"!type":"[]"},"springgreen":{"!type":"[]"},"steelblue":{"!type":"[]"},"tan":{"!type":"[]"},"thistle":{"!type":"[]"},"tomato":{"!type":"[]"},"transparent":{"!type":"[]"},"turquoise":{"!type":"[]"},"violet":{"!type":"[]"},"wheat":{"!type":"[]"},"whitesmoke":{"!type":"[]"},"yellowgreen":{"!type":"[]"}}},"_base":{"Color":{},"Deferred":{},"NodeList":{},"array":{},"browser":{},"connect":{},"declare":{},"event":{},"fx":{},"html":{},"json":{},"lang":{},"query":{},"window":{},"xhr":{},"_loader":{"loader_debug":{},"loader_xd":{}}},"Deferred":{"!type":"fn(canceller?: fn())","!doc":"Encapsulates a sequence of callbacks in response to a value that\nmay not yet be available.  This is modeled after the Deferred class\nfrom Twisted &lt;http://twistedmatrix.com&gt;.","prototype":{"_nextId":{},"cancel":{"!type":"fn()","!doc":"Cancels a Deferred that has not yet received a value, or is\nwaiting on another Deferred as its value."},"_resback":{"!type":"fn(res: ?)","!doc":"The private primitive that means either callback or errback"},"_check":{"!type":"fn()"},"callback":{"!type":"fn(res: ?)","!doc":"Begin the callback sequence with a non-error value."},"errback":{"!type":"fn(res: +Error)","!doc":"Begin the callback sequence with an error result."},"addBoth":{"!type":"fn(cb: fn(), cbfn?: string) -> +dojo.Deferred","!doc":"Add the same function as both a callback and an errback as the\nnext element on the callback sequence.This is useful for code\nthat you want to guarantee to run, e.g. a finalizer."},"addCallback":{"!type":"fn(cb: fn(), cbfn?: string) -> +dojo.Deferred","!doc":"Add a single callback to the end of the callback sequence."},"addErrback":{"!type":"fn(cb: ?, cbfn: ?) -> +dojo.Deferred","!doc":"Add a single callback to the end of the callback sequence."},"addCallbacks":{"!type":"fn(cb: ?, eb: ?) -> +dojo.Deferred","!doc":"Add separate callback and errback to the end of the callback\nsequence."},"_fire":{"!type":"fn()","!doc":"Used internally to exhaust the callback sequence when a result\nis available."}}},"version":{"!doc":"version number of dojo\nmajor: Integer\nMajor version. If total version is &quot;1.2.0beta1&quot;, will be 1\nminor: Integer\nMinor version. If total version is &quot;1.2.0beta1&quot;, will be 2\npatch: Integer\nPatch version. If total version is &quot;1.2.0beta1&quot;, will be 0\nflag: String\nDescriptor flag. If total version is &quot;1.2.0beta1&quot;, will be &quot;beta1&quot;\nrevision: Number\nThe SVN rev from which dojo was pulled","major":{"!type":"number"},"minor":{"!type":"number"},"patch":{"!type":"number"},"flag":{"!type":"string"},"revision":{},"toString":{"!type":"fn() -> string"}},"config":{"baseUrl":{},"modulePaths":{},"libraryScriptUri":{"!type":"string"},"addOnLoad":{},"extraLocale":{"!type":"[]"},"debugContainerId":{"!type":"string"},"debugHeight":{"!type":"number"},"baseRelativePath":{}},"_modulePrefixes":{"dojo":{"name":{"!type":"string"},"value":{"!type":"string"}},"doh":{"name":{"!type":"string"},"value":{"!type":"string"}},"tests":{"name":{"!type":"string"},"value":{"!type":"string"}}},"_Url":{"!type":"fn()","!doc":"Constructor to create an object representing a URL.\nIt is marked as private, since we might consider removing\nor simplifying it.","toString":{"!type":"fn()"}},"_listener":{"handlers":{},"getDispatcher":{"!type":"fn()"},"add":{"!type":"fn(source: ?, method: string, listener: fn())"},"remove":{"!type":"fn(source: ?, method: string, handle: +Handle)"}},"declare":{"!type":"fn(className: string, superclass: fn(), props: ?) -> fn()","!doc":"Create a feature-rich constructor from compact notation","_delegate":{"!type":"fn(base: ?, mixin: ?)"},"_extend":{"!type":"fn(props: ?)"},"_makeCtor":{"!type":"fn()"},"_core":{"_construct":{"!type":"fn(args: ?)"},"_findMixin":{"!type":"fn(mixin: ?)"},"_findMethod":{"!type":"fn(name: ?, method: ?, ptype: ?, has: ?)"},"inherited":{"!type":"fn(name?: string, args: ?, newArgs?: [])","!doc":"Call an inherited member function of this declared class."}}},"_event_listener":{"add":{"!type":"fn(node: +Node, name: string, fp: fn())"},"remove":{"!type":"fn(node: +Node, event: string, handle: +Handle)","!doc":"clobbers the listener from the node"},"_normalizeEventName":{"!type":"fn(name: string)"},"_fixCallback":{"!type":"fn(name: string, fp: ?)"},"_fixEvent":{"!type":"fn(evt: ?, sender: ?)"},"_setKeyChar":{"!type":"fn(evt: ?)"},"_punctMap":{"106":{"!type":"number"},"111":{"!type":"number"},"186":{"!type":"number"},"187":{"!type":"number"},"188":{"!type":"number"},"189":{"!type":"number"},"190":{"!type":"number"},"191":{"!type":"number"},"192":{"!type":"number"},"219":{"!type":"number"},"220":{"!type":"number"},"221":{"!type":"number"},"222":{"!type":"number"}}},"keys":{"!doc":"definitions for common key values","BACKSPACE":{"!type":"number"},"TAB":{"!type":"number"},"CLEAR":{"!type":"number"},"ENTER":{"!type":"number"},"SHIFT":{"!type":"number"},"CTRL":{"!type":"number"},"ALT":{"!type":"number"},"PAUSE":{"!type":"number"},"CAPS_LOCK":{"!type":"number"},"ESCAPE":{"!type":"number"},"SPACE":{"!type":"number"},"PAGE_UP":{"!type":"number"},"PAGE_DOWN":{"!type":"number"},"END":{"!type":"number"},"HOME":{"!type":"number"},"LEFT_ARROW":{"!type":"number"},"UP_ARROW":{"!type":"number"},"RIGHT_ARROW":{"!type":"number"},"DOWN_ARROW":{"!type":"number"},"INSERT":{"!type":"number"},"DELETE":{"!type":"number"},"HELP":{"!type":"number"},"LEFT_WINDOW":{"!type":"number"},"RIGHT_WINDOW":{"!type":"number"},"SELECT":{"!type":"number"},"NUMPAD_0":{"!type":"number"},"NUMPAD_1":{"!type":"number"},"NUMPAD_2":{"!type":"number"},"NUMPAD_3":{"!type":"number"},"NUMPAD_4":{"!type":"number"},"NUMPAD_5":{"!type":"number"},"NUMPAD_6":{"!type":"number"},"NUMPAD_7":{"!type":"number"},"NUMPAD_8":{"!type":"number"},"NUMPAD_9":{"!type":"number"},"NUMPAD_MULTIPLY":{"!type":"number"},"NUMPAD_PLUS":{"!type":"number"},"NUMPAD_ENTER":{"!type":"number"},"NUMPAD_MINUS":{"!type":"number"},"NUMPAD_PERIOD":{"!type":"number"},"NUMPAD_DIVIDE":{"!type":"number"},"F1":{"!type":"number"},"F2":{"!type":"number"},"F3":{"!type":"number"},"F4":{"!type":"number"},"F5":{"!type":"number"},"F6":{"!type":"number"},"F7":{"!type":"number"},"F8":{"!type":"number"},"F9":{"!type":"number"},"F10":{"!type":"number"},"F11":{"!type":"number"},"F12":{"!type":"number"},"F13":{"!type":"number"},"F14":{"!type":"number"},"F15":{"!type":"number"},"NUM_LOCK":{"!type":"number"},"SCROLL_LOCK":{"!type":"number"}},"_ie_listener":{"handlers":{"!type":"[]"},"add":{"!type":"fn(source: ?, method: string, listener: fn())"},"remove":{"!type":"fn(source: ?, method: string, handle: +Handle)"}},"Animation":{"!type":"fn(args: ?)","!doc":"A generic animation class that fires callbacks into its handlers\nobject at various states.","prototype":{"duration":{"!type":"number"},"curve":{},"easing":{},"repeat":{"!type":"number"},"rate":{"!type":"number"},"delay":{},"beforeBegin":{},"onBegin":{},"onAnimate":{},"onEnd":{},"onPlay":{},"onPause":{},"onStop":{},"_percent":{"!type":"number"},"_startRepeatCount":{"!type":"number"},"_fire":{"!type":"fn(evt: +Event, args?: []) -> +dojo.Animation","!doc":"Convenience function.  Fire event &quot;evt&quot; and pass it the\narguments specified in &quot;args&quot;."},"play":{"!type":"fn(delay?: number, gotoStart?: bool)","!doc":"Start the animation."},"_play":{"!type":"fn(gotoStart: ?) -> +dojo.Animation"},"pause":{"!type":"fn() -> +dojo.Animation","!doc":"Pauses a running animation."},"gotoPercent":{"!type":"fn(percent: +Decimal, andPlay?: bool) -> +dojo.Animation","!doc":"Sets the progress of the animation."},"stop":{"!type":"fn(gotoEnd?: bool) -> +dojo.Animation","!doc":"Stops a running animation."},"status":{"!type":"fn() -> string","!doc":"Returns a string token representation of the status of\nthe animation, one of: &quot;paused&quot;, &quot;playing&quot;, &quot;stopped&quot;"},"_cycle":{"!type":"fn() -> +dojo.Animation"},"_clearTimer":{"!type":"fn()","!doc":"Clear the play delay timer"},"_startTimer":{"!type":"fn()"},"_stopTimer":{"!type":"fn()"}}},"__AnimArgs":{"!type":"fn()","prototype":{"!proto":"dojo.__FadeArgs.prototype","properties":{}}},"_Line":{"!type":"fn(start: number, end: number)","!doc":"dojo._Line is the object used to generate values from a start value\nto an end value","getValue":{"!type":"fn(n: +float) -> +Decimal","!doc":"Returns the point on the line"}},"__XhrArgs":{"!type":"fn()","prototype":{"!proto":"dojo.__IoArgs.prototype","!doc":"In addition to the properties listed for the dojo._IoArgs type,\nthe following properties are allowed for dojo.xhr* methods.\nhandleAs: String?\nAcceptable values are: text (default), json, json-comment-optional,\njson-comment-filtered, javascript, xml\nsync: Boolean?\nfalse is default. Indicates whether the request should\nbe a synchronous (blocking) request.\nheaders: Object?\nAdditional HTTP headers to send in the request.","constructor":{"!type":"fn()","!doc":"In addition to the properties listed for the dojo._IoArgs type,\nthe following properties are allowed for dojo.xhr* methods.\nhandleAs: String?\nAcceptable values are: text (default), json, json-comment-optional,\njson-comment-filtered, javascript, xml\nsync: Boolean?\nfalse is default. Indicates whether the request should\nbe a synchronous (blocking) request.\nheaders: Object?\nAdditional HTTP headers to send in the request."}}},"_contentHandlers":{"text":{"!type":"fn(xhr: ?)"},"json":{"!type":"fn(xhr: ?)"},"json-comment-filtered":{"!type":"fn(xhr: ?)"},"javascript":{"!type":"fn(xhr: ?)"},"xml":{"!type":"fn(xhr: ?) -> +DOMDocument"},"json-comment-optional":{"!type":"fn(xhr: ?)"},"auto":{"!type":"fn(xhr: ?)"}},"_firebug":{"firebug":{}},"back":{"getHash":{},"setHash":{},"goBack":{},"goForward":{},"init":{"!type":"fn()","!doc":"Initializes the undo stack. This must be called from a &lt;script&gt;\nblock that lives inside the &lt;body&gt; tag to prevent bugs on IE."},"setInitialState":{"!type":"fn(args: ?)","!doc":"Sets the state object and back callback for the very first page\nthat is loaded."},"addToHistory":{"!type":"fn(args: +dojo.__backArgs)","!doc":"adds a state object (args) to the history list."},"_iframeLoaded":{"!type":"fn(evt: ?, ifrLoc: ?)","!doc":"private method. Do not call this directly."}},"cldr":{"monetary":{"getData":{"!type":"fn(code: string) -> ?","!doc":"A mapping of currency code to currency-specific formatting information. Returns a unique object with properties: places, round."}},"!doc":"transformation of relevant pieces of the Unicode.org Common Locale Data Repository\n(see http://unicode.org/cldr) to JSON from the original XML with associated utility classes","supplemental":{"getFirstDayOfWeek":{"!type":"fn(locale?: string)","!doc":"Returns a zero-based index for first day of the week"},"_region":{"!type":"fn(locale?: string)"},"getWeekend":{"!type":"fn(locale?: string)","!doc":"Returns a hash containing the start and end days of the weekend"}}},"colors":{"makeGrey":{"!type":"fn(g: number, a?: number)","!doc":"creates a greyscale color with an optional alpha"}},"cookie":{"!type":"fn(name: string, value?: string, props?: +dojo.__cookieProps)","!doc":"Get or set a cookie.","isSupported":{"!type":"fn()","!doc":"Use to determine if the current browser supports cookies or not.\n\nReturns true if user allows cookies.\nReturns false if user doesn't allow cookies."}},"currency":{"!doc":"localized formatting and parsing routines for currencies","_mixInDefaults":{"!type":"fn(options: ?)"},"format":{"!type":"fn(value: number, options?: +dojo.number.__FormatOptions)","!doc":"Format a Number as a currency, using locale-specific settings"},"regexp":{"!type":"fn(options?: +dojo.number.__RegexpOptions) -> string","!doc":"Builds the regular needed to parse a currency value"},"parse":{"!type":"fn(expression: string, options?: +dojo.currency.__ParseOptions)","!doc":"Convert a properly formatted currency string to a primitive Number,\nusing locale-specific settings."},"__ParseOptions":{"!type":"fn()","prototype":{"!proto":"dojo.number.__ParseOptions.prototype","type":{"!doc":"currency, set by default.","!type":"string"},"symbol":{"!doc":"override currency symbol. Normally, will be looked up in table of supported currencies,\nand ISO currency code will be used if not found.  See dojo.i18n.cldr.nls-&gt;currency.js","!type":"string"},"places":{"!doc":"number of decimal places to accept.  Default is defined by currency.","!type":"number"},"fractional":{"!doc":"where places are implied by pattern or explicit 'places' parameter, whether to include the fractional portion.\nBy default for currencies, it the fractional portion is optional.","!type":"bool"}}}},"data":{"!doc":"A uniform data access layer","ItemFileReadStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"The ItemFileReadStore implements the dojo.data.api.Read API and reads\ndata from JSON files that have contents in this format --\n{ items: [\n{ name:'Kermit', color:'green', age:12, friends:['Gonzo', {_reference:{name:'Fozzie Bear'}}]},\n{ name:'Fozzie Bear', wears:['hat', 'tie']},\n{ name:'Miss Piggy', pets:'Foo-Foo'}\n]}\nNote that it can also contain an 'identifer' property that specified which attribute on the items\nin the array of items that acts as the unique identifier for that item.\n\n\n\nuse \"\" rather than undefined for the benefit of the parser (#3539)","url":{"!type":"string"},"data":{},"typeMap":{},"clearOnClose":{"!type":"bool"},"urlPreventCache":{"!type":"bool"},"hierarchical":{"!type":"bool"},"constructor":{"!type":"fn(keywordParameters: ?)","!doc":"constructor"},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getValue":{"!type":"fn(item: +item, attribute: ?, defaultValue?: +value) -> +mixed","!doc":"See dojo.data.api.Read.getValue()"},"getValues":{"!type":"fn(item: +item, attribute: ?) -> []","!doc":"See dojo.data.api.Read.getValues()"},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: +item, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttribute()"},"containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything) -> +boolean.","!doc":"See dojo.data.api.Read.containsValue()"},"_containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything, regexp?: +RegExp) -> bool","!doc":"Internal function for looking at the values contained by the item."},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItem()"},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"getFeatures":{"!type":"fn() -> ?","!doc":"See dojo.data.api.Read.getFeatures()"},"getLabel":{"!type":"fn(item: +item) -> string","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"_fetchItems":{"!type":"fn(keywordArgs: ?, findCallback: fn(), errorCallback: fn())","!doc":"See dojo.data.util.simpleFetch.fetch()"},"_handleQueuedFetches":{"!type":"fn()","!doc":"Internal function to execute delayed request in the store.\nExecute any deferred fetches now."},"_getItemsArray":{"!type":"fn(queryOptions?: ?)","!doc":"Internal function to determine which list of items to search over."},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()"},"_getItemsFromLoadedData":{"!type":"fn(dataObject: ?)","!doc":"Function to parse the loaded data into item format and build the internal items array."},"_addReferenceToMap":{"!type":"fn(refItem: +item, parentItem: +item, attribute: string)","!doc":"Method to add an reference map entry for an item and attribute."},"getIdentity":{"!type":"fn(item: +item) -> number","!doc":"See dojo.data.api.Identity.getIdentity()"},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"},"_getItemByIdentity":{"!type":"fn(identity: ?) -> ?","!doc":"Internal function to look an item up by its identity map."},"getIdentityAttributes":{"!type":"fn(item: +item) -> +null","!doc":"See dojo.data.api.Identity.getIdentifierAttributes()"},"_forceLoad":{"!type":"fn()","!doc":"Internal function to force a load of the store if it hasn't occurred yet.  This is required\nfor specific functions to work properly."}}},"ItemFileWriteStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.ItemFileReadStore.prototype","referenceIntegrity":{"!type":"bool"},"constructor":{"!type":"fn(keywordParameters: ?)"},"_assert":{"!type":"fn(condition: bool)"},"_getIdentifierAttribute":{"!type":"fn()"},"newItem":{"!type":"fn(keywordArgs?: ?, parentInfo?: ?) -> +item","!doc":"See dojo.data.api.Write.newItem()"},"_removeArrayElement":{"!type":"fn(array: [], element: +anything)"},"deleteItem":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Write.deleteItem()"},"setValue":{"!type":"fn(item: +item, attribute: ?, value: +almost) -> bool","!doc":"See dojo.data.api.Write.set()"},"setValues":{"!type":"fn(item: +item, attribute: ?, values: []) -> bool","!doc":"See dojo.data.api.Write.setValues()"},"unsetAttribute":{"!type":"fn(item: +item, attribute: ?)","!doc":"See dojo.data.api.Write.unsetAttribute()"},"_setValueOrValues":{"!type":"fn(item: +item, attribute: ?, newValueOrValues: +anything, callOnSet?: bool) -> bool"},"_addReferenceToMap":{"!type":"fn(refItem: +item, parentItem: +item, attribute: string)","!doc":"Method to add an reference map entry for an item and attribute."},"_removeReferenceFromMap":{"!type":"fn(refItem: +item, parentItem: +item, attribute: +strin)","!doc":"Method to remove an reference map entry for an item and attribute."},"_dumpReferenceMap":{"!type":"fn()","!doc":"Function to dump the reverse reference map of all items in the store for debug purposes."},"_getValueOrValues":{"!type":"fn(item: +item, attribute: ?)"},"_flatten":{"!type":"fn(value: +anything)"},"_getNewFileContentString":{"!type":"fn()","!doc":"Generate a string that can be saved to a file.\nThe result should look similar to:\nhttp://trac.dojotoolkit.org/browser/dojo/trunk/tests/data/countries.json"},"_isEmpty":{"!type":"fn(something: +The) -> bool","!doc":"Function to determine if an array or object has no properties or values."},"save":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Write.save()"},"revert":{"!type":"fn() -> bool","!doc":"See dojo.data.api.Write.revert()"},"isDirty":{"!type":"fn(item?: +item) -> bool","!doc":"See dojo.data.api.Write.isDirty()"},"onSet":{"!type":"fn(item: +item, attribute: ?, oldValue: ?, newValue: ?)","!doc":"See dojo.data.api.Notification.onSet()"},"onNew":{"!type":"fn(newItem: +item, parentInfo?: ?)","!doc":"See dojo.data.api.Notification.onNew()"},"onDelete":{"!type":"fn(deletedItem: +item)","!doc":"See dojo.data.api.Notification.onDelete()"},"close":{"!type":"fn(request?: ?)","!doc":"Over-ride of base close function of ItemFileReadStore to add in check for store state."}}},"api":{"Identity":{"!type":"fn()","prototype":{"!proto":"dojo.data.api.Read.prototype","!doc":"This is an abstract API that data provider implementations conform to.\nThis file defines methods signatures and intentionally leaves all the\nmethods unimplemented.","getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"getIdentity":{"!type":"fn(item: +item) -> string","!doc":"Returns a unique identifier for an item.  The return value will be\neither a string or something that has a toString() method (such as,\nfor example, a dojox.uuid.Uuid object)."},"getIdentityAttributes":{"!type":"fn(item: +item) -> string","!doc":"Returns an array of attribute names that are used to generate the identity.\nFor most stores, this is a single attribute, but for some complex stores\nsuch as RDB backed stores that use compound (multi-attribute) identifiers\nit can be more than one.  If the identity is not composed of attributes\non the item, it will return null.  This function is intended to identify\nthe attributes that comprise the identity so that so that during a render\nof all attributes, the UI can hide the the identity information if it\nchooses."},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"Given the identity of an item, this method returns the item that has\nthat identity through the onItem callback.  Conforming implementations\nshould return null if there is no item with the given identity.\nImplementations of fetchItemByIdentity() may sometimes return an item\nfrom a local cache and may sometimes fetch an item from a remote server,"}}},"Notification":{"!type":"fn()","prototype":{"!proto":"dojo.data.api.Read.prototype","!doc":"This is an abstract API that data provider implementations conform to.\nThis file defines functions signatures and intentionally leaves all the\nfunctions unimplemented.","getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"onSet":{"!type":"fn(item: +item, attribute: ?, oldValue: ?, newValue: ?)","!doc":"This function is called any time an item is modified via setValue, setValues, unsetAttribute, etc."},"onNew":{"!type":"fn(newItem: +item, parentInfo?: ?)","!doc":"This function is called any time a new item is created in the store.\nIt is called immediately after the store newItem processing has completed."},"onDelete":{"!type":"fn(deletedItem: +item)","!doc":"This function is called any time an item is deleted from the store.\nIt is called immediately after the store deleteItem processing has completed."}}},"Read":{"!type":"fn()","prototype":{"!doc":"This is an abstract API that data provider implementations conform to.\nThis file defines methods signatures and intentionally leaves all the\nmethods unimplemented.  For more information on the dojo.data APIs,\nplease visit: http://www.dojotoolkit.org/node/98","getValue":{"!type":"fn(item: +item, attribute: ?, defaultValue?: +value)","!doc":"Returns a single attribute value.\nReturns defaultValue if and only if *item* does not have a value for *attribute*.\nReturns null if and only if null was explicitly set as the attribute value.\nReturns undefined if and only if the item does not have a value for the\ngiven attribute (which is the same as saying the item does not have the attribute)."},"getValues":{"!type":"fn(item: +item, attribute: ?)","!doc":"This getValues() method works just like the getValue() method, but getValues()\nalways returns an array rather than a single attribute value.  The array\nmay be empty, may contain a single attribute value, or may contain\nmany attribute values.\nIf the item does not have a value for the given attribute, then getValues()\nwill return an empty array: [].  (So, if store.hasAttribute(item, attribute)\nhas a return of false, then store.getValues(item, attribute) will return [].)"},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"Returns an array with all the attributes that this item has.  This\nmethod will always return an array; if the item has no attributes\nat all, getAttributes() will return an empty array: []."},"hasAttribute":{"!type":"fn(item: +item, attribute: ?) -> bool","!doc":"Returns true if the given *item* has a value for the given *attribute*."},"containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything) -> bool","!doc":"Returns true if the given *value* is one of the values that getValues()\nwould return."},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"Returns true if *something* is an item and came from the store instance.\nReturns false if *something* is a literal, an item from another store instance,\nor is any object other than an item."},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"Returns false if isItem(something) is false.  Returns false if\nif isItem(something) is true but the the item is not yet loaded\nin local memory (for example, if the item has not yet been read\nfrom the server)."},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"Given an item, this method loads the item so that a subsequent call\nto store.isItemLoaded(item) will return true.  If a call to\nisItemLoaded() returns true before loadItem() is even called,\nthen loadItem() need not do any work at all and will not even invoke\nthe callback handlers.  So, before invoking this method, check that\nthe item has not already been loaded."},"fetch":{"!type":"fn(keywordArgs: ?)","!doc":"Given a query and set of defined options, such as a start and count of items to return,\nthis method executes the query and makes the results available as data items.\nThe format and expectations of stores is that they operate in a generally asynchronous\nmanner, therefore callbacks are always used to return items located by the fetch parameters."},"getFeatures":{"!type":"fn()","!doc":"The getFeatures() method returns an simple keyword values object\nthat specifies what interface features the datastore implements.\nA simple CsvStore may be read-only, and the only feature it\nimplements will be the 'dojo.data.api.Read' interface, so the\ngetFeatures() method will return an object like this one:\n{'dojo.data.api.Read': true}.\nA more sophisticated datastore might implement a variety of\ninterface features, like 'dojo.data.api.Read', 'dojo.data.api.Write',\n'dojo.data.api.Identity', and 'dojo.data.api.Attribution'."},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"The close() method is intended for instructing the store to 'close' out\nany information associated with a particular request."},"getLabel":{"!type":"fn(item: +item)","!doc":"Method to inspect the item and return a user-readable 'label' for the item\nthat provides a general/adequate description of what the item is."},"getLabelAttributes":{"!type":"fn(item: +item)","!doc":"Method to inspect the item and return an array of what attributes of the item were used\nto generate its label, if any."}}},"Request":{"!type":"fn()","prototype":{"!doc":"This class defines out the semantics of what a 'Request' object looks like\nwhen returned from a fetch() method.  In general, a request object is\nnothing more than the original keywordArgs from fetch with an abort function\nattached to it to allow users to abort a particular request if they so choose.\nNo other functions are required on a general Request object return.  That does not\ninhibit other store implementations from adding extentions to it, of course.\n\nThis is an abstract API that data provider implementations conform to.\nThis file defines methods signatures and intentionally leaves all the\nmethods unimplemented.\n\nFor more details on fetch, see dojo.data.api.Read.fetch().","abort":{"!type":"fn()","!doc":"This function is a hook point for stores to provide as a way for\na fetch to be halted mid-processing."}}},"Write":{"!type":"fn()","prototype":{"!proto":"dojo.data.api.Read.prototype","!doc":"This is an abstract API that data provider implementations conform to.\nThis file defines function signatures and intentionally leaves all the\nfunctionss unimplemented.","getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"newItem":{"!type":"fn(keywordArgs?: ?, parentInfo?: ?) -> +item","!doc":"Returns a newly created item.  Sets the attributes of the new\nitem based on the *keywordArgs* provided.  In general, the attribute\nnames in the keywords become the attributes in the new item and as for\nthe attribute values in keywordArgs, they become the values of the attributes\nin the new item.  In addition, for stores that support hierarchical item\ncreation, an optional second parameter is accepted that defines what item is the parent\nof the new item and what attribute of that item should the new item be assigned to.\nIn general, this will assume that the attribute targetted is multi-valued and a new item\nis appended onto the list of values for that attribute."},"deleteItem":{"!type":"fn(item: +item) -> bool","!doc":"Deletes an item from the store."},"setValue":{"!type":"fn(item: +item, attribute: string, value: +almost) -> bool","!doc":"Sets the value of an attribute on an item.\nReplaces any previous value or values."},"setValues":{"!type":"fn(item: +item, attribute: string, values: []) -> bool","!doc":"Adds each value in the *values* array as a value of the given\nattribute on the given item.\nReplaces any previous value or values.\nCalling store.setValues(x, y, []) (with *values* as an empty array) has\nthe same effect as calling store.unsetAttribute(x, y)."},"unsetAttribute":{"!type":"fn(item: +item, attribute: string) -> bool","!doc":"Deletes all the values of an attribute on an item."},"save":{"!type":"fn(keywordArgs: ?)","!doc":"Saves to the server all the changes that have been made locally.\nThe save operation may take some time and is generally performed\nin an asynchronous fashion.  The outcome of the save action is\nis passed into the set of supported callbacks for the save."},"revert":{"!type":"fn() -> bool","!doc":"Discards any unsaved changes."},"isDirty":{"!type":"fn(item?: +item) -> bool","!doc":"Given an item, isDirty() returns true if the item has been modified\nsince the last save().  If isDirty() is called with no *item* argument,\nthen this function returns true if any item has been modified since\nthe last save()."}}}},"util":{"filter":{"patternToRegExp":{"!type":"fn(pattern: string, ignoreCase?: bool) -> +RegExp","!doc":"Helper function to convert a simple pattern to a regular expression for matching."}},"simpleFetch":{"fetch":{"!type":"fn(request?: ?) -> ?","!doc":"The simpleFetch mixin is designed to serve as a set of function(s) that can\nbe mixed into other datastore implementations to accelerate their development.\nThe simpleFetch mixin should work well for any datastore that can respond to a _fetchItems()\ncall by returning an array of all the found items that matched the query.  The simpleFetch mixin\nis not designed to work for datastores that respond to a fetch() call by incrementally\nloading items, or sequentially loading partial batches of the result\nset.  For datastores that mixin simpleFetch, simpleFetch\nimplements a fetch method that automatically handles eight of the fetch()\narguments -- onBegin, onItem, onComplete, onError, start, count, sort and scope\nThe class mixing in simpleFetch should not implement fetch(),\nbut should instead implement a _fetchItems() method.  The _fetchItems()\nmethod takes three arguments, the keywordArgs object that was passed\nto fetch(), a callback function to be called when the result array is\navailable, and an error callback to be called if something goes wrong.\nThe _fetchItems() method should ignore any keywordArgs parameters for\nstart, count, onBegin, onItem, onComplete, onError, sort, and scope.\nThe _fetchItems() method needs to correctly handle any other keywordArgs\nparameters, including the query parameter and any optional parameters\n(such as includeChildren).  The _fetchItems() method should create an array of\nresult items and pass it to the fetchHandler along with the original request object\n-- or, the _fetchItems() method may, if it wants to, create an new request object\nwith other specifics about the request that are specific to the datastore and pass\nthat as the request object to the handler.\n\nFor more information on this specific function, see dojo.data.api.Read.fetch()"}},"sorter":{"basicComparator":{"!type":"fn(a: +anything, b: +anything)","!doc":"Basic comparision function that compares if an item is greater or less than another item"},"createSortFunction":{"!type":"fn(sortSpec: +attributes, store: +dojo.data.core.Read) -> number","!doc":"Helper function to generate the sorting function based off the list of sort attributes."}}}},"fx":{"!doc":"Effects library on top of Base animations","chain":{"!type":"fn(animations: [+dojo.Animation]) -> +dojo.Animation","!doc":"Chain a list of dojo.Animation s to run in sequence"},"combine":{"!type":"fn(animations: [+dojo.Animation]) -> +dojo.Animation","!doc":"Combine an array of <code>dojo.Animation</code>s to run in parallel"},"wipeIn":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation that will expand the\nnode defined in 'args' object from it's current height to\nit's natural height (with no scrollbar).\nNode must have no margin/border/padding."},"wipeOut":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation that will shrink node defined in &quot;args&quot;\nfrom it's current height to 1px, and then hide it."},"slideTo":{"!type":"fn(args?: ?) -> +dojo.Animation","!doc":"Returns an animation that will slide &quot;node&quot;\ndefined in args Object from its current position to\nthe position defined by (args.left, args.top)."},"Toggler":{"!type":"fn()","prototype":{"!doc":"class constructor for an animation toggler. It accepts a packed\nset of arguments about what type of animation to use in each\ndirection, duration, etc.","node":{"!doc":"the node to toggle","!type":"+Node"},"showDuration":{"!doc":"in milliseconds to run the show Animation","!type":"+Time"},"hideDuration":{"!doc":"in milliseconds to run the hide Animation","!type":"+Time"},"_showArgs":{},"_showAnim":{},"_hideArgs":{},"_hideAnim":{},"_isShowing":{"!type":"bool"},"_isHiding":{"!type":"bool"},"constructor":{"!type":"fn(args: ?)"},"show":{"!type":"fn(delay: ?)","!doc":"Toggle the node to showing"},"hide":{"!type":"fn(delay: ?)","!doc":"Toggle the node to hidden"}},"showFunc":{"!type":"fn()","!doc":"The function that returns the dojo.Animation to show the node"},"hideFunc":{"!type":"fn()","!doc":"The function that returns the dojo.Animation to hide the node"}},"easing":{"!doc":"Collection of easing functions to use beyond the default\n<code>dojo._defaultEasing</code> function.","linear":{"!type":"fn(n?: +Decimal)","!doc":"A linear easing function"},"quadIn":{"!type":"fn(n?: +Decimal)"},"quadOut":{"!type":"fn(n?: +Decimal)"},"quadInOut":{"!type":"fn(n?: +Decimal)"},"cubicIn":{"!type":"fn(n?: +Decimal)"},"cubicOut":{"!type":"fn(n?: +Decimal)"},"cubicInOut":{"!type":"fn(n?: +Decimal)"},"quartIn":{"!type":"fn(n?: +Decimal)"},"quartOut":{"!type":"fn(n?: +Decimal)"},"quartInOut":{"!type":"fn(n?: +Decimal)"},"quintIn":{"!type":"fn(n?: +Decimal)"},"quintOut":{"!type":"fn(n?: +Decimal)"},"quintInOut":{"!type":"fn(n?: +Decimal)"},"sineIn":{"!type":"fn(n?: +Decimal)"},"sineOut":{"!type":"fn(n?: +Decimal)"},"sineInOut":{"!type":"fn(n?: +Decimal)"},"expoIn":{"!type":"fn(n?: +Decimal)"},"expoOut":{"!type":"fn(n?: +Decimal)"},"expoInOut":{"!type":"fn(n?: +Decimal)"},"circIn":{"!type":"fn(n?: +Decimal)"},"circOut":{"!type":"fn(n?: +Decimal)"},"circInOut":{"!type":"fn(n?: +Decimal)"},"backIn":{"!type":"fn(n?: +Decimal)","!doc":"An easing function that starts away from the target,\nand quickly accelerates towards the end value.\n\nUse caution when the easing will cause values to become\nnegative as some properties cannot be set to negative values."},"backOut":{"!type":"fn(n?: +Decimal)","!doc":"An easing function that pops past the range briefly, and slowly comes back."},"backInOut":{"!type":"fn(n?: +Decimal)","!doc":"An easing function combining the effects of <code>backIn</code> and <code>backOut</code>"},"elasticIn":{"!type":"fn(n?: +Decimal)","!doc":"An easing function the elastically snaps from the start value"},"elasticOut":{"!type":"fn(n?: +Decimal)","!doc":"An easing function that elasticly snaps around the target value,\nnear the end of the Animation"},"elasticInOut":{"!type":"fn(n?: +Decimal)","!doc":"An easing function that elasticly snaps around the value, near\nthe beginning and end of the Animation."},"bounceIn":{"!type":"fn(n?: +Decimal) -> +Decimal","!doc":"An easing function that 'bounces' near the beginning of an Animation"},"bounceOut":{"!type":"fn(n?: +Decimal)","!doc":"An easing function that 'bounces' near the end of an Animation"},"bounceInOut":{"!type":"fn(n?: +Decimal) -> +Decimal","!doc":"An easing function that 'bounces' at the beginning and end of the Animation"}}},"gears":{"available":{"!doc":"True if client is using Google Gears","!type":"bool"},"_gearsObject":{"!type":"fn()","!doc":"factory method to get a Google Gears plugin instance to\nexpose in the browser runtime environment, if present"}},"html":{"_secureForInnerHtml":{"!type":"fn(cont: string) -> string","!doc":"removes !DOCTYPE and title elements from the html string.\n\nkhtml is picky about dom faults, you can't attach a style or &lt;title&gt; node as child of body\nmust go into head, so we need to cut out those tags"},"_emptyNode":{"!type":"fn(node: +Node)","!doc":"removes all child nodes from the given node"},"_setNodeContent":{"!type":"fn(node: +Node, cont: string, shouldEmptyFirst?: bool)","!doc":"inserts the given content into the given node\noverlaps similiar functionality in dijit.layout.ContentPane._setContent"},"set":{"!type":"fn(node: +Node, cont: string, params?: ?)","!doc":"inserts (replaces) the given content into the given node. dojo.place(cont, node, &quot;only&quot;)\nmay be a better choice for simple HTML insertion."},"_ContentSetter":{"!type":"fn()","prototype":{"!doc":"Provides a configurable, extensible object to wrap the setting on content on a node\ncall the set() method to actually set the content..","node":{"!doc":"An node which will be the parent element that we set content into","!type":"+DomNode"},"content":{"!doc":"The content to be placed in the node. Can be an HTML string, a node reference, or a enumerable list of nodes","!type":"string"},"id":{"!doc":"Usually only used internally, and auto-generated with each instance","!type":"string"},"cleanContent":{"!doc":"Should the content be treated as a full html document,\nand the real content stripped of &lt;html&gt;, &lt;body&gt; wrapper before injection","!type":"bool"},"extractContent":{"!doc":"Should the content be treated as a full html document, and the real content stripped of &lt;html&gt;, &lt;body&gt; wrapper before injection","!type":"bool"},"parseContent":{"!doc":"Should the node by passed to the parser after the new content is set","!type":"bool"},"constructor":{"!type":"fn(params: ?, node: string)","!doc":"Provides a configurable, extensible object to wrap the setting on content on a node\ncall the set() method to actually set the content.."},"set":{"!type":"fn(cont?: string, params?: ?)","!doc":"front-end to the set-content sequence"},"setContent":{"!type":"fn()","!doc":"sets the content on the node"},"empty":{"!type":"fn()"},"onBegin":{"!type":"fn()"},"onEnd":{"!type":"fn()"},"tearDown":{"!type":"fn()"},"onContentError":{"!type":"fn(err: ?)"},"_mixin":{"!type":"fn(params: ?)"},"_parse":{"!type":"fn()","!doc":"runs the dojo parser over the node contents, storing any results in this.parseResults\nAny errors resulting from parsing are passed to _onError for handling"},"_onError":{"!type":"fn(type: ?, err: ?, consoleText: ?)","!doc":"shows user the string that is returned by on[type]Error\noveride/implement on[type]Error and return your own string to customize"}}}},"i18n":{"!doc":"Utility classes to enable loading of resources for internationalization (i18n)","getLocalization":{"!type":"fn(packageName: string, bundleName: string, locale?: string) -> ?","!doc":"Returns an Object containing the localization for a given resource\nbundle in a package, matching the specified locale."},"normalizeLocale":{"!type":"fn(locale?: string) -> string","!doc":"Returns canonical form of locale, as used by Dojo."},"_requireLocalization":{"!type":"fn(moduleName: string, bundleName: string, locale?: string, availableFlatLocales?: string, m: ?, b: ?)","!doc":"See dojo.requireLocalization()"},"_searchLocalePath":{"!type":"fn(locale: string, down: bool, searchFunc: fn())","!doc":"A helper method to assist in searching for locale-based resources.\nWill iterate through the variants of a particular locale, either up\nor down, executing a callback function.  For example, &quot;en-us&quot; and\ntrue will try &quot;en-us&quot; followed by &quot;en&quot; and finally &quot;ROOT&quot;."},"_preloadLocalizations":{"!type":"fn(bundlePrefix: string, localesGenerated: []) -> bool","!doc":"Load built, flattened resource bundles, if available for all\nlocales used in the page. Only called by built layer files."}},"io":{"iframe":{"_currentDfd":{},"_dfdQueue":{"!type":"[]"},"_iframeName":{"!type":"string"},"create":{"!type":"fn(fname: string, onloadstr: string, uri?: string)","!doc":"Creates a hidden iframe in the page. Used mostly for IO\ntransports.  You do not need to call this to start a\ndojo.io.iframe request. Just call send()."},"setSrc":{"!type":"fn(iframe: +Node, src: string, replace: bool)","!doc":"Sets the URL that is loaded in an IFrame. The replace parameter\nindicates whether location.replace() should be used when\nchanging the location of the iframe."},"doc":{"!type":"fn(iframeNode: +Node)","!doc":"Returns the document object associated with the iframe DOM Node argument."},"send":{"!type":"fn(args: +dojo.io.iframe.__ioArgs)","!doc":"function that sends the request to the server.\nThis transport can only process one send() request at a time, so if send() is called\nmultiple times, it will queue up the calls and only process one at a time."},"_fireNextRequest":{"!type":"fn()","!doc":"Internal method used to fire the next request in the bind queue."},"_iframeOnload":{"!type":"fn()"},"__ioArgs":{"!type":"fn()","!doc":"All the properties described in the dojo.__ioArgs type, apply\nto this type. The following additional properties are allowed\nfor dojo.io.iframe.send():\nmethod: String?\nThe HTTP method to use. \"GET\" or \"POST\" are the only supported\nvalues.  It will try to read the value from the form node's\nmethod, then try this argument. If neither one exists, then it\ndefaults to POST.\nhandleAs: String?\nSpecifies what format the result data should be given to the\nload/handle callback. Valid values are: text, html, xml, json,\njavascript. IMPORTANT: For all values EXCEPT html and xml, The\nserver response should be an HTML file with a textarea element.\nThe response data should be inside the textarea element. Using an\nHTML document the only reliable, cross-browser way this\ntransport can know when the response has loaded. For the html\nhandleAs value, just return a normal HTML document.  NOTE: xml\nis now supported with this transport (as of 1.1+); a known issue\nis if the XML document in question is malformed, Internet Explorer\nwill throw an uncatchable error.\ncontent: Object?\nIf \"form\" is one of the other args properties, then the content\nobject properties become hidden form form elements. For\ninstance, a content object of {name1 : \"value1\"} is converted\nto a hidden form element with a name of \"name1\" and a value of\n\"value1\". If there is not a \"form\" property, then the content\nobject is converted into a name=value&name=value string, by\nusing dojo.objectToQuery().","prototype":{"constructor":{"!type":"fn()","!doc":"All the properties described in the dojo.__ioArgs type, apply\nto this type. The following additional properties are allowed\nfor dojo.io.iframe.send():\nmethod: String?\nThe HTTP method to use. &quot;GET&quot; or &quot;POST&quot; are the only supported\nvalues.  It will try to read the value from the form node's\nmethod, then try this argument. If neither one exists, then it\ndefaults to POST.\nhandleAs: String?\nSpecifies what format the result data should be given to the\nload/handle callback. Valid values are: text, html, xml, json,\njavascript. IMPORTANT: For all values EXCEPT html and xml, The\nserver response should be an HTML file with a textarea element.\nThe response data should be inside the textarea element. Using an\nHTML document the only reliable, cross-browser way this\ntransport can know when the response has loaded. For the html\nhandleAs value, just return a normal HTML document.  NOTE: xml\nis now supported with this transport (as of 1.1+); a known issue\nis if the XML document in question is malformed, Internet Explorer\nwill throw an uncatchable error.\ncontent: Object?\nIf &quot;form&quot; is one of the other args properties, then the content\nobject properties become hidden form form elements. For\ninstance, a content object of {name1 : &quot;value1&quot;} is converted\nto a hidden form element with a name of &quot;name1&quot; and a value of\n&quot;value1&quot;. If there is not a &quot;form&quot; property, then the content\nobject is converted into a name=value&amp;name=value string, by\nusing dojo.objectToQuery()."}}}},"!doc":"Additional I/O transports (Ajax)","script":{"_deadScripts":{"!type":"[]"},"_counter":{"!type":"number"},"get":{"!type":"fn(args: +dojo.io.script.__ioArgs)","!doc":"sends a get request using a dynamically created script tag."},"attach":{"!type":"fn(id: string, url: string, frameDocument?: +Document)","!doc":"creates a new &lt;script&gt; tag pointing to the specified URL and\nadds it to the document."},"remove":{"!type":"fn(id: string, frameDocument?: +Document)","!doc":"removes the script element with the given id, from the given frameDocument.\nIf no frameDocument is passed, the current document is used."},"_makeScriptDeferred":{"!type":"fn(args: ?) -> +dojo.Deferred","!doc":"sets up a Deferred object for an IO request."},"_deferredCancel":{"!type":"fn(dfd: +Deferred)","!doc":"canceller function for dojo._ioSetArgs call."},"_deferredOk":{"!type":"fn(dfd: +Deferred)","!doc":"okHandler function for dojo._ioSetArgs call."},"_deferredError":{"!type":"fn(error: +Error, dfd: +Deferred)","!doc":"errHandler function for dojo._ioSetArgs call."},"_addDeadScript":{"!type":"fn(ioArgs: ?)","!doc":"sets up an entry in the deadScripts array."},"_validCheck":{"!type":"fn(dfd: +Deferred)","!doc":"inflight check function to see if dfd is still valid."},"_ioCheck":{"!type":"fn(dfd: +Deferred)","!doc":"inflight check function to see if IO finished."},"_resHandle":{"!type":"fn(dfd: +Deferred)","!doc":"inflight function to handle a completed response."},"_canAttach":{"!type":"fn(ioArgs: ?)","!doc":"provides an override of dojo.io.script._canAttach to check for\nthe existence of a the args.frameDoc property. If it is there, and it is a string,\nnot a document, then create the iframe with an ID of frameDoc, and use that for the calls.\nIf frameDoc is a document, then dojox.io.scriptFrame should not get involved."},"_jsonpCallback":{"!type":"fn(json: +JSON)","!doc":"generic handler for jsonp callback. A pointer to this function\nis used for all jsonp callbacks.  NOTE: the &quot;this&quot; in this\nfunction will be the Deferred object that represents the script\nrequest."},"__ioArgs":{"!type":"fn()","!doc":"All the properties described in the dojo.__ioArgs type, apply to this\ntype as well, EXCEPT \"handleAs\". It is not applicable to\ndojo.io.script.get() calls, since it is implied by the usage of\n\"callbackParamName\" (response will be a JSONP call returning JSON)\nor \"checkString\" (response is pure JavaScript defined in\nthe body of the script that was attached).\ncallbackParamName: String\nThe URL parameter name that indicates the JSONP callback string.\nFor instance, when using Yahoo JSONP calls it is normally,\ncallbackParamName: \"callback\". For AOL JSONP calls it is normally\ncallbackParamName: \"c\".\ncheckString: String\nA string of JavaScript that when evaluated like so:\n\"typeof(\" + checkString + \") != 'undefined'\"\nbeing true means that the script fetched has been loaded.\nDo not use this if doing a JSONP type of call (use callbackParamName instead).\nframeDoc: Document\nThe Document object for a child iframe. If this is passed in, the script\nwill be attached to that document. This can be helpful in some comet long-polling\nscenarios with Firefox and Opera.","prototype":{"constructor":{"!type":"fn()","!doc":"All the properties described in the dojo.__ioArgs type, apply to this\ntype as well, EXCEPT &quot;handleAs&quot;. It is not applicable to\ndojo.io.script.get() calls, since it is implied by the usage of\n&quot;callbackParamName&quot; (response will be a JSONP call returning JSON)\nor &quot;checkString&quot; (response is pure JavaScript defined in\nthe body of the script that was attached).\ncallbackParamName: String\nThe URL parameter name that indicates the JSONP callback string.\nFor instance, when using Yahoo JSONP calls it is normally,\ncallbackParamName: &quot;callback&quot;. For AOL JSONP calls it is normally\ncallbackParamName: &quot;c&quot;.\ncheckString: String\nA string of JavaScript that when evaluated like so:\n&quot;typeof(&quot; + checkString + &quot;) != 'undefined'&quot;\nbeing true means that the script fetched has been loaded.\nDo not use this if doing a JSONP type of call (use callbackParamName instead).\nframeDoc: Document\nThe Document object for a child iframe. If this is passed in, the script\nwill be attached to that document. This can be helpful in some comet long-polling\nscenarios with Firefox and Opera."}}}}},"number":{"!doc":"localized formatting and parsing routines for Number","_numberPatternRE":{"!type":"+RegExp"},"__FormatOptions":{"!type":"fn()"},"format":{"!type":"fn(value: number, options?: +dojo.number.__FormatOptions) -> +null","!doc":"Format a Number as a String, using locale-specific settings"},"_applyPattern":{"!type":"fn(value: number, pattern: string, options?: +dojo.number.__FormatOptions)","!doc":"Apply pattern to format value as a string using options. Gives no\nconsideration to local customs."},"round":{"!type":"fn(value: number, places?: number, increment?: number, v: ?, p: ?, m: ?) -> number","!doc":"Rounds to the nearest value with the given number of decimal places, away from zero"},"__FormatAbsoluteOptions":{"!type":"fn()"},"_formatAbsolute":{"!type":"fn(value: number, pattern: string, options?: +dojo.number.__FormatAbsoluteOptions)","!doc":"Apply numeric pattern to absolute value using options. Gives no\nconsideration to local customs."},"__RegexpOptions":{"!type":"fn()"},"regexp":{"!type":"fn(options?: +dojo.number.__RegexpOptions) -> string","!doc":"Builds the regular needed to parse a number"},"_parseInfo":{"!type":"fn(options?: ?) -> ?"},"__ParseOptions":{"!type":"fn()"},"parse":{"!type":"fn(expression: string, options?: +dojo.number.__ParseOptions) -> +NaN","!doc":"Convert a properly formatted string to a primitive Number, using\nlocale-specific settings."},"__RealNumberRegexpFlags":{"!type":"fn()"},"_realNumberRegexp":{"!type":"fn(flags?: +dojo.number.__RealNumberRegexpFlags) -> string","!doc":"Builds a regular expression to match a real number in exponential\nnotation"},"__IntegerRegexpFlags":{"!type":"fn()"},"_integerRegexp":{"!type":"fn(flags?: +dojo.number.__IntegerRegexpFlags) -> string","!doc":"Builds a regular expression that matches an integer"}},"regexp":{"!doc":"Regular expressions and Builder resources","escapeString":{"!type":"fn(str: string, except?: string)","!doc":"Adds escape sequences for special characters in regular expressions"},"buildGroupRE":{"!type":"fn(arr: +Object, re: fn(), nonCapture?: bool) -> string","!doc":"Builds a regular expression that groups subexpressions"},"group":{"!type":"fn(expression: string, nonCapture?: bool) -> string","!doc":"adds group match to expression"}},"rpc":{"!doc":"Dojo remote-procedure-call resources","JsonService":{"!type":"fn()","prototype":{"!proto":"dojo.rpc.RpcService.prototype","bustCache":{"!type":"bool"},"contentType":{"!type":"string"},"lastSubmissionId":{"!type":"number"},"callRemote":{"!type":"fn(method: string, params: [])","!doc":"call an arbitrary remote method without requiring it to be\npredefined with SMD"},"bind":{"!type":"fn(method: string, parameters: [], deferredRequestHandler: +deferred, url: ?)","!doc":"JSON-RPC bind method. Takes remote method, parameters,\ndeferred, and a url, calls createRequest to make a JSON-RPC\nenvelope and passes that off with bind."},"createRequest":{"!type":"fn(method: string, params: [])","!doc":"create a JSON-RPC envelope for the request"},"parseResults":{"!type":"fn(obj: +anything)","!doc":"parse the result envelope and pass the results back to\nthe callback function"}}},"JsonpService":{"!type":"fn()","prototype":{"!proto":"dojo.rpc.RpcService.prototype","!doc":"Generic JSONP service.  Minimally extends RpcService to allow\neasy definition of nearly any JSONP style service. Example\nSMD files exist in dojox.data","strictArgChecks":{"!type":"bool"},"constructor":{"!type":"fn(args: ?, requiredArgs: ?)"},"bind":{"!type":"fn(method: string, parameters: [], deferredRequestHandler: +deferred, url: ?)","!doc":"JSONP bind method. Takes remote method, parameters,\ndeferred, and a url, calls createRequest to make a JSON-RPC\nenvelope and passes that off with bind."},"createRequest":{"!type":"fn(parameters: ?)","!doc":"create a JSONP req\nparams: array\nThe array of parameters for this request;"}}},"RpcService":{"!type":"fn()","prototype":{"!doc":"Take a string as a url to retrieve an smd or an object that is an smd or partial smd to use\nas a definition for the service\n\nargs: object\nTakes a number of properties as kwArgs for defining the service.  It also\naccepts a string.  When passed a string, it is treated as a url from\nwhich it should synchronously retrieve an smd file.  Otherwise it is a kwArgs\nobject.  It accepts serviceUrl, to manually define a url for the rpc service\nallowing the rpc system to be used without an smd definition. strictArgChecks\nforces the system to verify that the # of arguments provided in a call\nmatches those defined in the smd.  smdString allows a developer to pass\na jsonString directly, which will be converted into an object or alternatively\nsmdObject is accepts an smdObject directly.","strictArgChecks":{"!type":"bool"},"serviceUrl":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Take a string as a url to retrieve an smd or an object that is an smd or partial smd to use\nas a definition for the service"},"parseResults":{"!type":"fn(obj: ?)"},"errorCallback":{"!type":"fn(deferredRequestHandler: +dojo.Deferred)","!doc":"create callback that calls the Deferres errback method"},"resultCallback":{"!type":"fn(deferredRequestHandler: +dojo.Deferred)","!doc":"create callback that calls the Deferred's callback method"},"generateMethod":{"!type":"fn(method: string, parameters: [], url: string)","!doc":"generate the local bind methods for the remote object"},"processSmd":{"!type":"fn(object: +smd)","!doc":"callback method for reciept of a smd object.  Parse the smd\nand generate functions based on the description"}}}}},"thix":{"x":{},"width":{}},"Math":{"floor":{},"PI":{}},"doh":{"robot":{"_scrollIntoView":{"!type":"fn(node: string)","!doc":"Scroll the passed node into view, if it is not.\nStub to be replaced dijit.robot."},"_updateDocument":{"!type":"fn()"},"scrollIntoView":{"!type":"fn(node: string, delay: number)","!doc":"Scroll the passed node into view, if it is not."},"mouseMoveAt":{"!type":"fn(node: string, delay: +Integer, duration: +Integer, offsetX: number, offsetY: number)","!doc":"Moves the mouse over the specified node at the specified relative x,y offset."},"initRobot":{"!type":"fn(url: string)","!doc":"Opens the application at the specified URL for testing, redirecting dojo to point to the application environment instead of the test environment."},"waitForPageToLoad":{"!type":"fn(submitActions: fn())","!doc":"Notifies DOH that the doh.robot is about to make a page change in the application it is driving,\nreturning a doh.Deferred object the user should return in their runTest function as part of a DOH test."}}},"Array":{"slice":{},"concat":{},"_wrap":{"!type":"fn(arr: ?)"}},"djConfig":{"isDebug":{"!type":"bool"},"debugAtAllCosts":{"!type":"bool"},"baseUrl":{},"urchin":{"!type":"string"},"preloadImages":{"!type":"[]"}},"navigator":{"userAgent":{},"appVersion":{},"cookieEnabled":{"!type":"bool"},"plugins":{"Shockwave Flash":{},"length":{}}},"document":{"compatMode":{},"documentElement":{},"cookie":{"!type":"string"},"styleSheets":{},"title":{"!type":"string"},"body":{"style":{"cursor":{"!type":"string"}},"onselectstart":{"!type":"fn()"}}},"console":{"warn":{},"error":{},"info":{},"log":{"!type":"fn(m: ?)"},"debug":{"!type":"fn()"}},"e":{"stack":{"!type":"string"}},"window":{"dojo":{},"dijit":{},"dojox":{},"status":{"!type":"string"},"onFirebugResize":{"!type":"fn()"},"passthrough":{"!type":"fn()"},"onload":{"!type":"fn()"},"console":{"_connects":{"!type":"[]"},"log":{"!type":"fn()","!doc":"Sends arguments to console."},"debug":{"!type":"fn()","!doc":"Sends arguments to console. Missing finctionality to show script line of trace."},"info":{"!type":"fn()","!doc":"Sends arguments to console, highlighted with (I) icon."},"warn":{"!type":"fn()","!doc":"Sends warning arguments to console, highlighted with (!) icon and blue style."},"error":{"!type":"fn()","!doc":"Sends error arguments (object) to console, highlighted with (X) icon and yellow style\nNEW: error object now displays in object inspector"},"assert":{"!type":"fn(truth: ?, message: ?)","!doc":"Tests for true. Throws exception if false."},"dir":{"!type":"fn(obj: ?)"},"dirxml":{"!type":"fn(node: ?)"},"group":{"!type":"fn()","!doc":"collects log messages into a group, starting with this call and ending with\ngroupEnd(). Missing collapse functionality"},"groupEnd":{"!type":"fn()","!doc":"Closes group. See above"},"time":{"!type":"fn(name: ?)","!doc":"Starts timers assigned to name given in argument. Timer stops and displays on timeEnd(title);"},"timeEnd":{"!type":"fn(name: ?)","!doc":"See above."},"count":{"!type":"fn(name: ?)","!doc":"Not supported"},"trace":{"!type":"fn(_value: ?)"},"profile":{"!type":"fn()","!doc":"Not supported"},"profileEnd":{"!type":"fn()"},"clear":{"!type":"fn()","!doc":"Clears message console. Do not call this directly"},"open":{"!type":"fn()","!doc":"Opens message console. Do not call this directly"},"close":{"!type":"fn()","!doc":"Closes message console. Do not call this directly"},"_restoreBorder":{"!type":"fn()"},"openDomInspector":{"!type":"fn()"},"_closeDomInspector":{"!type":"fn()"},"openConsole":{"!type":"fn()","!doc":"Closes object inspector and opens message console. Do not call this directly"},"openObjectInspector":{"!type":"fn()"},"recss":{"!type":"fn()"}},"location":{"hash":{},"href":{"!type":"string"}},"frames":{"dj_history":{"location":{}}},"event":{"srcElement":{"id":{"!type":"string"}}}},"style":{"left":{},"width":{"!type":"string"}},"runtimeStyle":{"left":{}},"Object":{"toString":{}},"RegExp":{"rightContext":{},"leftContext":{}},"Expr":{"order":{"length":{}}},"acme":{"doc":{},"NodeList":{},"trim":{"!type":"fn(str: string) -> string","!doc":"trims whitespaces from both sides of the string"},"forEach":{"!type":"fn(arr: string, callback: fn(), thisObject?: ?)","!doc":"an iterator function that passes items, indexes,\nand the array to a callback"},"byId":{"!type":"fn(id: ?, doc: ?) -> +Node","!doc":"a function that return an element by ID, but also\naccepts nodes safely"},"isString":{"!type":"fn(item: ?) -> bool","!doc":"is item a string?"}},"history":{"length":{}},"dojox":{"analytics":{"!type":"fn()","!doc":"TODOC\nwhere we store data until we're ready to send it off.\n\nthe data queue;","_base":{},"prototype":{"schedulePusher":{"!type":"fn(interval: number)","!doc":"Schedule the data pushing routines to happen in interval ms"},"addData":{"!type":"fn(dataType: ?, data: ?)","!doc":"add data to the queue. Will be pusshed to the server on the next\ndata push"},"checkData":{"!type":"fn()","!doc":"TODOC?"},"pushData":{"!type":"fn()","!doc":"pushes data to the server if any exists.  If a push is done, return\nthe deferred after hooking up completion callbacks.  If there is no data\nto be pushed, return false;"},"getQueryPacket":{"!type":"fn()","!doc":"TODOC"},"onPushComplete":{"!type":"fn(results: ?)","!doc":"If our data push was successfully, remove the _inTransit data and schedule the next\nparser run."}},"Urchin":{"!type":"fn()","prototype":{"!doc":"A Google-analytics helper, for post-onLoad inclusion of the tracker, and\ndynamic tracking during long-lived page cycles.","acct":{"!doc":"your GA urchin tracker account number. Overrides <code>djConfig.urchin</code>","!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initialize this Urchin instance. Immediately starts the load\nsequence, so defer construction until (ideally) after onLoad and\npotentially widget parsing."},"_gotGA":{"!type":"fn()","!doc":"initialize the tracker"},"GAonLoad":{"!type":"fn()","!doc":"Stub function to fire when urchin is complete"},"trackPageView":{"!type":"fn(url: string)","!doc":"A public API attached to this widget instance, allowing you\nAjax-like notification of updates."}}},"plugins":{"consoleMessages":{},"dojo":{},"idle":{},"mouseClick":{},"mouseOver":{},"window":{}}},"!doc":"DojoX: the home for Dojo eXtensions","_reqSeqId":{"!type":"number"},"atom":{"io":{"Connection":{"!type":"fn()","prototype":{"!doc":"This object implements a transport layer for working with ATOM feeds and ATOM publishing protocols.","preventCache":{"!type":"bool"},"alertsEnabled":{"!type":"bool"},"constructor":{"!type":"fn(sync: bool, preventCache: bool)","!doc":"initializer"},"getFeed":{"!type":"fn(url: string, callback: fn(), errorCallback: fn(), scope: ?)","!doc":"Function to obtain a s specific ATOM feed from a given ATOM Feed url."},"getService":{"!type":"fn(url: string, callback: fn(), errorCallback: ?, scope: ?)","!doc":"Function to retrieve an introspection document from the given URL."},"getEntry":{"!type":"fn(url: string, callback: fn(), errorCallback: ?, scope: ?)","!doc":"Function to retrieve a single entry from an ATOM feed from the given URL."},"_getXmlDoc":{"!type":"fn(url: string, nodeName: ?, newNode: ?, namespace: ?, callback: fn(), errorCallback: ?, scope: ?)","!doc":"Internal Function to retrieve an XML document and pass the results to a callback."},"updateEntry":{"!type":"fn(entry: ?, callback: fn(), errorCallback: ?, retrieveUpdated: bool, xmethod: bool, scope: ?)","!doc":"Function to update a specific ATOM entry by putting the new changes via APP."},"addEntry":{"!type":"fn(entry: ?, url: ?, callback: fn(), errorCallback: ?, retrieveEntry: bool, scope: ?)","!doc":"Function to add a new ATOM entry by posting the new entry via APP."},"deleteEntry":{"!type":"fn(entry: ?, callback: fn(), errorCallback: ?, xmethod: ?, scope: ?)","!doc":"Function to delete a specific ATOM entry via APP."}}},"model":{"Node":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(name_space: ?, name: ?, attributes: ?, content: ?, shortNs: ?)"},"buildFromDom":{"!type":"fn(node: ?)"},"_saveAttributes":{"!type":"fn(node: ?)"},"addAttribute":{"!type":"fn(name: ?, value: ?)"},"getAttribute":{"!type":"fn(name: ?)"},"_getAttributeNames":{"!type":"fn(node: ?)"},"toString":{"!type":"fn()"},"addContent":{"!type":"fn(content: ?)"}}},"AtomItem":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.Node.prototype","!doc":"Class container for generic Atom items.","_accepts":{},"constructor":{"!type":"fn(args: ?)"},"_getAttributeNames":{"!type":"fn()"},"accept":{"!type":"fn(tag: ?)"},"_postBuild":{"!type":"fn()"},"buildFromDom":{"!type":"fn(node: ?)"},"addNamespace":{"!type":"fn(fullName: ?, shortName: ?)"},"addAuthor":{"!type":"fn(name: string, email: string, uri: string)","!doc":"Function to add in an author to the list of authors."},"addContributor":{"!type":"fn(name: string, email: string, uri: string)","!doc":"Function to add in an author to the list of authors."},"addLink":{"!type":"fn(href: string, rel: string, hrefLang: string, title: string, type: string)","!doc":"Function to add in a link to the list of links."},"removeLink":{"!type":"fn(href: string, rel: string)","!doc":"Function to remove a link from the list of links."},"removeBasicLinks":{"!type":"fn()","!doc":"Function to remove all basic links from the list of links."},"addCategory":{"!type":"fn(scheme: string, term: string, label: string)","!doc":"Function to add in a category to the list of categories."},"getCategories":{"!type":"fn(scheme: string)","!doc":"Function to get all categories that match a particular scheme."},"removeCategories":{"!type":"fn(scheme: string, term: string)","!doc":"Function to remove all categories that match a particular scheme and term."},"setTitle":{"!type":"fn(str: string, type: string)","!doc":"Function to set the title of the item."},"addExtension":{"!type":"fn(name_space: string, name: string, attributes: [], content: string, shortNS: string)","!doc":"Function to add in an extension namespace into the item."},"getExtensions":{"!type":"fn(name_space: string, name: string)","!doc":"Function to get extensions that match a namespace and name."},"removeExtensions":{"!type":"fn(name_space: string, name: string)","!doc":"Function to remove extensions that match a namespace and name."},"destroy":{"!type":"fn()"}}},"Category":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.Node.prototype","!doc":"Class container for 'Category' types.","constructor":{"!type":"fn(scheme: string, term: string, label: string)"},"_postBuild":{"!type":"fn()"},"_getAttributeNames":{"!type":"fn()"},"toString":{"!type":"fn()","!doc":"Function to construct string form of the category tag, which is an XML structure."},"buildFromDom":{"!type":"fn(node: +DOM)","!doc":"Function to do construction of the Category data from the DOM node containing it."}}},"Content":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.Node.prototype","!doc":"Class container for 'Content' types. Such as summary, content, username, and so on types of data.","constructor":{"!type":"fn(tagName: ?, value: ?, src: ?, type: ?, xmlLang: ?)"},"_getAttributeNames":{"!type":"fn()"},"_postBuild":{"!type":"fn()"},"buildFromDom":{"!type":"fn(node: +DOM)","!doc":"Function to do construction of the Content data from the DOM node containing it."},"toString":{"!type":"fn()","!doc":"Function to construct string form of the content tag, which is an XML structure."}}},"Link":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.Node.prototype","!doc":"Class container for 'link' types.","constructor":{"!type":"fn(href: ?, rel: ?, hrefLang: ?, title: ?, type: ?)"},"_getAttributeNames":{"!type":"fn()"},"_postBuild":{"!type":"fn()"},"buildFromDom":{"!type":"fn(node: +The)","!doc":"Function to do construction of the link data from the DOM node containing it."},"toString":{"!type":"fn()","!doc":"Function to construct string form of the link tag, which is an XML structure."}}},"Person":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.Node.prototype","!doc":"Class container for 'person' types, such as Author, controbutors, and so on.","constructor":{"!type":"fn(personType: ?, name: ?, email: ?, uri: ?)"},"_getAttributeNames":{"!type":"fn()"},"_postBuild":{"!type":"fn()"},"accept":{"!type":"fn(tag: ?)"},"buildFromDom":{"!type":"fn(node: +The)","!doc":"Function to do construction of the person data from the DOM node containing it."},"toString":{"!type":"fn()","!doc":"Function to construct string form of the Person tag, which is an XML structure."}},"_accepts":{"name":{"!type":"bool"},"uri":{"!type":"bool"},"email":{"!type":"bool"}}},"Generator":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.Node.prototype","!doc":"Class container for 'Generator' types.","constructor":{"!type":"fn(uri: string, version: string, value: string)"},"_postBuild":{"!type":"fn()"},"buildFromDom":{"!type":"fn(node: +The)","!doc":"Function to do construction of the generator data from the DOM node containing it."},"toString":{"!type":"fn()","!doc":"Function to construct string form of the Generator tag, which is an XML structure."}}},"Entry":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.AtomItem.prototype","!doc":"Class container for 'Entry' types.","constructor":{"!type":"fn(id: string)"},"_getAttributeNames":{"!type":"fn()"},"toString":{"!type":"fn(amPrimary: ?) -> string","!doc":"Function to construct string form of the entry tag, which is an XML structure."},"getEditHref":{"!type":"fn() -> string","!doc":"Function to get the href that allows editing of this feed entry."},"setEditHref":{"!type":"fn(url: ?)"}},"_accepts":{"author":{"!type":"bool"},"content":{"!type":"bool"},"category":{"!type":"bool"},"contributor":{"!type":"bool"},"created":{"!type":"bool"},"id":{"!type":"bool"},"link":{"!type":"bool"},"published":{"!type":"bool"},"rights":{"!type":"bool"},"summary":{"!type":"bool"},"title":{"!type":"bool"},"updated":{"!type":"bool"},"xmlbase":{"!type":"bool"},"issued":{"!type":"bool"},"modified":{"!type":"bool"}}},"Feed":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.AtomItem.prototype","!doc":"Class container for 'Feed' types.","addEntry":{"!type":"fn(entry: ?)","!doc":"Function to add an entry to this feed."},"getFirstEntry":{"!type":"fn() -> ?","!doc":"Function to get the first entry of the feed."},"getEntry":{"!type":"fn(entryId: string)","!doc":"Function to get an entry by its id."},"removeEntry":{"!type":"fn(entry: ?)","!doc":"Function to remove an entry from the list of links."},"setEntries":{"!type":"fn(arrayOfEntry: [])","!doc":"Function to add a set of entries to the feed."},"toString":{"!type":"fn()","!doc":"Function to construct string form of the feed tag, which is an XML structure."},"createEntry":{"!type":"fn() -> ?","!doc":"Function to Create a new entry object in the feed."},"getSelfHref":{"!type":"fn() -> string","!doc":"Function to get the href that refers to this feed."}},"_accepts":{"author":{"!type":"bool"},"content":{"!type":"bool"},"category":{"!type":"bool"},"contributor":{"!type":"bool"},"created":{"!type":"bool"},"id":{"!type":"bool"},"link":{"!type":"bool"},"published":{"!type":"bool"},"rights":{"!type":"bool"},"summary":{"!type":"bool"},"title":{"!type":"bool"},"updated":{"!type":"bool"},"xmlbase":{"!type":"bool"},"entry":{"!type":"bool"},"logo":{"!type":"bool"},"issued":{"!type":"bool"},"modified":{"!type":"bool"},"icon":{"!type":"bool"},"subtitle":{"!type":"bool"}}},"Service":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.AtomItem.prototype","!doc":"Class container for 'Feed' types.","constructor":{"!type":"fn(href: ?)"},"buildFromDom":{"!type":"fn(node: +DOM)","!doc":"Function to do construction of the Service data from the DOM node containing it."},"getCollection":{"!type":"fn(url: string)","!doc":"Function to collections that match a specific url."}}},"Workspace":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.AtomItem.prototype","!doc":"Class container for 'Workspace' types.","constructor":{"!type":"fn(title: ?)"},"buildFromDom":{"!type":"fn(node: +DOM)","!doc":"Function to do construction of the Workspace data from the DOM node containing it."}}},"Collection":{"!type":"fn()","prototype":{"!proto":"dojox.atom.io.model.AtomItem.prototype","!doc":"Class container for 'Collection' types.","constructor":{"!type":"fn(href: ?, title: ?)"},"buildFromDom":{"!type":"fn(node: +DOM)","!doc":"Function to do construction of the Collection data from the DOM node containing it."}}},"_Constants":{"!doc":"Container for general constants.","ATOM_URI":{"!type":"string"},"ATOM_NS":{"!type":"string"},"PURL_NS":{"!type":"string"},"APP_NS":{"!type":"string"}},"_actions":{"!doc":"Container for tag handling functions.","link":{"!type":"fn(obj: ?, node: ?)"},"author":{"!type":"fn(obj: ?, node: ?)"},"contributor":{"!type":"fn(obj: ?, node: ?)"},"category":{"!type":"fn(obj: ?, node: ?)"},"icon":{"!type":"fn(obj: ?, node: ?)"},"id":{"!type":"fn(obj: ?, node: ?)"},"rights":{"!type":"fn(obj: ?, node: ?)"},"subtitle":{"!type":"fn(obj: ?, node: ?)"},"title":{"!type":"fn(obj: ?, node: ?)"},"updated":{"!type":"fn(obj: ?, node: ?)"},"issued":{"!type":"fn(obj: ?, node: ?)"},"modified":{"!type":"fn(obj: ?, node: ?)"},"published":{"!type":"fn(obj: ?, node: ?)"},"entry":{"!type":"fn(obj: ?, node: ?)"},"content":{"!type":"fn(obj: ?, node: ?)"},"summary":{"!type":"fn(obj: ?, node: ?)"},"name":{"!type":"fn(obj: ?, node: ?)"},"email":{"!type":"fn(obj: ?, node: ?)"},"uri":{"!type":"fn(obj: ?, node: ?)"},"generator":{"!type":"fn(obj: ?, node: ?)"}},"util":{"createDate":{"!type":"fn(node: +DOM)","!doc":"Utility function to create a date from a DOM node's text content."},"escapeHtml":{"!type":"fn(str: string)","!doc":"Utility function to escape XML special characters in an HTML string."},"unEscapeHtml":{"!type":"fn(str: string)","!doc":"Utility function to un-escape XML special characters in an HTML string."},"getNodename":{"!type":"fn(node: +DOM)","!doc":"Utility function to get a node name and deal with IE's bad handling of namespaces\non tag names."}}}},"widget":{"FeedEntryEditor":{"!type":"fn()","prototype":{"!proto":"dojox.atom.widget.FeedEntryViewer.prototype","!doc":"An ATOM feed entry editor that allows viewing of the individual attributes of an entry.","_contentEditor":{},"_oldContent":{},"_setObject":{},"enableEdit":{"!type":"bool"},"_contentEditorCreator":{},"_editors":{},"entryNewButton":{},"_editable":{"!type":"bool"},"templatePath":{},"postCreate":{"!type":"fn()"},"setEntry":{"!type":"fn(entry: ?, feed: ?, leaveMenuState: bool)","!doc":"Function to set the current entry that is being edited."},"_toggleEdit":{"!type":"fn()","!doc":"Internal function for toggling/enabling the display of edit mode"},"_handleEvent":{"!type":"fn(entrySelectionEvent: ?)","!doc":"Internal function for listening to a topic that will handle entry notification."},"_isEditable":{"!type":"fn(entry: ?)","!doc":"Internal function for determining of a particular entry is editable."},"setTitle":{"!type":"fn(titleAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the title node in the template to some value from the entry."},"setAuthors":{"!type":"fn(authorsAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the author node in the template to some value from the entry."},"setContributors":{"!type":"fn(contributorsAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the contributor node in the template to some value from the entry."},"setId":{"!type":"fn(idAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the ID  node in the template to some value from the entry."},"setUpdated":{"!type":"fn(updatedAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the updated  node in the template to some value from the entry."},"setSummary":{"!type":"fn(summaryAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the summary  node in the template to some value from the entry."},"setContent":{"!type":"fn(contentAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the content node in the template to some value from the entry."},"_createEditor":{"!type":"fn(anchorNode: +DOM, node: +DOM, multiline: bool, rte: ?)","!doc":"Function to create an appropriate text editor widget based on the given parameters."},"_switchEditor":{"!type":"fn(event: ?)","!doc":"Function to switch between editor types."},"_createPeopleEditor":{"!type":"fn(anchorNode: +DOM, node: +DOM)","!doc":"Creates a People Editor widget and returns it."},"saveEdits":{"!type":"fn()","!doc":"Saves edits submitted when the 'save' button is pressed."},"_handleSave":{"!type":"fn(entry: ?, location: string)","!doc":"Function for handling the save of an entry, cleaning up the display after the edit is completed."},"cancelEdits":{"!type":"fn()","!doc":"Cancels edits and reverts the editor to its previous state (display mode)"},"clear":{"!type":"fn()","!doc":"Clears the editor, destorys all editors, leaving the editor completely clear"},"clearEditors":{"!type":"fn()"},"_enforceXhtml":{"!type":"fn(html: string)","!doc":"Function for cleaning up/enforcing the XHTML standard in HTML returned from the editor2 widget."},"_closeTag":{"!type":"fn(xhtml: string, tag: string)","!doc":"Function for closing tags in a text of HTML/XHTML"},"_toggleNew":{"!type":"fn()","!doc":"Function to put the editor into a state to create a new entry."},"_displaySections":{"!type":"fn()","!doc":"Function to display the appropriate sections based on validity."}}},"PeopleEditor":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"An editor for dojox.atom.io.model.Person objects.","templatePath":{},"_rows":{"!type":"[]"},"_editors":{"!type":"[]"},"_index":{"!type":"number"},"_numRows":{"!type":"number"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"_createEditors":{"!type":"fn(name: string, email: string, uri: string, index: number, widgetName: string)","!doc":"creates editor boxes (textbox widgets) for the individual values of a Person."},"_createEditor":{"!type":"fn(value: string, id: string, name: string, labelNode: +DOM, node: +DOM)","!doc":"Creates an individual editor widget (textbox) for a value."},"_removeEditor":{"!type":"fn(event: ?)","!doc":"Removes a Person from our list of editors."},"_add":{"!type":"fn()","!doc":"Adds a new block of blank editors to represent a Person."},"getValues":{"!type":"fn()","!doc":"Gets the values of this editor in an array."}}},"FeedEntryViewer":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"An ATOM feed entry editor for publishing updated ATOM entries, or viewing non-editable entries.","entrySelectionTopic":{"!type":"string"},"_validEntryFields":{},"displayEntrySections":{"!type":"string"},"_displayEntrySections":{},"enableMenu":{"!type":"bool"},"enableMenuFade":{"!type":"bool"},"_optionButtonDisplayed":{"!type":"bool"},"templatePath":{},"_entry":{},"_feed":{},"_editMode":{"!type":"bool"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"clear":{"!type":"fn()","!doc":"Function to clear the state of the widget."},"clearNodes":{"!type":"fn()","!doc":"Function to clear all the display nodes for the ATOM entry from the viewer."},"setEntry":{"!type":"fn(entry: ?, feed: ?, leaveMenuState: bool)","!doc":"Function to set the current entry that is being edited."},"setTitleHeader":{"!type":"fn(titleHeaderNode: +DOM, entry: ?)","!doc":"Function to set the contents of the title header node in the template to some value."},"setTitle":{"!type":"fn(titleAnchorNode: ?, editMode: bool, entry: +The)","!doc":"Function to set the contents of the title node in the template to some value from the entry."},"setAuthorsHeader":{"!type":"fn(authorHeaderNode: +DOM, entry: ?)","!doc":"Function to set the title format for the authors section of the author row in the template to some value from the entry."},"setAuthors":{"!type":"fn(authorsAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the author node in the template to some value from the entry."},"setContributorsHeader":{"!type":"fn(contributorsHeaderNode: +DOM, entry: ?)","!doc":"Function to set the contents of the contributor header node in the template to some value from the entry."},"setContributors":{"!type":"fn(contributorsAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the contributor node in the template to some value from the entry."},"setIdHeader":{"!type":"fn(idHeaderNode: +DOM, entry: ?)","!doc":"Function to set the contents of the ID  node in the template to some value from the entry."},"setId":{"!type":"fn(idAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the ID  node in the template to some value from the entry."},"setUpdatedHeader":{"!type":"fn(updatedHeaderNode: +DOM, entry: ?)","!doc":"Function to set the contents of the updated header node in the template to some value from the entry."},"setUpdated":{"!type":"fn(updatedAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the updated  node in the template to some value from the entry."},"setSummaryHeader":{"!type":"fn(summaryHeaderNode: +DOM, entry: ?)","!doc":"Function to set the contents of the summary  node in the template to some value from the entry."},"setSummary":{"!type":"fn(summaryAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the summary  node in the template to some value from the entry."},"setContentHeader":{"!type":"fn(contentHeaderNode: +DOM, entry: ?)","!doc":"Function to set the contents of the content node in the template to some value from the entry."},"setContent":{"!type":"fn(contentAnchorNode: +DOM, editMode: bool, entry: ?)","!doc":"Function to set the contents of the content node in the template to some value from the entry."},"_displaySections":{"!type":"fn()","!doc":"Internal function for determining which sections of the view to actually display."},"setDisplaySections":{"!type":"fn(sectionsArray: [])","!doc":"Function for setting which sections of the entry should be displayed."},"_setDisplaySectionsCheckboxes":{"!type":"fn()","!doc":"Internal function for setting which checkboxes on the display are selected."},"_readDisplaySections":{"!type":"fn()","!doc":"Internal function for reading what is currently checked for display and generating the display list from it."},"_toggleCheckbox":{"!type":"fn(checkBox: ?)","!doc":"Internal function for determining of a particular entry is editable."},"_toggleOptions":{"!type":"fn(checkBox: ?)","!doc":"Internal function for determining of a particular entry is editable."},"_handleEvent":{"!type":"fn(entrySelectionEvent: ?)","!doc":"Internal function for listening to a topic that will handle entry notification."},"setFieldValidity":{"!type":"fn(field: string, isValid: bool)","!doc":"Function to set whether a field in the view is valid and displayable."},"isFieldValid":{"!type":"fn(field: string)","!doc":"Function to return if a displayable field is valid or not"},"getEntry":{"!type":"fn()"},"getFeed":{"!type":"fn()"},"destroy":{"!type":"fn()"}}},"EntryHeader":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Widget representing a header in a FeedEntryViewer/Editor","title":{"!type":"string"},"templatePath":{},"postCreate":{"!type":"fn()"},"setListHeader":{"!type":"fn(title: string)"},"clear":{"!type":"fn()"},"destroy":{"!type":"fn()"}}},"FeedViewer":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"An ATOM feed viewer that allows for viewing a feed, deleting entries, and editing entries.","feedViewerTableBody":{},"feedViewerTable":{},"entrySelectionTopic":{"!type":"string"},"url":{"!type":"string"},"xmethod":{"!type":"bool"},"localSaveOnly":{"!type":"bool"},"templatePath":{},"_feed":{},"_currentSelection":{},"_includeFilters":{},"alertsEnabled":{"!type":"bool"},"postCreate":{"!type":"fn()","!doc":"The postCreate function."},"startup":{"!type":"fn()","!doc":"The startup function."},"clear":{"!type":"fn()","!doc":"Function clearing all current entries in the feed view."},"setFeedFromUrl":{"!type":"fn(url: string)","!doc":"Function setting the feed from a URL which to get the feed."},"setFeed":{"!type":"fn(feed: ?)","!doc":"Function setting the dojox.atom.io.model.Feed data into the view."},"_displayDateForEntry":{"!type":"fn(entry: ?)","!doc":"Internal function for determining the appropriate date to display."},"appendGrouping":{"!type":"fn(titleText: string)","!doc":"Function for appending a new grouping of entries to the feed view."},"appendEntry":{"!type":"fn(entry: ?)","!doc":"Function for appending an entry to the feed view."},"deleteEntry":{"!type":"fn(entryRow: ?)","!doc":"Function for deleting a row from the view"},"_removeEntry":{"!type":"fn(entry: +FeedViewerEntry, success: bool)","!doc":"callback for when an entry is deleted from a feed."},"_rowSelected":{"!type":"fn(evt: ?)","!doc":"Internal function for handling the selection of feed entries."},"_deselectCurrentSelection":{"!type":"fn()","!doc":"Internal function for unselecting the current selection."},"_isEditable":{"!type":"fn(entry: ?)","!doc":"Internal function for determining of a particular entry is editable."},"onEntrySelected":{"!type":"fn(entry: ?)","!doc":"Function intended for over-riding/replacement as an attachpoint to for other items to recieve\nselection notification."},"_isRelativeURL":{"!type":"fn(url: string)","!doc":"Method to determine if the URL is relative or absolute."},"_calculateBaseURL":{"!type":"fn(fullURL: string, currentPageRelative: bool)","!doc":"Internal function to calculate a baseline URL from the provided full URL."},"_isFilterAccepted":{"!type":"fn(entry: ?)","!doc":"Internal function to do matching of category filters to widgets."},"addCategoryIncludeFilter":{"!type":"fn(filter: ?)","!doc":"Function to add a filter for entry inclusion in the feed view."},"removeCategoryIncludeFilter":{"!type":"fn(filter: ?)","!doc":"Function to remove a filter for entry inclusion in the feed view."},"_handleEvent":{"!type":"fn(entrySelectionEvent: ?)","!doc":"Internal function for listening to a topic that will handle entry notification."},"_addEntry":{"!type":"fn(entry: ?)","!doc":"callback function used when adding an entry to the feed."},"destroy":{"!type":"fn()","!doc":"Destroys this widget, including all descendants and subscriptions."}},"CategoryIncludeFilter":{"!type":"fn()","prototype":{"!doc":"The initializer function.","constructor":{"!type":"fn(scheme: ?, term: ?, label: ?)","!doc":"The initializer function."},"match":{"!type":"fn(entry: ?)","!doc":"Function to determine if this category filter matches against a category on an atom entry"}}}},"FeedViewerEntry":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Widget for handling the display of an entry and specific events associated with it.","templatePath":{},"entryNode":{},"timeNode":{},"deleteButton":{},"entry":{},"feed":{},"postCreate":{"!type":"fn()"},"setTitle":{"!type":"fn(text: string)","!doc":"Function to set the title of the entry."},"setTime":{"!type":"fn(timeText: string)","!doc":"Function to set the time of the entry."},"enableDelete":{"!type":"fn()","!doc":"Function to enable the delete action on this entry."},"disableDelete":{"!type":"fn()","!doc":"Function to disable the delete action on this entry."},"deleteEntry":{"!type":"fn(event: ?)","!doc":"Function to handle the delete event and delete the entry."},"onClick":{"!type":"fn(e: ?)","!doc":"Attach point for when a row is clicked on."}}},"FeedViewerGrouping":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Grouping of feed entries.","templatePath":{},"groupingNode":{},"titleNode":{},"setText":{"!type":"fn(text: +The)","!doc":"Sets the text to be shown above this grouping."}}},"AtomEntryCategoryFilter":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A filter to be applied to the list of entries.","scheme":{"!type":"string"},"term":{"!type":"string"},"label":{"!type":"string"},"isFilter":{"!type":"bool"}}}}},"av":{"FLAudio":{"!type":"fn()","prototype":{"!doc":"Play MP3 files through the Flash SWF built in the\nDEFT project.","id":{"!doc":"The id of this widget and the id of the SWF movie.","!type":"string"},"initialVolume":{"!doc":"From 0-1\nSets volume for all files unless changed with doPlay\nor setVolume","!type":"number"},"initialPan":{"!doc":"From -1 to 1 (-1 is left, 1 is right, 0 is middle)\nSets pan for all files unless changed with play\nor setPan\n\n\n\nautoPlay: Boolean\nIf true, all files will play upon load. If false,\nthey load and wait for doPlay() command.","!type":"number"},"isDebug":{"!doc":"Setting to true tells the SWF to output log messages to Firebug.","!type":"bool"},"statusInterval":{"!doc":"How often in milliseconds that the status of the\nplayer is checked - both load and play","!type":"number"},"_swfPath":{"!doc":"The path to the video player SWF resource","!type":"+Uri"},"constructor":{"!type":"fn(options: ?)"},"init":{"!type":"fn()","!doc":"Initialize the media."},"load":{"!type":"fn(options: ?) -> string","!doc":"Adds a media object to the playlist\nThis can be called repeatedly to add multiple items."},"doPlay":{"!type":"fn(options: ?)","!doc":"Tell media to play, based on\nthe options passed."},"pause":{"!type":"fn(options: ?)","!doc":"Tell media to pause, based on identifier in\nthe options passed."},"stop":{"!type":"fn(options: ?)","!doc":"Tell media to stop, based on identifier in\nthe options passed."},"setVolume":{"!type":"fn(options: ?)","!doc":"Set media volume, based on identifier in\nthe options passed."},"setPan":{"!type":"fn(options: ?)","!doc":"Set media pan, based on identifier in\nthe options passed."},"getVolume":{"!type":"fn(options: ?)","!doc":"Get media volume, based on identifier in\nthe options passed."},"getPan":{"!type":"fn(options: ?)","!doc":"Set media pan, based on identifier in\nthe options passed."},"onError":{"!type":"fn(msg: ?)","!doc":"stub fired when an error occurs"},"onLoadStatus":{"!type":"fn(events: [])"},"onAllLoaded":{"!type":"fn()","!doc":"stub fired"},"onPlayStatus":{"!type":"fn(events: [])"},"onLoad":{"!type":"fn()","!doc":"stub fired when SWF is ready"},"onID3":{"!type":"fn(evt: ?)","!doc":"Fired when the ID3 data is received."},"destroy":{"!type":"fn()","!doc":"destroys flash"},"_sub":{"!type":"fn(topic: ?, method: ?)","!doc":"helper for subscribing to topics"},"_normalizeVolume":{"!type":"fn(vol: ?)","!doc":"Ensures volume is less than one"},"_normalizeUrl":{"!type":"fn(_url: ?)","!doc":"Checks that path is relative to HTML file or\nconvertes it to an absolute path."}}},"FLVideo":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Inserts a Flash FLV video into the HTML page and provides methods\nand events for controlling the video. Also plays the H264/M4V codec\nwith a little trickery: change the '.M4V' extension to '.flv'.","_swfPath":{"!doc":"The path to the video player SWF resource","!type":"+Uri"},"postCreate":{"!type":"fn()","!doc":"Initialize the media."},"play":{"!type":"fn(newUrl?: string)","!doc":"Plays the video. If an url is passed in, plays the new link."},"pause":{"!type":"fn()","!doc":"Pauses the video"},"seek":{"!type":"fn(time: +Float)","!doc":"Goes to the time passed in the argument"},"volume":{"!type":"fn(vol: +Float) -> +Float","!doc":"Sets the volume of the video to the time in the\nargument - between 0 - 1."},"onLoad":{"!type":"fn(mov: ?)","!doc":"Fired when the SWF player has loaded\nNOT when the video has loaded"},"onDownloaded":{"!type":"fn(percent: ?)","!doc":"Fires the amount of that the media has been\ndownloaded. Number, 0-100"},"onClick":{"!type":"fn(evt: ?)","!doc":"Fires when the player is clicked\nCould be used to toggle play/pause, or\ndo an external activity, like opening a new\nwindow."},"onSwfSized":{"!type":"fn(data: ?)","!doc":"Fired on SWF resize, or when its\ntoggled between fullscreen."},"onMetaData":{"!type":"fn(data: ?, evt: ?)","!doc":"The video properties. Width, height, duration, etc.\nNOTE: \tif data is empty, this is an older FLV with no meta data.\nDuration cannot be determined. In original FLVs, duration\ncould only be obtained with Flash Media Server.\nNOTE: \tOlder FLVs can still return width and height\nand will do so on a second event call"},"onPosition":{"!type":"fn(time: ?)","!doc":"The position of the playhead in seconds"},"onStart":{"!type":"fn(data: ?)","!doc":"Fires when video starts\nGood for setting the play button to pause\nduring an autoPlay for example"},"onPlay":{"!type":"fn(data: ?)","!doc":"Fires when video starts and resumes"},"onPause":{"!type":"fn(data: ?)","!doc":"Fires when the pause button is clicked"},"onEnd":{"!type":"fn(data: ?)","!doc":"Fires when video ends\nCould be used to change pause button to play\nor show a post video graphic, like YouTube"},"onStop":{"!type":"fn()","!doc":"Fire when the Stop button is clicked\nTODO: \tThis is not hooked up yet and shouldn't\nfire."},"onBuffer":{"!type":"fn(isBuffering: ?)","!doc":"Fires a boolean to tell if media\nis paused for buffering or if buffering\nhas finished"},"onError":{"!type":"fn(data: ?, url: ?)","!doc":"Fired when the player encounters an error"},"onStatus":{"!type":"fn(data: ?)","!doc":"Simple status"},"onPlayerStatus":{"!type":"fn(data: ?)","!doc":"The status of the video from the SWF\nplaying, stopped, bufering, etc."},"onResize":{"!type":"fn()","!doc":"Fired on page resize"},"_checkBuffer":{"!type":"fn(time: +Float, bufferLength: +Float)","!doc":"Checks that there is a proper buffer time between\ncurrent playhead time and the amount of data loaded.\nWorks only on FLVs with a duration (not older). Pauses\nthe video while continuing download."},"_update":{"!type":"fn()","!doc":"Helper function to fire onPosition, check download progress,\nand check buffer."}}},"_Media":{"!type":"fn()","prototype":{"!doc":"Used as a mixin for dojox and AIR media","mediaUrl":{"!type":"string"},"initialVolume":{"!doc":"The initial volume setting of the player. Acccepts between 0 and 1.","!type":"+Float"},"autoPlay":{"!doc":"Whether the video automatically plays on load or not.","!type":"bool"},"bufferTime":{"!doc":"Time in milliseconds that the video should be loaded before it will\nplay. May pause and resume to build up buffer. Prevents stuttering.\nNote:\nOlder FLVs, without a duration, cannot be buffered.","!type":"number"},"minBufferTime":{"!doc":"Time in milliseconds bwteen the playhead time and loaded time that\nwill trigger the buffer. When buffer is triggered, video will pause\nuntil the bufferTime amount is buffered.\nNote: Should be a small number, greater than zero.","!type":"number"},"updateTime":{"!doc":"How often, in milliseconds to get an update of the video position.","!type":"number"},"id":{"!doc":"The id of this widget and the id of the SWF movie.","!type":"string"},"isDebug":{"!doc":"Setting to true tells the SWF to output log messages to Firebug.","!type":"bool"},"percentDownloaded":{"!doc":"The percentage the media has downloaded; from 0-100","!type":"?"},"_flashObject":{"!doc":"The dojox.embed object","!type":"?"},"flashMedia":{"!doc":"The SWF object. Methods are passed to this.","!type":"?"},"_initStatus":{"!type":"fn()","!doc":"Connect mediaStatus to the media."},"getTime":{"!type":"fn() -> +Float","!doc":"Returns the current time of the video\nNote:\nConsider the onPosition event, which returns\nthe time at a set interval. Too many trips to\nthe SWF could impact performance."},"onLoad":{"!type":"fn(mov: +SWF)","!doc":"Fired when the SWF player has loaded\nNOT when the video has loaded"},"onDownloaded":{"!type":"fn(percent: number)","!doc":"Fires the amount of that the media has been\ndownloaded. Number, 0-100"},"onClick":{"!type":"fn(evt: ?)","!doc":"TODO: Return x/y of click\nFires when the player is clicked\nCould be used to toggle play/pause, or\ndo an external activity, like opening a new\nwindow."},"onSwfSized":{"!type":"fn(data: ?)","!doc":"Fired on SWF resize, or when its\ntoggled between fullscreen."},"onMetaData":{"!type":"fn(data: ?, evt: ?)","!doc":"The video properties. Width, height, duration, etc.\nNOTE: \tif data is empty, this is an older FLV with no meta data.\nDuration cannot be determined. In original FLVs, duration\ncould only be obtained with Flash Media Server.\nNOTE: \tOlder FLVs can still return width and height\nand will do so on a second event call"},"onPosition":{"!type":"fn(time: +Float)","!doc":"The position of the playhead in seconds"},"onStart":{"!type":"fn(data: ?)","!doc":"Fires when video starts\nGood for setting the play button to pause\nduring an autoPlay for example"},"onPlay":{"!type":"fn(data: ?)","!doc":"Fires when video starts and resumes"},"onPause":{"!type":"fn(data: ?)","!doc":"Fires when the pause button is clicked"},"onEnd":{"!type":"fn(data: ?)","!doc":"Fires when video ends\nCould be used to change pause button to play\nor show a post video graphic, like YouTube"},"onStop":{"!type":"fn()","!doc":"Fire when the Stop button is clicked\nTODO: \tThis is not hooked up yet and shouldn't\nfire."},"onBuffer":{"!type":"fn(isBuffering: bool)","!doc":"Fires a boolean to tell if media\nis paused for buffering or if buffering\nhas finished"},"onError":{"!type":"fn(data: ?, url: string)","!doc":"Fired when the player encounters an error"},"onStatus":{"!type":"fn(data: ?)","!doc":"Simple status"},"onPlayerStatus":{"!type":"fn(data: ?)","!doc":"The status of the video from the SWF\nplaying, stopped, bufering, etc."},"onResize":{"!type":"fn()"},"_figureStatus":{"!type":"fn()","!doc":"Calculate media status, based on playhead movement, and\nonStop and onStart events\nTODO:\nFigure in real status from the media for more accurate results."},"_eventFactory":{"!type":"fn() -> ?","!doc":"Creates a generic event object."},"_sub":{"!type":"fn(topic: ?, method: ?)","!doc":"helper for subscribing to topics"},"_normalizeVolume":{"!type":"fn(vol: ?)","!doc":"Ensures volume is less than one"},"_normalizeUrl":{"!type":"fn(_url: ?)","!doc":"Checks that path is relative to HTML file or\nconvertes it to an absolute path."},"destroy":{"!type":"fn()","!doc":"destroys flash"}}},"widget":{"PlayButton":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A Play/Pause button widget to use with dojox.av.widget.Player","templatePath":{},"postCreate":{"!type":"fn()","!doc":"Intialize button."},"setMedia":{"!type":"fn(med: ?)","!doc":"A common method to set the media in all Player widgets.\nMay do connections and initializations."},"onClick":{"!type":"fn()","!doc":"Fired on play or pause click."},"onPlay":{"!type":"fn()","!doc":"Fired on play click."},"onPause":{"!type":"fn()","!doc":"Fired on pause click."},"showPlay":{"!type":"fn()","!doc":"Toggles the pause button invisible and the play\nbutton visible.."},"showPause":{"!type":"fn()","!doc":"Toggles the play button invisible and the pause\nbutton visible."}}},"Player":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A Media Player UI widget for all types of dojox.av and AIR media.","playerWidth":{"!doc":"or String\nSets the width of the player (not the video size)\nNumber will be converted to pixels\nString will be used literally. EX: &quot;320px&quot; or &quot;100%&quot;\n\n\n\nTODO:\nplayerHeight\nvideoWidth: 320,\nvideoHeight: 240,","!type":"number"},"widgetsInTemplate":{"!type":"bool"},"templatePath":{},"_fillContent":{"!type":"fn()"},"postCreate":{"!type":"fn()","!doc":"Do player styling, and place child widgets in the proper location."},"startup":{"!type":"fn()","!doc":"Fired when all children are ready. Set the media in\nall children with setMedia()"},"onResize":{"!type":"fn(evt: ?)","!doc":"If a player size is a percentage, this will fire an onResize\nevent for all children, passing the size of the player."}}},"ProgressSlider":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A custom slider widget to use with dojox.av.widget.Player.","templatePath":{},"postCreate":{"!type":"fn()","!doc":"Initialize slider."},"setMedia":{"!type":"fn(med: ?, playerWidget: ?)","!doc":"A common method to set the media in all Player widgets.\nMay do connections and initializations."},"onDrag":{"!type":"fn(evt: +HTMLEvent)","!doc":"Fired when the mouse is moved. Sets the slider."},"startDrag":{"!type":"fn()","!doc":"Fired onmousedown of the slider handle."},"endDrag":{"!type":"fn()","!doc":"Fired on document.onmouseup."},"setHandle":{"!type":"fn(time: ?)","!doc":"Sets the slider handle (when it is not being dragged)"},"setLoadedPosition":{"!type":"fn(decimal: ?)","!doc":"Sets the download progress bar to the percentage of how much\nthe media has been downloaded."},"handleOver":{"!type":"fn()","!doc":"Highlights the slider handle on mouseover, and\nstays highlighted during drag."},"handleOut":{"!type":"fn()","!doc":"Unhighlights handle onmouseover, or on endDrag."},"onResize":{"!type":"fn(playerDimensions: ?)","!doc":"Handles player resize. Need to recalculate the width of\nposition an download bars."}}},"Status":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A Status widget to use with dojox.av.widget.Player","templatePath":{},"postCreate":{"!type":"fn()"},"setMedia":{"!type":"fn(med: ?)","!doc":"A common method to set the media in all Player widgets.\nMay do connections and initializations."},"onMetaData":{"!type":"fn(data: ?)"},"onBuffer":{"!type":"fn(isBuffering: ?)"},"onPosition":{"!type":"fn(time: ?)"},"onStart":{"!type":"fn()"},"onPlay":{"!type":"fn()"},"onPause":{"!type":"fn()"},"onStop":{"!type":"fn()"},"onEnd":{"!type":"fn()"},"onError":{"!type":"fn(evt: ?)"},"onLoad":{"!type":"fn()"},"setStatus":{"!type":"fn(str: ?, isError: ?)"},"toSeconds":{"!type":"fn(time: ?)"}}},"VolumeButton":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A volume widget to use with dojox.av.widget.Player","templatePath":{},"postCreate":{"!type":"fn()","!doc":"Initialize the widget."},"setMedia":{"!type":"fn(med: ?)","!doc":"A common method to set the media in all Player widgets.\nMay do connections and initializations."},"updateIcon":{"!type":"fn(vol: +Float)","!doc":"Changes the icon on the button according to volume level."},"onShowVolume":{"!type":"fn(evt: +DOMEvent)","!doc":"Shows the volume slider."},"onDocClick":{"!type":"fn(evt: +DOMEvent)","!doc":"Fired on document.onmousedown. Checks if clicked inside\nof this widget or not."},"onHideVolume":{"!type":"fn()","!doc":"Hides volume slider."},"onDrag":{"!type":"fn(evt: +DOMEvent)","!doc":"Fired on mousemove. Updates volume and position of\nslider handle."},"startDrag":{"!type":"fn()","!doc":"Fired on mousedown of the slider handle."},"endDrag":{"!type":"fn()","!doc":"Fired on mouseup of the slider handle."},"handleOver":{"!type":"fn()","!doc":"Highlights the slider handle on mouseover, and\nstays highlighted during drag."},"handleOut":{"!type":"fn()","!doc":"Unhighlights handle onmouseover, or on endDrag."},"_getVolumeDim":{"!type":"fn()","!doc":"Gets dimensions of slider background node.\nOnly uses dojo.coords once, unless the page\nor player is resized."},"_getHandleDim":{"!type":"fn()","!doc":"Gets dimensions of slider handle.\nOnly uses dojo.marginBox once."},"onResize":{"!type":"fn(playerDimensions: ?)","!doc":"Fired on player resize. Zeros dimensions\nso that it can be calculated again."}}}}},"charting":{"Chart2D":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(node: ?, kwArgs: ?)"},"destroy":{"!type":"fn()"},"getCoords":{"!type":"fn()"},"setTheme":{"!type":"fn(theme: ?)"},"addAxis":{"!type":"fn(name: ?, kwArgs: ?)"},"getAxis":{"!type":"fn(name: ?)"},"removeAxis":{"!type":"fn(name: ?) -> +self"},"addPlot":{"!type":"fn(name: ?, kwArgs: ?)"},"removePlot":{"!type":"fn(name: ?) -> +self"},"addSeries":{"!type":"fn(name: ?, data: ?, kwArgs: ?)"},"removeSeries":{"!type":"fn(name: ?) -> +self"},"updateSeries":{"!type":"fn(name: ?, data: ?)"},"resize":{"!type":"fn(width: ?, height: ?)"},"getGeometry":{"!type":"fn()"},"setAxisWindow":{"!type":"fn(name: ?, scale: ?, offset: ?)"},"setWindow":{"!type":"fn(sx: ?, sy: ?, dx: ?, dy: ?)"},"calculateGeometry":{"!type":"fn()"},"fullGeometry":{"!type":"fn()"},"render":{"!type":"fn()"},"fullRender":{"!type":"fn()"},"connectToPlot":{"!type":"fn(name: ?, object: ?, method: ?)"},"_makeClean":{"!type":"fn()"},"_makeDirty":{"!type":"fn()"},"_invalidateDependentPlots":{"!type":"fn(plotName: ?, verticalAxis: bool)"}}},"Chart3D":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(node: ?, lights: ?, camera: ?, theme: ?)"},"generate":{"!type":"fn()"},"invalidate":{"!type":"fn()"},"render":{"!type":"fn()"},"addPlot":{"!type":"fn(plot: ?)"},"removePlot":{"!type":"fn(plot: ?)"},"addWall":{"!type":"fn(wall: ?)"},"removeWall":{"!type":"fn(wall: ?)"},"_add":{"!type":"fn(array: ?, item: ?)"},"_remove":{"!type":"fn(array: ?, item: ?)"},"_generateWalls":{"!type":"fn()"},"_generatePlots":{"!type":"fn()"}}},"DataChart":{"!type":"fn()","prototype":{"!proto":"dojox.charting.Chart2D.prototype","!doc":"DataChart\nExtension to the 2D chart that connects to a data store in\na simple manner. Convenience methods have been added for\nconnecting store item labels to the chart labels.","scroll":{"!doc":"Whether live data updates and changes display, like columns moving\nup and down, or whether it scrolls to the left as data is added","!type":"bool"},"comparative":{"!doc":"If false, all items are each their own series.\nIf true, the items are combined into one series\nso that their charted properties can be compared.","!type":"bool"},"query":{"!doc":"Used for fetching items. Will vary depending upon store.","!type":"string"},"queryOptions":{"!doc":"Option used for fetching items","!type":"string"},"fieldName":{"!doc":"The field in the store item that is getting charted","!type":"string"},"displayRange":{"!doc":"The number of major ticks to show on the xaxis","!type":"number"},"stretchToFit":{"!doc":"If true, chart is sized to data. If false, chart is a\nfixed size. Note, is overridden by displayRange.\nTODO: Stretch for the y-axis?","!type":"bool"},"minWidth":{"!doc":"The the smallest the chart width can be","!type":"number"},"minHeight":{"!doc":"The the smallest the chart height can be","!type":"number"},"showing":{"!doc":"Whether the chart is showing (default) on\ninitialization or hidden.","!type":"bool"},"label":{"!doc":"The name field of the store item\nDO NOT SET: Set from store.labelAttribute","!type":"string"},"constructor":{"!type":"fn(node: +Node, kwArgs: ?)","!doc":"Set up properties and initialize chart build.\n\narguments:"},"setStore":{"!type":"fn(store: ?, query, fieldName, queryOptions)","!doc":"Sets the chart store and query\nthen does the first fetch and\nconnects to subsequent changes.\n\nTODO: Not handling resetting store"},"show":{"!type":"fn()","!doc":"If chart is hidden, show it"},"hide":{"!type":"fn()","!doc":"If chart is showing, hide it\nPrevents rendering while hidden"},"onSet":{"!type":"fn(item: +storeObject)","!doc":"Fired when a store item changes.\nCollects the item calls and when\ndone (after 200ms), sends item\narray to onData().\n\nFIXME: Using labels instead of IDs for item\nidentifiers here and in the chart series. This\nis obviously short sighted, but currently used\nfor seriesLabels. Workaround for potential bugs\nis to assign a label for which all items are unique."},"onError":{"!type":"fn(err: +Error)"},"onDataReceived":{"!type":"fn(items: [])","!doc":"stub. Fires after data is received but\nbefore data is parsed and rendered"},"getProperty":{"!type":"fn(item: +storeObject, prop: ?)","!doc":"The main use of this function is to determine\nbetween a single value and an array of values.\nOther property types included for convenience."},"onData":{"!type":"fn(items: [])","!doc":"Called after a completed fetch\nor when store items change.\nOn first run, sets the chart data,\nthen updates chart and legends.\n\nconsole.log(&quot;Store:&quot;, store);console.log(&quot;items: (&quot;, items.length+&quot;)&quot;, items);console.log(&quot;Chart:&quot;, this);"},"fetch":{"!type":"fn()","!doc":"Fetches initial data. Subsequent changes\nare received via onSet in data store."},"convertLabels":{"!type":"fn(axis: ?) -> +null","!doc":"Convenience method to convert a label array of strings\ninto an array of objects"},"seriesLabels":{"!type":"fn(val: number) -> string","!doc":"Convenience method that sets series labels based on item labels."},"resizeChart":{"!type":"fn(dim: ?)","!doc":"Call this function to change the chart size.\nCan be connected to a layout widget that calls\nresize."}},"chartTheme":{"!doc":"The theme to style the chart. Defaults to PlotKit.blue.","!type":"+dojox.charting.themes.*"}},"Element":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(chart: ?)"},"createGroup":{"!type":"fn(creator: ?)"},"purgeGroup":{"!type":"fn()"},"cleanGroup":{"!type":"fn(creator: ?)"},"destroyHtmlElements":{"!type":"fn()"},"destroy":{"!type":"fn()"}}},"Series":{"!type":"fn()","prototype":{"!proto":"dojox.charting.Element.prototype","constructor":{"!type":"fn(chart: ?, data: ?, kwArgs: ?)"},"clear":{"!type":"fn()"}}},"Theme":{"!type":"fn(kwArgs?: ?)","prototype":{"defineColors":{"!type":"fn(obj: ?)","!doc":"Generate a set of colors for the theme based on keyword\narguments"},"_buildMarkerArray":{"!type":"fn()"},"_clone":{"!type":"fn()","!doc":"Return a clone of this theme, with the position vars reset to 0."},"addMarker":{"!type":"fn(name: string, segment: string)","!doc":"Add a custom marker to this theme."},"setMarkers":{"!type":"fn(obj: ?)","!doc":"Set all the markers of this theme at once.  obj should be a\ndictionary of keys and path segments."},"next":{"!type":"fn(type?: string)","!doc":"get either the next color or the next marker, depending on\nwhat was passed. If type is not passed, it assumes color."},"clear":{"!type":"fn()","!doc":"resets both marker and color counters back to the start.\nSubsequent calls to <code>next</code> will retrievie the first value\nof each depending on the passed type."}},"Markers":{"CIRCLE":{"!type":"string"},"SQUARE":{"!type":"string"},"DIAMOND":{"!type":"string"},"CROSS":{"!type":"string"},"X":{"!type":"string"},"TRIANGLE":{"!type":"string"},"TRIANGLE_INVERTED":{"!type":"string"}},"_def":{"colors":{"!type":"[]"},"chart":{"stroke":{},"fill":{"!type":"string"}},"plotarea":{"stroke":{},"fill":{"!type":"string"}},"axis":{"font":{"!type":"string"},"fontColor":{"!type":"string"},"stroke":{"color":{"!type":"string"},"width":{"!type":"number"}},"majorTick":{"color":{"!type":"string"},"width":{"!type":"number"},"length":{"!type":"number"},"position":{"!type":"string"}},"minorTick":{"color":{"!type":"string"},"width":{"!type":"number"},"length":{"!type":"number"},"position":{"!type":"string"}}},"series":{"fill":{"!type":"string"},"font":{"!type":"string"},"fontColor":{"!type":"string"},"outline":{"width":{"!type":"number"},"color":{"!type":"string"}},"stroke":{"width":{"!type":"number"},"color":{"!type":"string"}}},"marker":{"fill":{"!type":"string"},"font":{"!type":"string"},"fontColor":{"!type":"string"},"stroke":{"width":{"!type":"number"}}}}},"action2d":{"Base":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(chart: ?, plot: ?, kwargs: ?)"},"connect":{"!type":"fn()"},"disconnect":{"!type":"fn()"},"reset":{"!type":"fn()"},"destroy":{"!type":"fn()"}},"overOutEvents":{"onmouseover":{"!type":"number"},"onmouseout":{"!type":"number"}}},"Highlight":{"!type":"fn()","prototype":{"!proto":"dojox.charting.action2d.Base.prototype","constructor":{"!type":"fn(chart: ?, plot: ?, kwArgs: ?)"},"process":{"!type":"fn(o: ?)"}},"defaultParams":{"duration":{"!type":"number"},"easing":{}},"optionalParams":{"highlight":{"!type":"string"}}},"Magnify":{"!type":"fn()","prototype":{"!proto":"dojox.charting.action2d.Base.prototype","optionalParams":{},"constructor":{"!type":"fn(chart: ?, plot: ?, kwArgs: ?)"},"process":{"!type":"fn(o: ?)"}},"defaultParams":{"duration":{"!type":"number"},"easing":{},"scale":{}}},"MoveSlice":{"!type":"fn()","prototype":{"!proto":"dojox.charting.action2d.Base.prototype","optionalParams":{},"constructor":{"!type":"fn(chart: ?, plot: ?, kwArgs: ?)"},"process":{"!type":"fn(o: ?)"},"reset":{"!type":"fn()"}},"defaultParams":{"duration":{"!type":"number"},"easing":{},"scale":{},"shift":{}}},"Shake":{"!type":"fn()","prototype":{"!proto":"dojox.charting.action2d.Base.prototype","optionalParams":{},"constructor":{"!type":"fn(chart: ?, plot: ?, kwArgs: ?)"},"process":{"!type":"fn(o: ?)"}},"defaultParams":{"duration":{"!type":"number"},"easing":{},"shiftX":{},"shiftY":{}}},"Tooltip":{"!type":"fn()","prototype":{"!proto":"dojox.charting.action2d.Base.prototype","optionalParams":{},"constructor":{"!type":"fn(chart: ?, plot: ?, kwArgs: ?)"},"process":{"!type":"fn(o: ?)"}},"defaultParams":{"text":{}}}},"axis2d":{"Base":{"!type":"fn()","prototype":{"!proto":"dojox.charting.Element.prototype","constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"clear":{"!type":"fn()"},"initialized":{"!type":"fn()"},"calculate":{"!type":"fn(min: ?, max: ?, span: ?)"},"getScaler":{"!type":"fn()"},"getTicks":{"!type":"fn()"},"getOffsets":{"!type":"fn()"},"render":{"!type":"fn(dim: ?, offsets: ?)"}}},"Default":{"!type":"fn()","prototype":{"!proto":"dojox.charting.axis2d.Base.prototype","constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"dependOnData":{"!type":"fn()"},"clear":{"!type":"fn()"},"initialized":{"!type":"fn()"},"setWindow":{"!type":"fn(scale: ?, offset: ?)"},"getWindowScale":{"!type":"fn()"},"getWindowOffset":{"!type":"fn()"},"_groupLabelWidth":{"!type":"fn(labels: ?, font: ?)"},"calculate":{"!type":"fn(min: ?, max: ?, span: ?, labels: ?)"},"getScaler":{"!type":"fn()"},"getTicks":{"!type":"fn()"},"getOffsets":{"!type":"fn()"},"render":{"!type":"fn(dim: ?, offsets: ?)"}},"defaultParams":{"vertical":{"!type":"bool"},"fixUpper":{"!type":"string"},"fixLower":{"!type":"string"},"natural":{"!type":"bool"},"leftBottom":{"!type":"bool"},"includeZero":{"!type":"bool"},"fixed":{"!type":"bool"},"majorLabels":{"!type":"bool"},"minorTicks":{"!type":"bool"},"minorLabels":{"!type":"bool"},"microTicks":{"!type":"bool"},"htmlLabels":{"!type":"bool"}},"optionalParams":{"min":{"!type":"number"},"max":{"!type":"number"},"from":{"!type":"number"},"to":{"!type":"number"},"majorTickStep":{"!type":"number"},"minorTickStep":{"!type":"number"},"microTickStep":{"!type":"number"},"labels":{"!type":"[]"},"labelFunc":{},"maxLabelSize":{"!type":"number"},"stroke":{},"majorTick":{},"minorTick":{},"microTick":{},"font":{"!type":"string"},"fontColor":{"!type":"string"}}},"common":{"createText":{"gfx":{"!type":"fn(chart: ?, creator: ?, x: ?, y: ?, align: ?, text: ?, font: ?, fontColor: ?)"},"html":{"!type":"fn(chart: ?, creator: ?, x: ?, y: ?, align: ?, text: ?, font: ?, fontColor: ?, labelWidth: ?)"}}}},"scaler":{"common":{"getNumericLabel":{"!type":"fn(number: number, precision: number, kwArgs: ?)"},"findString":{"!type":"fn(val: string, text: [])"}},"linear":{"buildScaler":{"!type":"fn(min: number, max: number, span: number, kwArgs: ?) -> ?"},"buildTicks":{"!type":"fn(scaler: ?, kwArgs: ?) -> ?"},"getTransformerFromModel":{"!type":"fn(scaler: ?) -> fn()"},"getTransformerFromPlot":{"!type":"fn(scaler: ?) -> fn()"}},"primitive":{"buildScaler":{"!type":"fn(min: number, max: number, span: number, kwArgs: ?)"},"buildTicks":{"!type":"fn(scaler: ?, kwArgs: ?) -> ?"},"getTransformerFromModel":{"!type":"fn(scaler: ?) -> fn()"},"getTransformerFromPlot":{"!type":"fn(scaler: ?) -> fn()"}}},"plot2d":{"Areas":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Default.prototype","constructor":{"!type":"fn()"}}},"Bars":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Base.prototype","constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"calculateAxes":{"!type":"fn(dim: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?)"}},"defaultParams":{"hAxis":{"!type":"string"},"vAxis":{"!type":"string"},"gap":{"!type":"number"},"shadows":{}},"optionalParams":{"minBarSize":{"!type":"number"},"maxBarSize":{"!type":"number"}}},"Base":{"!type":"fn()","prototype":{"!proto":"dojox.charting.Element.prototype","destroy":{"!type":"fn()"},"clear":{"!type":"fn()"},"setAxis":{"!type":"fn(axis: ?)"},"addSeries":{"!type":"fn(run: ?)"},"calculateAxes":{"!type":"fn(dim: ?)"},"isDirty":{"!type":"fn()"},"render":{"!type":"fn(dim: ?, offsets: ?)"},"getRequiredColors":{"!type":"fn()"},"plotEvent":{"!type":"fn(o: ?)"},"connect":{"!type":"fn(object: ?, method: ?)"},"events":{"!type":"fn()"},"resetEvents":{"!type":"fn()"},"_calc":{"!type":"fn(dim: ?, stats: ?)"},"_connectEvents":{"!type":"fn(shape: ?, o: ?)"}}},"Bubble":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Base.prototype","optionalParams":{},"constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"calculateAxes":{"!type":"fn(dim: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?)"}},"defaultParams":{"hAxis":{"!type":"string"},"vAxis":{"!type":"string"}}},"Candlesticks":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Base.prototype","constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"collectStats":{"!type":"fn(series: ?)"},"calculateAxes":{"!type":"fn(dim: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?)"}},"defaultParams":{"hAxis":{"!type":"string"},"vAxis":{"!type":"string"},"gap":{"!type":"number"},"shadows":{}},"optionalParams":{"minBarSize":{"!type":"number"},"maxBarSize":{"!type":"number"}}},"ClusteredBars":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Bars.prototype","render":{"!type":"fn(dim: ?, offsets: ?)"}}},"ClusteredColumns":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Columns.prototype","render":{"!type":"fn(dim: ?, offsets: ?)"}}},"Columns":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Base.prototype","constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"calculateAxes":{"!type":"fn(dim: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?)"}},"defaultParams":{"hAxis":{"!type":"string"},"vAxis":{"!type":"string"},"gap":{"!type":"number"},"shadows":{}},"optionalParams":{"minBarSize":{"!type":"number"},"maxBarSize":{"!type":"number"}}},"Default":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Base.prototype","optionalParams":{},"constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"calculateAxes":{"!type":"fn(dim: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?)"}},"defaultParams":{"hAxis":{"!type":"string"},"vAxis":{"!type":"string"},"lines":{"!type":"bool"},"areas":{"!type":"bool"},"markers":{"!type":"bool"},"shadows":{"!type":"number"},"tension":{"!type":"number"}}},"Grid":{"!type":"fn()","prototype":{"!proto":"dojox.charting.Element.prototype","optionalParams":{},"constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"clear":{"!type":"fn()"},"setAxis":{"!type":"fn(axis: ?)"},"addSeries":{"!type":"fn(run: ?)"},"calculateAxes":{"!type":"fn(dim: ?)"},"isDirty":{"!type":"fn()"},"getRequiredColors":{"!type":"fn()"},"render":{"!type":"fn(dim: ?, offsets: ?)"}},"defaultParams":{"hAxis":{"!type":"string"},"vAxis":{"!type":"string"},"hMajorLines":{"!type":"bool"},"hMinorLines":{"!type":"bool"},"vMajorLines":{"!type":"bool"},"vMinorLines":{"!type":"bool"},"hStripes":{"!type":"string"},"vStripes":{"!type":"string"}}},"Lines":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Default.prototype","constructor":{"!type":"fn()"}}},"Markers":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Default.prototype","constructor":{"!type":"fn()"}}},"MarkersOnly":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Default.prototype","constructor":{"!type":"fn()"}}},"OHLC":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Base.prototype","constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"collectStats":{"!type":"fn(series: ?)"},"calculateAxes":{"!type":"fn(dim: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?)"}},"defaultParams":{"hAxis":{"!type":"string"},"vAxis":{"!type":"string"},"gap":{"!type":"number"},"shadows":{}},"optionalParams":{"minBarSize":{"!type":"number"},"maxBarSize":{"!type":"number"}}},"Pie":{"!type":"fn()","prototype":{"!proto":"dojox.charting.Element.prototype","constructor":{"!type":"fn(chart: ?, kwArgs: ?)"},"destroy":{"!type":"fn()"},"clear":{"!type":"fn()"},"setAxis":{"!type":"fn(axis: ?)"},"addSeries":{"!type":"fn(run: ?)"},"calculateAxes":{"!type":"fn(dim: ?)"},"getRequiredColors":{"!type":"fn()"},"plotEvent":{"!type":"fn(o: ?)"},"connect":{"!type":"fn(object: ?, method: ?)"},"events":{"!type":"fn()"},"resetEvents":{"!type":"fn()"},"_connectEvents":{"!type":"fn(shape: ?, o: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?) -> +continue"},"_getLabel":{"!type":"fn(number: ?)"}},"defaultParams":{"labels":{"!type":"bool"},"ticks":{"!type":"bool"},"fixed":{"!type":"bool"},"precision":{"!type":"number"},"labelOffset":{"!type":"number"},"labelStyle":{"!type":"string"},"htmlLabels":{"!type":"bool"}},"optionalParams":{"font":{"!type":"string"},"fontColor":{"!type":"string"},"radius":{"!type":"number"}}},"Scatter":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Default.prototype","constructor":{"!type":"fn()"}}},"Stacked":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Default.prototype","calculateAxes":{"!type":"fn(dim: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?)"}}},"StackedAreas":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Stacked.prototype","constructor":{"!type":"fn()"}}},"StackedBars":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Bars.prototype","calculateAxes":{"!type":"fn(dim: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?)"}}},"StackedColumns":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Columns.prototype","calculateAxes":{"!type":"fn(dim: ?)"},"render":{"!type":"fn(dim: ?, offsets: ?)"}}},"StackedLines":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot2d.Stacked.prototype","constructor":{"!type":"fn()"}}},"common":{"makeStroke":{"!type":"fn(stroke: ?)"},"augmentColor":{"!type":"fn(target: ?, color: ?)"},"augmentStroke":{"!type":"fn(stroke: ?, color: ?)"},"augmentFill":{"!type":"fn(fill: ?, color: ?)"},"collectSimpleStats":{"!type":"fn(series: ?)"},"calculateBarSize":{"!type":"fn(availableSize: number, opt: ?, clusterSize?: number) -> ?"},"collectStackedStats":{"!type":"fn(series: ?)"},"curve":{"!type":"fn(a: [number], tension: number)"},"defaultStats":{"hmin":{},"hmax":{},"vmin":{},"vmax":{}}}},"plot3d":{"Bars":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot3d.Base.prototype","constructor":{"!type":"fn(width: ?, height: ?, kwArgs: ?)"},"getDepth":{"!type":"fn()"},"generate":{"!type":"fn(chart: ?, creator: ?)"}}},"Base":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(width: ?, height: ?, kwArgs: ?)"},"setData":{"!type":"fn(data: ?)"},"getDepth":{"!type":"fn()"},"generate":{"!type":"fn(chart: ?, creator: ?)"}}},"Cylinders":{"!type":"fn()","prototype":{"!proto":"dojox.charting.plot3d.Base.prototype","constructor":{"!type":"fn(width: ?, height: ?, kwArgs: ?)"},"getDepth":{"!type":"fn()"},"generate":{"!type":"fn(chart: ?, creator: ?)"}}}},"themes":{"Adobebricks":{},"Algae":{},"Bahamation":{},"BlueDusk":{},"CubanShirts":{},"Desert":{},"Dollar":{},"Grasshopper":{},"Grasslands":{},"GreySkies":{},"IndigoNation":{},"Ireland":{},"MiamiNice":{},"Midwest":{},"Minty":{},"PurpleRain":{},"RoyalPurples":{},"SageToLime":{},"Shrooms":{},"Tufte":{},"WatersEdge":{},"Wetland":{},"ET":{"greys":{}},"PlotKit":{"blue":{},"cyan":{},"green":{},"orange":{},"purple":{},"red":{}}},"widget":{"Chart2D":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","theme":{},"margins":{},"stroke":{},"fill":{},"buildRendering":{"!type":"fn()"},"destroy":{"!type":"fn()","!doc":"properly destroy the widget"},"resize":{"!type":"fn(box: ?)","!doc":"resize the widget"}}},"Legend":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A legend for a chart. A legend contains summary labels for\neach series of data contained in the chart.\n\nSet the boolean horizontal attribute to false to layout legend labels vertically.\n\n(Line or Scatter charts (colored lines with shape symbols) )\n-o- Series1\t\t-X- Series2\t\t-v- Series3\n\n(Area/Bar/Pie charts (letters represent colors))\n[a] Series1\t\t[b] Series2\t\t[c] Series3","chartRef":{"!type":"string"},"horizontal":{"!type":"bool"},"swatchSize":{"!type":"number"},"templateString":{"!type":"string"},"legendNode":{},"legendBody":{},"postCreate":{"!type":"fn()"},"refresh":{"!type":"fn()","!doc":"regenerates the legend to reflect changes to the chart"},"_addLabel":{"!type":"fn(dyn: ?, label: ?)"},"_makeIcon":{"!type":"fn(div: ?, dyn: ?)"}}},"Sparkline":{"!type":"fn()","prototype":{"!proto":"dojox.charting.widget.Chart2D.prototype","type":{"!type":"string"},"valueFn":{"!type":"string"},"store":{"!type":"string"},"field":{"!type":"string"},"query":{"!type":"string"},"queryOptions":{"!type":"string"},"start":{"!type":"string"},"count":{"!type":"string"},"sort":{"!type":"string"},"data":{"!type":"string"},"name":{"!type":"string"},"buildRendering":{"!type":"fn()"}},"theme":{},"margins":{"l":{"!type":"number"},"r":{"!type":"number"},"t":{"!type":"number"},"b":{"!type":"number"}}}}},"lang":{"lettableWin":{},"ReadOnlyProxy":{},"observable":{"!type":"fn(wrapped: ?, onRead: fn, onWrite: fn, onInvoke: fn)","!doc":"Creates a wrapper object, which can be observed. The wrapper object\nis a proxy to the wrapped object. If you will be making multiple wrapper\nobjects with the same set of listeners, it is recommended that you\nuse makeObservable, as it is more memory efficient."},"makeObservable":{"!type":"fn(onRead: fn, onWrite: fn, onInvoke: fn, hiddenFunctions: ?)","!doc":"Creates and returns an observable creator function. All the objects that\nare created with the returned constructor will use the provided onRead and\nonWrite listeners.\nThe created constructor should be called with a single argument,\nthe object that will be wrapped to be observed. The constructor will\nreturn the wrapper object."},"aspect":{"cflow":{"!type":"fn(instance: ?, method?: string) -> bool","!doc":"Returns true if the context stack contains a context for a given\ninstance that satisfies a given method name criteria."},"counter":{"!type":"fn() -> ?","!doc":"Returns an object, which can be used to count calls to methods."},"memoizer":{"!type":"fn(keyMaker?: fn()) -> ?","!doc":"Returns an object, which can be used to count calls to methods."},"memoizerGuard":{"!type":"fn(method?: string) -> ?","!doc":"Invalidates the memoizer's cache (see dojox.lang.aspect.memoizer)\nafter calling certain methods."},"profiler":{"!type":"fn(title?: string) -> ?","!doc":"Returns an object, which can be used to time calls to methods."},"timer":{"!type":"fn(name?: string) -> ?","!doc":"Returns an object, which can be used to time calls to methods."},"tracer":{"!type":"fn(grouping: bool) -> ?","!doc":"Returns an object, which can be used to trace calls with Firebug's console.\nPrints argument, a return value, or an exception."},"advise":{"!type":"fn(obj: ?, method: string, advice: +Object) -> ?","!doc":"Attach AOP-style advices to a method."},"adviseRaw":{"!type":"fn(obj: ?, methods: [], advices: []) -> ?","!doc":"Attach AOP-style advices to methods."},"unadvise":{"!type":"fn(handle: ?)","!doc":"Detach previously attached AOP-style advices."},"getContext":{"!type":"fn() -> ?","!doc":"Returns the context information for the advice in effect."},"getContextStack":{"!type":"fn() -> []","!doc":"Returns the context stack, which reflects executing advices\nup to this point. The array is ordered from oldest to newest.\nIn order to get the active context use dojox.lang.aspect.getContext()."},"proceed":{"!type":"fn()","!doc":"Call the original function (or the next level around advice) in an around advice code."}},"docs":{"_loadedDocs":{},"init":{"!type":"fn(async: bool)","!doc":"Loads the documentation and applies it to the previously defined classes\nand any future defined classes"}},"functional":{"array":{},"arg":{},"fold":{},"object":{},"reversed":{},"scan":{},"sequence":{},"util":{},"filter":{"!type":"fn(a: [], f: fn(), o?: ?) -> []","!doc":"creates a new array with all elements that pass the test\nimplemented by the provided function."},"forEach":{"!type":"fn(a: [], f: fn(), o?: ?) -> ?","!doc":"executes a provided function once per array element."},"map":{"!type":"fn(a: [], f: fn(), o?: ?) -> []","!doc":"creates a new array with the results of calling\na provided function on every element in this array."},"every":{"!type":"fn(a: [], f: fn(), o?: ?) -> bool","!doc":"tests whether all elements in the array pass the test\nimplemented by the provided function."},"some":{"!type":"fn(a: [], f: fn(), o?: ?) -> bool","!doc":"tests whether some element in the array passes the test\nimplemented by the provided function."},"inlineLambda":{"!type":"fn(lambda: string, init: string, add2dict?: fn()) -> string","!doc":"Creates the inlined version of a string lambda."},"binrec":{"!type":"fn(cond: fn(), then: fn(), before: fn(), after: fn())","!doc":"Generates a function for the binary recursion pattern.\nAll parameter functions are called in the context of &quot;this&quot; object."},"curry":{"!type":"fn(f: fn(), arity?: number) -> fn()","!doc":"curries a function until the arity is satisfied, at\nwhich point it returns the calculated value."},"partial":{"!type":"fn(f: fn()) -> fn()","!doc":"creates a function where some arguments are bound, and\nsome arguments (marked as dojox.lang.functional.arg) are will be\naccepted by the final function in the order they are encountered."},"mixer":{"!type":"fn(f: fn(), mix: []) -> fn()","!doc":"changes the order of arguments using an array of\nnumbers mix --- i-th argument comes from mix[i]-th place\nof supplied arguments."},"flip":{"!type":"fn(f: fn()) -> fn()","!doc":"changes the order of arguments by reversing their\norder."},"foldl":{"!type":"fn(a: [], f: fn(), z: ?, o?: ?) -> ?","!doc":"repeatedly applies a binary function to an array from left\nto right using a seed value as a starting point; returns the final\nvalue."},"foldl1":{"!type":"fn(a: [], f: fn(), o?: ?) -> ?","!doc":"repeatedly applies a binary function to an array from left\nto right; returns the final value."},"foldr":{"!type":"fn(a: [], f: fn(), z: ?, o?: ?) -> ?","!doc":"repeatedly applies a binary function to an array from right\nto left using a seed value as a starting point; returns the final\nvalue."},"foldr1":{"!type":"fn(a: [], f: fn(), o?: ?) -> ?","!doc":"repeatedly applies a binary function to an array from right\nto left; returns the final value."},"reduce":{"!type":"fn(a: [], f: fn(), z?: ?) -> ?","!doc":"apply a function simultaneously against two values of the array\n(from left-to-right) as to reduce it to a single value."},"reduceRight":{"!type":"fn(a: [], f: fn(), z?: ?) -> ?","!doc":"apply a function simultaneously against two values of the array\n(from right-to-left) as to reduce it to a single value."},"unfold":{"!type":"fn(pr: fn(), f: fn(), g: fn(), z: ?, o?: ?) -> []","!doc":"builds an array by unfolding a value"},"rawLambda":{"!type":"fn(s: string) -> ?","!doc":"builds a function from a snippet, or array (composing),\nreturns an object describing the function; functions are\npassed through unmodified."},"buildLambda":{"!type":"fn(s: string) -> string","!doc":"builds a function from a snippet, returns a string, which\nrepresents the function."},"lambda":{"!type":"fn(s: fn()) -> fn()","!doc":"builds a function from a snippet, or array (composing),\nreturns a function object; functions are passed through\nunmodified."},"clearLambdaCache":{"!type":"fn()","!doc":"clears internal cache of lambdas"},"linrec":{"!type":"fn(cond: fn(), then: fn(), before: fn(), after: fn())","!doc":"Generates a function for the linear recursion pattern.\nAll parameter functions are called in the context of &quot;this&quot; object."},"buildListcomp":{"!type":"fn(s: string) -> string","!doc":"builds a function from a text snippet, which represents a valid\nJS 1.7 list comprehension, returns a string, which represents the function."},"compileListcomp":{"!type":"fn(s: string) -> fn()","!doc":"builds a function from a text snippet, which represents a valid\nJS 1.7 list comprehension, returns a function object."},"listcomp":{"!type":"fn(s: string) -> []","!doc":"executes the list comprehension building an array."},"multirec":{"!type":"fn(cond: fn(), then: fn(), before: fn(), after: fn())","!doc":"Generates a function for the multi-way recursion pattern.\nAll parameter functions are called in the context of &quot;this&quot; object."},"numrec":{"!type":"fn(then: ?, after: fn())","!doc":"Generates a function for the simplified numeric linear recursion pattern.\nAll parameter functions are called in the context of &quot;this&quot; object."},"keys":{"!type":"fn(obj: ?) -> []","!doc":"returns an array of all keys in the object"},"values":{"!type":"fn(obj: ?) -> []","!doc":"returns an array of all values in the object"},"filterIn":{"!type":"fn(obj: ?, f: fn(), o?: ?) -> ?","!doc":"creates new object with all attributes that pass the test\nimplemented by the provided function."},"forIn":{"!type":"fn(obj: ?, f: fn(), o?: ?) -> ?","!doc":"iterates over all object attributes."},"mapIn":{"!type":"fn(obj: ?, f: fn(), o?: ?) -> ?","!doc":"creates new object with the results of calling\na provided function on every attribute in this object."},"filterRev":{"!type":"fn(a: [], f: fn(), o?: ?) -> []","!doc":"creates a new array with all elements that pass the test\nimplemented by the provided function."},"forEachRev":{"!type":"fn(a: [], f: fn(), o?: ?)","!doc":"executes a provided function once per array element."},"mapRev":{"!type":"fn(a: [], f: fn(), o?: ?) -> []","!doc":"creates a new array with the results of calling\na provided function on every element in this array."},"everyRev":{"!type":"fn(a: [], f: fn(), o?: ?) -> bool","!doc":"tests whether all elements in the array pass the test\nimplemented by the provided function."},"someRev":{"!type":"fn(a: [], f: fn(), o?: ?) -> bool","!doc":"tests whether some element in the array passes the test\nimplemented by the provided function."},"scanl":{"!type":"fn(a: [], f: fn(), z: ?, o?: ?) -> []","!doc":"repeatedly applies a binary function to an array from left\nto right using a seed value as a starting point; returns an array\nof values produced by foldl() at that point."},"scanl1":{"!type":"fn(a: [], f: fn(), o?: ?) -> []","!doc":"repeatedly applies a binary function to an array from left\nto right; returns an array of values produced by foldl1() at that\npoint."},"scanr":{"!type":"fn(a: [], f: fn(), z: ?, o?: ?) -> []","!doc":"repeatedly applies a binary function to an array from right\nto left using a seed value as a starting point; returns an array\nof values produced by foldr() at that point."},"scanr1":{"!type":"fn(a: [], f: fn(), o?: ?) -> []","!doc":"repeatedly applies a binary function to an array from right\nto left; returns an array of values produced by foldr1() at that\npoint."},"repeat":{"!type":"fn(n: number, f: fn(), z: ?, o?: ?) -> []","!doc":"builds an array by repeatedly applying a unary function N times\nwith a seed value Z. N should be greater than 0."},"until":{"!type":"fn(pr: fn(), f: fn(), z: ?, o?: ?) -> []","!doc":"builds an array by repeatedly applying a unary function with\na seed value Z until the predicate is satisfied."},"tailrec":{"!type":"fn(cond: fn(), then: fn(), before: fn())","!doc":"Generates a function for the tail recursion pattern. This is the simplified\nversion of the linear recursive combinator without the &quot;after&quot; function,\nand with the modified &quot;before&quot; function. All parameter functions are called\nin the context of &quot;this&quot; object."},"zip":{"!type":"fn() -> []","!doc":"returns an array of arrays, where the i-th array\ncontains the i-th element from each of the argument arrays."},"unzip":{"!type":"fn(a: []) -> []","!doc":"similar to dojox.lang.functional.zip(), but takes\na single array of arrays as the input."}},"oo":{"declare":{},"Decorator":{"!type":"fn(value: +Object, decorator: fn())","!doc":"The base class for all decorators."},"makeDecorator":{"!type":"fn(decorator: fn())","!doc":"creates new custom decorator creator"},"Filter":{"!type":"fn(bag: +Object, filter: fn())","!doc":"Filter to control mixing in objects by skipping\nproperties and renaming them."},"filter":{"!type":"fn(bag: +Object, map: +Object)","!doc":"creates a simple filter object"},"makeDeclare":{"!type":"fn(before: ?, after: ?) -> fn()"},"applyDecorator":{"!type":"fn(decorator: fn(), name: string, newValue: +Object, oldValue: +Object)","!doc":"applies a decorator unraveling all embedded decorators"},"__MixinDefaults":{"!type":"fn()","!doc":"a dict of default parameters for dojox.lang.oo._mixin\ndecorator: Function:\na decorator function to be used in absence of other decorators\nfilter: Function:\na filter function to be used in absence of other filters\nmixer: Function:\na mixer function to be used to mix in new properties"},"__mixin":{"!type":"fn(target: +Object, source: +Object, decorator: ?, filter: ?, mixer: ?) -> ?","!doc":"mixes in two objects processing decorators and filters"},"mixin":{"!type":"fn(target: +Object, source: +Object) -> ?","!doc":"mixes in two or more objects processing decorators and filters\nusing defaults as a fallback"},"rearrange":{"!type":"fn(bag: +Object, map: +Object) -> ?","!doc":"Process properties in place by removing and renaming them."},"aop":{"before":{},"around":{},"afterReturning":{},"afterThrowing":{},"after":{}},"general":{"augment":{},"override":{},"shuffle":{},"wrap":{},"tap":{},"before":{},"after":{}}},"utils":{"coerceType":{"!type":"fn(target: ?, source: ?)"},"updateWithObject":{"!type":"fn(target: +Object, source: +Object, conv?: bool) -> ?","!doc":"updates an existing object in place with properties from an &quot;source&quot; object."},"updateWithPattern":{"!type":"fn(target: +Object, source: +Object, pattern: [], conv?: bool) -> ?","!doc":"updates an existing object in place with properties from an &quot;source&quot; object."}}},"gfx3d":{"_base":{},"Matrix3D":{},"object":{},"gradient":{"!type":"fn(model: +dojox.gfx3d.lighting.Model, material: +Object, center: +Object, radius: number, from: number, to: number, matrix: +dojox.gfx3d.Matrix3D)","!doc":"calculate a cylindrical gradient"},"defaultEdges":{"type":{"!type":"string"},"style":{},"points":{"!type":"[]"}},"defaultTriangles":{"type":{"!type":"string"},"style":{},"points":{"!type":"[]"}},"defaultQuads":{"type":{"!type":"string"},"style":{},"points":{"!type":"[]"}},"defaultOrbit":{"type":{"!type":"string"},"radius":{"!type":"number"},"center":{"x":{"!type":"number"},"y":{"!type":"number"},"z":{"!type":"number"}}},"defaultPath3d":{"type":{"!type":"string"},"path":{"!type":"[]"}},"defaultPolygon":{"type":{"!type":"string"},"path":{"!type":"[]"}},"defaultCube":{"type":{"!type":"string"},"bottom":{"x":{"!type":"number"},"y":{"!type":"number"},"z":{"!type":"number"}},"top":{"x":{"!type":"number"},"y":{"!type":"number"},"z":{"!type":"number"}}},"defaultCylinder":{"type":{"!type":"string"},"height":{"!type":"number"},"radius":{"!type":"number"},"center":{"x":{"!type":"number"},"y":{"!type":"number"},"z":{"!type":"number"}}},"lighting":{"black":{"!type":"fn()"},"white":{"!type":"fn()"},"toStdColor":{"!type":"fn(c: ?)"},"fromStdColor":{"!type":"fn(c: ?)"},"scaleColor":{"!type":"fn(s: ?, c: ?)"},"addColor":{"!type":"fn(a: ?, b: ?)"},"multiplyColor":{"!type":"fn(a: ?, b: ?)"},"saturateColor":{"!type":"fn(c: ?)"},"mixColor":{"!type":"fn(c1: ?, c2: ?, s: ?)"},"diff2Color":{"!type":"fn(c1: ?, c2: ?)"},"length2Color":{"!type":"fn(c: ?)"},"dot":{"!type":"fn(a: ?, b: ?)"},"scale":{"!type":"fn(s: ?, v: ?)"},"add":{"!type":"fn(a: ?, b: ?)"},"saturate":{"!type":"fn(v: ?)"},"length":{"!type":"fn(v: ?)"},"normalize":{"!type":"fn(v: ?)"},"faceforward":{"!type":"fn(n: ?, i: ?)"},"reflect":{"!type":"fn(i: ?, n: ?)"},"diffuse":{"!type":"fn(normal: ?, lights: ?)"},"specular":{"!type":"fn(normal: ?, v: ?, roughness: ?, lights: ?)"},"phong":{"!type":"fn(normal: ?, v: ?, size: ?, lights: ?)"},"Model":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(incident: ?, lights: ?, ambient: ?, specular: ?)"},"constant":{"!type":"fn(normal: ?, finish: ?, pigment: ?)"},"matte":{"!type":"fn(normal: ?, finish: ?, pigment: ?)"},"metal":{"!type":"fn(normal: ?, finish: ?, pigment: ?)"},"plastic":{"!type":"fn(normal: ?, finish: ?, pigment: ?)"},"npr":{"!type":"fn(normal: ?, finish: ?, pigment: ?)"}}},"finish":{"defaults":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}},"dull":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}},"shiny":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}},"glossy":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}},"phong_dull":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"phong":{"!type":"number"},"phong_size":{"!type":"number"}},"phong_shiny":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"phong":{"!type":"number"},"phong_size":{"!type":"number"}},"phong_glossy":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"phong":{"!type":"number"},"phong_size":{"!type":"number"}},"luminous":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}},"metalA":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}},"metalB":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}},"metalC":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}},"metalD":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}},"metalE":{"Ka":{"!type":"number"},"Kd":{"!type":"number"},"Ks":{"!type":"number"},"roughness":{"!type":"number"}}}},"matrix":{"identity":{},"translate":{"!type":"fn(a: number, b: number, c: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a translation matrix"},"scale":{"!type":"fn(a: number, b: number, c: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a scaling matrix"},"rotateX":{"!type":"fn(angle: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the x axis)"},"rotateXg":{"!type":"fn(degree: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the x axis)"},"rotateY":{"!type":"fn(angle: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the y axis)"},"rotateYg":{"!type":"fn(degree: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the y axis)"},"rotateZ":{"!type":"fn(angle: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the z axis)"},"rotateZg":{"!type":"fn(degree: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the z axis)"},"cameraTranslate":{"!type":"fn(a: number, b: number, c: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a translation matrix"},"cameraRotateX":{"!type":"fn(angle: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the x axis) in cameraTransform manner"},"cameraRotateXg":{"!type":"fn(degree: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the x axis)in cameraTransform manner"},"cameraRotateY":{"!type":"fn(angle: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the y axis) in cameraTransform manner"},"cameraRotateYg":{"!type":"fn(degree: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the y axis) in cameraTransform manner"},"cameraRotateZ":{"!type":"fn(angle: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the z axis) in cameraTransform manner"},"cameraRotateZg":{"!type":"fn(degree: number) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"forms a rotating matrix (about the z axis) in cameraTransform manner"},"normalize":{"!type":"fn(matrix: +Object) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"converts an object to a matrix, if necessary"},"clone":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix3D) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"creates a copy of a 3D matrix"},"invert":{"!type":"fn(matrix: +dojox.gfx.matrix.Matrix3D) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"inverts a 2D matrix"},"_multiplyPoint":{"!type":"fn(m: ?, x: number, y: number, z: number) -> ?","!doc":"applies a matrix to a point\nmatrix: dojox.gfx3d.matrix.Matrix3D: a 3D matrix object to be applied"},"multiplyPoint":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix3D, a: number, b: number, c: number) -> ?","!doc":"applies a matrix to a point"},"multiply":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix3D) -> +dojox.gfx3d.matrix.Matrix3D","!doc":"combines matrices by multiplying them sequentially in the given order"},"_project":{"!type":"fn(m: ?, x: number, y: number, z: number) -> ?","!doc":"applies a matrix to a point\nmatrix: dojox.gfx3d.matrix.Matrix3D: a 3D matrix object to be applied"},"project":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix3D, a: number, b: number, c: number) -> ?","!doc":"applies a matrix to a point"},"_degToRad":{"!type":"fn(degree: ?)"},"_radToDeg":{"!type":"fn(radian: ?)"},"Matrix3D":{"!type":"fn(arg: ?)","!doc":"a 3D matrix object"}},"Viewport":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d._creators.prototype","!doc":"a viewport/container for 3D objects, which knows\nthe camera and lightings","constructor":{"!type":"fn()","!doc":"a viewport/container for 3D objects, which knows\nthe camera and lightings"},"setCameraTransform":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix) -> +self","!doc":"sets a transformation matrix"},"applyCameraRightTransform":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix) -> +self","!doc":"multiplies the existing matrix with an argument on right side\n(this.matrix * matrix)"},"applyCameraLeftTransform":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix) -> +self","!doc":"multiplies the existing matrix with an argument on left side\n(matrix * this.matrix)"},"applyCameraTransform":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix) -> +self","!doc":"a shortcut for dojox.gfx3d.Object.applyRightTransform"},"setLights":{"!type":"fn(lights: [], ambient: +Color, specular: +Color)","!doc":"set the lights"},"addLights":{"!type":"fn(lights: [])","!doc":"add new light/lights to the viewport."},"addTodo":{"!type":"fn(newObject: ?)"},"invalidate":{"!type":"fn()"},"setDimensions":{"!type":"fn(dim: ?)"},"render":{"!type":"fn()","!doc":"iterate all children and call their render callback function."}},"nodeType":{}},"Scene":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d._creators.prototype","!doc":"the Scene is just a containter.\nnote: we have the following assumption:\nall objects in the Scene are not overlapped with other objects\noutside of the scene.","constructor":{"!type":"fn()","!doc":"a containter of other 3D objects"},"setFill":{"!type":"fn(fill: ?)"},"setStroke":{"!type":"fn(stroke: ?)"},"render":{"!type":"fn(camera: ?, deep: ?)"},"draw":{"!type":"fn(lighting: ?)"},"addTodo":{"!type":"fn(newObject: ?)"},"invalidate":{"!type":"fn()"},"getZOrder":{"!type":"fn()"}}},"Object":{"!type":"fn()","prototype":{"!doc":"a Object object, which knows how to map\n3D objects to 2D shapes.","constructor":{"!type":"fn()","!doc":"a Object object, which knows how to map\n3D objects to 2D shapes."},"setObject":{"!type":"fn(newObject: ?)","!doc":"sets a Object object\nobject: Object: an abstract Object object\n(see dojox.gfx3d.defaultEdges,\ndojox.gfx3d.defaultTriangles,\ndojox.gfx3d.defaultQuads\ndojox.gfx3d.defaultOrbit\ndojox.gfx3d.defaultCube\nor dojox.gfx3d.defaultCylinder)"},"setTransform":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix) -> +self","!doc":"sets a transformation matrix"},"applyRightTransform":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix) -> +self","!doc":"multiplies the existing matrix with an argument on right side\n(this.matrix * matrix)"},"applyLeftTransform":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix) -> +self","!doc":"multiplies the existing matrix with an argument on left side\n(matrix * this.matrix)"},"applyTransform":{"!type":"fn(matrix: +dojox.gfx3d.matrix.Matrix) -> +self","!doc":"a shortcut for dojox.gfx.Shape.applyRightTransform"},"setFill":{"!type":"fn(fill: +Object)","!doc":"sets a fill object\n(the default implementation is to delegate to\nthe underlying 2D shape)."},"setStroke":{"!type":"fn(stroke: +Object)","!doc":"sets a stroke object\n(the default implementation simply ignores it)"},"toStdFill":{"!type":"fn(lighting: ?, normal: ?)"},"invalidate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"render":{"!type":"fn(camera: ?)"},"draw":{"!type":"fn(lighting: ?)"},"getZOrder":{"!type":"fn()"},"getOutline":{"!type":"fn()"}}},"Edges":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d.Object.prototype","!doc":"a generic edge in 3D viewport","constructor":{"!type":"fn()","!doc":"a generic edge in 3D viewport"},"setObject":{"!type":"fn(newObject: [], style: string)","!doc":"setup the object"},"getZOrder":{"!type":"fn()"},"render":{"!type":"fn(camera: ?)"},"draw":{"!type":"fn()"}}},"Orbit":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d.Object.prototype","!doc":"a generic edge in 3D viewport","constructor":{"!type":"fn()","!doc":"a generic edge in 3D viewport"},"render":{"!type":"fn(camera: ?)"},"draw":{"!type":"fn(lighting: ?)"}}},"Path3d":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d.Object.prototype","!doc":"a generic line\n(this is a helper object, which is defined for convenience)","constructor":{"!type":"fn()","!doc":"a generic line\n(this is a helper object, which is defined for convenience)"},"_collectArgs":{"!type":"fn(array: [], args: [])","!doc":"converts an array of arguments to plain numeric values"},"_pushSegment":{"!type":"fn(action: string, args: [])","!doc":"adds a segment"},"moveTo":{"!type":"fn() -> +self","!doc":"formes a move segment"},"lineTo":{"!type":"fn() -> +self","!doc":"formes a line segment"},"closePath":{"!type":"fn() -> +self","!doc":"closes a path"},"render":{"!type":"fn(camera: ?)"},"_draw":{"!type":"fn()"}},"_validSegments":{"m":{"!type":"number"},"l":{"!type":"number"},"z":{"!type":"number"}}},"Triangles":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d.Object.prototype","!doc":"a generic triangle\n(this is a helper object, which is defined for convenience)","constructor":{"!type":"fn()","!doc":"a generic triangle\n(this is a helper object, which is defined for convenience)"},"setObject":{"!type":"fn(newObject: [], style: string)","!doc":"setup the object"},"render":{"!type":"fn(camera: ?)"},"draw":{"!type":"fn(lighting: ?)"},"getZOrder":{"!type":"fn()"}}},"Quads":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d.Object.prototype","!doc":"a generic triangle\n(this is a helper object, which is defined for convenience)","constructor":{"!type":"fn()","!doc":"a generic triangle\n(this is a helper object, which is defined for convenience)"},"setObject":{"!type":"fn(newObject: [], style: string)","!doc":"setup the object"},"render":{"!type":"fn(camera: ?)"},"draw":{"!type":"fn(lighting: ?)"},"getZOrder":{"!type":"fn()"}}},"Polygon":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d.Object.prototype","!doc":"a generic triangle\n(this is a helper object, which is defined for convenience)","constructor":{"!type":"fn()","!doc":"a generic triangle\n(this is a helper object, which is defined for convenience)"},"setObject":{"!type":"fn(newObject: [])","!doc":"setup the object"},"render":{"!type":"fn(camera: ?)"},"draw":{"!type":"fn(lighting: ?)"},"getZOrder":{"!type":"fn()"},"getOutline":{"!type":"fn()"}}},"Cube":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d.Object.prototype","!doc":"a generic triangle\n(this is a helper object, which is defined for convenience)","constructor":{"!type":"fn()","!doc":"a generic triangle\n(this is a helper object, which is defined for convenience)"},"setObject":{"!type":"fn(newObject: [])","!doc":"setup the object"},"render":{"!type":"fn(camera: ?)"},"draw":{"!type":"fn(lighting: ?)"},"getZOrder":{"!type":"fn()"}}},"Cylinder":{"!type":"fn()","prototype":{"!proto":"dojox.gfx3d.Object.prototype","constructor":{"!type":"fn()"},"render":{"!type":"fn(camera: ?)"},"draw":{"!type":"fn()"}}},"_creators":{"!doc":"object creators\n\n\ntodo : override the add/remove if necessary","createEdges":{"!type":"fn(edges: ?, style: ?) -> +dojox.gfx3d.Edge","!doc":"creates an edge object\nline: Object: a edge object (see dojox.gfx3d.defaultPath)"},"createTriangles":{"!type":"fn(tris: ?, style: ?) -> +dojox.gfx3d.Edge","!doc":"creates an edge object\nline: Object: a edge object (see dojox.gfx3d.defaultPath)"},"createQuads":{"!type":"fn(quads: ?, style: ?) -> +dojox.gfx3d.Edge","!doc":"creates an edge object\nline: Object: a edge object (see dojox.gfx3d.defaultPath)"},"createPolygon":{"!type":"fn(points: []) -> +dojox.gfx3d.Polygon","!doc":"creates an triangle object"},"createOrbit":{"!type":"fn(orbit: ?) -> +dojox.gfx3d.Cube","!doc":"creates an triangle object\npoints: Array of points || Object"},"createCube":{"!type":"fn(cube: ?) -> +dojox.gfx3d.Cube","!doc":"creates an triangle object\npoints: Array of points || Object"},"createCylinder":{"!type":"fn(cylinder: ?) -> +dojox.gfx3d.Cube","!doc":"creates an triangle object\npoints: Array of points || Object"},"createPath3d":{"!type":"fn(path: ?) -> +dojox.gfx3d.Edge","!doc":"creates an edge object\nline: Object: a edge object (see dojox.gfx3d.defaultPath)"},"createScene":{"!type":"fn() -> +dojox.gfx3d.Scene","!doc":"creates an triangle object\nline: Object: a triangle object (see dojox.gfx3d.defaultPath)"},"create3DObject":{"!type":"fn(objectType: ?, rawObject: ?, style: ?) -> +dojox.gfx3d.Object","!doc":"creates an instance of the passed shapeType class\nshapeType: Function: a class constructor to create an instance of\nrawShape: Object: properties to be passed in to the classes &quot;setShape&quot; method"},"adopt":{"!type":"fn(obj: ?)","!doc":"adds a shape to the list\nshape: dojox.gfx.Shape: a shape"},"abandon":{"!type":"fn(obj: ?, silently?: bool) -> +self","!doc":"removes a shape from the list"},"setScheduler":{"!type":"fn(scheduler: ?)"},"setDrawer":{"!type":"fn(drawer: ?)"}},"scheduler":{"zOrder":{"!type":"fn(buffer: ?, order: ?)"},"bsp":{"!type":"fn(buffer: ?, outline: ?)"},"order":{"!type":"fn(it: ?)"},"outline":{"!type":"fn(it: ?)"},"BinarySearchTree":{"!type":"fn()","prototype":{"!doc":"build the binary search tree, using binary space partition algorithm.\nThe idea is for any polygon, for example, (a, b, c), the space is divided by\nthe plane into two space: plus and minus.\n\nfor any arbitary vertex p, if(p - a) dotProduct n = 0, p is inside the plane,\n> 0, p is in the plus space, vice versa for minus space.\nn is the normal vector that is perpendicular the plate, defined as:\nn = ( b - a) crossProduct ( c - a )\n\nin this implementation, n is declared as normal, ,a is declared as orient.\n\nobj: object: dojox.gfx3d.Object","constructor":{"!type":"fn(obj: +object, outline: ?)","!doc":"build the binary search tree, using binary space partition algorithm.\nThe idea is for any polygon, for example, (a, b, c), the space is divided by\nthe plane into two space: plus and minus.\n\nfor any arbitary vertex p, if(p - a) dotProduct n = 0, p is inside the plane,\n&gt; 0, p is in the plus space, vice versa for minus space.\nn is the normal vector that is perpendicular the plate, defined as:\nn = ( b - a) crossProduct ( c - a )\n\nin this implementation, n is declared as normal, ,a is declared as orient."},"add":{"!type":"fn(obj: ?, outline: ?)"},"iterate":{"!type":"fn(outline: ?)"}}}},"drawer":{"conservative":{"!type":"fn(todos: ?, objects: ?, viewport: ?)"},"chart":{"!type":"fn(todos: ?, objects: ?, viewport: ?)"}},"vector":{"sum":{"!type":"fn()","!doc":"sum of the vectors"},"center":{"!type":"fn()","!doc":"center of the vectors"},"substract":{"!type":"fn(a: +Pointer, b: +Pointer)"},"_crossProduct":{"!type":"fn(x: number, y: number, z: number, u: number, v: number, w: number) -> ?","!doc":"applies a cross product of two vectorss, (x, y, z) and (u, v, w)"},"crossProduct":{"!type":"fn(a: number, b: number, c: number, d: number, e: number, f: number) -> ?","!doc":"applies a matrix to a point\nmatrix: dojox.gfx3d.matrix.Matrix3D: a 3D matrix object to be applied"},"_dotProduct":{"!type":"fn(x: number, y: number, z: number, u: number, v: number, w: number) -> number","!doc":"applies a cross product of two vectorss, (x, y, z) and (u, v, w)"},"dotProduct":{"!type":"fn(a: number, b: number, c: number, d: number, e: number, f: number) -> ?","!doc":"applies a matrix to a point\nmatrix: dojox.gfx3d.matrix.Matrix3D: a 3D matrix object to be applied"},"normalize":{"!type":"fn(a: +Point, b: +Point, c: +Point)","!doc":"find the normal of the implicit surface"}}},"gfx":{"_vectorFontCache":{},"_svgFontCache":{},"VectorText":{},"getDefault":{},"cm_in_pt":{"!type":"number"},"mm_in_pt":{"!type":"number"},"pathVmlRegExp":{"!type":"+RegExp"},"pathSvgRegExp":{"!type":"+RegExp"},"canvas":{},"Matrix2D":{},"move":{},"renderer":{"!type":"string"},"normalizedLength":{"!type":"fn(len: string) -> number","!doc":"converts any length value to pixels"},"getVectorFont":{"!type":"fn(url: string)"},"normalizeColor":{"!type":"fn(color: +Color) -> +dojo.Color","!doc":"converts any legal color representation to normalized\ndojo.Color object"},"normalizeParameters":{"!type":"fn(existed: ?, update: ?) -> ?","!doc":"updates an existing object with properties from an &quot;update&quot;\nobject"},"makeParameters":{"!type":"fn(defaults: ?, update: ?) -> ?","!doc":"copies the original object, and all copied properties from the\n&quot;update&quot; object"},"formatNumber":{"!type":"fn(x: number, addSpace?: bool) -> string","!doc":"converts a number to a string using a fixed notation"},"makeFontString":{"!type":"fn(font: +Object) -> ?","!doc":"converts a font object to a CSS font string"},"splitFontString":{"!type":"fn(str: string) -> ?","!doc":"converts a CSS font string to a font object"},"px_in_pt":{"!type":"fn() -> number","!doc":"returns a number of pixels per point"},"pt2px":{"!type":"fn(len: number) -> number","!doc":"converts points to pixels"},"px2pt":{"!type":"fn(len: number) -> number","!doc":"converts pixels to points"},"equalSources":{"!type":"fn(a: ?, b: ?)","!doc":"compares event sources, returns true if they are equal"},"_hasClass":{"!type":"fn(node: +Node, classStr: string) -> bool","!doc":"Returns whether or not the specified classes are a portion of the\nclass list currently applied to the node.\nreturn (new RegExp('(^|\\\\s+)'+classStr+'(\\\\s+|$)')).test(node.className)\t// Boolean"},"_addClass":{"!type":"fn(node: +Node, classStr: string)","!doc":"Adds the specified classes to the end of the class list on the\npassed node."},"_removeClass":{"!type":"fn(node: +Node, classStr: string)","!doc":"Removes classes from node."},"createSurface":{"!type":"fn(parentNode: +Node, width: string, height: string) -> +dojox.gfx.Surface","!doc":"creates a surface (VML)"},"attachNode":{"!type":"fn(node: +Node) -> +dojox.gfx.Shape","!doc":"creates a shape from a Node"},"decompose":{"!type":"fn(matrix: +dojox.gfx.matrix.Matrix2D) -> ?","!doc":"decompose a 2D matrix into translation, scaling, and rotation components"},"attachSurface":{"!type":"fn(node: +Node) -> +dojox.gfx.Surface","!doc":"creates a surface from a Node"},"matrix":{"identity":{},"flipX":{},"flipY":{},"flipXY":{},"multiplyPoint":{"!type":"fn(matrix: +dojox.gfx.matrix.Matrix2D, a: number, b: number) -> +dojox.gfx.Point","!doc":"applies a matrix to a point"},"translate":{"!type":"fn(a: number, b: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms a translation matrix"},"scale":{"!type":"fn(a: number, b: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms a scaling matrix"},"rotate":{"!type":"fn(angle: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms a rotating matrix"},"rotateg":{"!type":"fn(degree: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms a rotating matrix"},"skewX":{"!type":"fn(angle: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms an x skewing matrix"},"skewXg":{"!type":"fn(degree: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms an x skewing matrix"},"skewY":{"!type":"fn(angle: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms a y skewing matrix"},"skewYg":{"!type":"fn(degree: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms a y skewing matrix"},"reflect":{"!type":"fn(a: +dojox.gfx.Point, b: +null) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms a reflection matrix"},"project":{"!type":"fn(a: +dojox.gfx.Point, b: +null) -> +dojox.gfx.matrix.Matrix2D","!doc":"forms an orthogonal projection matrix"},"normalize":{"!type":"fn(matrix: +Object) -> +dojox.gfx.matrix.Matrix2D","!doc":"converts an object to a matrix, if necessary"},"clone":{"!type":"fn(matrix: +dojox.gfx.matrix.Matrix2D) -> +dojox.gfx.matrix.Matrix2D","!doc":"creates a copy of a 2D matrix"},"invert":{"!type":"fn(matrix: +dojox.gfx.matrix.Matrix2D) -> +dojox.gfx.matrix.Matrix2D","!doc":"inverts a 2D matrix"},"_multiplyPoint":{"!type":"fn(matrix: +dojox.gfx.matrix.Matrix2D, x: number, y: number) -> +dojox.gfx.Point","!doc":"applies a matrix to a point"},"multiply":{"!type":"fn(matrix: +dojox.gfx.matrix.Matrix2D) -> +dojox.gfx.matrix.Matrix2D","!doc":"combines matrices by multiplying them sequentially in the given order"},"_sandwich":{"!type":"fn(matrix: +dojox.gfx.matrix.Matrix2D, x: number, y: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"applies a matrix at a centrtal point"},"scaleAt":{"!type":"fn(a: number, b: number, c: number, d: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"scales a picture using a specified point as a center of scaling"},"rotateAt":{"!type":"fn(angle: number, a: number, b: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"rotates a picture using a specified point as a center of rotation"},"rotategAt":{"!type":"fn(degree: number, a: number, b: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"rotates a picture using a specified point as a center of rotation"},"skewXAt":{"!type":"fn(angle: number, a: number, b: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"skews a picture along the x axis using a specified point as a center of skewing"},"skewXgAt":{"!type":"fn(degree: number, a: number, b: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"skews a picture along the x axis using a specified point as a center of skewing"},"skewYAt":{"!type":"fn(angle: number, a: number, b: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"skews a picture along the y axis using a specified point as a center of skewing"},"skewYgAt":{"!type":"fn(degree: number, a: number, b: number) -> +dojox.gfx.matrix.Matrix2D","!doc":"skews a picture along the y axis using a specified point as a center of skewing"},"_degToRad":{"!type":"fn(degree: ?)"},"_radToDeg":{"!type":"fn(radian: ?)"},"Matrix2D":{"!type":"fn(arg: ?)","!doc":"a 2D matrix object"}},"Moveable":{"!type":"fn()","prototype":{"!doc":"an object, which makes a shape moveable\nshape: dojox.gfx.Shape: a shape object to be moved\nparams: Object: an optional object with additional parameters;\nfollowing parameters are recognized:\ndelay: Number: delay move by this number of pixels\nmover: Object: a constructor of custom Mover","constructor":{"!type":"fn(shape: +dojox.gfx.Shape, params: +Object)","!doc":"an object, which makes a shape moveable"},"destroy":{"!type":"fn()","!doc":"stops watching for possible move, deletes all references, so the object can be garbage-collected"},"onMouseDown":{"!type":"fn(e: +Event)","!doc":"event processor for onmousedown, creates a Mover for the shape"},"onMouseMove":{"!type":"fn(e: +Event)","!doc":"event processor for onmousemove, used only for delayed drags"},"onMouseUp":{"!type":"fn(e: +Event)","!doc":"event processor for onmouseup, used only for delayed delayed drags"},"onMoveStart":{"!type":"fn(mover: +dojox.gfx.Mover)","!doc":"called before every move operation"},"onMoveStop":{"!type":"fn(mover: +dojox.gfx.Mover)","!doc":"called after every move operation"},"onFirstMove":{"!type":"fn(mover: +dojox.gfx.Mover)","!doc":"called during the very first move notification,\ncan be used to initialize coordinates, can be overwritten."},"onMove":{"!type":"fn(mover: +dojox.gfx.Mover, shift: ?)","!doc":"called during every move notification,\nshould actually move the node, can be overwritten."},"onMoving":{"!type":"fn(mover: +dojox.gfx.Mover, shift: ?)","!doc":"called before every incremental move,\ncan be overwritten."},"onMoved":{"!type":"fn(mover: +dojox.gfx.Mover, shift: ?)","!doc":"called after every incremental move,\ncan be overwritten."}}},"Mover":{"!type":"fn()","prototype":{"!doc":"an object, which makes a shape follow the mouse,\nused as a default mover, and as a base class for custom movers\nshape: dojox.gfx.Shape: a shape object to be moved\ne: Event: a mouse event, which started the move;\nonly clientX and clientY properties are used\nhost: Object?: object which implements the functionality of the move,\nand defines proper events (onMoveStart and onMoveStop)","constructor":{"!type":"fn(shape: +dojox.gfx.Shape, e: +Event, host?: +Object)","!doc":"an object, which makes a shape follow the mouse,\nused as a default mover, and as a base class for custom movers"},"onMouseMove":{"!type":"fn(e: +Event)","!doc":"event processor for onmousemove"},"onFirstMove":{"!type":"fn()","!doc":"it is meant to be called only once"},"destroy":{"!type":"fn()","!doc":"stops the move, deletes all references, so the object can be garbage-collected"}}},"vectorFontFitting":{"NONE":{"!type":"number"},"FLOW":{"!type":"number"},"FIT":{"!type":"number"}},"defaultVectorText":{"type":{"!type":"string"},"x":{"!type":"number"},"y":{"!type":"number"},"width":{},"height":{},"text":{"!type":"string"},"align":{"!type":"string"},"decoration":{"!type":"string"},"fitting":{"!type":"number"},"leading":{"!type":"number"}},"defaultVectorFont":{"type":{"!type":"string"},"size":{"!type":"string"},"family":{}},"VectorFont":{"!type":"fn()","prototype":{"!doc":"Create this font object based on the SVG Font definition at url.","_entityRe":{"!type":"+RegExp"},"_decodeEntitySequence":{"!type":"fn(str: ?) -> +undefined"},"_parse":{"!type":"fn(svg: string, url: string)","!doc":"Take the loaded SVG Font definition file and convert the info\ninto things we can use. The SVG Font definition must follow\nthe SVG 1.1 Font specification."},"_clean":{"!type":"fn()","!doc":"Clean off all of the given mixin parameters."},"constructor":{"!type":"fn(url: string)","!doc":"Create this font object based on the SVG Font definition at url."},"load":{"!type":"fn(url: string) -> +dojox.gfx.VectorFont","!doc":"Load the passed SVG and send it to the parser for parsing."},"initialized":{"!type":"fn() -> bool","!doc":"Return if we've loaded a font def, and the parsing was successful."},"_round":{"!type":"fn(n: ?)"},"_leading":{"!type":"fn(unit: ?)"},"_normalize":{"!type":"fn(str: ?)"},"_getWidth":{"!type":"fn(glyphs: ?)"},"_getLongestLine":{"!type":"fn(lines: ?)"},"_trim":{"!type":"fn(lines: ?)"},"_split":{"!type":"fn(chars: ?, nLines: ?)","!doc":"split passed chars into nLines by finding the closest whitespace."},"_getSizeFactor":{"!type":"fn(size: ?)"},"_getFitFactor":{"!type":"fn(lines: ?, w: ?, h: ?, l: ?)","!doc":"Find the scaling factor for the given phrase set."},"_getBestFit":{"!type":"fn(chars: ?, w: ?, h: ?, ldng: ?)","!doc":"Get the best number of lines to return given w and h."},"_getBestFlow":{"!type":"fn(chars: ?, w: ?, scale: ?)","!doc":"Based on the given scale, do the best line splitting possible."},"getWidth":{"!type":"fn(text: string, scale?: +Float)","!doc":"Get the width of the rendered text without actually rendering it."},"getLineHeight":{"!type":"fn(scale?: +Float) -> +Float","!doc":"return the height of a single line, sans leading, based on scale."},"getCenterline":{"!type":"fn(scale?: +Float)","!doc":"return the y coordinate that is the center of the viewbox."},"getBaseline":{"!type":"fn(scale?: +Float) -> +Float","!doc":"Find the baseline coord for alignment; adjust for scale if passed."},"draw":{"!type":"fn(group: +dojox.gfx.Container, textArgs: +dojox.gfx.__TextArgs, fontArgs: +dojox.gfx.__FontArgs, fillArgs: +dojox.gfx.__FillArgs, strokeArgs?: +dojox.gfx.__StrokeArgs) -> +dojox.gfx.Group","!doc":"based on the passed parameters, draw the given text using paths\ndefined by this font."},"onLoadBegin":{"!type":"fn(url: string)"},"onLoad":{"!type":"fn(font: +dojox.gfx.VectorFont)"}}},"defaultPath":{"type":{"!type":"string"},"path":{"!type":"string"}},"defaultPolyline":{"type":{"!type":"string"},"points":{"!type":"[]"}},"defaultRect":{"type":{"!type":"string"},"x":{"!type":"number"},"y":{"!type":"number"},"width":{"!type":"number"},"height":{"!type":"number"},"r":{"!type":"number"}},"defaultEllipse":{"type":{"!type":"string"},"cx":{"!type":"number"},"cy":{"!type":"number"},"rx":{"!type":"number"},"ry":{"!type":"number"}},"defaultCircle":{"type":{"!type":"string"},"cx":{"!type":"number"},"cy":{"!type":"number"},"r":{"!type":"number"}},"defaultLine":{"type":{"!type":"string"},"x1":{"!type":"number"},"y1":{"!type":"number"},"x2":{"!type":"number"},"y2":{"!type":"number"}},"defaultImage":{"type":{"!type":"string"},"x":{"!type":"number"},"y":{"!type":"number"},"width":{"!type":"number"},"height":{"!type":"number"},"src":{"!type":"string"}},"defaultText":{"type":{"!type":"string"},"x":{"!type":"number"},"y":{"!type":"number"},"text":{"!type":"string"},"align":{"!type":"string"},"decoration":{"!type":"string"},"rotated":{"!type":"bool"},"kerning":{"!type":"bool"}},"defaultTextPath":{"type":{"!type":"string"},"text":{"!type":"string"},"align":{"!type":"string"},"decoration":{"!type":"string"},"rotated":{"!type":"bool"},"kerning":{"!type":"bool"}},"defaultStroke":{"type":{"!type":"string"},"color":{"!type":"string"},"style":{"!type":"string"},"width":{"!type":"number"},"cap":{"!type":"string"},"join":{"!type":"number"}},"defaultLinearGradient":{"type":{"!type":"string"},"x1":{"!type":"number"},"y1":{"!type":"number"},"x2":{"!type":"number"},"y2":{"!type":"number"},"colors":{"!type":"[]"}},"defaultRadialGradient":{"type":{"!type":"string"},"cx":{"!type":"number"},"cy":{"!type":"number"},"r":{"!type":"number"},"colors":{"!type":"[]"}},"defaultPattern":{"type":{"!type":"string"},"x":{"!type":"number"},"y":{"!type":"number"},"width":{"!type":"number"},"height":{"!type":"number"},"src":{"!type":"string"}},"defaultFont":{"type":{"!type":"string"},"style":{"!type":"string"},"variant":{"!type":"string"},"weight":{"!type":"string"},"size":{"!type":"string"},"family":{"!type":"string"}},"_base":{"_getFontMeasurements":{"!type":"fn() -> ?","!doc":"Returns an object that has pixel equivilents of standard font\nsize values."},"_getCachedFontMeasurements":{"!type":"fn(recalculate: ?)"},"_getTextBox":{"!type":"fn(text: string, style: ?, className?: string)"},"_getUniqueId":{"!type":"fn()","!doc":"returns a unique string for use with any DOM element"}},"arc":{"unitArcAsBezier":{},"curvePI4":{},"arcAsBezier":{"!type":"fn(last: +Object, rx: number, ry: number, xRotg: number, large: bool, sweep: bool, x: number, y: number) -> ?","!doc":"calculates an arc as a series of Bezier curves\ngiven the last point and a standard set of SVG arc parameters,\nit returns an array of arrays of parameters to form a series of\nabsolute Bezier curves."}},"shape":{"Creator":{"!doc":"shape creators","createObject":{"!type":"fn(shapeType: fn(), rawShape: +Object) -> +dojox.gfx.Shape","!doc":"creates an instance of the passed shapeType class"},"createShape":{"!type":"fn(shape: +Object)","!doc":"creates a shape object based on its type; it is meant to be used\nby group-like objects"},"createGroup":{"!type":"fn() -> +dojox.gfx.Group","!doc":"creates a VML group shape"},"createRect":{"!type":"fn(rect: +Object) -> +dojox.gfx.Rect","!doc":"creates a rectangle shape"},"createEllipse":{"!type":"fn(ellipse: +Object) -> +dojox.gfx.Ellipse","!doc":"creates an ellipse shape"},"createCircle":{"!type":"fn(circle: +Object) -> +dojox.gfx.Circle","!doc":"creates a circle shape"},"createLine":{"!type":"fn(line: +Object) -> +dojox.gfx.Line","!doc":"creates a line shape"},"createPolyline":{"!type":"fn(points: +Object) -> +dojox.gfx.Polyline","!doc":"creates a polyline/polygon shape"},"createImage":{"!type":"fn(image: +Object) -> +dojox.gfx.Image","!doc":"creates a VML image shape"},"createText":{"!type":"fn(text: +Object) -> +dojox.gfx.Text","!doc":"creates a text shape"},"createPath":{"!type":"fn(path: +Object) -> +dojox.gfx.Path","!doc":"creates a path shape"},"createTextPath":{"!type":"fn(text: +Object) -> +dojox.gfx.TextPath","!doc":"creates a text shape"},"_overrideSize":{"!type":"fn(node: ?)"}},"Surface":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.shape._eventsProcessing.prototype","!doc":"a surface object to be used for drawings","isLoaded":{"!type":"bool"},"constructor":{"!type":"fn()"},"destroy":{"!type":"fn()","!doc":"destroy all relevant external resources and release all\nexternal references to make this object garbage-collectible"},"getEventSource":{"!type":"fn() -> +Node","!doc":"returns a node, which can be used to attach event listeners"},"_getRealMatrix":{"!type":"fn() -> +dojox.gfx.Matrix2D","!doc":"always returns the identity matrix"},"onLoad":{"!type":"fn(surface: +dojox.gfx.Surface)","!doc":"local event, fired once when the surface is created\nasynchronously, used only when isLoaded is false, required\nonly for Silverlight."},"whenLoaded":{"!type":"fn(context?: ?, method: fn())"}}},"Rect":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.Shape.prototype","!doc":"a generic rectangle","constructor":{"!type":"fn(rawNode: +Node)"},"getBoundingBox":{"!type":"fn() -> +dojox.gfx.Rectangle","!doc":"returns the bounding box (its shape in this case)"}}},"Ellipse":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.Shape.prototype","!doc":"a generic ellipse","constructor":{"!type":"fn(rawNode: +Node)"},"getBoundingBox":{"!type":"fn() -> +dojox.gfx.Rectangle","!doc":"returns the bounding box"}}},"Circle":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.Shape.prototype","!doc":"a generic circle\n(this is a helper object, which is defined for convenience)","constructor":{"!type":"fn(rawNode: +Node)"},"getBoundingBox":{"!type":"fn() -> +dojox.gfx.Rectangle","!doc":"returns the bounding box"}}},"Line":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.Shape.prototype","!doc":"a generic line\n(this is a helper object, which is defined for convenience)","constructor":{"!type":"fn(rawNode: +Node)"},"getBoundingBox":{"!type":"fn() -> +dojox.gfx.Rectangle","!doc":"returns the bounding box"}}},"Polyline":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.Shape.prototype","!doc":"a generic polyline/polygon\n(this is a helper object, which is defined for convenience)","constructor":{"!type":"fn(rawNode: +Node)"},"setShape":{"!type":"fn(points: +Object, closed: bool) -> +self","!doc":"sets a polyline/polygon shape object"},"getBoundingBox":{"!type":"fn() -> +dojox.gfx.Rectangle","!doc":"returns the bounding box"}}},"Image":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.Shape.prototype","!doc":"a generic image\n(this is a helper object, which is defined for convenience)","constructor":{"!type":"fn(rawNode: +Node)"},"getBoundingBox":{"!type":"fn() -> +dojox.gfx.Rectangle","!doc":"returns the bounding box (its shape in this case)"},"setStroke":{"!type":"fn() -> +self","!doc":"ignore setting a stroke style"},"setFill":{"!type":"fn() -> +self","!doc":"ignore setting a fill style"}}},"Text":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.Shape.prototype","!doc":"a generic text","constructor":{"!type":"fn(rawNode: +Node)"},"getFont":{"!type":"fn() -> ?","!doc":"returns the current font object or null"},"setFont":{"!type":"fn(newFont: +Object) -> +self","!doc":"sets a font for text"}}},"_eventsProcessing":{"connect":{"!type":"fn(name: ?, object: ?, method: ?) -> ?","!doc":"connects a handler to an event on this shape"},"disconnect":{"!type":"fn(token: ?)","!doc":"connects a handler by token from an event on this shape"}},"Container":{"!doc":"a container of shapes, which can be used\nas a foundation for renderer-specific groups, or as a way\nto logically group shapes (e.g, to propagate matricies)","_init":{"!type":"fn()"},"add":{"!type":"fn(shape: +dojox.gfx.Shape) -> +self","!doc":"adds a shape to the list"},"remove":{"!type":"fn(shape: ?, silently?: bool) -> +self","!doc":"removes a shape from the list"},"clear":{"!type":"fn() -> +self","!doc":"removes all shapes from a group/surface"},"_moveChildToFront":{"!type":"fn(shape: ?) -> +self","!doc":"moves a shape to front of the list of shapes"},"_moveChildToBack":{"!type":"fn(shape: ?) -> +self","!doc":"moves a shape to back of the list of shapes"}}},"Shape":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.shape._eventsProcessing.prototype","!doc":"a Shape object, which knows how to apply\ngraphical attributes and transformations","_render":{"!type":"fn(ctx: ?)","!doc":"render the shape"},"_renderTransform":{"!type":"fn(ctx: ?)"},"_renderShape":{"!type":"fn(ctx: ?)"},"_renderFill":{"!type":"fn(ctx: ?, apply: bool)"},"_renderStroke":{"!type":"fn(ctx: ?, apply: bool)"},"getEventSource":{"!type":"fn() -> +Node","!doc":"returns a Node, which is used as\na source of events for this shape"},"connect":{"!type":"fn()"},"disconnect":{"!type":"fn()"},"constructor":{"!type":"fn()"},"getNode":{"!type":"fn() -> +Node","!doc":"returns the current DOM Node or null"},"getShape":{"!type":"fn() -> ?","!doc":"returns the current shape object or null\n(see dojox.gfx.defaultPath,\ndojox.gfx.defaultPolyline,\ndojox.gfx.defaultRect,\ndojox.gfx.defaultEllipse,\ndojox.gfx.defaultCircle,\ndojox.gfx.defaultLine,\nor dojox.gfx.defaultImage)"},"getTransform":{"!type":"fn() -> +dojox.gfx.Matrix2D","!doc":"returns the current transformation matrix or null"},"getFill":{"!type":"fn() -> ?","!doc":"returns the current fill object or null\n(see dojox.gfx.defaultLinearGradient,\ndojox.gfx.defaultRadialGradient,\ndojox.gfx.defaultPattern,\nor dojo.Color)"},"getStroke":{"!type":"fn() -> ?","!doc":"returns the current stroke object or null\n(see dojox.gfx.defaultStroke)"},"getParent":{"!type":"fn() -> ?","!doc":"returns the parent or null\n(see dojox.gfx.Surface,\ndojox.gfx.shape.VirtualGroup,\nor dojox.gfx.Group)"},"getBoundingBox":{"!type":"fn() -> +dojox.gfx.Rectangle","!doc":"returns the bounding box or null\n(see dojox.gfx.defaultRect)"},"getTransformedBoundingBox":{"!type":"fn() -> +null","!doc":"returns an array of four points or null\nfour points represent four corners of the untransformed bounding box"},"setShape":{"!type":"fn(shape: +Object) -> +self","!doc":"sets a shape object (SVG)"},"setFill":{"!type":"fn(fill: +Object) -> +self","!doc":"sets a fill object (VML)"},"setStroke":{"!type":"fn(stroke: +Object) -> +self","!doc":"sets a stroke object (VML)"},"setTransform":{"!type":"fn(matrix: +dojox.gfx.Matrix2D) -> +self","!doc":"sets a transformation matrix"},"_applyTransform":{"!type":"fn() -> +self","!doc":"physically sets a matrix"},"moveToFront":{"!type":"fn() -> +self","!doc":"moves a shape to front of its parent's list of shapes"},"moveToBack":{"!type":"fn()","!doc":"moves a shape to back of its parent's list of shapes"},"_moveToFront":{"!type":"fn() -> +self","!doc":"moves a shape to front of its parent's list of shapes (VML)"},"_moveToBack":{"!type":"fn() -> +self","!doc":"moves a shape to back of its parent's list of shapes (VML)"},"applyRightTransform":{"!type":"fn(matrix: +dojox.gfx.Matrix2D) -> +self","!doc":"multiplies the existing matrix with an argument on right side\n(this.matrix * matrix)"},"applyLeftTransform":{"!type":"fn(matrix: +dojox.gfx.Matrix2D) -> +self","!doc":"multiplies the existing matrix with an argument on left side\n(matrix * this.matrix)"},"applyTransform":{"!type":"fn(matrix: +dojox.gfx.Matrix2D) -> +self","!doc":"a shortcut for dojox.gfx.Shape.applyRightTransform"},"removeShape":{"!type":"fn(silently?: bool) -> +self","!doc":"removes the shape from its parent's list of shapes"},"_setParent":{"!type":"fn(parent: +Object, matrix: +dojox.gfx.Matrix2D) -> +self","!doc":"sets a parent"},"_updateParentMatrix":{"!type":"fn(matrix: +dojox.gfx.Matrix2D) -> +self","!doc":"updates the parent matrix with new matrix"},"_getRealMatrix":{"!type":"fn() -> +dojox.gfx.Matrix2D","!doc":"returns the cumulative (&quot;real&quot;) transformation matrix\nby combining the shape's matrix with its parent's matrix"},"_setFillAttr":{"!type":"fn(f: ?)"},"_getParentSurface":{"!type":"fn()"},"setRawNode":{"!type":"fn(rawNode: ?)","!doc":"assigns and clears the underlying node that will represent this\nshape. Once set, transforms, gradients, etc, can be applied.\n(no fill &amp; stroke by default)"},"_getAdjustedMatrix":{"!type":"fn() -> +dojox.gfx.Matrix2D","!doc":"returns the adjusted (&quot;real&quot;) transformation matrix"},"_setFillObject":{"!type":"fn(f: ?, nodeType: ?)"},"_translate":{"!type":"fn(dict: ?, value: ?)"},"_setDimensions":{"!type":"fn(width: string, height: string) -> +self","!doc":"sets the width and height of the rawNode,\nif the surface sixe has been changed"}},"_capMap":{"butt":{"!type":"string"}},"_capMapReversed":{"flat":{"!type":"string"}}},"Group":{"!type":"fn()","prototype":{"!proto":"Container.prototype","!doc":"a group shape (VML), which can be used\nto logically group shapes (e.g, to propagate matricies)\n\n\napply transformation","constructor":{"!type":"fn()"},"_render":{"!type":"fn(ctx: ?)","!doc":"render the group"},"setRawNode":{"!type":"fn(rawNode: +Node)","!doc":"sets a raw SVG node to be used by this shape"},"_applyTransform":{"!type":"fn() -> +self","!doc":"applies a transformation matrix to a group"},"_setDimensions":{"!type":"fn(width: string, height: string) -> +self","!doc":"sets the width and height of the rawNode,\nif the surface sixe has been changed"}},"nodeType":{"!type":"string"}},"Surface":{"!type":"fn()","prototype":{"!proto":"Container.prototype","!doc":"a surface object to be used for drawings (VML)","constructor":{"!type":"fn()"},"setDimensions":{"!type":"fn(width: string, height: string) -> +self","!doc":"sets the width and height of the rawNode"},"getDimensions":{"!type":"fn() -> ?","!doc":"returns an object with properties &quot;width&quot; and &quot;height&quot;"},"_render":{"!type":"fn()","!doc":"render the all shapes"},"makeDirty":{"!type":"fn()","!doc":"internal method, which is called when we may need to redraw"},"downloadImage":{"!type":"fn(img: +Image, url: string)","!doc":"internal method, which starts an image download and renders, when it is ready"},"onImageLoad":{"!type":"fn()"},"getEventSource":{"!type":"fn()"},"connect":{"!type":"fn()"},"disconnect":{"!type":"fn()"},"destroy":{"!type":"fn()"},"createViewport":{"!type":"fn()"}}},"Rect":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.shape.Rect.prototype","!doc":"a rectangle shape (VML)","_renderShape":{"!type":"fn(ctx: ?)"},"setShape":{"!type":"fn(newShape: +Object) -> +self","!doc":"sets a rectangle shape object (VML)"},"_getAdjustedMatrix":{"!type":"fn() -> +dojox.gfx.Matrix2D","!doc":"returns the adjusted (&quot;real&quot;) transformation matrix"}},"nodeType":{"!type":"string"}},"Ellipse":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.shape.Ellipse.prototype","!doc":"an ellipse shape (VML)","setShape":{"!type":"fn(newShape: +Object) -> +self","!doc":"sets an ellipse shape object (VML)"},"_renderShape":{"!type":"fn(ctx: ?)"},"_getAdjustedMatrix":{"!type":"fn() -> +dojox.gfx.Matrix2D","!doc":"returns the adjusted (&quot;real&quot;) transformation matrix"}},"nodeType":{"!type":"string"}},"Circle":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.shape.Circle.prototype","!doc":"a circle shape (VML)","_renderShape":{"!type":"fn(ctx: ?)"},"setShape":{"!type":"fn(newShape: +Object) -> +self","!doc":"sets a circle shape object (VML)"},"_getAdjustedMatrix":{"!type":"fn() -> +dojox.gfx.Matrix2D","!doc":"returns the adjusted (&quot;real&quot;) transformation matrix"}},"nodeType":{"!type":"string"}},"Line":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.shape.Line.prototype","!doc":"a line shape (VML)","_renderShape":{"!type":"fn(ctx: ?)"},"setShape":{"!type":"fn(newShape: +Object) -> +self","!doc":"sets a line shape object (VML)"},"constructor":{"!type":"fn(rawNode: ?)"}},"nodeType":{"!type":"string"}},"Polyline":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.shape.Polyline.prototype","!doc":"a polyline/polygon shape (VML)","setShape":{"!type":"fn(points: +Object, closed: bool) -> +self","!doc":"sets a polyline/polygon shape object (VML)"},"_renderShape":{"!type":"fn(ctx: ?)"},"constructor":{"!type":"fn(rawNode: ?)"}},"nodeType":{"!type":"string"}},"Image":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.shape.Image.prototype","!doc":"an image (VML)","setShape":{"!type":"fn(newShape: +Object) -> +self","!doc":"sets an image shape object (VML)"},"_renderShape":{"!type":"fn(ctx: ?)"},"_getAdjustedMatrix":{"!type":"fn() -> +dojox.gfx.Matrix2D","!doc":"returns the adjusted (&quot;real&quot;) transformation matrix"},"setRawNode":{"!type":"fn(rawNode: ?)","!doc":"assigns and clears the underlying node that will represent this\nshape. Once set, transforms, gradients, etc, can be applied.\n(no fill &amp; stroke by default)"},"_applyTransform":{"!type":"fn() -> +self"},"_setDimensions":{"!type":"fn(width: string, height: string) -> +self","!doc":"sets the width and height of the rawNode,\nif the surface sixe has been changed"}},"nodeType":{"!type":"string"}},"Text":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.shape.Text.prototype","!doc":"an anchored text (VML)","_renderShape":{"!type":"fn(ctx: ?)"},"setShape":{"!type":"fn(newShape: +Object) -> +self","!doc":"sets a text shape object (VML)"},"_delayAlignment":{"!type":"fn()"},"_getAdjustedMatrix":{"!type":"fn()","!doc":"returns the adjusted (&quot;real&quot;) transformation matrix"},"setStroke":{"!type":"fn() -> +self","!doc":"ignore setting a stroke style"},"_setFillAttr":{"!type":"fn(f: ?)"},"setRawNode":{"!type":"fn(rawNode: ?)","!doc":"assigns and clears the underlying node that will represent this\nshape. Once set, transforms, gradients, etc, can be applied.\n(no fill &amp; stroke by default)"},"getTextWidth":{"!type":"fn()","!doc":"get the text width, in px"},"constructor":{"!type":"fn(rawNode: ?)"},"_setFont":{"!type":"fn()","!doc":"sets a font object (VML)"},"_getRealMatrix":{"!type":"fn() -> +dojox.gfx.Matrix2D","!doc":"returns the cumulative (&quot;real&quot;) transformation matrix\nby combining the shape's matrix with its parent's matrix;\nit makes a correction for a font size"}},"nodeType":{"!type":"string"},"_alignment":{"start":{"!type":"string"},"middle":{"!type":"string"},"end":{"!type":"string"}}},"Path":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.path.Path.prototype","!doc":"a path shape (VML)\n\n\nVML-specific segment renderers","constructor":{"!type":"fn(rawNode: ?)"},"setShape":{"!type":"fn(newShape: +Object) -> +self","!doc":"forms a path using a shape (VML)"},"_updateWithSegment":{"!type":"fn(segment: +Object)","!doc":"updates the bounding box of path with new segment"},"_renderShape":{"!type":"fn(ctx: ?)"},"_moveToA":{"!type":"fn(result: ?, action: ?, args: ?)"},"_moveToR":{"!type":"fn(result: ?, action: ?, args: ?)"},"_lineToA":{"!type":"fn(result: ?, action: ?, args: ?)"},"_lineToR":{"!type":"fn(result: ?, action: ?, args: ?)"},"_hLineToA":{"!type":"fn(result: ?, action: ?, args: ?)"},"_hLineToR":{"!type":"fn(result: ?, action: ?, args: ?)"},"_vLineToA":{"!type":"fn(result: ?, action: ?, args: ?)"},"_vLineToR":{"!type":"fn(result: ?, action: ?, args: ?)"},"_curveToA":{"!type":"fn(result: ?, action: ?, args: ?)"},"_curveToR":{"!type":"fn(result: ?, action: ?, args: ?)"},"_smoothCurveToA":{"!type":"fn(result: ?, action: ?, args: ?)"},"_smoothCurveToR":{"!type":"fn(result: ?, action: ?, args: ?)"},"_qCurveToA":{"!type":"fn(result: ?, action: ?, args: ?)"},"_qCurveToR":{"!type":"fn(result: ?, action: ?, args: ?)"},"_qSmoothCurveToA":{"!type":"fn(result: ?, action: ?, args: ?)"},"_qSmoothCurveToR":{"!type":"fn(result: ?, action: ?, args: ?)"},"_arcTo":{"!type":"fn(result: ?, action: ?, args: ?)"},"_closePath":{"!type":"fn(result: ?, action: ?, args: ?)"},"_addArgs":{"!type":"fn(path: ?, segment: ?, from: ?, upto: ?)"},"_adjustRelCrd":{"!type":"fn(last: ?, segment: ?, step: ?)"},"_adjustRelPos":{"!type":"fn(last: ?, segment: ?)"}},"nodeType":{"!type":"string"},"_pathVmlToSvgMap":{"m":{"!type":"string"},"l":{"!type":"string"},"t":{"!type":"string"},"r":{"!type":"string"},"c":{"!type":"string"},"v":{"!type":"string"},"qb":{"!type":"string"},"x":{"!type":"string"},"e":{"!type":"string"}},"renderers":{"M":{"!type":"string"},"m":{"!type":"string"},"L":{"!type":"string"},"l":{"!type":"string"},"H":{"!type":"string"},"h":{"!type":"string"},"V":{"!type":"string"},"v":{"!type":"string"},"C":{"!type":"string"},"c":{"!type":"string"},"S":{"!type":"string"},"s":{"!type":"string"},"Q":{"!type":"string"},"q":{"!type":"string"},"T":{"!type":"string"},"t":{"!type":"string"},"A":{"!type":"string"},"a":{"!type":"string"},"Z":{"!type":"string"},"z":{"!type":"string"}}},"TextPath":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.path.TextPath.prototype","!doc":"a textpath shape (VML)","_renderShape":{"!type":"fn(ctx: ?)"},"_updateWithSegment":{"!type":"fn(segment: +Object)","!doc":"updates the bounding box of path with new segment"},"setShape":{"!type":"fn(newShape: +Object) -> +self","!doc":"forms a path using a shape (SVG)"},"_setText":{"!type":"fn()","!doc":"sets a text shape object (VML)"},"_setTextPath":{"!type":"fn()"},"constructor":{"!type":"fn(rawNode: ?)"},"setText":{"!type":"fn(newText: ?) -> +self","!doc":"sets a text to be drawn along the path"},"setFont":{"!type":"fn(newFont: ?) -> +self","!doc":"sets a font for text"},"_setFont":{"!type":"fn()","!doc":"sets a font object (VML)"}},"nodeType":{"!type":"string"}},"fx":{"animateStroke":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation which will change stroke properties over time"},"animateFill":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation which will change fill color over time.\nOnly solid fill color is supported at the moment"},"animateFont":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation which will change font properties over time"},"animateTransform":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation which will change transformation over time"}},"path":{"_calcArc":{"!type":"fn(alpha: ?)"},"Path":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.Shape.prototype","!doc":"a generalized path shape","_2PI":{"!type":"number"},"constructor":{"!type":"fn(rawNode: +Node)","!doc":"a path constructor"},"setAbsoluteMode":{"!type":"fn(mode: bool) -> +self","!doc":"sets an absolute or relative mode for path points"},"getAbsoluteMode":{"!type":"fn() -> bool","!doc":"returns a current value of the absolute mode"},"getBoundingBox":{"!type":"fn() -> +dojox.gfx.Rectangle","!doc":"returns the bounding box {x, y, width, height} or null"},"getLastPosition":{"!type":"fn() -> ?","!doc":"returns the last point in the path, or null"},"_updateBBox":{"!type":"fn(x: number, y: number)","!doc":"updates the bounding box of path with new point"},"_updateWithSegment":{"!type":"fn(segment: +Object)","!doc":"updates the bounding box of path with new segment"},"_pushSegment":{"!type":"fn(action: string, args: [])","!doc":"adds a segment"},"_collectArgs":{"!type":"fn(array: [], args: [])","!doc":"converts an array of arguments to plain numeric values"},"moveTo":{"!type":"fn() -> +self","!doc":"formes a move segment"},"lineTo":{"!type":"fn() -> +self","!doc":"formes a line segment"},"hLineTo":{"!type":"fn() -> +self","!doc":"formes a horizontal line segment"},"vLineTo":{"!type":"fn() -> +self","!doc":"formes a vertical line segment"},"curveTo":{"!type":"fn() -> +self","!doc":"formes a curve segment"},"smoothCurveTo":{"!type":"fn() -> +self","!doc":"formes a smooth curve segment"},"qCurveTo":{"!type":"fn() -> +self","!doc":"formes a quadratic curve segment"},"qSmoothCurveTo":{"!type":"fn() -> +self","!doc":"formes a quadratic smooth curve segment"},"arcTo":{"!type":"fn() -> +self","!doc":"formes an elliptic arc segment"},"closePath":{"!type":"fn() -> +self","!doc":"closes a path"},"_setPath":{"!type":"fn(path: string)","!doc":"forms a path using an SVG path string"},"setShape":{"!type":"fn(newShape: +Object) -> +self","!doc":"forms a path using a shape"}},"_validSegments":{"m":{"!type":"number"},"l":{"!type":"number"},"h":{"!type":"number"},"v":{"!type":"number"},"c":{"!type":"number"},"s":{"!type":"number"},"q":{"!type":"number"},"t":{"!type":"number"},"a":{"!type":"number"},"z":{"!type":"number"}}},"TextPath":{"!type":"fn()","prototype":{"!proto":"dojox.gfx.path.Path.prototype","!doc":"a generalized TextPath shape","constructor":{"!type":"fn(rawNode: +Node)","!doc":"a TextPath shape constructor"},"getText":{"!type":"fn() -> ?","!doc":"returns the current text object or null"},"setText":{"!type":"fn(newText: ?) -> +self","!doc":"sets a text to be drawn along the path"},"getFont":{"!type":"fn() -> ?","!doc":"returns the current font object or null"},"setFont":{"!type":"fn(newFont: ?) -> +self","!doc":"sets a font for text"}}}},"Point":{"!type":"fn()","prototype":{"!doc":"a hypothetical 2D point to be used for drawings - {x, y}"}},"Rectangle":{"!type":"fn()","prototype":{"!doc":"a hypothetical rectangle - {x, y, width, height}"}},"silverlight":{"surfaces":{},"hexColor":{"!type":"fn(color: string) -> string","!doc":"converts a color object to a Silverlight hex color string (#aarrggbb)"},"nullFunc":{"!type":"fn()"},"dasharray":{"solid":{"!type":"string"},"shortdash":{"!type":"[]"},"shortdot":{"!type":"[]"},"shortdashdot":{"!type":"[]"},"shortdashdotdot":{"!type":"[]"},"dot":{"!type":"[]"},"dash":{"!type":"[]"},"longdash":{"!type":"[]"},"dashdot":{"!type":"[]"},"longdashdot":{"!type":"[]"},"longdashdotdot":{"!type":"[]"}},"fontweight":{"normal":{"!type":"number"},"bold":{"!type":"number"}},"caps":{"butt":{"!type":"string"},"round":{"!type":"string"},"square":{"!type":"string"}},"joins":{"bevel":{"!type":"string"},"round":{"!type":"string"}},"fonts":{"serif":{"!type":"string"},"times":{"!type":"string"},"sans-serif":{"!type":"string"},"helvetica":{"!type":"string"},"monotone":{"!type":"string"},"courier":{"!type":"string"}},"Font":{"_setFont":{"!type":"fn()","!doc":"sets a font object (Silverlight)"}},"Container":{"_moveChildToFront":{},"_moveChildToBack":{},"_init":{"!type":"fn()"},"add":{"!type":"fn(shape: +dojox.gfx.Shape) -> +self","!doc":"adds a shape to a group/surface"},"remove":{"!type":"fn(shape: +dojox.gfx.Shape, silently?: bool) -> +self","!doc":"remove a shape from a group/surface"},"clear":{"!type":"fn()","!doc":"removes all shapes from a group/surface"}}},"svg":{"getRef":{"!type":"fn(name: string) -> +Node","!doc":"returns a DOM Node specified by the name argument or null"},"xmlns":{"xlink":{"!type":"string"},"svg":{"!type":"string"}},"dasharray":{"solid":{"!type":"string"},"shortdash":{"!type":"[]"},"shortdot":{"!type":"[]"},"shortdashdot":{"!type":"[]"},"shortdashdotdot":{"!type":"[]"},"dot":{"!type":"[]"},"dash":{"!type":"[]"},"longdash":{"!type":"[]"},"dashdot":{"!type":"[]"},"longdashdot":{"!type":"[]"},"longdashdotdot":{"!type":"[]"}},"Font":{"_setFont":{"!type":"fn()","!doc":"sets a font object (SVG)"}},"Container":{"_moveChildToFront":{},"_moveChildToBack":{},"_init":{"!type":"fn()"},"add":{"!type":"fn(shape: +dojox.gfx.Shape) -> +self","!doc":"adds a shape to a group/surface"},"remove":{"!type":"fn(shape: +dojox.gfx.Shape, silently?: bool) -> +self","!doc":"remove a shape from a group/surface"},"clear":{"!type":"fn()","!doc":"removes all shapes from a group/surface"}}},"utils":{"forEach":{"!type":"fn(object: +dojox.gfx.Surface, f: fn(), o?: ?)"},"serialize":{"!type":"fn(object: +dojox.gfx.Surface) -> []"},"toJson":{"!type":"fn(object: +dojox.gfx.Surface, prettyPrint?: bool) -> string"},"deserialize":{"!type":"fn(parent: +dojox.gfx.Surface, object: +dojox.gfx.Shape) -> []"},"fromJson":{"!type":"fn(parent: +dojox.gfx.Surface, json: string) -> []"}},"vml":{"xmlns":{"!type":"string"},"_parseFloat":{"!type":"fn(str: string) -> number","!doc":"a helper function to parse VML-specific floating-point values"},"text_alignment":{"start":{"!type":"string"},"middle":{"!type":"string"},"end":{"!type":"string"}},"_bool":{"t":{"!type":"number"},"true":{"!type":"number"}},"Container":{"_moveChildToFront":{},"_moveChildToBack":{},"_init":{"!type":"fn()"},"add":{"!type":"fn(shape: +dojox.gfx.Shape) -> +self","!doc":"adds a shape to a group/surface"},"remove":{"!type":"fn(shape: +dojox.gfx.Shape, silently?: bool) -> +self","!doc":"remove a shape from a group/surface"},"clear":{"!type":"fn()","!doc":"removes all shapes from a group/surface"}}}},"collections":{"Set":{},"_base":{},"ArrayList":{"!type":"fn(arr?: []) -> +dojox.collections.ArrayList"},"Dictionary":{"!type":"fn(dictionary?: +dojox.collections.Dictionary) -> +dojox.collections.Dictionary"},"Queue":{"!type":"fn(arr?: []) -> +dojox.collections.Queue"},"SortedList":{"!type":"fn(dictionary?: ?) -> +dojox.collections.SortedList"},"Stack":{"!type":"fn(arr?: []) -> bool"},"DictionaryEntry":{"!type":"fn(k: string, v: ?) -> ?"},"Iterator":{"!type":"fn(arr: []) -> bool"},"DictionaryIterator":{"!type":"fn(obj: ?) -> bool"},"BinaryTree":{"!type":"fn(data: ?)","TraversalMethods":{"Inorder":{"!type":"number"},"Preorder":{"!type":"number"},"Postorder":{"!type":"number"}}}},"color":{"Colorspace":{},"blend":{},"fromRgb":{},"fromHex":{},"fromArray":{},"fromString":{},"greyscale":{},"_base":{},"fromXYZ":{"!type":"fn(xyz: ?, kwArgs?: ?)"},"fromCmy":{"!type":"fn(cyan: +Object, magenta: number, yellow: number) -> +dojox.color.Color"},"fromCmyk":{"!type":"fn(cyan: +Object, magenta: number, yellow: number, black: number) -> +dojox.color.Color"},"fromHsl":{"!type":"fn(hue: +Object, saturation: number, luminosity: number) -> +dojox.color.Color"},"fromHsv":{"!type":"fn(hue: +Object, saturation: number, value: number) -> +dojox.color.Color"},"Color":{"prototype":{"toXYZ":{"!type":"fn(kwArgs: ?) -> ?"},"toCmy":{"!type":"fn() -> ?"},"toCmyk":{"!type":"fn() -> ?"},"toHsl":{"!type":"fn() -> ?"},"toHsv":{"!type":"fn() -> ?"}}},"Palette":{"!type":"fn(base: string)","generate":{"!type":"fn(base: string, type: fn()) -> +dojox.color.Palette"},"prototype":{"transform":{"!type":"fn(kwArgs: ?) -> +dojox.color.Palette"},"clone":{"!type":"fn() -> +dojox.color.Palette"}},"generators":{"analogous":{"!type":"fn(args: ?)"},"monochromatic":{"!type":"fn(args: ?)"},"triadic":{"!type":"fn(args: ?)"},"complementary":{"!type":"fn(args: ?)"},"splitComplementary":{"!type":"fn(args: ?)"},"compound":{"!type":"fn(args: ?)"},"shades":{"!type":"fn(args: ?)"}}}},"math":{"_base":{},"degreesToRadians":{"!type":"fn(n: number) -> number"},"radiansToDegrees":{"!type":"fn(n: number) -> number"},"factorial":{"!type":"fn(n: number) -> number"},"permutations":{"!type":"fn(n: number, k: number) -> number"},"combinations":{"!type":"fn(n: number, r: number) -> number"},"bernstein":{"!type":"fn(t: number, n: number, i: number) -> number"},"gaussian":{"!type":"fn() -> number"},"sd":{"!type":"fn(a: [number]) -> number","!doc":"Returns the standard deviation of the passed arguments."},"variance":{"!type":"fn(a: [number]) -> number","!doc":"Find the variance in the passed array of numbers."},"bestFit":{"!type":"fn(a: [+Object], xProp?: string, yProp?: string) -> ?","!doc":"Calculate the slope and intercept in a linear fashion.  An array\nof objects is expected; optionally you can pass in the property\nnames for &quot;x&quot; and &quot;y&quot;, else x/y is used as the default.  If you\npass an array of numbers, it will be mapped to a set of {x,y} objects\nwhere x = the array index."},"mean":{"!type":"fn(a: [number]) -> number","!doc":"Returns the mean value in the passed array."},"min":{"!type":"fn(a: [number]) -> number","!doc":"Returns the min value in the passed array."},"max":{"!type":"fn(a: [number]) -> number","!doc":"Returns the max value in the passed array."},"median":{"!type":"fn(a: [number]) -> number","!doc":"Returns the value closest to the middle from a sorted version of the passed array."},"mode":{"!type":"fn(a: [number]) -> number","!doc":"Returns the mode from the passed array (number that appears the most often).\nThis is not the most efficient method, since it requires a double scan, but\nis ensures accuracy."},"approxLin":{"!type":"fn(a: [number], pos: number) -> number","!doc":"Returns a linearly approximated value from an array using\na normalized float position value."},"getSummary":{"!type":"fn(a: [number], alreadySorted?: bool) -> ?","!doc":"Returns a non-parametric collection of summary statistics:\nthe classic five-number summary extended to the Bowley's\nseven-figure summary."},"range":{"!type":"fn(a: number, b?: number, step?: number) -> []"},"distance":{"!type":"fn(a: [], b: []) -> number"},"midpoint":{"!type":"fn(a: [], b: []) -> []"},"round":{"!type":"fn(value: number, places?: number, increment?: number, v: ?, p: ?, m: ?) -> number","!doc":"Similar to dojo.number.round, but compensates for binary floating point artifacts"},"curves":{"Line":{"!type":"fn(start: ?, end: ?)"},"Bezier":{"!type":"fn(pnts: ?)"},"CatmullRom":{"!type":"fn(pnts: ?, c: ?)"},"Arc":{"!type":"fn(start: ?, end: ?, ccw: ?)"},"CenteredArc":{"!type":"fn(center: ?, radius: ?, start: ?, end: ?)"},"Circle":{"!type":"fn(center: ?, radius: ?)"},"Path":{"!type":"fn()"}},"matrix":{"iDF":{"!type":"number"},"ALMOST_ZERO":{"!type":"number"},"multiply":{"!type":"fn(a: [], b: []) -> []"},"product":{"!type":"fn() -> []"},"sum":{"!type":"fn() -> number"},"inverse":{"!type":"fn(a: []) -> []"},"determinant":{"!type":"fn(a: []) -> number"},"upperTriangle":{"!type":"fn(m: []) -> []"},"create":{"!type":"fn(a: number, b: number, value?: number) -> []"},"ones":{"!type":"fn(a: number, b: number) -> []"},"zeros":{"!type":"fn(a: number, b: number) -> []"},"identity":{"!type":"fn(size: number, scale?: number) -> []"},"adjoint":{"!type":"fn(a: []) -> []"},"transpose":{"!type":"fn(a: []) -> []"},"format":{"!type":"fn(a: [], points?: number) -> string"},"copy":{"!type":"fn(a: []) -> []"},"scale":{"!type":"fn(a: [], factor: number)"}}},"cometd":{"HttpChannels":{},"connectionTypes":{},"_base":{},"ackEnabled":{"!type":"bool"},"ack":{},"longPollTransport":{},"timestamp":{},"Connection":{"!type":"fn(prefix: ?) -> +dojo.Deferred"},"_ack":{"!type":"fn()"},"callbackPollTransport":{"!type":"fn()"},"longPollTransportFormEncoded":{"!type":"fn()"},"longPollTransportJsonEncoded":{"!type":"fn()"},"timesync":{"!type":"fn()"},"RestChannels":{"!type":"fn()","prototype":{"!doc":"Initiates the REST Channels protocol\noptions:\nKeyword arguments:\nThe *autoSubscribeRoot* parameter:\nWhen this is set, all REST service requests that have this\nprefix will be auto-subscribed. The default is '/' (all REST requests).\nThe *url* parameter:\nThis is the url to connect to for server-sent messages. The default\nis \"/channels\".\nThe *autoReconnectTime* parameter:\nThis is amount time to wait to reconnect with a connection is broken\nThe *reloadDataOnReconnect* parameter:\nThis indicates whether RestChannels should re-download data when a connection\nis restored (value of true), or if it should re-subscribe with retroactive subscriptions\n(Subscribe-Since header) using HEAD requests (value of false). The\ndefault is true.","acceptType":{"!type":"string"},"subscriptions":{},"subCallbacks":{},"autoReconnectTime":{"!type":"number"},"reloadDataOnReconnect":{"!type":"bool"},"sendAsJson":{"!type":"bool"},"url":{"!type":"string"},"autoSubscribeRoot":{"!type":"string"},"constructor":{"!type":"fn(options: +Keyword)","!doc":"Initiates the REST Channels protocol"},"absoluteUrl":{"!type":"fn(baseUrl: ?, relativeUrl: ?)"},"open":{"!type":"fn()","!doc":"Startup the transport (connect to the &quot;channels&quot; resource to receive updates from the server)."},"_send":{"!type":"fn(method: ?, args: ?, data: ?)"},"subscribe":{"!type":"fn(channel: string, args?: +dojo.__XhrArgs)","!doc":"Subscribes to a channel/uri, and returns a dojo.Deferred object for the response from\nthe subscription request"},"publish":{"!type":"fn(channel: +Channel, data: +data)","!doc":"Publish an event."},"_processMessage":{"!type":"fn(message: ?)"},"onprogress":{"!type":"fn(xhr: ?, data: ?, contentType: ?)"},"get":{"!type":"fn(channel: string, args?: +dojo.__XhrArgs)","!doc":"GET the initial value of the resource and subscribe to it\nSee subscribe for parameter values"},"receive":{"!type":"fn(message: +A)","!doc":"Called when a message is received from the server"},"disconnected":{"!type":"fn()","!doc":"called when our channel gets disconnected"},"unsubscribe":{"!type":"fn(channel: string, args?: +dojo.__XhrArgs)","!doc":"unsubscribes from the resource\nSee subscribe for parameter values"},"disconnect":{"!type":"fn()","!doc":"disconnect from the server"}},"defaultInstance":{}}},"rpc":{"Rest":{"!type":"fn(path: string, isJson?: bool, schema?: ?, getRequest?: fn())","!doc":"Creates a REST service using the provided path.","_index":{},"_get":{"!type":"fn(service: ?, id: ?)"},"_change":{"!type":"fn(method: ?, service: ?, id: ?, serializedContent: ?)"}},"JsonRest":{"_saveNotNeeded":{"!type":"bool"},"conflictDateHeader":{"!type":"string"},"services":{},"schemas":{},"_contentId":{},"commit":{"!type":"fn(kwArgs: ?)","!doc":"Saves the dirty data using REST Ajax methods"},"sendToServer":{"!type":"fn(actions: ?, kwArgs: ?)"},"getDirtyObjects":{"!type":"fn()"},"revert":{"!type":"fn(service: ?)","!doc":"Reverts all the changes made to JSON/REST data"},"changing":{"!type":"fn(object: ?, _deleting: ?)","!doc":"adds an object to the list of dirty objects.  This object\ncontains a reference to the object itself as well as a\ncloned and trimmed version of old object for use with\nrevert."},"deleteObject":{"!type":"fn(object: ?)","!doc":"deletes an object"},"getConstructor":{"!type":"fn(service: fn(), schema: ?)","!doc":"Creates or gets a constructor for objects from this service"},"fetch":{"!type":"fn(absoluteId: ?)","!doc":"Fetches a resource by an absolute path/id and returns a dojo.Deferred."},"getIdAttribute":{"!type":"fn(service: ?)","!doc":"Return the ids attribute used by this service (based on it's schema).\nDefaults to &quot;id&quot;, if not other id is defined"},"getServiceAndId":{"!type":"fn(absoluteId: string)","!doc":"Returns the REST service and the local id for the given absolute id. The result\nis returned as an object with a service property and an id property"},"registerService":{"!type":"fn(service: fn(), servicePath: string, schema?: ?)","!doc":"Registers a service for as a JsonRest service, mapping it to a path and schema"},"byId":{"!type":"fn(service: ?, id: ?)"},"query":{"!type":"fn(service: ?, id: ?, args: ?)"},"_loader":{"!type":"fn(callback: ?)"},"isDirty":{"!type":"fn(item: ?)"}},"_sync":{"!type":"bool"},"JsonRPC":{},"ProxiedPath":{},"transportRegistry":{},"envelopeRegistry":{},"getTarget":{"!type":"fn(smd: ?, method: ?)"},"toOrdered":{"!type":"fn(method: ?, args: ?)"},"Client":{"clientId":{}},"OfflineRest":{"sync":{},"sendChanges":{},"turnOffAutoSync":{"!type":"fn()"},"downloadChanges":{"!type":"fn()"},"addStore":{"!type":"fn(store: ?, baseQuery?: +query)","!doc":"Adds a store to the monitored store for local storage"}},"Service":{"!type":"fn()","prototype":{"!doc":"Take a string as a url to retrieve an smd or an object that is an smd or partial smd to use\nas a definition for the service\n\nsmd: object\nTakes a number of properties as kwArgs for defining the service.  It also\naccepts a string.  When passed a string, it is treated as a url from\nwhich it should synchronously retrieve an smd file.  Otherwise it is a kwArgs\nobject.  It accepts serviceUrl, to manually define a url for the rpc service\nallowing the rpc system to be used without an smd definition. strictArgChecks\nforces the system to verify that the # of arguments provided in a call\nmatches those defined in the smd.  smdString allows a developer to pass\na jsonString directly, which will be converted into an object or alternatively\nsmdObject is accepts an smdObject directly.","constructor":{"!type":"fn(smd: ?, options: ?)","!doc":"Take a string as a url to retrieve an smd or an object that is an smd or partial smd to use\nas a definition for the service"},"_generateService":{"!type":"fn(serviceName: ?, method: ?)"},"_getRequest":{"!type":"fn(method: ?, args: ?)"},"_executeMethod":{"!type":"fn(method: ?)"}},"_nextId":{"!type":"number"}}},"data":{"ASYNC_MODE":{"!type":"number"},"SYNC_MODE":{"!type":"number"},"_getStoreForItem":{"!type":"fn(item: ?)"},"restListener":{"!type":"fn(message: ?)","!doc":"this function can be used to receive REST notifications, from Comet or from another frame"},"AndOrReadStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"AndOrReadStore uses ItemFileReadStore as a base, modifying only the query (_fetchItems) section.\nSupports queries of the form: query:\"id:1* OR dept:'Sales Department' || (id:2* && NOT dept:S*)\"\nIncludes legacy/widget support via:\nquery:{complexQuery:\"id:1* OR dept:'Sales Department' || (id:2* && NOT dept:S*)\"}\nThe ItemFileReadStore implements the dojo.data.api.Read API and reads\ndata from JSON files that have contents in this format --\n{ items: [\n{ name:'Kermit', color:'green', age:12, friends:['Gonzo', {_reference:{name:'Fozzie Bear'}}]},\n{ name:'Fozzie Bear', wears:['hat', 'tie']},\n{ name:'Miss Piggy', pets:'Foo-Foo'}\n]}\nNote that it can also contain an 'identifer' property that specified which attribute on the items\nin the array of items that acts as the unique identifier for that item.\n\n\n\nuse \"\" rather than undefined for the benefit of the parser (#3539)","url":{"!type":"string"},"data":{},"typeMap":{},"clearOnClose":{"!type":"bool"},"urlPreventCache":{"!type":"bool"},"hierarchical":{"!type":"bool"},"constructor":{"!type":"fn(keywordParameters: ?)","!doc":"constructor"},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getValue":{"!type":"fn(item: +item, attribute: ?, defaultValue?: +value) -> +mixed","!doc":"See dojo.data.api.Read.getValue()"},"getValues":{"!type":"fn(item: +item, attribute: ?) -> []","!doc":"See dojo.data.api.Read.getValues()"},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: +item, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttribute()"},"containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything) -> +boolean.","!doc":"See dojo.data.api.Read.containsValue()"},"_containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything, regexp?: +RegExp) -> bool","!doc":"Internal function for looking at the values contained by the item."},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItem()"},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"getFeatures":{"!type":"fn() -> ?","!doc":"See dojo.data.api.Read.getFeatures()"},"getLabel":{"!type":"fn(item: +item) -> string","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"_fetchItems":{"!type":"fn(keywordArgs: ?, findCallback: fn(), errorCallback: fn())","!doc":"See dojo.data.util.simpleFetch.fetch()\nfilter modified to permit complex queries where\nlogical operators are case insensitive:\n, NOT AND OR ( ) ! &amp;&amp; ||\nNote:  &quot;,&quot; included for quoted/string legacy queries."},"_handleQueuedFetches":{"!type":"fn()","!doc":"Internal function to execute delayed request in the store.\nExecute any deferred fetches now."},"_getItemsArray":{"!type":"fn(queryOptions?: ?)","!doc":"Internal function to determine which list of items to search over."},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()"},"_getItemsFromLoadedData":{"!type":"fn(dataObject: ?)","!doc":"Function to parse the loaded data into item format and build the internal items array."},"_addReferenceToMap":{"!type":"fn(refItem: +item, parentItem: +item, attribute: string)","!doc":"Method to add an reference map entry for an item and attribute."},"getIdentity":{"!type":"fn(item: +item) -> number","!doc":"See dojo.data.api.Identity.getIdentity()"},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"},"_getItemByIdentity":{"!type":"fn(identity: ?) -> ?","!doc":"Internal function to look an item up by its identity map."},"getIdentityAttributes":{"!type":"fn(item: +item) -> +null","!doc":"See dojo.data.api.Identity.getIdentifierAttributes()"},"_forceLoad":{"!type":"fn()","!doc":"Internal function to force a load of the store if it hasn't occurred yet.  This is required\nfor specific functions to work properly."}}},"AndOrWriteStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.AndOrReadStore.prototype","referenceIntegrity":{"!type":"bool"},"constructor":{"!type":"fn(keywordParameters: ?)"},"_assert":{"!type":"fn(condition: bool)"},"_getIdentifierAttribute":{"!type":"fn()"},"newItem":{"!type":"fn(keywordArgs?: ?, parentInfo?: ?) -> +item","!doc":"See dojo.data.api.Write.newItem()"},"_removeArrayElement":{"!type":"fn(array: [], element: +anything)"},"deleteItem":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Write.deleteItem()"},"setValue":{"!type":"fn(item: +item, attribute: ?, value: +almost) -> bool","!doc":"See dojo.data.api.Write.set()"},"setValues":{"!type":"fn(item: +item, attribute: ?, values: []) -> bool","!doc":"See dojo.data.api.Write.setValues()"},"unsetAttribute":{"!type":"fn(item: +item, attribute: ?)","!doc":"See dojo.data.api.Write.unsetAttribute()"},"_setValueOrValues":{"!type":"fn(item: +item, attribute: ?, newValueOrValues: +anything, callOnSet?: bool) -> bool"},"_addReferenceToMap":{"!type":"fn(refItem: +item, parentItem: +item, attribute: string)","!doc":"Method to add an reference map entry for an item and attribute."},"_removeReferenceFromMap":{"!type":"fn(refItem: +item, parentItem: +item, attribute: +strin)","!doc":"Method to remove an reference map entry for an item and attribute."},"_dumpReferenceMap":{"!type":"fn()","!doc":"Function to dump the reverse reference map of all items in the store for debug purposes."},"_getValueOrValues":{"!type":"fn(item: +item, attribute: ?)"},"_flatten":{"!type":"fn(value: +anything)"},"_getNewFileContentString":{"!type":"fn()","!doc":"Generate a string that can be saved to a file.\nThe result should look similar to:\nhttp://trac.dojotoolkit.org/browser/dojo/trunk/tests/data/countries.json"},"_isEmpty":{"!type":"fn(something: +The) -> bool","!doc":"Function to determine if an array or object has no properties or values."},"save":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Write.save()"},"revert":{"!type":"fn() -> bool","!doc":"See dojo.data.api.Write.revert()"},"isDirty":{"!type":"fn(item?: +item) -> bool","!doc":"See dojo.data.api.Write.isDirty()"},"onSet":{"!type":"fn(item: +item, attribute: ?, oldValue: ?, newValue: ?)","!doc":"See dojo.data.api.Notification.onSet()"},"onNew":{"!type":"fn(newItem: +item, parentInfo?: ?)","!doc":"See dojo.data.api.Notification.onNew()"},"onDelete":{"!type":"fn(deletedItem: +item)","!doc":"See dojo.data.api.Notification.onDelete()"},"close":{"!type":"fn(request?: ?)","!doc":"Over-ride of base close function of ItemFileReadStore to add in check for store state."}}},"AppStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"The APP data store.","url":{"!doc":"url of the Collection to load.","!type":"+The"},"urlPreventCache":{"!doc":"or not to append on cache prevention params (as defined by dojo.xhr*)","!type":"+Whether"},"xmethod":{"!type":"bool"},"_atomIO":{},"_feed":{},"_requests":{},"_processing":{},"_updates":{},"_adds":{},"_deletes":{},"constructor":{"!type":"fn(args: ?)","!doc":"The APP data store."},"_setFeed":{"!type":"fn(feed: +dojox.atom.io.model.Feed, data: +unused)","!doc":"Sets the internal feed using a dojox.atom.io.model.Feed object."},"_getAllItems":{"!type":"fn() -> []","!doc":"Function to return all entries in the Feed as an array of items."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item is an item."},"_assertIsAttribute":{"!type":"fn(attribute: string)","!doc":"This function tests whether the item is an attribute."},"_addUpdate":{"!type":"fn(update: ?)","!doc":"Internal function to add an updated entry to our updates array"},"getValue":{"!type":"fn(item: +item, attribute: ?, defaultValue?: +value) -> ?","!doc":"See dojo.data.api.Read.getValue()"},"getValues":{"!type":"fn(item: +item, attribute: ?) -> []","!doc":"See dojo.data.api.Read.getValues()"},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: +item, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttribute()"},"containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything) -> +boolean.","!doc":"See dojo.data.api.Read.containsValue()"},"_containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything, regexp?: +RegExp, trim?: bool) -> bool","!doc":"Internal function for looking at the values contained by the item."},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItem()"},"isItemLoaded":{"!type":"fn(something: +anything)","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"_fetchItems":{"!type":"fn(request: +A, fetchHandler: +A, errorHandler: +A)","!doc":"Fetch items (Atom entries) that match to a query"},"_finishFetchItems":{"!type":"fn(request: +A, fetchHandler: +A, errorHandler: +A)","!doc":"Internal function for finishing a fetch request."},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()\nnothing to do here!"},"getLabel":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"getIdentity":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentity()"},"getIdentityAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentityAttributes()"},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"},"newItem":{"!type":"fn(keywordArgs?: ?)","!doc":"See dojo.data.api.Write.newItem()"},"deleteItem":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Write.deleteItem()"},"setValue":{"!type":"fn(item: +item, attribute: string, value: +almost)","!doc":"See dojo.data.api.Write.setValue()"},"setValues":{"!type":"fn(item: +item, attribute: string, values: [])","!doc":"See dojo.data.api.Write.setValues()"},"unsetAttribute":{"!type":"fn(item: +item, attribute: string) -> bool","!doc":"See dojo.data.api.Write.unsetAttribute()"},"save":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Write.save()"},"revert":{"!type":"fn()","!doc":"See dojo.data.api.Write.revert()"},"isDirty":{"!type":"fn(item?: +item) -> bool","!doc":"See dojo.data.api.Write.isDirty()"}}},"AtomReadStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"A read only data store for Atom XML based services or documents","url":{"!doc":"url to a service or an XML document that represents the store","!type":"+The"},"label":{"!type":"string"},"sendQuery":{"!doc":"boolean indicate to add a query string to the service URL","!type":"+A"},"unescapeHTML":{"!doc":"boolean to specify whether or not to unescape HTML text","!type":"+A"},"constructor":{"!type":"fn(args: ?)","!doc":"Constructor for the AtomRead store."},"getValue":{"!type":"fn(item: +item, attribute: +attribute, defaultValue?: +value)","!doc":"Return an attribute value"},"getValues":{"!type":"fn(item: +item, attribute: +attribute)","!doc":"Return an attribute value"},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"Return an array of attribute names"},"hasAttribute":{"!type":"fn(item: +item, attribute: +attribute) -> bool","!doc":"Check whether an element has the attribute"},"containsValue":{"!type":"fn(item: +item, attribute: +attribute, value: +anything) -> bool","!doc":"Check whether the attribute values contain the value"},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"Check whether the object is an item (XML element)\nitem:\nAn object to check"},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"Check whether the object is an item (XML element) and loaded\nitem:\nAn object to check"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"Load an item (XML element)"},"getFeatures":{"!type":"fn() -> []","!doc":"Return supported data APIs"},"getLabel":{"!type":"fn(item: +item) -> +undefined","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"getFeedValue":{"!type":"fn(attribute: ?, defaultValue: ?)","!doc":"Non-API method for retrieving values regarding the Atom feed,\nrather than the Atom entries."},"getFeedValues":{"!type":"fn(attribute: ?, defaultValue: ?)","!doc":"Non-API method for retrieving values regarding the Atom feed,\nrather than the Atom entries."},"_initItem":{"!type":"fn(item: ?)","!doc":"Initializes an item before it can be parsed."},"_fetchItems":{"!type":"fn(request: ?, fetchHandler: ?, errorHandler: ?)","!doc":"Retrieves the items from the Atom XML document."},"_getFetchUrl":{"!type":"fn(request: ?)"},"_getItems":{"!type":"fn(document: ?, request: ?)","!doc":"Parses the document in a first pass"},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()"},"_getItem":{"!type":"fn(element: ?)"},"_parseItem":{"!type":"fn(item: ?)"},"_unescapeHTML":{"!type":"fn(text: ?)"},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."}}},"CdfStore":{"!type":"fn()","prototype":{"!doc":"IMPORTANT: The CDF Store is designed to work with Tibco GI, and references Tibco's\nJSX3 JavaScript library and will not work without it.\n\nThe CDF Store implements dojo.data.Read, Write, and Identity api's.  It is a local\n(in memory) store that handles XML documents formatted according to the\nCommon Data Format (CDF) spec:\nhttp://www.tibco.com/devnet/resources/gi/3_1/tips_and_techniques/CommonDataFormatCDF.pdf\n\nThe purpose of this store is to provide a glue between a jsx3 CDF file and a Dijit.\n\nWhile a CDF document is an XML file, other than the initial input, all data returned\nfrom and written to this store should be in object format.","identity":{"!doc":"The unique identifier for each item. Defaults to &quot;jsxid&quot; which is standard for a CDF\ndocument. Should not be changed.\n\n\n\nurl : String\nThe location from which to fetch the XML (CDF) document.","!type":"string"},"url":{"!type":"string"},"xmlStr":{"!doc":"A string that can be parsed into an XML document and should be formatted according\nto the CDF spec.","!type":"string"},"data":{"!doc":"A object that will be converted into the xmlStr property, and then parsed into a CDF."},"label":{"!doc":"The property within each item used to define the item.\n\n\n\nmode [const]: dojox.data.ASYNC_MODE | dojox.data.SYNC_MODE\nThis store supports syncronous fetches if this property is set to dojox.data.SYNC_MODE.","!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Constructor for the CDF store. Instantiate a new CdfStore."},"getValue":{"!type":"fn(item: +jsx3.xml.Entity, property: string, defaultValue?: +value) -> +anything","!doc":"Return an property value of an item"},"getValues":{"!type":"fn(item: +jsx3.xml.Entity, property: string)","!doc":"Return an array of values\n\nTODO!!! Can't find an example of an array in any CDF files"},"getAttributes":{"!type":"fn(item: +jsx3.xml.Entity) -> []","!doc":"Return an array of property names"},"hasAttribute":{"!type":"fn(item: +jsx3.xml.Entity, property: string) -> bool","!doc":"Check whether an item has a property"},"hasProperty":{"!type":"fn(item: +jsx3.xml.Entity, property: string)","!doc":"Alias for hasAttribute"},"containsValue":{"!type":"fn(item: +jsx3.xml.Entity, property: string, value: +anything) -> bool","!doc":"Check whether an item contains a value"},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"Check whether the object is an item (jsx3.xml.Entity)"},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"Check whether the object is a jsx3.xml.Entity object and loaded"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"Load an item"},"getFeatures":{"!type":"fn()","!doc":"Return supported data APIs"},"getLabel":{"!type":"fn(item: +jsx3.xml.Entity) -> +undefined","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +jsx3.xml.Entity) -> []","!doc":"returns an array of what properties of the item that were used\nto generate its label\nSee dojo.data.api.Read.getLabelAttributes()"},"fetch":{"!type":"fn(request?: ?) -> ?","!doc":"Returns an Array of items based on the request arguments."},"_loadCDF":{"!type":"fn() -> +jsx3.xml.CDF","!doc":"Internal method.\nIf a cdfDoc exists, return it. Otherwise, get one from JSX3,\nload the data or url, and return the doc or a deferred."},"_getItems":{"!type":"fn(cdfDoc: +jsx3.xml.Entity, request: ?)","!doc":"Internal method.\nRequests the items from jsx3.xml.Entity with an xpath query."},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()"},"newItem":{"!type":"fn(keywordArgs?: ?, parentInfo?: ?) -> +jsx3.xml.Entity","!doc":"Creates a jsx3.xml.Entity item and inserts it either inside the\nparent or appends it to the root"},"deleteItem":{"!type":"fn(item: +jsx3.xml.Entity) -> bool","!doc":"Delete an jsx3.xml.Entity (wrapper to a XML element)."},"setValue":{"!type":"fn(item: +jsx3.xml.Entity, property: string, value: +almost) -> bool","!doc":"Set an property value"},"setValues":{"!type":"fn(item: +jsx3.xml.Entity, property: string, values: [])","!doc":"Set property values\nTODO: Needs to be fully implemented."},"unsetAttribute":{"!type":"fn(item: +jsx3.xml.Entity, property: string) -> bool","!doc":"Remove an property"},"revert":{"!type":"fn() -> bool","!doc":"Invalidate changes (new and/or modified elements)\nResets data by simply deleting the reference to the cdfDoc.\nSubsequent fetches will load the new data.\nNote:\nAny items outside the store will no longer be valid and may cause errors."},"isDirty":{"!type":"fn(item: +jsx3.xml.Entity) -> bool","!doc":"Check whether an item is new, modified or deleted.\nIf no item is passed, checks if anything in the store has changed."},"_makeDirty":{"!type":"fn(item: ?)","!doc":"Internal method.\nMarks items as modified, deleted or new."},"_makeXmlString":{"!type":"fn(obj: ?)","!doc":"Internal method.\nConverts an object into an XML string."},"getIdentity":{"!type":"fn(item: +jsx3.xml.Entity) -> string","!doc":"Returns the identifier for an item."},"getIdentityAttributes":{"!type":"fn(item: +jsx3.xml.Entity) -> []","!doc":"Returns the property used for the identity."},"fetchItemByIdentity":{"!type":"fn(args: ?) -> +dojo.Deferred","!doc":"See dojo.data.api.Identity.fetchItemByIdentity(keywordArgs)\n\nNote:\nThis method can be synchronous if mode is set.\nAlso, there is a more finger friendly alias of this method, byId();"},"byId":{"!type":"fn(args: ?)"}},"mode":{}},"ClientFilter":{"!type":"fn()","prototype":{"!doc":"This is an abstract class that data stores can extend to add updateable result set functionality\nas well as client side querying capabilities. This enables\nwidgets to be aware of how active results change in response to the modifications/notifications.","serverVersion":{"!type":"number"},"constructor":{"!type":"fn()","!doc":"This is an abstract class that data stores can extend to add updateable result set functionality\nas well as client side querying capabilities. This enables\nwidgets to be aware of how active results change in response to the modifications/notifications."},"clearCache":{"!type":"fn()","!doc":"Clears the cache of client side queries"},"updateResultSet":{"!type":"fn(resultSet: [], request: ?)","!doc":"Attempts to update the given result set based on previous notifications"},"querySuperSet":{"!type":"fn(argsSuper: +Dojo, argsSub: +Dojo)","!doc":"Determines whether the provided arguments are super/sub sets of each other"},"cachingFetch":{"!type":"fn(args: ?)"},"isUpdateable":{"!type":"fn(request: ?)","!doc":"Returns whether the provide fetch arguments can be used to update an existing list"},"clientSideFetch":{"!type":"fn(request: ?, baseResults: [])","!doc":"Performs a query on the client side and returns the results as an array"},"clientSidePaging":{"!type":"fn(request: ?, baseResults: [])"},"matchesQuery":{"!type":"fn(item: ?, request: ?)"},"makeComparator":{"!type":"fn(sort: +See)","!doc":"returns a comparator function for the given sort order array"}}},"CouchDBRestStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.JsonRestStore.prototype","save":{"!type":"fn(kwArgs: ?)"},"fetch":{"!type":"fn(args: ?)","!doc":"This only differs from JsonRestStore in that it, will put the query string the query part of the URL and it handles start and count"},"_processResults":{"!type":"fn(results: ?)"}},"getStores":{"!type":"fn(couchServerUrl: ?)"}},"CssClassStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.CssRuleStore.prototype","!doc":"Basic store to display CSS information.","_labelAttribute":{"!type":"string"},"_idAttribute":{"!type":"string"},"_cName":{"!type":"string"},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"getAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getAttributes()"},"getValue":{"!type":"fn(item: ?, attribute: ?, defaultValue: ?)","!doc":"See dojo.data.api.Read.getValue()"},"getValues":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.getValues()"},"_handleRule":{"!type":"fn(rule: ?, styleSheet: ?, href: ?)","!doc":"Handles the creation of an item based on the passed rule.  In this store, this implies\nparsing out all available class names."},"_handleReturn":{"!type":"fn()","!doc":"Handles the return from a fetching action.  Delegates requests to act on the resulting\nitem set to eitehr the _handleFetchReturn or _handleFetchByIdentityReturn depending on\nwhere the request originated."},"_handleFetchByIdentityReturn":{"!type":"fn(request: ?)","!doc":"Handles a fetchByIdentity request by finding the correct item."},"getIdentity":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentity()"},"getIdentityAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentityAttributes()"},"fetchItemByIdentity":{"!type":"fn(request: +request)","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"}}},"CssRuleStore":{"!type":"fn()","prototype":{"!doc":"Basic store to display CSS information.","_storeRef":{"!type":"string"},"_labelAttribute":{"!type":"string"},"_cache":{},"_browserMap":{},"_cName":{"!type":"string"},"constructor":{"!type":"fn(keywordParameters: ?)"},"setContext":{"!type":"fn(context: [])"},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"isItem":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItem()"},"hasAttribute":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttribute()"},"getAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getAttributes()"},"getValue":{"!type":"fn(item: ?, attribute: ?, defaultValue: ?)","!doc":"See dojo.data.api.Read.getValue()"},"getValues":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.getValues()"},"getLabel":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything) -> +boolean.","!doc":"See dojo.data.api.Read.containsValue()"},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"fetch":{"!type":"fn(request: ?)","!doc":"See dojo.data.api.Read.fetch()"},"_fetch":{"!type":"fn(request: ?)","!doc":"Populates the _allItems object with unique class names"},"_handleRule":{"!type":"fn(rule: ?, styleSheet: ?, href: ?)","!doc":"Handles the creation of an item based on the passed rule.  In this store, this implies\nparsing out all available class names."},"_handleReturn":{"!type":"fn()","!doc":"Handles the return from a fetching action.  Delegates requests to act on the resulting\nitem set to eitehr the _handleFetchReturn or _handleFetchByIdentityReturn depending on\nwhere the request originated."},"_handleFetchReturn":{"!type":"fn(request: +Request)","!doc":"Handles a fetchByIdentity request by finding the correct items."},"close":{"!type":"fn()","!doc":"See dojo.data.api.Read.close()\nClears out the cache and allItems objects, meaning all future fetches will requery\nthe stylesheets."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"_containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything, regexp?: +RegExp) -> bool","!doc":"Internal function for looking at the values contained by the item."}}},"CsvStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"The CsvStore implements the dojo.data.api.Read API and reads\ndata from files in CSV (Comma Separated Values) format.\nAll values are simple string values. References to other items\nare not supported as attribute values in this datastore.\n\nExample data file:\nname, color, age, tagline\nKermit, green, 12, \"Hi, I'm Kermit the Frog.\"\nFozzie Bear, orange, 10, \"Wakka Wakka Wakka!\"\nMiss Piggy, pink, 11, \"Kermie!\"\n\nNote that values containing a comma must be enclosed with quotes (\"\")\nAlso note that values containing quotes must be escaped with two consecutive quotes (\"\"quoted\"\")","url":{"!type":"string"},"label":{"!type":"string"},"identifier":{"!type":"string"},"constructor":{"!type":"fn(keywordParameters: ?)","!doc":"initializer"},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: +item)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"_getIndex":{"!type":"fn(item: +The)","!doc":"Internal function to get the internal index to the item data from the item handle"},"getValue":{"!type":"fn(item: +item, attribute: +attribute, defaultValue?: +value) -> string","!doc":"See dojo.data.api.Read.getValue()\nNote that for the CsvStore, an empty string value is the same as no value,\nso the defaultValue would be returned instead of an empty string."},"getValues":{"!type":"fn(item: +item, attribute: +attribute) -> []","!doc":"See dojo.data.api.Read.getValues()\nCSV syntax does not support multi-valued attributes, so this is just a\nwrapper function for getValue()."},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: +item, attribute: +attribute) -> bool","!doc":"See dojo.data.api.Read.hasAttribute()\nThe hasAttribute test is true if attribute has an index number within the item's array length\nAND if the item has a value for that attribute. Note that for the CsvStore, an\nempty string value is the same as no value."},"containsValue":{"!type":"fn(item: +item, attribute: +attribute, value: +anything) -> +boolean.","!doc":"See dojo.data.api.Read.containsValue()"},"_containsValue":{"!type":"fn(item: +item, attribute: +attribute, value: +anything, regexp?: +RegExp) -> bool","!doc":"Internal function for looking at the values contained by the item."},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItem()"},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItemLoaded()\nThe CsvStore always loads all items, so if it's an item, then it's loaded."},"loadItem":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.loadItem()"},"getFeatures":{"!type":"fn() -> ?","!doc":"See dojo.data.api.Read.getFeatures()"},"getLabel":{"!type":"fn(item: +item) -> string","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"_fetchItems":{"!type":"fn(keywordArgs: ?, findCallback: fn(), errorCallback: fn())","!doc":"See dojo.data.util.simpleFetch.fetch()"},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()"},"_splitLines":{"!type":"fn(csvContent: ?)","!doc":"Function to split the CSV file contents into separate lines.\nSince line breaks can occur inside quotes, a Regexp didn't\nwork as well.  A quick passover parse should be just as efficient."},"_processData":{"!type":"fn(data: string)"},"_createItemFromIdentity":{"!type":"fn(identity: string) -> ?"},"getIdentity":{"!type":"fn(item: +item) -> string","!doc":"See dojo.data.api.Identity.getIdentity()"},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"},"getIdentityAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentifierAttributes()"},"_handleQueuedFetches":{"!type":"fn()","!doc":"Internal function to execute delayed request in the store.\nExecute any deferred fetches now."}},"_getArrayOfArraysFromCsvFileContents":{}},"FileStore":{"!type":"fn()","prototype":{"!doc":"A simple store that provides a datastore interface to a filesystem.","url":{"!doc":"URL of the service which provides the file store serverside implementation.","!type":"+The"},"_storeRef":{"!type":"string"},"label":{"!doc":"attribute of the file to use as the huma-readable text.  Default is 'name'.\nThe purpose of this store is to represent a file as a datastore item.  The\ndatastore item by default has the following attributes that can be examined on it.\ndirectory:\tBoolean indicating if the file item represents a directory.\nname:\tThe filename with no path informatiom.\npath:\tThe file complete file path including name, relative to the location the\nfile service scans from\nsize:\tThe size of the file, in bytes.\nparentDir:\tThe parent directory path.\nchildren:\tAny child files contained by a directory file item.\n\nNote that the store's server call pattern is RESTlike.\n\nThe store also supports the passing of configurable options to the back end service, such as\nexpanding all child files (no lazy load), displaying hidden files, displaying only directories, and so on.\nThese are defined through a comma-separated list in declarative, or through setting the options array in programmatic.","!type":"+The"},"_identifier":{"!type":"string"},"_attributes":{"!type":"[]"},"pathSeparator":{"!type":"string"},"options":{"!type":"[]"},"pathAsQueryParam":{"!type":"bool"},"constructor":{"!type":"fn(args: ?)","!doc":"A simple store that provides a datastore interface to a filesystem."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"getValue":{"!type":"fn(item: ?, attribute: ?, defaultValue: ?)","!doc":"See dojo.data.api.Read.getValue()"},"getAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttributes()"},"getIdentity":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentity()"},"getIdentityAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"isItemLoaded":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"getLabel":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"containsValue":{"!type":"fn(item: ?, attribute: ?, value: ?)","!doc":"See dojo.data.api.Read.containsValue()"},"getValues":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.getValue()"},"isItem":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItem()"},"close":{"!type":"fn(request: ?)","!doc":"See dojo.data.api.Read.close()"},"fetch":{"!type":"fn(request: +A)","!doc":"Fetch  items that match to a query"},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"_processResult":{"!type":"fn(data: ?, request: ?)"},"_processItemArray":{"!type":"fn(itemArray: ?)","!doc":"Internal function for processing an array of items for return."},"_processItem":{"!type":"fn(item: ?)","!doc":"Internal function for processing an item returned from the store.\nIt sets up the store ref as well as sets up the attributes necessary\nto invoke a lazy load on a child, if there are any."}}},"FlickrRestStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.FlickrStore.prototype","!doc":"Initializer for the FlickrRestStore store.","_id":{"!doc":"A unique identifier for this store.","!type":"+Integer"},"_requestCount":{"!doc":"A counter for the number of requests made. This is used to define\nthe callback function that Flickr will use.","!type":"+Integer"},"_flickrRestUrl":{"!doc":"The URL to the Flickr REST services.","!type":"string"},"_apikey":{"!doc":"The users API key to be used when accessing Flickr REST services.","!type":"string"},"_storeRef":{"!doc":"A key used to mark an data store item as belonging to this store.","!type":"string"},"_cache":{"!doc":"An Array of all previously downloaded picture info.","!type":"[]"},"_prevRequests":{"!doc":"A HashMap used to record the signature of a request to prevent duplicate\nrequest being made."},"_handlers":{"!doc":"A HashMap used to record the handlers registered for a single remote request.  Multiple\nrequests may be made for the same information before the first request has finished.\nEach element of this Object is an array of handlers to call back when the request finishes.\nThis prevents multiple requests being made for the same information."},"constructor":{"!type":"fn(args: ?)","!doc":"Initializer for the FlickrRestStore store."},"_fetchItems":{"!type":"fn(request: ?, fetchHandler: fn(), errorHandler: fn())","!doc":"Fetch flickr items that match to a query"},"getAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getAttributes()"},"getValues":{"!type":"fn(item: ?, attribute: ?) -> string","!doc":"See dojo.data.api.Read.getValue()"},"_processFlickrData":{"!type":"fn(data: ?, request: ?, cacheKey: string) -> []","!doc":"Processes the raw data from Flickr and updates the internal cache."},"_checkPrevRanges":{"!type":"fn(primaryKey: ?, start: ?, count: ?)"}},"_sortAttributes":{"!doc":"A quick lookup of valid attribute names in a sort query.","date-posted":{"!type":"bool"},"date-taken":{"!type":"bool"},"interestingness":{"!type":"bool"}}},"FlickrStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"Initializer for the FlickrStore store.","_storeRef":{"!type":"string"},"label":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initializer for the FlickrStore store."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"getValue":{"!type":"fn(item: ?, attribute: ?, defaultValue: ?)","!doc":"See dojo.data.api.Read.getValue()"},"getAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttributes()"},"isItemLoaded":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"getLabel":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"containsValue":{"!type":"fn(item: ?, attribute: ?, value: ?)","!doc":"See dojo.data.api.Read.containsValue()"},"getValues":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.getValue()"},"isItem":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItem()"},"close":{"!type":"fn(request: ?)","!doc":"See dojo.data.api.Read.close()"},"_fetchItems":{"!type":"fn(request: +A, fetchHandler: +A, errorHandler: +A)","!doc":"Fetch flickr items that match to a query"},"_processFlickrData":{"!type":"fn(data: ?)"},"_unescapeHtml":{"!type":"fn(str: string)","!doc":"Utility function to un-escape XML special characters in an\nHTML string."}},"urlRegistry":{}},"GoogleFeedStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.GoogleSearchStore.prototype","!doc":"A data store for retrieving RSS and Atom feeds from Google. The\nfeeds can come from any source, which is specified in the \"url\"\nparameter of the query passed to the \"fetch\" function.\nThe following attributes are supported on each item:\n<ul>\n<li>title - The feed entry title.</li>\n<li>link - The URL for the HTML version of the feed entry.</li>\n<li>content - The full content of the blog post, in HTML format</li>\n<li>summary - A snippet of information about the feed entry, in plain text</li>\n<li>published - The string date on which the entry was published.\nYou can parse the date with new Date(store.getValue(item, \"published\")</li>\n<li>categories - An array of string tags for the entry</li>\n</ul>\nThe query accepts one parameter: url - The URL of the feed to retrieve","_type":{"!type":"string"},"_googleUrl":{"!type":"string"},"_attributes":{"!type":"[]"},"_queryAttr":{"!type":"string"},"_processItem":{"!type":"fn(item: ?, request: ?)"},"_getItems":{"!type":"fn(data: ?)"},"_createContent":{"!type":"fn(query: ?, callback: ?, request: ?)"}}},"GoogleSearchStore":{"!type":"fn()","prototype":{"!doc":"A data store for retrieving search results from Google.\nThis data store acts as a base class for Google searches,\nand has a number of child data stores that implement different\nsearches. This store defaults to searching the web, and is functionally\nidentical to the dojox.data.GoogleWebSearchStore object.\nThe following attributes are supported on each item:\n<ul>\n<li>url - The URL for the item</li>\n<li>unescapedUrl - The URL for the item, with URL escaping. This is often more readable</li>\n<li>visibleUrl - The URL with no protocol specified.\n<li>cacheUrl - The URL to the copy of the document cached by Google\n<li>title - The page title in HTML format.</li>\n<li>titleNoFormatting - The page title in plain text</li>\n<li>content - A snippet of information about the page</li>\n</ul>\nThe query accepts one parameter: text - The string to search for","_id":{"!doc":"A unique identifier for this store.","!type":"+Integer"},"_requestCount":{"!doc":"A counter for the number of requests made. This is used to define\nthe callback function that GoogleSearchStore will use.","!type":"+Integer"},"_googleUrl":{"!doc":"The URL to Googles search web service.","!type":"string"},"_storeRef":{"!doc":"The internal reference added to each item pointing at the store which owns it.","!type":"string"},"_attributes":{"!doc":"The list of attributes that this store supports","!type":"[]"},"label":{"!doc":"The default attribute which acts as a label for each item.","!type":"string"},"_type":{"!type":"string"},"_queryAttr":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initializer for the GoogleSearchStore store."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"getValue":{"!type":"fn(item: ?, attribute: ?, defaultValue: ?)","!doc":"See dojo.data.api.Read.getValue()"},"getAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttributes()"},"isItemLoaded":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"getLabel":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"containsValue":{"!type":"fn(item: ?, attribute: ?, value: ?)","!doc":"See dojo.data.api.Read.containsValue()"},"getValues":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.getValue()"},"isItem":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItem()"},"close":{"!type":"fn(request: ?)","!doc":"See dojo.data.api.Read.close()"},"_format":{"!type":"fn(item: ?, name: ?)"},"fetch":{"!type":"fn(request: +A)","!doc":"Fetch Google search items that match to a query"},"_processItem":{"!type":"fn(item: ?, data: ?)"},"_getItems":{"!type":"fn(data: ?)"},"_createContent":{"!type":"fn(query: ?, callback: ?, request: ?)"}}},"GoogleWebSearchStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.GoogleSearchStore.prototype","!doc":"A data store for retrieving search results from Google.\nThe following attributes are supported on each item:\n<ul>\n<li>title - The page title in HTML format.</li>\n<li>titleNoFormatting - The page title in plain text</li>\n<li>content - A snippet of information about the page</li>\n<li>url - The URL for the item</li>\n<li>unescapedUrl - The URL for the item, with URL escaping. This is often more readable</li>\n<li>visibleUrl - The URL with no protocol specified.</li>\n<li>cacheUrl - The URL to the copy of the document cached by Google</li>\n</ul>\nThe query accepts one parameter: text - The string to search for"}},"GoogleBlogSearchStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.GoogleSearchStore.prototype","!doc":"A data store for retrieving search results from Google.\nThe following attributes are supported on each item:\n<ul>\n<li>title - The blog post title in HTML format.</li>\n<li>titleNoFormatting - The  blog post title in plain text</li>\n<li>content - A snippet of information about the blog post</li>\n<li>blogUrl - The URL for the blog</li>\n<li>postUrl - The URL for the a single blog post</li>\n<li>visibleUrl - The URL with no protocol specified.\n<li>cacheUrl - The URL to the copy of the document cached by Google\n<li>author - The author of the blog post</li>\n<li>publishedDate - The published date, in RFC-822 format</li>\n</ul>\nThe query accepts one parameter: text - The string to search for","_type":{"!type":"string"},"_attributes":{"!type":"[]"}}},"GoogleLocalSearchStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.GoogleSearchStore.prototype","!doc":"A data store for retrieving search results from Google.\nThe following attributes are supported on each item:\n<ul>\n<li>title - The blog post title in HTML format.</li>\n<li>titleNoFormatting - The  blog post title in plain text</li>\n<li>content - A snippet of information about the blog post</li>\n<li>url - The URL for the item</li>\n<li>lat - The latitude.</li>\n<li>lng - The longtitude.</li>\n<li>streetAddress - The street address</li>\n<li>city - The city</li>\n<li>region - The region</li>\n<li>country - The country</li>\n<li>phoneNumbers - Phone numbers associated with this address. Can be one or more.</li>\n<li>ddUrl - A URL that can be used to provide driving directions from the center of the search results to this search results</li>\n<li>ddUrlToHere - A URL that can be used to provide driving directions from this search result to a user specified location</li>\n<li>staticMapUrl - The published date, in RFC-822 format</li>\n</ul>\nThe query accepts one parameter: text - The string to search for","_type":{"!type":"string"},"_attributes":{"!type":"[]"}}},"GoogleVideoSearchStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.GoogleSearchStore.prototype","!doc":"A data store for retrieving search results from Google.\nThe following attributes are supported on each item:\n<ul>\n<li>title - The blog post title in HTML format.</li>\n<li>titleNoFormatting - The  blog post title in plain text</li>\n<li>content - A snippet of information about the blog post</li>\n<li>url - The URL for the item</li>\n<li>published - The published date, in RFC-822 format.</li>\n<li>publisher - The name of the publisher.</li>\n<li>duration - The approximate duration, in seconds, of the video.</li>\n<li>tbWidth - The width in pixels of the video.</li>\n<li>tbHeight - The height in pixels of the video</li>\n<li>tbUrl - The URL to a thumbnail representation of the video.</li>\n<li>playUrl - If present, supplies the url of the flash version of the video that can be played inline on your page. To play this video simply create and <embed> element on your page using this value as the src attribute and using application/x-shockwave-flash as the type attribute. If you want the video to play right away, make sure to append &autoPlay=true to the url..</li>\n</ul>\nThe query accepts one parameter: text - The string to search for","_type":{"!type":"string"},"_attributes":{"!type":"[]"}}},"GoogleNewsSearchStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.GoogleSearchStore.prototype","!doc":"A data store for retrieving search results from Google.\nThe following attributes are supported on each item:\n<ul>\n<li>title - The news story title in HTML format.</li>\n<li>titleNoFormatting - The news story title in plain text</li>\n<li>content - A snippet of information about the news story</li>\n<li>url - The URL for the item</li>\n<li>unescapedUrl - The URL for the item, with URL escaping. This is often more readable</li>\n<li>publisher - The name of the publisher</li>\n<li>clusterUrl - A URL pointing to a page listing related storied.</li>\n<li>location - The location of the news story.</li>\n<li>publishedDate - The date of publication, in RFC-822 format.</li>\n<li>relatedStories - An optional array of objects specifying related stories.\nEach object has the following subset of properties:\n\"title\", \"titleNoFormatting\", \"url\", \"unescapedUrl\", \"publisher\", \"location\", \"publishedDate\".\n</li>\n</ul>\nThe query accepts one parameter: text - The string to search for","_type":{"!type":"string"},"_attributes":{"!type":"[]"}}},"GoogleBookSearchStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.GoogleSearchStore.prototype","!doc":"A data store for retrieving search results from Google.\nThe following attributes are supported on each item:\n<ul>\n<li>title - The book title in HTML format.</li>\n<li>titleNoFormatting - The book title in plain text</li>\n<li>authors - An array of authors</li>\n<li>url - The URL for the item</li>\n<li>unescapedUrl - The URL for the item, with URL escaping. This is often more readable</li>\n<li>bookId - An identifier for the book, usually an ISBN.</li>\n<li>pageCount - The number of pages in the book.</li>\n<li>publishedYear - The year of publication.</li>\n</ul>\nThe query accepts one parameter: text - The string to search for","_type":{"!type":"string"},"_attributes":{"!type":"[]"}}},"GoogleImageSearchStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.GoogleSearchStore.prototype","!doc":"A data store for retrieving search results from Google.\nThe following attributes are supported on each item:\n<ul>\n<li>title - The image title in HTML format.</li>\n<li>titleNoFormatting - The image title in plain text</li>\n<li>url - The URL for the image</li>\n<li>unescapedUrl - The URL for the image, with URL escaping. This is often more readable</li>\n<li>tbUrl - The URL for the image thumbnail</li>\n<li>visibleUrl - A shortened version of the URL associated with the result, stripped of a protocol and path</li>\n<li>originalContextUrl - The URL of the page containing the image.</li>\n<li>width - The width of the image in pixels.</li>\n<li>height - The height of the image in pixels.</li>\n<li>tbWidth - The width of the image thumbnail in pixels.</li>\n<li>tbHeight - The height of the image thumbnail in pixels.</li>\n<li>content - A snippet of information about the image, in HTML format</li>\n<li>contentNoFormatting - A snippet of information about the image, in plain text</li>\n</ul>\nThe query accepts one parameter: text - The string to search for","_type":{"!type":"string"},"_attributes":{"!type":"[]"}}},"HtmlStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"Initializer for the HTML table store.","url":{"!doc":"url of the remote page to load","!type":"+The"},"dataId":{"!doc":"id of the table element in the remote page","!type":"+The"},"constructor":{"!type":"fn(args: ?)","!doc":"Initializer for the HTML table store."},"_indexItems":{"!type":"fn()"},"_getHeadings":{"!type":"fn()","!doc":"Function to load the attribute names from the table header so that the\nattributes (cells in a row), can have a reasonable name.\nFor list items, returns single implicit heading, [&quot;name&quot;]"},"_getAllItems":{"!type":"fn() -> []","!doc":"Function to return all rows in the table as an array of items."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: string) -> number","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getValue":{"!type":"fn(item: +item, attribute: ?, defaultValue?: +value) -> ?","!doc":"See dojo.data.api.Read.getValue()"},"getValues":{"!type":"fn(item: +item, attribute: ?) -> []","!doc":"See dojo.data.api.Read.getValues()"},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: +item, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttribute()"},"containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything) -> +boolean.","!doc":"See dojo.data.api.Read.containsValue()"},"_containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything, regexp?: +RegExp) -> bool","!doc":"Internal function for looking at the values contained by the item."},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItem()"},"isItemLoaded":{"!type":"fn(something: +anything)","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"_fetchItems":{"!type":"fn(request: +A, fetchHandler: +A, errorHandler: +A) -> ?","!doc":"Fetch items (XML elements) that match to a query"},"_finishFetchItems":{"!type":"fn(request: ?, fetchHandler: ?, errorHandler: ?)","!doc":"Internal function for processing the passed in request and locating the requested items."},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()\nnothing to do here!"},"getLabel":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"getIdentity":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentity()"},"getIdentityAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentityAttributes()\nIdentity isn't taken from a public attribute."},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?) -> ?","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"}}},"HtmlTableStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","url":{"!type":"string"},"tableId":{"!type":"string"},"constructor":{"!type":"fn(args: ?)"},"_getHeadings":{"!type":"fn()","!doc":"Function to load the attribute names from the table header so that the\nattributes (cells in a row), can have a reasonable name."},"_getAllItems":{"!type":"fn() -> []","!doc":"Function to return all rows in the table as an array of items."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: string) -> number","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getValue":{"!type":"fn(item: +item, attribute: ?, defaultValue?: +value) -> ?","!doc":"See dojo.data.api.Read.getValue()"},"getValues":{"!type":"fn(item: +item, attribute: ?) -> []","!doc":"See dojo.data.api.Read.getValues()"},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: +item, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttribute()"},"containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything) -> +boolean.","!doc":"See dojo.data.api.Read.containsValue()"},"_containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything, regexp?: +RegExp) -> bool","!doc":"Internal function for looking at the values contained by the item."},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItem()"},"isItemLoaded":{"!type":"fn(something: +anything)","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"_fetchItems":{"!type":"fn(request: +A, fetchHandler: +A, errorHandler: +A) -> ?","!doc":"Fetch items (XML elements) that match to a query"},"_finishFetchItems":{"!type":"fn(request: ?, fetchHandler: ?, errorHandler: ?)","!doc":"Internal function for processing the passed in request and locating the requested items."},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()\nnothing to do here!"},"getLabel":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"getIdentity":{"!type":"fn(item: +item) -> number","!doc":"See dojo.data.api.Identity.getIdentity()"},"getIdentityAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentityAttributes()\nIdentity isn't taken from a public attribute."},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?) -> ?","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"}}},"ItemExplorer":{"!type":"fn()","prototype":{"!proto":"dijit.Tree.prototype","useSelect":{"!type":"bool"},"refSelectSearchAttr":{},"store":{},"constructor":{"!type":"fn(options: ?)"},"postCreate":{"!type":"fn()"},"setStore":{"!type":"fn(store: ?)"},"setItem":{"!type":"fn(item: ?)"},"refreshItem":{"!type":"fn()"},"_createEditDialog":{"!type":"fn() -> +isFocused"},"_enableFields":{"!type":"fn(selection: ?)"},"_updateItem":{"!type":"fn(vals: ?)"},"_editProperty":{"!type":"fn()"},"_destroyProperty":{"!type":"fn()"},"_addProperty":{"!type":"fn()"}}},"JsonQueryRestStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.JsonRestStore.prototype","matchesQuery":{"!type":"fn(item: ?, request: ?)"}}},"JsonRestStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.ServiceStore.prototype","!doc":"JsonRestStore is a Dojo Data store interface to JSON HTTP/REST web\nstorage services that support read and write through GET, PUT, POST, and DELETE.\noptions:\nKeyword arguments\n\nThe *schema* parameter\nThis is a schema object for this store. This should be JSON Schema format.\n\nThe *service* parameter\nThis is the service object that is used to retrieve lazy data and save results\nThe function should be directly callable with a single parameter of an object id to be loaded\nThe function should also have the following methods:\nput(id,value) - puts the value at the given id\npost(id,value) - posts (appends) the value at the given id\ndelete(id) - deletes the value corresponding to the given id\nNote that it is critical that the service parses responses as JSON.\nIf you are using dojox.rpc.Service, the easiest way to make sure this\nhappens is to make the responses have a content type of\napplication/json. If you are creating your own service, make sure you\nuse handleAs: \"json\" with your XHR requests.\n\nThe *target* parameter\nThis is the target URL for this Service store. This may be used in place\nof a service parameter to connect directly to RESTful URL without\nusing a dojox.rpc.Service object.\n\nThe *idAttribute* parameter\nDefaults to 'id'. The name of the attribute that holds an objects id.\nThis can be a preexisting id provided by the server.\nIf an ID isn't already provided when an object\nis fetched or added to the store, the autoIdentity system\nwill generate an id for it and add it to the index.\n\nThe *syncMode* parameter\nSetting this to true will set the store to using synchronous calls by default.\nSync calls return their data immediately from the calling function, so\ncallbacks are unnecessary","referenceIntegrity":{"!type":"bool"},"target":{"!type":"string"},"constructor":{"!type":"fn(options: +Keyword)","!doc":"JsonRestStore is a Dojo Data store interface to JSON HTTP/REST web\nstorage services that support read and write through GET, PUT, POST, and DELETE."},"newItem":{"!type":"fn(data: ?, parentInfo: ?)","!doc":"adds a new item to the store at the specified point.\nTakes two parameters, data, and options."},"deleteItem":{"!type":"fn(item: +item)","!doc":"deletes item and any references to that item from the store."},"changing":{"!type":"fn(item: ?, _deleting: ?)","!doc":"adds an item to the list of dirty items.  This item\ncontains a reference to the item itself as well as a\ncloned and trimmed version of old item for use with\nrevert."},"setValue":{"!type":"fn(item: ?, attribute: ?, value: ?)","!doc":"sets 'attribute' on 'item' to 'value'"},"setValues":{"!type":"fn(item: ?, attribute: ?, values: ?)","!doc":"sets 'attribute' on 'item' to 'value' value\nmust be an array."},"unsetAttribute":{"!type":"fn(item: ?, attribute: ?)","!doc":"unsets 'attribute' on 'item'"},"save":{"!type":"fn(kwArgs: ?)","!doc":"Saves the dirty data using REST Ajax methods. See dojo.data.api.Write for API.\n\nkwArgs.global:\nThis will cause the save to commit the dirty data for all\nJsonRestStores as a single transaction."},"revert":{"!type":"fn(kwArgs: ?)"},"isDirty":{"!type":"fn(item: ?)"},"isItem":{"!type":"fn(item: ?, anyStore: bool)","!doc":"Checks to see if a passed 'item'\nreally belongs to this JsonRestStore."},"_doQuery":{"!type":"fn(args: ?)"},"_processResults":{"!type":"fn(results: ?, deferred: ?)"},"getConstructor":{"!type":"fn()","!doc":"Gets the constructor for objects from this store"},"getIdentity":{"!type":"fn(item: ?) -> string"},"fetchItemByIdentity":{"!type":"fn(args: ?)"},"onSet":{"!type":"fn()"},"onNew":{"!type":"fn()"},"onDelete":{"!type":"fn()"},"getFeatures":{"!type":"fn()","!doc":"return the store feature set"}}},"KeyValueStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"This is a dojo.data store implementation.  It can take in either a Javascript\narray, JSON string, or URL as the data source.  Data is expected to be in the\nfollowing format:\n[\n{ \"key1\": \"value1\" },\n{ \"key2\": \"value2\" }\n]\nThis is to mimic the Java Properties file format.  Each 'item' from this store\nis a JS object representing a key-value pair.  If an item in the above array has\nmore than one key/value pair, only the first will be used/accessed.","url":{"!type":"string"},"data":{"!type":"string"},"constructor":{"!type":"fn(keywordParameters: ?)","!doc":"constructor"},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(item: +item, attribute: string)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getValue":{"!type":"fn(item: +item, attribute: ?, defaultValue?: +value)","!doc":"See dojo.data.api.Read.getValue()"},"getValues":{"!type":"fn(item: +item, attribute: ?) -> []","!doc":"See dojo.data.api.Read.getValues()\nKey/Value syntax does not support multi-valued attributes, so this is just a\nwrapper function for getValue()."},"getAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: +item, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttribute()"},"containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything) -> +boolean.","!doc":"See dojo.data.api.Read.containsValue()"},"_containsValue":{"!type":"fn(item: +item, attribute: +attribute, value: +anything, regexp?: +RegExp) -> bool","!doc":"Internal function for looking at the values contained by the item."},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItem()"},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItemLoaded()\nThe KeyValueStore always loads all items, so if it's an item, then it's loaded."},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"getFeatures":{"!type":"fn() -> ?","!doc":"See dojo.data.api.Read.getFeatures()"},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()"},"getLabel":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"_fetchItems":{"!type":"fn(keywordArgs: ?, findCallback: fn(), errorCallback: fn())","!doc":"See dojo.data.util.simpleFetch.fetch()"},"_handleQueuedFetches":{"!type":"fn()","!doc":"Internal function to execute delayed request in the store.\nExecute any deferred fetches now."},"_processData":{"!type":"fn(data: [])"},"_createItem":{"!type":"fn(something: ?) -> ?"},"getIdentity":{"!type":"fn(item: +item) -> string","!doc":"See dojo.data.api.Identity.getIdentity()"},"getIdentityAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentifierAttributes()"},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"},"_finishFetchItemByIdentity":{"!type":"fn(items: [], request: ?)"}}},"OpenSearchStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"Initializer for the OpenSearchStore store.","url":{"!type":"string"},"itemPath":{"!type":"string"},"_storeRef":{"!type":"string"},"urlElement":{},"iframeElement":{},"ATOM_CONTENT_TYPE":{"!type":"number"},"ATOM_CONTENT_TYPE_STRING":{"!type":"string"},"RSS_CONTENT_TYPE":{"!type":"number"},"RSS_CONTENT_TYPE_STRING":{"!type":"string"},"XML_CONTENT_TYPE":{"!type":"number"},"XML_CONTENT_TYPE_STRING":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initializer for the OpenSearchStore store."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"getValue":{"!type":"fn(item: ?, attribute: ?, defaultValue: ?)","!doc":"See dojo.data.api.Read.getValue()"},"getAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttributes()"},"isItemLoaded":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"getLabel":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"containsValue":{"!type":"fn(item: ?, attribute: ?, value: ?)","!doc":"See dojo.data.api.Read.containsValue()"},"getValues":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.getValue()"},"isItem":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItem()"},"close":{"!type":"fn(request: ?)","!doc":"See dojo.data.api.Read.close()"},"process":{"!type":"fn(data: ?)"},"processItem":{"!type":"fn(item: ?, attribute: ?)"},"_createSearchUrl":{"!type":"fn(request: ?)"},"_fetchItems":{"!type":"fn(request: +A, fetchHandler: +A, errorHandler: +A)","!doc":"Fetch OpenSearch items that match to a query"},"_processOSDxml":{"!type":"fn(data: ?)"},"_processItemxml":{"!type":"fn(item: ?, attribute: ?)"},"_processOSDatom":{"!type":"fn(data: ?)"},"_processItematom":{"!type":"fn(item: ?, attribute: ?)"},"_processOSDrss":{"!type":"fn(data: ?)"},"_processItemrss":{"!type":"fn(item: ?, attribute: ?)"},"_processOSDfeed":{"!type":"fn(data: ?, type: ?)"},"_processItemfeed":{"!type":"fn(item: ?, attribute: ?, type: ?)"},"_getNodeXml":{"!type":"fn(node: ?, skipFirst: ?)"},"_processOsdd":{"!type":"fn(doc: ?)"}}},"OpmlStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"The OpmlStore implements the dojo.data.api.Read API.","label":{"!type":"string"},"url":{"!type":"string"},"constructor":{"!type":"fn(keywordParameters: ?)","!doc":"constructor"},"_assertIsItem":{"!type":"fn(item: +item)"},"_assertIsAttribute":{"!type":"fn(attribute: +item)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"_removeChildNodesThatAreNotElementNodes":{"!type":"fn(node: +node, recursive: bool)"},"_processRawXmlTree":{"!type":"fn(rawXmlTree: +xmlDoc)"},"_checkChildNodes":{"!type":"fn(node: +Node)","!doc":"Internal function to recurse over all child nodes from the store and add them\nAs non-toplevel items"},"_getItemsArray":{"!type":"fn(queryOptions?: ?)","!doc":"Internal function to determine which list of items to search over."},"getValue":{"!type":"fn(item: +item, attribute: +attribute, defaultValue?: +value) -> ?","!doc":"See dojo.data.api.Read.getValue()"},"getValues":{"!type":"fn(item: +item, attribute: +attribute) -> []","!doc":"See dojo.data.api.Read.getValues()"},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: +item, attribute: +attribute) -> bool","!doc":"See dojo.data.api.Read.hasAttribute()"},"containsValue":{"!type":"fn(item: +item, attribute: +attribute, value: +anything) -> +boolean.","!doc":"See dojo.data.api.Read.containsValue()"},"_containsValue":{"!type":"fn(item: +item, attribute: +attribute, value: +anything, regexp?: +RegExp) -> bool","!doc":"Internal function for looking at the values contained by the item."},"isItem":{"!type":"fn(something: +anything)","!doc":"See dojo.data.api.Read.isItem()"},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"See dojo.data.api.Read.isItemLoaded()\nOpmlStore loads every item, so if it's an item, then it's loaded."},"loadItem":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Read.loadItem()"},"getLabel":{"!type":"fn(item: +item) -> string","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"_fetchItems":{"!type":"fn(keywordArgs: ?, findCallback: fn(), errorCallback: fn())","!doc":"See dojo.data.util.simpleFetch.fetch()"},"getFeatures":{"!type":"fn() -> ?","!doc":"See dojo.data.api.Read.getFeatures()"},"getIdentity":{"!type":"fn(item: +item) -> +null","!doc":"See dojo.data.api.Identity.getIdentity()"},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"},"getIdentityAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentifierAttributes()"},"_handleQueuedFetches":{"!type":"fn()","!doc":"Internal function to execute delayed request in the store.\nExecute any deferred fetches now."},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()"}}},"PersevereStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.JsonQueryRestStore.prototype","useFullIdInQueries":{"!type":"bool"},"jsonQueryPagination":{"!type":"bool"}},"getStores":{"!type":"fn(path?: string, sync?: bool)","!doc":"Creates Dojo data stores for all the table/classes on a Persevere server"},"addProxy":{"!type":"fn()","!doc":"Invokes the XHR proxy plugin. Call this if you will be using x-site data."}},"PicasaStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"Initializer for the PicasaStore store.","_picasaUrl":{"!type":"string"},"_storeRef":{"!type":"string"},"label":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initializer for the PicasaStore store."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"getValue":{"!type":"fn(item: ?, attribute: ?, defaultValue: ?)","!doc":"See dojo.data.api.Read.getValue()"},"getAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttributes()"},"isItemLoaded":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"getLabel":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"containsValue":{"!type":"fn(item: ?, attribute: ?, value: ?)","!doc":"See dojo.data.api.Read.containsValue()"},"getValues":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.getValue()"},"isItem":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItem()"},"close":{"!type":"fn(request: ?)","!doc":"See dojo.data.api.Read.close()"},"_fetchItems":{"!type":"fn(request: +A, fetchHandler: +A, errorHandler: +A)","!doc":"Fetch picasa items that match to a query"},"_processPicasaData":{"!type":"fn(data: ?)"},"_unescapeHtml":{"!type":"fn(str: +String.)","!doc":"Utility function to un-escape XML special characters in an HTML string."}}},"QueryReadStore":{"!type":"fn()","prototype":{"!doc":"By default all the sorting is done serverside before the data is returned\nwhich is the proper place to be doing it for really large datasets.","url":{"!type":"string"},"requestMethod":{"!type":"string"},"_className":{"!type":"string"},"_items":{"!type":"[]"},"_lastServerQuery":{},"_numRows":{"!type":"number"},"lastRequestHash":{},"doClientPaging":{"!type":"bool"},"doClientSorting":{"!type":"bool"},"_itemsByIdentity":{},"_identifier":{},"_features":{},"_labelAttr":{"!type":"string"},"constructor":{"!type":"fn(params: ?)"},"getValue":{"!type":"fn(item: +item, attribute: ?, defaultValue?: +value)"},"getValues":{"!type":"fn(item: +item, attribute: ?)"},"getAttributes":{"!type":"fn(item: +item)"},"hasAttribute":{"!type":"fn(item: +item, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttribute()"},"containsValue":{"!type":"fn(item: +item, attribute: ?, value: +anything)"},"isItem":{"!type":"fn(something: +anything)"},"isItemLoaded":{"!type":"fn(something: +anything)"},"loadItem":{"!type":"fn(args: ?)"},"fetch":{"!type":"fn(request?: ?) -> ?","!doc":"See dojo.data.util.simpleFetch.fetch() this is just a copy and I adjusted\nonly the paging, since it happens on the server if doClientPaging is\nfalse, thx to http://trac.dojotoolkit.org/ticket/4761 reporting this.\nWould be nice to be able to use simpleFetch() to reduce copied code,\nbut i dont know how yet. Ideas please!"},"getFeatures":{"!type":"fn()"},"close":{"!type":"fn(request: +dojo.data.api.Request)"},"getLabel":{"!type":"fn(item: +item) -> string","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"_xhrFetchHandler":{"!type":"fn(data: ?, request: ?, fetchHandler: ?, errorHandler: ?)"},"_fetchItems":{"!type":"fn(request: ?, fetchHandler: ?, errorHandler: ?)","!doc":"The request contains the data as defined in the Read-API.\nAdditionally there is following keyword &quot;serverQuery&quot;.\n\nThe *serverQuery* parameter, optional.\nThis parameter contains the data that will be sent to the server.\nIf this parameter is not given the parameter &quot;query&quot;'s\ndata are sent to the server. This is done for some reasons:\n- to specify explicitly which data are sent to the server, they\nmight also be a mix of what is contained in &quot;query&quot;, &quot;queryOptions&quot;\nand the paging parameters &quot;start&quot; and &quot;count&quot; or may be even\ncompletely different things.\n- don't modify the request.query data, so the interface using this\nstore can rely on unmodified data, as the combobox dijit currently\ndoes it, it compares if the query has changed\n- request.query is required by the Read-API\n\nI.e. the following examples might be sent via GET:\nfetch({query:{name:&quot;abc&quot;}, queryOptions:{ignoreCase:true}})\nthe URL will become:   /url.php?name=abc\n\nfetch({serverQuery:{q:&quot;abc&quot;, c:true}, query:{name:&quot;abc&quot;}, queryOptions:{ignoreCase:true}})\nthe URL will become:   /url.php?q=abc&amp;c=true\n// The serverQuery-parameter has overruled the query-parameter\n// but the query parameter stays untouched, but is not sent to the server!\n// The serverQuery contains more data than the query, so they might differ!"},"_filterResponse":{"!type":"fn(data: +The)","!doc":"If the data from servers needs to be processed before it can be processed by this\nstore, then this function should be re-implemented in subclass. This default\nimplementation just return the data unchanged."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"It throws an error if item is not valid, so you can call it in every method that needs to\nthrow an error when item is invalid."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Identity.fetchItemByIdentity()"},"getIdentity":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentity()"},"getIdentityAttributes":{"!type":"fn(item: +item)","!doc":"See dojo.data.api.Identity.getIdentityAttributes()"}},"_features":{"dojo":{"data":{"api":{"Read":{"!type":"bool"},"Identity":{"!type":"bool"}}}}}},"RailsStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.JsonRestStore.prototype","!doc":"RailsStore is a data store for interacting with RESTful Rails controllers","constructor":{"!type":"fn()","!doc":"RailsStore is a data store for interacting with RESTful Rails controllers"},"preamble":{"!type":"fn(options: ?)"},"fetch":{"!type":"fn(args: ?)"},"_processResults":{"!type":"fn(results: ?, deferred: ?)"}}},"S3Store":{"!type":"fn()","prototype":{"!proto":"dojox.data.JsonRestStore.prototype","_processResults":{"!type":"fn(results: ?)"}}},"ServiceStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.ClientFilter.prototype","!doc":"ServiceStore constructor, instantiate a new ServiceStore\nA ServiceStore can be configured from a JSON Schema. Queries are just\npassed through to the underlying services\n\noptions:\nKeyword arguments\nThe *schema* parameter\nThis is a schema object for this store. This should be JSON Schema format.\n\nThe *service* parameter\nThis is the service object that is used to retrieve lazy data and save results\nThe function should be directly callable with a single parameter of an object id to be loaded\n\nThe *idAttribute* parameter\nDefaults to 'id'. The name of the attribute that holds an objects id.\nThis can be a preexisting id provided by the server.\nIf an ID isn't already provided when an object\nis fetched or added to the store, the autoIdentity system\nwill generate an id for it and add it to the index.\n\nThe *estimateCountFactor* parameter\nThis parameter is used by the ServiceStore to estimate the total count. When\npaging is indicated in a fetch and the response includes the full number of items\nrequested by the fetch's count parameter, then the total count will be estimated\nto be estimateCountFactor multiplied by the provided count. If this is 1, then it is assumed that the server\ndoes not support paging, and the response is the full set of items, where the\ntotal count is equal to the numer of items returned. If the server does support\npaging, an estimateCountFactor of 2 is a good value for estimating the total count\nIt is also possible to override _processResults if the server can provide an exact\ntotal count.\n\nThe *syncMode* parameter\nSetting this to true will set the store to using synchronous calls by default.\nSync calls return their data immediately from the calling function, so\ncallbacks are unnecessary. This will only work with a synchronous capable service.","schema":{},"idAttribute":{"!type":"string"},"syncMode":{"!type":"bool"},"estimateCountFactor":{"!type":"number"},"loadLazyValues":{"!type":"bool"},"_currentId":{"!type":"number"},"constructor":{"!type":"fn(options: +Keyword)","!doc":"ServiceStore constructor, instantiate a new ServiceStore\nA ServiceStore can be configured from a JSON Schema. Queries are just\npassed through to the underlying services"},"getSchema":{"!type":"fn()"},"getValue":{"!type":"fn(item: ?, property: string, defaultValue?: +value)","!doc":"Gets the value of an item's 'property'"},"getValues":{"!type":"fn(item: ?, property: string)","!doc":"Gets the value of an item's 'property' and returns\nit.  If this value is an array it is just returned,\nif not, the value is added to an array and that is returned."},"getAttributes":{"!type":"fn(item: ?)","!doc":"Gets the available attributes of an item's 'property' and returns\nit as an array."},"hasAttribute":{"!type":"fn(item: ?, attribute: string)","!doc":"Checks to see if item has attribute"},"containsValue":{"!type":"fn(item: ?, attribute: string, value: +anything)","!doc":"Checks to see if 'item' has 'value' at 'attribute'"},"isItem":{"!type":"fn(item: ?)","!doc":"Checks to see if the argument is an item"},"isItemLoaded":{"!type":"fn(item: ?)","!doc":"Checks to see if the item is loaded."},"loadItem":{"!type":"fn(args: ?)","!doc":"Loads an item and calls the callback handler. Note, that this will call the callback\nhandler even if the item is loaded. Consequently, you can use loadItem to ensure\nthat an item is loaded is situations when the item may or may not be loaded yet.\nIf you access a value directly through property access, you can use this to load\na lazy value as well (doesn't need to be an item)."},"_processResults":{"!type":"fn(results: ?, deferred: ?)"},"close":{"!type":"fn(request: ?)"},"fetch":{"!type":"fn(args: ?)","!doc":"See dojo.data.api.Read.fetch\n\nThe *queryOptions.cache* parameter\nIf true, indicates that the query result should be cached for future use. This is only available\nif dojox.data.ClientFilter has been loaded before the ServiceStore\n\nThe *syncMode* parameter\nIndicates that the call should be fetch synchronously if possible (this is not always possible)\n\nThe *clientFetch* parameter\nThis is a fetch keyword argument for explicitly doing client side filtering, querying, and paging"},"_doQuery":{"!type":"fn(args: ?)"},"getFeatures":{"!type":"fn()","!doc":"return the store feature set"},"getLabel":{"!type":"fn(item: ?)"},"getLabelAttributes":{"!type":"fn(item: ?)","!doc":"returns an array of attributes that are used to create the label of an item"},"getIdentity":{"!type":"fn(item: ?)"},"getIdentityAttributes":{"!type":"fn(item: ?)","!doc":"returns the attributes which are used to make up the\nidentity of an item.  Basically returns this.idAttribute"},"fetchItemByIdentity":{"!type":"fn(args: ?)","!doc":"fetch an item by its identity, by looking in our index of what we have loaded"}}},"SnapLogicStore":{"!type":"fn()","prototype":{"!doc":"Initialize a SnapLogicStore object.\nargs:\nAn object that contains properties for initializing the new data store object. The\nfollowing properties are understood:","url":{"!doc":"URL to the SnapLogic pipeline's output routed through PipeToHttp. Typically, this\nwill look like &quot;http://&lt;server-host&gt;:&lt;port&gt;/pipe/&lt;pipeline-url&gt;/&lt;pipeline-output-view&gt;&quot;.\nparameters:\nAn object whose properties define parameters to the pipeline. The values of these\nproperties will be sent to the pipeline as parameters when it run.","!type":"+A"},"constructor":{"!type":"fn(args: ?)","!doc":"Initialize a SnapLogicStore object."},"_assertIsItem":{"!type":"fn(item: +item)","!doc":"This function tests whether the item passed in is indeed an item in the store."},"_assertIsAttribute":{"!type":"fn(attribute: ?)","!doc":"This function tests whether the item passed in is indeed a valid 'attribute' like type for the store."},"getFeatures":{"!type":"fn()","!doc":"See dojo.data.api.Read.getFeatures()"},"getValue":{"!type":"fn(item: ?, attribute: ?, defaultValue: ?)","!doc":"See dojo.data.api.Read.getValue()"},"getAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getAttributes()"},"hasAttribute":{"!type":"fn(item: ?, attribute: ?)","!doc":"See dojo.data.api.Read.hasAttributes()"},"isItemLoaded":{"!type":"fn(item: ?) -> bool","!doc":"See dojo.data.api.Read.isItemLoaded()"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Read.loadItem()"},"getLabel":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"containsValue":{"!type":"fn(item: ?, attribute: ?, value: ?) -> bool","!doc":"See dojo.data.api.Read.containsValue()"},"getValues":{"!type":"fn(item: ?, attribute: ?) -> []","!doc":"See dojo.data.api.Read.getValue()"},"isItem":{"!type":"fn(item: ?)","!doc":"See dojo.data.api.Read.isItem()"},"close":{"!type":"fn(request: ?)","!doc":"See dojo.data.api.Read.close()"},"_fetchHandler":{"!type":"fn(request: ?)","!doc":"Process data retrieved via fetch and send it back to requester.\nresponse:\nThe data returend from the I/O transport. In the normal case, it will be an array of result rows\nfrom the pipeline. In the special case for record count optimization, response will be an array\nwith a single element containing the total pipeline result row count. See fetch() for details\non this optimization."},"_partHandler":{"!type":"fn(request: ?, part: string, response: ?)","!doc":"Handle the individual replies for both data and length requests."},"fetch":{"!type":"fn(request: ?) -> ?","!doc":"See dojo.data.api.Read.close()"}},"Parts":{"DATA":{"!type":"string"},"COUNT":{"!type":"string"}}},"StoreExplorer":{"!type":"fn()","prototype":{"!proto":"dijit.layout.BorderContainer.prototype","store":{},"stringQueries":{"!type":"bool"},"constructor":{"!type":"fn(options: ?)"},"postCreate":{"!type":"fn()"},"setQuery":{"!type":"fn(query: ?)"},"_formatCell":{"!type":"fn(value: ?)"},"setStore":{"!type":"fn(store: ?)"},"createNew":{"!type":"fn()"}}},"WikipediaStore":{"!type":"fn()","prototype":{"!proto":"dojox.data.ServiceStore.prototype","!doc":"Initializer for the Wikipedia data store interface.","constructor":{"!type":"fn(options: ?)"},"fetch":{"!type":"fn(request: ?)","!doc":"Fetch a page or some partially-loaded search results from\nWikipedia. Note that there isn't a way to sort data coming\nin from the API, so we just ignore the *sort* parameter."},"_processResults":{"!type":"fn(results: ?, def: ?)"}}},"XmlStore":{"!type":"fn()","prototype":{"!proto":"dojo.data.util.simpleFetch.prototype","!doc":"A data store for XML based services or documents","url":{"!doc":"url to a service or an XML document that represents the store","!type":"+The"},"rootItem":{"!doc":"tag name for root items","!type":"+A"},"keyAttribute":{"!doc":"attribute name for a key or an identity (unique identifier)\nRequired for serverside fetchByIdentity, etc.  Not required for\nclient side fetchItemBIdentity, as it will use an XPath-like\nstructure if keyAttribute was not specified.  Recommended to always\nset this, though, for consistent identity behavior.","!type":"+An"},"label":{"!type":"string"},"sendQuery":{"!doc":"boolean indicate to add a query string to the service URL.\nDefault is false.","!type":"+A"},"attributeMap":{"!doc":"anonymous object contains properties for attribute mapping,\n{&quot;tag_name.item_attribute_name&quot;: &quot;@xml_attribute_name&quot;, ...}","!type":"+An"},"constructor":{"!type":"fn(args: ?)","!doc":"Constructor for the XML store."},"getValue":{"!type":"fn(item: +item, attribute: +attribute, defaultValue?: +value) -> ?","!doc":"Return an attribute value"},"getValues":{"!type":"fn(item: +item, attribute: +attribute) -> []","!doc":"Return an array of attribute values"},"getAttributes":{"!type":"fn(item: +item) -> []","!doc":"Return an array of attribute names"},"hasAttribute":{"!type":"fn(item: +item, attribute: +attribute) -> bool","!doc":"Check whether an element has the attribute"},"containsValue":{"!type":"fn(item: +item, attribute: +attribute, value: +anything) -> bool","!doc":"Check whether the attribute values contain the value"},"isItem":{"!type":"fn(something: +anything) -> bool","!doc":"Check whether the object is an item (XML element)\nitem:\nAn object to check"},"isItemLoaded":{"!type":"fn(something: +anything) -> bool","!doc":"Check whether the object is an item (XML element) and loaded\nitem:\nAn object to check"},"loadItem":{"!type":"fn(keywordArgs: ?)","!doc":"Load an item (XML element)"},"getFeatures":{"!type":"fn() -> []","!doc":"Return supported data APIs"},"getLabel":{"!type":"fn(item: +item) -> +undefined","!doc":"See dojo.data.api.Read.getLabel()"},"getLabelAttributes":{"!type":"fn(item: +item) -> []","!doc":"See dojo.data.api.Read.getLabelAttributes()"},"_fetchItems":{"!type":"fn(request: +A, fetchHandler: +A, errorHandler: +A)","!doc":"Fetch items (XML elements) that match to a query"},"_getFetchUrl":{"!type":"fn(request: +A)","!doc":"Generate a URL for fetch"},"_getItems":{"!type":"fn(document: +An, request: +A)","!doc":"Fetch items (XML elements) in an XML document based on a request"},"_flattenNodes":{"!type":"fn(nodes: ?)"},"close":{"!type":"fn(request: +dojo.data.api.Request)","!doc":"See dojo.data.api.Read.close()"},"newItem":{"!type":"fn(keywordArgs?: ?, parentInfo: ?) -> ?","!doc":"Return a new dojox.data.XmlItem"},"deleteItem":{"!type":"fn(item: +item) -> bool","!doc":"Delete an dojox.data.XmlItem (wrapper to a XML element)."},"setValue":{"!type":"fn(item: +item, attribute: +attribute, value: +almost) -> bool","!doc":"Set an attribute value"},"setValues":{"!type":"fn(item: +item, attribute: +attribute, values: []) -> bool","!doc":"Set attribute values"},"unsetAttribute":{"!type":"fn(item: +item, attribute: +attribute) -> bool","!doc":"Remove an attribute"},"save":{"!type":"fn(keywordArgs: ?)","!doc":"Save new and/or modified items (XML elements)"},"revert":{"!type":"fn() -> bool","!doc":"Invalidate changes (new and/or modified elements)"},"isDirty":{"!type":"fn(item?: +item)","!doc":"Check whether an item is new, modified or deleted"},"_saveItem":{"!type":"fn(item: ?, keywordArgs: ?, method: ?)"},"_getPostUrl":{"!type":"fn(item: +An) -> string","!doc":"Generate a URL for post"},"_getPutUrl":{"!type":"fn(item: +An) -> string","!doc":"Generate a URL for put"},"_getDeleteUrl":{"!type":"fn(item: +An) -> string","!doc":"Generate a URL for delete"},"_getPostContent":{"!type":"fn(item: +An)","!doc":"Generate a content to post"},"_getPutContent":{"!type":"fn(item: +An)","!doc":"Generate a content to put"},"_getAttribute":{"!type":"fn(tagName: ?, attribute: ?) -> ?"},"_getItem":{"!type":"fn(element: ?) -> ?"},"_getItemIndex":{"!type":"fn(items: ?, element: ?) -> number"},"_backupItem":{"!type":"fn(item: ?)"},"_restoreItems":{"!type":"fn(items: ?)"},"_forgetItem":{"!type":"fn(item: ?)"},"_getDocument":{"!type":"fn(element: ?) -> +DOMDocument"},"_getRootElement":{"!type":"fn(element: ?) -> +DOMElement"},"_getXPath":{"!type":"fn(element: ?) -> string","!doc":"A function to compute the xpath of a node in a DOM document."},"getIdentity":{"!type":"fn(item: +item) -> +String.","!doc":"Returns a unique identifier for an item."},"getIdentityAttributes":{"!type":"fn(item: +item) -> []","!doc":"Returns an array of attribute names that are used to generate the identity."},"fetchItemByIdentity":{"!type":"fn(keywordArgs: ?)","!doc":"See dojo.data.api.Identity.fetchItemByIdentity(keywordArgs)"}}},"XmlItem":{"!type":"fn()","prototype":{"!doc":"A data item of 'XmlStore'","constructor":{"!type":"fn(element: +An, store: +The, query: +The)","!doc":"Initialize with an XML element"},"toString":{"!type":"fn() -> string","!doc":"Return a value of the first text child of the element"}}},"css":{"rules":{"forEach":{"!type":"fn(fn: ?, ctx: ?, context: ?)"}},"findStyleSheets":{"!type":"fn(sheets: ?)"},"findStyleSheet":{"!type":"fn(sheet: ?)"},"determineContext":{"!type":"fn(initialStylesheets: ?)"}},"dom":{"createDocument":{"!type":"fn(str?: string, mimetype?: string) -> +DOMDocument.","!doc":"cross-browser implementation of creating an XML document object."},"textContent":{"!type":"fn(node: +Node, text?: string) -> string","!doc":"Implementation of the DOM Level 3 attribute; scan node for text"},"replaceChildren":{"!type":"fn(node: +Element, newChildren: +Node)","!doc":"Removes all children of node and appends newChild. All the existing\nchildren will be destroyed."},"removeChildren":{"!type":"fn(node: +Element) -> number","!doc":"removes all children from node and returns the count of children removed.\nThe children nodes are not destroyed. Be sure to call dojo._destroyElement on them\nafter they are not used anymore."},"innerXML":{"!type":"fn(node: +Node) -> string","!doc":"Implementation of MS's innerXML function."}},"jsonPathStore":{"!type":"fn()","!doc":"jsonPathStore constructor, instantiate a new jsonPathStore\n\nTakes a single optional parameter in the form of a Javascript object\ncontaining one or more of the following properties.\n\ndata: /*JSON String*/ || /* Javascript Object */,\nJSON String or Javascript object this store will control\nJSON is converted into an object, and an object passed to\nthe store will be used directly.  If no data and no url\nis provide, an empty object, {}, will be used as the initial\nstore.","mode":{"!doc":"|| dojox.data.SYNC_MODE\nDefaults to ASYNC_MODE.  This option sets the default mode for this store.\nSync calls return their data immediately from the calling function\ninstead of calling the callback functions.  Functions such as\nfetchItemByIdentity() and fetch() both accept a string parameter in addtion\nto the normal keywordArgs parameter.  When passed this option, SYNC_MODE will\nautomatically be used even when the default mode of the system is ASYNC_MODE.\nA normal request to fetch or fetchItemByIdentity (with kwArgs object) can also\ninclude a mode property to override this setting for that one request.","!type":"+dojox.data.ASYNC_MODE"},"prototype":{"metaLabel":{"!doc":"Defaults to '_meta' overrides the attribute name that is used by the store\nfor attaching meta information to an object while\nin the store's control.  Defaults to '_meta'.","!type":"string"},"hideMetaAttributes":{"!doc":"Defaults to False.  When enabled, calls to getAttributes() will not\ninclude the meta attribute.","!type":"bool"},"autoIdPrefix":{"!doc":"Defaults to &quot;_auto_&quot;.  This string is used as the prefix to any\nobjects which have a generated id. A numeric index is appended\nto this string to complete the ID","!type":"string"},"autoIdentity":{"!type":"bool"},"idAttribute":{"!doc":"Defaults to '_id'. The name of the attribute that holds an objects id.\nThis can be a preexisting id provided by the server.\nIf an ID isn't already provided when an object\nis fetched or added to the store, the autoIdentity system\nwill generate an id for it and add it to the index. There\nare utility routines for exporting data from the store\nthat can clean any generated IDs before exporting and leave\npreexisting id's in tact.","!type":"string"},"indexOnLoad":{"!doc":"*/\nDefaults to true, but this may change in the near future.\nParse the data object and set individual objects up as\nappropriate.  This will add meta data and assign\nid's to objects that dont' have them as defined by the\nidAttribute option.  Disabling this option will keep this\nparsing from happening until a query is performed at which\ntime only the top level of an item has meta info stored.\nThis might work in some situations, but you will almost\nalways want to indexOnLoad or use another option which\nwill create an index.  In the future we will support a\ngenerated index that maps by jsonPath allowing the\nserver to take some of this load for larger data sets.","!type":"bool"},"labelAttribute":{"!type":"string"},"url":{"!doc":"url */\nLoad data from this url in JSON format and use the Object\ncreated from the data as the data source.","!type":"string"},"_replaceRegex":{"!type":"+RegExp"},"noRevert":{"!type":"bool"},"constructor":{"!type":"fn(options: ?)","!doc":"jsonPathStore constructor, instantiate a new jsonPathStore\n\nTakes a single optional parameter in the form of a Javascript object\ncontaining one or more of the following properties.\n\ndata: /*JSON String*/ || /* Javascript Object */,\nJSON String or Javascript object this store will control\nJSON is converted into an object, and an object passed to\nthe store will be used directly.  If no data and no url\nis provide, an empty object, {}, will be used as the initial\nstore.\n\nurl: /* string url */\nLoad data from this url in JSON format and use the Object\ncreated from the data as the data source.\n\nindexOnLoad: /* boolean */\nDefaults to true, but this may change in the near future.\nParse the data object and set individual objects up as\nappropriate.  This will add meta data and assign\nid's to objects that dont' have them as defined by the\nidAttribute option.  Disabling this option will keep this\nparsing from happening until a query is performed at which\ntime only the top level of an item has meta info stored.\nThis might work in some situations, but you will almost\nalways want to indexOnLoad or use another option which\nwill create an index.  In the future we will support a\ngenerated index that maps by jsonPath allowing the\nserver to take some of this load for larger data sets.\n\nidAttribute: /* string\nDefaults to '_id'. The name of the attribute that holds an objects id.\nThis can be a preexisting id provided by the server.\nIf an ID isn't already provided when an object\nis fetched or added to the store, the autoIdentity system\nwill generate an id for it and add it to the index. There\nare utility routines for exporting data from the store\nthat can clean any generated IDs before exporting and leave\npreexisting id's in tact.\n\nmetaLabel: /* string\nDefaults to '_meta' overrides the attribute name that is used by the store\nfor attaching meta information to an object while\nin the store's control.  Defaults to '_meta'.\n\nhideMetaAttributes: /* boolean\nDefaults to False.  When enabled, calls to getAttributes() will not\ninclude the meta attribute.\n\nautoIdPrefix: /*string\nDefaults to &quot;_auto_&quot;.  This string is used as the prefix to any\nobjects which have a generated id. A numeric index is appended\nto this string to complete the ID\n\nmode: dojox.data.ASYNC_MODE || dojox.data.SYNC_MODE\nDefaults to ASYNC_MODE.  This option sets the default mode for this store.\nSync calls return their data immediately from the calling function\ninstead of calling the callback functions.  Functions such as\nfetchItemByIdentity() and fetch() both accept a string parameter in addtion\nto the normal keywordArgs parameter.  When passed this option, SYNC_MODE will\nautomatically be used even when the default mode of the system is ASYNC_MODE.\nA normal request to fetch or fetchItemByIdentity (with kwArgs object) can also\ninclude a mode property to override this setting for that one request."},"_loadData":{"!type":"fn(data: ?)","!doc":"load data into the store. Index it if appropriate."},"onLoadData":{"!type":"fn(data: ?)"},"setData":{"!type":"fn(data: ?)","!doc":"set the stores' data to the supplied object and then\nload and/or setup that data with the required meta info"},"buildIndex":{"!type":"fn(path: string, item: ?)","!doc":"parse the object structure, and turn any objects into\njsonPathStore items. Basically this just does a recursive\nseries of fetches which itself already examines any items\nas they are retrieved and setups up the required meta information."},"_correctReference":{"!type":"fn(item: ?)","!doc":"make sure we have an reference to the item in the store\nand not a clone. Takes an item, matches it to the corresponding\nitem in the store and if it is the same, returns itself, otherwise\nit returns the item from the store."},"getValue":{"!type":"fn(item: ?, property: string)","!doc":"Gets the value of an item's 'property'"},"getValues":{"!type":"fn(item: ?, property: string)","!doc":"Gets the value of an item's 'property' and returns\nit.  If this value is an array it is just returned,\nif not, the value is added to an array and that is returned."},"getAttributes":{"!type":"fn(item: ?)","!doc":"Gets the available attributes of an item's 'property' and returns\nit as an array. If the store has 'hideMetaAttributes' set to true\nthe attributed identified by 'metaLabel' will not be included."},"hasAttribute":{"!type":"fn(item: ?, attribute: string)","!doc":"Checks to see if item has attribute"},"containsValue":{"!type":"fn(item: ?, attribute: string, value: +anything)","!doc":"Checks to see if 'item' has 'value' at 'attribute'"},"_shallowCompare":{"!type":"fn(a: ?, b: ?)"},"isItem":{"!type":"fn(item: ?)","!doc":"Checks to see if a passed 'item'\nis really a jsonPathStore item.  Currently\nit only verifies structure.  It does not verify\nthat it belongs to this store at this time."},"isItemLoaded":{"!type":"fn(item: ?)","!doc":"returns isItem() :)"},"loadItem":{"!type":"fn(item: ?)","!doc":"returns true. Future implementatins might alter this"},"_updateMeta":{"!type":"fn(item: ?, props: ?)","!doc":"verifies that 'item' has a meta object attached\nand if not it creates it by setting it to 'props'\nif the meta attribute already exists, mix 'props'\ninto it."},"cleanMeta":{"!type":"fn(data: ?, options: ?)"},"fetch":{"!type":"fn(args: ?)"},"dump":{"!type":"fn(options: ?)","!doc":"exports the store data set. Takes an options\nobject with a number of parameters\n\ndata: /* object\nDefaults to the root of the store.\nThe data to be exported.\n\nclone: /* boolean\nclone the data set before returning it\nor modifying it for export\n\ncleanMeta: /* boolean\nclean the meta data off of the data. Note\nthat this will happen to the actual\nstore data if !clone. If you want\nto continue using the store after\nthis operation, it is probably better to export\nit as a clone if you want it cleaned.\n\nsuppressExportMeta: /* boolean\nBy default, when data is exported from the store\nsome information, such as as a timestamp, is\nadded to the root of exported data.  This\nprevents that from happening.  It is mainly used\nfor making tests easier.\n\ntype: &quot;raw&quot; || &quot;json&quot;\nDefaults to 'json'. 'json' will convert the data into\njson before returning it. 'raw' will just return a\nreference to the object"},"getFeatures":{"!type":"fn()","!doc":"return the store feature set"},"getLabel":{"!type":"fn(item: ?)"},"getLabelAttributes":{"!type":"fn(item: ?)","!doc":"returns an array of attributes that are used to create the label of an item"},"sort":{"!type":"fn(a: ?, b: ?)"},"getIdentity":{"!type":"fn(item: ?)"},"getIdentityAttributes":{"!type":"fn(item: ?)","!doc":"returns the attributes which are used to make up the\nidentity of an item.  Basically returns this.idAttribute"},"fetchItemByIdentity":{"!type":"fn(args: ?)","!doc":"fetch an item by its identity. This store also provides\na much more finger friendly alias, 'byId' which does the\nsame thing as this function.  If provided a string\nthis call will be treated as a SYNC request and will\nreturn the identified item immediatly.  Alternatively it\ntakes a object as a set of keywordArgs:\n\nidentity: /* string\nthe id of the item you want to retrieve\n\nmode: dojox.data.SYNC_MODE || dojox.data.ASYNC_MODE\noverrides the default store fetch mode\n\nonItem: /* function\nResult call back.  Passed the fetched item.\n\nonError: /* function\nerror callback."},"_makeItAnItem":{"!type":"fn(data: ?, pInfo: ?)"},"newItem":{"!type":"fn(data: ?, options: ?)","!doc":"adds a new item to the store at the specified point.\nTakes two parameters, data, and options."},"_addReference":{"!type":"fn(item: ?, pInfo: ?)"},"deleteItem":{"!type":"fn(item: ?)"},"_setDirty":{"!type":"fn(item: ?)","!doc":"adds an item to the list of dirty items.  This item\ncontains a reference to the item itself as well as a\ncloned and trimmed version of old item for use with\nrevert."},"setValue":{"!type":"fn(item: ?, attribute: ?, value: ?)","!doc":"sets 'attribute' on 'item' to 'value'"},"setValues":{"!type":"fn(item: ?, attribute: ?, values: ?)","!doc":"sets 'attribute' on 'item' to 'value' value\nmust be an array."},"unsetAttribute":{"!type":"fn(item: ?, attribute: ?)","!doc":"unsets 'attribute' on 'item'"},"save":{"!type":"fn(kwArgs: ?)","!doc":"Takes an optional set of keyword Args with\nsome save options.  Currently only format with options\nbeing &quot;raw&quot; or &quot;json&quot;.  This function goes through\nthe dirty item lists, clones and trims the item down so that\nthe items children are not part of the data (the children are replaced\nwith reference objects). This data is compiled into a single array, the dirty objects\nare all marked as clean, and the new data is then passed on to the onSave handler."},"_markClean":{"!type":"fn(item: ?)"},"revert":{"!type":"fn()"},"_mixin":{"!type":"fn(target: ?, data: ?)","!doc":"specialized mixin that hooks up objects in the store where references are identified."},"isDirty":{"!type":"fn(item: ?)"},"_createReference":{"!type":"fn(item: ?)"},"_trimItem":{"!type":"fn(item: ?)","!doc":"copy an item recursively stoppying at other items that have id's\nand replace them with a refrence object;"},"onSet":{"!type":"fn(item: +item, attribute: ?, oldValue: ?, newValue: ?)","!doc":"See dojo.data.api.Notification.onSet()"},"onNew":{"!type":"fn(newItem: +item, parentInfo?: ?)","!doc":"See dojo.data.api.Notification.onNew()"},"onDelete":{"!type":"fn(deletedItem: +item)","!doc":"See dojo.data.api.Notification.onDelete()"},"onSave":{"!type":"fn(items: ?)","!doc":"notification of the save event..not part of the notification api,\nbut probably should be.\nconsole.log(&quot;onSave() &quot;, items);"},"onRevert":{"!type":"fn()","!doc":"notification of the revert event..not part of the notification api,\nbut probably should be."}},"byId":{}},"util":{"JsonQuery":{"!type":"fn()","prototype":{"useFullIdInQueries":{"!type":"bool"},"jsonQueryPagination":{"!type":"bool"},"_toJsonQuery":{"!type":"fn(args: ?, jsonQueryPagination: ?)"},"fetch":{"!type":"fn(args: ?)"},"isUpdateable":{"!type":"fn()"},"matchesQuery":{"!type":"fn(item: ?, request: ?)"},"clientSideFetch":{"!type":"fn(request: ?, baseResults: [])"},"querySuperSet":{"!type":"fn(argsSuper: ?, argsSub: ?)"}}}}},"json":{"ref":{"_useRefs":{"!type":"bool"},"serializeFunctions":{"!type":"bool"},"resolveJson":{"!type":"fn(root: ?, args?: ?)","!doc":"Indexes and resolves references in the JSON object."},"fromJson":{"!type":"fn(str: string, args?: ?)","!doc":"evaluates the passed string-form of a JSON object."},"toJson":{"!type":"fn(it: ?, prettyPrint?: bool, idPrefix?: ?, indexSubObjects?: ?)","!doc":"Create a JSON serialization of an object.\nThis has support for referencing, including circular references, duplicate references, and out-of-message references\nid and path-based referencing is supported as well and is based on http://www.json.com/2007/10/19/json-referencing-proposal-and-library/."},"_addProp":{"!type":"fn(id: ?, prop: ?)"}},"query":{"!type":"fn(query: string, obj?: ?)","!doc":"Performs a JSONQuery on the provided object and returns the results.\nIf no object is provided (just a query), it returns a &quot;compiled&quot; function that evaluates objects\naccording to the provided query."},"schema":{"validate":{"!type":"fn(instance: +Any, schema: ?)","!doc":"To use the validator call this with an instance object and an optional schema object.\nIf a schema is provided, it will be used to validate. If the instance object refers to a schema (self-validating),\nthat schema will be used to validate and the schema parameter is not necessary (if both exist,\nboth validations will occur)."},"checkPropertyChange":{"!type":"fn(value: +Any, schema: ?)","!doc":"The checkPropertyChange method will check to see if an value can legally be in property with the given schema\nThis is slightly different than the validate method in that it will fail if the schema is readonly and it will\nnot check for self-validation, it is assumed that the passed in value is already internally valid.\nThe checkPropertyChange method will return the same object type as validate, see JSONSchema.validate for\ninformation."},"mustBeValid":{"!type":"fn(result: +the)","!doc":"This checks to ensure that the result is valid and will throw an appropriate error message if it is not"},"_validate":{"!type":"fn(instance: +Any, schema: ?, _changing: bool)"}}},"date":{"IslamicDate":{"!type":"fn()","prototype":{"!doc":"The component defines the Islamic (Hijri) Calendar Object","_date":{"!type":"number"},"_month":{"!type":"number"},"_year":{"!type":"number"},"_hours":{"!type":"number"},"_minutes":{"!type":"number"},"_seconds":{"!type":"number"},"_milliseconds":{"!type":"number"},"_day":{"!type":"number"},"_GREGORIAN_EPOCH":{"!type":"number"},"_ISLAMIC_EPOCH":{"!type":"number"},"constructor":{"!type":"fn()","!doc":"This is the constructor"},"getDate":{"!type":"fn()","!doc":"This function returns the date value (1 - 30)"},"getMonth":{"!type":"fn()","!doc":"This function return the month value ( 0 - 11 )"},"getFullYear":{"!type":"fn()","!doc":"This function return the Year value"},"getDay":{"!type":"fn()","!doc":"This function return Week Day value ( 0 - 6 )"},"getHours":{"!type":"fn()","!doc":"returns the Hour value"},"getMinutes":{"!type":"fn()","!doc":"returns the Minuites value"},"getSeconds":{"!type":"fn()","!doc":"returns the seconde value"},"getMilliseconds":{"!type":"fn()","!doc":"returns the Milliseconds value"},"setDate":{"!type":"fn(date: number)","!doc":"This function sets the Date"},"setYear":{"!type":"fn(year: number)","!doc":"This function set Year"},"setMonth":{"!type":"fn(month: number)","!doc":"This function set Month"},"setHours":{"!type":"fn()","!doc":"set the Hours"},"setMinutes":{"!type":"fn(minutes: number)","!doc":"set the Minutes"},"setSeconds":{"!type":"fn(seconds: number)","!doc":"set Seconds"},"setMilliseconds":{"!type":"fn(milliseconds: number)","!doc":"set the Millisconds"},"toString":{"!type":"fn()","!doc":"This returns a string representation of the date in &quot;DDDD MMMM DD YYYY HH:MM:SS&quot; format"},"toGregorian":{"!type":"fn()","!doc":"This returns the equevalent Grogorian date value in Date object"},"fromGregorian":{"!type":"fn(gdate: +Date)","!doc":"This function returns the equivalent Islamic Date value for the Gregorian Date"},"parse":{"!type":"fn(dateObject: string)","!doc":"This function parse the date string"},"valueOf":{"!type":"fn()","!doc":"This function returns The stored time value in milliseconds\nsince midnight, January 1, 1970 UTC"},"_yearStart":{"!type":"fn(year: number)","!doc":"return start of Islamic year"},"_monthStart":{"!type":"fn(year: number, month: number)","!doc":"return the start of Islamic Month"},"_civilLeapYear":{"!type":"fn(year: number)","!doc":"return Boolean value if Islamic leap year"},"getDaysInIslamicMonth":{"!type":"fn(month: number, year: number) -> +dojox.date.IslamicDate","!doc":"returns the number of days in the given Islamic Month"},"_mod":{"!type":"fn(a: ?, b: ?)"}},"weekDays":{},"months":{},"_getNames":{"!type":"fn(item: string, type: string, use?: string, locale?: string)","!doc":"Used to get localized strings from dojo.cldr for day or month names."}},"hebrew":{"getDaysInMonth":{"!type":"fn(month: +hebrew.Date)"},"compare":{"!type":"fn(dateheb1: +hebrew.Date, dateheb2: +hebrew.Date, portion?: string)","!doc":"Compare two hebrew date objects by date, time, or both."},"add":{"!type":"fn(date: +dojox.date.hebrew.Date, interval: string, amount: number) -> +dojox.date.hebrew.Date","!doc":"Add to a Date in intervals of different size, from milliseconds to years"},"difference":{"!type":"fn(date1: +dojox.date.hebrew.Date, date2?: +dojox.date.hebrew.Date, interval?: string)","!doc":"date1 - date2\ndate2 is hebrew.Date object.  If not specified, the current hebrew.Date is used."},"Date":{"!type":"fn()","prototype":{"!doc":"The component defines the Hebrew Calendar Object","_MONTH_LENGTH":{"!type":"[]"},"_MONTH_START":{"!type":"[]"},"_LEAP_MONTH_START":{"!type":"[]"},"_GREGORIAN_MONTH_COUNT":{"!type":"[]"},"_date":{"!type":"number"},"_month":{"!type":"number"},"_year":{"!type":"number"},"_hours":{"!type":"number"},"_minutes":{"!type":"number"},"_seconds":{"!type":"number"},"_milliseconds":{"!type":"number"},"_day":{"!type":"number"},"constructor":{"!type":"fn()","!doc":"This is the constructor"},"getDate":{"!type":"fn(isNumber?: bool)","!doc":"This function returns the date value (1 - 30)"},"getMonth":{"!type":"fn()","!doc":"This function return the month value ( 0 - 11 )"},"getFullYear":{"!type":"fn()","!doc":"This function return the Year value"},"getHours":{"!type":"fn()","!doc":"returns the Hour value"},"getMinutes":{"!type":"fn()","!doc":"returns the Minuites value"},"getSeconds":{"!type":"fn()","!doc":"returns the seconde value"},"getMilliseconds":{"!type":"fn()","!doc":"returns the Milliseconds value"},"setDate":{"!type":"fn(date: number)","!doc":"This function sets the Date"},"setFullYear":{"!type":"fn(year: number, month?: number, date?: number)","!doc":"This function set Year"},"setMonth":{"!type":"fn(month: number)","!doc":"This function set Month"},"setHours":{"!type":"fn()","!doc":"set the Hours  0-23"},"setMinutes":{"!type":"fn(minutes: number)","!doc":"set the Minutes  frm 0-59"},"setSeconds":{"!type":"fn(seconds: number)","!doc":"set the Seconds  from 0-59"},"setMilliseconds":{"!type":"fn(milliseconds: number)","!doc":"set the milliseconds"},"toString":{"!type":"fn() -> string","!doc":"This returns a string representation of the date in &quot;dd, MM, YYYY HH:MM:SS&quot; format"},"getDaysInHebrewMonth":{"!type":"fn(month: number, year: number)","!doc":"returns the number of days in the month used"},"_yearType":{"!type":"fn(year: number)"},"_handleGetYearLength":{"!type":"fn(eyear: number)"},"_startOfYear":{"!type":"fn(year: number)"},"isLeapYear":{"!type":"fn(year: number)","!doc":"Determines if the year (argument) is a leap year"},"fromGregorian":{"!type":"fn(gdate: +Date)","!doc":"This function sets this Date to the Hebrew Date corresponding to the Gregorian Date"},"_computeHebrewFields":{"!type":"fn(gdate: +Date)"},"toGregorian":{"!type":"fn() -> +Date","!doc":"This returns the equevalent Grogorian date value in Date object"},"_floorDivide":{"!type":"fn(numerator: ?, denominator: ?, remainder: ?)"},"getDay":{"!type":"fn()","!doc":"This function return Week Day value ( 0 - 6 )"},"_getJulianDayFromGregorianDate":{"!type":"fn(gdate: ?)","!doc":"returns the Julian day of a Gregorian date"}},"valueOf":{"!type":"fn()"}},"locale":{"format":{"!type":"fn(dateObject: +hebrew.Date, options?: ?) -> string","!doc":"Format a Date object as a String, using  settings."},"regexp":{"!type":"fn(options?: ?) -> string","!doc":"Builds the regular needed to parse a hebrew.Date"},"_parseInfo":{"!type":"fn(options?: +oblect)"},"parse":{"!type":"fn(value: string, options?: ?) -> +hebrew.Date","!doc":"This function parse string date value according to options"},"addCustomFormats":{"!type":"fn(packageName: string, bundleName: string)","!doc":"Add a reference to a bundle containing localized custom formats to be\nused by date/time formatting and parsing routines."},"_getHebrewBundle":{"!type":"fn(locale: string)"},"getNames":{"!type":"fn(item: string, type: string, context?: string, locale?: string, date: +hebrew)","!doc":"Used to get localized strings from dojo.cldr for day or month names."}},"numerals":{"getYearHebrewLetters":{"!type":"fn(year: number)","!doc":"This function return year written in Hebrew numbers-letters,"},"parseYearHebrewLetters":{"!type":"fn(year: string)","!doc":"This function return year in format number from  the year written in Hebrew numbers-letters"},"getDayHebrewLetters":{"!type":"fn(day: ?, nogrsh?: bool)","!doc":"This function return date written in Hebrew numbers-letter,  can be in format &times;"},"parseDayHebrewLetters":{"!type":"fn(day: string)","!doc":"This function return date in format number from  the date written in Hebrew numbers-letter"},"getMonthHebrewLetters":{"!type":"fn(monthNum: ?, isNum: bool, year: number)","!doc":"This function return month written in Hebrew numerals"},"parseMonthHebrewLetters":{"!type":"fn(monthStr: ?)","!doc":"This function return month in format number from  the month written in Hebrew  word  or numbers-letters\nthe return number is index in month name array, to use it for setMont, do correction for leap year"}}},"php":{"DateFormat":{"!type":"fn(format: string)","!doc":"Format the internal date object","prototype":{"weekdays":{"!type":"[]"},"weekdays_3":{"!type":"[]"},"months":{"!type":"[]"},"months_3":{"!type":"[]"},"monthdays":{"!type":"[]"},"format":{"!type":"fn(date: +Date)"},"d":{"!type":"fn()","!doc":"Day of the month, 2 digits with leading zeros"},"D":{"!type":"fn()","!doc":"A textual representation of a day, three letters"},"j":{"!type":"fn()","!doc":"Day of the month without leading zeros"},"l":{"!type":"fn()","!doc":"A full textual representation of the day of the week"},"N":{"!type":"fn()","!doc":"ISO-8601 numeric representation of the day of the week (added in PHP 5.1.0)"},"S":{"!type":"fn()","!doc":"English ordinal suffix for the day of the month, 2 characters"},"w":{"!type":"fn()","!doc":"Numeric representation of the day of the week"},"z":{"!type":"fn()","!doc":"The day of the year (starting from 0)"},"W":{"!type":"fn()","!doc":"ISO-8601 week number of year, weeks starting on Monday (added in PHP 4.1.0)"},"F":{"!type":"fn()","!doc":"A full textual representation of a month, such as January or March"},"m":{"!type":"fn()","!doc":"Numeric representation of a month, with leading zeros"},"M":{"!type":"fn()","!doc":"A short textual representation of a month, three letters"},"n":{"!type":"fn()","!doc":"Numeric representation of a month, without leading zeros"},"t":{"!type":"fn()","!doc":"Number of days in the given month"},"L":{"!type":"fn()","!doc":"Whether it's a leap year"},"o":{"!type":"fn()","!doc":"ISO-8601 year number. This has the same value as Y, except that if\nthe ISO week number (W) belongs to the previous or next year, that year is used instead. (added in PHP 5.1.0)\nTODO: Figure out what this means"},"Y":{"!type":"fn()","!doc":"A full numeric representation of a year, 4 digits"},"y":{"!type":"fn()","!doc":"A two digit representation of a year"},"a":{"!type":"fn()","!doc":"Lowercase Ante meridiem and Post meridiem"},"b":{"!type":"fn()","!doc":"Uppercase Ante meridiem and Post meridiem"},"B":{"!type":"fn()","!doc":"Swatch Internet time\nA day is 1,000 beats. All time is measured from GMT + 1"},"g":{"!type":"fn()","!doc":"12-hour format of an hour without leading zeros"},"G":{"!type":"fn()","!doc":"24-hour format of an hour without leading zeros"},"h":{"!type":"fn()","!doc":"12-hour format of an hour with leading zeros"},"H":{"!type":"fn()","!doc":"24-hour format of an hour with leading zeros"},"i":{"!type":"fn()","!doc":"Minutes with leading zeros"},"s":{"!type":"fn()","!doc":"Seconds, with leading zeros"},"e":{"!type":"fn()","!doc":"Timezone identifier (added in PHP 5.1.0)"},"I":{"!type":"fn()","!doc":"Whether or not the date is in daylight saving time\nTODO: Can dojo.date do this?"},"O":{"!type":"fn()","!doc":"Difference to Greenwich time (GMT) in hours"},"P":{"!type":"fn()","!doc":"Difference to Greenwich time (GMT) with colon between hours and minutes (added in PHP 5.1.3)"},"T":{"!type":"fn()","!doc":"Timezone abbreviation"},"Z":{"!type":"fn()","!doc":"Timezone offset in seconds. The offset for timezones west of UTC is always negative,\nand for those east of UTC is always positive."},"c":{"!type":"fn()","!doc":"ISO 8601 date (added in PHP 5)"},"r":{"!type":"fn()","!doc":"RFC 2822 formatted date"},"U":{"!type":"fn()","!doc":"Seconds since the Unix Epoch (January 1 1970 00:00:00 GMT)"}}},"format":{"!type":"fn(date: +Date, format: string)","!doc":"Get a formatted string for a given date object"}},"posix":{"strftime":{"!type":"fn(dateObject: +Date, format: string, locale?: string) -> string","!doc":"Formats the date object using the specifications of the POSIX strftime function"},"getStartOfWeek":{"!type":"fn(dateObject: +Date, firstDay: number) -> +Date","!doc":"Return a date object representing the first day of the given\ndate's week."},"setIsoWeekOfYear":{"!type":"fn(dateObject: +Date, week: number) -> +Date","!doc":"Set the ISO8601 week number of the given date.\nThe week containing January 4th is the first week of the year."},"getIsoWeekOfYear":{"!type":"fn(dateObject: +Date) -> +Integer","!doc":"Get the ISO8601 week number of the given date.\nThe week containing January 4th is the first week of the year.\nSee http://en.wikipedia.org/wiki/ISO_week_date"},"getIsoWeeksInYear":{"!type":"fn(dateObject: +Date) -> +Integer","!doc":"Determine the number of ISO8601 weeks in the year of the given\ndate. Most years have 52 but some have 53.\nSee http://www.phys.uu.nl/~vgent/calendar/isocalendar_text3.htm"}}},"dtl":{"TOKEN_BLOCK":{"!type":"number"},"TOKEN_VAR":{"!type":"number"},"TOKEN_COMMENT":{"!type":"number"},"TOKEN_TEXT":{"!type":"number"},"_Context":{},"Template":{},"_QuickNodeList":{},"_Filter":{},"_TextNode":{},"_Node":{},"_NodeList":{},"_VarNode":{},"_Parser":{},"mark_safe":{},"TOKEN_CHANGE":{"!type":"number"},"TOKEN_ATTR":{"!type":"number"},"TOKEN_CUSTOM":{"!type":"number"},"TOKEN_NODE":{"!type":"number"},"DomTemplate":{},"DomBuffer":{},"_DomNode":{},"_DomNodeList":{},"_DomVarNode":{},"ChangeNode":{},"AttributeNode":{},"_DomTextNode":{},"_DomParser":{},"HtmlTemplate":{},"html":{},"quickFilter":{"!type":"fn(str: ?)"},"_noOpNode":{"!type":"fn()","!doc":"Adds a no-op node. Useful in custom tags"},"Context":{"!type":"fn(dict: ?)","prototype":{"getKeys":{"!type":"fn()"},"extend":{"!type":"fn(obj: +dojox.dtl.Context)","!doc":"Returns a clone of this context object, with the items from the\npassed objecct mixed in."},"filter":{"!type":"fn(filter: +dojox.dtl.Context)","!doc":"Returns a clone of this context, only containing the items\ndefined in the filter."},"setThis":{"!type":"fn(_this: ?)"},"getThis":{"!type":"fn()"},"hasKey":{"!type":"fn(key: ?)"}}},"DomInline":{"!type":"fn(args: ?, node: ?)","prototype":{"context":{},"declaredClass":{"!type":"string"},"render":{"!type":"fn(context?: +dojox.dtl.Context)"},"buildRendering":{"!type":"fn()"},"postMixInProperties":{"!type":"fn()"}}},"HtmlInline":{"declaredClass":{"!type":"string"}},"Inline":{"!type":"fn(args: ?, node: ?)","prototype":{"context":{},"declaredClass":{"!type":"string"},"render":{"!type":"fn(context?: +Object)"},"buildRendering":{"!type":"fn()"},"postMixInProperties":{"!type":"fn()"}}},"_DomTemplated":{"prototype":{"_dijitTemplateCompat":{"!type":"bool"},"buildRendering":{"!type":"fn()","!doc":"Construct the UI for this widget, setting this.domNode."},"setTemplate":{"!type":"fn(template: string, context?: +dojox.dtl.Context)","!doc":"Quickly switch between templated by location"},"render":{"!type":"fn(context?: +dojox.dtl.Context, tpl?: +dojox.dtl.DomTemplate)"},"_getContext":{"!type":"fn(context: ?)"},"_getCachedTemplate":{"!type":"fn(templatePath: ?, templateString: ?)"}}},"contrib":{"html":{},"dijit":{"widgetsInTemplate":{"!type":"bool"},"AttachNode":{},"EventNode":{},"DojoTypeNode":{},"dojoAttachPoint":{"!type":"fn(parser: ?, token: ?)"},"dojoAttachEvent":{"!type":"fn(parser: ?, token: ?)"},"dojoType":{"!type":"fn(parser: ?, token: ?)"},"on":{"!type":"fn(parser: ?, token: ?)","!doc":"Associates an event type to a function (on the current widget) by name"}},"data":{"_BoundItem":{"get":{"safe":{"!type":"bool"}}},"BindDataNode":{},"_get":{"!type":"fn(key: ?)"},"bind_data":{"!type":"fn(parser: ?, token: ?)","!doc":"Turns a list of data store items into DTL compatible items"},"bind_query":{"!type":"fn(parser: ?, token: ?)","!doc":"Queries a data store and makes the returned items DTL compatible"}},"dom":{"StyleNode":{},"BufferNode":{},"buffer":{"!type":"fn(parser: ?, token: ?)","!doc":"Buffer large DOM manipulations during re-render."},"html":{"!type":"fn(parser: ?, token: ?)"},"style_":{"!type":"fn(parser: ?, token: ?)"}},"objects":{"key":{"!type":"fn(value: ?, arg: ?)"}}},"_HtmlTemplated":{"declaredClass":{"!type":"string"}},"_Templated":{"!type":"fn()","prototype":{"!proto":"dijit._Templated.prototype","_dijitTemplateCompat":{"!type":"bool"},"_templateCache":{},"buildRendering":{"!type":"fn()"},"getCachedTemplate":{"!type":"fn(templatePath: ?, templateString: ?, alwaysUseString: ?)","!doc":"Layer for dijit._Templated.getCachedTemplate"},"render":{"!type":"fn()"}}},"Token":{"!type":"fn(token_type: ?, contents: ?)","split_contents":{"!type":"fn(limit?: +Integer)"}},"text":{"_re":{"!type":"+RegExp"},"_get":{"!type":"fn(module: ?, name: ?, errorless: ?)","!doc":"Used to find both tags and filters"},"getTag":{"!type":"fn(name: ?, errorless: ?)"},"getFilter":{"!type":"fn(name: ?, errorless: ?)"},"getTemplate":{"!type":"fn(file: ?)"},"getTemplateString":{"!type":"fn(file: ?)"},"_resolveLazy":{"!type":"fn(location: ?, sync: ?, json: ?)"},"_resolveTemplateArg":{"!type":"fn(arg: ?, sync: ?)"},"_isTemplate":{"!type":"fn(arg: ?)"},"_resolveContextArg":{"!type":"fn(arg: ?, sync: ?)"},"tokenize":{"!type":"fn(str: ?)"},"_parseDelims":{"!type":"fn(varr: ?, load: ?, tag: ?)"}},"register":{"get":{"!type":"fn(module: string, name: string)"},"getAttributeTags":{"!type":"fn()"},"_any":{"!type":"fn(type: ?, base: ?, locations: ?)"},"tags":{"!type":"fn(base: string, locations: ?)"},"filters":{"!type":"fn(base: string, locations: ?)"},"_registry":{"attributes":{"!type":"[]"},"tags":{"!type":"[]"},"filters":{"!type":"[]"}}},"_base":{"escape":{"!type":"fn(value: ?)","!doc":"Escapes a string's HTML"},"safe":{"!type":"fn(value: ?)"}},"BOOLS":{"checked":{"!type":"number"},"disabled":{"!type":"number"},"readonly":{"!type":"number"}},"dom":{"_attributes":{},"_uppers":{},"_re4":{"!type":"+RegExp"},"_reTrim":{"!type":"+RegExp"},"_reSplit":{"!type":"+RegExp"},"_swallowed":{"!type":"[]"},"getTemplate":{"!type":"fn(text: ?)"},"tokenize":{"!type":"fn(nodes: +Node)"},"_tokenize":{"!type":"fn(node: +Node, tokens: [])"},"__tokenize":{"!type":"fn(child: ?, tokens: ?)"}},"ext-dojo":{"NodeList":{}},"filter":{"dates":{"_toDate":{"!type":"fn(value: ?)"},"date":{"!type":"fn(value: ?, arg: ?)","!doc":"Formats a date according to the given format"},"time":{"!type":"fn(value: ?, arg: ?)","!doc":"Formats a time according to the given format"},"timesince":{"!type":"fn(value: ?, arg: ?)","!doc":"Formats a date as the time since that date (i.e. &quot;4 days, 6 hours&quot;)"},"timeuntil":{"!type":"fn(value: ?, arg: ?)","!doc":"Formats a date as the time until that date (i.e. &quot;4 days, 6 hours&quot;)"}},"htmlstrings":{"_linebreaksrn":{"!type":"+RegExp"},"_linebreaksn":{"!type":"+RegExp"},"_linebreakss":{"!type":"+RegExp"},"_linebreaksbr":{"!type":"+RegExp"},"_removetagsfind":{"!type":"+RegExp"},"_striptags":{"!type":"+RegExp"},"linebreaks":{"!type":"fn(value: ?)","!doc":"Converts newlines into &lt;p&gt; and &lt;br /&gt;s"},"linebreaksbr":{"!type":"fn(value: ?)","!doc":"Converts newlines into &lt;br /&gt;s"},"removetags":{"!type":"fn(value: ?, arg: ?)","!doc":"Removes a space separated list of [X]HTML tags from the output&quot;"},"striptags":{"!type":"fn(value: ?)","!doc":"Strips all [X]HTML tags"}},"integers":{"add":{"!type":"fn(value: ?, arg: ?)"},"get_digit":{"!type":"fn(value: ?, arg: ?)","!doc":"Given a whole number, returns the 1-based requested digit of it\ndesciprtion:\n1 is the right-most digit, 2 is the second-right-most digit, etc. Returns the\noriginal value for invalid input (if input or argument is not an integer,\nor if argument is less than 1). Otherwise, output is always an integer."}},"lists":{"_dictsort":{"!type":"fn(a: ?, b: ?)"},"dictsort":{"!type":"fn(value: ?, arg: ?)","!doc":"Takes a list of dicts, returns that list sorted by the property given in the argument."},"dictsortreversed":{"!type":"fn(value: ?, arg: ?)","!doc":"Takes a list of dicts, returns that list sorted in reverse order by the property given in the argument."},"first":{"!type":"fn(value: ?)","!doc":"Returns the first item in a list"},"join":{"!type":"fn(value: ?, arg: ?)","!doc":"Joins a list with a string, like Python's `<code>str.join(list)</code>`"},"length":{"!type":"fn(value: ?)","!doc":"Returns the length of the value - useful for lists"},"length_is":{"!type":"fn(value: ?, arg: ?)","!doc":"Returns a boolean of whether the value's length is the argument"},"random":{"!type":"fn(value: ?)","!doc":"Returns a random item from the list"},"slice":{"!type":"fn(value: ?, arg: ?)","!doc":"Returns a slice of the list."},"_unordered_list":{"!type":"fn(value: ?, tabs: ?)"},"unordered_list":{"!type":"fn(value: ?)","!doc":"Recursively takes a self-nested list and returns an HTML unordered list --\nWITHOUT opening and closing &lt;ul&gt; tags."}},"logic":{"_yesno":{"!type":"+RegExp"},"default_":{"!type":"fn(value: ?, arg: ?)","!doc":"If value is unavailable, use given default"},"default_if_none":{"!type":"fn(value: ?, arg: ?)","!doc":"If value is null, use given default"},"divisibleby":{"!type":"fn(value: ?, arg: ?)","!doc":"Returns true if the value is devisible by the argument&quot;"},"yesno":{"!type":"fn(value: ?, arg: ?)","!doc":"arg being a comma-delimited string, value of true/false/none\nchooses the appropriate item from the string"}},"misc":{"filesizeformat":{"!type":"fn(value: ?)","!doc":"Format the value like a 'human-readable' file size (i.e. 13 KB, 4.1 MB, 102bytes, etc)."},"pluralize":{"!type":"fn(value: ?, arg: ?)","!doc":"Returns a plural suffix if the value is not 1, for '1 vote' vs. '2 votes'"},"phone2numeric":{"!type":"fn(value: ?)","!doc":"Takes a phone number and converts it in to its numerical equivalent"},"pprint":{"!type":"fn(value: ?)","!doc":"A wrapper around toJson unless something better comes along"},"_phone2numeric":{"a":{"!type":"number"},"b":{"!type":"number"},"c":{"!type":"number"},"d":{"!type":"number"},"e":{"!type":"number"},"f":{"!type":"number"},"g":{"!type":"number"},"h":{"!type":"number"},"i":{"!type":"number"},"j":{"!type":"number"},"k":{"!type":"number"},"l":{"!type":"number"},"m":{"!type":"number"},"n":{"!type":"number"},"o":{"!type":"number"},"p":{"!type":"number"},"r":{"!type":"number"},"s":{"!type":"number"},"t":{"!type":"number"},"u":{"!type":"number"},"v":{"!type":"number"},"w":{"!type":"number"},"x":{"!type":"number"},"y":{"!type":"number"}}},"strings":{"_fix_ampersands":{"!type":"+RegExp"},"_strings":{},"_truncatewords":{"!type":"+RegExp"},"_truncate_words":{"!type":"+RegExp"},"_truncate_tag":{"!type":"+RegExp"},"_urlize":{"!type":"+RegExp"},"_urlize2":{"!type":"+RegExp"},"_urlquote":{"!type":"fn(url: string, safe?: string)"},"addslashes":{"!type":"fn(value: ?)","!doc":"Adds slashes - useful for passing strings to JavaScript, for example."},"capfirst":{"!type":"fn(value: ?)","!doc":"Capitalizes the first character of the value"},"center":{"!type":"fn(value: ?, arg: ?)","!doc":"Centers the value in a field of a given width"},"cut":{"!type":"fn(value: ?, arg: ?)","!doc":"Removes all values of arg from the given string"},"fix_ampersands":{"!type":"fn(value: ?)","!doc":"Replaces ampersands with `<code>&amp;amp;</code>` entities"},"floatformat":{"!type":"fn(value: ?, arg: ?)","!doc":"Format a number according to arg"},"iriencode":{"!type":"fn(value: ?)"},"linenumbers":{"!type":"fn(value: ?)","!doc":"Displays text with line numbers"},"ljust":{"!type":"fn(value: ?, arg: ?)"},"lower":{"!type":"fn(value: ?)","!doc":"Converts a string into all lowercase"},"make_list":{"!type":"fn(value: ?)","!doc":"Returns the value turned into a list. For an integer, it's a list of\ndigits. For a string, it's a list of characters."},"rjust":{"!type":"fn(value: ?, arg: ?)"},"slugify":{"!type":"fn(value: ?)","!doc":"Converts to lowercase, removes\nnon-alpha chars and converts spaces to hyphens"},"stringformat":{"!type":"fn(value: ?, arg: ?)","!doc":"Formats the variable according to the argument, a string formatting specifier.\nThis specifier uses Python string formating syntax, with the exception that\nthe leading &quot;%&quot; is dropped."},"title":{"!type":"fn(value: ?)","!doc":"Converts a string into titlecase"},"truncatewords":{"!type":"fn(value: ?, arg: +Integer)","!doc":"Truncates a string after a certain number of words"},"truncatewords_html":{"!type":"fn(value: ?, arg: ?)"},"upper":{"!type":"fn(value: ?)"},"urlencode":{"!type":"fn(value: ?)"},"urlize":{"!type":"fn(value: ?)"},"urlizetrunc":{"!type":"fn(value: ?, arg: ?)"},"wordcount":{"!type":"fn(value: ?)"},"wordwrap":{"!type":"fn(value: ?, arg: ?)"},"_truncate_singlets":{"br":{"!type":"bool"},"col":{"!type":"bool"},"link":{"!type":"bool"},"base":{"!type":"bool"},"img":{"!type":"bool"},"param":{"!type":"bool"},"area":{"!type":"bool"},"hr":{"!type":"bool"},"input":{"!type":"bool"}}}},"utils":{"date":{"_chunks":{"!type":"[]"},"_months_ap":{"!type":"[]"},"timesince":{"!type":"fn(d: ?, now: ?)","!doc":"Takes two datetime objects and returns the time between then and now\nas a nicely formatted string, e.g &quot;10 minutes&quot;"},"format":{"!type":"fn(date: +Date, format: string)"},"DateFormat":{"!type":"fn(format: string)","prototype":{"f":{"!type":"fn()","!doc":"Time, in 12-hour hours and minutes, with minutes left off if they're zero."},"N":{"!type":"fn()","!doc":"Month abbreviation in Associated Press style. Proprietary extension."},"P":{"!type":"fn()","!doc":"Time, in 12-hour hours, minutes and 'a.m.'/'p.m.', with minutes left off\nif they're zero and the strings 'midnight' and 'noon' if appropriate."}}}}},"render":{"dom":{"Render":{"!type":"fn(attachPoint?: +Node, tpl?: +dojox.dtl.DomTemplate)","prototype":{"setAttachPoint":{"!type":"fn(node: +Node)"},"render":{"!type":"fn(context: ?, tpl?: +dojox.dtl.DomTemplate, buffer?: +dojox.dtl.DomBuffer)"}}}},"html":{"Render":{}}},"tag":{"date":{"NowNode":{"!type":"fn(format: ?, node: ?)","prototype":{"render":{"!type":"fn(context: ?, buffer: ?)"},"unrender":{"!type":"fn(context: ?, buffer: ?)"},"clone":{"!type":"fn(buffer: ?)"}}},"now":{"!type":"fn(parser: ?, token: ?)"}},"loader":{"BlockNode":{},"ExtendsNode":{},"IncludeNode":{},"block":{"!type":"fn(parser: ?, token: ?)"},"extends_":{"!type":"fn(parser: ?, token: ?)"},"include":{"!type":"fn(parser: ?, token: ?)"},"ssi":{"!type":"fn(parser: ?, token: ?)"}},"logic":{"IfNode":{},"IfEqualNode":{},"ForNode":{},"if_":{"!type":"fn(parser: ?, token: ?)"},"_ifequal":{"!type":"fn(parser: ?, token: ?, negate: ?)"},"ifequal":{"!type":"fn(parser: ?, token: ?)"},"ifnotequal":{"!type":"fn(parser: ?, token: ?)"},"for_":{"!type":"fn(parser: ?, token: ?)"}},"loop":{"CycleNode":{},"IfChangedNode":{},"RegroupNode":{},"cycle":{"!type":"fn(parser: ?, token: ?)","!doc":"Cycle among the given strings each time this tag is encountered"},"ifchanged":{"!type":"fn(parser: ?, token: ?)"},"regroup":{"!type":"fn(parser: ?, token: ?)"}},"misc":{"DebugNode":{},"FilterNode":{},"FirstOfNode":{},"SpacelessNode":{},"WidthRatioNode":{},"WithNode":{},"comment":{"!type":"fn(parser: ?, token: ?)","!doc":"Ignore everything between {% comment %} and {% endcomment %}"},"debug":{"!type":"fn(parser: ?, token: ?)","!doc":"Output the current context, maybe add more stuff later."},"filter":{"!type":"fn(parser: ?, token: ?)","!doc":"Filter the contents of the blog through variable filters."},"firstof":{"!type":"fn(parser: ?, token: ?)"},"spaceless":{"!type":"fn(parser: ?, token: ?)"},"templatetag":{"!type":"fn(parser: ?, token: ?)"},"widthratio":{"!type":"fn(parser: ?, token: ?)"},"with_":{"!type":"fn(parser: ?, token: ?)"},"TemplateTagNode":{"mapping":{}}}}},"editor":{"plugins":{"GlobalTableHandler":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"A global object that handles common tasks for all the plugins. Since\nthere are several plugins that are all calling common methods, it's preferable\nthat they call a centralized location that either has a set variable or a\ntimeout to only repeat code-heavy calls when necessary.\n\n\n\nFIXME:","tablesConnected":{"!type":"bool"},"currentlyAvailable":{"!type":"bool"},"alwaysAvailable":{"!type":"bool"},"availableCurrentlySet":{"!type":"bool"},"initialized":{"!type":"bool"},"tableData":{},"shiftKeyDown":{"!type":"bool"},"editorDomNode":{},"doMixins":{"!type":"fn()"},"initialize":{"!type":"fn(editor: ?)","!doc":"Initialize the global handler upon a plugin's first instance of setEditor"},"getTableInfo":{"!type":"fn(forceNewData: ?)"},"connectDraggable":{"!type":"fn()"},"onDragStart":{"!type":"fn()"},"onDragEnd":{"!type":"fn()"},"checkAvailable":{"!type":"fn()"},"_prepareTable":{"!type":"fn(tbl: ?)"},"getTimeStamp":{"!type":"fn()"},"_tempStoreTableData":{"!type":"fn(type: ?)"},"_tempAvailability":{"!type":"fn(type: ?)"},"connectTableKeys":{"!type":"fn()"},"disconnectTableKeys":{"!type":"fn()"},"onKeyDown":{"!type":"fn(evt: ?)"},"onKeyUp":{"!type":"fn(evt: ?)"},"onDisplayChanged":{"!type":"fn()"}},"undoEnabled":{}},"TablePlugins":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"A collection of Plugins for inserting and modifying tables in the Editor\nSee end of this document for all avaiable plugs\nand dojox/editorPlugins/tests/editorTablePlugs.html for an example\n\nNOT IMPLEMENTED: Not handling cell merge, span or split","iconClassPrefix":{"!type":"string"},"useDefaultCommand":{"!type":"bool"},"commandName":{"!type":"string"},"label":{"!type":"string"},"alwaysAvailable":{"!type":"bool"},"undoEnabled":{"!type":"bool"},"constructor":{"!type":"fn()"},"onDisplayChanged":{"!type":"fn(withinTable: ?)"},"setEditor":{"!type":"fn()"},"onEditorLoaded":{"!type":"fn()"},"_createContextMenu":{"!type":"fn()"},"selectTable":{"!type":"fn()"},"launchInsertDialog":{"!type":"fn()"},"launchModifyDialog":{"!type":"fn()"},"_initButton":{"!type":"fn()"},"modTable":{"!type":"fn(cmd: ?, args: ?)"},"begEdit":{"!type":"fn()"},"endEdit":{"!type":"fn()"},"makeColumnsEven":{"!type":"fn()"},"getTableInfo":{"!type":"fn(forceNewData: ?)"},"_makeTitle":{"!type":"fn(str: ?)"},"getSelectedCells":{"!type":"fn()"}},"buttonClass":{}},"EditorTableDialog":{"!type":"fn()","prototype":{"!proto":"dijit.Dialog.prototype","baseClass":{"!type":"string"},"widgetsInTemplate":{"!type":"bool"},"templatePath":{},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"onInsert":{"!type":"fn()"},"onBuildTable":{"!type":"fn(tableText: ?)"}}},"EditorModifyTableDialog":{"!type":"fn()","prototype":{"!proto":"dijit.Dialog.prototype","baseClass":{"!type":"string"},"widgetsInTemplate":{"!type":"bool"},"table":{},"tableAtts":{},"templatePath":{},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"setBrdColor":{"!type":"fn(color: ?)"},"setBkColor":{"!type":"fn(color: ?)"},"onSet":{"!type":"fn()"},"onSetTable":{"!type":"fn(tableText: ?)"}}},"UploadImage":{"!type":"fn()","prototype":{"!proto":"dijit._editor._Plugin.prototype","!doc":"Adds an icon to the Editor toolbar that when clicked, opens a system dialog\nAlthough the toolbar icon is a tiny \"image\" the uploader could be used for\nany file type","tempImageUrl":{"!type":"string"},"iconClassPrefix":{"!type":"string"},"useDefaultCommand":{"!type":"bool"},"uploadUrl":{"!type":"string"},"fileInput":{},"label":{"!type":"string"},"_initButton":{"!type":"fn()"},"createFileInput":{"!type":"fn()"},"onComplete":{"!type":"fn(data: ?, ioArgs: ?, widgetRef: ?)"},"insertTempImage":{"!type":"fn()"}}}}},"embed":{"Flash":{"!type":"fn(kwArgs: +dojox.embed.__flashArgs, node: +Node)","!doc":"Creates a wrapper object around a Flash movie.  Wrapper object will\ninsert the movie reference in node; when the browser first starts\ngrabbing the movie, onReady will be fired; when the movie has finished\nloading, it will fire onLoad.\n\nIf your movie uses ExternalInterface, you should use the onLoad event\nto do any kind of proxy setup (see dojox.embed.Flash.proxy); this seems\nto be the only consistent time calling EI methods are stable (since the\nFlash movie will shoot several methods into the window object before\nEI callbacks can be used properly).\n\narguments:","minSupported":{"!type":"number"},"available":{},"supported":{"!type":"bool"},"minimumRequired":{},"version":{},"initialized":{"!type":"bool"},"onInitialize":{"!type":"fn()"},"__ie_markup__":{"!type":"fn(kwArgs: ?)"},"proxy":{"!type":"fn(obj: +dojox.embed.Flash, methods: [])","!doc":"Create the set of passed methods on the dojox.embed.Flash object\nso that you can call that object directly, as opposed to having to\ndelve into the internal movie to do this.  Intended to make working\nwith Flash movies that use ExternalInterface much easier to use."},"prototype":{"onReady":{"!type":"fn(movie: +HTMLObject)","!doc":"Stub function for you to attach to when the movie reference is first\npushed into the document."},"onLoad":{"!type":"fn(movie: +HTMLObject)","!doc":"Stub function for you to attach to when the movie has finished downloading\nand is ready to be manipulated."},"onError":{"!type":"fn(msg: ?)"},"_onload":{"!type":"fn()","!doc":"Internal. Cleans up before calling onLoad."},"init":{"!type":"fn(kwArgs: +dojox.embed.__flashArgs, node?: +Node)"},"_destroy":{"!type":"fn()"},"destroy":{"!type":"fn()"},"byId":{"!type":"fn(movieName: string, doc: ?)","!doc":"Gets Flash movie by id."}},"place":{"!type":"fn(kwArgs: ?, node: ?)"}},"__flashArgs":{"!type":"fn(path: string, id?: string, width?: number, height?: number, style?: string, params?: ?, vars?: ?, expressInstall?: bool, redirect?: string)"},"__QTArgs":{"!type":"fn(path: string, id?: string, width?: number, height?: number, params?: ?, redirect?: string)"},"Object":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget you can use to embed either a Flash or Quicktime\nmovie.","width":{"!doc":"The width of the movie. If not provided, the width of this.domNode is used.","!type":"number"},"height":{"!doc":"The height of the movie. If not provided, the height of this.domNode is used.","!type":"number"},"src":{"!doc":"The URL of the movie to embed.","!type":"string"},"movie":{"!doc":"The eventual reference to the movie embedded.  If you are looking to script\ncontrol over the movie, you'd access it this way.","!type":"+HTMLEmbed"},"params":{"!doc":"A property bag that is created postCreate.  Any additional attributes you\ndefine on your domNode will be collected and placed into this, which will\nthen be passed to the movie constructor."},"reFlash":{"!doc":"Expression used on the src property to determine if this is Flash or Quicktime.","!type":"+RegExp"},"reQtMovie":{"!doc":"Expression used on the src property to determine if this is Flash or Quicktime.","!type":"+RegExp"},"reQtAudio":{"!doc":"Expression used on the src property to determine if this is Flash or Quicktime.","!type":"+RegExp"},"postCreate":{"!type":"fn()"}}},"Quicktime":{"!type":"fn(kwArgs: +dojox.embed.__QTArgs, node: +Node) -> +HTMLObject","!doc":"Returns a reference to the HTMLObject/HTMLEmbed that is created to\nplace the movie in the document.  You can use this either with or\nwithout the new operator.  Note that with any other DOM manipulation,\nyou must wait until the document is finished loading before trying\nto use this.","minSupported":{"!type":"number"},"available":{},"supported":{},"initialized":{"!type":"bool"},"onInitialize":{"!type":"fn()"},"place":{"!type":"fn(kwArgs: ?, node: ?) -> +QuickTimeObject"},"version":{"major":{"!type":"number"},"minor":{"!type":"number"},"rev":{"!type":"number"}}}},"encoding":{"_base":{},"ascii85":{"encode":{"!type":"fn(input: []) -> string","!doc":"encodes input data in ascii85 string"},"decode":{"!type":"fn(input: string)","!doc":"decodes the input string back to array of numbers"}},"base64":{"encode":{"!type":"fn(ba: [+byte]) -> string"},"decode":{"!type":"fn(str: string) -> [+byte]"}},"bits":{"OutputStream":{"!type":"fn()","prototype":{"reset":{"!type":"fn()"},"putBits":{"!type":"fn(value: ?, width: ?)"},"getWidth":{"!type":"fn()"},"getBuffer":{"!type":"fn()"}}},"InputStream":{"!type":"fn(buffer: ?, width: ?)","prototype":{"getBits":{"!type":"fn(width: ?)"},"getWidth":{"!type":"fn()"}}}},"compression":{"lzw":{"Encoder":{"!type":"fn(n: ?)","prototype":{"init":{"!type":"fn()"},"encode":{"!type":"fn(value: ?, stream: ?)"},"flush":{"!type":"fn(stream: ?)"}}},"Decoder":{"!type":"fn(n: ?)","prototype":{"init":{"!type":"fn()"},"decode":{"!type":"fn(stream: ?)"}}}},"splay":{},"Splay":{"!type":"fn(n: ?)","prototype":{"reset":{"!type":"fn()"},"splay":{"!type":"fn(i: ?)"},"encode":{"!type":"fn(value: ?, stream: ?)"},"decode":{"!type":"fn(stream: ?)"}}}},"crypto":{"Blowfish":{},"SimpleAES":{},"_base":{},"cipherModes":{"ECB":{"!type":"number"},"CBC":{"!type":"number"},"PCBC":{"!type":"number"},"CFB":{"!type":"number"},"OFB":{"!type":"number"},"CTR":{"!type":"number"}},"outputTypes":{"Base64":{"!type":"number"},"Hex":{"!type":"number"},"String":{"!type":"number"},"Raw":{"!type":"number"}}},"digests":{"_base":{},"addWords":{"!type":"fn(a: +word, b: +word) -> +word","!doc":"add a pair of words together with rollover"},"stringToWord":{"!type":"fn(s: string) -> [+word]","!doc":"convert a string to a word array"},"wordToString":{"!type":"fn(wa: [+word]) -> string","!doc":"convert an array of words to a string"},"wordToHex":{"!type":"fn(wa: [+word]) -> string","!doc":"convert an array of words to a hex tab"},"wordToBase64":{"!type":"fn(wa: [+word]) -> string","!doc":"convert an array of words to base64 encoding, should be more efficient\nthan using dojox.encoding.base64"},"MD5":{"!type":"fn(data: string, outputType?: +dojox.encoding.digests.outputTypes) -> [+word]","_hmac":{"!type":"fn(data: string, key: string, outputType?: +dojox.encoding.digests.outputTypes) -> [+word]"}},"SHA1":{"!type":"fn(data: string, outputType?: +dojox.encoding.digests.outputTypes) -> [+word]","!doc":"Computes the SHA1 digest of the data, and returns the result according to output type.","_hmac":{"!type":"fn(data: string, key: string, outputType?: +dojox.encoding.digests.outputTypes) -> [+word]","!doc":"computes the digest of data, and returns the result according to type outputType"}},"outputTypes":{"!doc":"Enumeration for input and output encodings.","Base64":{"!type":"number"},"Hex":{"!type":"number"},"String":{"!type":"number"},"Raw":{"!type":"number"}}},"easy64":{"encode":{"!type":"fn(input: []) -> string","!doc":"encodes input data in easy64 string"},"decode":{"!type":"fn(input: string)","!doc":"decodes the input string back to array of numbers"}}},"flash":{"!type":"fn()","!doc":"Utilities to embed and communicate with the Flash player from Javascript","ready":{"!type":"bool"},"url":{},"_visible":{"!type":"bool"},"_loadedListeners":{"!type":"[]"},"_installingListeners":{"!type":"[]"},"installer":{},"obj":{},"comm":{},"_base":{},"setSwf":{"!type":"fn(url: string, visible?: bool)","!doc":"Sets the SWF files and versions we are using."},"addLoadedListener":{"!type":"fn(listener: fn())","!doc":"Adds a listener to know when Flash is finished loading.\nUseful if you don't want a dependency on dojo.event."},"addInstallingListener":{"!type":"fn(listener: fn())","!doc":"Adds a listener to know if Flash is being installed.\nUseful if you don't want a dependency on dojo.event."},"loaded":{"!type":"fn()","!doc":"Called back when the Flash subsystem is finished loading."},"installing":{"!type":"fn()","!doc":"Called if Flash is being installed."},"_initialize":{"!type":"fn()"},"Info":{"!type":"fn()","!doc":"A class that helps us determine whether Flash is available.","prototype":{"version":{"!type":"number"},"versionMajor":{"!type":"number"},"versionMinor":{"!type":"number"},"versionRevision":{"!type":"number"},"capable":{"!type":"bool"},"installing":{"!type":"bool"},"isVersionOrAbove":{"!type":"fn(reqMajorVer: number, reqMinorVer: number, reqVer: number)","!doc":"Asserts that this environment has the given major, minor, and revision\nnumbers for the Flash player."},"_detectVersion":{"!type":"fn()"},"_JSFlashInfo":{"!type":"fn(testVersion: ?)"}}},"Embed":{"!type":"fn(visible: ?)","!doc":"A class that is used to write out the Flash object into the page.","prototype":{"width":{"!type":"number"},"height":{"!type":"number"},"id":{"!type":"string"},"_visible":{"!type":"bool"},"protocol":{"!type":"fn()"},"write":{"!type":"fn(doExpressInstall?: bool)","!doc":"Writes the Flash into the page."},"get":{"!type":"fn()","!doc":"Gets the Flash object DOM node."},"setVisible":{"!type":"fn(visible: bool)","!doc":"Sets the visibility of this Flash object."},"center":{"!type":"fn()","!doc":"Centers the flash applet on the page."}}},"Communicator":{"!type":"fn()","!doc":"A class that is used to communicate between Flash and JavaScript.","prototype":{"_addExternalInterfaceCallback":{"!type":"fn(methodName: ?)"},"_encodeData":{"!type":"fn(data: ?)"},"_decodeData":{"!type":"fn(data: ?)"},"_execFlash":{"!type":"fn(methodName: ?, methodArgs: ?)"}}},"Install":{"!type":"fn()","!doc":"Helps install Flash plugin if needed.","prototype":{"needed":{"!type":"fn()","!doc":"Determines if installation or revving of the current plugin is\nneeded."},"install":{"!type":"fn()","!doc":"Performs installation or revving of the Flash plugin."},"_onInstallStatus":{"!type":"fn(msg: ?)"}}},"info":{"installing":{"!type":"bool"}}},"form":{"RangeSlider":{},"__SelectOption":{"!type":"fn()"},"_BusyButtonMixin":{"!type":"fn()","prototype":{"isBusy":{"!type":"bool"},"busyLabel":{"!type":"string"},"timeout":{},"useIcon":{"!type":"bool"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()","!doc":"stores initial label and timeout for reference"},"makeBusy":{"!type":"fn()","!doc":"sets state from idle to busy"},"cancel":{"!type":"fn()","!doc":"if no timeout is set or for other reason the user can put the button back\nto being idle"},"resetTimeout":{"!type":"fn(timeout: number)","!doc":"to reset existing timeout and setting a new timeout"},"setLabel":{"!type":"fn(content: string, timeout: number)","!doc":"reset the label (text) of the button; takes an HTML string"},"_clicked":{"!type":"fn(e: ?)","!doc":"on button click the button state gets changed"}}},"BusyButton":{"!type":"fn()","prototype":{"!proto":"dijit.form.Button.prototype"}},"BusyComboButton":{"!type":"fn()","prototype":{"!proto":"dijit.form.ComboButton.prototype"}},"BusyDropDownButton":{"!type":"fn()","prototype":{"!proto":"dijit.form.DropDownButton.prototype"}},"_CheckedMultiSelectItem":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"The individual items for a CheckedMultiSelect","widgetsInTemplate":{"!type":"bool"},"templatePath":{},"baseClass":{"!type":"string"},"option":{"!doc":"The option that is associated with this item","!type":"+dojox.form.__SelectOption"},"parent":{},"disabled":{"!doc":"Whether or not this widget is disabled","!type":"bool"},"readOnly":{"!doc":"Whether or not this widget is readOnly","!type":"bool"},"postMixInProperties":{"!type":"fn()","!doc":"Set the appropriate _subClass value - based on if we are multi-\nor single-select"},"postCreate":{"!type":"fn()","!doc":"Set innerHTML here - since the template gets messed up sometimes\nwith rich text"},"_changeBox":{"!type":"fn()","!doc":"Called to force the select to match the state of the check box\n(only on click of the checkbox)  Radio-based calls _setValueAttr\ninstead."},"_onMouse":{"!type":"fn(e: ?)","!doc":"Sets the hover state depending on mouse state (passes through\nto the check box)"},"_onClick":{"!type":"fn(e: ?)","!doc":"Sets the click state (passes through to the check box)"},"_updateBox":{"!type":"fn()","!doc":"Called to force the box to match the state of the select"},"_setDisabledAttr":{"!type":"fn(value: ?)","!doc":"Disables (or enables) all the children as well"},"_setReadOnlyAttr":{"!type":"fn(value: ?)","!doc":"Sets read only (or unsets) all the children as well"}}},"CheckedMultiSelect":{"!type":"fn()","prototype":{"!proto":"dojox.form._FormSelectWidget.prototype","!doc":"Extends the core dijit MultiSelect to provide a \"checkbox\" selector","templateString":{"!type":"string"},"templatePath":{},"baseClass":{"!type":"string"},"_mouseDown":{"!type":"fn(e: ?)","!doc":"Cancels the mousedown event to prevent others from stealing\nfocus"},"_addOptionItem":{"!type":"fn(option: +dojox.form.__SelectOption)"},"_updateSelection":{"!type":"fn()"},"_getChildren":{"!type":"fn()"},"invertSelection":{"!type":"fn(onChange: bool)","!doc":"Invert the selection"},"_setDisabledAttr":{"!type":"fn(value: ?)","!doc":"Disable (or enable) all the children as well"},"_setReadOnlyAttr":{"!type":"fn(value: ?)","!doc":"Sets read only (or unsets) all the children as well"},"uninitialize":{"!type":"fn()"}}},"DateTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form._DateTimeTextBox.prototype","!doc":"A validating, serializable, range-bound date text box with a popup calendar","popupClass":{"!doc":"The popup widget to use. In this case, a calendar with Day, Month and Year views.","!type":"string"},"_selector":{"!type":"string"},"_open":{"!type":"fn()"}}},"DayTextBox":{"!type":"fn()","prototype":{"!proto":"dojox.form.DateTextBox.prototype","!doc":"A validating, serializable, range-bound date text box with a popup calendar that contains just months.","popupClass":{"!doc":"The popup widget to use. In this case, a calendar with just a Month view.","!type":"string"},"format":{"!type":"fn(value: ?)"},"validator":{"!type":"fn(value: ?)"},"_open":{"!type":"fn()"}}},"MonthTextBox":{"!type":"fn()","prototype":{"!proto":"dojox.form.DateTextBox.prototype","!doc":"A validating, serializable, range-bound date text box with a popup calendar that contains just months.","popupClass":{"!doc":"The popup widget to use. In this case, a calendar with just a Month view.","!type":"string"},"format":{"!type":"fn(value: ?)"},"validator":{"!type":"fn(value: ?)"},"_open":{"!type":"fn()"}}},"YearTextBox":{"!type":"fn()","prototype":{"!proto":"dojox.form.DateTextBox.prototype","!doc":"A validating, serializable, range-bound date text box with a popup calendar that contains only years","popupClass":{"!doc":"The popup widget to use. In this case, a calendar with just a Year view.","!type":"string"},"format":{"!type":"fn(value: ?)"},"validator":{"!type":"fn(value: ?)"},"_open":{"!type":"fn()"}}},"_DropDownSelectMenu":{"!type":"fn()","prototype":{"!proto":"dijit.Menu.prototype","buildRendering":{"!type":"fn()"},"resize":{"!type":"fn(mb: ?)"}}},"DropDownSelect":{"!type":"fn()","prototype":{"!proto":"dojox.form._FormSelectWidget.prototype","!doc":"This is a \"Styleable\" select box - it is basically a DropDownButton which\ncan take as its input a <select>.","attributeMap":{"!doc":"Add in our style to be applied to the focus node"},"baseClass":{"!type":"string"},"templatePath":{},"required":{"!doc":"Can be true or false, default is false.","!type":"bool"},"state":{"!doc":"Shows current state (ie, validation result) of input (Normal, Warning, or Error)","!type":"string"},"tooltipPosition":{"!doc":"See description of dijit.Tooltip.defaultPosition for details on this parameter.","!type":"[string]"},"emptyLabel":{"!doc":"What to display in an &quot;empty&quot; dropdown","!type":"string"},"_isLoaded":{"!doc":"Whether or not we have been loaded","!type":"bool"},"_childrenLoaded":{"!doc":"Whether or not our children have been loaded","!type":"bool"},"_fillContent":{"!type":"fn()","!doc":"Set the value to be the first, or the selected index"},"_getMenuItemForOption":{"!type":"fn(option: +dojox.form.__SelectOption)","!doc":"For the given option, return the menu item that should be\nused to display it.  This can be overridden as needed"},"_addOptionItem":{"!type":"fn(option: +dojox.form.__SelectOption)","!doc":"For the given option, add a option to our dropdown\nIf the option doesn't have a value, then a separator is added\nin that place."},"_getChildren":{"!type":"fn()"},"_loadChildren":{"!type":"fn()","!doc":"Resets the menu and the length attribute of the button - and\nensures that the label is appropriately set."},"_setValueAttr":{"!type":"fn(value: ?)"},"_setDisplay":{"!type":"fn(newDisplay: string)","!doc":"sets the display for the given value (or values)"},"validate":{"!type":"fn(isFocused: bool)","!doc":"Called by oninit, onblur, and onkeypress."},"isValid":{"!type":"fn(isFocused: bool)","!doc":"Whether or not this is a valid value"},"reset":{"!type":"fn()","!doc":"Overridden so that the state will be cleared."},"postMixInProperties":{"!type":"fn()","!doc":"set the missing message"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"_onMenuMouseup":{"!type":"fn(e: ?)"},"isLoaded":{"!type":"fn()"},"loadDropDown":{"!type":"fn(loadCallback: fn())","!doc":"populates the menu"},"_setReadOnlyAttr":{"!type":"fn(value: ?)"},"_setDisabledAttr":{"!type":"fn(value: ?)"},"uninitialize":{"!type":"fn(preserveDom: ?)"}}},"DropDownStack":{"!type":"fn()","prototype":{"!proto":"dojox.form.DropDownSelect.prototype","!doc":"A dropdown-based select stack."}},"FileInput":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormWidget.prototype","!doc":"A styled input type=\"file\"","label":{"!doc":"the title text of the &quot;Browse&quot; button","!type":"string"},"cancelText":{"!doc":"the title of the &quot;Cancel&quot; button","!type":"string"},"name":{"!doc":"ugh, this should be pulled from this.domNode","!type":"string"},"templatePath":{},"startup":{"!type":"fn()","!doc":"listen for changes on our real file input"},"_matchValue":{"!type":"fn()","!doc":"set the content of the upper input based on the semi-hidden file input"},"setLabel":{"!type":"fn(label: string, cssClass?: string)","!doc":"method to allow use to change button label"},"reset":{"!type":"fn(e: +Event)","!doc":"on click of cancel button, since we can't clear the input because of\nsecurity reasons, we destroy it, and add a new one in it's place."}}},"FileInputAuto":{"!type":"fn()","prototype":{"!proto":"dojox.form.FileInput.prototype","!doc":"An extension on dojox.form.FileInput providing background upload progress","url":{"!doc":"the URL where our background FileUpload will be sent","!type":"string"},"blurDelay":{"!doc":"time in ms before an un-focused widget will wait before uploading the file to the url=&quot;&quot; specified\ndefault: 2 seconds","!type":"+Integer"},"duration":{"!doc":"The time in ms to use as the generic timing mechanism for the animations\nset to 1 or 0 for &quot;immediate respose&quot;","!type":"+Integer"},"uploadMessage":{"!doc":"FIXME: i18n somehow?","!type":"string"},"triggerEvent":{"!doc":"Event which triggers the upload. Defaults to onblur, sending the file selected\n'blurDelay' milliseconds after losing focus. Set to &quot;onchange&quot; with a low blurDelay\nto send files immediately after uploading.","!type":"string"},"_sent":{"!type":"bool"},"templatePath":{},"startup":{"!type":"fn()","!doc":"add our extra blur listeners"},"_onFocus":{"!type":"fn()","!doc":"clear the upload timer"},"_onBlur":{"!type":"fn()","!doc":"start the upload timer"},"setMessage":{"!type":"fn(title: string)","!doc":"set the text of the progressbar"},"_sendFile":{"!type":"fn(e: +Event)","!doc":"triggers the chain of events needed to upload a file in the background."},"_handleSend":{"!type":"fn(data: ?, ioArgs: ?)","!doc":"The callback to toggle the progressbar, and fire the user-defined callback"},"reset":{"!type":"fn(e: ?)","!doc":"accomodate our extra focusListeners"},"onComplete":{"!type":"fn(data: +the, ioArgs: +the, widgetRef: +this)","!doc":"stub function fired when an upload has finished."}}},"FileInputBlind":{"!type":"fn()","prototype":{"!proto":"dojox.form.FileInputAuto.prototype","!doc":"An extended version of dojox.form.FileInputAuto\nthat does not display an input node, but rather only a button\nand otherwise behaves just like FileInputAuto","startup":{"!type":"fn()","!doc":"hide our fileInput input field"},"_fixPosition":{"!type":"fn()","!doc":"in this case, set the button under where the visible button is"},"reset":{"!type":"fn(e: ?)","!doc":"onclick, we need to reposition our newly created input type=&quot;file&quot;"}}},"FilePickerTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.ValidationTextBox.prototype","!doc":"A validating text box tied to a file picker popup","baseClass":{"!type":"string"},"templatePath":{},"searchDelay":{"!doc":"Delay in milliseconds between when user types something and we start\nsearching based on that value","!type":"+Integer"},"_stopClickEvents":{"!type":"bool"},"valueItem":{"!doc":"The item, in our store, of the directory relating to our value","!type":"+item"},"numPanes":{"!doc":"The number of panes to display in our box (if we don't have any\nminPaneWidth specified by our constraints)","!type":"number"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"_setValueAttr":{"!type":"fn(value: string, priorityChange: ?, fromWidget: ?)","!doc":"sets the value of this widget"},"_onWidgetChange":{"!type":"fn(item: +item)","!doc":"called when the path gets changed in the dropdown"},"startup":{"!type":"fn()"},"openDropDown":{"!type":"fn()"},"toggleDropDown":{"!type":"fn()"},"_focusBlur":{"!type":"fn(e: +Event)","!doc":"called when the focus node gets blurred"},"_focusFocus":{"!type":"fn(e: +Event)","!doc":"called when the focus node gets focus"},"_onBlur":{"!type":"fn()","!doc":"called when focus is shifted away from this widget"},"_setBlurValue":{"!type":"fn()","!doc":"sets the value of the widget once focus has left"},"parse":{"!type":"fn(value: string, constraints: ?)","!doc":"Function to convert a formatted string to a value - we use\nit to verify that it *really* is a valid value"},"_startSearchFromInput":{"!type":"fn()","!doc":"kicks off a search based off the current text value of the widget"},"_onKey":{"!type":"fn(e: +Event)","!doc":"callback when the user presses a key on menu popup node"}}},"FileUploader":{"!type":"fn()","prototype":{"!doc":"Handles File Uploading to a server (PHP script included for testing)\nDoes *NOT* create a button, it transforms a button into an uploader.\nThis can be used for toolbar buttons for example.","isDebug":{"!doc":"If true, outputs traces from the SWF to console. What exactly gets passed\nis very relative, and depends upon what traces have been left in the DEFT SWF.","!type":"bool"},"devMode":{"!doc":"If true, gives a red overlay to the Flash button and the HTML fileInput button's\nopcaity is set to 1.0. Since this code uses some crazy CSS to get the uploaders\nto hover over the 'fake' button, there is no garuantee that it will work in all\ncases. Set this param to true to see if the button is properly positioned.\nMethods may be called over over-written to help in this case.","!type":"+Boolean."},"id":{"!doc":"The object id, just like any other widget in Dojo. However, this id\nis also used as a reference for the SWF","!type":"string"},"uploadUrl":{"!doc":"REQUIRED: The Url to where the file will be uploaded","!type":"string"},"button":{"!doc":"or a domNode\nREQUIRED: The button that when clicked, launches the upload dialog","!type":"+dijit.form.Button"},"uploadOnChange":{"!doc":"If true, uploads imeediately after a file has been selected. If false,\nwaits for upload() to be called.","!type":"bool"},"selectMultipleFiles":{"!doc":"If true and flash mode, multiple files may be selected from the dialog.\nIf html mode, files are not uploaded until upload() is called. The references\nto each file is incremented:uploadedfile0, uploadedfile1, uploadedfile2... etc.","!type":"bool"},"htmlFieldName":{"!doc":"The name of the field of the fileInput that the server is expecting","!type":"string"},"flashFieldName":{"!doc":"The name of the field of the flash uploaded files that the server is expecting","!type":"string"},"fileMask":{"!doc":"Array[Description, FileTypes], Array[...]...]\n(an array, or an array of arrays)\nRestrict file selection to certain file types\nEmpty array defaults to &quot;All Files&quot;","!type":"[+Array]"},"force":{"!doc":"options:\n&quot;flash&quot; forces Flash Uploader\n&quot;html&quot; forces HTML fileInput\n&quot;&quot; checks availability of the proper Flash player","!type":"string"},"postData":{"!doc":"FLASH ONLY - In HTML, append the vars to the uploadUrl\nSends data via POST to the server along with the uploaded\nfiles.\nNEW:\nYou can also pass postData in the upload method\nwhich can be different with each upload"},"minFlashVersion":{"!doc":"Internal. Version of Flash Player to check for. Thi may be over-written\nfor testing.","!type":"number"},"uploaderType":{"!doc":"Internal.","!type":"string"},"flashObject":{"!doc":"The object that creates the SWF embed object. Mostly Internal.","!type":"+dojox.embed.Flash"},"flashDiv":{"!doc":"The div that holds the SWF. While mostly internal, ccould be accessed\nfor advanced positioning.","!type":"+HTMLNode"},"domNode":{"!doc":"either flash div or fileInput, depending on type\n\n\nonClick: function(){\n// summary:\n//\t\tFired when upload button is up\n//\t\tStub to which user can connect\n},","!type":"+HTMLNode"},"flashMovie":{"!type":"fn()","!doc":"The SWF. Mostly Internal."},"constructor":{"!type":"fn(options: ?)","!doc":"Calling init function instead of doing operations in\nconstructor, to allow for patches and over-writes."},"log":{"!type":"fn()","!doc":"Due to the excessive logging necessary to make this code happen,\nIt's easier to turn it on and off here in one place.\nAlso helpful if there are multiple uploaders on one page."},"init":{"!type":"fn(options: ?)","!doc":"Determine which uploader to use and initialize it."},"onMouseDown":{"!type":"fn(evt: ?)","!doc":"Fired when upload button is down\nStub to which user can connect"},"onMouseUp":{"!type":"fn(evt: ?)","!doc":"Fired when upload button is up\nStub to which user can connect"},"onMouseOver":{"!type":"fn(evt: ?)","!doc":"Fired when upload button is over\nCan be connected to for manipulating hover state"},"onMouseOut":{"!type":"fn(evt: ?)","!doc":"Fired when upload button is off\nCan be connected to for manipulating hover state"},"onChange":{"!type":"fn(dataArray: ?)","!doc":"stub to connect\nFires when files are selected\nEvent is an array of last files selected"},"onProgress":{"!type":"fn(dataArray: ?)","!doc":"Stub to connect\nFires as progress returns from SWF\nEvent is an array of all files uploading\nCan be connected to for HTML uploader,\nbut will not return anything."},"onComplete":{"!type":"fn(dataArray: ?)"},"onCancel":{"!type":"fn()","!doc":"Stub to connect\nFires when dialog box has been closed\nwithout a file selection"},"onError":{"!type":"fn(evtObject: ?)"},"upload":{"!type":"fn(data: ?)","!doc":"When called, begins file upload"},"setPosition":{"!type":"fn()","!doc":"Positions the upload button over the 'fake' button.\nThis method is called on init, and may be called\nfor various other reasons, for example, when the browser\nwindow is resized. Also, this code detects if the\nupload button is within a Dijit Dialog, and calls\nthis method when the Dialog is dragged. Whenever the\nDOM has been redrawn, you should call this method."},"hide":{"!type":"fn()","!doc":"Hides the upload button. This is called\nwhen within a dialog."},"show":{"!type":"fn()","!doc":"Shows the upload button. This is called\nwhen within a dialog."},"disable":{"!type":"fn(disabled: bool)","!doc":"This method is connected to the &quot;fake&quot; dijit\nbutton, and hides and shows on the disabling.\nIf the &quot;fake&quot; button is a dom node, this method\nwould need to be called directly."},"destroyAll":{"!type":"fn()","!doc":"Destroys everything including 'fake' button"},"destroy":{"!type":"fn()","!doc":"Destroys flash\nTODO: This doesn't look complete. HTML?"},"createFlashUploader":{"!type":"fn()"},"setFlashVars":{"!type":"fn()"},"createHtmlUploader":{"!type":"fn()","!doc":"Create the fileInput overlay"},"setFlashPosition":{"!type":"fn()","!doc":"Get size and location of the 'fake' node (the button)\nResize, set position of the SWF"},"setHtmlPosition":{"!type":"fn()","!doc":"Get size and location of the 'fake' node (the button)\nResize, set position, and clip the 'real' button (the fileInput)\nsetPosition will fire on browser resize. The button may wrap to a different position\nand sometimes it just shifts slightly in the html, maybe because of the scrollbar."},"_connectFlash":{"!type":"fn()","!doc":"Subscribing to published topics coming from the\nFlash uploader."},"_doSub":{"!type":"fn(subStr: ?, funcStr: ?)"},"_connectInput":{"!type":"fn()"},"_connectCommon":{"!type":"fn()"},"_checkHtmlCancel":{"!type":"fn(mouseType: ?)"},"_error":{"!type":"fn(evt: ?)"},"_change":{"!type":"fn(dataArray: ?)"},"_complete":{"!type":"fn(dataArray: ?)"},"_progress":{"!type":"fn(dataObject: ?)"},"_dialogParent":{"!type":"fn()"},"_disconnect":{"!type":"fn()"},"_buildFileInput":{"!type":"fn(node: ?)"},"_removeFileInput":{"!type":"fn()"},"_buildForm":{"!type":"fn(node: ?)","!doc":"Build the form that holds the fileInput\nThis form also holds the class that targets\nthe input to change its size"},"_setHtmlPostData":{"!type":"fn()"},"_setFormStyle":{"!type":"fn()","!doc":"Apply a dynamic style to the form and input"},"getFakeButtonSize":{"!type":"fn()","!doc":"Get the size and position of the Dijit Button or DOM node."}},"swfPath":{"!doc":"optional: pass in a path to your own SWF file uploader. defaults to the one in dojox.\nCDN USERS NOTE: For the Flash Uploader to work via CDN, the SWF must be from the\nsame server as the HTML page. Pass the link to that file here.","!type":"string"}},"Manager":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"The widget to orchestrate dynamic forms.","widgetsInTemplate":{"!type":"bool"},"buildRendering":{"!type":"fn()"},"startup":{"!type":"fn()"}}},"MultiComboBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.ValidationTextBox.prototype","!doc":"A ComboBox that accpets multiple inputs on a single line?","delimiter":{"!doc":"The character to use to separate items in the ComboBox input","!type":"string"},"_previousMatches":{"!type":"bool"},"_setValueAttr":{"!type":"fn(value: ?)"},"_addPreviousMatches":{"!type":"fn(text: string) -> string"},"_cleanupDelimiters":{"!type":"fn(text: string)"},"_autoCompleteText":{"!type":"fn(text: string)"},"_startSearch":{"!type":"fn(text: string)"}}},"_ChildTextBox":{"!type":"fn()","prototype":{"!proto":"dijit.form.ValidationTextBox.prototype","!doc":"A class that is shared between all our children - extends\nValidationTextBox and provides some shared functionality","containerWidget":{"!doc":"Our parent (the PasswordValidator)","!type":"+dijit._Widget"},"type":{"!doc":"Don't override this - we are all &quot;password&quot; types","!type":"string"},"reset":{"!type":"fn()","!doc":"Force-set to empty string (we don't save passwords EVER)...and\nsince _OldPWBox overrides _setValueAttr to check for empty string,\ncall our parent class directly (not this.inherited())"},"postCreate":{"!type":"fn()","!doc":"We want to remove the &quot;name&quot; attribute from our focus node if\nwe don't have one set - this prevents all our extra values\nfrom being posted on submit"}}},"_OldPWBox":{"!type":"fn()","prototype":{"!proto":"dojox.form._ChildTextBox.prototype","!doc":"A class representing our \"old password\" box.","_isPWValid":{"!doc":"Whether or not the password is valid","!type":"bool"},"_setValueAttr":{"!type":"fn(newVal: +anything, priority?: bool)","!doc":"Updates _isPWValid if this isn't our initial update by calling\nour PasswordValidator's pwCheck function"},"isValid":{"!type":"fn(isFocused: bool)"},"_update":{"!type":"fn(e: +event)"},"_getValueAttr":{"!type":"fn()"},"_setBlurValue":{"!type":"fn()"}}},"_NewPWBox":{"!type":"fn()","prototype":{"!proto":"dojox.form._ChildTextBox.prototype","!doc":"A class representing our new password textbox","required":{"!doc":"Whether or not this widget is required (default: true)","!type":"bool"},"onChange":{"!type":"fn()","!doc":"Validates our verify box - to make sure that a change to me is\nreflected there"}}},"_VerifyPWBox":{"!type":"fn()","prototype":{"!proto":"dojox.form._ChildTextBox.prototype","!doc":"A class representing our verify textbox","isValid":{"!type":"fn(isFocused: ?)","!doc":"Validates that we match the &quot;real&quot; password"}}},"PasswordValidator":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormValueWidget.prototype","!doc":"A password validation widget that simplifies the \"old/new/verify\"\nstyle of requesting passwords.  You will probably want to override\nthis class and implement your own pwCheck function.","required":{"!doc":"Whether or not it is required for form submission","!type":"bool"},"_inputWidgets":{},"oldName":{"!doc":"The name to send our old password as (when form is posted)","!type":"string"},"templatePath":{},"_hasBeenBlurred":{"!type":"bool"},"isValid":{"!type":"fn(isFocused: bool)","!doc":"we are valid if ALL our children are valid"},"validate":{"!type":"fn(isFocused: bool)","!doc":"Validating this widget validates all our children"},"reset":{"!type":"fn()","!doc":"Resetting this widget resets all our children"},"_createSubWidgets":{"!type":"fn()","!doc":"Turns the inputs inside this widget into &quot;real&quot; validation\nwidgets - and sets up the needed connections."},"pwCheck":{"!type":"fn(password: string)","!doc":"Overridable function for validation of the old password box.\n\nThis function is called and passed the old password.  Return\ntrue if it's OK to continue, and false if it is not.\n\nIMPORTANT SECURITY NOTE:  Do NOT EVER EVER EVER check this in\nHTML or JavaScript!!!\n\nYou will probably want to override this function to callback\nto a server to verify the password (the callback will need to\nbe syncronous) - and it's probably a good idea to validate\nit again on form submission before actually doing\nanything destructive - that's why the &quot;oldName&quot; value\nis available.\n\nAnd don't just fetch the password from the server\neither :)  Send the test password (probably hashed, for\nsecurity) and return from the server a status instead.\n\nAgain - DON'T BE INSECURE!!!  Security is left as an exercise\nfor the reader :)"},"postCreate":{"!type":"fn()","!doc":"Sets up the correct widgets.  You *MUST* specify one child\ntext box (a simple HTML &lt;input&gt; element) with pwType=&quot;new&quot;\nand* one child text box with pwType=&quot;verify&quot;.  You *MAY*\nspecify a third child text box with pwType=&quot;old&quot; in order to\nprompt the user to enter in their old password before the\nwidget returns that it is valid."},"_childValueAttr":{"!type":"fn(v: ?)"},"_setDisabledAttr":{"!type":"fn(value: ?)"},"_setRequiredAttribute":{"!type":"fn(value: ?)"},"_setValueAttr":{"!type":"fn(v: ?)"},"_getValueAttr":{"!type":"fn()"},"focus":{"!type":"fn()","!doc":"places focus on the first invalid input widget - if all\ninput widgets are valid, the first widget is focused."}}},"RadioStack":{"!type":"fn()","prototype":{"!proto":"dojox.form.CheckedMultiSelect.prototype","!doc":"A radio-based select stack."}},"_RangeSliderMixin":{"!type":"fn()","prototype":{"value":{"!type":"[]"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"_onKeyPress":{"!type":"fn(e: +Event)"},"_onHandleClickMax":{"!type":"fn(e: ?)"},"_onClkIncBumper":{"!type":"fn()"},"_bumpValue":{"!type":"fn(signedChange: ?, useMaxValue: ?)"},"_getBumpValue":{"!type":"fn(signedChange: ?, useMaxValue: ?)"},"_onBarClick":{"!type":"fn(e: ?)"},"_onRemainingBarClick":{"!type":"fn(e: ?)"},"_setPixelValue":{"!type":"fn(pixelValue: number, maxPixels: number, priorityChange: bool, isMaxVal: bool)"},"_getValueByPixelValue":{"!type":"fn(pixelValue: number, maxPixels: number)"},"_setValueAttr":{"!type":"fn(value: [], priorityChange: bool, isMaxVal: bool)"},"_printSliderBar":{"!type":"fn(priorityChange: ?, isMaxVal: ?)"}}},"HorizontalRangeSlider":{"!type":"fn()","prototype":{"!proto":"dijit.form.HorizontalSlider.prototype","!doc":"A form widget that allows one to select a range with two horizontally draggable images","templatePath":{}}},"VerticalRangeSlider":{"!type":"fn()","prototype":{"!proto":"dijit.form.VerticalSlider.prototype","!doc":"A form widget that allows one to select a range with two vertically draggable images","templatePath":{}}},"Rating":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormWidget.prototype","!doc":"A widget for rating using stars.\n\nrequired: Boolean\nTODO: Can be true or false, default is false.\nrequired: false,","templateString":{},"numStars":{"!doc":"The number of stars to show, default is 3.","!type":"+Integer"},"value":{"!doc":"The current value of the Rating","!type":"+Integer"},"constructor":{"!type":"fn(params: ?)"},"postCreate":{"!type":"fn()"},"_onMouse":{"!type":"fn(evt: ?)"},"_renderStars":{"!type":"fn(value: ?, hover: ?)","!doc":"Render the stars depending on the value."},"onStarClick":{"!type":"fn(evt: +Event)","!doc":"Connect on this method to get noticed when a star was clicked."},"onMouseOver":{"!type":"fn()","!doc":"Connect here, the value is passed to this function as the second parameter!"},"setAttribute":{"!type":"fn(key: string, value: ?)","!doc":"When calling setAttribute(&quot;value&quot;, 4), set the value and render the stars accordingly."}}},"TimeSpinner":{"!type":"fn()","prototype":{"!proto":"dijit.form._Spinner.prototype","!doc":"Time Spinner","required":{"!type":"bool"},"smallDelta":{"!type":"number"},"largeDelta":{"!type":"number"},"timeoutChangeRate":{"!type":"number"},"value":{"!type":"string"},"adjust":{"!type":"fn(val: ?, delta: number)"},"isValid":{"!type":"fn()"},"parse":{"!type":"fn(time: ?, locale: ?)"},"format":{"!type":"fn(time: ?, locale: ?)"}},"serialize":{}},"_FormSelectWidget":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormValueWidget.prototype","multiple":{"!doc":"Matches the select's &quot;multiple=&quot; value","!type":"bool"},"_multiValue":{"!doc":"Whether or not we are multi-valued (for form)","!type":"bool"},"options":{"!doc":"The set of options for our select item.  Roughly corresponds to\nthe html &lt;option&gt; tag.\n\n\nremove when _FormWidget:getValue is removed","!type":"[+dojox.form.__SelectOption]"},"_getValueDeprecated":{"!type":"bool"},"getOptions":{"!type":"fn(valueOrIdx: +anything) -> [+dojox.form.__SelectOption]","!doc":"Returns a given option (or options)."},"addOption":{"!type":"fn(option: +dojox.form.__SelectOption)","!doc":"Adds an option or options to the end of the select.  If value\nof the option is empty or missing, a separator is created instead.\nPassing in an array of options will yeild slightly better performance\nsince the children are only loaded once."},"removeOption":{"!type":"fn(valueOrIdx: string)","!doc":"Removes the given option or options.  You can remove by string\n(in which case the value is removed), number (in which case the\nindex in the options array is removed), or select option (in\nwhich case, the select option with a matching value is removed).\nYou can also pass in an array of those values for a slightly\nbetter performance since the children are only loaded once."},"updateOption":{"!type":"fn(newOption: +dojox.form.__SelectOption)","!doc":"Updates the values of the given option.  The option to update\nis matched based on the value of the entered option.  Passing\nin an array of new options will yeild better performance since\nthe children will only be loaded once."},"_setValueAttr":{"!type":"fn(newValue: +anything, priorityChange: bool)","!doc":"set the value of the widget.\nIf a string is passed, then we set our value from looking it up."},"_getDisplayedValueAttr":{"!type":"fn()","!doc":"returns the displayed value of the widget"},"getValue":{"!type":"fn()","!doc":"get the value of the widget."},"undo":{"!type":"fn()","!doc":"restore the value to the last value passed to onChange"},"_loadChildren":{"!type":"fn()","!doc":"Loads the children represented by this widget's optiosn.\nreset the menu to make it &quot;populatable on the next click"},"_updateSelection":{"!type":"fn()","!doc":"Sets the &quot;selected&quot; class on the item for styling purposes"},"_getValueFromOpts":{"!type":"fn()","!doc":"Returns the value of the widget by reading the options for\nthe selected flag"},"postMixInProperties":{"!type":"fn()"},"_fillContent":{"!type":"fn()","!doc":"Loads our options and sets up our dropdown correctly.  We\ndon't want any content, so we don't call any inherit chain\nfunction."},"postCreate":{"!type":"fn()","!doc":"sets up our event handling that we need for functioning\nas a select"},"_addOptionItem":{"!type":"fn(option: +dojox.form.__SelectOption)","!doc":"User-overridable function which, for the given option, adds an\nitem to the select.  If the option doesn't have a value, then a\nseparator is added in that place.  Make sure to store the option\nin the created option widget."},"_removeOptionItem":{"!type":"fn(option: +dojox.form.__SelectOption)","!doc":"User-overridable function which, for the given option, removes\nits item from the select."},"_setDisplay":{"!type":"fn(newDisplay: string)","!doc":"Overridable function which will set the display for the\nwidget.  newDisplay is either a string (in the case of\nsingle selects) or array of strings (in the case of multi-\nselects)"},"_getChildren":{"!type":"fn()","!doc":"Overridable function to return the children that this widget\ncontains."},"_getSelectedOptionsAttr":{"!type":"fn()","!doc":"hooks into this.attr to provide a mechanism for getting the\noption items for the current value of the widget."}}},"_HasDropDown":{"!type":"fn()","prototype":{"!doc":"Mixin for widgets that need drop down ability.","dropDownNode":{"!doc":"responds to click events.  &quot;dropDownNode&quot; can be set via\na dojoAttachPoint assignment.  If missing, then either focusNode\nor domNode (if focusNode is also missing) will be used.","!type":"+Node"},"popupStateNode":{"!doc":"the node to set the popupActive class on.  If missing, then\nfocusNode or dropDownNode (if focusNode is missing) will be used.","!type":"+Node"},"aroundNode":{"!doc":"the node to display the popup around.  If missing, then\ndomNode will be used.","!type":"+Node"},"dropDown":{"!doc":"the widget to display in the popup.  This widget *must* be\ndefined before the startup function is called.","!type":"+dijit._Widget"},"autoWidth":{"!doc":"Set to true to make the drop down at least as wide as this\nwidget.  Set to false if the drop down should just be its\ndefault width","!type":"bool"},"maxHeight":{"!doc":"The max height for our dropdown.  Set to 0 for no max height.\nany dropdown taller than this will have scrollbars","!type":"+Integer"},"_stopClickEvents":{"!doc":"When set to false, the click events will not be stopped, in\ncase you want to use them in your subwidget","!type":"bool"},"_onMenuMouseup":{"!type":"fn(e: +Event)","!doc":"called with the mouseup event if the mouseup occurred\nover the menu.  You can try and use this event in\norder to automatically execute your dropdown (as\nif it were clicked).  You mightwant to close your menu\nas a part of this function."},"_onDropDownMouse":{"!type":"fn(e: +Event)","!doc":"callback when the user mouse clicks on menu popup node\n\nWe handle mouse events using onmousedown in order to allow for\nselecting via a drag.  So, our click is already handled, unless\nwe are executed via keypress - in which case, this._seenKeydown\nwill be set to true."},"_onDropDownMouseup":{"!type":"fn(e?: +Event)","!doc":"callback when the user lifts their mouse - if we are\nover the menu, we execute it, otherwise, we focus our\ndropDown node.  If the event is missing, then we are not\na mouseup event."},"_setupDropdown":{"!type":"fn()","!doc":"set up nodes and connect our mouse and keypress events"},"postCreate":{"!type":"fn()"},"destroyDescendants":{"!type":"fn()"},"_onDropDownKeydown":{"!type":"fn(e: +Event)"},"_onKeyPress":{"!type":"fn(e: +Event)"},"_onDropDownBlur":{"!type":"fn(e: +Event)"},"_onKey":{"!type":"fn(e: +Event)","!doc":"callback when the user presses a key on menu popup node"},"_onBlur":{"!type":"fn()","!doc":"called magically when focus has shifted away from this widget and it's dropdown"},"isLoaded":{"!type":"fn()","!doc":"returns whether or not the dropdown is loaded.  This can\nbe overridden in order to force a call to loadDropDown()."},"loadDropDown":{"!type":"fn(loadCallback: fn())","!doc":"loads the data for the dropdown, and at some point, calls\nthe given callback"},"toggleDropDown":{"!type":"fn()","!doc":"toggle the drop-down widget; if it is up, close it, if not, open it"},"openDropDown":{"!type":"fn()","!doc":"opens the dropdown for this widget - it returns the\nreturn value of dijit.popup.open"},"closeDropDown":{"!type":"fn(focus: bool)","!doc":"Closes the drop down on this widget"}}},"_SelectStackMixin":{"!type":"fn()","prototype":{"!doc":"Mix this class in to a dojox.form._FormSelectWidget in order to\nprovide support for \"selectable\" multiforms.  The widget is pointed\nto a dijit.layout.StackContainer and will handle displaying and\nsubmitting the values of only the appropriate pane.\n\nThe options for this widget will be automatically set - based on\nthe panes that are in the stack container.  The \"title\" attribute of\nthe pane will be used for the display of the option.  The \"id\" attribute\nof the pane will be used as the value of the option.  In order to\navoid running into unique ID constraint issues, a stackPrefix mechanism\nis provided.","stackId":{"!doc":"The id of the stack that this widget is supposed to control","!type":"string"},"stackPrefix":{"!doc":"A prefix to remove from our stack pane ids when setting our options.\nThis exists so that we won't run into unique ID constraints.  For\nexample, if stackPrefix is set to &quot;foo_&quot;, and there are three panes\nin our stack with ids of &quot;foo_a&quot;, &quot;foo_b&quot;, and &quot;foo_c&quot;, then the values\nof the options created for the stack controller widget will be &quot;a&quot;,\n&quot;b&quot;, and &quot;c&quot;.  This allows you to have multiple select stack widgets\nwith the same values - without having to have the panes require the\nsame ids.","!type":"string"},"_paneIdFromOption":{"!type":"fn(oVal: string) -> string","!doc":"Gets the pane ID given an option value"},"_optionValFromPane":{"!type":"fn(id: string) -> string","!doc":"Gets the option value given a pane ID"},"_togglePane":{"!type":"fn(pane: +dijit._Widget, shown: bool)","!doc":"called when a pane is either shown or hidden (so that\nwe can toggle the widgets on it)"},"onAddChild":{"!type":"fn(pane: +dijit._Widget, insertIndex?: +Integer)","!doc":"Called when the stack container adds a new pane"},"onRemoveChild":{"!type":"fn(pane: +dijit._Widget)","!doc":"Called when the stack container removes a pane"},"onSelectChild":{"!type":"fn(pane: +dijit._Widget)","!doc":"Called when the stack container selects a new pane"},"onStartup":{"!type":"fn(info: ?)","!doc":"Called when the stack container is started up"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"_handleSelfOnChange":{"!type":"fn(val: string)","!doc":"Called when form select widget's value has changed"}}},"manager":{"actionAdapter":{"!type":"fn(action: fn())","!doc":"Adapter that automates application of actions to arrays."},"inspectorAdapter":{"!type":"fn(inspector: fn())","!doc":"Adapter that applies an inspector only to the first item of the array."},"_keys":{"!type":"fn(o: ?)"},"changeEvent":{"!type":"fn(node: +Node) -> string","!doc":"Function that returns a valid &quot;onchange&quot; event for a given form node."},"_ClassMixin":{"!type":"fn()","prototype":{"!doc":"Form manager's mixin for testing/assigning/removing\nclasses of controlled elements.","gatherClassState":{"!type":"fn(className: string, names?: +Object) -> ?","!doc":"Gather the presence of a certain class in all controlled elements."},"addClass":{"!type":"fn(className: string, names?: +Object) -> +self","!doc":"Add a class to nodes according to the supplied set of names"},"removeClass":{"!type":"fn(className: string, names?: +Object) -> +self","!doc":"Remove a class from nodes according to the supplied set of names"}}},"_DisplayMixin":{"!type":"fn()","prototype":{"!doc":"Form manager's mixin for controlling show/hide state of\ncontrolled elements (defined by dojoAttachPoint attributes).","gatherDisplayState":{"!type":"fn(names?: +Object) -> ?","!doc":"Gather display state of all attached elements and return as a dictionary."},"show":{"!type":"fn(state?: +Object, defaultState?: bool) -> +self","!doc":"Show attached nodes according to the supplied state object."},"hide":{"!type":"fn(state?: +Object) -> +self","!doc":"Hide attached nodes according to the supplied state object."}}},"_EnableMixin":{"!type":"fn()","prototype":{"!doc":"Form manager's mixin for controlling enable/disable state of\nform elements.","gatherEnableState":{"!type":"fn(names?: +Object) -> ?","!doc":"Gather enable state of all form elements and return as a dictionary."},"enable":{"!type":"fn(state?: +Object, defaultState: bool) -> +self","!doc":"Enable form controls according to the supplied state object."},"disable":{"!type":"fn(state?: +Object) -> ?","!doc":"Disable form controls according to the supplied state object\nreturning the previous state."}}},"_FormMixin":{"!type":"fn()","prototype":{"!doc":"Form manager's mixin for form-specific functionality.","name":{"!type":"string"},"action":{"!type":"string"},"method":{"!type":"string"},"encType":{"!type":"string"},"accept-charset":{"!type":"string"},"accept":{"!type":"string"},"target":{"!type":"string"},"startup":{"!type":"fn()"},"_onReset":{"!type":"fn(evt: ?)"},"onReset":{"!type":"fn() -> bool","!doc":"Callback when user resets the form. This method is intended\nto be over-ridden. When the <code>reset</code> method is called\nprogrammatically, the return value from <code>onReset</code> is used\nto compute whether or not resetting should proceed"},"reset":{"!type":"fn()","!doc":"Resets form widget values."},"_onSubmit":{"!type":"fn(evt: ?)"},"onSubmit":{"!type":"fn() -> bool","!doc":"Callback when user submits the form. This method is\nintended to be over-ridden, but by default it checks and\nreturns the validity of form elements. When the <code>submit</code>\nmethod is called programmatically, the return value from\n<code>onSubmit</code> is used to compute whether or not submission\nshould proceed"},"submit":{"!type":"fn()","!doc":"programmatically submit form if and only if the <code>onSubmit</code> returns true"},"isValid":{"!type":"fn()","!doc":"Make sure that every widget that has a validator function returns true."}}},"_Mixin":{"!type":"fn()","prototype":{"!doc":"Mixin to orchestrate dynamic forms.","watch":{"!type":"bool"},"startup":{"!type":"fn()","!doc":"Called after all the widgets have been instantiated and their\ndom nodes have been inserted somewhere under dojo.doc.body."},"destroy":{"!type":"fn()","!doc":"Called when the widget is being destroyed"},"registerWidget":{"!type":"fn(widget: string)","!doc":"Register a widget with the form manager"},"unregisterWidget":{"!type":"fn(name: string)","!doc":"Removes the widget by name from internal tables unregistering\nconnected observers"},"registerWidgetDescendants":{"!type":"fn(widget: string)","!doc":"Register widget's descendants with the form manager"},"unregisterWidgetDescendants":{"!type":"fn(widget: string)","!doc":"Unregister widget's descendants with the form manager"},"formWidgetValue":{"!type":"fn(elem: string, value?: +Object) -> ?","!doc":"Set or get a form widget by name."},"formPointValue":{"!type":"fn(elem: string, value?: +Object) -> ?","!doc":"Set or get a node context by name (using dojoAttachPoint)."},"inspectFormWidgets":{"!type":"fn(inspector: fn(), state?: +Object, defaultValue?: +Object) -> ?","!doc":"Run an inspector function on controlled widgets returning a result object."},"inspectAttachedPoints":{"!type":"fn(inspector: fn(), state?: +Object, defaultValue?: +Object) -> ?","!doc":"Run an inspector function on &quot;dojoAttachPoint&quot; nodes returning a result object."},"inspect":{"!type":"fn(inspector: fn(), state?: +Object, defaultValue?: +Object) -> ?","!doc":"Run an inspector function on controlled elements returning a result object."}}},"_NodeMixin":{"!type":"fn()","prototype":{"!doc":"Mixin to orchestrate dynamic forms (works with DOM nodes).","destroy":{"!type":"fn()","!doc":"Called when the widget is being destroyed"},"registerNode":{"!type":"fn(node: string)","!doc":"Register a node with the form manager"},"unregisterNode":{"!type":"fn(name: string)","!doc":"Removes the node by name from internal tables unregistering\nconnected observers"},"registerNodeDescendants":{"!type":"fn(node: string)","!doc":"Register node's descendants (form nodes) with the form manager"},"unregisterNodeDescendants":{"!type":"fn(node: string)","!doc":"Unregister node's descendants (form nodes) with the form manager"},"formNodeValue":{"!type":"fn(elem: string, value?: +Object) -> ?","!doc":"Set or get a form element by name."},"inspectFormNodes":{"!type":"fn(inspector: fn(), state?: +Object, defaultValue?: +Object) -> ?","!doc":"Run an inspector function on controlled form elements returning a result object."}}},"_ValueMixin":{"!type":"fn()","prototype":{"!doc":"Form manager's mixin for getting/setting form values in the unified manner.","elementValue":{"!type":"fn(name: string, value?: +Object) -> ?","!doc":"Set or get a form widget/element or an attached point node by name."},"gatherFormValues":{"!type":"fn(names?: +Object) -> ?","!doc":"Collect form values."},"setFormValues":{"!type":"fn(values: +Object)","!doc":"Set values to form elements"}}}}},"fx":{"anim":{},"animateProperty":{},"fadeTo":{},"fadeIn":{},"fadeOut":{},"combine":{},"chain":{},"slideTo":{},"wipeIn":{},"wipeOut":{},"_base":{},"_core":{},"easing":{"!doc":"An Alias to <code>dojo.fx.easing</code>. Moved to Core in Dojo 1.2."},"scroll":{},"split":{},"_allowedProperties":{"!type":"[]"},"style":{},"sizeTo":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Creates an animation that will size a node"},"slideBy":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation to slide a node by a defined offset."},"crossFade":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation cross fading two element simultaneously"},"highlight":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Highlight a node"},"wipeTo":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Animate a node wiping to a specific width or height"},"_Line":{"!type":"fn(start: +Integer, end: +Integer) -> []","!doc":"a custom _Line to accomodate multi-dimensional values"},"flip":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Animate a node flipping following a specific direction"},"flipCube":{"!type":"fn(args: ?)","!doc":"An extension to <code>dojox.fx.flip</code> providing a more 3d-like rotation"},"flipPage":{"!type":"fn(args: ?)","!doc":"An extension to <code>dojox.fx.flip</code> providing a page flip like animation."},"flipGrid":{"!type":"fn(args: ?)","!doc":"An extension to <code>dojox.fx.flip</code> providing a decomposition in rows * cols flipping elements"},"smoothScroll":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Returns an animation that will smooth-scroll to a node (specified in etup())"},"_split":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Split a node into rectangular pieces and animate them."},"explode":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Explode a node into rectangular pieces"},"converge":{"!type":"fn(args: ?)"},"disintegrate":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Split a node into rectangular pieces and let them fall"},"build":{"!type":"fn(args: ?)"},"shear":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Split a node into rectangular pieces and slide them in alternating directions"},"unShear":{"!type":"fn(args: ?)"},"pinwheel":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Split a node into rectangular pieces and wipe them in alternating directions"},"unPinwheel":{"!type":"fn(args: ?) -> +dojo.Animation"},"blockFadeOut":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Split a node into rectangular pieces and fade them"},"blockFadeIn":{"!type":"fn(args: ?) -> +dojo.Animation"},"addClass":{"!type":"fn(node: string, cssClass: string, args?: ?) -> +dojo.Animation","!doc":"Animate the effects of adding a class to a node"},"removeClass":{"!type":"fn(node: ?, cssClass: ?, args: ?) -> +dojo.Animation","!doc":"Animate the effects of removing a class from a node"},"toggleClass":{"!type":"fn(node: string, cssClass: string, condition?: bool, args?: ?) -> +dojo.Animation","!doc":"Animate the effects of Toggling a class on a Node"},"Shadow":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Adds a drop-shadow to a node.","shadowPng":{"!doc":"Base location for drop-shadow images","!type":"string"},"shadowThickness":{"!doc":"How wide (in px) to make the shadow","!type":"+Integer"},"shadowOffset":{"!doc":"How deep to make the shadow appear to be","!type":"+Integer"},"opacity":{"!doc":"Overall opacity of the shadow","!type":"+Float"},"animate":{"!doc":"A toggle to disable animated transitions","!type":"bool"},"node":{"!doc":"The node we will be applying this shadow to","!type":"+Node"},"startup":{"!type":"fn()","!doc":"Initializes the shadow."},"_makePiece":{"!type":"fn(name: ?, vertAttach: ?, vertCoord: ?, horzAttach: ?, horzCoord: ?, sizing: ?)","!doc":"append a shadow pieces to the node, and position it"},"setOpacity":{"!type":"fn(n: +Float, animArgs?: ?)","!doc":"set the opacity of the underlay\nnote: does not work in IE? FIXME."},"setDisabled":{"!type":"fn(disabled: bool)","!doc":"enable / disable the shadow"},"resize":{"!type":"fn(args: +dojox.fx._arg.ShadowResizeArgs)","!doc":"Resizes the shadow based on width and height."}}},"_arg":{"StyleArgs":{"!type":"fn(args: ?)","!doc":"The node and CSS class to use for style manipulations.\nnode: DOMNode\nThe node to manipulate\ncssClass: String\nThe class to use during the manipulation"},"ShadowResizeArgs":{"!type":"fn(args: ?)","!doc":"The odd way to document object parameters.\nx: Integer\nthe width to set\ny: Integer\nthe height to set"}},"ext-dojo":{"NodeList-style":{},"NodeList":{}},"text":{"_split":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Split a block of text into words or letters"},"explode":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Explode a block of text into words or letters"},"converge":{"!type":"fn(args: ?)"},"disintegrate":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Split a block of text into words or letters and let them fall"},"build":{"!type":"fn(args: ?)"},"blockFadeOut":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Split a block of text into words or letters and fade them"},"blockFadeIn":{"!type":"fn(args: ?)"},"backspace":{"!type":"fn(args: ?) -> +dojo.Animation","!doc":"Split a block of text into words or letters and backspace them in sequence"},"type":{"!type":"fn(args: ?)"}}},"grid":{"Grid":{},"VirtualGrid":{},"_Builder":{},"_ContentBuilder":{},"_HeaderBuilder":{},"_TableMap":{},"rowIndexTag":{"!type":"string"},"gridViewTag":{"!type":"string"},"drag":{},"na":{"!type":"string"},"mouseEvents":{"!type":"[]"},"keyEvents":{"!type":"[]"},"__CellDef":{"!type":"fn()"},"__ViewDef":{"!type":"fn()"},"nop":{"!type":"fn()","!doc":"a null function?"},"getTdIndex":{"!type":"fn(td: ?)"},"getTrIndex":{"!type":"fn(tr: ?)"},"getTr":{"!type":"fn(rowOwner: ?, index: ?)"},"getTd":{"!type":"fn(rowOwner: ?, rowIndex: ?, cellIndex: ?)"},"findTable":{"!type":"fn(node: ?)"},"ascendDom":{"!type":"fn(inNode: ?, inWhile: ?)"},"makeNotTagName":{"!type":"fn(inTagName: ?)"},"fire":{"!type":"fn(ob: ?, ev: ?, args: ?)"},"setStyleText":{"!type":"fn(inNode: ?, inStyleText: ?)"},"getStyleText":{"!type":"fn(inNode: ?, inStyleText: ?)"},"setStyle":{"!type":"fn(inElement: ?, inStyle: ?, inValue: ?)"},"setStyleHeightPx":{"!type":"fn(inElement: ?, inHeight: ?)"},"funnelEvents":{"!type":"fn(inNode: ?, inObject: ?, inMethod: ?, inEvents: ?)"},"removeNode":{"!type":"fn(inNode: ?)"},"getScrollbarWidth":{"!type":"fn()"},"getRef":{"!type":"fn(name: ?, create: ?, context: ?)"},"getProp":{"!type":"fn(name: ?, create: ?, context: ?)"},"indexInParent":{"!type":"fn(inNode: ?)"},"cleanNode":{"!type":"fn(inNode: ?)"},"getTagName":{"!type":"fn(inNodeOrId: ?)"},"nodeKids":{"!type":"fn(inNode: ?, inTag: ?)"},"divkids":{"!type":"fn(inNode: ?)"},"focusSelectNode":{"!type":"fn(inNode: ?)"},"whenIdle":{"!type":"fn()"},"arrayCompare":{"!type":"fn(inA: ?, inB: ?)"},"arrayInsert":{"!type":"fn(inArray: ?, inIndex: ?, inValue: ?)"},"arrayRemove":{"!type":"fn(inArray: ?, inIndex: ?)"},"arraySwap":{"!type":"fn(inArray: ?, inI: ?, inJ: ?)"},"initTextSizePoll":{"!type":"fn(inInterval: ?)"},"textSizeChanged":{"!type":"fn()"},"__DataCellDef":{"!type":"fn()","prototype":{"!proto":"dojox.grid.__CellDef.prototype","constructor":{"!type":"fn()"}}},"__DataViewDef":{"!type":"fn()","prototype":{"!proto":"dojox.grid.__ViewDef.prototype","constructor":{"!type":"fn()"}}},"DataGrid":{"!type":"fn()","prototype":{"!proto":"dojox.grid._Grid.prototype","store":{},"query":{},"queryOptions":{},"fetchText":{"!type":"string"},"sortFields":{},"structure":{"!doc":"View layout defintion.","!type":"+dojox.grid.__DataViewDef"},"items":{},"_store_connects":{},"_by_idty":{},"_by_idx":{},"_cache":{},"_pages":{},"_pending_requests":{},"_bop":{"!type":"number"},"_eop":{"!type":"number"},"_requests":{"!type":"number"},"rowCount":{"!type":"number"},"_isLoaded":{"!type":"bool"},"_isLoading":{"!type":"bool"},"postCreate":{"!type":"fn()"},"createSelection":{"!type":"fn()"},"get":{"!type":"fn(inRowIndex: ?, inItem: ?)"},"_onSet":{"!type":"fn(item: ?, attribute: ?, oldValue: ?, newValue: ?)"},"_addItem":{"!type":"fn(item: ?, index: ?, noUpdate: ?)"},"_onNew":{"!type":"fn(item: ?, parentInfo: ?)"},"_onDelete":{"!type":"fn(item: ?)"},"_onRevert":{"!type":"fn()"},"setStore":{"!type":"fn(store: ?, query: ?, queryOptions: ?)"},"setQuery":{"!type":"fn(query: ?, queryOptions: ?)"},"setItems":{"!type":"fn(items: ?)"},"_setQuery":{"!type":"fn(query: ?, queryOptions: ?)"},"_setStore":{"!type":"fn(store: ?)"},"_onFetchBegin":{"!type":"fn(size: ?, req: ?)"},"_onFetchComplete":{"!type":"fn(items: ?, req: ?)"},"_onFetchError":{"!type":"fn(err: ?, req: ?)"},"onFetchError":{"!type":"fn(err: ?, req: ?)"},"_fetch":{"!type":"fn(start: ?, isRender: ?)"},"_clearData":{"!type":"fn()"},"getItem":{"!type":"fn(idx: ?)"},"getItemIndex":{"!type":"fn(item: ?)"},"_getItemIndex":{"!type":"fn(item: ?, isDeleted: ?)"},"filter":{"!type":"fn(query: ?, reRender: ?)"},"_getItemAttr":{"!type":"fn(idx: ?, attr: ?)"},"_render":{"!type":"fn()"},"_requestsPending":{"!type":"fn(inRowIndex: ?)"},"_rowToPage":{"!type":"fn(inRowIndex: ?)"},"_pageToRow":{"!type":"fn(inPageIndex: ?)"},"_preparePage":{"!type":"fn(inRowIndex: ?)"},"_needPage":{"!type":"fn(inPageIndex: ?)"},"_requestPage":{"!type":"fn(inPageIndex: ?)"},"getCellName":{"!type":"fn(inCell: ?)"},"_refresh":{"!type":"fn(isRender: ?)"},"sort":{"!type":"fn()"},"canSort":{"!type":"fn()"},"getSortProps":{"!type":"fn()"},"styleRowState":{"!type":"fn(inRow: ?)","!doc":"Perform row styling"},"onStyleRow":{"!type":"fn(inRow: ?)"},"canEdit":{"!type":"fn(inCell: ?, inRowIndex: ?)"},"_copyAttr":{"!type":"fn(idx: ?, attr: ?)"},"doStartEdit":{"!type":"fn(inCell: ?, inRowIndex: ?)"},"doApplyCellEdit":{"!type":"fn(inValue: ?, inRowIndex: ?, inAttrName: ?)"},"doCancelEdit":{"!type":"fn(inRowIndex: ?)"},"doApplyEdit":{"!type":"fn(inRowIndex: ?, inDataAttr: ?)"},"removeSelectedRows":{"!type":"fn()","!doc":"Remove the selected rows from the grid."}},"markupFactory":{"!type":"fn(props: ?, node: ?, ctor: ?, cellFunc: ?)"}},"DataSelection":{"!type":"fn()","prototype":{"!proto":"dojox.grid.Selection.prototype","getFirstSelected":{"!type":"fn()"},"getNextSelected":{"!type":"fn(inPrev: ?)"},"getSelected":{"!type":"fn()"},"addToSelection":{"!type":"fn(inItemOrIndex: ?)"},"deselect":{"!type":"fn(inItemOrIndex: ?)"},"deselectAll":{"!type":"fn(inItemOrIndex: ?)"}}},"Selection":{"!type":"fn()","prototype":{"!doc":"Manages row selection for grid. Owned by grid and used internally\nfor selection. Override to implement custom selection.","mode":{"!type":"string"},"selected":{},"updating":{"!type":"number"},"selectedIndex":{"!type":"number"},"constructor":{"!type":"fn(inGrid: ?)"},"setMode":{"!type":"fn(mode: ?)"},"onCanSelect":{"!type":"fn(inIndex: ?)"},"onCanDeselect":{"!type":"fn(inIndex: ?)"},"onSelected":{"!type":"fn(inIndex: ?)"},"onDeselected":{"!type":"fn(inIndex: ?)"},"onChanging":{"!type":"fn()"},"onChanged":{"!type":"fn()"},"isSelected":{"!type":"fn(inIndex: ?)"},"getFirstSelected":{"!type":"fn()"},"getNextSelected":{"!type":"fn(inPrev: ?)"},"getSelected":{"!type":"fn()"},"getSelectedCount":{"!type":"fn()"},"_beginUpdate":{"!type":"fn()"},"_endUpdate":{"!type":"fn()"},"select":{"!type":"fn(inIndex: ?)"},"addToSelection":{"!type":"fn(inIndex: ?)"},"deselect":{"!type":"fn(inIndex: ?)"},"setSelected":{"!type":"fn(inIndex: ?, inSelect: ?)"},"toggleSelect":{"!type":"fn(inIndex: ?)"},"_range":{"!type":"fn(inFrom: ?, inTo: ?, func: ?)"},"selectRange":{"!type":"fn(inFrom: ?, inTo: ?)"},"deselectRange":{"!type":"fn(inFrom: ?, inTo: ?)"},"insert":{"!type":"fn(inIndex: ?)"},"remove":{"!type":"fn(inIndex: ?)"},"deselectAll":{"!type":"fn(inExcept: ?)"},"clickSelect":{"!type":"fn(inIndex: ?, inCtrlKey: ?, inShiftKey: ?)"},"clickSelectEvent":{"!type":"fn(e: ?)"},"clear":{"!type":"fn()"}}},"util":{"rowIndexTag":{"!type":"string"},"gridViewTag":{"!type":"string"},"na":{"!type":"string"},"mouseEvents":{"!type":"[]"},"keyEvents":{"!type":"[]"},"fire":{"!type":"fn(ob: ?, ev: ?, args: ?)"},"setStyleHeightPx":{"!type":"fn(inElement: ?, inHeight: ?)"},"funnelEvents":{"!type":"fn(inNode: ?, inObject: ?, inMethod: ?, inEvents: ?)"},"removeNode":{"!type":"fn(inNode: ?)"},"arrayCompare":{"!type":"fn(inA: ?, inB: ?)"},"arrayInsert":{"!type":"fn(inArray: ?, inIndex: ?, inValue: ?)"},"arrayRemove":{"!type":"fn(inArray: ?, inIndex: ?)"},"arraySwap":{"!type":"fn(inArray: ?, inI: ?, inJ: ?)"}},"_EditManager":{"!type":"fn()","prototype":{"!doc":"Controls grid cell editing process. Owned by grid and used internally for editing.","info":{},"_boomerangWindow":{"!type":"number"},"constructor":{"!type":"fn(inGrid: +dojox.Grid)"},"destroy":{"!type":"fn()"},"cellFocus":{"!type":"fn(inCell: +cell, inRowIndex: +Integer)","!doc":"Invoke editing when cell is focused"},"rowClick":{"!type":"fn(e: ?)"},"styleRow":{"!type":"fn(inRow: ?)"},"dispatchEvent":{"!type":"fn(e: ?)"},"isEditing":{"!type":"fn()","!doc":"Indicates editing state of the grid."},"isEditCell":{"!type":"fn(inRowIndex: +Integer, inCellIndex: +Integer)","!doc":"Indicates if the given cell is being edited."},"isEditRow":{"!type":"fn(inRowIndex: +Integer)","!doc":"Indicates if the given row is being edited."},"setEditCell":{"!type":"fn(inCell: ?, inRowIndex: +Integer)","!doc":"Set the given cell to be edited"},"_focusEditor":{"!type":"fn(inCell: ?, inRowIndex: ?)"},"focusEditor":{"!type":"fn()"},"_shouldCatchBoomerang":{"!type":"fn()"},"_boomerangFocus":{"!type":"fn()"},"_doCatchBoomerang":{"!type":"fn()"},"start":{"!type":"fn(inCell: ?, inRowIndex: ?, inEditing: ?)"},"_editorDo":{"!type":"fn(inMethod: ?)"},"editorApply":{"!type":"fn()"},"editorCancel":{"!type":"fn()"},"applyCellEdit":{"!type":"fn(inValue: ?, inCell: ?, inRowIndex: ?)"},"applyRowEdit":{"!type":"fn()"},"apply":{"!type":"fn()","!doc":"Apply a grid edit"},"cancel":{"!type":"fn()","!doc":"Cancel a grid edit"},"save":{"!type":"fn(inRowIndex: +Integer, inView: ?)","!doc":"Save the grid editing state"},"restore":{"!type":"fn(inView: ?, inRowIndex: +Integer)","!doc":"Restores the grid editing state"}}},"_Events":{"!type":"fn()","prototype":{"!doc":"_Grid mixin that provides default implementations for grid events.","cellOverClass":{"!doc":"css class to apply to grid cells over which the cursor is placed.","!type":"string"},"onKeyEvent":{"!type":"fn(e: ?)","!doc":"top level handler for Key Events"},"onContentEvent":{"!type":"fn(e: ?)","!doc":"Top level handler for Content events"},"onHeaderEvent":{"!type":"fn(e: ?)","!doc":"Top level handler for header events"},"onStyleRow":{"!type":"fn(inRow: ?)","!doc":"Perform row styling on a given row. Called whenever row styling is updated."},"onKeyDown":{"!type":"fn(e: ?)","!doc":"Grid key event handler. By default enter begins editing and applies edits, escape cancels an edit,\ntab, shift-tab, and arrow keys move grid cell focus."},"onMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is over the grid."},"onMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of the grid."},"onMouseDown":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down inside grid."},"onMouseOverRow":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is over any row (data or header)."},"onMouseOutRow":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of any row (data or header)."},"onMouseDownRow":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down inside grid row"},"onCellMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is over a cell."},"onCellMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of a cell."},"onCellMouseDown":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down in a header cell."},"onCellClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a cell is clicked."},"onCellDblClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a cell is double-clicked."},"onCellContextMenu":{"!type":"fn(e: +Event)","!doc":"Event fired when a cell context menu is accessed via mouse right click."},"onCellFocus":{"!type":"fn(inCell: ?, inRowIndex: +Integer)","!doc":"Event fired when a cell receives focus."},"onRowClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a row is clicked."},"onRowDblClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a row is double clicked."},"onRowMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves over a data row."},"onRowMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of a data row."},"onRowMouseDown":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down in a row."},"onRowContextMenu":{"!type":"fn(e: +Event)","!doc":"Event fired when a row context menu is accessed via mouse right click."},"onHeaderMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves over the grid header."},"onHeaderMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of the grid header."},"onHeaderCellMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves over a header cell."},"onHeaderCellMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of a header cell."},"onHeaderCellMouseDown":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down in a header cell."},"onHeaderClick":{"!type":"fn(e: +Event)","!doc":"Event fired when the grid header is clicked."},"onHeaderCellClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a header cell is clicked."},"onHeaderDblClick":{"!type":"fn(e: +Event)","!doc":"Event fired when the grid header is double clicked."},"onHeaderCellDblClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a header cell is double clicked."},"onHeaderCellContextMenu":{"!type":"fn(e: +Event)","!doc":"Event fired when a header cell context menu is accessed via mouse right click."},"onHeaderContextMenu":{"!type":"fn(e: +Event)","!doc":"Event fired when the grid header context menu is accessed via mouse right click."},"onStartEdit":{"!type":"fn(inCell: ?, inRowIndex: +Integer)","!doc":"Event fired when editing is started for a given grid cell"},"onApplyCellEdit":{"!type":"fn(inValue: string, inRowIndex: +Integer, inFieldIndex: +Integer)","!doc":"Event fired when editing is applied for a given grid cell"},"onCancelEdit":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event fired when editing is cancelled for a given grid cell"},"onApplyEdit":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event fired when editing is applied for a given grid row"},"onCanSelect":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event to determine if a grid row may be selected"},"onCanDeselect":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event to determine if a grid row may be deselected"},"onSelected":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event fired when a grid row is selected"},"onDeselected":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event fired when a grid row is deselected"},"onSelectionChanged":{"!type":"fn()"}}},"_FocusManager":{"!type":"fn()","prototype":{"!doc":"Controls grid cell focus. Owned by grid and used internally for focusing.\nNote: grid cell actually receives keyboard input only when cell is being edited.","_colHeadNode":{},"_colHeadFocusIdx":{},"tabbingOut":{"!type":"bool"},"focusClass":{"!type":"string"},"focusView":{},"constructor":{"!type":"fn(inGrid: ?)"},"destroy":{"!type":"fn()"},"initFocusView":{"!type":"fn()"},"isFocusCell":{"!type":"fn(inCell: ?, inRowIndex: number)","!doc":"states if the given cell is focused"},"isLastFocusCell":{"!type":"fn()"},"isFirstFocusCell":{"!type":"fn()"},"isNoFocusCell":{"!type":"fn()"},"isNavHeader":{"!type":"fn()","!doc":"states whether currently navigating among column headers."},"getHeaderIndex":{"!type":"fn()","!doc":"if one of the column headers currently has focus, return its index."},"_focusifyCellNode":{"!type":"fn(inBork: ?)"},"_delayedCellFocus":{"!type":"fn()"},"_delayedHeaderFocus":{"!type":"fn()"},"_initColumnHeaders":{"!type":"fn()"},"_findHeaderCells":{"!type":"fn()"},"scrollIntoView":{"!type":"fn()"},"_scrollInfo":{"!type":"fn(cell: ?, domNode: ?)"},"_scrollHeader":{"!type":"fn(currentIdx: ?)"},"_isHeaderHidden":{"!type":"fn()","!doc":"determine if the grid headers are hidden\nrelies on documented technique of setting .dojoxGridHeader { display:none; }"},"colSizeAdjust":{"!type":"fn(e: ?, colIdx: ?, delta: ?)"},"styleRow":{"!type":"fn(inRow: ?)"},"setFocusIndex":{"!type":"fn(inRowIndex: number, inCellIndex: number)","!doc":"focuses the given grid cell"},"setFocusCell":{"!type":"fn(inCell: ?, inRowIndex: number)","!doc":"focuses the given grid cell"},"next":{"!type":"fn()","!doc":"focus next grid cell"},"previous":{"!type":"fn()","!doc":"focus previous grid cell"},"move":{"!type":"fn(inRowDelta: number, inColDelta: number)","!doc":"focus grid cell or column header based on position relative to current focus"},"previousKey":{"!type":"fn(e: ?)"},"nextKey":{"!type":"fn(e: ?)"},"tabOut":{"!type":"fn(inFocusNode: ?)"},"focusGridView":{"!type":"fn()"},"focusGrid":{"!type":"fn(inSkipFocusCell: ?)"},"findAndFocusGridCell":{"!type":"fn()","!doc":"find the first focusable grid cell"},"focusHeader":{"!type":"fn()"},"doFocus":{"!type":"fn(e: ?)"},"doBlur":{"!type":"fn(e: ?)"},"doBlurHeader":{"!type":"fn(e: ?)"},"doLastNodeFocus":{"!type":"fn(e: ?)"},"doLastNodeBlur":{"!type":"fn(e: ?)"},"doColHeaderFocus":{"!type":"fn(e: ?)"},"doColHeaderBlur":{"!type":"fn(e: ?)"}}},"_Grid":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A grid widget with virtual scrolling, cell editing, complex rows,\nsorting, fixed columns, sizeable columns, etc.","templatePath":{},"classTag":{"!doc":"CSS class applied to the grid's domNode","!type":"string"},"rowCount":{"!doc":"Number of rows to display.","!type":"+Integer"},"keepRows":{"!doc":"Number of rows to keep in the rendering cache.","!type":"+Integer"},"rowsPerPage":{"!doc":"Number of rows to render at a time.","!type":"+Integer"},"autoWidth":{"!doc":"If autoWidth is true, grid width is automatically set to fit the data.","!type":"bool"},"autoHeight":{"!doc":"If autoHeight is true, grid height is automatically set to fit the data.\nIf it is an integer, the height will be automatically set to fit the data\nif there are fewer than that many rows - and the height will be set to show\nthat many rows if there are more","!type":"bool"},"autoRender":{"!doc":"If autoRender is true, grid will render itself after initialization.","!type":"bool"},"defaultHeight":{"!doc":"default height of the grid, measured in any valid css unit.","!type":"string"},"height":{"!doc":"explicit height of the grid, measured in any valid css unit.  This will be populated (and overridden)\nif the height: css attribute exists on the source node.","!type":"string"},"structure":{"!doc":"View layout defintion.","!type":"+dojox.grid.__ViewDef"},"elasticView":{"!doc":"Override defaults and make the indexed grid view elastic, thus filling available horizontal space.","!type":"+Integer"},"singleClickEdit":{"!doc":"Single-click starts editing. Default is double-click","!type":"bool"},"selectionMode":{"!doc":"Set the selection mode of grid's Selection.  Value must be 'single', 'multiple',\nor 'extended'.  Default is 'extended'.","!type":"string"},"rowSelector":{"!doc":"If set to true, will add a row selector view to this grid.  If set to a CSS width, will add\na row selector of that width to this grid.","!type":"bool"},"columnReordering":{"!doc":"If set to true, will add drag and drop reordering to views with one row of columns.","!type":"bool"},"headerMenu":{"!doc":"If set to a dijit.Menu, will use this as a context menu for the grid headers.","!type":"+dijit.Menu"},"placeholderLabel":{"!doc":"Label of placeholders to search for in the header menu to replace with column toggling\nmenu items.","!type":"string"},"selectable":{"!doc":"Set to true if you want to be able to select the text within the grid.","!type":"bool"},"_click":{},"loadingMessage":{"!doc":"Message that shows while the grid is loading","!type":"string"},"errorMessage":{"!doc":"Message that shows when the grid encounters an error loading","!type":"string"},"noDataMessage":{"!doc":"Message that shows if the grid has no data - wrap it in a\nspan with class 'dojoxGridNoData' if you want it to be\nstyled similar to the loading and error messages","!type":"string"},"sortInfo":{"!type":"number"},"themeable":{"!type":"bool"},"_placeholders":{},"invalidated":{},"updating":{"!type":"bool"},"fastScroll":{"!doc":"flag modifies vertical scrolling behavior. Defaults to true but set to false for slower\nscroll performance but more immediate scrolling feedback","!type":"bool"},"delayScroll":{"!type":"bool"},"scrollRedrawThreshold":{"!doc":"pixel distance a user must scroll vertically to trigger grid scrolling.","!type":"number"},"get":{"!type":"fn(inRowIndex: +Integer)","!doc":"Default data getter."},"buildRendering":{"!type":"fn()"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"_setAutoHeightAttr":{"!type":"fn(ah: ?, skipRender: ?)"},"_getRowCountAttr":{"!type":"fn()"},"textSizeChanged":{"!type":"fn()"},"sizeChange":{"!type":"fn()"},"createManagers":{"!type":"fn()","!doc":"create grid managers for various tasks including rows, focus, selection, editing"},"createSelection":{"!type":"fn()","!doc":"Creates a new Grid selection manager."},"createScroller":{"!type":"fn()","!doc":"Creates a new virtual scroller"},"createLayout":{"!type":"fn()","!doc":"Creates a new Grid layout"},"onMoveColumn":{"!type":"fn()"},"createViews":{"!type":"fn()"},"createView":{"!type":"fn(inClass: ?, idx: ?)"},"buildViews":{"!type":"fn()"},"_setStructureAttr":{"!type":"fn(structure: ?)"},"setStructure":{"!type":"fn(inStructure: +dojox.grid.__ViewDef)","!doc":"Install a new structure and rebuild the grid."},"getColumnTogglingItems":{"!type":"fn()"},"_setHeaderMenuAttr":{"!type":"fn(menu: ?)"},"setHeaderMenu":{"!type":"fn(menu: +dijit.Menu)"},"setupHeaderMenu":{"!type":"fn()"},"_fetch":{"!type":"fn(start: ?)"},"getItem":{"!type":"fn(inRowIndex: ?)"},"showMessage":{"!type":"fn(message: ?)"},"_structureChanged":{"!type":"fn()"},"hasLayout":{"!type":"fn()"},"resize":{"!type":"fn(changeSize: ?, resultSize: ?)","!doc":"Update the grid's rendering dimensions and resize it"},"_getPadBorder":{"!type":"fn()"},"_getHeaderHeight":{"!type":"fn()"},"_resize":{"!type":"fn(changeSize: ?, resultSize: ?)"},"adaptWidth":{"!type":"fn()"},"adaptHeight":{"!type":"fn(inHeaderHeight: ?)"},"startup":{"!type":"fn()"},"render":{"!type":"fn()","!doc":"Render the grid, headers, and views. Edit and scrolling states are reset. To retain edit and\nscrolling states, see Update."},"_render":{"!type":"fn()"},"prerender":{"!type":"fn()"},"postrender":{"!type":"fn()"},"postresize":{"!type":"fn()"},"renderRow":{"!type":"fn(inRowIndex: ?, inNodes: ?)","!doc":"private, used internally to render rows"},"rowRemoved":{"!type":"fn(inRowIndex: ?)","!doc":"private, used internally to remove rows"},"beginUpdate":{"!type":"fn()","!doc":"Use to make multiple changes to rows while queueing row updating.\nNOTE: not currently supporting nested begin/endUpdate calls"},"endUpdate":{"!type":"fn()","!doc":"Use after calling beginUpdate to render any changes made to rows."},"defaultUpdate":{"!type":"fn()"},"update":{"!type":"fn()","!doc":"Update the grid, retaining edit and scrolling states."},"updateRow":{"!type":"fn(inRowIndex: +Integer)","!doc":"Render a single row."},"updateRows":{"!type":"fn(startIndex: +Integer, howMany: +Integer)","!doc":"Render consecutive rows at once."},"updateRowCount":{"!type":"fn(inRowCount: number)","!doc":"Change the number of rows."},"updateRowStyles":{"!type":"fn(inRowIndex: ?)","!doc":"Update the styles for a row after it's state has changed."},"rowHeightChanged":{"!type":"fn(inRowIndex: +Integer)","!doc":"Update grid when the height of a row has changed. Row height is handled automatically as rows\nare rendered. Use this function only to update a row's height outside the normal rendering process."},"scrollTo":{"!type":"fn(inTop: +Integer)","!doc":"Vertically scroll the grid to a given pixel position"},"finishScrollJob":{"!type":"fn()"},"setScrollTop":{"!type":"fn(inTop: ?)"},"scrollToRow":{"!type":"fn(inRowIndex: +Integer)","!doc":"Scroll the grid to a specific row."},"styleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"_mouseOut":{"!type":"fn(e: ?)"},"getCell":{"!type":"fn(inIndex: +Integer)","!doc":"Retrieves the cell object for a given grid column."},"setCellWidth":{"!type":"fn(inIndex: ?, inUnitWidth: ?)"},"getCellName":{"!type":"fn(inCell: ?) -> string","!doc":"Returns the cell name of a passed cell"},"canSort":{"!type":"fn(inSortInfo: +Integer)","!doc":"Determines if the grid can be sorted"},"sort":{"!type":"fn()"},"getSortAsc":{"!type":"fn(inSortInfo: ?) -> bool","!doc":"Returns true if grid is sorted in an ascending direction."},"getSortIndex":{"!type":"fn(inSortInfo: ?) -> +Integer","!doc":"Returns the index of the column on which the grid is sorted"},"setSortIndex":{"!type":"fn(inIndex: +Integer, inAsc: bool)","!doc":"Sort the grid on a column in a specified direction"},"setSortInfo":{"!type":"fn(inSortInfo: ?)"},"doKeyEvent":{"!type":"fn(e: ?)"},"_dispatch":{"!type":"fn(m: ?, e: ?)"},"dispatchKeyEvent":{"!type":"fn(e: ?)"},"dispatchContentEvent":{"!type":"fn(e: ?)"},"dispatchHeaderEvent":{"!type":"fn(e: ?)"},"dokeydown":{"!type":"fn(e: ?)"},"doclick":{"!type":"fn(e: ?)"},"dodblclick":{"!type":"fn(e: ?)"},"docontextmenu":{"!type":"fn(e: ?)"},"doheaderclick":{"!type":"fn(e: ?)"},"doheaderdblclick":{"!type":"fn(e: ?)"},"doheadercontextmenu":{"!type":"fn(e: ?)"},"doStartEdit":{"!type":"fn(inCell: ?, inRowIndex: ?)"},"doApplyCellEdit":{"!type":"fn(inValue: ?, inRowIndex: ?, inFieldIndex: ?)"},"doCancelEdit":{"!type":"fn(inRowIndex: ?)"},"doApplyEdit":{"!type":"fn(inRowIndex: ?)"},"addRow":{"!type":"fn()","!doc":"Add a row to the grid."},"removeSelectedRows":{"!type":"fn()","!doc":"Remove the selected rows from the grid."}},"_layoutClass":{"!doc":"The class to use for our layout - can be overridden by grid subclasses"},"markupFactory":{"!type":"fn(props: ?, node: ?, ctor: ?, cellFunc: ?)"}},"_Layout":{"!type":"fn()","prototype":{"!doc":"Controls grid cell layout. Owned by grid and used internally.\n\n\nflat array of grid cells\n\n\nstructured array of grid cells\n\n\ndefault cell width","cells":{"!type":"[]"},"structure":{},"defaultWidth":{"!type":"string"},"constructor":{"!type":"fn(inGrid: ?)"},"moveColumn":{"!type":"fn(sourceViewIndex: ?, destViewIndex: ?, cellIndex: ?, targetIndex: ?, before: ?)"},"setColumnVisibility":{"!type":"fn(columnIndex: ?, visible: ?)"},"addCellDef":{"!type":"fn(inRowIndex: ?, inCellIndex: ?, inDef: ?)"},"addRowDef":{"!type":"fn(inRowIndex: ?, inDef: ?)"},"addRowsDef":{"!type":"fn(inDef: ?)"},"addViewDef":{"!type":"fn(inDef: ?)"},"setStructure":{"!type":"fn(inStructure: ?)"}}},"_RowManager":{"!type":"fn()","prototype":{"linesToEms":{"!type":"number"},"overRow":{"!type":"number"},"constructor":{"!type":"fn(inGrid: ?)"},"prepareStylingRow":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"styleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"applyStyles":{"!type":"fn(inRow: ?)"},"updateStyles":{"!type":"fn(inRowIndex: ?)"},"setOverRow":{"!type":"fn(inRowIndex: ?)"},"isOver":{"!type":"fn(inRowIndex: ?)"}}},"_RowSelector":{"!type":"fn()","prototype":{"!proto":"dojox.grid._View.prototype","!doc":"Custom grid view. If used in a grid structure, provides a small selectable region for grid rows.\n\n\nstyling\n\n\nevent handlers","defaultWidth":{"!type":"string"},"noscroll":{"!type":"bool"},"padBorderWidth":{"!type":"number"},"buildRendering":{"!type":"fn()"},"getWidth":{"!type":"fn()"},"buildRowContent":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"renderHeader":{"!type":"fn()"},"resize":{"!type":"fn()"},"adaptWidth":{"!type":"fn()"},"doStyleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"domouseover":{"!type":"fn(e: ?)"},"domouseout":{"!type":"fn(e: ?)"}}},"_Scroller":{"!type":"fn()","prototype":{"rowCount":{"!type":"number"},"defaultRowHeight":{"!type":"number"},"keepRows":{"!type":"number"},"contentNode":{},"scrollboxNode":{},"defaultPageHeight":{"!type":"number"},"keepPages":{"!type":"number"},"pageCount":{"!type":"number"},"windowHeight":{"!type":"number"},"firstVisibleRow":{"!type":"number"},"lastVisibleRow":{"!type":"number"},"averageRowHeight":{"!type":"number"},"page":{"!type":"number"},"pageTop":{"!type":"number"},"pacifying":{"!type":"bool"},"pacifyTicks":{"!type":"number"},"dummy":{"!type":"number"},"constructor":{"!type":"fn(inContentNodes: ?)"},"init":{"!type":"fn(inRowCount: ?, inKeepRows: ?, inRowsPerPage: ?)"},"_getPageCount":{"!type":"fn(rowCount: ?, rowsPerPage: ?)"},"destroy":{"!type":"fn()"},"setKeepInfo":{"!type":"fn(inKeepRows: ?)"},"setContentNodes":{"!type":"fn(inNodes: ?)"},"getDefaultNodes":{"!type":"fn()"},"invalidate":{"!type":"fn()"},"updateRowCount":{"!type":"fn(inRowCount: ?)"},"pageExists":{"!type":"fn(inPageIndex: ?)"},"measurePage":{"!type":"fn(inPageIndex: ?)"},"positionPage":{"!type":"fn(inPageIndex: ?, inPos: ?)"},"repositionPages":{"!type":"fn(inPageIndex: ?)"},"installPage":{"!type":"fn(inPageIndex: ?)"},"preparePage":{"!type":"fn(inPageIndex: ?, inReuseNode: ?)"},"renderPage":{"!type":"fn(inPageIndex: ?)"},"removePage":{"!type":"fn(inPageIndex: ?)"},"destroyPage":{"!type":"fn(inPageIndex: ?)"},"pacify":{"!type":"fn(inShouldPacify: ?)"},"setPacifying":{"!type":"fn(inPacifying: ?)"},"startPacify":{"!type":"fn()"},"doPacify":{"!type":"fn()"},"endPacify":{"!type":"fn()"},"resize":{"!type":"fn()"},"calcLastPageHeight":{"!type":"fn()"},"updateContentHeight":{"!type":"fn(inDh: ?)"},"updatePageHeight":{"!type":"fn(inPageIndex: ?)"},"rowHeightChanged":{"!type":"fn(inRowIndex: ?)"},"invalidateNodes":{"!type":"fn()"},"createPageNode":{"!type":"fn()"},"getPageHeight":{"!type":"fn(inPageIndex: ?)"},"pushPage":{"!type":"fn(inPageIndex: ?)"},"popPage":{"!type":"fn()"},"findPage":{"!type":"fn(inTop: ?)"},"buildPage":{"!type":"fn(inPageIndex: ?, inReuseNode: ?, inPos: ?)"},"needPage":{"!type":"fn(inPageIndex: ?, inPos: ?)"},"onscroll":{"!type":"fn()"},"scroll":{"!type":"fn(inTop: ?)"},"getScrollBottom":{"!type":"fn(inTop: ?)"},"processNodeEvent":{"!type":"fn(e: ?, inNode: ?)"},"processEvent":{"!type":"fn(e: ?)"},"renderRow":{"!type":"fn(inRowIndex: ?, inPageNode: ?)"},"removeRow":{"!type":"fn(inRowIndex: ?)"},"getDefaultPageNode":{"!type":"fn(inPageIndex: ?)"},"positionPageNode":{"!type":"fn(inNode: ?, inPos: ?)"},"getPageNodePosition":{"!type":"fn(inNode: ?)"},"invalidatePageNode":{"!type":"fn(inPageIndex: ?, inNodes: ?)"},"getPageRow":{"!type":"fn(inPage: ?)"},"getLastPageRow":{"!type":"fn(inPage: ?)"},"getFirstVisibleRow":{"!type":"fn(inPage: ?, inPageTop: ?, inScrollTop: ?)"},"getLastVisibleRow":{"!type":"fn(inPage: ?, inBottom: ?, inScrollBottom: ?)"},"findTopRow":{"!type":"fn(inScrollTop: ?)"},"findScrollTop":{"!type":"fn(inRow: ?)"}}},"_View":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A collection of grid columns. A grid is comprised of a set of views that stack horizontally.\nGrid creates views automatically based on grid's layout structure.\nUsers should typically not need to access individual views directly.","defaultWidth":{"!doc":"Default width of the view","!type":"string"},"viewWidth":{"!doc":"Width for the view, in valid css unit","!type":"string"},"templatePath":{},"themeable":{"!type":"bool"},"classTag":{"!type":"string"},"marginBottom":{"!type":"number"},"rowPad":{"!type":"number"},"_togglingColumn":{"!doc":"Width of the column being toggled (-1 for none)","!type":"number"},"lastTop":{"!type":"number"},"firstScroll":{"!type":"number"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"focus":{"!type":"fn()"},"setStructure":{"!type":"fn(inStructure: ?)"},"onBeforeRow":{"!type":"fn(inRowIndex: ?, cells: ?)"},"onAfterRow":{"!type":"fn(inRowIndex: ?, cells: ?, inRowNode: ?)"},"testFlexCells":{"!type":"fn()"},"updateStructure":{"!type":"fn()"},"getScrollbarWidth":{"!type":"fn() -> +Integer"},"getColumnsWidth":{"!type":"fn() -> +Integer"},"setColumnsWidth":{"!type":"fn(width: ?)"},"getWidth":{"!type":"fn() -> string"},"getContentWidth":{"!type":"fn() -> string"},"render":{"!type":"fn()"},"_hide":{"!type":"fn(node: ?)"},"_onDndDropBefore":{"!type":"fn(source: ?, nodes: ?, copy: ?)"},"_onDndDrop":{"!type":"fn(source: ?, nodes: ?, copy: ?)"},"renderHeader":{"!type":"fn()"},"_getHeaderContent":{"!type":"fn(inCell: ?)"},"resize":{"!type":"fn()"},"hasHScrollbar":{"!type":"fn(reset: ?) -> bool"},"hasVScrollbar":{"!type":"fn(reset: ?) -> bool"},"convertColPctToFixed":{"!type":"fn()"},"adaptHeight":{"!type":"fn(minusScroll: ?)"},"adaptWidth":{"!type":"fn()"},"setSize":{"!type":"fn(w: ?, h: ?)"},"renderRow":{"!type":"fn(inRowIndex: ?)"},"createRowNode":{"!type":"fn(inRowIndex: ?)"},"buildRow":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"buildRowContent":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"rowRemoved":{"!type":"fn(inRowIndex: ?)"},"getRowNode":{"!type":"fn(inRowIndex: ?)"},"getCellNode":{"!type":"fn(inRowIndex: ?, inCellIndex: ?)"},"getHeaderCellNode":{"!type":"fn(inCellIndex: ?)"},"styleRow":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"styleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"doStyleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"updateRow":{"!type":"fn(inRowIndex: ?)"},"updateRowStyles":{"!type":"fn(inRowIndex: ?)"},"doscroll":{"!type":"fn(inEvent: ?)"},"setScrollTop":{"!type":"fn(inTop: ?)"},"doContentEvent":{"!type":"fn(e: ?)"},"doHeaderEvent":{"!type":"fn(e: ?)"},"dispatchContentEvent":{"!type":"fn(e: ?)"},"dispatchHeaderEvent":{"!type":"fn(e: ?)"},"setColWidth":{"!type":"fn(inIndex: ?, inWidth: ?)"},"update":{"!type":"fn()"}},"_headerBuilderClass":{"!doc":"The class to use for our header builder"},"_contentBuilderClass":{"!doc":"The class to use for our content builder"}},"_GridAvatar":{"!type":"fn()","prototype":{"!proto":"dojo.dnd.Avatar.prototype","construct":{"!type":"fn()"},"destroy":{"!type":"fn()"}}},"_ViewManager":{"!type":"fn()","prototype":{"!doc":"A collection of grid views. Owned by grid and used internally for managing grid views.","defaultWidth":{"!type":"number"},"views":{"!type":"[]"},"constructor":{"!type":"fn(inGrid: ?)"},"resize":{"!type":"fn()"},"render":{"!type":"fn()"},"addView":{"!type":"fn(inView: ?)"},"destroyViews":{"!type":"fn()"},"getContentNodes":{"!type":"fn()"},"forEach":{"!type":"fn(inCallback: ?)"},"onEach":{"!type":"fn(inMethod: ?, inArgs: ?)"},"normalizeHeaderNodeHeight":{"!type":"fn()"},"normalizeRowNodeHeights":{"!type":"fn(inRowNodes: ?)"},"resetHeaderNodeHeight":{"!type":"fn()"},"renormalizeRow":{"!type":"fn(inRowIndex: ?)"},"getViewWidth":{"!type":"fn(inIndex: ?)"},"measureHeader":{"!type":"fn()"},"measureContent":{"!type":"fn()"},"findClient":{"!type":"fn(inAutoWidth: ?)"},"arrange":{"!type":"fn(l: ?, w: ?)"},"renderRow":{"!type":"fn(inRowIndex: ?, inNodes: ?)"},"rowRemoved":{"!type":"fn(inRowIndex: ?)"},"updateRow":{"!type":"fn(inRowIndex: ?)"},"updateRowStyles":{"!type":"fn(inRowIndex: ?)"},"setScrollTop":{"!type":"fn(inTop: ?)"},"getFirstScrollingView":{"!type":"fn()","!doc":"Returns the first grid view with a scroll bar"}}},"cells":{"_base":{},"dijit":{},"_Base":{"!type":"fn()","prototype":{"!doc":"Respresents a grid cell and contains information about column options and methods\nfor retrieving cell related information.\nEach column in a grid layout has a cell object and most events and many methods\nprovide access to these objects.\n\n\nprivate","styles":{"!type":"string"},"classes":{"!type":"string"},"editable":{"!type":"bool"},"alwaysEditing":{"!type":"bool"},"formatter":{},"defaultValue":{"!type":"string"},"value":{},"hidden":{"!type":"bool"},"noresize":{"!type":"bool"},"_valueProp":{"!type":"string"},"_formatPending":{"!type":"bool"},"constructor":{"!type":"fn(inProps: ?)"},"format":{"!type":"fn(inRowIndex: number, inItem: ?)","!doc":"provides the html for a given grid cell."},"formatEditing":{"!type":"fn(inDatum: +anything, inRowIndex: number)","!doc":"formats the cell for editing"},"getNode":{"!type":"fn(inRowIndex: number)","!doc":"gets the dom node for a given grid cell."},"getHeaderNode":{"!type":"fn()"},"getEditNode":{"!type":"fn(inRowIndex: ?)"},"canResize":{"!type":"fn()"},"isFlex":{"!type":"fn()"},"applyEdit":{"!type":"fn(inValue: ?, inRowIndex: ?)"},"cancelEdit":{"!type":"fn(inRowIndex: ?)"},"_onEditBlur":{"!type":"fn(inRowIndex: ?)"},"registerOnBlur":{"!type":"fn(inNode: ?, inRowIndex: ?)"},"needFormatNode":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"cancelFormatNode":{"!type":"fn()"},"_formatNode":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"formatNode":{"!type":"fn(inNode: +dom, inDatum: +anything, inRowIndex: number)","!doc":"format the editing dom node. Use when editor is a widget."},"dispatchEvent":{"!type":"fn(m: ?, e: ?)"},"getValue":{"!type":"fn(inRowIndex: number)","!doc":"returns value entered into editor"},"setValue":{"!type":"fn(inRowIndex: number, inValue: +anything)","!doc":"set the value of the grid editor"},"focus":{"!type":"fn(inRowIndex: number, inNode: +dom)","!doc":"focus the grid editor"},"save":{"!type":"fn(inRowIndex: number)","!doc":"save editor state"},"restore":{"!type":"fn(inRowIndex: number)","!doc":"restore editor state"},"_finish":{"!type":"fn(inRowIndex: number)","!doc":"called when editing is completed to clean up editor"},"apply":{"!type":"fn(inRowIndex: number)","!doc":"apply edit from cell editor"},"cancel":{"!type":"fn(inRowIndex: number)","!doc":"cancel cell edit"}},"markupFactory":{"!type":"fn(node: ?, cellDef: ?)"}},"Cell":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells._Base.prototype","keyFilter":{"!doc":"optional regex for disallowing keypresses","!type":"+RegExp"},"constructor":{"!type":"fn()"},"formatEditing":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"formatNode":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"doKey":{"!type":"fn(e: ?)"},"_finish":{"!type":"fn(inRowIndex: ?)"}},"markupFactory":{"!type":"fn(node: ?, cellDef: ?)"}},"RowIndex":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells.Cell.prototype","name":{"!type":"string"},"postscript":{"!type":"fn()"},"get":{"!type":"fn(inRowIndex: ?)"}},"markupFactory":{"!type":"fn(node: ?, cellDef: ?)"}},"Select":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells.Cell.prototype","!doc":"grid cell that provides a standard select for editing","options":{"!doc":"text of each item","!type":"[]"},"values":{"!doc":"value for each item","!type":"[]"},"returnIndex":{"!doc":"editor returns only the index of the selected option and not the value","!type":"+Integer"},"constructor":{"!type":"fn(inCell: ?)"},"formatEditing":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"getValue":{"!type":"fn(inRowIndex: ?)"}},"markupFactory":{"!type":"fn(node: ?, cell: ?)"}},"AlwaysEdit":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells.Cell.prototype","!doc":"grid cell that is always in an editable state, regardless of grid editing state","alwaysEditing":{"!type":"bool"},"_formatNode":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"applyStaticValue":{"!type":"fn(inRowIndex: ?)"}},"markupFactory":{"!type":"fn(node: ?, cell: ?)"}},"Bool":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells.AlwaysEdit.prototype","!doc":"grid cell that provides a standard checkbox that is always on for editing","_valueProp":{"!type":"string"},"formatEditing":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"doclick":{"!type":"fn(e: ?)"}},"markupFactory":{"!type":"fn(node: ?, cell: ?)"}},"_Widget":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells._Base.prototype","constructor":{"!type":"fn(inCell: ?)"},"formatEditing":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"getValue":{"!type":"fn(inRowIndex: ?)"},"setValue":{"!type":"fn(inRowIndex: ?, inValue: ?)"},"getWidgetProps":{"!type":"fn(inDatum: ?)"},"createWidget":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"attachWidget":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"formatNode":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"sizeWidget":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"focus":{"!type":"fn(inRowIndex: ?, inNode: ?)"},"_finish":{"!type":"fn(inRowIndex: ?)"}},"widgetClass":{},"markupFactory":{"!type":"fn(node: ?, cell: ?)"}},"ComboBox":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells._Widget.prototype","getWidgetProps":{"!type":"fn(inDatum: ?)"},"getValue":{"!type":"fn()"}},"widgetClass":{},"markupFactory":{"!type":"fn(node: ?, cell: ?)"}},"DateTextBox":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells._Widget.prototype","setValue":{"!type":"fn(inRowIndex: ?, inValue: ?)"},"getWidgetProps":{"!type":"fn(inDatum: ?)"}},"widgetClass":{},"markupFactory":{"!type":"fn(node: ?, cell: ?)"}},"CheckBox":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells._Widget.prototype","getValue":{"!type":"fn()"},"setValue":{"!type":"fn(inRowIndex: ?, inValue: ?)"},"sizeWidget":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"}},"widgetClass":{},"markupFactory":{"!type":"fn(node: ?, cell: ?)"}},"Editor":{"!type":"fn()","prototype":{"!proto":"dojox.grid.cells._Widget.prototype","getWidgetProps":{"!type":"fn(inDatum: ?)"},"createWidget":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"formatNode":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"populateEditor":{"!type":"fn()"}},"widgetClass":{},"markupFactory":{"!type":"fn(node: ?, cell: ?)"}}},"compat":{"Grid":{},"VirtualGrid":{},"editors":{},"_data":{"dijitEditors":{},"fields":{},"model":{}},"_grid":{"builder":{},"cell":{},"drag":{},"edit":{},"focus":{},"layout":{},"lib":{},"publicEvents":{},"rowbar":{},"rows":{},"scroller":{},"selection":{},"view":{},"views":{}}},"editors":{"base":{},"input":{},"select":{},"alwaysOn":{},"bool":{},"Dijit":{"!type":"fn()","prototype":{"!proto":"dojox.grid.editors.base.prototype","editorClass":{"!type":"string"},"constructor":{"!type":"fn(inCell: ?)"},"format":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"getValue":{"!type":"fn(inRowIndex: ?)"},"setValue":{"!type":"fn(inRowIndex: ?, inValue: ?)"},"getEditorProps":{"!type":"fn(inDatum: ?)"},"createEditor":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"attachEditor":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"formatNode":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"sizeEditor":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"focus":{"!type":"fn(inRowIndex: ?, inNode: ?)"},"_finish":{"!type":"fn(inRowIndex: ?)"}}},"ComboBox":{"!type":"fn()","prototype":{"!proto":"dojox.grid.editors.Dijit.prototype","editorClass":{"!type":"string"},"getEditorProps":{"!type":"fn(inDatum: ?)"},"getValue":{"!type":"fn()"}}},"DateTextBox":{"!type":"fn()","prototype":{"!proto":"dojox.grid.editors.Dijit.prototype","editorClass":{"!type":"string"},"setValue":{"!type":"fn(inRowIndex: ?, inValue: ?)"},"getEditorProps":{"!type":"fn(inDatum: ?)"}}},"CheckBox":{"!type":"fn()","prototype":{"!proto":"dojox.grid.editors.Dijit.prototype","editorClass":{"!type":"string"},"getValue":{"!type":"fn()"},"setValue":{"!type":"fn(inRowIndex: ?, inValue: ?)"},"sizeEditor":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"}}},"Editor":{"!type":"fn()","prototype":{"!proto":"dojox.grid.editors.Dijit.prototype","editorClass":{"!type":"string"},"getEditorProps":{"!type":"fn(inDatum: ?)"},"createEditor":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"formatNode":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"populateEditor":{"!type":"fn()"}}},"Base":{"!type":"fn()","prototype":{"!doc":"base grid editor class. Other grid editors should inherited from this class.\n\n\nprivate\n\n\nprotected\n\n\nprivate\n\n\nprotected\n\n\npublic\n\n\nprotected\n\n\npublic","_valueProp":{"!type":"string"},"_formatPending":{"!type":"bool"},"constructor":{"!type":"fn(inCell: ?)"},"format":{"!type":"fn(inDatum: +anything, inRowIndex: number)","!doc":"formats the cell for editing"},"needFormatNode":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"cancelFormatNode":{"!type":"fn()"},"_formatNode":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"getNode":{"!type":"fn(inRowIndex: ?)"},"formatNode":{"!type":"fn(inNode: +dom, inDatum: +anything, inRowIndex: number)","!doc":"format the editing dom node. Use when editor is a widget."},"dispatchEvent":{"!type":"fn(m: ?, e: ?)"},"getValue":{"!type":"fn(inRowIndex: number)","!doc":"returns value entered into editor"},"setValue":{"!type":"fn(inRowIndex: number, inValue: +anything)","!doc":"set the value of the grid editor"},"focus":{"!type":"fn(inRowIndex: number, inNode: +dom)","!doc":"focus the grid editor"},"save":{"!type":"fn(inRowIndex: number)","!doc":"save editor state"},"restore":{"!type":"fn(inRowIndex: number)","!doc":"restore editor state"},"_finish":{"!type":"fn(inRowIndex: number)","!doc":"called when editing is completed to clean up editor"},"apply":{"!type":"fn(inRowIndex: number)","!doc":"apply edit from cell editor"},"cancel":{"!type":"fn(inRowIndex: number)","!doc":"cancel cell edit"}}},"Input":{"!type":"fn()","prototype":{"!proto":"dojox.grid.editors.Base.prototype","keyFilter":{"!doc":"optional regex for disallowing keypresses","!type":"?"},"constructor":{"!type":"fn(inCell: ?)"},"format":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"formatNode":{"!type":"fn(inNode: ?, inDatum: ?, inRowIndex: ?)"},"doKey":{"!type":"fn(e: ?)"},"_finish":{"!type":"fn(inRowIndex: ?)"}}},"Select":{"!type":"fn()","prototype":{"!proto":"dojox.grid.editors.Input.prototype","!doc":"grid cell editor that provides a standard select\noptions: text of each item\nvalues: value for each item\nreturnIndex: editor returns only the index of the selected option and not the value","constructor":{"!type":"fn(inCell: ?)"},"format":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"getValue":{"!type":"fn(inRowIndex: ?)"}}},"AlwaysOn":{"!type":"fn()","prototype":{"!proto":"dojox.grid.editors.Input.prototype","!doc":"grid cell editor that is always on, regardless of grid editing state","alwaysOn":{"!doc":"flag to use editor to format grid cell regardless of editing state.","!type":"bool"},"_formatNode":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"applyStaticValue":{"!type":"fn(inRowIndex: ?)"}}},"Bool":{"!type":"fn()","prototype":{"!proto":"dojox.grid.editors.AlwaysOn.prototype","!doc":"grid cell editor that provides a standard checkbox that is always on","_valueProp":{"!type":"string"},"format":{"!type":"fn(inDatum: ?, inRowIndex: ?)"},"doclick":{"!type":"fn(e: ?)"}}}},"data":{"table":{},"dynamic":{},"compare":{"!type":"fn(a: ?, b: ?)"},"Mixer":{"!type":"fn()","prototype":{"!doc":"basic collection class that provides a default value for items","constructor":{"!type":"fn()"},"count":{"!type":"fn()"},"clear":{"!type":"fn()"},"build":{"!type":"fn(inIndex: ?)"},"getDefault":{"!type":"fn()"},"setDefault":{"!type":"fn(inField: ?)"},"get":{"!type":"fn(inIndex: ?)"},"_set":{"!type":"fn(inIndex: ?, inField: ?)"},"set":{"!type":"fn()"},"insert":{"!type":"fn(inIndex: ?, inProps: ?)"},"remove":{"!type":"fn(inIndex: ?)"},"swap":{"!type":"fn(inIndexA: ?, inIndexB: ?)"},"move":{"!type":"fn(inFromIndex: ?, inToIndex: ?)"}}},"Field":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(inName: ?)"}},"na":{}},"Fields":{"!type":"fn()","prototype":{"!proto":"dojox.grid.data.Mixer.prototype","constructor":{"!type":"fn(inFieldClass: ?)"},"indexOf":{"!type":"fn(inKey: ?)"}}},"Model":{"!type":"fn()","prototype":{"!doc":"Base abstract grid data model.\nMakes no assumptions about the structure of grid data.\n\n\nobservers\n\n\nupdates\n\n\ndata\n\n\nobserver events\n\n\ninsert\n\n\nremove\n\n\nsort","count":{"!type":"number"},"updating":{"!type":"number"},"sort":{},"dummy":{"!type":"number"},"constructor":{"!type":"fn(inFields: ?, inData: ?)"},"observer":{"!type":"fn(inObserver: ?, inPrefix: ?)"},"notObserver":{"!type":"fn(inObserver: ?)"},"notify":{"!type":"fn(inMsg: ?, inArgs: ?)"},"clear":{"!type":"fn()"},"beginUpdate":{"!type":"fn()"},"endUpdate":{"!type":"fn()"},"clearData":{"!type":"fn()"},"change":{"!type":"fn()"},"insertion":{"!type":"fn()"},"removal":{"!type":"fn()"},"insert":{"!type":"fn(inData: ?)"},"remove":{"!type":"fn(inData: ?)"},"canSort":{"!type":"fn()"},"generateComparator":{"!type":"fn(inCompare: ?, inField: ?, inTrueForAscend: ?, inSubCompare: ?)"},"makeComparator":{"!type":"fn(inIndices: ?)"}}},"Rows":{"!type":"fn()","prototype":{"!proto":"dojox.grid.data.Model.prototype","allChange":{"!type":"fn()"},"rowChange":{"!type":"fn()"},"datumChange":{"!type":"fn()"},"beginModifyRow":{"!type":"fn(inRowIndex: ?)"},"endModifyRow":{"!type":"fn(inRowIndex: ?)"},"cancelModifyRow":{"!type":"fn(inRowIndex: ?)"}}},"Table":{"!type":"fn()","prototype":{"!proto":"dojox.grid.data.Rows.prototype","!doc":"Basic grid data model for static data in the form of an array of rows\nthat are arrays of cell data\n\n\ntables introduce cols\n\n\nmorphology\n\n\naccess\n\n\nupdate\n\n\ninsert\n\n\nremove\n\n\nsort","colCount":{"!type":"number"},"data":{},"cache":{},"dummy":{"!type":"number"},"constructor":{"!type":"fn()"},"measure":{"!type":"fn()"},"getRowCount":{"!type":"fn()"},"getColCount":{"!type":"fn()"},"badIndex":{"!type":"fn(inCaller: ?, inDescriptor: ?)"},"isGoodIndex":{"!type":"fn(inRowIndex: ?, inColIndex: ?)"},"getRow":{"!type":"fn(inRowIndex: ?)"},"copyRow":{"!type":"fn(inRowIndex: ?)"},"getDatum":{"!type":"fn(inRowIndex: ?, inColIndex: ?)"},"get":{"!type":"fn()"},"setData":{"!type":"fn(inData: ?)"},"setRow":{"!type":"fn(inData: ?, inRowIndex: ?)"},"setDatum":{"!type":"fn(inDatum: ?, inRowIndex: ?, inColIndex: ?)"},"set":{"!type":"fn()"},"setRows":{"!type":"fn(inData: ?, inRowIndex: ?)"},"update":{"!type":"fn(inOldData: ?, inNewData: ?, inRowIndex: ?)"},"_insert":{"!type":"fn(inData: ?, inRowIndex: ?)"},"_remove":{"!type":"fn(inKeys: ?)"},"sort":{"!type":"fn()"},"swap":{"!type":"fn(inIndexA: ?, inIndexB: ?)"}}},"Objects":{"!type":"fn()","prototype":{"!proto":"dojox.grid.data.Table.prototype","constructor":{"!type":"fn(inFields: ?, inData: ?, inKey: ?)"},"allChange":{"!type":"fn()"},"autoAssignFields":{"!type":"fn()"},"setData":{"!type":"fn(inData: ?)"},"getDatum":{"!type":"fn(inRowIndex: ?, inColIndex: ?)"}}},"Dynamic":{"!type":"fn()","prototype":{"!proto":"dojox.grid.data.Table.prototype","!doc":"Grid data model for dynamic data such as data retrieved from a server.\nRetrieves data automatically when requested and provides notification when data is received\n\n\ndata\n\n\npaging\n\n\nremoval\n\n\naccess\n\n\nsort","page":{},"pages":{},"rowsPerPage":{"!type":"number"},"requests":{"!type":"number"},"bop":{"!type":"number"},"eop":{"!type":"number"},"constructor":{"!type":"fn()"},"clearData":{"!type":"fn()"},"getRowCount":{"!type":"fn()"},"getColCount":{"!type":"fn()"},"setRowCount":{"!type":"fn(inCount: ?)"},"requestsPending":{"!type":"fn(inBoolean: ?)"},"rowToPage":{"!type":"fn(inRowIndex: ?)"},"pageToRow":{"!type":"fn(inPageIndex: ?)"},"requestRows":{"!type":"fn(inRowIndex: ?, inCount: ?)","!doc":"stub. Fill in to perform actual data row fetching logic. The\nreturning logic must provide the data back to the system via\nsetRow"},"rowsProvided":{"!type":"fn(inRowIndex: ?, inCount: ?)"},"requestPage":{"!type":"fn(inPageIndex: ?)"},"needPage":{"!type":"fn(inPageIndex: ?)"},"preparePage":{"!type":"fn(inRowIndex: ?, inColIndex: ?)"},"isRowLoaded":{"!type":"fn(inRowIndex: ?)"},"removePages":{"!type":"fn(inRowIndexes: ?)"},"remove":{"!type":"fn(inRowIndexes: ?)"},"getRow":{"!type":"fn(inRowIndex: ?)"},"getDatum":{"!type":"fn(inRowIndex: ?, inColIndex: ?)"},"setDatum":{"!type":"fn(inDatum: ?, inRowIndex: ?, inColIndex: ?)"},"canSort":{"!type":"fn()"}}},"DojoData":{"!type":"fn()","prototype":{"!proto":"dojox.grid.data.Dynamic.prototype","!doc":"A grid data model for dynamic data retreived from a store which\nimplements the dojo.data API set. Retrieves data automatically when\nrequested and provides notification when data is received","store":{},"_currentlyProcessing":{},"_canNotify":{"!type":"bool"},"_canWrite":{"!type":"bool"},"_canIdentify":{"!type":"bool"},"_rowIdentities":{},"clientSort":{"!type":"bool"},"sortFields":{},"queryOptions":{},"constructor":{"!type":"fn(inFields: ?, inData: ?, args: ?)"},"markupFactory":{"!type":"fn(args: ?, node: ?)"},"setData":{"!type":"fn(inData: ?)"},"setRowCount":{"!type":"fn(inCount: ?)"},"beginReturn":{"!type":"fn(inCount: ?)"},"_setupFields":{"!type":"fn(dataItem: ?)"},"_getRowFromItem":{"!type":"fn(item: ?)"},"_createRow":{"!type":"fn(item: ?)"},"processRows":{"!type":"fn(items: ?, request: ?)"},"requestRows":{"!type":"fn(inRowIndex: ?, inCount: ?)"},"getDatum":{"!type":"fn(inRowIndex: ?, inColIndex: ?)"},"setDatum":{"!type":"fn(inDatum: ?, inRowIndex: ?, inColIndex: ?)"},"copyRow":{"!type":"fn(inRowIndex: ?)"},"_attrCompare":{"!type":"fn(cache: ?, data: ?)"},"endModifyRow":{"!type":"fn(inRowIndex: ?)"},"cancelModifyRow":{"!type":"fn(inRowIndex: ?)"},"_setRowId":{"!type":"fn(item: ?, offset: ?, idx: ?)"},"_getRowId":{"!type":"fn(item: +The, isNotItem: bool)","!doc":"Function determine the row index for a particular item"},"_storeDatumChange":{"!type":"fn(item: ?, attr: ?, oldVal: ?, newVal: ?)"},"_storeDatumDelete":{"!type":"fn(item: ?)"},"_storeDatumNew":{"!type":"fn(item: ?)"},"insert":{"!type":"fn(item: ?, index: ?)"},"_insertItem":{"!type":"fn(storeItem: ?, index: ?)"},"datumChange":{"!type":"fn(value: ?, rowIdx: ?, colIdx: ?)"},"insertion":{"!type":"fn()"},"removal":{"!type":"fn()"},"remove":{"!type":"fn(inRowIndexes: +An)","!doc":"Function to remove a set of items from the store based on the row index."},"_removeItems":{"!type":"fn(inRowIndexes: [])","!doc":"Function to remove a set of items from the store based on the row index."},"canSort":{"!type":"fn()"},"sort":{"!type":"fn(colIndex: ?)"},"refresh":{"!type":"fn()","!doc":"Function to cause the model to re-query the store and rebuild the current viewport."},"clearData":{"!type":"fn(keepStore: bool)"},"processError":{"!type":"fn(error: +The, request: +The)","!doc":"Hook function to trap error messages from the store and emit them.\nIntended for connecting to and handling the error object or at least reporting it."}},"query":{"name":{"!type":"string"}}}},"Builder":{"!type":"fn()","prototype":{"!doc":"Base class to produce html for grid content.\nAlso provide event decoration, providing grid related information inside the event object\npassed to grid events.\n\n\nboilerplate HTML","view":{},"_table":{"!type":"string"},"constructor":{"!type":"fn(inView: ?)"},"generateCellMarkup":{"!type":"fn(inCell: ?, inMoreStyles: ?, inMoreClasses: ?, isHeader: ?) -> []"},"isCellNode":{"!type":"fn(inNode: ?)"},"getCellNodeIndex":{"!type":"fn(inCellNode: ?)"},"getCellNode":{"!type":"fn(inRowNode: ?, inCellIndex: ?)"},"findCellTarget":{"!type":"fn(inSourceNode: ?, inTopNode: ?)"},"baseDecorateEvent":{"!type":"fn(e: ?)"},"findTarget":{"!type":"fn(inSource: ?, inTag: ?)"},"findRowTarget":{"!type":"fn(inSource: ?)"},"isIntraNodeEvent":{"!type":"fn(e: ?)"},"isIntraRowEvent":{"!type":"fn(e: ?)"},"dispatchEvent":{"!type":"fn(e: ?)"},"domouseover":{"!type":"fn(e: ?)"},"domouseout":{"!type":"fn(e: ?)"},"domousedown":{"!type":"fn(e: ?)"}}},"contentBuilder":{"!type":"fn()","!doc":"Produces html for grid data content. Owned by grid and used internally\nfor rendering data. Override to implement custom rendering.","prototype":{"update":{"!type":"fn()"},"prepareHtml":{"!type":"fn()"},"generateHtml":{"!type":"fn(inDataIndex: ?, inRowIndex: ?) -> string"},"decorateEvent":{"!type":"fn(e: ?) -> bool"}}},"headerBuilder":{"!type":"fn()","!doc":"Produces html for grid header content. Owned by grid and used internally\nfor rendering data. Override to implement custom rendering.","prototype":{"bogusClickTime":{"!type":"number"},"overResizeWidth":{"!type":"number"},"minColWidth":{"!type":"number"},"_table":{"!type":"string"},"update":{"!type":"fn()"},"generateHtml":{"!type":"fn(inGetValue: ?, inValue: ?)"},"getCellX":{"!type":"fn(e: ?)"},"decorateEvent":{"!type":"fn(e: ?)"},"prepareResize":{"!type":"fn(e: ?, mod: ?)"},"canResize":{"!type":"fn(e: ?)"},"overLeftResizeArea":{"!type":"fn(e: ?)"},"overRightResizeArea":{"!type":"fn(e: ?)"},"domousemove":{"!type":"fn(e: ?)"},"domousedown":{"!type":"fn(e: ?)"},"doclick":{"!type":"fn(e: ?)"},"beginColumnResize":{"!type":"fn(e: ?)"},"doResizeColumn":{"!type":"fn(inDrag: ?, inEvent: ?)"},"endResizeColumn":{"!type":"fn(inDrag: ?)"}}},"tableMap":{"!type":"fn()","!doc":"Maps an html table into a structure parsable for information about cell row and col spanning.\nUsed by headerBuilder","prototype":{"map":{},"constructor":{"!type":"fn(inRows: ?)"},"mapRows":{"!type":"fn(inRows: ?)","!doc":"Map table topography"},"dumpMap":{"!type":"fn()"},"getMapCoords":{"!type":"fn(inRow: ?, inCol: ?)","!doc":"Find node's map coords by it's structure coords"},"getNode":{"!type":"fn(inTable: ?, inRow: ?, inCol: ?)","!doc":"Find a node in inNode's table with the given structure coords"},"_findOverlappingNodes":{"!type":"fn(inTable: ?, inRow: ?, inCol: ?)"},"findOverlappingNodes":{"!type":"fn(inNode: ?)"}}},"cell":{"!type":"fn()","!doc":"Respresents a grid cell and contains information about column options and methods\nfor retrieving cell related information.\nEach column in a grid layout has a cell object and most events and many methods\nprovide access to these objects.\n\n\ndata source\n\n\nutility\n\n\nedit support","prototype":{"styles":{"!type":"string"},"constructor":{"!type":"fn(inProps: ?)"},"format":{"!type":"fn(inRowIndex: number)","!doc":"provides the html for a given grid cell."},"getNode":{"!type":"fn(inRowIndex: number)","!doc":"gets the dom node for a given grid cell."},"isFlex":{"!type":"fn()"},"applyEdit":{"!type":"fn(inValue: ?, inRowIndex: ?)"},"cancelEdit":{"!type":"fn(inRowIndex: ?)"},"_onEditBlur":{"!type":"fn(inRowIndex: ?)"},"registerOnBlur":{"!type":"fn(inNode: ?, inRowIndex: ?)"}}},"edit":{"!type":"fn()","!doc":"Controls grid cell editing process. Owned by grid and used internally for editing.","prototype":{"info":{},"_boomerangWindow":{"!type":"number"},"constructor":{"!type":"fn(inGrid: +dojox.Grid)"},"destroy":{"!type":"fn()"},"cellFocus":{"!type":"fn(inCell: +cell, inRowIndex: +Integer)","!doc":"Invoke editing when cell is focused"},"rowClick":{"!type":"fn(e: ?)"},"styleRow":{"!type":"fn(inRow: ?)"},"dispatchEvent":{"!type":"fn(e: ?)"},"isEditing":{"!type":"fn()","!doc":"Indicates editing state of the grid."},"isEditCell":{"!type":"fn(inRowIndex: +Integer, inCellIndex: +Integer)","!doc":"Indicates if the given cell is being edited."},"isEditRow":{"!type":"fn(inRowIndex: +Integer)","!doc":"Indicates if the given row is being edited."},"setEditCell":{"!type":"fn(inCell: ?, inRowIndex: +Integer)","!doc":"Set the given cell to be edited"},"_focusEditor":{"!type":"fn(inCell: ?, inRowIndex: ?)"},"focusEditor":{"!type":"fn()"},"_shouldCatchBoomerang":{"!type":"fn()"},"_boomerangFocus":{"!type":"fn()"},"_doCatchBoomerang":{"!type":"fn()"},"start":{"!type":"fn(inCell: ?, inRowIndex: ?, inEditing: ?)"},"_editorDo":{"!type":"fn(inMethod: ?)"},"editorApply":{"!type":"fn()"},"editorCancel":{"!type":"fn()"},"applyCellEdit":{"!type":"fn(inValue: ?, inCell: ?, inRowIndex: ?)"},"applyRowEdit":{"!type":"fn()"},"apply":{"!type":"fn()","!doc":"Apply a grid edit"},"cancel":{"!type":"fn()","!doc":"Cancel a grid edit"},"save":{"!type":"fn(inRowIndex: +Integer, inView: ?)","!doc":"Save the grid editing state"},"restore":{"!type":"fn(inView: ?, inRowIndex: +Integer)","!doc":"Restores the grid editing state"}}},"focus":{"!type":"fn()","!doc":"Controls grid cell focus. Owned by grid and used internally for focusing.\nNote: grid cell actually receives keyboard input only when cell is being edited.","prototype":{"tabbingOut":{"!type":"bool"},"focusClass":{"!type":"string"},"focusView":{},"constructor":{"!type":"fn(inGrid: ?)"},"initFocusView":{"!type":"fn()"},"isFocusCell":{"!type":"fn(inCell: ?, inRowIndex: number)","!doc":"states if the given cell is focused"},"isLastFocusCell":{"!type":"fn()"},"isFirstFocusCell":{"!type":"fn()"},"isNoFocusCell":{"!type":"fn()"},"_focusifyCellNode":{"!type":"fn(inBork: ?)"},"scrollIntoView":{"!type":"fn()"},"styleRow":{"!type":"fn(inRow: ?)"},"setFocusIndex":{"!type":"fn(inRowIndex: number, inCellIndex: number)","!doc":"focuses the given grid cell"},"setFocusCell":{"!type":"fn(inCell: ?, inRowIndex: number)","!doc":"focuses the given grid cell"},"next":{"!type":"fn()","!doc":"focus next grid cell"},"previous":{"!type":"fn()","!doc":"focus previous grid cell"},"move":{"!type":"fn(inRowDelta: number, inColDelta: number)","!doc":"focus grid cell based on position relative to current focus"},"previousKey":{"!type":"fn(e: ?)"},"nextKey":{"!type":"fn(e: ?)"},"tabOut":{"!type":"fn(inFocusNode: ?)"},"focusGridView":{"!type":"fn()"},"focusGrid":{"!type":"fn(inSkipFocusCell: ?)"},"doFocus":{"!type":"fn(e: ?)"}}},"layout":{"!type":"fn()","!doc":"Controls grid cell layout. Owned by grid and used internally.\n\n\nflat array of grid cells\n\n\nstructured array of grid cells\n\n\ndefault cell width\n\n\nmethods","prototype":{"cells":{"!type":"[]"},"structure":{},"defaultWidth":{"!type":"string"},"constructor":{"!type":"fn(inGrid: ?)"},"setStructure":{"!type":"fn(inStructure: ?)"},"addViewDef":{"!type":"fn(inDef: ?)"},"addRowsDef":{"!type":"fn(inDef: ?)"},"addRowDef":{"!type":"fn(inRowIndex: ?, inDef: ?)"},"addCellDef":{"!type":"fn(inRowIndex: ?, inCellIndex: ?, inDef: ?)"}}},"jobs":{"jobs":{"!type":"[]"},"cancel":{"!type":"fn(inHandle: ?)"},"job":{"!type":"fn(inName: ?, inDelay: ?, inJob: ?)"},"cancelJob":{"!type":"fn(inName: ?)"}},"publicEvents":{"!doc":"VirtualGrid mixin that provides default implementations for grid events.","cellOverClass":{"!type":"string"},"onKeyEvent":{"!type":"fn(e: ?)","!doc":"top level handler for Key Events"},"onContentEvent":{"!type":"fn(e: ?)","!doc":"Top level handler for Content events"},"onHeaderEvent":{"!type":"fn(e: ?)","!doc":"Top level handler for header events"},"onStyleRow":{"!type":"fn(inRow: ?)","!doc":"Perform row styling on a given row. Called whenever row styling is updated."},"onKeyDown":{"!type":"fn(e: ?)","!doc":"Grid key event handler. By default enter begins editing and applies edits, escape cancels and edit,\ntab, shift-tab, and arrow keys move grid cell focus."},"onMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is over the grid."},"onMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of the grid."},"onMouseDown":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down inside grid."},"onMouseOverRow":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is over any row (data or header)."},"onMouseOutRow":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of any row (data or header)."},"onMouseDownRow":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down inside grid row"},"onCellMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is over a cell."},"onCellMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of a cell."},"onCellMouseDown":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down in a header cell."},"onCellClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a cell is clicked."},"onCellDblClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a cell is double-clicked."},"onCellContextMenu":{"!type":"fn(e: +Event)","!doc":"Event fired when a cell context menu is accessed via mouse right click."},"onCellFocus":{"!type":"fn(inCell: ?, inRowIndex: +Integer)","!doc":"Event fired when a cell receives focus."},"onRowClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a row is clicked."},"onRowDblClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a row is double clicked."},"onRowMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves over a data row."},"onRowMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of a data row."},"onRowMouseDown":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down in a row."},"onRowContextMenu":{"!type":"fn(e: +Event)","!doc":"Event fired when a row context menu is accessed via mouse right click."},"onHeaderMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves over the grid header."},"onHeaderMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of the grid header."},"onHeaderCellMouseOver":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves over a header cell."},"onHeaderCellMouseOut":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse moves out of a header cell."},"onHeaderCellMouseDown":{"!type":"fn(e: +Event)","!doc":"Event fired when mouse is down in a header cell."},"onHeaderClick":{"!type":"fn(e: +Event)","!doc":"Event fired when the grid header is clicked."},"onHeaderCellClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a header cell is clicked."},"onHeaderDblClick":{"!type":"fn(e: +Event)","!doc":"Event fired when the grid header is double clicked."},"onHeaderCellDblClick":{"!type":"fn(e: +Event)","!doc":"Event fired when a header cell is double clicked."},"onHeaderCellContextMenu":{"!type":"fn(e: +Event)","!doc":"Event fired when a header cell context menu is accessed via mouse right click."},"onHeaderContextMenu":{"!type":"fn(e: +Event)","!doc":"Event fired when the grid header context menu is accessed via mouse right click."},"onStartEdit":{"!type":"fn(inCell: ?, inRowIndex: +Integer)","!doc":"Event fired when editing is started for a given grid cell"},"onApplyCellEdit":{"!type":"fn(inValue: string, inRowIndex: +Integer, inFieldIndex: +Integer)","!doc":"Event fired when editing is applied for a given grid cell"},"onCancelEdit":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event fired when editing is cancelled for a given grid cell"},"onApplyEdit":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event fired when editing is applied for a given grid row"},"onCanSelect":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event to determine if a grid row may be selected"},"onCanDeselect":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event to determine if a grid row may be deselected"},"onSelected":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event fired when a grid row is selected"},"onDeselected":{"!type":"fn(inRowIndex: +Integer)","!doc":"Event fired when a grid row is deselected"},"onSelectionChanged":{"!type":"fn()"}},"rows":{"!type":"fn()","prototype":{"linesToEms":{"!type":"number"},"defaultRowHeight":{"!type":"number"},"overRow":{"!type":"number"},"constructor":{"!type":"fn(inGrid: ?)"},"getHeight":{"!type":"fn(inRowIndex: ?)"},"getDefaultHeightPx":{"!type":"fn()"},"prepareStylingRow":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"styleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"applyStyles":{"!type":"fn(inRow: ?)"},"updateStyles":{"!type":"fn(inRowIndex: ?)"},"setOverRow":{"!type":"fn(inRowIndex: ?)"},"isOver":{"!type":"fn(inRowIndex: ?)"}}},"scroller":{"!type":"fn()","!doc":"virtual scroller class, makes no assumption about shape of items being scrolled\n\n\nvirtual rendering interface\n\n\npage node operations\n\n\nimplementation for page manager\n\n\nrendering implementation\n\n\nscroll control","prototype":{"dummy":{"!type":"number"},"constructor":{"!type":"fn()"},"renderRow":{"!type":"fn(inRowIndex: ?, inPageNode: ?)"},"removeRow":{"!type":"fn(inRowIndex: ?)"},"getDefaultNodes":{"!type":"fn()"},"getDefaultPageNode":{"!type":"fn(inPageIndex: ?)"},"positionPageNode":{"!type":"fn(inNode: ?, inPos: ?)"},"getPageNodePosition":{"!type":"fn(inNode: ?)"},"repositionPageNodes":{"!type":"fn(inPageIndex: ?, inNodes: ?)"},"invalidatePageNode":{"!type":"fn(inPageIndex: ?, inNodes: ?)"},"preparePageNode":{"!type":"fn(inPageIndex: ?, inReusePageIndex: ?, inNodes: ?)"},"pageExists":{"!type":"fn(inPageIndex: ?)"},"measurePage":{"!type":"fn(inPageIndex: ?)"},"positionPage":{"!type":"fn(inPageIndex: ?, inPos: ?)"},"repositionPages":{"!type":"fn(inPageIndex: ?)"},"preparePage":{"!type":"fn(inPageIndex: ?, inReuseNode: ?)"},"installPage":{"!type":"fn(inPageIndex: ?)"},"destroyPage":{"!type":"fn(inPageIndex: ?)"},"renderPage":{"!type":"fn(inPageIndex: ?)"},"removePage":{"!type":"fn(inPageIndex: ?)"},"getPageRow":{"!type":"fn(inPage: ?)"},"getLastPageRow":{"!type":"fn(inPage: ?)"},"getFirstVisibleRowNodes":{"!type":"fn(inPage: ?, inPageTop: ?, inScrollTop: ?, inNodes: ?)"},"getFirstVisibleRow":{"!type":"fn(inPage: ?, inPageTop: ?, inScrollTop: ?)"},"getLastVisibleRowNodes":{"!type":"fn(inPage: ?, inBottom: ?, inScrollBottom: ?, inNodes: ?)"},"getLastVisibleRow":{"!type":"fn(inPage: ?, inBottom: ?, inScrollBottom: ?)"},"findTopRowForNodes":{"!type":"fn(inScrollTop: ?, inNodes: ?)"},"findScrollTopForNodes":{"!type":"fn(inRow: ?, inNodes: ?)"},"findTopRow":{"!type":"fn(inScrollTop: ?)"},"findScrollTop":{"!type":"fn(inRow: ?)"}},"base":{"!type":"fn()","!doc":"virtual scrollbox, abstract class\nContent must in /rows/\nRows are managed in contiguous sets called /pages/\nThere are a fixed # of rows per page\nThe minimum rendered unit is a page\n\n\nspecified\n\n\ntotal number of rows to manage\n\n\ndefault height of a row\n\n\nmaximum number of rows that should exist at one time\n\n\nnode to contain pages\n\n\nnode that controls scrolling\ncalculated\n\n\ndefault height of a page\n\n\nmaximum number of pages that should exists at one time\n\n\nprivate\n\n\ninit\n\n\nupdating\n\n\nabstract interface\n\n\npacification\n\n\ndefault sizing implementation\n\n\nscroller core\n\n\nFIXME: this is not a stack, it's a FIFO list\n\n\nevents","prototype":{"rowCount":{"!type":"number"},"defaultRowHeight":{"!type":"number"},"keepRows":{"!type":"number"},"contentNode":{},"scrollboxNode":{},"defaultPageHeight":{"!type":"number"},"keepPages":{"!type":"number"},"pageCount":{"!type":"number"},"windowHeight":{"!type":"number"},"firstVisibleRow":{"!type":"number"},"lastVisibleRow":{"!type":"number"},"page":{"!type":"number"},"pageTop":{"!type":"number"},"pacifying":{"!type":"bool"},"pacifyTicks":{"!type":"number"},"dummy":{"!type":"number"},"constructor":{"!type":"fn()"},"init":{"!type":"fn(inRowCount: ?, inKeepRows: ?, inRowsPerPage: ?)"},"setKeepInfo":{"!type":"fn(inKeepRows: ?)"},"invalidate":{"!type":"fn()"},"updateRowCount":{"!type":"fn(inRowCount: ?)"},"pageExists":{"!type":"fn(inPageIndex: ?)"},"measurePage":{"!type":"fn(inPageIndex: ?)"},"positionPage":{"!type":"fn(inPageIndex: ?, inPos: ?)"},"repositionPages":{"!type":"fn(inPageIndex: ?)"},"installPage":{"!type":"fn(inPageIndex: ?)"},"preparePage":{"!type":"fn(inPageIndex: ?, inPos: ?, inReuseNode: ?)"},"renderPage":{"!type":"fn(inPageIndex: ?)"},"removePage":{"!type":"fn(inPageIndex: ?)"},"pacify":{"!type":"fn(inShouldPacify: ?)"},"setPacifying":{"!type":"fn(inPacifying: ?)"},"startPacify":{"!type":"fn()"},"doPacify":{"!type":"fn()"},"endPacify":{"!type":"fn()"},"resize":{"!type":"fn()"},"calcLastPageHeight":{"!type":"fn()"},"updateContentHeight":{"!type":"fn(inDh: ?)"},"updatePageHeight":{"!type":"fn(inPageIndex: ?)"},"rowHeightChanged":{"!type":"fn(inRowIndex: ?)"},"invalidateNodes":{"!type":"fn()"},"createPageNode":{"!type":"fn()"},"getPageHeight":{"!type":"fn(inPageIndex: ?)"},"pushPage":{"!type":"fn(inPageIndex: ?)"},"popPage":{"!type":"fn()"},"findPage":{"!type":"fn(inTop: ?)"},"buildPage":{"!type":"fn(inPageIndex: ?, inReuseNode: ?, inPos: ?)"},"needPage":{"!type":"fn(inPageIndex: ?, inPos: ?)"},"onscroll":{"!type":"fn()"},"scroll":{"!type":"fn(inTop: ?)"},"getScrollBottom":{"!type":"fn(inTop: ?)"},"processNodeEvent":{"!type":"fn(e: ?, inNode: ?)"},"processEvent":{"!type":"fn(e: ?)"}}},"columns":{"!type":"fn()","!doc":"Virtual scroller class that scrolls list of columns. Owned by grid and used internally\nfor virtual scrolling.\n\n\nnodes\n\n\nresize\n\n\nimplementation for page manager\n\n\nrendering implementation","prototype":{"constructor":{"!type":"fn(inContentNodes: ?)"},"setContentNodes":{"!type":"fn(inNodes: ?)"},"getDefaultNodes":{"!type":"fn()"},"scroll":{"!type":"fn(inTop: ?)"},"resize":{"!type":"fn()"},"positionPage":{"!type":"fn(inPageIndex: ?, inPos: ?)"},"preparePage":{"!type":"fn(inPageIndex: ?, inReuseNode: ?)"},"installPage":{"!type":"fn(inPageIndex: ?)"},"destroyPage":{"!type":"fn(inPageIndex: ?)"},"renderPage":{"!type":"fn(inPageIndex: ?)"}}}},"selection":{"!type":"fn()","!doc":"Manages row selection for grid. Owned by grid and used internally\nfor selection. Override to implement custom selection.","prototype":{"multiSelect":{"!type":"bool"},"selected":{},"updating":{"!type":"number"},"selectedIndex":{"!type":"number"},"constructor":{"!type":"fn(inGrid: ?)"},"onCanSelect":{"!type":"fn(inIndex: ?)"},"onCanDeselect":{"!type":"fn(inIndex: ?)"},"onSelected":{"!type":"fn(inIndex: ?)"},"onDeselected":{"!type":"fn(inIndex: ?)"},"onChanging":{"!type":"fn()"},"onChanged":{"!type":"fn()"},"isSelected":{"!type":"fn(inIndex: ?)"},"getFirstSelected":{"!type":"fn()"},"getNextSelected":{"!type":"fn(inPrev: ?)"},"getSelected":{"!type":"fn()"},"getSelectedCount":{"!type":"fn()"},"beginUpdate":{"!type":"fn()"},"endUpdate":{"!type":"fn()"},"select":{"!type":"fn(inIndex: ?)"},"addToSelection":{"!type":"fn(inIndex: ?)"},"deselect":{"!type":"fn(inIndex: ?)"},"setSelected":{"!type":"fn(inIndex: ?, inSelect: ?)"},"toggleSelect":{"!type":"fn(inIndex: ?)"},"insert":{"!type":"fn(inIndex: ?)"},"remove":{"!type":"fn(inIndex: ?)"},"unselectAll":{"!type":"fn(inExcept: ?)"},"shiftSelect":{"!type":"fn(inFrom: ?, inTo: ?)"},"clickSelect":{"!type":"fn(inIndex: ?, inCtrlKey: ?, inShiftKey: ?)"},"clickSelectEvent":{"!type":"fn(e: ?)"},"clear":{"!type":"fn()"}}},"views":{"!type":"fn()","!doc":"A collection of grid views. Owned by grid and used internally for managing grid views.","prototype":{"defaultWidth":{"!type":"number"},"views":{"!type":"[]"},"constructor":{"!type":"fn(inGrid: ?)"},"resize":{"!type":"fn()"},"render":{"!type":"fn()"},"addView":{"!type":"fn(inView: ?)"},"destroyViews":{"!type":"fn()"},"getContentNodes":{"!type":"fn()"},"forEach":{"!type":"fn(inCallback: ?)"},"onEach":{"!type":"fn(inMethod: ?, inArgs: ?)"},"normalizeHeaderNodeHeight":{"!type":"fn()"},"normalizeRowNodeHeights":{"!type":"fn(inRowNodes: ?)"},"resetHeaderNodeHeight":{"!type":"fn()"},"renormalizeRow":{"!type":"fn(inRowIndex: ?)"},"getViewWidth":{"!type":"fn(inIndex: ?)"},"measureHeader":{"!type":"fn()"},"measureContent":{"!type":"fn()"},"findClient":{"!type":"fn(inAutoWidth: ?)"},"arrange":{"!type":"fn(l: ?, w: ?)"},"renderRow":{"!type":"fn(inRowIndex: ?, inNodes: ?)"},"rowRemoved":{"!type":"fn(inRowIndex: ?)"},"updateRow":{"!type":"fn(inRowIndex: ?, inHeight: ?)"},"updateRowStyles":{"!type":"fn(inRowIndex: ?)"},"setScrollTop":{"!type":"fn(inTop: ?)"},"getFirstScrollingView":{"!type":"fn()","!doc":"Returns the first grid view with a scroll bar"}}}},"Grid":{"!type":"fn()","prototype":{"!proto":"dojox.VirtualGrid.prototype","!doc":"A grid widget with virtual scrolling, cell editing, complex rows,\nsorting, fixed columns, sizeable columns, etc.","model":{"!doc":"or object grid data model","!type":"string"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"_structureChanged":{"!type":"fn()"},"_setModel":{"!type":"fn(inModel: ?)"},"setModel":{"!type":"fn(inModel: ?)","!doc":"Set the grid's data model"},"get":{"!type":"fn(inRowIndex: ?)","!doc":"data socket (called in cell's context)"},"modelAllChange":{"!type":"fn()"},"modelBeginUpdate":{"!type":"fn()"},"modelEndUpdate":{"!type":"fn()"},"modelRowChange":{"!type":"fn(inData: ?, inRowIndex: ?)"},"modelDatumChange":{"!type":"fn(inDatum: ?, inRowIndex: ?, inFieldIndex: ?)"},"modelFieldsChange":{"!type":"fn()"},"modelInsertion":{"!type":"fn(inRowIndex: ?)"},"modelRemoval":{"!type":"fn(inKeys: ?)"},"getCellName":{"!type":"fn(inCell: ?)"},"indexCellFields":{"!type":"fn()"},"refresh":{"!type":"fn()","!doc":"Re-render the grid, getting new data from the model"},"canSort":{"!type":"fn(inSortInfo: ?)"},"getSortField":{"!type":"fn(inSortInfo: +Integer)","!doc":"Retrieves the model field on which to sort data."},"sort":{"!type":"fn()"},"addRow":{"!type":"fn(inRowData: ?, inIndex: ?)"},"removeSelectedRows":{"!type":"fn()"},"canEdit":{"!type":"fn(inCell: ?, inRowIndex: +Integer)","!doc":"Determines if a given cell may be edited"},"doStartEdit":{"!type":"fn(inCell: ?, inRowIndex: ?)"},"doApplyCellEdit":{"!type":"fn(inValue: ?, inRowIndex: ?, inFieldIndex: ?)"},"doCancelEdit":{"!type":"fn(inRowIndex: ?)"},"doApplyEdit":{"!type":"fn(inRowIndex: ?)"},"styleRowState":{"!type":"fn(inRow: ?)","!doc":"Perform row styling"},"onStyleRow":{"!type":"fn(inRow: ?)"}},"markupFactory":{"!type":"fn(props: ?, node: ?, ctor: ?)"}},"VirtualGrid":{"!type":"fn()","prototype":{"templatePath":{},"classTag":{"!doc":"CSS class applied to the grid's domNode","!type":"string"},"rowCount":{"!doc":"Number of rows to display.","!type":"+Integer"},"keepRows":{"!doc":"Number of rows to keep in the rendering cache.","!type":"+Integer"},"rowsPerPage":{"!doc":"Number of rows to render at a time.","!type":"+Integer"},"autoWidth":{"!doc":"If autoWidth is true, grid width is automatically set to fit the data.","!type":"bool"},"autoHeight":{"!doc":"If autoHeight is true, grid height is automatically set to fit the data.","!type":"bool"},"autoRender":{"!doc":"If autoRender is true, grid will render itself after initialization.","!type":"bool"},"defaultHeight":{"!doc":"default height of the grid, measured in any valid css unit.","!type":"string"},"structure":{"!doc":"View layout defintion. Can be set to a layout object, or to the (string) name of a layout object.","!type":"+Object"},"elasticView":{"!doc":"Override defaults and make the indexed grid view elastic, thus filling available horizontal space.","!type":"+Integer"},"singleClickEdit":{"!doc":"Single-click starts editing. Default is double-click","!type":"bool"},"_click":{},"sortInfo":{"!type":"number"},"themeable":{"!type":"bool"},"invalidated":{},"updating":{"!type":"bool"},"fastScroll":{"!doc":"flag modifies vertical scrolling behavior. Defaults to true but set to false for slower\nscroll performance but more immediate scrolling feedback","!type":"bool"},"delayScroll":{"!type":"bool"},"scrollRedrawThreshold":{"!doc":"pixel distance a user must scroll vertically to trigger grid scrolling.","!type":"number"},"get":{"!type":"fn(inRowIndex: +Integer)","!doc":"Default data getter."},"buildRendering":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"styleChanged":{"!type":"fn()"},"_styleChanged":{"!type":"fn()"},"textSizeChanged":{"!type":"fn()"},"_textSizeChanged":{"!type":"fn()"},"sizeChange":{"!type":"fn()"},"renderOnIdle":{"!type":"fn()"},"createManagers":{"!type":"fn()","!doc":"create grid managers for various tasks including rows, focus, selection, editing"},"createScroller":{"!type":"fn()","!doc":"Creates a new virtual scroller"},"createLayout":{"!type":"fn()","!doc":"Creates a new Grid layout"},"createViews":{"!type":"fn()"},"createView":{"!type":"fn(inClass: ?)"},"buildViews":{"!type":"fn()"},"setStructure":{"!type":"fn(inStructure: ?)","!doc":"Install a new structure and rebuild the grid."},"_structureChanged":{"!type":"fn()"},"hasLayout":{"!type":"fn()"},"resize":{"!type":"fn(sizeBox?: ?)","!doc":"Update the grid's rendering dimensions and resize it"},"_getPadBorder":{"!type":"fn()"},"_resize":{"!type":"fn()"},"adaptWidth":{"!type":"fn()"},"adaptHeight":{"!type":"fn()"},"render":{"!type":"fn()","!doc":"Render the grid, headers, and views. Edit and scrolling states are reset. To retain edit and\nscrolling states, see Update."},"prerender":{"!type":"fn()"},"postrender":{"!type":"fn()"},"postresize":{"!type":"fn()"},"renderRow":{"!type":"fn(inRowIndex: ?, inNodes: ?)","!doc":"private, used internally to render rows"},"rowRemoved":{"!type":"fn(inRowIndex: ?)","!doc":"private, used internally to remove rows"},"beginUpdate":{"!type":"fn()","!doc":"Use to make multiple changes to rows while queueing row updating."},"endUpdate":{"!type":"fn()","!doc":"Use after calling beginUpdate to render any changes made to rows."},"defaultUpdate":{"!type":"fn()"},"update":{"!type":"fn()","!doc":"Update the grid, retaining edit and scrolling states."},"updateRow":{"!type":"fn(inRowIndex: +Integer)","!doc":"Render a single row."},"updateRowCount":{"!type":"fn(inRowCount: number)","!doc":"Change the number of rows."},"updateRowStyles":{"!type":"fn(inRowIndex: ?)","!doc":"Update the styles for a row after it's state has changed."},"rowHeightChanged":{"!type":"fn(inRowIndex: +Integer)","!doc":"Update grid when the height of a row has changed. Row height is handled automatically as rows\nare rendered. Use this function only to update a row's height outside the normal rendering process."},"scrollTo":{"!type":"fn(inTop: +Integer)","!doc":"Vertically scroll the grid to a given pixel position"},"finishScrollJob":{"!type":"fn()"},"setScrollTop":{"!type":"fn(inTop: ?)"},"scrollToRow":{"!type":"fn(inRowIndex: +Integer)","!doc":"Scroll the grid to a specific row."},"styleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"getCell":{"!type":"fn(inIndex: +Integer)","!doc":"Retrieves the cell object for a given grid column."},"setCellWidth":{"!type":"fn(inIndex: ?, inUnitWidth: ?)"},"getCellName":{"!type":"fn(inCell: ?) -> string","!doc":"Returns the cell name of a passed cell"},"canSort":{"!type":"fn(inSortInfo: +Integer)","!doc":"Determines if the grid can be sorted"},"sort":{"!type":"fn()"},"getSortAsc":{"!type":"fn(inSortInfo: ?) -> bool","!doc":"Returns true if grid is sorted in an ascending direction."},"getSortIndex":{"!type":"fn(inSortInfo: ?) -> +Integer","!doc":"Returns the index of the column on which the grid is sorted"},"setSortIndex":{"!type":"fn(inIndex: +Integer, inAsc: bool)","!doc":"Sort the grid on a column in a specified direction"},"setSortInfo":{"!type":"fn(inSortInfo: ?)"},"doKeyEvent":{"!type":"fn(e: ?)"},"_dispatch":{"!type":"fn(m: ?, e: ?)"},"dispatchKeyEvent":{"!type":"fn(e: ?)"},"dispatchContentEvent":{"!type":"fn(e: ?)"},"dispatchHeaderEvent":{"!type":"fn(e: ?)"},"dokeydown":{"!type":"fn(e: ?)"},"doclick":{"!type":"fn(e: ?)"},"dodblclick":{"!type":"fn(e: ?)"},"docontextmenu":{"!type":"fn(e: ?)"},"doheaderclick":{"!type":"fn(e: ?)"},"doheaderdblclick":{"!type":"fn(e: ?)"},"doheadercontextmenu":{"!type":"fn(e: ?)"},"doStartEdit":{"!type":"fn(inCell: ?, inRowIndex: ?)"},"doApplyCellEdit":{"!type":"fn(inValue: ?, inRowIndex: ?, inFieldIndex: ?)"},"doCancelEdit":{"!type":"fn(inRowIndex: ?)"},"doApplyEdit":{"!type":"fn(inRowIndex: ?)"},"addRow":{"!type":"fn()","!doc":"Add a row to the grid."},"removeSelectedRows":{"!type":"fn()","!doc":"Remove the selected rows from the grid."}}},"GridRowView":{"!type":"fn()","prototype":{"!proto":"dojox.GridView.prototype","!doc":"Custom grid view. If used in a grid structure, provides a small selectable region for grid rows.\n\n\nstyling\n\n\nevent handlers","defaultWidth":{"!type":"string"},"noscroll":{"!type":"bool"},"padBorderWidth":{"!type":"number"},"buildRendering":{"!type":"fn()"},"getWidth":{"!type":"fn()"},"buildRowContent":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"renderHeader":{"!type":"fn()"},"resize":{"!type":"fn()"},"adaptWidth":{"!type":"fn()"},"doStyleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"domouseover":{"!type":"fn(e: ?)"},"domouseout":{"!type":"fn(e: ?)"}}},"GridView":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A collection of grid columns. A grid is comprised of a set of views that stack horizontally.\nGrid creates views automatically based on grid's layout structure.\nUsers should typically not need to access individual views directly.","defaultWidth":{"!doc":"Default widget of the view","!type":"string"},"viewWidth":{"!doc":"Width for the view, in valid css unit","!type":"string"},"templatePath":{},"themeable":{"!type":"bool"},"classTag":{"!type":"string"},"marginBottom":{"!type":"number"},"rowPad":{"!type":"number"},"lastTop":{"!type":"number"},"firstScroll":{"!type":"number"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"focus":{"!type":"fn()"},"setStructure":{"!type":"fn(inStructure: ?)"},"testFlexCells":{"!type":"fn()"},"updateStructure":{"!type":"fn()"},"getScrollbarWidth":{"!type":"fn() -> +Integer"},"getColumnsWidth":{"!type":"fn() -> +Integer"},"getWidth":{"!type":"fn() -> string"},"getContentWidth":{"!type":"fn() -> string"},"render":{"!type":"fn()"},"renderHeader":{"!type":"fn()"},"_getHeaderContent":{"!type":"fn(inCell: ?)"},"resize":{"!type":"fn()"},"hasScrollbar":{"!type":"fn() -> bool"},"adaptHeight":{"!type":"fn()"},"adaptWidth":{"!type":"fn()"},"setSize":{"!type":"fn(w: ?, h: ?)"},"renderRow":{"!type":"fn(inRowIndex: ?, inHeightPx: ?)"},"createRowNode":{"!type":"fn(inRowIndex: ?)"},"buildRow":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"buildRowContent":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"rowRemoved":{"!type":"fn(inRowIndex: ?)"},"getRowNode":{"!type":"fn(inRowIndex: ?)"},"getCellNode":{"!type":"fn(inRowIndex: ?, inCellIndex: ?)"},"styleRow":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"styleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"doStyleRowNode":{"!type":"fn(inRowIndex: ?, inRowNode: ?)"},"updateRow":{"!type":"fn(inRowIndex: ?, inHeightPx: ?, inPageNode: ?)"},"updateRowStyles":{"!type":"fn(inRowIndex: ?)"},"doscroll":{"!type":"fn(inEvent: ?)"},"setScrollTop":{"!type":"fn(inTop: ?)"},"doContentEvent":{"!type":"fn(e: ?)"},"doHeaderEvent":{"!type":"fn(e: ?)"},"dispatchContentEvent":{"!type":"fn(e: ?)"},"dispatchHeaderEvent":{"!type":"fn(e: ?)"},"setColWidth":{"!type":"fn(inIndex: ?, inWidth: ?)"},"update":{"!type":"fn()"}}},"help":{"!doc":"Adds the help function to all variables.","_namespaces":{"!type":"[]"},"_rpc":{},"_attributes":{"!type":"[]"},"_toStrings":{},"_overrides":{"!type":"[]"},"_recursions":{"!type":"[]"},"_names":{},"_timer":{"!type":"bool"},"_toStringTimer":{},"_base":{},"console":{},"locate":{"!type":"fn(searchFor: string, searchIn: string, maxResults: number)","!doc":"Search for dojo functionality that has something to do with the given string."},"refresh":{"!type":"fn(namespace?: string, recursive?: bool)","!doc":"Useful if you reset some values, and want to restore their\nhelp function"},"noConflict":{"!type":"fn(item?: ?)","!doc":"Use this function when you want to resolve the problems\ncreated by including a dojox.help package."},"init":{"!type":"fn(namespaces: [string], noConflict?: +Boolen)","!doc":"Should be called by one of the implementations. Runs startup code"},"_noConflict":{"!type":"fn(item: ?)"},"_clean":{"!type":"fn(self: ?)"},"_displayLocated":{"!type":"fn(located: ?)","!doc":"Stub function to be overridden in one of the dojox.help packages"},"_displayHelp":{"!type":"fn(loading: ?, obj: ?)","!doc":"Stub function to be overridden in one of the dojox.help packages"},"_addVersion":{"!type":"fn(obj: ?)"},"_stripPrototype":{"!type":"fn(original: ?)"},"_help":{"!type":"fn()"},"_parse":{"!type":"fn(data: ?)"},"_toString":{"!type":"fn(data: ?)"},"__toString":{"!type":"fn()"},"_recurse":{"!type":"fn(namespace?: string, recursive?: bool)"},"__recurse":{"!type":"fn(namespace: ?, root: ?, name: ?, items: ?, recursive: ?)"},"_plainText":{"!type":"fn(str: ?)"}},"highlight":{"!doc":"Syntax highlighting with language auto-detection package","_base":{},"processString":{"!type":"fn(str: string, lang?: string)","!doc":"highlight a string of text"},"init":{"!type":"fn(node: string)","!doc":"Highlight a passed node"},"Code":{"!type":"fn(props?: ?, node: string, p: ?, n: ?)","!doc":"A Class object to allow for dojoType usage with the highlight engine. This is\nNOT a Widget in the conventional sense, and does not have any member functions for\nthe instance. This is provided as a convenience. You likely should be calling\n<code>dojox.highlight.init</code> directly."},"constants":{"IDENT_RE":{"!type":"string"},"UNDERSCORE_IDENT_RE":{"!type":"string"},"NUMBER_RE":{"!type":"string"},"C_NUMBER_RE":{},"APOS_STRING_MODE":{"className":{"!type":"string"},"begin":{"!type":"string"},"end":{"!type":"string"},"illegal":{"!type":"string"},"contains":{"!type":"[]"},"relevance":{"!type":"number"}},"QUOTE_STRING_MODE":{"className":{"!type":"string"},"begin":{"!type":"string"},"end":{"!type":"string"},"illegal":{"!type":"string"},"contains":{"!type":"[]"},"relevance":{"!type":"number"}},"BACKSLASH_ESCAPE":{"className":{"!type":"string"},"begin":{"!type":"string"},"end":{"!type":"string"},"relevance":{"!type":"number"}},"C_LINE_COMMENT_MODE":{"className":{"!type":"string"},"begin":{"!type":"string"},"end":{"!type":"string"},"relevance":{"!type":"number"}},"C_BLOCK_COMMENT_MODE":{"className":{"!type":"string"},"begin":{"!type":"string"},"end":{"!type":"string"}},"HASH_COMMENT_MODE":{"className":{"!type":"string"},"begin":{"!type":"string"},"end":{"!type":"string"}},"C_NUMBER_MODE":{"className":{"!type":"string"},"begin":{},"end":{"!type":"string"},"relevance":{"!type":"number"}}},"languages":{"_all":{},"_dynamic":{},"_static":{},"_www":{},"cpp":{"!doc":"C++ highlight definitions","modes":{"!type":"[]"},"defaultMode":{"lexems":{"!type":"[]"},"illegal":{"!type":"string"},"contains":{"!type":"[]"},"keywords":{"false":{"!type":"number"},"int":{"!type":"number"},"float":{"!type":"number"},"while":{"!type":"number"},"private":{"!type":"number"},"char":{"!type":"number"},"catch":{"!type":"number"},"export":{"!type":"number"},"virtual":{"!type":"number"},"operator":{"!type":"number"},"sizeof":{"!type":"number"},"dynamic_cast":{"!type":"number"},"typedef":{"!type":"number"},"const_cast":{"!type":"number"},"const":{"!type":"number"},"struct":{"!type":"number"},"for":{"!type":"number"},"static_cast":{"!type":"number"},"union":{"!type":"number"},"namespace":{"!type":"number"},"unsigned":{"!type":"number"},"long":{"!type":"number"},"throw":{"!type":"number"},"volatile":{"!type":"number"},"static":{"!type":"number"},"protected":{"!type":"number"},"bool":{"!type":"number"},"template":{"!type":"number"},"mutable":{"!type":"number"},"if":{"!type":"number"},"public":{"!type":"number"},"friend":{"!type":"number"},"do":{"!type":"number"},"return":{"!type":"number"},"goto":{"!type":"number"},"auto":{"!type":"number"},"void":{"!type":"number"},"enum":{"!type":"number"},"else":{"!type":"number"},"break":{"!type":"number"},"new":{"!type":"number"},"extern":{"!type":"number"},"using":{"!type":"number"},"true":{"!type":"number"},"class":{"!type":"number"},"asm":{"!type":"number"},"case":{"!type":"number"},"typeid":{"!type":"number"},"short":{"!type":"number"},"reinterpret_cast":{"!type":"number"},"default":{"!type":"number"},"double":{"!type":"number"},"register":{"!type":"number"},"explicit":{"!type":"number"},"signed":{"!type":"number"},"typename":{"!type":"number"},"try":{"!type":"number"},"this":{"!type":"number"},"switch":{"!type":"number"},"continue":{"!type":"number"},"wchar_t":{"!type":"number"},"inline":{"!type":"number"},"delete":{"!type":"number"}}}},"css":{"case_insensitive":{"!type":"bool"},"modes":{"!type":"[]"},"defaultMode":{"contains":{"!type":"[]"},"lexems":{"!type":"[]"},"illegal":{"!type":"string"},"keywords":{"name tag":{},"keyword":{"@media":{"!type":"number"}}}}},"delphi":{"case_insensitive":{"!type":"bool"},"modes":{"!type":"[]"},"defaultMode":{"lexems":{"!type":"[]"},"illegal":{"!type":"string"},"contains":{"!type":"[]"},"keywords":{}}},"django":{"case_insensitive":{"!type":"bool"},"modes":{"!type":"[]"},"defaultMode":{"contains":{"!type":"[]"}}},"html":{"case_insensitive":{"!type":"bool"},"modes":{"!type":"[]"},"HTML_TAGS":{},"HTML_DOCTYPE":{},"HTML_ATTR":{},"HTML_VALUE":{},"defaultMode":{"contains":{"!type":"[]"}}},"javascript":{"modes":{"!type":"[]"},"defaultMode":{"lexems":{"!type":"[]"},"contains":{"!type":"[]"},"keywords":{"keyword":{"in":{"!type":"number"},"if":{"!type":"number"},"for":{"!type":"number"},"while":{"!type":"number"},"finally":{"!type":"number"},"var":{"!type":"number"},"new":{"!type":"number"},"function":{"!type":"number"},"do":{"!type":"number"},"return":{"!type":"number"},"void":{"!type":"number"},"else":{"!type":"number"},"break":{"!type":"number"},"catch":{"!type":"number"},"instanceof":{"!type":"number"},"with":{"!type":"number"},"throw":{"!type":"number"},"case":{"!type":"number"},"default":{"!type":"number"},"try":{"!type":"number"},"this":{"!type":"number"},"switch":{"!type":"number"},"continue":{"!type":"number"},"typeof":{"!type":"number"},"delete":{"!type":"number"},"const":{"!type":"number"},"label":{"!type":"number"}},"literal":{"true":{"!type":"number"},"false":{"!type":"number"},"null":{"!type":"number"}},"keyword constant":{"true":{"!type":"number"},"false":{"!type":"number"},"null":{"!type":"number"},"NaN":{"!type":"number"},"Infinity":{"!type":"number"},"undefined":{"!type":"number"}},"name builtin":{"Array":{"!type":"number"},"Boolean":{"!type":"number"},"Date":{"!type":"number"},"Error":{"!type":"number"},"Function":{"!type":"number"},"Math":{"!type":"number"},"netscape":{"!type":"number"},"Number":{"!type":"number"},"Object":{"!type":"number"},"Packages":{"!type":"number"},"RegExp":{"!type":"number"},"String":{"!type":"number"},"sun":{"!type":"number"},"decodeURI":{"!type":"number"},"decodeURIComponent":{"!type":"number"},"encodeURI":{"!type":"number"},"encodeURIComponent":{"!type":"number"},"eval":{"!type":"number"},"isFinite":{"!type":"number"},"isNaN":{"!type":"number"},"parseFloat":{"!type":"number"},"parseInt":{"!type":"number"},"document":{"!type":"number"},"window":{"!type":"number"}},"name builtin pseudo":{"this":{"!type":"number"}}}}},"pygments":{"_html":{"tags":{"code":{"!type":"number"},"kbd":{"!type":"number"},"font":{"!type":"number"},"noscript":{"!type":"number"},"style":{"!type":"number"},"img":{"!type":"number"},"title":{"!type":"number"},"menu":{"!type":"number"},"tt":{"!type":"number"},"tr":{"!type":"number"},"param":{"!type":"number"},"li":{"!type":"number"},"tfoot":{"!type":"number"},"th":{"!type":"number"},"input":{"!type":"number"},"td":{"!type":"number"},"dl":{"!type":"number"},"blockquote":{"!type":"number"},"fieldset":{"!type":"number"},"big":{"!type":"number"},"dd":{"!type":"number"},"abbr":{"!type":"number"},"optgroup":{"!type":"number"},"dt":{"!type":"number"},"button":{"!type":"number"},"isindex":{"!type":"number"},"p":{"!type":"number"},"small":{"!type":"number"},"div":{"!type":"number"},"dir":{"!type":"number"},"em":{"!type":"number"},"frame":{"!type":"number"},"meta":{"!type":"number"},"sub":{"!type":"number"},"bdo":{"!type":"number"},"label":{"!type":"number"},"acronym":{"!type":"number"},"sup":{"!type":"number"},"body":{"!type":"number"},"xml":{"!type":"number"},"basefont":{"!type":"number"},"base":{"!type":"number"},"br":{"!type":"number"},"address":{"!type":"number"},"strong":{"!type":"number"},"legend":{"!type":"number"},"ol":{"!type":"number"},"script":{"!type":"number"},"caption":{"!type":"number"},"s":{"!type":"number"},"col":{"!type":"number"},"h2":{"!type":"number"},"h3":{"!type":"number"},"h1":{"!type":"number"},"h6":{"!type":"number"},"h4":{"!type":"number"},"h5":{"!type":"number"},"table":{"!type":"number"},"select":{"!type":"number"},"noframes":{"!type":"number"},"span":{"!type":"number"},"area":{"!type":"number"},"dfn":{"!type":"number"},"strike":{"!type":"number"},"cite":{"!type":"number"},"thead":{"!type":"number"},"head":{"!type":"number"},"option":{"!type":"number"},"form":{"!type":"number"},"hr":{"!type":"number"},"var":{"!type":"number"},"link":{"!type":"number"},"b":{"!type":"number"},"colgroup":{"!type":"number"},"ul":{"!type":"number"},"applet":{"!type":"number"},"del":{"!type":"number"},"iframe":{"!type":"number"},"pre":{"!type":"number"},"frameset":{"!type":"number"},"ins":{"!type":"number"},"tbody":{"!type":"number"},"html":{"!type":"number"},"samp":{"!type":"number"},"map":{"!type":"number"},"object":{"!type":"number"},"a":{"!type":"number"},"xmlns":{"!type":"number"},"center":{"!type":"number"},"textarea":{"!type":"number"},"i":{"!type":"number"},"q":{"!type":"number"},"u":{"!type":"number"}}},"_www":{},"css":{},"html":{},"javascript":{},"xml":{"a":{"!type":"number"}}},"xml":{"modes":{"!type":"[]"},"case_insensitive":{"!type":"bool"},"XML_COMMENT":{},"XML_ATTR":{},"XML_VALUE":{},"defaultMode":{"contains":{"!type":"[]"}}},"python":{"!doc":"Python highlight definitions","modes":{"!type":"[]"},"defaultMode":{"lexems":{"!type":"[]"},"illegal":{"!type":"string"},"contains":{"!type":"[]"},"keywords":{"and":{"!type":"number"},"elif":{"!type":"number"},"is":{"!type":"number"},"global":{"!type":"number"},"as":{"!type":"number"},"in":{"!type":"number"},"if":{"!type":"number"},"from":{"!type":"number"},"raise":{"!type":"number"},"for":{"!type":"number"},"except":{"!type":"number"},"finally":{"!type":"number"},"print":{"!type":"number"},"import":{"!type":"number"},"pass":{"!type":"number"},"None":{"!type":"number"},"return":{"!type":"number"},"exec":{"!type":"number"},"else":{"!type":"number"},"break":{"!type":"number"},"not":{"!type":"number"},"with":{"!type":"number"},"class":{"!type":"number"},"assert":{"!type":"number"},"yield":{"!type":"number"},"try":{"!type":"number"},"while":{"!type":"number"},"continue":{"!type":"number"},"del":{"!type":"number"},"or":{"!type":"number"},"def":{"!type":"number"},"lambda":{"!type":"number"}}}},"sql":{"!doc":"SQL highlight definitions","case_insensitive":{"!type":"bool"},"modes":{"!type":"[]"},"defaultMode":{"lexems":{"!type":"[]"},"contains":{"!type":"[]"},"keywords":{"keyword":{},"aggregate":{"count":{"!type":"number"},"sum":{"!type":"number"},"min":{"!type":"number"},"max":{"!type":"number"},"avg":{"!type":"number"}}}}}}},"html":{"_base":{},"styles":{},"_adjustCssPaths":{"!type":"fn(cssUrl: ?, cssText: ?)","!doc":"adjusts relative paths in cssText to be relative to cssUrl\na path is considered relative if it doesn't start with '/' and not contains ':'"},"_adjustHtmlPaths":{"!type":"fn(htmlUrl: ?, cont: ?)"},"_snarfStyles":{"!type":"fn(cssUrl: string, cont: string, styles: [])"},"_snarfScripts":{"!type":"fn(cont: ?, byRef: ?)"},"evalInGlobal":{"!type":"fn(code: ?, appendNode: ?)"},"set":{"!type":"fn(node: +Node, cont: string, params?: ?)","!doc":"inserts (replaces) the given content into the given node"},"insertCssRule":{"!type":"fn(selector: string, declaration: string, styleSheetName: string) -> string","!doc":"Creates a style and attaches it to a dynamically created stylesheet\narguments:"},"removeCssRule":{"!type":"fn(selector: string, declaration: string, styleSheetName: string) -> bool","!doc":"Removes a cssRule base on the selector and declaration passed\nThe declaration is needed for cases of dupe selectors"},"getStyleSheet":{"!type":"fn(styleSheetName: string)","!doc":"Returns a style sheet based on the argument.\nSearches dynamic style sheets first. If no matches,\nsearches document style sheets.\n\nargument: (optional)\nA title or an href to a style sheet. Title can be\nan attribute in a tag, or a dynamic style sheet\nreference. Href can be the name of the file.\nIf no argument, the assumed created dynamic style\nsheet is used."},"getDynamicStyleSheet":{"!type":"fn(styleSheetName: string) -> +StyleSheet","!doc":"Creates and returns a dynamically created style sheet\nused for dynamic styles\n\nargument:\nstyleSheetName /* optional String\nThe name given the style sheet so that multiple\nstyle sheets can be created and referenced. If\nno argument is given, the name &quot;default&quot; is used."},"enableStyleSheet":{"!type":"fn(styleSheetName: string)","!doc":"Enables the style sheet with the name passed in the\nargument. Deafults to the default style sheet."},"disableStyleSheet":{"!type":"fn(styleSheetName: ?)","!doc":"Disables the dynamic style sheet with the name passed in the\nargument. If no arg is passed, defaults to the default style sheet."},"activeStyleSheet":{"!type":"fn(title: string)","!doc":"Getter/Setter"},"getPreferredStyleSheet":{"!type":"fn()"},"getToggledStyleSheets":{"!type":"fn() -> []","!doc":"Searches HTML for style sheets that are &quot;toggle-able&quot; -\ncan be enabled and disabled. These would include sheets\nwith the title attribute, as well as the REL attribute."},"getStyleSheets":{"!type":"fn() -> ?","!doc":"Collects all the style sheets referenced in the HTML page,\nincluding any incuded via @import."},"_ContentSetter":{"!type":"fn()","prototype":{"!proto":"dojo.html._ContentSetter.prototype","adjustPaths":{"!doc":"Adjust relative paths in html string content to point to this page\nOnly useful if you grab content from a another folder than the current one","!type":"bool"},"referencePath":{"!type":"string"},"renderStyles":{"!type":"bool"},"executeScripts":{"!type":"bool"},"scriptHasHooks":{"!type":"bool"},"scriptHookReplacement":{},"_renderStyles":{"!type":"fn(styles: ?)"},"empty":{"!type":"fn()"},"onBegin":{"!type":"fn()"},"onEnd":{"!type":"fn()"},"tearDown":{"!type":"fn()"}}},"metrics":{"getFontMeasurements":{"!type":"fn() -> ?"},"getCachedFontMeasurements":{"!type":"fn(recalculate: ?)"},"getTextBox":{"!type":"fn(text: string, style: ?, className?: string)"},"getScrollbar":{"!type":"fn()"},"initOnFontResize":{"!type":"fn(interval: ?)"},"onFontResize":{"!type":"fn()"},"_fontresize":{"!type":"fn()"},"_fontResizeNode":{"onresize":{},"contentWindow":{"onresize":{}}}}},"image":{"_base":{},"preload":{"!type":"fn(urls: [])","!doc":"Preload a list of images in the dom."},"Badge":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A simple grid of Images that loops through thumbnails","baseClass":{"!type":"string"},"templateString":{"!type":"string"},"children":{"!doc":"A CSS3 Selector that determines the node to become a child","!type":"string"},"rows":{"!doc":"Number of Rows to display","!type":"+Integer"},"cols":{"!doc":"Number of Columns to display","!type":"+Integer"},"cellSize":{"!doc":"Size in PX of each thumbnail","!type":"+Integer"},"delay":{"!doc":"Time (in ms) to show the image before sizing down again","!type":"+Integer"},"threads":{"!doc":"how many cycles will be going &quot;simultaneously&quot; (&gt;2 not reccommended)","!type":"+Integer"},"easing":{"!doc":"An easing function to use when showing the node (does not apply to shrinking)","!type":"fn()"},"startup":{"!type":"fn()"},"_init":{"!type":"fn()","!doc":"Setup and layout the images"},"_getCell":{"!type":"fn(n: +Node)","!doc":"Return information about the position for a given node"},"_getImage":{"!type":"fn()","!doc":"Returns the next image in the list, or the first one if not available"},"_enbiggen":{"!type":"fn(e: +Event)","!doc":"Show the passed node in the picker"},"_loadUnder":{"!type":"fn(info: ?, props: ?)","!doc":"figure out which three images are being covered, and\ndetermine if they need loaded or not"},"_disenbiggen":{"!type":"fn(info: ?, props: ?)","!doc":"Hide the passed node (info.n), passing along properties\nreceived."},"_cycle":{"!type":"fn(info: ?, props: ?)","!doc":"Select an un-viewed image from the list, and show it"}}},"FlickrBadge":{"!type":"fn()","prototype":{"!proto":"dojox.image.Badge.prototype","children":{"!type":"string"},"userid":{"!doc":"If you know your Flickr userid, you can set it to prevent a call to fetch the id","!type":"string"},"username":{"!doc":"Your Flickr username","!type":"string"},"setid":{"!doc":"The id of the set to display","!type":"string"},"tags":{"!type":"string"},"searchText":{"!doc":"Free text search.  Photos who's title, description, or tags contain the text will be displayed","!type":"string"},"target":{"!doc":"Where to display the pictures when clicked on.  Valid values are the same as the target attribute\nof the A tag.","!type":"string"},"apikey":{"!type":"string"},"_store":{},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"}}},"Gallery":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Gallery widget that wraps a dojox.image.ThumbnailPicker and dojox.image.SlideShow widget","imageHeight":{"!doc":"Maximum height of an image in the SlideShow widget","!type":"number"},"imageWidth":{"!doc":"Maximum width of an image in the SlideShow widget","!type":"number"},"autoLoad":{"!doc":"If true, images are loaded before the user views them. If false, an\nimage is loaded when the user displays it.","!type":"bool"},"linkAttr":{"!doc":"Defines the name of the attribute to request from the store to retrieve the\nURL to link to from an image, if any.","!type":"string"},"imageThumbAttr":{"!doc":"Defines the name of the attribute to request from the store to retrieve the\nURL to the thumbnail image.","!type":"string"},"imageLargeAttr":{"!doc":"Defines the name of the attribute to request from the store to retrieve the\nURL to the image.","!type":"string"},"titleAttr":{"!doc":"Defines the name of the attribute to request from the store to retrieve the\ntitle of the picture, if any.","!type":"string"},"slideshowInterval":{"!doc":"time in seconds, between image changes in the slide show.","!type":"+Integer"},"templatePath":{},"postCreate":{"!type":"fn()","!doc":"Initializes the widget, creates the ThumbnailPicker and SlideShow widgets"},"setDataStore":{"!type":"fn(dataStore: +An, request: +An, paramNames: +optional)","!doc":"Sets the data store and request objects to read data from."},"reset":{"!type":"fn()","!doc":"Resets the widget to its initial state"},"showNextImage":{"!type":"fn(inTimer: bool)","!doc":"Changes the image being displayed in the SlideShow to the next\nimage in the data store"},"toggleSlideshow":{"!type":"fn()","!doc":"Switches the slideshow mode on and off."},"showImage":{"!type":"fn(index: ?, callback: +optional)","!doc":"Shows the image at index 'idx'.\nidx: Number\nThe position of the image in the data store to display"},"_centerChildren":{"!type":"fn()","!doc":"Ensures that the ThumbnailPicker and the SlideShow widgets\nare centered."}},"pageSize":{"!doc":"The number of records to retrieve from the data store per request.","!type":"number"}},"Lightbox":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A dojo-based Lightbox implementation.","group":{"!doc":"Grouping images in a page with similar tags will provide a 'slideshow' like grouping of images","!type":"string"},"title":{"!doc":"A string of text to be shown in the Lightbox beneath the image (empty if using a store)","!type":"string"},"href":{"!type":"string"},"duration":{"!doc":"Generic time in MS to adjust the feel of widget. could possibly add various\ndurations for the various actions (dialog fadein, sizeing, img fadein ...)","!type":"+Integer"},"modal":{"!doc":"If true, this Dialog instance will be truly modal and prevent closing until\nexplicitly told to by calling hide() or clicking the (x) - Defaults to false\nto preserve previous behaviors. (aka: enable click-to-click on the underlay)","!type":"bool"},"_allowPassthru":{"!doc":"Privately set this to disable/enable natural link of anchor tags","!type":"bool"},"_attachedDialog":{},"startup":{"!type":"fn()"},"_addSelf":{"!type":"fn()","!doc":"Add this instance to the master LightBoxDialog"},"_handleClick":{"!type":"fn(e: +Event)","!doc":"Handle the click on the link"},"show":{"!type":"fn()","!doc":"Show the Lightbox with this instance as the starting point"},"hide":{"!type":"fn()","!doc":"Hide the Lightbox currently showing"},"disable":{"!type":"fn()","!doc":"Disables event clobbering and dialog, and follows natural link"},"enable":{"!type":"fn()","!doc":"Enables the dialog (prevents default link)"},"onClick":{"!type":"fn()","!doc":"Stub fired when the image in the lightbox is clicked."}}},"LightboxDialog":{"!type":"fn()","prototype":{"!proto":"dijit.Dialog.prototype","!doc":"The \"dialog\" shared  between any Lightbox instances on the page, publically available\nfor programatic manipulation.","title":{"!doc":"The current title, read from object passed to show()","!type":"string"},"inGroup":{"!doc":"Array of objects. this is populated by from the JSON object _groups, and\nshould not be populate manually. it is a placeholder for the currently\nshowing group of images in this master dialog","!type":"[]"},"errorMessage":{"!doc":"The text to display when an unreachable image is linked","!type":"string"},"adjust":{"!doc":"If true, ensure the image always stays within the viewport\nmore difficult than necessary to disable, but enabled by default\nseems sane in most use cases.","!type":"bool"},"modal":{"!doc":"If true, this Dialog instance will be truly modal and prevent closing until\nexplicitly told to by calling hide() or clicking the (x) - Defaults to false\nto preserve previous behaviors. (aka: enable click-to-click on the underlay)","!type":"bool"},"errorImg":{"!doc":"Path to the image used when a 404 is encountered\n\n\njanktastic solution to #8967","!type":"+Url"},"_fixSizes":{"!type":"bool"},"templatePath":{},"startup":{"!type":"fn()","!doc":"Add some extra event handlers, and startup our superclass."},"show":{"!type":"fn(groupData: ?)","!doc":"Show the Master Dialog. Starts the chain of events to show\nan image in the dialog, including showing the dialog if it is\nnot already visible"},"_ready":{"!type":"fn(src: ?)","!doc":"A function to trigger all 'real' showing of some src"},"_nextImage":{"!type":"fn()","!doc":"Load next image in group"},"_prevImage":{"!type":"fn()","!doc":"Load previous image in group"},"_loadImage":{"!type":"fn()","!doc":"Do the prep work before we can show another image"},"_prepNodes":{"!type":"fn()","!doc":"A localized hook to accompany _loadImage"},"resizeTo":{"!type":"fn(size: ?, forceTitle: ?)","!doc":"Resize our dialog container, and fire _showImage"},"_scaleToFit":{"!type":"fn(size: ?) -> ?","!doc":"resize an image to fit within the bounds of the viewport"},"_setImageSize":{"!type":"fn(size: ?)","!doc":"Reset the image size to some actual size."},"_size":{"!type":"fn()"},"_position":{"!type":"fn(e: +Event)","!doc":"we want to know the viewport size any time it changes"},"_showImage":{"!type":"fn()","!doc":"Fade in the image, and fire showNav"},"_showNav":{"!type":"fn()","!doc":"Fade in the footer, and setup our connections."},"hide":{"!type":"fn()","!doc":"Hide the Master Lightbox"},"addImage":{"!type":"fn(child: ?, group?: string)","!doc":"Add an image to this Master Lightbox"},"_handleKey":{"!type":"fn(e: +Event)","!doc":"Handle keyboard navigation internally"},"_makeAnims":{"!type":"fn()","!doc":"make and cleanup animation and animation connections"},"onClick":{"!type":"fn(groupData: ?)","!doc":"a stub function, called with the currently displayed image as the only argument"},"_onImageClick":{"!type":"fn(e: ?)"}},"imgUrl":{"!doc":"The src=&quot;&quot; attribute of our imageNode (can be null at statup)","!type":"string"},"_groups":{"XnoGroupX":{"!type":"[]"}}},"LightboxNano":{"!type":"fn()","prototype":{"!doc":"A simple \"nano\" version of the lightbox.","href":{"!doc":"URL to the large image to show in the lightbox.","!type":"string"},"duration":{"!doc":"The delay in milliseconds of the LightboxNano open and close animation.","!type":"number"},"preloadDelay":{"!doc":"The delay in milliseconds after the LightboxNano is created before preloading the larger image.","!type":"number"},"constructor":{"!type":"fn(p: ?, n: ?)","!doc":"Initializes the DOM node and connect onload event"},"destroy":{"!type":"fn()","!doc":"Destroys the LightboxNano and it's DOM node"},"_createDiv":{"!type":"fn(cssClass: string, refNode: +Node, display: bool) -> +Node","!doc":"Creates a div for the enlarge icon and loading indicator layers"},"_load":{"!type":"fn(e: +Event)","!doc":"Creates the large image and begins to show it"},"_hideLoading":{"!type":"fn()","!doc":"Hides the animated loading indicator"},"_show":{"!type":"fn()","!doc":"The image is now loaded, calculate size and display"},"_sizeBg":{"!type":"fn()","!doc":"Resize the background to fill the page"},"_key":{"!type":"fn(e: +Event)","!doc":"A key was pressed, so hide the lightbox"},"_coords":{"!type":"fn(s: ?, e: ?) -> ?","!doc":"Returns animation parameters with the start and end coords"},"_hide":{"!type":"fn()","!doc":"Closes the lightbox"},"_reset":{"!type":"fn()","!doc":"Destroys the lightbox"},"_anim":{"!type":"fn(node: ?, args: ?, onEnd: ?) -> +dojo.Animation","!doc":"Creates the lightbox open/close and background fadein/out animations"}}},"Magnifier":{"!type":"fn()","prototype":{"!proto":"dojox.image.MagnifierLite.prototype","!doc":"Adds magnification on a portion of an image element, using `dojox.gfx`","_createGlass":{"!type":"fn()","!doc":"create the glassNode, and an img on a dojox.gfx surface"},"_placeGlass":{"!type":"fn(e: ?)","!doc":"position the overlay centered under the cursor"},"_setImage":{"!type":"fn(e: ?)","!doc":"set the image's offset in the clipping window relative to the mouse position"}}},"MagnifierLite":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Adds magnification on a portion of an image element","glassSize":{"!doc":"the width and height of the bounding box","!type":"number"},"scale":{"!doc":"the multiplier of the Mangification.","!type":"+Decimal"},"postCreate":{"!type":"fn()"},"_createGlass":{"!type":"fn()","!doc":"make img and glassNode elements as children of the body"},"_adjustScale":{"!type":"fn()","!doc":"update the calculations should this.scale change"},"_showGlass":{"!type":"fn(e: ?)","!doc":"show the overlay"},"_hideGlass":{"!type":"fn(e: ?)","!doc":"hide the overlay"},"_placeGlass":{"!type":"fn(e: ?)","!doc":"position the overlay centered under the cursor"},"_setImage":{"!type":"fn(e: ?)","!doc":"set the image's offset in the clipping window relative to the mouse position"},"destroy":{"!type":"fn(finalize: ?)"}}},"SlideShow":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A Slideshow Widget","imageHeight":{"!doc":"The maximum height of an image","!type":"number"},"imageWidth":{"!doc":"The maximum width of an image.","!type":"number"},"title":{"!doc":"the initial title of the SlideShow","!type":"string"},"titleTemplate":{"!doc":"a way to customize the wording in the title. supported parameters to be populated are:\n${title} = the passed title of the image\n${current} = the current index of the image\n${total} = the total number of images in the SlideShow\n\nshould add more?","!type":"string"},"noLink":{"!doc":"Prevents the slideshow from putting an anchor link around the displayed image\nenables if true, though still will not link in absence of a url to link to","!type":"bool"},"loop":{"!doc":"true/false - make the slideshow loop","!type":"bool"},"hasNav":{"!doc":"toggle to enable/disable the visual navigation controls","!type":"bool"},"images":{"!doc":"Contains the DOM nodes that individual images are stored in when loaded or loading.","!type":"[]"},"pageSize":{"!doc":"The number of images to request each time.","!type":"number"},"autoLoad":{"!doc":"If true, then images are preloaded, before the user navigates to view them.\nIf false, an image is not loaded until the user views it.","!type":"bool"},"autoStart":{"!doc":"If true, the SlideShow begins playing immediately","!type":"bool"},"fixedHeight":{"!doc":"If true, the widget does not resize itself to fix the displayed image.","!type":"bool"},"imageStore":{"!doc":"Implementation of the dojo.data.api.Read API, which provides data on the images\nto be displayed."},"linkAttr":{"!doc":"Defines the name of the attribute to request from the store to retrieve the\nURL to link to from an image, if any.","!type":"string"},"imageLargeAttr":{"!doc":"Defines the name of the attribute to request from the store to retrieve the\nURL to the image.","!type":"string"},"titleAttr":{"!doc":"Defines the name of the attribute to request from the store to retrieve the\ntitle of the picture, if any.","!type":"string"},"slideshowInterval":{"!doc":"Time, in seconds, between image transitions during a slideshow.","!type":"number"},"templatePath":{},"_imageCounter":{"!doc":"A counter to keep track of which index image is to be loaded next","!type":"number"},"_tmpImage":{"!doc":"The temporary image to show when a picture is loading.","!type":"+Node"},"_request":{"!doc":"Implementation of the dojo.data.api.Request API, which defines the query\nparameters for accessing the store."},"postCreate":{"!type":"fn()","!doc":"Initilizes the widget, sets up listeners and shows the first image"},"setDataStore":{"!type":"fn(dataStore: +An, request: +An, paramNames: +optional)","!doc":"Sets the data store and request objects to read data from."},"reset":{"!type":"fn()","!doc":"Resets the widget to its initial state"},"isImageLoaded":{"!type":"fn(index: +The)","!doc":"Returns true if image at the specified index is loaded, false otherwise."},"moveImageLoadingPointer":{"!type":"fn(index: +The)","!doc":"If 'autoload' is true, this tells the widget to start loading\nimages from the specified pointer."},"destroy":{"!type":"fn()","!doc":"Cleans up the widget when it is being destroyed"},"showNextImage":{"!type":"fn(inTimer: bool, forceLoop: ?)","!doc":"Changes the image being displayed to the next image in the data store"},"toggleSlideShow":{"!type":"fn()","!doc":"Switches the slideshow mode on and off."},"getShowTopicName":{"!type":"fn()","!doc":"Returns the topic id published to when an image is shown"},"getLoadTopicName":{"!type":"fn()","!doc":"Returns the topic id published to when an image finishes loading."},"showImage":{"!type":"fn(index: number, callback?: fn())","!doc":"Shows the image at index 'index'."},"_fitSize":{"!type":"fn(force: bool)","!doc":"Fits the widget size to the size of the image being shown,\nor centers the image, depending on the value of 'fixedHeight'"},"_getTopPadding":{"!type":"fn()","!doc":"Returns the padding to place at the top of the image to center it vertically."},"_loadNextImage":{"!type":"fn()","!doc":"Load the next unloaded image."},"_loadImage":{"!type":"fn(index: +The, callbackFn: +An)","!doc":"Load image at specified index"},"_stop":{"!type":"fn()","!doc":"Stops a running slide show."},"_prev":{"!type":"fn()","!doc":"Show the previous image.\nFIXME: either pull code from showNext/prev, or call it here"},"_next":{"!type":"fn()","!doc":"Show the next image"},"_startTimer":{"!type":"fn()","!doc":"Starts a timeout to show the next image when a slide show is active"},"_calcNavDimensions":{"!type":"fn()","!doc":"Calculates the dimensions of the navigation controls"},"_setTitle":{"!type":"fn(title: string)","!doc":"Sets the title to the image being displayed"},"_fitImage":{"!type":"fn(img: +Node)","!doc":"Ensures that the image width and height do not exceed the maximum."},"_handleClick":{"!type":"fn(e: +Event)","!doc":"Performs navigation on the images based on users mouse clicks"},"_showNav":{"!type":"fn(force: bool)","!doc":"Shows the navigation controls"},"_hideNav":{"!type":"fn(e: +Event)","!doc":"Hides the navigation controls"},"_overElement":{"!type":"fn(element: +Node, e: +Event)","!doc":"Returns whether the mouse is over the passed element.\nElement must be display:block (ie, not a &lt;span&gt;)"}}},"ThumbnailPicker":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A scrolling Thumbnail Picker widget","imageStore":{"!doc":"A data store that implements the dojo.data Read API."},"request":{"!doc":"A dojo.data Read API Request object."},"size":{"!doc":"Width or height in pixels, depending if horizontal or vertical.\n\n\nFIXME: use CSS?","!type":"number"},"thumbHeight":{"!doc":"Default height of a thumbnail image\n\n\nFIXME: use CSS?","!type":"number"},"thumbWidth":{"!doc":"Default width of an image\n\n\nFIXME: use CSS?","!type":"number"},"useLoadNotifier":{"!doc":"Setting useLoadNotifier to true makes a colored DIV appear under each\nthumbnail image, which is used to display the loading status of each\nimage in the data store.","!type":"bool"},"useHyperlink":{"!doc":"Setting useHyperlink to true causes a click on a thumbnail to open a link.","!type":"bool"},"hyperlinkTarget":{"!doc":"If hyperlinkTarget is set to &quot;new&quot;, clicking on a thumb will open a new window\nIf it is set to anything else, clicking a thumbnail will open the url in the\ncurrent window.","!type":"string"},"isClickable":{"!doc":"When set to true, the cursor over a thumbnail changes.","!type":"bool"},"isScrollable":{"!doc":"When true, uses smoothScroll to move between pages","!type":"bool"},"isHorizontal":{"!doc":"If true, the thumbnails are displayed horizontally. Otherwise they are displayed\nvertically","!type":"bool"},"autoLoad":{"!type":"bool"},"linkAttr":{"!doc":"The attribute name for accessing the url from the data store","!type":"string"},"imageThumbAttr":{"!doc":"The attribute name for accessing the thumbnail image url from the data store","!type":"string"},"imageLargeAttr":{"!doc":"The attribute name for accessing the large image url from the data store","!type":"string"},"pageSize":{"!doc":"The number of images to request each time.","!type":"number"},"titleAttr":{"!doc":"The attribute name for accessing the title from the data store","!type":"string"},"templatePath":{},"_thumbs":{"!type":"[]"},"_thumbIndex":{"!doc":"The index of the first thumbnail shown","!type":"number"},"_maxPhotos":{"!doc":"The total number of photos in the image store","!type":"number"},"_loadedImages":{"!doc":"Stores the indices of images that have been marked as loaded using the\nmarkImageLoaded function."},"postCreate":{"!type":"fn()","!doc":"Initializes styles and listeners"},"init":{"!type":"fn()","!doc":"Creates DOM nodes for thumbnail images and initializes their listeners"},"getClickTopicName":{"!type":"fn() -> string","!doc":"Returns the name of the dojo topic that can be\nsubscribed to in order to receive notifications on\nwhich thumbnail was selected."},"getShowTopicName":{"!type":"fn() -> string","!doc":"Returns the name of the dojo topic that can be\nsubscribed to in order to receive notifications on\nwhich thumbnail is now visible"},"setDataStore":{"!type":"fn(dataStore: +An, request: +An, paramNames: +optional)","!doc":"Sets the data store and request objects to read data from."},"reset":{"!type":"fn()","!doc":"Resets the widget back to its original state."},"isVisible":{"!type":"fn(index: ?)","!doc":"Returns true if the image at the specified index is currently visible. False otherwise."},"_next":{"!type":"fn()","!doc":"Displays the next page of images"},"_prev":{"!type":"fn()","!doc":"Displays the next page of images"},"_checkLoad":{"!type":"fn(img: ?, index: ?)"},"_showThumbs":{"!type":"fn(index: number)","!doc":"Displays thumbnail images, starting at position 'index'"},"markImageLoaded":{"!type":"fn(index: ?)","!doc":"Changes a visual cue to show the image is loaded"},"_setThumbClass":{"!type":"fn(thumb: +Node, className: string)","!doc":"Adds a CSS class to a thumbnail, only if 'autoLoad' is true"},"_loadNextPage":{"!type":"fn()","!doc":"Loads the next page of thumbnail images"},"_loadImage":{"!type":"fn(data: ?, index: ?, callback: ?)"},"_updateNavControls":{"!type":"fn()","!doc":"Updates the navigation controls to hide/show them when at\nthe first or last images."}}}},"io":{"httpParse":{"!type":"fn(httpStream: string, topHeaders?: string, partial?: bool)","!doc":"Parses an HTTP stream for a message."},"__xhrContentArgs":{"!type":"fn()"},"__xhrMultiArgs":{"!type":"fn()"},"xhrMultiPart":{"!type":"fn(args: +dojox.io.__xhrMultiArgs)"},"xhrScriptPlugin":{"!type":"fn(url: string, callbackParamName: string, httpAdapter?: fn())","!doc":"Adds the script transport (JSONP) as an XHR plugin for the given site. See\ndojox.io.script for more information on the transport. Note, that JSONP\nis *not* a secure transport, by loading data from a third-party site using JSONP\nthe site has full access to your JavaScript environment."},"xhrWindowNamePlugin":{"!type":"fn(url: string, httpAdapter?: fn(), trusted?: bool)","!doc":"Adds the windowName transport as an XHR plugin for the given site. See\ndojox.io.windowName for more information on the transport."},"OAuth":{"__AccessorArgs":{"!type":"fn(key: string, secret: string)"},"__OAuthArgs":{"!type":"fn(consumer: +dojox.io.OAuth.__AccessorArgs, sig_method: string, token?: +dojox.io.OAuth.__AccessorArgs)"}},"proxy":{"xip":{"XhrIframeFacade":{"!type":"fn(ifpServerUrl: ?)","!doc":"XMLHttpRequest facade object used by dojox.io.proxy.xip.","prototype":{"open":{"!type":"fn(method: string, uri: string)"},"setRequestHeader":{"!type":"fn(header: string, value: string)"},"send":{"!type":"fn(stringData: string)"},"abort":{"!type":"fn()"},"getAllResponseHeaders":{"!type":"fn() -> string"},"getResponseHeader":{"!type":"fn(header: string) -> string"},"_setResponseHeaders":{"!type":"fn(allHeaders: string)"}}},"!doc":"Object that implements the iframe handling for XMLHttpRequest\nIFrame Proxying.","xipClientUrl":{},"urlLimit":{"!type":"number"},"_callbackName":{"!type":"string"},"_state":{},"_stateIdCounter":{"!type":"number"},"_isWebKit":{"!type":"bool"},"_xhrObjOld":{},"send":{"!type":"fn(facade: ?) -> ?","!doc":"starts the xdomain request using the provided facade.\nThis method first does some init work, then delegates to _realSend."},"_realSend":{"!type":"fn(facade: ?) -> ?","!doc":"starts the actual xdomain request using the provided facade."},"receive":{"!type":"fn(stateId: string, urlEncodedData: string)"},"frameLoaded":{"!type":"fn(stateId: string)"},"destroyState":{"!type":"fn(stateId: string)"},"createFacade":{"!type":"fn()"},"sendRequest":{"!type":"fn(stateId: ?, encodedData: ?)"},"sendRequestStart":{"!type":"fn(stateId: ?)"},"sendRequestPart":{"!type":"fn(stateId: ?)"},"setServerUrl":{"!type":"fn(stateId: ?, cmd: ?, message: ?)"},"makeServerUrl":{"!type":"fn(stateId: ?, cmd: ?, message: ?)"},"fragmentReceivedEvent":{"!type":"fn(evt: ?)","!doc":"HTML5 document messaging endpoint. Unpack the event to see\nif we want to use it."},"fragmentReceived":{"!type":"fn(frag: ?)"},"unpackMessage":{"!type":"fn(encodedMessage: ?)"}}},"scriptFrame":{"_waiters":{},"_loadedIds":{},"_getWaiters":{"!type":"fn(frameId: string)"},"_fixAttachUrl":{"!type":"fn(url: string)","!doc":"fixes the URL so that"},"_loaded":{"!type":"fn(frameId: string)","!doc":"callback used when waiting for a frame to load (related to the usage of\nthe frameId argument to dojo.io.script.get()."}},"windowName":{"_frameNum":{"!type":"number"},"send":{"!type":"fn(method: string, args: +dojo.__IoArgs)","!doc":"Provides secure cross-domain request capability.\nSends a request using an iframe (POST or GET) and reads the response through the\nframe's window.name."},"_send":{"!type":"fn(dfd: ?, method: ?, authTarget: ?, onAuthLoad: ?)"}},"xhrPlugins":{"plainXhr":{},"register":{"!type":"fn()","!doc":"overrides the default xhr handler to implement a registry of\nxhr handlers"},"addProxy":{"!type":"fn(proxyUrl: +This)","!doc":"adds a server side proxy xhr handler for cross-site URLs"},"addCrossSiteXhr":{"!type":"fn(url: +Requests, httpAdapter: +This)","!doc":"Adds W3C Cross site XHR or XDomainRequest handling for the given URL prefix"},"fullHttpAdapter":{"!type":"fn(plainXhr: ?, noRawBody: ?)","!doc":"Provides a HTTP adaption."}}},"jsonPath":{"_regularExpressions":{},"query":{"!type":"fn(obj: ?, expr: string, arg: ?)"}},"layout":{"BorderContainer":{},"ContentPane":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"cleans content to make it less likely to generate DOM/JS errors.","adjustPaths":{"!doc":"Adjust relative paths in html string content to point to this page.\nOnly useful if you grab content from a another folder then the current one","!type":"bool"},"cleanContent":{"!type":"bool"},"renderStyles":{"!doc":"trigger/load styles in the content","!type":"bool"},"executeScripts":{"!doc":"Execute (eval) scripts that is found in the content","!type":"bool"},"scriptHasHooks":{"!doc":"replace keyword '_container_' in scripts with 'dijit.byId(this.id)'\nNOTE this name might change in the near future","!type":"bool"},"ioArgs":{"!doc":"makes it possible to add custom args to xhrGet, like ioArgs.headers['X-myHeader'] = 'true'"},"onLoadDeferred":{"!doc":"callbackchain will start when onLoad occurs","!type":"+dojo.Deferred"},"onUnloadDeferred":{"!doc":"callbackchain will start when onUnload occurs\ncould put back _renderStyles by wrapping/aliasing dojox.html._ContentSetter.prototype._renderStyles","!type":"+dojo.Deferred"},"setHref":{"!type":"fn(url: ?) -> +dojox.layout.ContentPane.DeferredHandle","!doc":"replace current content with url's content"},"refresh":{"!type":"fn() -> +dojox.layout.ContentPane.DeferredHandle","!doc":"Sets up for a xhrLoad, load is deferred until widget is showing"},"constructor":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"onExecError":{"!type":"fn(e: ?)"},"_setContentAttr":{"!type":"fn(data: ?) -> +dojox.layout.ContentPane.DeferredHandle"},"cancel":{"!type":"fn()","!doc":"cancels a inflight download"},"_setUpDeferreds":{"!type":"fn()"},"_onLoadHandler":{"!type":"fn()"},"_onUnloadHandler":{"!type":"fn()"},"_onError":{"!type":"fn(type: ?, err: ?)"},"_setContent":{"!type":"fn(cont: ?)"}},"ioMethod":{"!doc":"reference to the method that should grab the content","!type":"+dojo.xhrGet"},"DeferredHandle":{"cancel":{"!type":"fn()","!doc":"cancel a in flight download"},"addOnLoad":{"!type":"fn(func: fn())","!doc":"add a callback to the onLoad chain"},"addOnUnload":{"!type":"fn(func: fn())","!doc":"add a callback to the onUnload chain"}}},"DragPane":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Makes a pane's content dragable by/within it's surface","invert":{"!doc":"Naturally, the behavior is to invert the axis of the drag.\nSetting invert:false will make the pane drag in the same\ndirection as the mouse.","!type":"bool"},"postCreate":{"!type":"fn()"},"_down":{"!type":"fn(e: ?)","!doc":"mousedown handler, start the dragging"},"_up":{"!type":"fn(e: ?)","!doc":"mouseup handler, stop the dragging"},"_move":{"!type":"fn(e: ?)","!doc":"mousemove listener, offset the scroll amount by the delta\nsince our last call."}}},"ExpandoPane":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"An experimental collapsing-pane for dijit.layout.BorderContainer","maxHeight":{"!type":"string"},"maxWidth":{"!type":"string"},"splitter":{"!type":"string"},"templatePath":{},"easeOut":{"!doc":"easing function used to hide pane","!type":"string"},"easeIn":{"!doc":"easing function use to show pane","!type":"string"},"duration":{"!doc":"duration to run show/hide animations","!type":"+Integer"},"startExpanded":{"!doc":"Does this widget start in an open (true) or closed (false) state","!type":"bool"},"baseClass":{"!type":"string"},"postCreate":{"!type":"fn()"},"_startupSizes":{"!type":"fn()"},"_afterResize":{"!type":"fn(e: ?)"},"_setupAnims":{"!type":"fn()","!doc":"Create the show and hide animations"},"toggle":{"!type":"fn()","!doc":"Toggle this pane's visibility"},"_hideWrapper":{"!type":"fn()","!doc":"Set the Expando state to &quot;closed&quot;"},"_showEnd":{"!type":"fn()","!doc":"Common animation onEnd code - &quot;unclose&quot;"},"_hideEnd":{"!type":"fn()","!doc":"Callback for the hide animation - &quot;close&quot;"},"resize":{"!type":"fn(psize?: ?)","!doc":"we aren't a layout widget, but need to act like one:"},"_trap":{"!type":"fn(e: ?)","!doc":"Trap stray events"}}},"FloatingPane":{"!type":"fn()","prototype":{"!proto":"dojox.layout.ContentPane.prototype","!doc":"A non-modal Floating window.","closable":{"!doc":"Allow closure of this Node","!type":"bool"},"dockable":{"!doc":"Allow minimizing of pane if true","!type":"bool"},"resizable":{"!doc":"Allow resizing of pane true if true","!type":"bool"},"maxable":{"!doc":"Horrible param name for &quot;Can you maximize this floating pane?&quot;","!type":"bool"},"resizeAxis":{"!doc":"One of: x | xy | y to limit pane's sizing direction","!type":"string"},"title":{"!doc":"Title to use in the header","!type":"string"},"dockTo":{"!doc":"if empty, will create private layout.Dock that scrolls with viewport\non bottom span of viewport.","!type":"+Node"},"duration":{"!doc":"Time is MS to spend toggling in/out node","!type":"+Integer"},"iconSrc":{"!doc":"[not implemented yet] will be either icon in titlepane to left\nof Title, and/or icon show when docked in a fisheye-like dock\nor maybe dockIcon would be better?","!type":"string"},"contentClass":{"!doc":"The className to give to the inner node which has the content","!type":"string"},"_showAnim":{},"_hideAnim":{},"_dockNode":{},"_restoreState":{},"_allFPs":{"!type":"[]"},"_startZ":{"!type":"number"},"templateString":{},"templatePath":{},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"setTitle":{"!type":"fn(title: string)","!doc":"Update the Title bar with a new string"},"close":{"!type":"fn()","!doc":"Close and destroy this widget"},"hide":{"!type":"fn(callback?: fn())","!doc":"Close, but do not destroy this FloatingPane"},"show":{"!type":"fn(callback?: fn())","!doc":"Show the FloatingPane"},"minimize":{"!type":"fn()","!doc":"Hide and dock the FloatingPane"},"maximize":{"!type":"fn()","!doc":"Make this FloatingPane full-screen (viewport)"},"_restore":{"!type":"fn()"},"_dock":{"!type":"fn()"},"resize":{"!type":"fn(dim: ?)","!doc":"Size the FloatingPane and place accordingly"},"bringToTop":{"!type":"fn()","!doc":"bring this FloatingPane above all other panes"},"destroy":{"!type":"fn()","!doc":"Destroy this FloatingPane completely"}}},"Dock":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget that attaches to a node and keeps track of incoming / outgoing FloatingPanes\nand handles layout","templateString":{"!type":"string"},"_docked":{"!type":"[]"},"_inPositioning":{"!type":"bool"},"autoPosition":{"!type":"bool"},"addNode":{"!type":"fn(refNode: ?)","!doc":"Instert a dockNode refernce into the dock"},"startup":{"!type":"fn()"},"_positionDock":{"!type":"fn(e?: +Event)"}}},"_DockNode":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"dojox.layout._DockNode is a private widget used to keep track of\nwhich pane is docked.","title":{"!doc":"Shown in dock icon. should read parent iconSrc?","!type":"string"},"paneRef":{"!doc":"reference to the FloatingPane we reprasent in any given dock","!type":"+dijit._Widget"},"templateString":{"!type":"string"},"restore":{"!type":"fn()","!doc":"remove this dock item from parent dock, and call show() on reffed floatingpane"}}},"GridContainer":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"The Grid Container is a container of child elements that are placed in a kind of grid.","templatePath":{},"isContainer":{"!type":"bool"},"i18n":{"!doc":"Contain i18n ressources."},"isAutoOrganized":{"!doc":"Define auto organisation of children into the grid container.","!type":"bool"},"isRightFixed":{"!doc":"Define if the right border has a fixed size.","!type":"bool"},"isLeftFixed":{"!doc":"Define if the left border has a fixed size.","!type":"bool"},"hasResizableColumns":{"!doc":"Allow or not resizing of columns by a grip handle.","!type":"bool"},"nbZones":{"!doc":"The number of dropped zones.","!type":"+Integer"},"opacity":{"!doc":"Define the opacity of the DnD Avatar.","!type":"+Integer"},"minColWidth":{"!doc":"Minimum column width in percentage.","!type":"+Integer"},"minChildWidth":{"!doc":"Minimun children with in pixel (only used for IE6 that doesn't handle min-width css property","!type":"+Integer"},"acceptTypes":{"!doc":"The gridcontainer will only accept the children that fit to the types.\nIn order to do that, the child must have a widgetType or a dndType attribute corresponding to the accepted type.","!type":"[]"},"mode":{"!doc":"location to add columns, must be set to left or right(default)","!type":"string"},"allowAutoScroll":{"!doc":"auto-scrolling enable inside the GridContainer","!type":"bool"},"timeDisplayPopup":{"!doc":"display time of popup in miliseconds","!type":"+Integer"},"isOffset":{"!doc":"if true : Let the mouse to its original location when moving (allow to specify it proper offset)\nif false : Current behavior, mouse in the upper left corner of the widget","!type":"bool"},"offsetDrag":{"!doc":"Allow to specify its own offset (x and y) onl when Parameter isOffset is true"},"withHandles":{"!doc":"Specify if there is a specific drag handle on widgets","!type":"bool"},"handleClasses":{"!doc":"Array of classes of nodes that will act as drag handles","!type":"[]"},"_draggedWidget":{},"_isResized":{"!doc":"Determine if user can resizing the widget with the mouse.","!type":"bool"},"_activeGrip":{},"_oldwidth":{"!doc":"Save the old width size.","!type":"+Integer"},"_oldheight":{"!doc":"Save the old height size.","!type":"+Integer"},"_a11yOn":{"!type":"bool"},"_canDisplayPopup":{"!type":"bool"},"constructor":{"!type":"fn(props: ?, node: ?)"},"postMixInProperties":{"!type":"fn()"},"_createCells":{"!type":"fn()"},"startup":{"!type":"fn()"},"init":{"!type":"fn()","!doc":"Initialization of the GridContainer widget"},"destroy":{"!type":"fn()","!doc":"destroy GridContainer Component."},"onResized":{"!type":"fn()","!doc":"Callback method to resize the GridContainer widget and columns"},"_organizeServices":{"!type":"fn()","!doc":"List all zones and insert service into columns."},"_organizeServicesManually":{"!type":"fn()","!doc":"Organize Services by column property of widget."},"_insertService":{"!type":"fn(z: +Integer, p: +Integer, i: +Integer, first: bool) -> string","!doc":"Insert a service in a specific column of the GridContainer widget."},"addService":{"!type":"fn(service: ?, z: +Integer, p: +Integer) -> ?","!doc":"Add a service (child widget) in a specific column of the GridContainer widget."},"_createGrid":{"!type":"fn() -> ?","!doc":"Create all grid (zones and grip)"},"_disconnectDnd":{"!type":"fn()","!doc":"disconnect all events on insertNodes"},"_createZone":{"!type":"fn(zone: ?)","!doc":"Create a DnD column."},"_createGrip":{"!type":"fn(dz: ?)","!doc":"Create a grip for a specific zone"},"_initPlaceGrips":{"!type":"fn()","!doc":"Initialize the position of a grip which will not change (top)"},"_placeGrips":{"!type":"fn()","!doc":"Define the position of a grip and place it on page."},"_getZoneByIndex":{"!type":"fn(n: +Integer) -> number","!doc":"Return a DOM node containing a zone by given a index."},"getIndexZone":{"!type":"fn(zone: +Node) -> number","!doc":"Return an integer by given a zone"},"resizeColumnOn":{"!type":"fn(e: +Event)","!doc":"Connect events to listen the resize action.\nChange the type of width columns (% to px)\nCalculate the minwidth according to the children"},"resizeColumnMove":{"!type":"fn(e: +Event)","!doc":"Change columns size."},"resizeColumnOff":{"!type":"fn(e: +Event)","!doc":"Disconnect resize events.\nChange the type of width columns (px to %)"},"setColumns":{"!type":"fn(nbColumns: +Integer)","!doc":"Set the number of columns"},"_addColumn":{"!type":"fn(nbColumns: +Integer)","!doc":"Add some columns"},"_deleteColumn":{"!type":"fn(indices: [])","!doc":"Remove some columns with indices passed as an array"},"_updateColumnsWidth":{"!type":"fn()","!doc":"Update the columns width."},"_selectFocus":{"!type":"fn(event: +Event)","!doc":"Enable a11y into the GridContainer :\n- Possibility to move focus into the GridContainer (TAB, LEFT ARROW, RIGHT ARROW, UP ARROW, DOWN ARROW).\n- Possibility to move GridContainer's children (Drag and Drop) with keyboard. (SHIFT +  ARROW).\nIf the type of widget is not draggable, a popup is displayed."},"_displayPopup":{"!type":"fn()","!doc":"display a popup when a widget type can not move"}}},"RadioGroup":{"!type":"fn()","prototype":{"!proto":"dijit.layout.StackContainer.prototype","!doc":"A Container that turns its Layout Children into a single Pane and transitions between states\nonHover of the button","duration":{"!doc":"used for Fade and Slide RadioGroup's, the duration to run the transition animation. does not affect anything\nin default RadioGroup","!type":"+Integer"},"hasButtons":{"!doc":"toggles internal button making on or off","!type":"bool"},"buttonClass":{"!doc":"The full declared className of the Button widget to use for hasButtons","!type":"string"},"templateString":{"!doc":"the template for our container","!type":"string"},"startup":{"!type":"fn()","!doc":"scan the container for children, and make &quot;tab buttons&quot; for them"},"_setupChild":{"!type":"fn(child: +dijit._Widget)","!doc":"Creates a hover button for a child node of the RadioGroup"},"removeChild":{"!type":"fn(child: ?)"},"_transition":{"!type":"fn(newWidget: +dijit._Widget, oldWidget: +dijit._Widget)","!doc":"called when StackContainer receives a selectChild call, used to transition the panes."},"_showChild":{"!type":"fn(page: +dijit._Widget)","!doc":"show the selected child widget"},"_hideChild":{"!type":"fn(page: +dijit._Widget)","!doc":"hide the specified child widget"}}},"RadioGroupFade":{"!type":"fn()","prototype":{"!proto":"dojox.layout.RadioGroup.prototype","!doc":"An extension on a stock RadioGroup, that fades the panes.","_hideChild":{"!type":"fn(page: ?)","!doc":"hide the specified child widget"},"_showChild":{"!type":"fn(page: ?)","!doc":"show the specified child widget"}}},"RadioGroupSlide":{"!type":"fn()","prototype":{"!proto":"dojox.layout.RadioGroup.prototype","!doc":"A Sliding Radio Group","zTop":{"!doc":"A z-index to apply to the incoming pane","!type":"+Integer"},"easing":{"!type":"fn()","!doc":"A hook to override the default easing of the pane slides."},"constructor":{"!type":"fn()"},"_positionChild":{"!type":"fn(page: ?)","!doc":"set the child out of view immediately after being hidden"},"_showChild":{"!type":"fn(page: ?)","!doc":"Slide in the selected child widget"},"_hideChild":{"!type":"fn(page: ?)","!doc":"reset the position of the hidden pane out of sight"}}},"_RadioButton":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"The Buttons for a RadioGroup","label":{"!doc":"the Text Label of the button","!type":"string"},"page":{},"templateString":{"!type":"string"},"startup":{"!type":"fn()","!doc":"start listening to mouseOver"},"_onMouse":{"!type":"fn(e: +Event)","!doc":"set the selected child on hover, and set our hover state class"},"_clearSelected":{"!type":"fn()","!doc":"remove hover state class from sibling Buttons. This is easier (and more reliable)\nthan setting up an additional connection to onMouseOut"}}},"ResizeHandle":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A dragable handle used to resize an attached node.","targetId":{"!doc":"id of the Widget OR DomNode that I will size","!type":"string"},"targetContainer":{"!doc":"over-ride targetId and attch this handle directly to a reference of a DomNode","!type":"+Node"},"resizeAxis":{"!doc":"one of: x|y|xy limit resizing to a single axis, default to xy ...","!type":"string"},"activeResize":{"!doc":"if true, node will size realtime with mouse movement,\nif false, node will create virtual node, and only resize target on mouseUp","!type":"bool"},"activeResizeClass":{"!doc":"css class applied to virtual resize node.","!type":"string"},"animateSizing":{"!doc":"only applicable if activeResize = false. onMouseup, animate the node to the\nnew size","!type":"bool"},"animateMethod":{"!doc":"one of &quot;chain&quot; or &quot;combine&quot; ... visual effect only. combine will &quot;scale&quot;\nnode to size, &quot;chain&quot; will alter width, then height","!type":"string"},"animateDuration":{"!doc":"time in MS to run sizing animation. if animateMethod=&quot;chain&quot;, total animation\nplaytime is 2*animateDuration","!type":"+Integer"},"minHeight":{"!doc":"smallest height in px resized node can be","!type":"+Integer"},"minWidth":{"!doc":"smallest width in px resize node can be","!type":"+Integer"},"constrainMax":{"!doc":"Toggle if this widget cares about the maxHeight and maxWidth\nparameters.","!type":"bool"},"maxHeight":{"!doc":"Largest height size in px the resize node can become.","!type":"+Integer"},"maxWidth":{"!doc":"Largest width size in px the reize node can become.","!type":"+Integer"},"fixedAspect":{"!doc":"Toggle to enable this widget to maintain the aspect\nratio of the attached node.","!type":"bool"},"intermediateChanges":{"!doc":"Toggle to enable/disable this widget from firing onResize\nevents at every step of a resize. If <code>activeResize</code> is true,\nand this is false, onResize only fires _after_ the drop\noperation. Animated resizing is not affected by this setting.","!type":"bool"},"templateString":{"!type":"string"},"postCreate":{"!type":"fn()","!doc":"setup our one major listener upon creation"},"_beginSizing":{"!type":"fn(e: +Event)","!doc":"setup movement listeners and calculate initial size"},"_updateSizing":{"!type":"fn(e: +Event)","!doc":"called when moving the ResizeHandle ... determines\nnew size based on settings/position and sets styles."},"_getNewCoords":{"!type":"fn(e: +Event) -> ?"},"_checkConstraints":{"!type":"fn(newW: ?, newH: ?) -> ?","!doc":"filter through the various possible constaint possibilities."},"_changeSizing":{"!type":"fn(e: +Event)","!doc":"apply sizing information based on information in (e) to attached node"},"_endSizing":{"!type":"fn(e: +Event)","!doc":"disconnect listenrs and cleanup sizing"},"onResize":{"!type":"fn(e: ?)","!doc":"Stub fired when sizing is done. Fired once\nafter resize, or often when <code>intermediateChanges</code> is\nset to true."}}},"_ResizeHelper":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A global private resize helper shared between any\n`dojox.layout.ResizeHandle` with activeSizing off.","show":{"!type":"fn()","!doc":"show helper to start resizing"},"hide":{"!type":"fn()","!doc":"hide helper after resizing is complete"},"resize":{"!type":"fn(dim: ?)","!doc":"size the widget and place accordingly"}}},"RotatorContainer":{"!type":"fn()","prototype":{"!proto":"dijit.layout.StackContainer.prototype","!doc":"Extends a StackContainer to automatically transition between children\nand display navigation in the form of tabs or a pager.","templateString":{"!type":"string"},"showTabs":{"!doc":"Sets the display of the tabs.  The tabs are actually a StackController.\nThe child's title is used for the tab's label.","!type":"bool"},"transitionDelay":{"!doc":"The delay in milliseconds before transitioning to the next child.","!type":"number"},"transition":{"!doc":"The type of transition to perform when switching children.\nA null transition will transition instantly.","!type":"string"},"transitionDuration":{"!doc":"The duration of the transition in milliseconds.","!type":"number"},"autoStart":{"!doc":"Starts the timer to transition children upon creation.","!type":"bool"},"suspendOnHover":{"!doc":"Pause the rotator when the mouse hovers over it.","!type":"bool"},"pauseOnManualChange":{"!doc":"Pause the rotator when the tab is changed or the pager's next/previous\nbuttons are clicked.","!type":"bool"},"reverse":{"!doc":"Causes the rotator to rotate in reverse order.","!type":"bool"},"pagerId":{"!doc":"ID the pager widget.","!type":"string"},"cycles":{"!doc":"Number of cycles before pausing.","!type":"number"},"_timer":{"!doc":"The timer used for controlling the transitions.","!type":"number"},"_over":{"!doc":"Flag to quick check if the mouse is over the rotator.","!type":"bool"},"_playing":{"!doc":"Flag to track transition state.","!type":"bool"},"pagerClass":{"!doc":"The declared Class of the Pager used for this Widget","!type":"string"},"postCreate":{"!type":"fn()","!doc":"Initializes the DOM nodes, tabs, and transition stuff."},"startup":{"!type":"fn()","!doc":"Initializes the pagers."},"destroy":{"!type":"fn()","!doc":"Unsubscribe to all of our topics"},"setAttribute":{"!type":"fn(attr: string, value: +anything)","!doc":"Exposes attributes to be changed."},"_updatePager":{"!type":"fn()","!doc":"Notify the pager's current and total numbers."},"_onMouseOver":{"!type":"fn()","!doc":"Triggered when the mouse is moved over the rotator container."},"_onMouseOut":{"!type":"fn()","!doc":"Triggered when the mouse is moved off the rotator container."},"_resetTimer":{"!type":"fn()","!doc":"Resets the timer used to start the next transition."},"_cycle":{"!type":"fn(next: bool)","!doc":"Cycles to the next/previous child."},"_manualChange":{"!type":"fn()","!doc":"This function is only called when a manual change occurs in which\ncase we may need to stop playing and we need to reset the cycle counter"},"_play":{"!type":"fn(skip: ?)","!doc":"Schedules the next transition."},"_pause":{"!type":"fn()","!doc":"Clears the transition timer and pauses the rotator."},"_state":{"!type":"fn(playing: ?)","!doc":"Fired when the play/pause pager button is toggled."},"_transition":{"!type":"fn(next: +dijit._Widget, prev: +dijit._Widget)","!doc":"Dispatches the appropriate transition."},"_transitionEnd":{"!type":"fn()"},"_fade":{"!type":"fn(next: +dijit._Widget, prev: +dijit._Widget)","!doc":"Crossfades two children."},"_styleNode":{"!type":"fn(node: +Node, opacity: number, zIndex: number)","!doc":"Helper function to style the children."}}},"RotatorPager":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Defines controls used to manipulate a RotatorContainer","widgetsInTemplate":{"!type":"bool"},"rotatorId":{"!doc":"The ID of the rotator this pager is tied to.\nOnly required if defined outside of the RotatorContainer's container.","!type":"number"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()","!doc":"Unsubscribe to all of our topics"},"_state":{"!type":"fn(playing: bool)","!doc":"Updates the display of the play/pause button"},"_update":{"!type":"fn(playing: bool, current: number, total: number)","!doc":"Updates the pager's play/pause button, current child, and total number of children."}}},"ScrollPane":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"A pane that \"scrolls\" its content based on the mouse poisition inside","_line":{"!doc":"storage for our top and bottom most scrollpoints","!type":"+dojo._Line"},"_lo":{"!doc":"height of the visible pane","!type":"+the"},"_offset":{"!type":"number"},"orientation":{"!doc":"either &quot;horizontal&quot; or &quot;vertical&quot; for scroll orientation.","!type":"string"},"autoHide":{"!type":"bool"},"templatePath":{},"resize":{"!type":"fn(size: ?)","!doc":"calculates required sizes. Call this if you add/remove content manually, or reload the content."},"postCreate":{"!type":"fn()"},"_set":{"!type":"fn(n: +Float)"},"_calc":{"!type":"fn(e: +Event)","!doc":"calculate the relative offset of the cursor over the node, and call _set"},"_enter":{"!type":"fn(e: ?)"},"_leave":{"!type":"fn(e: ?)"}}},"ToggleSplitter":{"!type":"fn()","prototype":{"!proto":"dijit.layout._Splitter.prototype","!doc":"A draggable and toggle-to-close/open spacer between two items in a BorderContainer","container":{},"child":{},"region":{},"open":{"!doc":"the initial and current state of the splitter (and its attached pane)","!type":"bool"},"closedThreshold":{"!doc":"how small the attached pane can be before its considered closed","!type":"+Integer"},"openSize":{"!doc":"the css height/width value to apply by default when the attached pane is open","!type":"string"},"_closedSize":{"!doc":"the css height/width value to apply by default when the attached pane is closed","!type":"string"},"templateString":{"!type":"string"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"_onMouseUp":{"!type":"fn(evt: ?)"},"_onPrelimMouseMove":{"!type":"fn(evt: ?)"},"_onMouseDown":{"!type":"fn(evt: ?)","!doc":"handle mousedown events from the domNode"},"_handleOnChange":{"!type":"fn()"},"_getStyleProps":{"!type":"fn(paneNode: ?, open: ?, paneStyle: ?)","!doc":"create an object with the style property name: values\nthat will need to be applied to the child pane render the given state"},"_setStateClass":{"!type":"fn()"},"_setOpenAttr":{"!type":"fn(value: bool)","!doc":"setter for the open property"},"onOpen":{"!type":"fn()"},"onClose":{"!type":"fn()"},"_toggleMe":{"!type":"fn(evt: ?)","!doc":"event handle, toggle the open state"},"_onKeyPress":{"!type":"fn(e: +Event)"}}},"dnd":{"Avatar":{"!type":"fn(manager: ?, opacity: ?)","!doc":"An Object, which represents the object being moved in a GridContainer","prototype":{"construct":{"!type":"fn(opacity: number)","!doc":"A constructor function. it is separate so it can be (dynamically)\noverwritten in case of need."},"destroy":{"!type":"fn()","!doc":"Destroy this avatar instance"},"update":{"!type":"fn()"},"_generateText":{"!type":"fn()"}}},"handdleIE":{"!type":"[]"},"_setGcDndHandle":{"!type":"fn(service: ?, withHandles: ?, handleClasses: ?, first: ?)"},"PlottedDnd":{"!type":"fn()","prototype":{"!proto":"dojo.dnd.Source.prototype","!doc":"dnd source handling plotted zone to show the dropping area","constructor":{"!type":"fn(node: +Node, params: ?)"},"_calculateCoords":{"!type":"fn(height: bool)","!doc":"Calculate each position of children"},"_legalMouseDown":{"!type":"fn(e: +Event) -> bool","!doc":"Checks if user clicked on &quot;approved&quot; items."},"setDndItemSelectable":{"!type":"fn(node: +Node, isSelectable: bool)","!doc":"set an item as selectable"},"getDraggedWidget":{"!type":"fn(node: +Node)","!doc":"Return one or more widget selected during the drag."},"isAccepted":{"!type":"fn(node: +Node)","!doc":"test if this node can be accepted"},"onDndStart":{"!type":"fn(source: ?, nodes: [], copy: ?)","!doc":"Called to initiate the DnD operation."},"onDndCancel":{"!type":"fn()","!doc":"Called to cancel the DnD operation."},"onDndDrop":{"!type":"fn(source: ?, nodes: ?, copy: ?, target: ?)","!doc":"Called to finish the DnD operation"},"onMouseDown":{"!type":"fn(e: +Event)","!doc":"Event processor for onmousedown."},"onMouseUp":{"!type":"fn(e: +Event)","!doc":"Event processor for onmouseup."},"onMouseMove":{"!type":"fn(e: ?)","!doc":"Event processor for onmousemove"},"_markTargetAnchor":{"!type":"fn(before: bool)","!doc":"Assigns a class to the current target anchor based on &quot;before&quot; status"},"_unmarkTargetAnchor":{"!type":"fn()","!doc":"Removes a class of the current target anchor based on &quot;before&quot; status."},"setIndicatorPosition":{"!type":"fn(e: +Event)","!doc":"set the position of the drop indicator"},"onOverEvent":{"!type":"fn()"},"onOutEvent":{"!type":"fn()"},"deleteDashedZone":{"!type":"fn()","!doc":"hide the dashed zone"},"insertDashedZone":{"!type":"fn(before: bool)","!doc":"Insert the dashed zone at the right place"},"insertNodes":{"!type":"fn(addSelected: bool, data: [], before: bool, anchor: +Node)","!doc":"Inserts new data items (see Dojo Container's insertNodes method for details)."},"_checkAutoScroll":{"!type":"fn(e: ?)"},"_autoScrollUp":{"!type":"fn(node: ?)"},"_autoScrollDown":{"!type":"fn(node: ?)"},"_stopAutoScroll":{"!type":"fn()"},"_sumAncestorProperties":{"!type":"fn(node: ?, prop: ?) -> +integer"}},"GC_OFFSET_X":{},"GC_OFFSET_Y":{}},"DropIndicator":{"!type":"fn()","prototype":{"!doc":"An empty widget to show at the user the drop zone of the widget.","constructor":{"!type":"fn(cn: string, tag: string)"},"isInserted":{"!type":"fn()"},"create":{"!type":"fn()"},"destroy":{"!type":"fn()"}}}},"ext-dijit":{"layout":{"StackContainer-touch":{}}}},"off":{"isOnline":{"!type":"bool"},"NET_CHECK":{"!type":"number"},"STORAGE_NAMESPACE":{"!type":"string"},"enabled":{"!type":"bool"},"availabilityURL":{},"goingOnline":{"!type":"bool"},"coreOpFailed":{"!type":"bool"},"doNetChecking":{"!type":"bool"},"hasOfflineCache":{},"browserRestart":{"!type":"bool"},"_STORAGE_APP_NAME":{},"_initializeCalled":{"!type":"bool"},"_storageLoaded":{"!type":"bool"},"_pageLoaded":{"!type":"bool"},"_common":{},"offline":{},"onLoad":{"!type":"fn()","!doc":"Called when Dojo Offline can be used."},"onNetwork":{"!type":"fn(type: string)","!doc":"Called when our on- or offline- status changes."},"initialize":{"!type":"fn()","!doc":"Called when a Dojo Offline-enabled application is finished\nconfiguring Dojo Offline, and is ready for Dojo Offline to\ninitialize itself."},"goOffline":{"!type":"fn()","!doc":"For advanced usage; most developers can ignore this.\nManually goes offline, away from the network."},"goOnline":{"!type":"fn(callback: fn())","!doc":"For advanced usage; most developers can ignore this.\nAttempts to go online."},"onFrameworkEvent":{"!type":"fn(type: string, saveData?: ?)","!doc":"For advanced usage; most developers can ignore this.\nA standard event handler that can be attached to to find out\nabout low-level framework events. Most developers will not need to\nattach to this method; it is meant for low-level information\nthat can be useful for updating offline user-interfaces in\nexceptional circumstances. The default Dojo Offline UI\nwidget takes care of most of these situations."},"_checkOfflineCacheAvailable":{"!type":"fn(callback: ?)"},"_onLoad":{"!type":"fn()"},"_onOfflineCacheChecked":{"!type":"fn()"},"_keepCheckingUntilInstalled":{"!type":"fn()"},"_finishStartingUp":{"!type":"fn()"},"_onPageLoad":{"!type":"fn()"},"_onStorageLoad":{"!type":"fn()"},"_isSiteAvailable":{"!type":"fn(callback: fn())","!doc":"Determines if our web application's website is available."},"_startNetworkThread":{"!type":"fn()"},"_getAvailabilityURL":{"!type":"fn()"},"_onOfflineCacheInstalled":{"!type":"fn()"},"_cacheDojoResources":{"!type":"fn()"},"_save":{"!type":"fn()","!doc":"Causes the Dojo Offline framework to save its configuration\ndata into local storage."},"_load":{"!type":"fn(callback: ?)","!doc":"Causes the Dojo Offline framework to load its configuration\ndata from local storage"},"sync":{"isSyncing":{"!type":"bool"},"cancelled":{"!type":"bool"},"successful":{"!type":"bool"},"details":{"!type":"[]"},"error":{"!type":"bool"},"actions":{},"autoSync":{"!type":"bool"},"onSync":{"!type":"fn(type: string)"},"synchronize":{"!type":"fn()","!doc":"Starts synchronizing"},"cancel":{"!type":"fn()","!doc":"Attempts to cancel this sync session"},"finishedDownloading":{"!type":"fn(successful?: bool, errorMessage?: string)","!doc":"Applications call this method from their\nafter getting a &quot;download&quot; event in\ndojox.off.sync.onSync to signal that\nthey are finished downloading any data\nthat should be available offline"},"start":{"!type":"fn()","!doc":"For advanced usage; most developers can ignore this.\nCalled at the start of the syncing process. Advanced\ndevelopers can over-ride this method to use their\nown sync mechanism to start syncing."},"refreshFiles":{"!type":"fn()","!doc":"For advanced usage; most developers can ignore this.\nCalled when we are going to refresh our list\nof offline files during syncing. Advanced developers\ncan over-ride this method to do some advanced magic related to\nrefreshing files."},"upload":{"!type":"fn()","!doc":"For advanced usage; most developers can ignore this.\nCalled when syncing wants to upload data. Advanced\ndevelopers can over-ride this method to completely\nthrow away the Action Log and replaying system\nand roll their own advanced sync mechanism if needed."},"download":{"!type":"fn()","!doc":"For advanced usage; most developers can ignore this.\nCalled when syncing wants to download data. Advanced\ndevelopers can over-ride this method to use their\nown sync mechanism."},"finished":{"!type":"fn()","!doc":"For advanced usage; most developers can ignore this.\nCalled when syncing is finished. Advanced\ndevelopers can over-ride this method to clean\nup after finishing their own sync\nmechanism they might have rolled."},"_save":{"!type":"fn(callback: ?)"},"_load":{"!type":"fn(callback: ?)"},"ActionLog":{"!type":"fn()","prototype":{"entries":{"!doc":"An array of our action entries, where each one is simply a custom\nobject literal that were passed to add() when this action entry\nwas added.","!type":"[]"},"reasonHalted":{"!doc":"If we halted, the reason why","!type":"string"},"isReplaying":{"!doc":"If true, we are in the middle of replaying a command log; if false,\nthen we are not","!type":"bool"},"autoSave":{"!doc":"Whether we automatically save the action log after each call to\nadd(); defaults to true. For applications that are rapidly adding\nmany action log entries in a short period of time, it can be\nuseful to set this to false and simply call save() yourself when\nyou are ready to persist your command log -- otherwise performance\ncould be slow as the default action is to attempt to persist the\nactions log constantly with calls to add().","!type":"bool"},"add":{"!type":"fn(action: ?)","!doc":"Adds an action to our action log"},"onReplay":{"!type":"fn(action: ?, actionLog: +dojox.off.sync.ActionLog)","!doc":"Called when we replay our log, for each of our action\nentries."},"length":{"!type":"fn()","!doc":"Returns the length of this\naction log"},"haltReplay":{"!type":"fn(reason: string)","!doc":"Halts replaying this command log."},"continueReplay":{"!type":"fn()","!doc":"Indicates that we should continue processing out list of\nactions."},"clear":{"!type":"fn()","!doc":"Completely clears this action log of its entries"},"replay":{"!type":"fn()","!doc":"For advanced usage; most developers can ignore this.\nReplays all of the commands that have been\ncached in this command log when we go back online;\nonCommand will be called for each command we have"},"onReplayFinished":{"!type":"fn()","!doc":"For advanced usage; most developers can ignore this.\nCalled when we are finished replaying our commands;\ncalled if we have successfully exhausted all of our\ncommands, or if an error occurred during replaying.\nThe default implementation simply continues the\nsynchronization process. Connect to this to register\nfor the event:\n\ndojo.connect(dojox.off.sync.actions, &quot;onReplayFinished&quot;,\nsomeFunc)"},"toString":{"!type":"fn()"},"_save":{"!type":"fn(callback: ?)"},"_load":{"!type":"fn(callback: ?)"}}}},"files":{"versionURL":{"!type":"string"},"listOfURLs":{"!type":"[]"},"refreshing":{"!type":"bool"},"_cancelID":{},"_error":{"!type":"bool"},"_errorMessages":{"!type":"[]"},"_currentFileIndex":{"!type":"number"},"_store":{},"_doSlurp":{"!type":"bool"},"slurp":{"!type":"fn()","!doc":"Autoscans the page to find all resources to\ncache. This includes scripts, images, CSS, and hyperlinks\nto pages that are in the same scheme/port/host as this\npage. We also scan the embedded CSS of any stylesheets\nto find @import statements and url()'s.\nYou should call this method from the top-level, outside of\nany functions and before the page loads:\n\n&lt;script&gt;\ndojo.require(&quot;dojox.sql&quot;);\ndojo.require(&quot;dojox.off&quot;);\ndojo.require(&quot;dojox.off.ui&quot;);\ndojo.require(&quot;dojox.off.sync&quot;);\n\n// configure how we should work offline\n\n// set our application name\ndojox.off.ui.appName = &quot;Moxie&quot;;\n\n// automatically &quot;slurp&quot; the page and\n// capture the resources we need offline\ndojox.off.files.slurp();\n\n// tell Dojo Offline we are ready for it to initialize itself now\n// that we have finished configuring it for our application\ndojox.off.initialize();\n&lt;/script&gt;\n\nNote that inline styles on elements are not handled (i.e.\nif you somehow have an inline style that uses a URL);\nobject and embed tags are not scanned since their format\ndiffers based on type; and elements created by JavaScript\nafter page load are not found. For these you must manually\nadd them with a dojox.off.files.cache() method call."},"cache":{"!type":"fn(urlOrList: string)","!doc":"Caches a file or list of files to be available offline. This\ncan either be a full URL, such as http://foobar.com/index.html,\nor a relative URL, such as ../index.html. This URL is not\nactually cached until dojox.off.sync.synchronize() is called."},"printURLs":{"!type":"fn()","!doc":"A helper function that will dump and print out\nall of the URLs that are cached for offline\navailability. This can help with debugging if you\nare trying to make sure that all of your URLs are\navailable offline"},"remove":{"!type":"fn(url: string)","!doc":"Removes a URL from the list of files to cache."},"isAvailable":{"!type":"fn(url: string)","!doc":"Determines whether the given resource is available offline."},"refresh":{"!type":"fn(callback: fn())","!doc":"For advanced usage; most developers can ignore this.\nRefreshes our list of offline resources,\nmaking them available offline."},"abortRefresh":{"!type":"fn()","!doc":"For advanced usage; most developers can ignore this.\nAborts and cancels a refresh."},"_slurp":{"!type":"fn()"},"_sameLocation":{"!type":"fn(url: ?)"},"_trimAnchor":{"!type":"fn(url: ?)"},"_doRefresh":{"!type":"fn(callback: ?, newVersion: ?)"},"_getVersionInfo":{"!type":"fn(callback: ?)"}},"ui":{"appName":{"!type":"string"},"autoEmbed":{"!type":"bool"},"autoEmbedID":{"!type":"string"},"runLink":{},"runLinkTitle":{"!type":"string"},"learnHowPath":{},"customLearnHowPath":{"!type":"bool"},"htmlTemplatePath":{},"cssTemplatePath":{},"onlineImagePath":{},"offlineImagePath":{},"rollerImagePath":{},"checkmarkImagePath":{},"learnHowJSPath":{},"_initialized":{"!type":"bool"},"onLoad":{"!type":"fn()","!doc":"A function that should be connected to allow your\napplication to know when Dojo Offline, the page, and\nthe Offline Widget are all initialized and ready to be\nused:\n\ndojo.connect(dojox.off.ui, &quot;onLoad&quot;, someFunc)"},"_initialize":{"!type":"fn()"},"_doAutoEmbed":{"!type":"fn()"},"_templateLoaded":{"!type":"fn(data: ?)"},"_testNet":{"!type":"fn()"},"_updateNetIndicator":{"!type":"fn()"},"_initLearnHow":{"!type":"fn()"},"_validateAppName":{"!type":"fn(appName: ?)"},"_updateSyncUI":{"!type":"fn()"},"_setSyncMessage":{"!type":"fn(message: ?)"},"_clearSyncMessage":{"!type":"fn()"},"_initImages":{"!type":"fn()"},"_showDetails":{"!type":"fn(evt: ?)"},"_cancel":{"!type":"fn(evt: ?)"},"_needsBrowserRestart":{"!type":"fn()"},"_showNeedsOfflineCache":{"!type":"fn()"},"_hideNeedsOfflineCache":{"!type":"fn()"},"_initMainEvtHandlers":{"!type":"fn()"},"_setOfflineEnabled":{"!type":"fn(enabled: ?)"},"_syncFinished":{"!type":"fn()"},"_onFrameworkEvent":{"!type":"fn(type: ?, saveData: ?)"},"_onSync":{"!type":"fn(type: ?)"},"_onNetwork":{"!type":"fn(type: string)","!doc":"Called when we go on- or off-line"}}},"robot":{"recorder":{}},"secure":{"badProps":{"!type":"+RegExp"},"DOM":{"!type":"fn(element: ?)"},"unwrap":{"!type":"fn(result: ?)"},"sandbox":{"!type":"fn(element: +The) -> +dojox.secure.__Sandbox","!doc":"Creates a secure sandbox from which scripts and HTML can be loaded that\nwill only be able to access the provided element and it's descendants, the\nrest of the DOM and JS environment will not be accessible to the sandboxed\nscripts and HTML."},"_safeDojoFunctions":{"!type":"fn(element: ?, wrap: ?)"},"capability":{"keywords":{"!type":"[]"},"validate":{"!type":"fn(script: string, safeLibraries: [], safeGlobals: ?)","!doc":"pass in the text of a script. If it passes and it can be eval'ed, it should be safe.\nNote that this does not do full syntax checking, it relies on eval to reject invalid scripts.\nThere are also known false rejections:\nNesting vars inside blocks will not declare the variable for the outer block\nNamed functions are not treated as declaration so they are generally not allowed unless the name is declared with a var.\nVar declaration that involve multiple comma delimited variable assignments are not accepted"}}},"sketch":{"tools":{},"Anchor":{"!type":"fn(an: ?, id: ?, isControl: ?)"},"registerTool":{"!type":"fn(type: ?, fn: ?)"},"makeToolbar":{"!type":"fn(node: ?, figure: ?)"},"AnnotationTool":{"!type":"fn()","prototype":{"!proto":"dojox.sketch._Plugin.prototype","onMouseDown":{"!type":"fn(e: ?)"},"onMouseMove":{"!type":"fn(e: ?, rect: ?)"},"onMouseUp":{"!type":"fn(e: ?)"},"_create":{"!type":"fn(start: ?, end: ?)"}}},"Annotation":{"!type":"fn(figure: ?, id: ?)","constructor":{},"type":{"!type":"fn()"},"getType":{"!type":"fn()"},"onRemove":{"!type":"fn(noundo: ?)"},"property":{"!type":"fn(name: ?, value)"},"onPropertyChange":{"!type":"fn(name: ?, oldvalue: ?)"},"onCreate":{"!type":"fn()"},"onDblClick":{"!type":"fn(e: ?)"},"initialize":{"!type":"fn()"},"destroy":{"!type":"fn()"},"draw":{"!type":"fn()"},"apply":{"!type":"fn(obj: ?)"},"serialize":{"!type":"fn()"},"getBBox":{"!type":"fn()"},"beginEdit":{"!type":"fn(type: ?)"},"endEdit":{"!type":"fn()"},"drawBBox":{"!type":"fn()"},"setBinding":{"!type":"fn(pt: ?)"},"getTextBox":{"!type":"fn(zoomfactor: ?)"},"setMode":{"!type":"fn(m: ?)"},"zoom":{"!type":"fn(pct: ?)"},"writeCommonAttrs":{"!type":"fn()"},"readCommonAttrs":{"!type":"fn(obj: ?)"},"register":{"!type":"fn(name: ?, toolclass: ?)"},"calculate":{"slope":{"!type":"fn(p1: ?, p2: ?)"},"dx":{"!type":"fn(p1: ?, p2: ?, dy: ?)"},"dy":{"!type":"fn(p1: ?, p2: ?, dx: ?)"}},"Modes":{"View":{"!type":"number"},"Edit":{"!type":"number"}}},"DoubleArrowAnnotation":{"!type":"fn(figure: ?, id: ?)","constructor":{},"type":{"!type":"fn()"},"getType":{"!type":"fn()"},"_rot":{"!type":"fn()"},"_pos":{"!type":"fn()"},"apply":{"!type":"fn(obj: ?)"},"initialize":{"!type":"fn(obj: ?)"},"destroy":{"!type":"fn()"},"draw":{"!type":"fn(obj: ?)"},"zoom":{"!type":"fn(pct: ?)"},"getBBox":{"!type":"fn()"},"serialize":{"!type":"fn()"}},"Figure":{"!type":"fn(mixin: ?)","getValue":{},"initUndoStack":{"!type":"fn()"},"setTool":{"!type":"fn(t: +dojox.sketch._Plugin)"},"_delete":{"!type":"fn(arr: ?, noundo: ?)"},"onDblClickShape":{"!type":"fn(shape: ?, e: ?)"},"onCreateShape":{"!type":"fn(shape: ?)"},"onBeforeCreateShape":{"!type":"fn(shape: ?)"},"initialize":{"!type":"fn(node: ?)"},"destroy":{"!type":"fn(isLoading: ?)"},"nextKey":{"!type":"fn()"},"draw":{"!type":"fn()"},"zoom":{"!type":"fn(pct: ?)"},"getFit":{"!type":"fn()"},"unzoom":{"!type":"fn()"},"_add":{"!type":"fn(obj: ?)"},"_remove":{"!type":"fn(obj: ?)"},"_get":{"!type":"fn(key: ?)"},"_keyFromEvt":{"!type":"fn(e: ?)"},"_fromEvt":{"!type":"fn(e: ?)"},"add":{"!type":"fn(annotation: ?)"},"remove":{"!type":"fn(annotation: ?)"},"get":{"!type":"fn(id: ?)"},"convert":{"!type":"fn(ann: ?, t: ?)"},"setValue":{"!type":"fn(text: ?)"},"load":{"!type":"fn(obj: ?, n: ?)"},"onLoad":{"!type":"fn()"},"onClick":{"!type":"fn()"},"_loadAnnotation":{"!type":"fn(obj: ?)"},"onUndo":{"!type":"fn()"},"onBeforeUndo":{"!type":"fn()"},"onRedo":{"!type":"fn()"},"onBeforeRedo":{"!type":"fn()"},"undo":{"!type":"fn()"},"redo":{"!type":"fn()"},"serialize":{"!type":"fn()"}},"LeadAnnotation":{"!type":"fn(figure: ?, id: ?)","constructor":{},"type":{"!type":"fn()"},"getType":{"!type":"fn()"},"_pos":{"!type":"fn()"},"apply":{"!type":"fn(obj: ?)"},"initialize":{"!type":"fn(obj: ?)"},"destroy":{"!type":"fn()"},"getBBox":{"!type":"fn()"},"draw":{"!type":"fn(obj: ?)"},"serialize":{"!type":"fn()"}},"PreexistingAnnotation":{"!type":"fn(figure: ?, id: ?)","constructor":{},"type":{"!type":"fn()"},"getType":{"!type":"fn()"},"_pos":{"!type":"fn()"},"apply":{"!type":"fn(obj: ?)"},"initialize":{"!type":"fn(obj: ?)"},"destroy":{"!type":"fn()"},"getBBox":{"!type":"fn()"},"draw":{"!type":"fn(obj: ?)"},"zoom":{"!type":"fn(pct: ?)"},"serialize":{"!type":"fn()"}},"SingleArrowAnnotation":{"!type":"fn(figure: ?, id: ?)","constructor":{},"type":{"!type":"fn()"},"getType":{"!type":"fn()"},"_rot":{"!type":"fn()"},"_pos":{"!type":"fn()"},"apply":{"!type":"fn(obj: ?)"},"initialize":{"!type":"fn(obj: ?)"},"destroy":{"!type":"fn()"},"draw":{"!type":"fn(obj: ?)"},"zoom":{"!type":"fn(pct: ?)"},"getBBox":{"!type":"fn()"},"serialize":{"!type":"fn()"}},"Slider":{"!type":"fn()","prototype":{"!proto":"dojox.sketch._Plugin.prototype","_initButton":{"!type":"fn()"},"_zoomToFit":{"!type":"fn()"},"_setZoom":{"!type":"fn(v: ?)"},"setToolbar":{"!type":"fn(t: ?)"}}},"ButtonGroup":{"!type":"fn()","prototype":{"constructor":{"!type":"fn()"},"add":{"!type":"fn(plugin: +_Plugin)"},"_resetGroup":{"!type":"fn(p: ?)"}}},"Toolbar":{"!type":"fn()","prototype":{"!proto":"dijit.Toolbar.prototype","figure":{},"plugins":{},"postCreate":{"!type":"fn()"},"destroy":{"!type":"fn()"},"addGroupItem":{"!type":"fn(item: +_Plugin, group: ?)"},"reset":{"!type":"fn()"},"_setShape":{"!type":"fn(s: ?)"}}},"UnderlineAnnotation":{"!type":"fn(figure: ?, id: ?)","constructor":{},"type":{"!type":"fn()"},"getType":{"!type":"fn()"},"apply":{"!type":"fn(obj: ?)"},"initialize":{"!type":"fn(obj: ?)"},"destroy":{"!type":"fn()"},"getBBox":{"!type":"fn()"},"draw":{"!type":"fn(obj: ?)"},"zoom":{"!type":"fn(pct: ?)"},"serialize":{"!type":"fn()"}},"UndoStack":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(figure: ?)"},"apply":{"!type":"fn(state: ?, from: ?, to: ?)"},"add":{"!type":"fn(cmd: string, ann?: +ta.Annotation, before?: string)"},"destroy":{"!type":"fn()"},"undo":{"!type":"fn()"},"redo":{"!type":"fn()"}}},"CommandTypes":{"Create":{"!type":"string"},"Move":{"!type":"string"},"Modify":{"!type":"string"},"Delete":{"!type":"string"},"Convert":{"!type":"string"}},"_Plugin":{"!type":"fn()","prototype":{"figure":{},"iconClassPrefix":{"!type":"string"},"itemGroup":{"!type":"string"},"button":{},"queryCommand":{},"shape":{"!type":"string"},"useDefaultCommand":{"!type":"bool"},"constructor":{"!type":"fn(args?: ?)"},"_initButton":{"!type":"fn()"},"attr":{"!type":"fn(name: ?, value)"},"onActivate":{"!type":"fn()"},"activate":{"!type":"fn(e)"},"onMouseDown":{"!type":"fn(e: ?)"},"onMouseMove":{"!type":"fn(e: ?)"},"onMouseUp":{"!type":"fn(e: ?)"},"destroy":{"!type":"fn(f: ?)"},"connect":{"!type":"fn(o: ?, f: ?, tf: ?)"},"setFigure":{"!type":"fn(figure: +dijit._Widget)"},"setToolbar":{"!type":"fn(toolbar: +dijit._Widget)"}},"buttonClass":{}}},"sql":{"dbName":{},"debug":{},"_base":{},"open":{"!type":"fn(dbName: ?)"},"close":{"!type":"fn(dbName: ?)"},"_exec":{"!type":"fn(params: ?)"},"_initDb":{"!type":"fn()"},"_printDebugSQL":{"!type":"fn(sql: ?, args: ?)"},"_normalizeResults":{"!type":"fn(rs: ?)"},"_needsEncrypt":{"!type":"fn(sql: ?)"},"_needsDecrypt":{"!type":"fn(sql: ?)"},"_SQLCrypto":{"!type":"fn()","prototype":{"!doc":"A private class encapsulating any cryptography that must be done\non a SQL statement. We instantiate this class and have it hold\nit's state so that we can potentially have several encryption\noperations happening at the same time by different SQL statements.","constructor":{"!type":"fn(action: ?, sql: ?, password: ?, args: ?, callback: ?)"},"_execEncryptSQL":{"!type":"fn(sql: ?, password: ?, args: ?, callback: ?)"},"_execDecryptSQL":{"!type":"fn(sql: ?, password: ?, args: ?, callback: ?)"},"_encrypt":{"!type":"fn(sql: ?, password: ?, args: ?, encryptColumns: ?, callback: ?)"},"_decrypt":{"!type":"fn(resultSet: ?, needsDecrypt: ?, password: ?, callback: ?)"},"_stripCryptoSQL":{"!type":"fn(sql: ?)"},"_flagEncryptedArgs":{"!type":"fn(sql: ?, args: ?)"},"_determineDecryptedColumns":{"!type":"fn(sql: ?)"},"_decryptSingleColumn":{"!type":"fn(columnName: ?, columnValue: ?, password: ?, currentRowIndex: ?, callback: ?)"}}},"_crypto":{"_POOL_SIZE":{"!type":"number"},"encrypt":{"!type":"fn(plaintext: ?, password: ?, callback: ?)","!doc":"Use Corrected Block TEA to encrypt plaintext using password\n(note plaintext &amp; password must be strings not string objects).\nResults will be returned to the 'callback' asychronously."},"decrypt":{"!type":"fn(ciphertext: ?, password: ?, callback: ?)","!doc":"Use Corrected Block TEA to decrypt ciphertext using password\n(note ciphertext &amp; password must be strings not string objects).\nResults will be returned to the 'callback' asychronously."},"_initWorkerPool":{"!type":"fn()"},"_assignWork":{"!type":"fn(msg: ?, callback: ?)"},"_workerHandler":{"!type":"fn(msg: ?, sender: ?)"}}},"storage":{"DEFAULT_NAMESPACE":{},"_common":{},"manager":{"!type":"fn()","!doc":"A singleton class in charge of the dojox.storage system"},"AirDBStorageProvider":{"!type":"fn()","prototype":{"!proto":"dojox.storage.Provider.prototype","DATABASE_FILE":{"!type":"string"},"TABLE_NAME":{"!type":"string"},"initialized":{"!type":"bool"},"_db":{},"initialize":{"!type":"fn()"},"_sql":{"!type":"fn(query: ?, params: ?)"},"_beginTransaction":{"!type":"fn()"},"_commitTransaction":{"!type":"fn()"},"isAvailable":{"!type":"fn()"},"put":{"!type":"fn(key: ?, value: ?, resultsHandler: ?, namespace: ?)"},"get":{"!type":"fn(key: ?, namespace: ?)"},"getNamespaces":{"!type":"fn()"},"getKeys":{"!type":"fn(namespace: ?)"},"clear":{"!type":"fn(namespace: ?)"},"remove":{"!type":"fn(key: ?, namespace: ?)"},"putMultiple":{"!type":"fn(keys: ?, values: ?, resultsHandler: ?, namespace: ?)"},"getMultiple":{"!type":"fn(keys: ?, namespace: ?)"},"removeMultiple":{"!type":"fn(keys: ?, namespace: ?)"},"isPermanent":{"!type":"fn()"},"getMaximumSize":{"!type":"fn()"},"hasSettingsUI":{"!type":"fn()"},"showSettingsUI":{"!type":"fn()"},"hideSettingsUI":{"!type":"fn()"}}},"AirEncryptedLocalStorageProvider":{"!type":"fn()","prototype":{"!proto":"dojox.storage.Provider.prototype","initialize":{"!type":"fn()"},"isAvailable":{"!type":"fn()"},"_getItem":{"!type":"fn(key: ?)"},"_setItem":{"!type":"fn(key: ?, value: ?)"},"_removeItem":{"!type":"fn(key: ?)"},"put":{"!type":"fn(key: ?, value: ?, resultsHandler: ?, namespace: ?)"},"get":{"!type":"fn(key: ?, namespace: ?)"},"getNamespaces":{"!type":"fn()"},"getKeys":{"!type":"fn(namespace: ?)"},"clear":{"!type":"fn(namespace: ?)"},"remove":{"!type":"fn(key: ?, namespace: ?)"},"putMultiple":{"!type":"fn(keys: ?, values: ?, resultsHandler: ?, namespace: ?)"},"getMultiple":{"!type":"fn(keys: ?, namespace: ?)"},"removeMultiple":{"!type":"fn(keys: ?, namespace: ?)"},"isPermanent":{"!type":"fn()"},"getMaximumSize":{"!type":"fn()"},"hasSettingsUI":{"!type":"fn()"},"showSettingsUI":{"!type":"fn()"},"hideSettingsUI":{"!type":"fn()"}}},"AirFileStorageProvider":{"!type":"fn()","prototype":{"!proto":"dojox.storage.Provider.prototype","initialized":{"!type":"bool"},"_storagePath":{"!type":"string"},"initialize":{"!type":"fn()"},"isAvailable":{"!type":"fn()"},"put":{"!type":"fn(key: ?, value: ?, resultsHandler: ?, namespace: ?)"},"get":{"!type":"fn(key: ?, namespace: ?)"},"getNamespaces":{"!type":"fn()"},"getKeys":{"!type":"fn(namespace: ?)"},"clear":{"!type":"fn(namespace: ?)"},"remove":{"!type":"fn(key: ?, namespace: ?)"},"putMultiple":{"!type":"fn(keys: ?, values: ?, resultsHandler: ?, namespace: ?)"},"getMultiple":{"!type":"fn(keys: ?, namespace: ?)"},"removeMultiple":{"!type":"fn(keys: ?, namespace: ?)"},"isPermanent":{"!type":"fn()"},"getMaximumSize":{"!type":"fn()"},"hasSettingsUI":{"!type":"fn()"},"showSettingsUI":{"!type":"fn()"},"hideSettingsUI":{"!type":"fn()"}}},"FlashStorageProvider":{"!type":"fn()","prototype":{"!proto":"dojox.storage.Provider.prototype","initialized":{"!type":"bool"},"_available":{},"_statusHandler":{},"_flashReady":{"!type":"bool"},"_pageReady":{"!type":"bool"},"initialize":{"!type":"fn()"},"setFlushDelay":{"!type":"fn(newDelay: ?)"},"getFlushDelay":{"!type":"fn()"},"flush":{"!type":"fn(namespace: ?)"},"isAvailable":{"!type":"fn()"},"put":{"!type":"fn(key: ?, value: ?, resultsHandler: ?, namespace: ?)"},"putMultiple":{"!type":"fn(keys: ?, values: ?, resultsHandler: ?, namespace: ?)"},"get":{"!type":"fn(key: ?, namespace: ?)"},"getMultiple":{"!type":"fn(keys: [], namespace?: string)"},"_destringify":{"!type":"fn(results: ?)"},"getKeys":{"!type":"fn(namespace: ?)"},"getNamespaces":{"!type":"fn()"},"clear":{"!type":"fn(namespace: ?)"},"remove":{"!type":"fn(key: ?, namespace: ?)"},"removeMultiple":{"!type":"fn(keys: [], namespace?: string)"},"isPermanent":{"!type":"fn()"},"getMaximumSize":{"!type":"fn()"},"hasSettingsUI":{"!type":"fn()"},"showSettingsUI":{"!type":"fn()"},"hideSettingsUI":{"!type":"fn()"},"getResourceList":{"!type":"fn()"},"_loaded":{"!type":"fn()"},"_onStatus":{"!type":"fn(statusResult: ?, key: ?, namespace: ?)"}}},"GearsStorageProvider":{"!type":"fn()","prototype":{"!proto":"dojox.storage.Provider.prototype","!doc":"Storage provider that uses the features of Google Gears\nto store data (it is saved into the local SQL database\nprovided by Gears, using dojox.sql)","TABLE_NAME":{"!type":"string"},"initialized":{"!type":"bool"},"_available":{},"_storageReady":{"!type":"bool"},"constructor":{"!type":"fn()"},"initialize":{"!type":"fn()"},"isAvailable":{"!type":"fn()"},"put":{"!type":"fn(key: ?, value: ?, resultsHandler: ?, namespace: ?)"},"get":{"!type":"fn(key: ?, namespace: ?)"},"getNamespaces":{"!type":"fn()"},"getKeys":{"!type":"fn(namespace: ?)"},"clear":{"!type":"fn(namespace: ?)"},"remove":{"!type":"fn(key: ?, namespace: ?)"},"putMultiple":{"!type":"fn(keys: ?, values: ?, resultsHandler: ?, namespace: ?)"},"getMultiple":{"!type":"fn(keys: ?, namespace: ?)"},"removeMultiple":{"!type":"fn(keys: ?, namespace: ?)"},"isPermanent":{"!type":"fn()"},"getMaximumSize":{"!type":"fn()"},"hasSettingsUI":{"!type":"fn()"},"showSettingsUI":{"!type":"fn()"},"hideSettingsUI":{"!type":"fn()"},"_initStorage":{"!type":"fn()"}}},"Provider":{"!type":"fn()","prototype":{"!doc":"A singleton for working with dojox.storage.","SUCCESS":{"!doc":"Flag that indicates a put() call to a\nstorage provider was succesful.","!type":"string"},"FAILED":{"!doc":"Flag that indicates a put() call to\na storage provider failed.","!type":"string"},"PENDING":{"!doc":"Flag that indicates a put() call to a\nstorage provider is pending user approval.","!type":"string"},"SIZE_NOT_AVAILABLE":{"!doc":"Returned by getMaximumSize() if this storage provider can not determine\nthe maximum amount of data it can support.","!type":"string"},"SIZE_NO_LIMIT":{"!doc":"Returned by getMaximumSize() if this storage provider has no theoretical\nlimit on the amount of data it can store.","!type":"string"},"DEFAULT_NAMESPACE":{"!doc":"The namespace for all storage operations. This is useful if several\napplications want access to the storage system from the same domain but\nwant different storage silos.","!type":"string"},"constructor":{"!type":"fn()"},"onHideSettingsUI":{"!type":"fn()","!doc":"If a function is assigned to this property, then when the settings\nprovider's UI is closed this function is called. Useful, for example,\nif the user has just cleared out all storage for this provider using\nthe settings UI, and you want to update your UI."},"initialize":{"!type":"fn()","!doc":"Allows this storage provider to initialize itself. This is\ncalled after the page has finished loading, so you can not do\ndocument.writes(). Storage Provider subclasses should initialize\nthemselves inside of here rather than in their function\nconstructor."},"isAvailable":{"!type":"fn()","!doc":"Returns whether this storage provider is available on this\nplatform."},"put":{"!type":"fn(key: string, value: ?, resultsHandler: fn, namespace?: string)","!doc":"Puts a key and value into this storage system."},"get":{"!type":"fn(key: string, namespace?: string)","!doc":"Gets the value with the given key. Returns null if this key is\nnot in the storage system."},"hasKey":{"!type":"fn(key: string, namespace?: string) -> bool","!doc":"Determines whether the storage has the given key."},"getKeys":{"!type":"fn(namespace?: string)","!doc":"Enumerates all of the available keys in this storage system.\nreturn: Array of available keys"},"clear":{"!type":"fn(namespace?: string)","!doc":"Completely clears this storage system of all of it's values and\nkeys. If 'namespace' is provided just clears the keys in that\nnamespace."},"remove":{"!type":"fn(key: string, namespace?: string)","!doc":"Removes the given key from this storage system."},"getNamespaces":{"!type":"fn()"},"isPermanent":{"!type":"fn()","!doc":"Returns whether this storage provider's values are persisted\nwhen this platform is shutdown."},"getMaximumSize":{"!type":"fn()","!doc":"The maximum storage allowed by this provider"},"putMultiple":{"!type":"fn(keys: [], values: [], resultsHandler: fn, namespace?: string)","!doc":"Puts multiple keys and values into this storage system."},"getMultiple":{"!type":"fn(keys: [], namespace?: string)","!doc":"Gets the valuse corresponding to each of the given keys.\nReturns a null array element for each given key that is\nnot in the storage system."},"removeMultiple":{"!type":"fn(keys: [], namespace?: string)","!doc":"Removes the given keys from this storage system."},"isValidKeyArray":{"!type":"fn(keys: ?)"},"hasSettingsUI":{"!type":"fn()","!doc":"Determines whether this provider has a settings UI."},"showSettingsUI":{"!type":"fn()","!doc":"If this provider has a settings UI, determined\nby calling hasSettingsUI(), it is shown."},"hideSettingsUI":{"!type":"fn()","!doc":"If this provider has a settings UI, hides it."},"isValidKey":{"!type":"fn(keyName: string)","!doc":"Subclasses can call this to ensure that the key given is valid\nin a consistent way across different storage providers. We use\nthe lowest common denominator for key values allowed: only\nletters, numbers, and underscores are allowed. No spaces."},"getResourceList":{"!type":"fn()","!doc":"Returns a list of URLs that this\nstorage provider might depend on."}}},"WhatWGStorageProvider":{"!type":"fn()","prototype":{"!proto":"dojox.storage.Provider.prototype","!doc":"Storage provider that uses WHAT Working Group features in Firefox 2\nto achieve permanent storage.","initialized":{"!type":"bool"},"_domain":{},"_available":{},"_statusHandler":{},"_allNamespaces":{},"_storageEventListener":{},"initialize":{"!type":"fn()"},"isAvailable":{"!type":"fn()"},"put":{"!type":"fn(key: ?, value: ?, resultsHandler: ?, namespace: ?)"},"get":{"!type":"fn(key: ?, namespace: ?)"},"getNamespaces":{"!type":"fn()"},"getKeys":{"!type":"fn(namespace: ?)"},"clear":{"!type":"fn(namespace: ?)"},"remove":{"!type":"fn(key: ?, namespace: ?)"},"isPermanent":{"!type":"fn()"},"getMaximumSize":{"!type":"fn()"},"hasSettingsUI":{"!type":"fn()"},"showSettingsUI":{"!type":"fn()"},"hideSettingsUI":{"!type":"fn()"},"getFullKey":{"!type":"fn(key: ?, namespace: ?)"},"_getDomain":{"!type":"fn()"}}}},"string":{"BidiComplex":{"attachInput":{"!type":"fn(field: +Node, pattern: string)","!doc":"Attach key listeners to the INPUT field to accomodate dynamic complex BiDi expressions"},"createDisplayString":{"!type":"fn(str: string, pattern: string)","!doc":"Create the display string by adding the Unicode direction Markers"},"stripSpecialCharacters":{"!type":"fn(str: ?) -> string","!doc":"removes all Unicode directional markers from the string"},"_ceKeyDown":{"!type":"fn(event: ?)"},"_ceKeyUp":{"!type":"fn(event: ?)"},"_processCopy":{"!type":"fn(elem: ?, text: ?, isReverse: ?)","!doc":"This function strips the unicode directional controls when the text copied to the Clipboard"},"_ceCopyText":{"!type":"fn(elem: ?)"},"_ceCutText":{"!type":"fn(elem: ?)"},"_getCaretPos":{"!type":"fn(event: ?, elem: ?)"},"_setSelectedRange":{"!type":"fn(elem: ?, selectionStart: ?, selectionEnd: ?)"},"_parse":{"!type":"fn(str: string, pattern: string)"}},"Builder":{"!type":"fn(str?: string) -> +dojox.string.Builder","!doc":"A fast buffer for creating large strings.\n\nlength: Number\nThe current length of the internal string."},"tokenize":{"!type":"fn(str: string, re: +RegExp, parseDelim?: fn(), instance?: ?)","!doc":"Split a string by a regular expression with the ability to capture the delimeters"},"sprintf":{"Formatter":{"!type":"fn(format: string)","prototype":{"_re":{"!type":"+RegExp"},"_zeros10":{"!type":"string"},"_spaces10":{"!type":"string"},"_parseDelim":{"!type":"fn(mapping: ?, intmapping: ?, flags: ?, minWidth: ?, period: ?, precision: ?, specifier: ?)"},"format":{"!type":"fn(filler: +mixed)"},"formatInt":{"!type":"fn(token: ?)"},"formatDouble":{"!type":"fn(token: ?)"},"zeroPad":{"!type":"fn(token: ?, length: number)"},"fitField":{"!type":"fn(token: ?)"},"spacePad":{"!type":"fn(token: ?, length: number)"}},"_specifiers":{"b":{"base":{"!type":"number"},"isInt":{"!type":"bool"}},"o":{"base":{"!type":"number"},"isInt":{"!type":"bool"}},"x":{"base":{"!type":"number"},"isInt":{"!type":"bool"}},"X":{"extend":{"!type":"[]"},"toUpper":{"!type":"bool"}},"d":{"base":{"!type":"number"},"isInt":{"!type":"bool"}},"i":{"extend":{"!type":"[]"}},"u":{"extend":{"!type":"[]"},"isUnsigned":{"!type":"bool"}},"c":{"setArg":{"!type":"fn(token: ?)"}},"s":{"setMaxWidth":{"!type":"fn(token: ?)"}},"e":{"isDouble":{"!type":"bool"},"doubleNotation":{"!type":"string"}},"E":{"extend":{"!type":"[]"},"toUpper":{"!type":"bool"}},"f":{"isDouble":{"!type":"bool"},"doubleNotation":{"!type":"string"}},"F":{"extend":{"!type":"[]"}},"g":{"isDouble":{"!type":"bool"},"doubleNotation":{"!type":"string"}},"G":{"extend":{"!type":"[]"},"toUpper":{"!type":"bool"}}}},"!type":"fn(format: string, filler: +mixed)"}},"testing":{"DocTest":{"!type":"fn()","prototype":{"!doc":"This class executes doctests.","errors":{"!type":"[]"},"getTests":{"!type":"fn(moduleName: string)","!doc":"Extract the tests from the given module or string.\nexamples:\n&gt;&gt;&gt; dojo.isArray(new dojox.testing.DocTest().getTests(&quot;dojox.testing.DocTest&quot;)) // Use the module name to extract the tests from.\ntrue"},"getTestsFromString":{"!type":"fn(data: string)"},"_getTestsFromString":{"!type":"fn(data: string, insideComments: bool)","!doc":"Parse the given string for tests."},"run":{"!type":"fn(moduleName: ?)","!doc":"Run the doctests in the module given."},"_run":{"!type":"fn(tests: [])","!doc":"Each element in the array contains the test in the first element,\nand the expected result in the second element."},"runTest":{"!type":"fn(commands: ?, expected: ?)"}}}},"timing":{"ThreadPool":{},"_base":{},"Streamer":{"!type":"fn(input: fn, output: fn, interval: number, minimum: number, initialData: [])"},"Thread":{"!type":"fn(fn: fn(), priority?: +dojox.timing.threadPriorities)"},"Sequence":{"!type":"fn()","prototype":{"!doc":"This class provides functionality to really sequentialize\nfunction calls. You need to provide a list of functions and\nsome parameters for each (like: pauseBefore) and they will\nbe run one after another. This can be very useful for slideshows\nor alike things.","_defsResolved":{"!doc":"The resolved sequence, for easier handling.","!type":"[]"},"_goOnPause":{"!doc":"The pause to wait before really going on.","!type":"+Integer"},"_running":{"!type":"bool"},"constructor":{"!type":"fn()"},"go":{"!type":"fn(defs: [], doneFunction?: fn())","!doc":"Run the passed sequence definition"},"_go":{"!type":"fn()","!doc":"Execute one task of this._defsResolved."},"goOn":{"!type":"fn()","!doc":"This method just provides a hook from the outside, so that\nan interrupted sequence can be continued."},"stop":{"!type":"fn()","!doc":"Stop the currently running sequence."}}},"threadStates":{"UNSTARTED":{"!type":"string"},"STOPPED":{"!type":"string"},"PENDING":{"!type":"string"},"RUNNING":{"!type":"string"},"SUSPENDED":{"!type":"string"},"WAITING":{"!type":"string"},"COMPLETE":{"!type":"string"},"ERROR":{"!type":"string"}},"threadPriorities":{"LOWEST":{"!type":"number"},"BELOWNORMAL":{"!type":"number"},"NORMAL":{"!type":"number"},"ABOVENORMAL":{"!type":"number"},"HIGHEST":{"!type":"number"}},"Timer":{"!type":"fn(interval: number)","!doc":"Timer object executes an &quot;onTick()&quot; method repeatedly at a specified interval.\nrepeatedly at a given interval.","prototype":{"onTick":{"!type":"fn()","!doc":"Method called every time the interval passes.  Override to do something useful."},"setInterval":{"!type":"fn(interval: +New)","!doc":"Reset the interval of a timer, whether running or not."},"start":{"!type":"fn()","!doc":"Start the timer ticking."},"stop":{"!type":"fn()","!doc":"Stop the timer."}}},"doLater":{"!type":"fn(conditional: +anything, context: ?, interval: number) -> bool","!doc":"Check if a parameter is ready, and if not,\n&quot;do later&quot;. doLater will ping the parameter\nuntil it evaluates to something (truthy).\nIt thens calls the caller with original\narguments, using the supplied context or\nwindow.","caller":{"arguments":{}}}},"uuid":{"NIL_UUID":{"!type":"string"},"_ourVariantLookupTable":{},"_base":{},"assert":{"!type":"fn(booleanValue: bool, message?: string)","!doc":"Throws an exception if the assertion fails."},"generateNilUuid":{"!type":"fn() -> string","!doc":"This function returns the Nil UUID: &quot;00000000-0000-0000-0000-000000000000&quot;."},"isValid":{"!type":"fn(uuidString: string) -> bool","!doc":"Returns true if the UUID was initialized with a valid value."},"getVariant":{"!type":"fn(uuidString: string) -> +dojox.uuid.variant","!doc":"Returns a variant code that indicates what type of UUID this is.\nReturns one of the enumerated dojox.uuid.variant values."},"getVersion":{"!type":"fn(uuidString: string) -> +dojox.uuid.version","!doc":"Returns a version number that indicates what type of UUID this is.\nReturns one of the enumerated dojox.uuid.version values."},"getNode":{"!type":"fn(uuidString: string)","!doc":"If this is a version 1 UUID (a time-based UUID), getNode() returns a\n12-character string with the &quot;node&quot; or &quot;pseudonode&quot; portion of the UUID,\nwhich is the rightmost 12 characters."},"getTimestamp":{"!type":"fn(uuidString: string, returnType?: string) -> +Date","!doc":"If this is a version 1 UUID (a time-based UUID), this method returns\nthe timestamp value encoded in the UUID.  The caller can ask for the\ntimestamp to be returned either as a JavaScript Date object or as a\n15-character string of hex digits."},"generateRandomUuid":{"!type":"fn() -> string","!doc":"This function generates random UUIDs, meaning &quot;version 4&quot; UUIDs."},"Uuid":{"!type":"fn(input?: string)","!doc":"This is the constructor for the Uuid class.  The Uuid class offers\nmethods for inspecting existing UUIDs.","_ourGenerator":{},"compare":{"!type":"fn(uuidOne: +dojox.uuid.Uuid, uuidTwo: +dojox.uuid.Uuid, otherUuid: +dojox.uuid.Uuid) -> +integer","!doc":"Compares this UUID to another UUID, and returns 0, 1, or -1."},"setGenerator":{"!type":"fn(generator?: fn())","!doc":"Sets the default generator, which will be used by the\n&quot;new dojox.uuid.Uuid()&quot; constructor if no parameters\nare passed in."},"getGenerator":{"!type":"fn()","!doc":"Returns the default generator.  See setGenerator()."},"toString":{"!type":"fn() -> string","!doc":"This method returns a standard 36-character string representing\nthe UUID, such as &quot;3b12f1df-5232-4804-897e-917bf397618a&quot;."},"isEqual":{"!type":"fn(otherUuid: +dojox.uuid.Uuid) -> bool","!doc":"Returns true if this UUID is equal to the otherUuid, or false otherwise."},"isValid":{"!type":"fn()","!doc":"Returns true if the UUID was initialized with a valid value."},"getVariant":{"!type":"fn()","!doc":"Returns a variant code that indicates what type of UUID this is.\nReturns one of the enumerated dojox.uuid.variant values."},"getVersion":{"!type":"fn() -> +dojox.uuid.version","!doc":"Returns a version number that indicates what type of UUID this is.\nReturns one of the enumerated dojox.uuid.version values."},"getNode":{"!type":"fn()","!doc":"If this is a version 1 UUID (a time-based UUID), getNode() returns a\n12-character string with the &quot;node&quot; or &quot;pseudonode&quot; portion of the UUID,\nwhich is the rightmost 12 characters."},"getTimestamp":{"!type":"fn(returnType?: string) -> +Date","!doc":"If this is a version 1 UUID (a time-based UUID), this method returns\nthe timestamp value encoded in the UUID.  The caller can ask for the\ntimestamp to be returned either as a JavaScript Date object or as a\n15-character string of hex digits."}},"version":{"UNKNOWN":{"!type":"number"},"TIME_BASED":{"!type":"number"},"DCE_SECURITY":{"!type":"number"},"NAME_BASED_MD5":{"!type":"number"},"RANDOM":{"!type":"number"},"NAME_BASED_SHA1":{"!type":"number"}},"variant":{"NCS":{"!type":"string"},"DCE":{"!type":"string"},"MICROSOFT":{"!type":"string"},"UNKNOWN":{"!type":"string"}},"generateTimeBasedUuid":{"!type":"fn(node?: string) -> string","!doc":"This function generates time-based UUIDs, meaning &quot;version 1&quot; UUIDs.","_generator":{},"isValidNode":{"!type":"fn(node?: string) -> bool"},"setNode":{"!type":"fn(node?: string)","!doc":"Sets the 'node' value that will be included in generated UUIDs."},"getNode":{"!type":"fn()","!doc":"Returns the 'node' value that will be included in generated UUIDs."}}},"validate":{"_isInRangeCache":{},"_base":{},"creditCard":{"!doc":"Module provides validation functions for Credit Cards, using account number\nrules in conjunction with the Luhn algorigthm, with a plugable card info database."},"isbn":{},"isEmailAddressList":{},"web":{},"isText":{"!type":"fn(value: string, flags?: ?) -> bool","!doc":"Checks if a string has non whitespace characters.\nParameters allow you to constrain the length."},"isInRange":{"!type":"fn(value: string, flags?: ?) -> bool","!doc":"Validates whether a string denoting a number\nis between a max and min."},"isNumberFormat":{"!type":"fn(value: string, flags?: ?) -> bool","!doc":"Validates any sort of number based format"},"isValidLuhn":{"!type":"fn(value: string) -> bool","!doc":"Validate a String value against the Luhn algorithm."},"check":{"!type":"fn(form: +HTMLFormElement, profile: ?) -> ?","!doc":"validates user input of an HTML form based on input profile"},"evaluateConstraint":{"!type":"fn(profile: +The, constraint: [], fieldName: +The, elem: +The) -> bool","!doc":"Evaluates dojo.validate.check() constraints that are specified as array\narguments"},"isValidCreditCard":{"!type":"fn(value: string, ccType: string)","!doc":"Validate a credit card number by type with Luhn checking."},"isValidCreditCardNumber":{"!type":"fn(value: string, ccType?: string) -> bool","!doc":"Checks if value matches the pattern for that card or any card types if none is specified"},"isValidCvv":{"!type":"fn(value: string, ccType: string) -> bool","!doc":"Validate the security code (CCV) for a passed credit-card type."},"isValidIsbn":{"!type":"fn(value: string) -> bool","!doc":"Validate ISBN-10 or ISBN-13 based on the length of value"},"isIpAddress":{"!type":"fn(value: string, flags?: ?) -> bool","!doc":"Validates an IP address"},"isUrl":{"!type":"fn(value: string, flags?: ?) -> bool","!doc":"Checks if a string could be a valid URL"},"isEmailAddress":{"!type":"fn(value: string, flags?: ?) -> bool","!doc":"Checks if a string could be a valid email address"},"getEmailAddressList":{"!type":"fn(value: string, flags?: ?) -> []","!doc":"Check if value is an email address list. If an empty list\nis returned, the value didn't pass the test or it was empty."},"ca":{"!doc":"Module which includes Canadian-specific methods for dojox.validate","isPhoneNumber":{"!type":"fn(value: string) -> bool","!doc":"Validates Canadian 10-digit phone number for several common formats"},"isProvince":{"!type":"fn(value: [string]) -> bool","!doc":"Validates Canadian province abbreviations (2 characters)"},"isSocialInsuranceNumber":{"!type":"fn(value: string) -> bool","!doc":"Validates Canadian 9 digit social insurance number for several\ncommon formats"},"isPostalCode":{"!type":"fn(value: ?) -> bool","!doc":"Validates Canadian 6 digit postal code"}},"_cardInfo":{"!doc":"A dictionary list of credit card abbreviations","mc":{"!type":"string"},"ec":{"!type":"string"},"vi":{"!type":"string"},"ax":{"!type":"string"},"dc":{"!type":"string"},"bl":{"!type":"string"},"di":{"!type":"string"},"jcb":{"!type":"string"},"er":{"!type":"string"}},"regexp":{"emailAddressList":{},"ipAddress":{"!type":"fn(flags?: ?) -> string","!doc":"Builds a RE that matches an IP Address"},"host":{"!type":"fn(flags?: ?) -> string","!doc":"Builds a RE that matches a host"},"url":{"!type":"fn(flags?: ?)","!doc":"Builds a regular expression that matches a URL"},"emailAddress":{"!type":"fn(flags?: ?) -> string","!doc":"Builds a regular expression that matches an email address"},"numberFormat":{"!type":"fn(flags?: ?) -> string","!doc":"Builds a regular expression to match any sort of number based format"},"ca":{"postalCode":{"!type":"fn()","!doc":"String regular Express to match Canadain Postal Codes"},"province":{"!type":"fn()","!doc":"a regular expression to match Canadian Province Abbreviations"}},"us":{"state":{"!type":"fn(flags?: ?) -> string","!doc":"A regular expression to match US state and territory abbreviations\n\nflags  An object.\nflags.allowTerritories  Allow Guam, Puerto Rico, etc.  Default is true.\nflags.allowMilitary  Allow military 'states', e.g. Armed Forces Europe (AE).  Default is true."}}},"us":{"isState":{"!type":"fn(value: string, flags?: ?) -> bool","!doc":"Validates US state and territory abbreviations."},"isPhoneNumber":{"!type":"fn(value: string) -> bool","!doc":"Validates 10 US digit phone number for several common formats"},"isSocialSecurityNumber":{"!type":"fn(value: string) -> bool","!doc":"Validates social security number"},"isZipCode":{"!type":"fn(value: string) -> bool","!doc":"Validates U.S. zip-code"}}},"widget":{"gauge":{"AnalogLineIndicator":{"!type":"fn()","prototype":{"!proto":"dojox.widget.gauge._Indicator.prototype","_getShapes":{"!type":"fn()","!doc":"Private function for generating the shapes for this indicator. An indicator that behaves the\nsame might override this one and simply replace the shapes (such as ArrowIndicator)."},"draw":{"!type":"fn(dontAnimate?: bool)","!doc":"Override of dojox.widget.gauge._Indicator.draw"},"_move":{"!type":"fn(dontAnimate?: bool)","!doc":"Moves this indicator (since it's already been drawn once)"}}},"BarLineIndicator":{"!type":"fn()","prototype":{"!proto":"dojox.widget.gauge._Indicator.prototype","width":{"!type":"number"},"_getShapes":{"!type":"fn()","!doc":"Private function for generating the shapes for this indicator. An indicator that behaves the\nsame might override this one and simply replace the shapes (such as BarIndicator)."},"draw":{"!type":"fn(dontAnimate?: bool)","!doc":"Override of dojox.widget.gauge._Indicator.draw"},"_move":{"!type":"fn(dontAnimate?: bool)","!doc":"Moves this indicator (since it's already been drawn once)"}}},"AnalogArcIndicator":{"!type":"fn()","prototype":{"!proto":"dojox.widget.gauge.AnalogLineIndicator.prototype","_createArc":{"!type":"fn(val: ?)"},"draw":{"!type":"fn(dontAnimate?: bool)","!doc":"Override of dojox.widget._Indicator.draw"}}},"AnalogArrowIndicator":{"!type":"fn()","prototype":{"!proto":"dojox.widget.gauge.AnalogLineIndicator.prototype","_getShapes":{"!type":"fn()","!doc":"Override of dojox.widget.AnalogLineIndicator._getShapes"}}},"AnalogNeedleIndicator":{"!type":"fn()","prototype":{"!proto":"dojox.widget.gauge.AnalogLineIndicator.prototype","_getShapes":{"!type":"fn()","!doc":"Override of dojox.widget.AnalogLineIndicator._getShapes"}}},"BarIndicator":{"!type":"fn()","prototype":{"!proto":"dojox.widget.gauge.BarLineIndicator.prototype","_getShapes":{"!type":"fn()","!doc":"Override of dojox.widget.BarLineIndicator._getShapes"},"_createShapes":{"!type":"fn(val: ?)","!doc":"Creates a shallow copy of the current shapes while adjusting for the new value"},"_move":{"!type":"fn(dontAnimate?: bool)","!doc":"Override of dojox.widget.BarLineIndicator._move to resize the bar (rather than moving it)"}}},"_Gauge":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"a gauge built using the dojox.gfx package.","width":{"!doc":"width of the mark\nlength: The length of the mark\ninterval: The interval the ticks should be added on\ncolor: The color of the mark and text\nfont: an object with any/all of the following parameters:\n{family: &quot;Helvetica&quot;, style: &quot;italic&quot;, variant: 'small-caps', weight: 'bold', size: &quot;18pt&quot;}","!type":"+The"},"height":{"!doc":"the height of the gauge (default is 200)","!type":"number"},"background":{"!doc":"the color of the background.  This must be an object of one of two forms:\n{'color': 'color-name'}\nOR\n(for a gradient:)\n{'type': 'linear', 'x1': 0, 'x2': 0, 'y1': 0, 'y2': 200, 'colors': [{offset: 0, color:'#C0C0C0'}, {offset: 1, color: '#E0E0E0'}] }"},"min":{"!doc":"The minimum value of the gauge.  Normally not set explicitly, as it will be determined by\nthe ranges that are added.","!type":"number"},"max":{"!doc":"The maximum value of the gauge.  Normally not set explicitly, as it will be determined by\nthe ranges that are added.","!type":"number"},"image":{"!doc":"background image for gauge (default is no image)","!type":"string"},"useRangeStyles":{"!doc":"indicates whether to use given css classes (dojoxGaugeRangeXX)\nto determine the color (and other style attributes?) of the ranges\nthis value should be the number of dojoxGaugeRange classes that are\ndefined, starting at dojoxGaugeRange1 (0 indicates falling to default\nhardcoded colors)","!type":"number"},"useTooltip":{"!doc":"indicates whether tooltips should be displayed for ranges, indicators, etc.","!type":"bool"},"majorTicks":{"!doc":"An object representing the tick marks that should be added to the gauge. Major tick marks have a text label\nindicating the value.  The object can have the following attributes (required are marked with a *):\noffset: the distance from the 'center' of the gauge.  Used differently for Analog vs. Bar"},"minorTicks":{"!doc":"An object of the same format as majorTicks, indicating where the minor (label-less) marks should be placed\nThe font parameter is ignored if provided since minor tick marks have no text label."},"_defaultIndicator":{"!doc":"Should be overridden by any extending classes and used to indicate what the 'default' indicator is.\nThis object is used as the indicator when creating tick marks or when an anonmyous object is passed into\naddIndicator.","!type":"+Objection"},"defaultColors":{"!doc":"Set of default colors to color ranges with.","!type":"[]"},"surface":{"!doc":"The SVG/VML surface that the shapes are drawn on.  Can be accessed/used by indicators to draw themselves"},"hideValues":{"!doc":"indicates whether the text boxes showing the value of the indicator (as text\ncontent) should be hidden or shown.  Default is not hidden, aka shown.","!type":"bool"},"gaugeContent":{},"templatePath":{},"_rangeData":{},"_indicatorData":{},"_drag":{},"_img":{},"_overOverlay":{"!type":"bool"},"_lastHover":{"!type":"string"},"startup":{"!type":"fn()"},"_setTicks":{"!type":"fn(oldTicks: ?, newTicks: ?, label: bool)","!doc":"internal method used to clear existing tick marks, then add new ones"},"setMinorTicks":{"!type":"fn(ticks: ?)","!doc":"Creates and draws the minor tick marks based on the passed object (expecting the same format\nas the minorTicks object documented above)"},"setMajorTicks":{"!type":"fn(ticks: ?)","!doc":"Creates and draws the major tick marks based on the passed object (expecting the same format\nas the majorTicks object documented above)"},"postCreate":{"!type":"fn()"},"createSurface":{"!type":"fn()","!doc":"internal method used by the gauge to create the graphics surface area"},"setBackground":{"!type":"fn(background: +An)","!doc":"This method is used to set the background of the gauge after it is created."},"addRange":{"!type":"fn(range: ?)","!doc":"This method is used to add a range to the gauge."},"addRanges":{"!type":"fn(ranges: [])","!doc":"This method is used to add ranges to the gauge."},"addIndicator":{"!type":"fn(indicator: ?)","!doc":"This method is used to add an indicator to the bar graph."},"removeIndicator":{"!type":"fn(indicator: ?)","!doc":"Removes the given indicator from the gauge by calling it's remove function\nand removing it from the local cache."},"moveIndicatorToFront":{"!type":"fn(indicator: ?)","!doc":"This function is used to move an indicator the the front (top)\nof the gauge"},"drawText":{"!type":"fn(txt: string, x: number, y: number, align?: string, vAlign?: string, color?: string, font?: ?)","!doc":"This function is used draw text onto the gauge.  The text object\nis also returned by the function so that may be removed later\nby calling removeText"},"removeText":{"!type":"fn(t: string)","!doc":"Removes a text element from the gauge."},"updateTooltip":{"!type":"fn(txt: string, e: +Event)","!doc":"Updates the tooltip for the gauge to display the given text."},"handleMouseOver":{"!type":"fn(event: ?)","!doc":"This is an internal handler used by the gauge to support\nhover text"},"handleMouseOut":{"!type":"fn(event: ?)","!doc":"This is an internal handler used by the gauge to support\nhover text"},"handleMouseDown":{"!type":"fn(event: ?)","!doc":"This is an internal handler used by the gauge to support using\nthe mouse to drag an indicator to modify it's value"},"handleMouseUp":{"!type":"fn(event: ?)","!doc":"This is an internal handler used by the gauge to support using\nthe mouse to drag an indicator to modify it's value"},"handleMouseMove":{"!type":"fn(event: ?)","!doc":"This is an internal handler used by the gauge to support using\nthe mouse to drag an indicator to modify it's value"}},"_backgroundDefault":{"color":{"!type":"string"}}},"Range":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"a range to be used in a _Gauge","low":{"!doc":"the low value of the range","!type":"number"},"high":{"!doc":"the high value of the range","!type":"+Numbe"},"hover":{"!doc":"the text to put in the tooltip for the gauge","!type":"string"},"color":{"!doc":"the color of the range.  This must be an object of one of two forms:\n{'color': 'color-name'}\nOR\n(for a gradient:)\n{'type': 'linear', 'colors': [{offset: 0, color:'#C0C0C0'}, {offset: 1, color: '#E0E0E0'}] }"},"size":{"!doc":"for a circular gauge (such as an AnalogGauge), this dictates the size of the arc","!type":"number"},"startup":{"!type":"fn()"}}},"_Indicator":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"a indicator to be used in a gauge","value":{"!doc":"The value (on the gauge) that this indicator should be placed at","!type":"number"},"type":{"!doc":"The type of indicator to draw.  Varies by gauge type.  Some examples include\n&quot;line&quot;, &quot;arrow&quot;, and &quot;bar&quot;","!type":"string"},"color":{"!doc":"The color of the indicator.","!type":"string"},"label":{"!doc":"The text label for the indicator.","!type":"string"},"length":{"!doc":"The length of the indicator.  In the above example, the radius of the AnalogGauge\nis 125, but the length of the indicator is 135, meaning it would project beyond\nthe edge of the AnalogGauge","!type":"number"},"width":{"!doc":"The width of the indicator.","!type":"number"},"offset":{"!doc":"The offset of the indicator","!type":"number"},"hover":{"!doc":"The string to put in the tooltip when this indicator is hovered over.","!type":"string"},"front":{"!doc":"Keep this indicator at the front","!type":"bool"},"duration":{"!doc":"indicates how long an animation of the indicator should take","!type":"number"},"hideValue":{"!type":"bool"},"noChange":{"!doc":"indicates whether the indicator's value can be changed.  Useful for\na static target indicator.  Default is false (that the value can be changed).","!type":"bool"},"_gauge":{},"title":{"!doc":"The title of the indicator, to be displayed next to it's input box for the text-representation.","!type":"string"},"templatePath":{},"startup":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"_update":{"!type":"fn(event: ?)","!doc":"A private function, handling the updating of the gauge"},"update":{"!type":"fn(value: ?)","!doc":"Updates the value of the indicator, including moving/re-drawing at it's new location and\nupdating the text box"},"onDragMove":{"!type":"fn()","!doc":"Handles updating the text box and the hover text while dragging an indicator"},"draw":{"!type":"fn(dontAnimate?: bool)","!doc":"Performs the initial drawing of the indicator."},"remove":{"!type":"fn()","!doc":"Removes the indicator's shapes from the gauge surface."}},"easing":{"!doc":"indicates the easing function to be used when animating the of an indicator.","!type":"string"},"font":{"!doc":"Generally in a format similar to:\n{family: &quot;Helvetica&quot;, weight: &quot;bold&quot;, style: &quot;italic&quot;, size: &quot;18pt&quot;, rotated: true}","family":{"!type":"string"},"size":{"!type":"string"}}}},"CalendarFx":{},"CalendarViews":{},"AnalogGauge":{"!type":"fn()","prototype":{"!proto":"dojox.widget.gauge._Gauge.prototype","!doc":"a gauge built using the dojox.gfx package.","startAngle":{"!doc":"angle (in degrees) for start of gauge (default is -90)","!type":"number"},"endAngle":{"!doc":"angle (in degrees) for end of gauge (default is 90)","!type":"number"},"cx":{"!doc":"center of gauge x coordinate (default is gauge width / 2)","!type":"number"},"cy":{"!doc":"center of gauge x coordinate (default is gauge height / 2)","!type":"number"},"radius":{"!doc":"radius of gauge (default is smaller of cx-25 or cy-25)","!type":"number"},"startup":{"!type":"fn()"},"_getAngle":{"!type":"fn(value: number)","!doc":"This is a helper function used to determine the angle that represents\na given value on the gauge"},"_getValueForAngle":{"!type":"fn(angle: number)","!doc":"This is a helper function used to determie the value represented by a\ngiven angle on the gauge"},"_getRadians":{"!type":"fn(angle: number)","!doc":"This is a helper function than converts degrees to radians"},"_getDegrees":{"!type":"fn(radians: number)","!doc":"This is a helper function that converts radians to degrees"},"draw":{"!type":"fn()","!doc":"This function is used to draw (or redraw) the gauge."},"drawRange":{"!type":"fn(range: ?)","!doc":"This function is used to draw (or redraw) a range"},"getRangeUnderMouse":{"!type":"fn(event: ?)","!doc":"Determines which range the mouse is currently over"},"_dragIndicator":{"!type":"fn(widget: ?, event: ?)","!doc":"Handles the dragging of an indicator, including moving/re-drawing\nget angle for mouse position"}},"_defaultIndicator":{"!doc":"of dojox.widget._Gauge._defaultIndicator","!type":"+override"}},"BarGauge":{"!type":"fn()","prototype":{"!proto":"dojox.widget.gauge._Gauge.prototype","!doc":"a bar graph built using the dojox.gfx package.","dataX":{"!doc":"x position of data area (default 5)","!type":"number"},"dataY":{"!doc":"y position of data area (default 5)","!type":"number"},"dataWidth":{"!doc":"width of data area (default is bar graph width - 10)","!type":"number"},"dataHeight":{"!doc":"height of data area (default is bar graph width - 10)","!type":"number"},"startup":{"!type":"fn()"},"_getPosition":{"!type":"fn(value: number)","!doc":"This is a helper function used to determine the position that represents\na given value on the bar graph"},"_getValueForPosition":{"!type":"fn(pos: number)","!doc":"This is a helper function used to determine the value represented by\na position on the bar graph"},"draw":{"!type":"fn()","!doc":"This function is used to draw (or redraw) the bar graph"},"drawRange":{"!type":"fn(range: ?)","!doc":"This function is used to draw (or redraw) a range"},"getRangeUnderMouse":{"!type":"fn(event: ?)","!doc":"Determines which range the mouse is currently over"},"_dragIndicator":{"!type":"fn(widget: ?, event: ?)","!doc":"Handles the dragging of an indicator, including moving/re-drawing\nget new value based on mouse position"}},"_defaultIndicator":{"!doc":"of dojox.widget._Gauge._defaultIndicator","!type":"+override"}},"_CalendarBase":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"The Root class for all _Calendar extensions","templatePath":{"!doc":"the path to the template to be used to construct the widget.","!type":"+URL"},"_views":{"!doc":"The list of mixin views available on this calendar.","!type":"[]"},"useFx":{"!doc":"Specifies if visual effects should be applied to the widget.\nThe default behavior of the widget does not contain any effects.\nThe dojox.widget.CalendarFx package is needed for these.","!type":"bool"},"widgetsInTemplate":{"!doc":"This widget is a container of other widgets, so this is true.","!type":"bool"},"value":{"!doc":"the currently selected Date","!type":"+Date"},"constraints":{},"footerFormat":{"!doc":"The date format of the date displayed in the footer.\tCan be\n'short', 'medium', and 'long'","!type":"string"},"constructor":{"!type":"fn()","!doc":"constructor for the widget"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()","!doc":"Instantiates the mixin views"},"addFx":{"!type":"fn(query: ?, fromNode: ?)"},"_setValueAttr":{"!type":"fn(value: +Date)","!doc":"set the current date and update the UI.\tIf the date is disabled, the selection will\nnot change, but the display will change to the corresponding month."},"isDisabledDate":{"!type":"fn(date: +Date, locale?: string)","!doc":"May be overridden to disable certain dates in the calendar e.g. <code>isDisabledDate=dojo.date.locale.isWeekend</code>"},"onValueSelected":{"!type":"fn(date: +Date)","!doc":"a date cell was selected.\tIt may be the same as the previous value."},"_onDateSelected":{"!type":"fn(date: ?, formattedValue: ?, force: ?)"},"onChange":{"!type":"fn(date: +Date)","!doc":"called only when the selected date has changed"},"onHeaderClick":{"!type":"fn(e: ?)","!doc":"Transitions to the next view."},"goToToday":{"!type":"fn()"},"_transitionVert":{"!type":"fn(direction: number)","!doc":"Animates the views to show one and hide another, in a\nvertical direction.\nIf 'direction' is 1, then the views slide upwards.\nIf 'direction' is -1, the views slide downwards."},"_updateTitleStyle":{"!type":"fn()"},"_slideTable":{"!type":"fn(widget: string, direction: number, callback: fn())","!doc":"Animates the horizontal sliding of a table."},"_addView":{"!type":"fn(view: ?)"},"getClassForDate":{"!type":"fn(dateObject: +Date, locale?: string) -> string","!doc":"May be overridden to return CSS classes to associate with the date entry for the given dateObject,\nfor example to indicate a holiday in specified locale."},"_adjustDisplay":{"!type":"fn(part: string, amount: number, noSlide: ?)","!doc":"This function overrides the base function defined in dijit.Calendar.\nIt changes the displayed years, months and days depending on the inputs."}}},"_CalendarView":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Base implementation for all view mixins.\nAll calendar views should extend this widget.","headerClass":{"!type":"string"},"useHeader":{"!type":"bool"},"cloneClass":{"!type":"fn(clazz: ?, n: ?, before: ?)","!doc":"Clones all nodes with the class 'clazz' in a widget"},"_setText":{"!type":"fn(node: ?, text: ?)","!doc":"sets the text inside a node"},"getHeader":{"!type":"fn()","!doc":"Returns the header node of a view. If none exists,\nan empty DIV is created and returned."},"onValueSelected":{"!type":"fn(date: ?)"},"adjustDate":{"!type":"fn(date: ?, amount: ?)","!doc":"Adds or subtracts values from a date.\nThe unit, e.g. &quot;day&quot;, &quot;month&quot; or &quot;year&quot;, is\nspecified in the &quot;datePart&quot; property of the\ncalendar view mixin."},"onDisplay":{"!type":"fn()","!doc":"Stub function that can be used to tell a view when it is shown."},"onBeforeDisplay":{"!type":"fn()","!doc":"Stub function that can be used to tell a view it is about to be shown."},"onBeforeUnDisplay":{"!type":"fn()","!doc":"Stub function that can be used to tell\na view when it is no longer shown."}}},"_CalendarDay":{"!type":"fn()","prototype":{"!doc":"Mixin for the dojox.widget.Calendar which provides\nthe standard day-view. A single month is shown at a time.","parent":{},"constructor":{"!type":"fn()"}}},"_CalendarDayView":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarView.prototype","!doc":"View class for the dojox.widget.Calendar.\nAdds a view showing every day of a single month to the calendar.\nThis should not be mixed in directly with dojox.widget._CalendarBase.\nInstead, use dojox.widget._CalendarDay","templatePath":{"!doc":"the path to the template to be used to construct the widget.","!type":"+URL"},"datePart":{"!doc":"Specifies how much to increment the displayed date when the user\nclicks the array button to increment of decrement the view.","!type":"string"},"dayWidth":{"!doc":"Specifies the type of day name to display.\t&quot;narrow&quot; causes just one letter to be shown.","!type":"string"},"postCreate":{"!type":"fn()","!doc":"Constructs the calendar view."},"onDisplay":{"!type":"fn()"},"_onDayClick":{"!type":"fn(e: ?)","!doc":"executed when a day value is clicked."},"_setValueAttr":{"!type":"fn(value: ?)"},"_populateDays":{"!type":"fn()","!doc":"Fills the days of the current month."}}},"_CalendarMonthYear":{"!type":"fn()","prototype":{"!doc":"Mixin class for adding a view listing all 12 months of the year to the\ndojox.widget._CalendarBase","constructor":{"!type":"fn()","!doc":"Adds a dojox.widget._CalendarMonthView view to the calendar widget."}}},"_CalendarMonthYearView":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarView.prototype","!doc":"A Calendar view listing the 12 months of the year","templatePath":{"!doc":"the path to the template to be used to construct the widget.","!type":"+URL"},"datePart":{"!doc":"Specifies how much to increment the displayed date when the user\nclicks the array button to increment of decrement the view.","!type":"string"},"displayedYears":{"!type":"number"},"useHeader":{"!type":"bool"},"postCreate":{"!type":"fn()","!doc":"Constructs the view"},"_setValueAttr":{"!type":"fn(value: ?)"},"getHeader":{"!type":"fn()"},"_getMonthNames":{"!type":"fn(format: ?)","!doc":"Returns localized month names"},"_populateMonths":{"!type":"fn()","!doc":"Populate the month names using the localized values."},"_populateYears":{"!type":"fn(year: ?)","!doc":"Fills the list of years with a range of 12 numbers, with the current year\nbeing the 6th number."},"_updateSelectedYear":{"!type":"fn()"},"_updateSelectedMonth":{"!type":"fn()"},"_updateSelectedNode":{"!type":"fn(query: ?, filter: ?)"},"onClick":{"!type":"fn(evt: ?)"},"onOk":{"!type":"fn(evt: ?)"},"onCancel":{"!type":"fn(evt: ?)"}}},"Calendar2Pane":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarBase.prototype","!doc":"A Calendar with two panes, the second one\ncontaining both month and year"}},"Calendar":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarBase.prototype","!doc":"The standard Calendar. It includes day and month/year views.\nNo visual effects are included."}},"DailyCalendar":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarBase.prototype","!doc":"A calendar with only a daily view."}},"MonthAndYearlyCalendar":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarBase.prototype","!doc":"A calendar with only a daily view."}},"_FisheyeFX":{"!type":"fn()","prototype":{"addFx":{"!type":"fn(query: ?, fromNode: ?)"}}},"CalendarFisheye":{"!type":"fn()","prototype":{"!proto":"dojox.widget.Calendar.prototype","!doc":"The standard Calendar. It includes day, month and year views.\nFisheyeLite effects are included."}},"_CalendarMonth":{"!type":"fn()","prototype":{"!doc":"Mixin class for adding a view listing all 12 months of the year to the\ndojox.widget._CalendarBase","constructor":{"!type":"fn()","!doc":"Adds a dojox.widget._CalendarMonthView view to the calendar widget."}}},"_CalendarMonthView":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarView.prototype","!doc":"A Calendar view listing the 12 months of the year","templatePath":{"!doc":"the path to the template to be used to construct the widget.","!type":"+URL"},"datePart":{"!doc":"Specifies how much to increment the displayed date when the user\nclicks the array button to increment of decrement the view.","!type":"string"},"headerClass":{"!doc":"Specifies the CSS class to apply to the header node for this view.","!type":"string"},"postCreate":{"!type":"fn()","!doc":"Constructs the view"},"_setValueAttr":{"!type":"fn(value: ?)"},"onClick":{"!type":"fn(evt: ?)","!doc":"Handles clicks on month names"}},"_getMonthNames":{},"_populateMonths":{}},"_CalendarYear":{"!type":"fn()","prototype":{"!doc":"Mixin class for adding a view listing 12 years to the\ndojox.widget._CalendarBase","parent":{},"constructor":{"!type":"fn()","!doc":"Adds a dojox.widget._CalendarYearView view to the\ndojo.widget._CalendarBase widget."}}},"_CalendarYearView":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarView.prototype","!doc":"A Calendar view listing 12 years","templatePath":{"!doc":"the path to the template to be used to construct the widget.","!type":"+URL"},"displayedYears":{"!type":"number"},"postCreate":{"!type":"fn()","!doc":"Constructs the view"},"_setValueAttr":{"!type":"fn(value: ?)"},"adjustDate":{"!type":"fn(date: ?, amount: ?)","!doc":"Adjusts the value of a date. It moves it by 12 years each time."},"onClick":{"!type":"fn(evt: ?)","!doc":"Handles clicks on year values."}},"_populateYears":{}},"Calendar3Pane":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarBase.prototype","!doc":"The Calendar includes day, month and year views.\nNo visual effects are included."}},"MonthlyCalendar":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarBase.prototype","!doc":"A calendar with only a month view."}},"YearlyCalendar":{"!type":"fn()","prototype":{"!proto":"dojox.widget._CalendarBase.prototype","!doc":"A calendar with only a year view."}},"ColorPicker":{"!type":"fn()","prototype":{"!proto":"dijit.form._FormWidget.prototype","!doc":"a HSV color picker - similar to Photoshop picker","showRgb":{"!doc":"show/update RGB input nodes","!type":"bool"},"showHsv":{"!doc":"show/update HSV input nodes","!type":"bool"},"showHex":{"!doc":"show/update Hex value field","!type":"bool"},"webSafe":{"!doc":"deprecated? or just use a toggle to show/hide that node, too?","!type":"bool"},"animatePoint":{"!doc":"toggle to use slideTo (true) or just place the cursor (false) on click","!type":"bool"},"slideDuration":{"!doc":"time in ms picker node will slide to next location (non-dragging) when animatePoint=true","!type":"+Integer"},"liveUpdate":{"!doc":"Set to true to fire onChange in an indeterminate way","!type":"bool"},"PICKER_HUE_H":{"!doc":"Height of the hue picker, used to calculate positions","!type":"number"},"PICKER_SAT_VAL_H":{"!doc":"Height of the 2d picker, used to calculate positions","!type":"number"},"PICKER_SAT_VAL_W":{"!doc":"Width of the 2d picker, used to calculate positions","!type":"number"},"value":{"!doc":"Default color for this component. Only hex values are accepted as incoming/returned\nvalues. Adjust this value with <code>.attr</code>, eg: dijit.byId(&quot;myPicker&quot;).attr(&quot;value&quot;, &quot;#ededed&quot;);\nto cause the points to adjust and the values to reflect the current color.\n\n\ndon't change to d.moduleUrl, build won't intern it.","!type":"string"},"_underlay":{},"templatePath":{},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"_setValueAttr":{"!type":"fn(value: ?)"},"setColor":{"!type":"fn(color: string, force: ?)","!doc":"Set a color on a picker. Usually used to set\ninitial color as an alternative to passing defaultColor option\nto the constructor."},"_setTimer":{"!type":"fn(mover: +d.dnd.Mover)"},"_clearTimer":{"!type":"fn(mover: +d.dnd.Mover)"},"_setHue":{"!type":"fn(h: +Decimal)","!doc":"sets a natural color background for the\nunderlay image against closest hue value (full saturation)"},"_updateColor":{"!type":"fn()","!doc":"update the previewNode color, and input values [optional]"},"_colorInputChange":{"!type":"fn(e: ?)","!doc":"updates picker position and inputs\naccording to rgb, hex or hsv input changes"},"_updateValue":{"!type":"fn(col: +dojox.color.Color, fireChange: bool)","!doc":"updates the value of the widget\ncan cancel reverse onChange by specifying second param"},"_updatePickerLocations":{"!type":"fn(col: +dojox.color.Color)","!doc":"update handles on the pickers acording to color values"},"_updateColorInputs":{"!type":"fn(col: +dojox.color.Color)","!doc":"updates color inputs that were changed through other inputs\nor by clicking on the picker"},"_setHuePoint":{"!type":"fn(evt: +Event)","!doc":"set the hue picker handle on relative y coordinates"},"_setPoint":{"!type":"fn(evt: +Event)","!doc":"set our picker point based on relative x/y coordinates\nevt.preventDefault();"},"_handleKey":{"!type":"fn(e: +Event)"}}},"Dialog":{"!type":"fn()","prototype":{"!proto":"dijit.Dialog.prototype","!doc":"A Lightbox-like Modal-dialog for HTML Content","templatePath":{},"sizeToViewport":{"!doc":"If true, fix the size of the dialog to the Viewport based on\nviewportPadding value rather than the calculated or natural\nstlye. If false, base the size on a passed dimension attribute.\nEitherway, the viewportPadding value is used if the the content\nextends beyond the viewport size for whatever reason.","!type":"bool"},"viewportPadding":{"!doc":"If sizeToViewport=&quot;true&quot;, this is the amount of padding in pixels to leave\nbetween the dialog border and the viewport edge.\nThis value is also used when sizeToViewport=&quot;false&quot; and dimensions exceeded\nby dialog content to ensure dialog does not go outside viewport boundary","!type":"+Integer"},"dimensions":{"!doc":"A two-element array of [widht,height] to animate the Dialog to if sizeToViewport=&quot;false&quot;\nDefaults to [300,300]","!type":"[]"},"easing":{"!doc":"An easing function to apply to the sizing animation.","!type":"fn()"},"sizeMethod":{"!doc":"To be passed to dojox.fx.sizeTo, one of &quot;chain&quot; or &quot;combine&quot; to effect\nthe animation sequence.","!type":"string"},"showTitle":{"!doc":"Toogle to show or hide the Title area. Can only be set at startup.","!type":"bool"},"draggable":{"!doc":"Make the pane draggable. Differs from dijit.Dialog by setting default to false\n\n\nsimply over-ride the default from dijit.Dialog","!type":"bool"},"modal":{"!doc":"If true, this Dialog instance will be truly modal and prevent closing until\nexplicitly told to by calling hide() - Defaults to false to preserve previous\nbehaviors.","!type":"bool"},"constructor":{"!type":"fn(props: ?, node: ?)"},"_setup":{"!type":"fn()","!doc":"Piggyback on dijit.Dialog's _setup for load-time options, deferred to"},"layout":{"!type":"fn(e: ?)"},"_setSize":{"!type":"fn()","!doc":"cache and set our desired end position"},"show":{"!type":"fn()"},"_handleNav":{"!type":"fn(e: ?)","!doc":"Handle's showing or hiding the close icon"},"_position":{"!type":"fn()"},"_showContent":{"!type":"fn(e: ?)","!doc":"Show the inner container after sizing animation"}},"sizeDuration":{"!doc":"Time (in ms) to use in the Animation for sizing.","!type":"+Integer"}},"DocTester":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget to run DocTests inside an HTML page.","templatePath":{},"widgetsInTemplate":{"!type":"bool"},"_fillContent":{"!type":"fn(source: +Node)","!doc":"Overridden from _Templates.js, which actually just takes care of filling the containerNode."},"postCreate":{"!type":"fn()"},"runTests":{"!type":"fn()"},"reset":{"!type":"fn()","!doc":"Reset the DocTester visuals and enable the &quot;Run tests&quot; button again."},"_unescapeHtml":{"!type":"fn(str: string) -> string","!doc":"Adds escape sequences for special characters in XML: &amp;&lt;&gt;&quot;'"}}},"_FileInfoPane":{"!type":"fn()","prototype":{"!proto":"dojox.widget._RollingListPane.prototype","!doc":"a pane to display the information for the currently-selected\nfile","templateString":{"!doc":"delete our template string","!type":"string"},"templatePath":{"!doc":"Our template path","!type":"string"},"postMixInProperties":{"!type":"fn()"},"onItems":{"!type":"fn()","!doc":"called after a fetch or load - at this point, this.items should be\nset and loaded."}}},"FilePicker":{"!type":"fn()","prototype":{"!proto":"dojox.widget.RollingList.prototype","!doc":"a specialized version of RollingList that handles file information\nin a store","className":{"!type":"string"},"pathSeparator":{"!doc":"Our file separator - it will be guessed if not set","!type":"string"},"topDir":{"!doc":"The top directory string - it will be guessed if not set","!type":"string"},"parentAttr":{"!doc":"the attribute to read for finding our parent directory","!type":"string"},"pathAttr":{"!doc":"the attribute to read for getting the full path of our file","!type":"string"},"preloadItems":{"!doc":"or int\nSet this to a sane number - since we expect to mostly be using the\ndojox.data.FileStore - which doesn't like loading lots of items\nall at once.","!type":"bool"},"selectDirectories":{"!doc":"whether or not we allow selection of directories - that is, whether or\nour value can be set to a directory.","!type":"bool"},"selectFiles":{"!doc":"whether or not we allow selection of files - that is, we will disable\nthe file entries.","!type":"bool"},"_itemsMatch":{"!type":"fn(item1: +item, item2: +item)"},"startup":{"!type":"fn()"},"getChildItems":{"!type":"fn(item: ?)"},"getMenuItemForItem":{"!type":"fn(item: +item, parentPane: +dijit._Contained, children?: [+item])"},"getPaneForItem":{"!type":"fn(item: +item, parentPane: +dijit._Contained, children?: [+item])"},"_setPathValueAttr":{"!type":"fn(path: string, resetLastExec?: bool, onSet?: fn)"},"_getPathValueAttr":{"!type":"fn(val?: +item)","!doc":"returns the path value of the given value (or current value\nif not passed a value)"},"_setValue":{"!type":"fn(value: +item)","!doc":"internally sets the value and fires onchange"}}},"FisheyeList":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Menu similar to the fish eye menu on the Mac OS","templateString":{"!type":"string"},"snarfChildDomOutput":{"!type":"bool"},"itemWidth":{"!doc":"width of menu item (in pixels) in it's dormant state (when the mouse is far away)","!type":"+Integer"},"itemHeight":{"!doc":"height of menu item (in pixels) in it's dormant state (when the mouse is far away)","!type":"+Integer"},"itemMaxWidth":{"!doc":"width of menu item (in pixels) in it's fully enlarged state (when the mouse is directly over it)","!type":"+Integer"},"itemMaxHeight":{"!doc":"height of menu item (in pixels) in it's fully enlarged state (when the mouse is directly over it)","!type":"+Integer"},"imgNode":{},"orientation":{"!doc":"orientation of the menu, either &quot;horizontal&quot; or &quot;vertical&quot;","!type":"string"},"isFixed":{"!doc":"toggle to enable additional listener (window scroll) if FisheyeList is in a fixed postion","!type":"bool"},"conservativeTrigger":{"!doc":"if true, don't start enlarging menu items until mouse is over an image;\nif false, start enlarging menu items as the mouse moves near them.","!type":"bool"},"effectUnits":{"!doc":"controls how much reaction the menu makes, relative to the distance of the mouse from the menu","!type":"number"},"itemPadding":{"!doc":"padding (in pixels) betweeen each menu item","!type":"+Integer"},"attachEdge":{"!doc":"controls the border that the menu items don't expand past;\nfor example, if set to &quot;top&quot;, then the menu items will drop downwards as they expand.\nvalues\n&quot;center&quot;, &quot;left&quot;, &quot;right&quot;, &quot;top&quot;, &quot;bottom&quot;.","!type":"string"},"labelEdge":{"!doc":"controls were the labels show up in relation to the menu item icons\nvalues\n&quot;center&quot;, &quot;left&quot;, &quot;right&quot;, &quot;top&quot;, &quot;bottom&quot;.","!type":"string"},"constructor":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()","!doc":"create our connections and setup our FisheyeList"},"_initializePositioning":{"!type":"fn()"},"_overElement":{"!type":"fn(node: +DomNode, e: +Event)","!doc":"Returns whether the mouse is over the passed element.\nNode: Must must be display:block (ie, not a &lt;span&gt;)"},"_onBodyOut":{"!type":"fn(e: +Event)"},"_setDormant":{"!type":"fn(e: +Event)","!doc":"called when mouse moves out of menu's range"},"_setActive":{"!type":"fn(e: +Event)","!doc":"called when mouse is moved into menu's range"},"_onMouseMove":{"!type":"fn(e: +Event)","!doc":"called when mouse is moved"},"_onScroll":{"!type":"fn()"},"onResized":{"!type":"fn()"},"_onGridMouseMove":{"!type":"fn(x: ?, y: ?)","!doc":"called when mouse is moved in the vicinity of the menu"},"_paint":{"!type":"fn()"},"_weighAt":{"!type":"fn(cen: +Integer, i: +Integer) -> +Integer"},"_setItemSize":{"!type":"fn(p: ?, scale: ?)"},"_positionElementsFrom":{"!type":"fn(p: ?, offset: ?)"},"_positionLabel":{"!type":"fn(itm: ?)"},"_calcHitGrid":{"!type":"fn()"},"_toEdge":{"!type":"fn(inp: ?, def: ?)"},"_expandSlowly":{"!type":"fn()","!doc":"slowly expand the image to user specified max size"},"destroyRecursive":{"!type":"fn()"}},"EDGE":{"CENTER":{"!type":"number"},"LEFT":{"!type":"number"},"RIGHT":{"!type":"number"},"TOP":{"!type":"number"},"BOTTOM":{"!type":"number"}}},"FisheyeListItem":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","iconSrc":{"!doc":"pathname to image file (jpg, gif, png, etc.) of icon for this menu item","!type":"string"},"label":{"!doc":"label to print next to the icon, when it is moused-over","!type":"string"},"id":{"!doc":"will be set to the id of the orginal div element","!type":"string"},"templateString":{"!type":"string"},"_isNode":{"!type":"fn(wh: ?) -> bool","!doc":"checks to see if wh is actually a node."},"_hasParent":{"!type":"fn(node: +Node) -> bool","!doc":"returns whether or not node is a child of another node."},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"onMouseOver":{"!type":"fn(e: +Event)","!doc":"callback when user moves mouse over this menu item\nin conservative mode, don't activate the menu until user mouses over an icon"},"onMouseOut":{"!type":"fn(e: +Event)","!doc":"callback when user moves mouse off of this menu item"},"onClick":{"!type":"fn(e: +Event)","!doc":"user overridable callback when user clicks this menu item"}}},"FisheyeLite":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A Light-weight Fisheye Component, or an exhanced version\nof dojo.fx.Toggler ...","durationIn":{"!type":"number"},"durationOut":{"!doc":"The Time (in ms) to run the hide animation","!type":"+Integer"},"properties":{"!doc":"An object of &quot;property&quot;:scale pairs, or &quot;property&quot;:{} pairs.\ndefaults to font-size with a scale of 2.75\nIf a named property is an integer or float, the &quot;scale multiplier&quot;\nis used. If the named property is an object, that object is mixed\ninto the animation directly. eg: height:{ end:20, unit:&quot;em&quot; }"},"units":{"!doc":"Sometimes, you need to specify a unit. Should be part of\nproperties attrib, but was trying to shorthand the logic there","!type":"string"},"constructor":{"!type":"fn(props: ?, node: ?)"},"postCreate":{"!type":"fn()"},"show":{"!type":"fn()","!doc":"Show this Fisheye item."},"hide":{"!type":"fn()","!doc":"Hide this fisheye item on mouse leave"},"_makeAnims":{"!type":"fn()","!doc":"Pre-generate the animations"},"onClick":{"!type":"fn(e: +Event)","!doc":"stub function fired when target is clicked\nconnect or override to use."},"onSelected":{"!type":"fn(e: ?)","!doc":"stub function fired when Fisheye Item is fully visible and\nhovered. connect or override use."}},"easeIn":{"!type":"fn()","!doc":"An easing function to use for the show animation"},"easeOut":{"!type":"fn()","!doc":"An easing function to use for the hide animation"}},"Iterator":{"!type":"fn()","prototype":{"!proto":"dijit.Declaration.prototype","constructor":{},"start":{"!type":"number"},"fetchMax":{"!type":"number"},"attrs":{"!type":"[]"},"defaultValue":{"!type":"string"},"widgetCtor":{},"dataValues":{"!type":"[]"},"data":{},"store":{},"_srcIndex":{"!type":"number"},"_srcParent":{},"_setSrcIndex":{"!type":"fn(s: ?)"},"postscript":{"!type":"fn(p: ?, s: ?)"},"clear":{"!type":"fn()"},"update":{"!type":"fn()"},"_addItem":{"!type":"fn(config: ?, idx: ?)"},"getAttrValuesObj":{"!type":"fn(item: ?)"},"onDataAvailable":{"!type":"fn(data: ?)"},"fetch":{"!type":"fn(query: ?, start: ?, end: ?)"}},"_classes":{},"query":{"name":{"!type":"string"}}},"Loader":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"a configurable global xhr-listener to display\na loading message during running xhr's or to simply provide\nbase-level topic to subscribe to for custom loading messages","loadIcon":{"!doc":"location to the icon used.","!type":"string"},"loadMessage":{"!doc":"string to use for progress loading","!type":"string"},"hasVisuals":{"!doc":"true to display a fixed loading message in TR cornder, false to unly provide\n&quot;Loader&quot; topic to subscribe to for your own custom loading message.","!type":"bool"},"attachToPointer":{"!type":"bool"},"duration":{"!doc":"time in ms to toggle in/out the visual load indicator","!type":"+Integer"},"_offset":{"!doc":"distance in px from the mouse pointer to show attachToPointer avatar","!type":"+Integer"},"_pointerConnect":{},"_xhrStart":{},"_xhrEnd":{},"templateString":{"!type":"string"},"postCreate":{"!type":"fn()","!doc":"setup the loader"},"_setMessage":{"!type":"fn(message: string)","!doc":"set's the message in the loader"},"_putLoader":{"!type":"fn(e: +Event)","!doc":"place the floating loading element based on mousemove connection position"},"_show":{"!type":"fn()","!doc":"publish and show progress indicator"},"_hide":{"!type":"fn()","!doc":"publish &quot;xhr ended&quot; and hide progress indicator"}}},"Pager":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A Pager, displaying a list of sized nodes","templatePath":{},"iconPrevious":{"!doc":"The url of the previous page icon","!type":"string"},"iconNext":{"!doc":"The url of the next page icon","!type":"string"},"iconPage":{},"iconPageActive":{},"store":{"!doc":"A dojo.data Data store\n\n\ndata store for items"},"orientation":{"!doc":"Either &quot;horizontal or &quot;vertical&quot; to define the direction the pages will slide\n\n\nor vertical","!type":"string"},"statusPos":{"!doc":"A string describing where to put the Pager &quot;current page&quot; indicator. Options are\n&quot;leading&quot; or &quot;trailing&quot;. In the case of horiztonal orientation, &quot;leading&quot; indicates\npositioned above the PageItems. In the case of vertical, &quot;leading&quot; indicates &quot;before&quot;.","!type":"string"},"pagerPos":{"!doc":"TODOC","!type":"string"},"duration":{"!doc":"Time in milliseconds to transition the pages","!type":"+Integer"},"itemSpace":{"!doc":"Spacing between items? TODOC","!type":"+Integer"},"resizeChildren":{"!doc":"TODOC","!type":"bool"},"itemClass":{"!doc":"The full dotted named of a Class to use for the internal Pager Items.","!type":"string"},"itemsPage":{"!doc":"The numbers of items to display in each &quot;Page&quot;","!type":"+Integer"},"postMixInProperties":{"!type":"fn()"},"postCreate":{"!type":"fn()"},"_a11yStyle":{"!type":"fn(e: ?)","!doc":"top level onfocus/onblur listen to set a class &quot;pagerFocus&quot; on some node\nand remove it onblur"},"_handleKey":{"!type":"fn(e: ?)","!doc":"Handle keyboard navigation internally"},"_init":{"!type":"fn(items: ?)"},"_renderPages":{"!type":"fn()"},"_renderPager":{"!type":"fn()"},"_renderStatus":{"!type":"fn()"},"_pagerSkip":{"!type":"fn(page: ?)"},"_pagerNext":{"!type":"fn()"},"_pagerPrevious":{"!type":"fn()"},"onScrollEnd":{"!type":"fn()","!doc":"Stub Function. Fired after the slide is complete. Override or connect."}}},"_PagerItem":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","templateString":{"!type":"string"},"resizeChildren":{"!type":"fn()"},"parseChildren":{"!type":"fn()"}}},"PlaceholderMenuItem":{"!type":"fn()","prototype":{"!proto":"dijit.MenuItem.prototype","!doc":"A menu item that can be used as a placeholder.  Set the label\nof this item to a unique key and you can then use it to add new\nitems at that location.  This item is not displayed.","_replaced":{"!type":"bool"},"_replacedWith":{},"_isPlaceholder":{"!type":"bool"},"postCreate":{"!type":"fn()"},"replace":{"!type":"fn(menuItems: [+dijit.MenuItem])","!doc":"replaces this menu item with the given menuItems.  The original\nmenu item is not actually removed from the menu - so if you want\nit removed, you must do that explicitly."},"unReplace":{"!type":"fn(destroy?: bool) -> [+dijit.MenuItem]","!doc":"Removes menu items added by calling replace().  It returns the\narray of items that were actually removed (in case you want to\nclean them up later)"}}},"Roller":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A simple widget to take an unordered-list of Text and roll through them","delay":{"!doc":"Interval between rolls","!type":"+Integer"},"autoStart":{"!doc":"Toggle to control starup behavior. Call .start() manually\nif set to <code>false</code>","!type":"bool"},"itemSelector":{"!doc":"A CSS selector to be used by <code>dojo.query</code> to find the children\nitems in this widget. Defaults to &quot;&gt; li&quot;, finding only first-children\nlist-items in the list, allowing for embedded lists to occur.","!type":"string"},"durationIn":{"!doc":"Speed (in ms) to apply to the &quot;in&quot; animation (show the node)","!type":"+Integer"},"durationOut":{"!doc":"Speed (in ms) to apply to the &quot;out&quot; animation (hide the showing node)","!type":"+Integer"},"items":{"!doc":"If populated prior to instantiation, is used as the Items over the children","!type":"[]"},"_idx":{"!doc":"Index of the the currently visible item in the list of items[]","!type":"+Integer"},"postCreate":{"!type":"fn()"},"makeAnims":{"!type":"fn()","!doc":"Animation creator function. Need to create an 'in' and 'out'\nAnimation stored in _anim Object, which the rest of the widget\nwill reuse."},"_setupConnects":{"!type":"fn()","!doc":"setup the loop connection logic"},"start":{"!type":"fn()","!doc":"Starts to Roller looping"},"_run":{"!type":"fn()"},"stop":{"!type":"fn()","!doc":"Stops the Roller from looping anymore."},"_set":{"!type":"fn(i: ?)","!doc":"Set the Roller to some passed index. If beyond range, go to first."}}},"RollerSlide":{"!type":"fn()","prototype":{"!proto":"dojox.widget.Roller.prototype","!doc":"An add-on to the Roller to modify animations. This produces\na slide-from-bottom like effect. See `dojox.widget.Roller` for\nfull API information.","durationOut":{"!type":"number"},"makeAnims":{"!type":"fn()","!doc":"Animation creator function. Need to create an 'in' and 'out'\nAnimation stored in _anim Object, which the rest of the widget\nwill reuse."}}},"_RollerHover":{"!type":"fn()","prototype":{"!doc":"A mixin class to provide a way to automate the \"stop on hover\" functionality.","postCreate":{"!type":"fn()"}}},"_RollingListPane":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"a core pane that can be attached to a RollingList.  All panes\nshould extend this one","templateString":{"!doc":"our template","!type":"string"},"parentWidget":{"!doc":"Our rolling list widget","!type":"+dojox.widget.RollingList"},"parentPane":{"!doc":"The pane that immediately precedes ours","!type":"+dojox.widget._RollingListPane"},"store":{"!doc":"the store we must use","!type":"+store"},"items":{"!doc":"an array of (possibly not-yet-loaded) items to display in this.\nIf this array is null, then the query and query options are used to\nget the top-level items to use.  This array is also used to watch and\nsee if the pane needs to be reloaded (store notifications are handled)\nby the pane","!type":"[+item]"},"query":{"!doc":"a query to pass to the datastore.  This is only used if items are null","!type":"?"},"queryOptions":{"!doc":"query options to be passed to the datastore","!type":"?"},"_focusByNode":{"!type":"bool"},"minWidth":{"!doc":"the width (in px) for this pane","!type":"+integer"},"_setContentAndScroll":{"!type":"fn(cont: string, isFakeContent: ?)","!doc":"sets the value of the content and scrolls it into view"},"_updateNodeWidth":{"!type":"fn(n: ?, min: ?)","!doc":"updates the min width of the pane to be minPaneWidth"},"_onMinWidthChange":{"!type":"fn(v: ?)"},"_setMinWidthAttr":{"!type":"fn(v: ?)"},"startup":{"!type":"fn()"},"_focusKey":{"!type":"fn(e: +Event)","!doc":"called when a keypress happens on the widget"},"focus":{"!type":"fn(force: bool)","!doc":"sets the focus to this current widget"},"_loadCheck":{"!type":"fn()","!doc":"checks that the store is loaded"},"_loadQuery":{"!type":"fn()","!doc":"sets the &quot;loading&quot; message and then kicks off a query asyncronously"},"_doLoadItems":{"!type":"fn(items: [+item], callback: fn)","!doc":"loads the given items, and then calls the callback when they\nare finished."},"_doQuery":{"!type":"fn()","!doc":"either runs the query or loads potentially not-yet-loaded items."},"_hasItem":{"!type":"fn(item: +item)","!doc":"returns whether or not the given item is handled by this\npane"},"_onSetItem":{"!type":"fn(item: +item, attribute: ?, oldValue: ?, newValue: ?)"},"_onNewItem":{"!type":"fn(newItem: +item, parentInfo?: ?)"},"_onDeleteItem":{"!type":"fn(deletedItem: +item)"},"onFetchStart":{"!type":"fn()","!doc":"called before a fetch starts"},"onFetchError":{"!type":"fn(error: +Error)","!doc":"called when a fetch error occurs."},"onLoadStart":{"!type":"fn()","!doc":"called before a load starts"},"onLoadError":{"!type":"fn(error: +Error)","!doc":"called when a load error occurs."},"onItems":{"!type":"fn()","!doc":"called after a fetch or load - at this point, this.items should be\nset and loaded.  Override this function to &quot;do your stuff&quot;"}}},"_RollingListGroupPane":{"!type":"fn()","prototype":{"!proto":"dojox.widget._RollingListPane.prototype","!doc":"a pane that will handle groups (treats them as menu items)","templateString":{"!doc":"our template","!type":"string"},"_menu":{"!doc":"The menu that we will call addChild() on for adding items","!type":"+dijit.Menu"},"_loadCheck":{"!type":"fn()","!doc":"checks that the store is loaded"},"_setContent":{"!type":"fn(cont: string)"},"_onMinWidthChange":{"!type":"fn(v: ?)"},"onItems":{"!type":"fn()","!doc":"called after a fetch or load"},"_checkScrollConnection":{"!type":"fn(doLoad: ?)","!doc":"checks whether or not we need to connect to our onscroll\nfunction"},"startup":{"!type":"fn()"},"focus":{"!type":"fn(force: bool)","!doc":"sets the focus to this current widget"},"_getMenu":{"!type":"fn()","!doc":"returns a widget to be used for the container widget."},"_onScrollPane":{"!type":"fn()","!doc":"called when the pane has been scrolled - it sets a timeout\nso that we don't try and load our visible items too often during\na scroll"},"_layoutHack":{"!type":"fn()","!doc":"work around table sizing bugs on FF2 by forcing redraw\nnote - this function is taken from dijit.form._FormWidget"},"_loadVisibleItems":{"!type":"fn()","!doc":"loads the items that are currently visible in the pane"},"_getSelected":{"!type":"fn(menu?: +dijit.Menu)","!doc":"returns the selected menu item - or null if none are selected"},"_setSelected":{"!type":"fn(item?: +dijit.MenuItem, menu?: +dijit.Menu)","!doc":"selectes the given item in the given menu (defaults to pane's menu)"},"destroy":{"!type":"fn()"}}},"RollingList":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"a rolling list that can be tied to a data store with children","templatePath":{"!doc":"our template to use","!type":"string"},"widgetsInTemplate":{"!type":"bool"},"className":{"!doc":"an additional class (or space-separated classes) to add for our widget","!type":"string"},"store":{"!doc":"the store we must use","!type":"+store"},"query":{"!doc":"a query to pass to the datastore.  This is only used if items are null","!type":"?"},"queryOptions":{"!doc":"query options to be passed to the datastore","!type":"?"},"childrenAttrs":{"!doc":"one ore more attributes that holds children of a node","!type":"[string]"},"parentAttr":{"!doc":"the attribute to read for finding our parent item (if any)","!type":"string"},"value":{"!doc":"The value that has been selected","!type":"+item"},"executeOnDblClick":{"!doc":"Set to true if you want to call onExecute when an item is\ndouble-clicked, false if you want to call onExecute yourself. (mainly\nused for popups to control how they want to be handled)","!type":"bool"},"preloadItems":{"!doc":"or int\nif set to true, then onItems will be called only *after* all items have\nbeen loaded (ie store.isLoaded will return true for all of them).  If\nfalse, then no preloading will occur.  If set to an integer, preloading\nwill occur if the number of items is less than or equal to the value\nof the integer.  The onItems function will need to be aware of handling\nitems that may not be loaded","!type":"bool"},"showButtons":{"!doc":"if set to true, then buttons for &quot;OK&quot; and &quot;Cancel&quot; will be provided","!type":"bool"},"okButtonLabel":{"!doc":"The string to use for the OK button - will use dijit's common &quot;OK&quot; string\nif not set","!type":"string"},"cancelButtonLabel":{"!doc":"The string to use for the Cancel button - will use dijit's common\n&quot;Cancel&quot; string if not set","!type":"string"},"minPaneWidth":{"!doc":"the minimum pane width (in px) for all child panes.  If they are narrower,\nthe width will be increased to this value.","!type":"+integer"},"postMixInProperties":{"!type":"fn()","!doc":"Mix in our labels, if they are not set"},"_setShowButtonsAttr":{"!type":"fn(doShow: ?)","!doc":"Sets the visibility of the buttons for the widget"},"_itemsMatch":{"!type":"fn(item1: +item, item2: +item)"},"_removeAfter":{"!type":"fn(idx: +dijit._Widget)","!doc":"removes all widgets after the given widget (or index)"},"addChild":{"!type":"fn(widget: +dijit._Widget, insertIndex?: number)","!doc":"adds a child to this rolling list - if passed an insertIndex,\nthen all children from that index on will be removed and destroyed\nbefore adding the child."},"_setMinPaneWidthAttr":{"!type":"fn(value: ?)","!doc":"Sets the min pane width of all children"},"_updateClass":{"!type":"fn(node: +Node, type: string, options?: ?)","!doc":"sets the state of the given node with the given type and options"},"scrollIntoView":{"!type":"fn(childWidget: +dijit._Widget)","!doc":"scrolls the given widget into view"},"resize":{"!type":"fn(args: ?)"},"layout":{"!type":"fn()"},"_onChange":{"!type":"fn(value: +item)"},"_setValue":{"!type":"fn(value: +item)","!doc":"internally sets the value and fires onchange"},"_setValueAttr":{"!type":"fn(value: +item)","!doc":"sets the value of this widget to the given store item"},"_onItemClick":{"!type":"fn(evt: +Event, pane: +dijit._Contained, item: +item, children?: [+item])","!doc":"internally called when a widget should pop up its child"},"_getPaneForItem":{"!type":"fn(item?: +item, parentPane?: +dijit._Contained, children?: [+item])","!doc":"gets the pane for the given item, and mixes in our needed parts\nReturns the pane for the given item (null if the root pane) - after mixing in\nits stuff."},"_getMenuItemForItem":{"!type":"fn(item: +item, parentPane: +dijit._Contained)","!doc":"returns a widget for the given store item.  The returned\nitem will be added to this widget's container widget.  null will\nbe passed in for an &quot;empty&quot; item."},"_setStore":{"!type":"fn(store: +dojo.data.api.Read)","!doc":"sets the store for this widget"},"_onKey":{"!type":"fn(e: +Event)","!doc":"called when a keypress event happens on this widget"},"_resetValue":{"!type":"fn()"},"_onCancel":{"!type":"fn()"},"_onExecute":{"!type":"fn()"},"focus":{"!type":"fn()","!doc":"sets the focus state of this widget"},"handleKey":{"!type":"fn(e: +Event)","!doc":"handle the key for the given event - called by dropdown\nwidgets"},"_updateChildClasses":{"!type":"fn()","!doc":"Called when a child is added or removed - so that we can\nupdate the classes for styling the &quot;current&quot; one differently than\nthe others"},"startup":{"!type":"fn()"},"getChildItems":{"!type":"fn(item: +item)","!doc":"Returns the child items for the given store item"},"getMenuItemForItem":{"!type":"fn(item: +item, parentPane: +dijit._Contained, children?: [+item])","!doc":"user overridable function to return a widget for the given item\nand its children."},"getPaneForItem":{"!type":"fn(item?: +item, parentPane?: +dijit._Contained, children?: [+item])","!doc":"user-overridable function to return a pane that corresponds\nto the given item in the store.  It can return null to not add a new pane\n(ie, you are planning on doing something else with it in onItemClick)\n\nItem is undefined for the root pane, children is undefined for non-group panes"},"onItemClick":{"!type":"fn(item: +item, pane: +dijit._Contained, children?: [+item])","!doc":"called when an item is clicked - it receives the store item"},"onExecute":{"!type":"fn()","!doc":"exists so that popups don't disappear too soon"},"onCancel":{"!type":"fn()","!doc":"exists so that we can close ourselves if we wish"},"onChange":{"!type":"fn(value: +item)","!doc":"called when the value of this widget has changed"}}},"SortList":{"!type":"fn()","prototype":{"!proto":"dijit.layout._LayoutWidget.prototype","!doc":"A sortable unordered-list with a fixed header for use in dijit.demos.chat\nfor demonstration purposes only for now. feel free to make API suggestions\nor fixes.","title":{"!doc":"The title in the header","!type":"string"},"heading":{"!doc":"In the event a parent container is expecting a title=&quot;&quot; attribute, set it for the parent\nvia title, and the title of this widget via heading=&quot;&quot; ... assuming you want different\ntitles for each. eg: TabContainer, AccordionContainer, etc.","!type":"string"},"descending":{"!doc":"Toggle sort order based on this value.","!type":"bool"},"selected":{"!doc":"A list of the selected &lt;li&gt; nodes at any given time.","!type":"[]"},"sortable":{"!doc":"toggle to enable/disable sorting","!type":"bool"},"store":{"!type":"string"},"key":{"!type":"string"},"baseClass":{"!type":"string"},"templatePath":{},"_addItem":{"!type":"fn(item: ?)"},"postCreate":{"!type":"fn()"},"startup":{"!type":"fn()"},"resize":{"!type":"fn()","!doc":"do our additional calculations when resize() is called by or in a parent"},"onSort":{"!type":"fn(e: +Event)","!doc":"sort the data, and style the nodes."},"_set":{"!type":"fn(e: +Event)","!doc":"set hover state"},"_unset":{"!type":"fn(e: +Event)","!doc":"remove hover state (FIXME: combine with _set?)"},"_handleClick":{"!type":"fn(e: +Event)","!doc":"click listener for data portion of widget. toggle selected state\nof node, and update this.selected array accordingly"},"_updateValues":{"!type":"fn()"},"_sorter":{"!type":"fn(a: ?, b: ?)","!doc":"a basic sort function, use query sort, or keep this?"},"setTitle":{"!type":"fn(title: string)","!doc":"Sets the widget title to a String"},"onChanged":{"!type":"fn()","!doc":"stub function, passes the last changed item, and is fired after current state"}}},"Standby":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget designed to act as a Standby/Busy/Disable/Blocking widget to indicate a\nparticular DOM node is processing and cannot be clicked on at this time.\nThis widget uses absolute positioning to apply the overlay and image.","templatePath":{},"_underlayNode":{},"_imageNode":{},"image":{"!doc":"URL to an image to center within the blocking overlay.  The default is a basic spinner.","!type":"+A"},"imageText":{"!doc":"to set on the ALT tag of the image.  The default is 'Please wait...'","!type":"+Text"},"_displayed":{"!type":"bool"},"_resizeCheck":{},"target":{"!type":"string"},"color":{"!doc":"color to use for the translucent overlay.  Text string such as: darkblue, #FE02FD, etc.\n\n\nThe node that is the translucent underlay for the image that blocks access to the target.","!type":"+The"},"startup":{"!type":"fn(args: ?)","!doc":"Over-ride of the basic widget startup function.  Configures the target node and sets the image to use."},"show":{"!type":"fn()","!doc":"Function to display the blocking overlay and busy/status icon"},"hide":{"!type":"fn()","!doc":"Function to hide the blocking overlay and status icon."},"_size":{"!type":"fn()","!doc":"Internal function that handles resizing the overlay and centering of the image on window resizing."},"_fadeIn":{"!type":"fn()","!doc":"Internal function that does the opacity style fade in animation."},"_fadeOut":{"!type":"fn()","!doc":"Internal function that does the opacity style fade out animation."},"_ignore":{"!type":"fn(event: ?)"},"uninitialize":{"!type":"fn()","!doc":"Over-ride to hide the widget, which clears intervals, before cleanup."}}},"Toaster":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"Message that slides in from the corner of the screen, used for notifications\nlike \"new email\".","templateString":{"!type":"string"},"messageTopic":{"!doc":"Name of topic; anything published to this topic will be displayed as a message.\nMessage format is either String or an object like\n{message: &quot;hello word&quot;, type: &quot;error&quot;, duration: 500}","!type":"string"},"defaultType":{"!doc":"If message type isn't specified (see &quot;messageTopic&quot; parameter),\nthen display message as this type.\nPossible values in messageTypes enumeration (&quot;message&quot;, &quot;warning&quot;, &quot;error&quot;, &quot;fatal&quot;)","!type":"string"},"positionDirection":{"!doc":"Position from which message slides into screen, one of\n[&quot;br-up&quot;, &quot;br-left&quot;, &quot;bl-up&quot;, &quot;bl-right&quot;, &quot;tr-down&quot;, &quot;tr-left&quot;, &quot;tl-down&quot;, &quot;tl-right&quot;]","!type":"string"},"positionDirectionTypes":{"!doc":"Possible values for positionDirection parameter","!type":"[]"},"duration":{"!doc":"Number of milliseconds to show message","!type":"+Integer"},"slideDuration":{"!doc":"Number of milliseconds for the slide animation, increasing will cause the Toaster\nto slide in more slowly.","!type":"+Integer"},"separator":{"!doc":"String used to separate messages if consecutive calls are made to setContent before previous messages go away","!type":"string"},"postCreate":{"!type":"fn()"},"_handleMessage":{"!type":"fn(message: string)"},"_capitalize":{"!type":"fn(w: string)"},"setContent":{"!type":"fn(message: string, messageType: string, duration?: number)","!doc":"sets and displays the given message and show duration"},"_setContent":{"!type":"fn(message: ?)"},"_cancelHideTimer":{"!type":"fn()"},"_setHideTimer":{"!type":"fn(duration: ?)"},"_placeClip":{"!type":"fn()"},"onSelect":{"!type":"fn(e: +Event)","!doc":"callback for when user clicks the message"},"show":{"!type":"fn()","!doc":"show the Toaster"},"hide":{"!type":"fn()","!doc":"hide the Toaster"}},"messageTypes":{"!doc":"Possible message types.","MESSAGE":{"!type":"string"},"WARNING":{"!type":"string"},"ERROR":{"!type":"string"},"FATAL":{"!type":"string"}}},"Wizard":{"!type":"fn()","prototype":{"!proto":"dijit.layout.StackContainer.prototype","!doc":"A set of panels that display sequentially, typically notating a step-by-step\nprocedure like an install","widgetsInTemplate":{"!type":"bool"},"templatePath":{},"nextButtonLabel":{"!doc":"Label override for the &quot;Next&quot; button.","!type":"string"},"previousButtonLabel":{"!doc":"Label override for the &quot;Previous&quot; button.","!type":"string"},"cancelButtonLabel":{"!doc":"Label override for the &quot;Cancel&quot; button.","!type":"string"},"doneButtonLabel":{"!doc":"Label override for the &quot;Done&quot; button.","!type":"string"},"cancelFunction":{"!doc":"Name of function to call if user presses cancel button.\nCancel button is not displayed if function is not specified.","!type":"fn()"},"hideDisabled":{"!doc":"If true, disabled buttons are hidden; otherwise, they are assigned the\n&quot;WizardButtonDisabled&quot; CSS class","!type":"bool"},"postMixInProperties":{"!type":"fn()"},"startup":{"!type":"fn()"},"_checkButtons":{"!type":"fn()"},"_setButtonClass":{"!type":"fn(button: ?)"},"_forward":{"!type":"fn()","!doc":"callback when next button is clicked"},"done":{"!type":"fn()","!doc":"Finish the wizard's operation"},"destroy":{"!type":"fn()"}}},"WizardPane":{"!type":"fn()","prototype":{"!proto":"dijit.layout.ContentPane.prototype","!doc":"A panel in a `dojox.widget.Wizard`","canGoBack":{"!doc":"If true, then can move back to a previous panel (by clicking the &quot;Previous&quot; button)","!type":"bool"},"passFunction":{"!doc":"Name of function that checks if it's OK to advance to the next panel.\nIf it's not OK (for example, mandatory field hasn't been entered), then\nreturns an error message (String) explaining the reason.","!type":"string"},"doneFunction":{"!doc":"Name of function that is run if you press the &quot;Done&quot; button from this panel","!type":"string"},"startup":{"!type":"fn()"},"_onShow":{"!type":"fn()"},"_checkPass":{"!type":"fn() -> bool","!doc":"Called when the user presses the &quot;next&quot; button.\nCalls passFunction to see if it's OK to advance to next panel, and\nif it isn't, then display error.\nReturns true to advance, false to not advance. If passFunction\nreturns a string, it is assumed to be a custom error message, and\nis alert()'ed"},"done":{"!type":"fn()"}}}},"wire":{"_defaultWireClass":{"!type":"string"},"_base":{},"register":{"!type":"fn(wireClass: fn(), key: string) -> +undefined","!doc":"Register a Wire class\ndesription:\nThe specified Wire class or a class name is registered with\na key property of arguments to create a Wire"},"_getClass":{"!type":"fn(name: string) -> fn()","!doc":"Returns a class"},"create":{"!type":"fn(args: ?) -> ?","!doc":"Create a Wire from arguments"},"isWire":{"!type":"fn(wire: ?) -> bool","!doc":"Check if an object is a Wire"},"transfer":{"!type":"fn(source: +Wire, target: +Wire, defaultObject?: ?, defaultTargetObject?: ?) -> +undefined","!doc":"Transfer a source value to a target value"},"connect":{"!type":"fn(trigger: ?, source: +Wire, target: +Wire) -> +undefined","!doc":"Transfer a source value to a target value on a trigger event or\ntopic"},"disconnect":{"!type":"fn(connection: ?) -> +undefined","!doc":"Remove a connection or subscription for transfer"},"CompositeWire":{"!type":"fn()","prototype":{"!proto":"dojox.wire.Wire.prototype","!doc":"A Wire for composite values in object or array","_wireClass":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initialize properties"},"_getValue":{"!type":"fn(object: +Object) -> ?","!doc":"Return an object with property values or an array with element\nvalues"},"_setValue":{"!type":"fn(object: +Object, value: +Object) -> ?","!doc":"Set an object properties or an array elements to an object\ndesription:\nThis method calls setValues() method of the child Wires with\na corresponding property or element in 'value' argument and\n'object' argument."},"_initializeChildren":{"!type":"fn(children: +Object) -> +undefined","!doc":"Initialize child Wires"}}},"DataWire":{"!type":"fn()","prototype":{"!proto":"dojox.wire.Wire.prototype","!doc":"A Wire for item attributes of data stores","_wireClass":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initialize properties"},"_getValue":{"!type":"fn(object: ?) -> ?","!doc":"Return an attribute value of an item"},"_setValue":{"!type":"fn(object: ?, value: +anything) -> ?","!doc":"Set an attribute value to an item"},"_getAttributeValue":{"!type":"fn(item: ?, attribute: string) -> +anything","!doc":"Return an attribute value of an item"},"_setAttributeValue":{"!type":"fn(item: ?, attribute: string, value: +anything)","!doc":"Set an attribute value to an item"}}},"TableAdapter":{"!type":"fn()","prototype":{"!proto":"dojox.wire.CompositeWire.prototype","!doc":"A composite Wire for table rows","_wireClass":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initialize properties"},"_getValue":{"!type":"fn(object: []) -> []","!doc":"Return an array of table row value (object or array)"},"_setValue":{"!type":"fn(object: [], value: [])","!doc":"Not supported"},"_getRow":{"!type":"fn(object: +Object) -> []","!doc":"Return an array or object for a table row"}}},"TextAdapter":{"!type":"fn()","prototype":{"!proto":"dojox.wire.CompositeWire.prototype","!doc":"A composite Wire for a concatenated text","_wireClass":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initialize properties"},"_getValue":{"!type":"fn(object: +Object) -> ?","!doc":"Return a concatenated text"},"_setValue":{"!type":"fn(object: +Object, value: string)","!doc":"Not supported"},"_addSegment":{"!type":"fn(text: string, segment: string) -> string","!doc":"Return a concatenated text"}}},"TreeAdapter":{"!type":"fn()","prototype":{"!proto":"dojox.wire.CompositeWire.prototype","!doc":"A composite Wire for tree nodes","_wireClass":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initialize properties"},"_getValue":{"!type":"fn(object: []) -> []","!doc":"Return an array of tree node values"},"_setValue":{"!type":"fn(object: [], value: [])","!doc":"Not supported"},"_initializeChildren":{"!type":"fn(children: []) -> +undefined","!doc":"Initialize child Wires"},"_getNodes":{"!type":"fn(object: ?, child: ?) -> []","!doc":"Return an array of tree node values"}}},"Wire":{"!type":"fn()","prototype":{"!doc":"A default and base Wire to access an object property","_wireClass":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initialize properties"},"getValue":{"!type":"fn(defaultObject: +Object) -> +anything","!doc":"Return a value of an object"},"setValue":{"!type":"fn(value: +anything, defaultObject: +Object)","!doc":"Set a value to an object"},"_getPropertyValue":{"!type":"fn(object: +Object, property: string) -> +anything","!doc":"Return a property value of an object"},"_setPropertyValue":{"!type":"fn(object: +Object, property: string, value: +anything)","!doc":"Set a property value to an object"},"_useAttr":{"!type":"fn(object: +The)","!doc":"Function to detect if dijit.attr support exists on the target"}}},"XmlWire":{"!type":"fn()","prototype":{"!proto":"dojox.wire.Wire.prototype","!doc":"A Wire for XML nodes or values (element, attribute and text)","_wireClass":{"!type":"string"},"constructor":{"!type":"fn(args: ?)","!doc":"Initialize properties"},"_getValue":{"!type":"fn(object: +Node) -> +Node","!doc":"Return an attribute value, a text value or an array of elements"},"_setValue":{"!type":"fn(object: +Node, value: string) -> +Node","!doc":"Set an attribute value or a child text value to an element"},"_getNodeValue":{"!type":"fn(node: +Node, exp: string) -> string","!doc":"Return an attribute value, a text value or an array of elements"},"_setNodeValue":{"!type":"fn(node: +Node, exp: string, value: string)","!doc":"Set an attribute value or a child text value to an element"},"_getChildNode":{"!type":"fn(node: +Node, name: string) -> +Node","!doc":"Return a child node"},"_getDocument":{"!type":"fn(node: +Node) -> +Document","!doc":"Return a DOM document"}}},"_wireClasses":{"attribute":{"!type":"string"},"path":{"!type":"string"},"children":{"!type":"string"},"columns":{"!type":"string"},"nodes":{"!type":"string"},"segments":{"!type":"string"}},"ml":{"util":{},"_getValue":{"!type":"fn(source: string, args: []) -> +undefined","!doc":"Return a value"},"_setValue":{"!type":"fn(target: string, value: +anything) -> +undefined","!doc":"Store a value"},"Action":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A base widget to \"run\" a task on an event or a topic","trigger":{"!doc":"event scope","!type":"+An"},"triggerEvent":{"!doc":"event (function) name","!type":"+An"},"triggerTopic":{"!doc":"topic name","!type":"+A"},"postCreate":{"!type":"fn()","!doc":"Call _connect()"},"_connect":{"!type":"fn()","!doc":"Connect run() method to an event or a topic"},"_disconnect":{"!type":"fn()","!doc":"Disconnect run() method from an event or a topic"},"run":{"!type":"fn()","!doc":"Run a task"},"_run":{"!type":"fn()","!doc":"Call run() methods of child Action widgets"},"uninitialize":{"!type":"fn()","!doc":"Over-ride of base widget unitialize function to do some connection cleanup."}}},"ActionFilter":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget to define a filter for the parent Action to run","required":{"!doc":"property required","!type":"+A"},"requiredValue":{"!doc":"A specific value the property is required to have.  If this isn't provided\nthan any non-false/non-null value of the required propery will cause this filter\nto pass.","!type":"+Optional."},"type":{"!doc":"A specific type to compare the values as (if requiredValue is set)\nValid values for type are boolean, int, string.  Default is string.","!type":"+Optional."},"message":{"!doc":"error message to emit if the filter doesn't execute due to property mismatch.","!type":"+An"},"error":{"!doc":"property to store an error due to property mismatch.","!type":"+A"},"filter":{"!type":"fn() -> bool","!doc":"Check if a required property is specified.  Also, if provided, check to see\nif the required property contains a specific value."}}},"Data":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget for a data object","startup":{"!type":"fn()","!doc":"Call _initializeProperties()"},"_initializeProperties":{"!type":"fn(reset: bool)","!doc":"Initialize a data object"},"getPropertyValue":{"!type":"fn(property: string) -> +anything","!doc":"Return a property value"},"setPropertyValue":{"!type":"fn(property: string, value: +anything)","!doc":"Store a property value"}}},"DataProperty":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget to define a data property","name":{"!doc":"property name","!type":"+A"},"type":{"!doc":"property type name","!type":"+A"},"value":{"!doc":"property value","!type":"+A"},"_getValueAttr":{"!type":"fn()"},"getValue":{"!type":"fn() -> +anything","!doc":"Returns a property value"}}},"DataStore":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget for a data store","storeClass":{"!doc":"class name of a data store","!type":"+A"},"postCreate":{"!type":"fn()","!doc":"Call _createStore()"},"_createStore":{"!type":"fn() -> +null","!doc":"Create a data store\ndesription:\nA data store of 'storeClass' is created with arguments\nspecified with attributes."},"getFeatures":{"!type":"fn() -> ?","!doc":"Call getFeatures() method of a data store"},"fetch":{"!type":"fn(request: ?) -> ?","!doc":"Call fetch() method of a data store"},"save":{"!type":"fn(args: ?)","!doc":"Call save() method of a data store"},"newItem":{"!type":"fn(args: ?) -> ?","!doc":"Call newItem() method of a data store"},"deleteItem":{"!type":"fn(item: ?) -> bool","!doc":"Call deleteItem() method of a data store"},"revert":{"!type":"fn() -> bool","!doc":"Call revert() method of a data store"}}},"Invocation":{"!type":"fn()","prototype":{"!proto":"dojox.wire.ml.Action.prototype","!doc":"A widget to invoke a method or publish a topic","object":{"!doc":"scope of a method to invoke","!type":"+A"},"method":{"!doc":"name of a method to invoke","!type":"+A"},"topic":{"!doc":"name of a topic to publish","!type":"+A"},"parameters":{"!doc":"for the method or the topic","!type":"+Arguments"},"result":{"!doc":"property to store a return value of the method call","!type":"+A"},"error":{"!doc":"property to store an error on the method call","!type":"+A"},"_run":{"!type":"fn() -> +undefined","!doc":"Invoke a method or publish a topic"},"onComplete":{"!type":"fn(result: +anything)","!doc":"A function called when the method or the topic publish\ncompleted"},"onError":{"!type":"fn(error: +anything)","!doc":"A function called on an error occurs"},"_getParameters":{"!type":"fn(args: []) -> []","!doc":"Returns arguments to a method or topic to invoke"}}},"Service":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget for a service","url":{"!doc":"URL to a service description","!type":"+A"},"serviceUrl":{"!doc":"URL to a service","!type":"+A"},"serviceType":{"!doc":"service type","!type":"+A"},"handlerClass":{"!doc":"service handler class name","!type":"+A"},"preventCache":{"!type":"bool"},"postCreate":{"!type":"fn()","!doc":"Call _createHandler()"},"_createHandler":{"!type":"fn() -> +null","!doc":"Create a service handler\ndesription:\nA service handler class is determined by:\n1. 'handlerClass' attribute\n2. 'serviceType' attribute\n3. 'serviceType' property in a service description"},"callMethod":{"!type":"fn(method: +A, parameters: +An)","!doc":"Call a service method with parameters"}},"_handlerClasses":{"TEXT":{"!type":"string"},"XML":{"!type":"string"},"JSON":{"!type":"string"},"JSON-RPC":{"!type":"string"}}},"RestHandler":{"!type":"fn()","prototype":{"!doc":"A REST service handler","contentType":{"!type":"string"},"handleAs":{"!type":"string"},"bind":{"!type":"fn(method: +A, parameters: +An, deferred: +Deferred, url: +A)","!doc":"Call a service method with parameters."},"_getUrl":{"!type":"fn(method: string, parameters: [], url: string) -> string","!doc":"Generate a URL"},"_getContent":{"!type":"fn(method: string, parameters: []) -> +anything","!doc":"Generate a request content"},"_getResult":{"!type":"fn(data: +anything) -> +anything","!doc":"Extract a result"}}},"XmlHandler":{"!type":"fn()","prototype":{"!proto":"dojox.wire.ml.RestHandler.prototype","!doc":"A REST service handler for XML","contentType":{"!type":"string"},"handleAs":{"!type":"string"},"_getContent":{"!type":"fn(method: string, parameters: [])"},"_getResult":{"!type":"fn(data: +Document)","!doc":"Extract a result"}}},"JsonHandler":{"!type":"fn()","prototype":{"!proto":"dojox.wire.ml.RestHandler.prototype","!doc":"A REST service handler for JSON","contentType":{"!type":"string"},"handleAs":{"!type":"string"},"_getContent":{"!type":"fn(method: string, parameters: []) -> string","!doc":"Generate a request content"}},"headers":{"Accept":{"!type":"string"}}},"Transfer":{"!type":"fn()","prototype":{"!proto":"dojox.wire.ml.Action.prototype","!doc":"A widget to transfer values through source and target Wires","source":{"!doc":"source object and/or property","!type":"+A"},"sourceStore":{"!doc":"data store for a source data item","!type":"+A"},"sourceAttribute":{"!doc":"attribute of a source data item","!type":"+An"},"sourcePath":{"!doc":"simplified XPath to a source property of an XML element","!type":"+A"},"type":{"!doc":"type of the value to be transferred","!type":"+A"},"converter":{"!doc":"class name of a converter for the value to be transferred","!type":"+A"},"delimiter":{"!type":"string"},"target":{"!doc":"target object and/or property","!type":"+A"},"targetStore":{"!doc":"data store for a target data item","!type":"+A"},"targetAttribute":{"!doc":"attribute of a target data item","!type":"+An"},"targetPath":{"!doc":"simplified XPath to a target property of an XML element","!type":"+A"},"_run":{"!type":"fn()","!doc":"Transfer a value from a source to a target"},"_getWire":{"!type":"fn(which: string) -> ?","!doc":"Build Wire arguments from attributes"}}},"ChildWire":{"!type":"fn()","prototype":{"!proto":"dijit._Widget.prototype","!doc":"A widget to add a child wire","which":{"!doc":"Wire to add a child Wire, &quot;source&quot; or &quot;target&quot;, default to\n&quot;source&quot;","!type":"+Which"},"object":{"!doc":"root object for the value","!type":"+A"},"property":{"!doc":"property for the value","!type":"+A"},"type":{"!doc":"type of the value","!type":"+A"},"converter":{"!doc":"class name of a converter for the value","!type":"+A"},"attribute":{"!doc":"data item attribute for the value","!type":"+A"},"path":{"!doc":"simplified XPath for the value","!type":"+A"},"name":{"!doc":"composite property name","!type":"+A"},"_addWire":{"!type":"fn(parent: +Transfer, args: ?)","!doc":"Add a child Wire to Wire arguments"},"_getWire":{"!type":"fn(parent: +Transfer)","!doc":"Build child Wire arguments from attributes"}}},"ColumnWire":{"!type":"fn()","prototype":{"!proto":"dojox.wire.ml.ChildWire.prototype","!doc":"A widget to add a column wire","column":{"!doc":"column name","!type":"+A"},"_addWire":{"!type":"fn(parent: +Transfer, args: ?)","!doc":"Add a column Wire to Wire arguments"}}},"NodeWire":{"!type":"fn()","prototype":{"!proto":"dojox.wire.ml.ChildWire.prototype","!doc":"A widget to add node wires","titleProperty":{"!doc":"property for the node title","!type":"+A"},"titleAttribute":{"!doc":"data item attribute for the node title","!type":"+A"},"titlePath":{"!doc":"simplified XPath for the node title","!type":"+A"},"_addWire":{"!type":"fn(parent: +Transfer, args: ?)","!doc":"Add node Wires to Wire arguments"},"_getWires":{"!type":"fn(parent: +Transfer) -> ?","!doc":"Build node Wires arguments from attributes"}}},"SegmentWire":{"!type":"fn()","prototype":{"!proto":"dojox.wire.ml.ChildWire.prototype","!doc":"A widget to add a segment wire","_addWire":{"!type":"fn(parent: +Transfer, args: ?)","!doc":"Add a segument Wire to Wire arguments"}}},"XmlElement":{"!type":"fn()","prototype":{"!doc":"An object wrapping an XML element","constructor":{"!type":"fn(element: +Element)","!doc":"Initialize with an XML element or a tag name"},"getPropertyValue":{"!type":"fn(property: string) -> +undefined","!doc":"Return a property value"},"setPropertyValue":{"!type":"fn(property: string, value: string) -> +undefined","!doc":"Store a property value"},"toString":{"!type":"fn() -> string","!doc":"Return a value of the first text child of the element"},"toObject":{"!type":"fn() -> +null","!doc":"Return an object representation of the element"},"_getDocument":{"!type":"fn() -> +Document","!doc":"Return a DOM document"}}}}},"xml":{"DomParser":{},"widgetParser":{},"Script":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(props: ?, node: ?)"}}},"parser":{"parse":{"!type":"fn(str?: string, mimetype?: string) -> +DOMDocument","!doc":"cross-browser implementation of creating an XML document object from null, empty string, and XML text.."},"textContent":{"!type":"fn(node: +Node, text?: string) -> string","!doc":"Implementation of the DOM Level 3 attribute; scan node for text"},"replaceChildren":{"!type":"fn(node: +Element, newChildren: +Node)","!doc":"Removes all children of node and appends newChild. All the existing\nchildren will be destroyed."},"removeChildren":{"!type":"fn(node: +Element) -> number","!doc":"removes all children from node and returns the count of children removed.\nThe children nodes are not destroyed. Be sure to call dojo.destroy on them\nafter they are not used anymore."},"innerXML":{"!type":"fn(node: +Node) -> string","!doc":"Implementation of MS's innerXML function."}}},"xmpp":{"ChatService":{"!type":"fn()","prototype":{"state":{"!type":"string"},"constructor":{"!type":"fn()"},"recieveMessage":{"!type":"fn(msg: ?, initial: ?)"},"setSession":{"!type":"fn(session: ?)"},"setState":{"!type":"fn(state: ?)"},"invite":{"!type":"fn(contact: ?)"},"sendMessage":{"!type":"fn(msg: ?)"},"sendChatState":{"!type":"fn(state: ?)"},"onNewMessage":{"!type":"fn(msg: ?)"},"onInvite":{"!type":"fn(contact: ?)"}}},"chat":{"CHAT_STATE_NS":{"!type":"string"},"ACTIVE_STATE":{"!type":"string"},"COMPOSING_STATE":{"!type":"string"},"INACTIVE_STATE":{"!type":"string"},"PAUSED_STATE":{"!type":"string"},"GONE_STATE":{"!type":"string"}},"PresenceService":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(xmppService: ?)"},"publish":{"!type":"fn(presence: ?)"},"sendAvatarHash":{"!type":"fn(avatarHash: ?)"},"_setPresence":{"!type":"fn()"},"toggleBlockContact":{"!type":"fn(jid: ?)"},"toggleContactInvisiblity":{"!type":"fn(jid: ?)"},"_createRestrictedJid":{"!type":"fn()"},"_updateRestricted":{"!type":"fn()"},"_setVisible":{"!type":"fn()"},"_setInvisible":{"!type":"fn()"},"_manageSubscriptions":{"!type":"fn(contact: ?, type: ?)"},"subscribe":{"!type":"fn(contact: ?)"},"approveSubscription":{"!type":"fn(contact: ?)"},"unsubscribe":{"!type":"fn(contact: ?)"},"declineSubscription":{"!type":"fn(contact: ?)"},"cancelSubscription":{"!type":"fn(contact: ?)"}}},"presence":{"UPDATE":{"!type":"number"},"SUBSCRIPTION_REQUEST":{"!type":"number"},"SUBSCRIPTION_SUBSTATUS_NONE":{"!type":"number"},"SUBSCRIPTION_NONE":{"!type":"string"},"SUBSCRIPTION_FROM":{"!type":"string"},"SUBSCRIPTION_TO":{"!type":"string"},"SUBSCRIPTION_BOTH":{"!type":"string"},"SUBSCRIPTION_REQUEST_PENDING":{"!type":"string"},"STATUS_ONLINE":{"!type":"string"},"STATUS_AWAY":{"!type":"string"},"STATUS_CHAT":{"!type":"string"},"STATUS_DND":{"!type":"string"},"STATUS_EXTENDED_AWAY":{"!type":"string"},"STATUS_OFFLINE":{"!type":"string"},"STATUS_INVISIBLE":{"!type":"string"}},"RosterService":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(xmppSession: ?)"},"addRosterItem":{"!type":"fn(jid: ?, name: ?, groups: ?)"},"updateRosterItem":{"!type":"fn(jid: ?, name: ?, groups: ?)"},"verifyRoster":{"!type":"fn(res: ?)"},"addRosterItemToGroup":{"!type":"fn(jid: ?, group: ?)"},"removeRosterGroup":{"!type":"fn(group: ?)"},"renameRosterGroup":{"!type":"fn(group: ?, newGroup: ?)"},"removeRosterItemFromGroup":{"!type":"fn(jid: ?, group: ?)"},"rosterItemRenameGroup":{"!type":"fn(jid: ?, oldGroup: ?, newGroup: ?)"},"renameRosterItem":{"!type":"fn(jid: ?, newName: ?)"},"removeRosterItem":{"!type":"fn(jid: ?)"},"getAvatar":{"!type":"fn(jid: ?)"},"publishAvatar":{"!type":"fn(type: ?, binval: ?)"},"onVerifyRoster":{"!type":"fn(id: ?)"},"onVerifyRosterFailed":{"!type":"fn(err: ?)"}}},"roster":{"ADDED":{"!type":"number"},"CHANGED":{"!type":"number"},"REMOVED":{"!type":"number"}},"TransportSession":{"!type":"fn(props: ?)","prototype":{"rid":{"!type":"number"},"hold":{"!type":"number"},"polling":{"!type":"number"},"secure":{"!type":"bool"},"wait":{"!type":"number"},"lang":{"!type":"string"},"submitContentType":{"!type":"string"},"serviceUrl":{"!type":"string"},"defaultResource":{"!type":"string"},"domain":{"!type":"string"},"sendTimeout":{"!type":"number"},"useScriptSrcTransport":{"!type":"bool"},"keepAliveTimer":{},"state":{"!type":"string"},"transmitState":{"!type":"string"},"protocolPacketQueue":{"!type":"[]"},"outboundQueue":{"!type":"[]"},"outboundRequests":{},"inboundQueue":{"!type":"[]"},"deferredRequests":{},"matchTypeIdAttribute":{},"open":{"!type":"fn()"},"_sendLogin":{"!type":"fn()"},"processScriptSrc":{"!type":"fn(msg: ?, rid: ?)"},"_keepAlive":{"!type":"fn()"},"close":{"!type":"fn(protocolMsg: ?)"},"dispatchPacket":{"!type":"fn(msg: ?, protocolMatchType: ?, matchId: ?, matchProperty: ?)"},"_dispatchPacket":{"!type":"fn()"},"redispatchPacket":{"!type":"fn(rid: ?)"},"addToOutboundQueue":{"!type":"fn(msg: ?, rid: ?)"},"removeFromOutboundQueue":{"!type":"fn(rid: ?)"},"processProtocolPacketQueue":{"!type":"fn()"},"findOpenIframe":{"!type":"fn()"},"sendXml":{"!type":"fn(message: ?, rid: ?)"},"processDocument":{"!type":"fn(doc: ?, rid: ?)"},"processInboundQueue":{"!type":"fn()"},"addToInboundQueue":{"!type":"fn(doc: ?, rid: ?)"},"processResponse":{"!type":"fn(body: ?, rid: ?)"},"processProtocolResponse":{"!type":"fn(msg: ?, rid: ?)"},"setState":{"!type":"fn(state: ?, message: ?)"},"isTerminated":{"!type":"fn()"},"processError":{"!type":"fn(err: ?, httpStatusCode: ?, rid: ?)"},"onTerminate":{"!type":"fn(newState: ?, oldState: ?, message: ?)"},"onProcessProtocolResponse":{"!type":"fn(msg: ?)"},"onReady":{"!type":"fn(newState: ?, oldState: ?)"}},"_iframeOnload":{"!type":"fn(index: ?)"},"handleBOSH":{"!type":"fn(msg: ?, rid: ?)"}},"UserService":{"!type":"fn()","prototype":{"constructor":{"!type":"fn(xmppService: ?)"},"getPersonalProfile":{"!type":"fn()"},"setPersonalProfile":{"!type":"fn(props: ?)"},"_onSetPersonalProfile":{"!type":"fn(response: ?)"},"onSetPersonalProfile":{"!type":"fn(id: ?)"},"onSetPersonalProfileFailure":{"!type":"fn(err: ?)"},"_onGetPersonalProfile":{"!type":"fn(profile: ?)"},"onGetPersonalProfile":{"!type":"fn(profile: ?)"},"onGetPersonalProfileFailure":{"!type":"fn(err: ?)"}}},"sasl":{"saslNS":{"!type":"string"},"SunWebClientAuth":{"!type":"fn(session: ?)"},"SaslPlain":{"!type":"fn(session: ?)"}},"util":{"xmlEncode":{"!type":"fn(str: ?)"},"encodeJid":{"!type":"fn(jid: ?)"},"decodeJid":{"!type":"fn(jid: ?)"},"createElement":{"!type":"fn(tag: ?, attributes: ?, terminal: ?)"},"stripHtml":{"!type":"fn(str: ?)"},"decodeHtmlEntities":{"!type":"fn(str: ?)"},"htmlToPlain":{"!type":"fn(str: ?)"},"Base64":{"keylist":{"!type":"string"},"encode":{"!type":"fn(input: ?)"},"decode":{"!type":"fn(input: ?)"}}},"widget":{"ChatSession":{"!type":"fn()","prototype":{"!proto":"dijit.layout.LayoutContainer.prototype","templatePath":{},"enableSubWidgets":{"!type":"bool"},"widgetsInTemplate":{"!type":"bool"},"widgetType":{"!type":"string"},"chatWith":{},"instance":{},"postCreate":{"!type":"fn()"},"displayMessage":{"!type":"fn(message: ?, type: ?)"},"goToLastMessage":{"!type":"fn()"},"onKeyPress":{"!type":"fn(e: ?)"}}}},"xmppSession":{"!type":"fn(props: ?)","prototype":{"roster":{"!type":"[]"},"chatRegister":{"!type":"[]"},"_iqId":{},"open":{"!type":"fn(user: ?, password: ?, resource: ?)"},"close":{"!type":"fn()"},"processProtocolResponse":{"!type":"fn(msg: ?)"},"messageHandler":{"!type":"fn(msg: ?)"},"iqHandler":{"!type":"fn(msg: ?)"},"presenceHandler":{"!type":"fn(msg: ?)"},"featuresHandler":{"!type":"fn(msg: ?)"},"saslHandler":{"!type":"fn(msg: ?)"},"chatHandler":{"!type":"fn(msg: ?)"},"simpleMessageHandler":{"!type":"fn(msg: ?)"},"registerChatInstance":{"!type":"fn(chatInstance: ?, message: ?)"},"iqSetHandler":{"!type":"fn(msg: ?)"},"sendIqResult":{"!type":"fn(iqId: ?, to: ?)"},"rosterSetHandler":{"!type":"fn(elem: ?)"},"presenceUpdate":{"!type":"fn(msg: ?)"},"retrieveRoster":{"!type":"fn()"},"getRosterIndex":{"!type":"fn(jid: ?)"},"createRosterEntry":{"!type":"fn(elem: ?)"},"bindResource":{"!type":"fn()"},"getNextIqId":{"!type":"fn()"},"presenceSubscriptionRequest":{"!type":"fn(msg: ?)"},"dispatchPacket":{"!type":"fn(msg: ?, type: ?, matchId: ?)"},"setState":{"!type":"fn(state: ?, message: ?)"},"search":{"!type":"fn(searchString: ?, service: ?, searchAttribute: ?)"},"_onSearchResults":{"!type":"fn(msg: ?)"},"onLogin":{"!type":"fn()"},"onLoginFailure":{"!type":"fn(msg: ?)"},"onBindResource":{"!type":"fn(msg: ?)"},"onSearchResults":{"!type":"fn(results: ?)"},"onRetrieveRoster":{"!type":"fn(msg: ?)"},"onRosterUpdated":{"!type":"fn()"},"onSubscriptionRequest":{"!type":"fn(req: ?)"},"onPresenceUpdate":{"!type":"fn(p: ?)"},"onTransportReady":{"!type":"fn()"},"onTransportTerminate":{"!type":"fn(newState: ?, oldState: ?, message: ?)"},"onConnected":{"!type":"fn()"},"onTerminate":{"!type":"fn(newState: ?, oldState: ?, message: ?)"},"onActive":{"!type":"fn()"},"onRegisterChatInstance":{"!type":"fn(chatInstance: ?, message: ?)"},"onRosterAdded":{"!type":"fn(ri: ?)"},"onRosterRemoved":{"!type":"fn(ri: ?)"},"onRosterChanged":{"!type":"fn(ri: ?, previousCopy: ?)"},"processXmppError":{"!type":"fn(msg: ?)"},"sendStanzaError":{"!type":"fn(stanzaType: ?, to: ?, id: ?, errorType: ?, condition: ?, text: ?)"},"getBareJid":{"!type":"fn(jid: ?)"},"getResourceFromJid":{"!type":"fn(jid: ?)"}}},"xmpp":{"STREAM_NS":{"!type":"string"},"CLIENT_NS":{"!type":"string"},"STANZA_NS":{"!type":"string"},"SASL_NS":{"!type":"string"},"BIND_NS":{"!type":"string"},"BODY_NS":{"!type":"string"},"XHTML_BODY_NS":{"!type":"string"},"XHTML_IM_NS":{"!type":"string"},"INACTIVE":{"!type":"string"},"CONNECTED":{"!type":"string"},"ACTIVE":{"!type":"string"},"TERMINATE":{"!type":"string"},"LOGIN_FAILURE":{"!type":"string"},"INVALID_ID":{"!type":"number"},"NO_ID":{"!type":"number"},"error":{"BAD_REQUEST":{"!type":"string"},"CONFLICT":{"!type":"string"},"FEATURE_NOT_IMPLEMENTED":{"!type":"string"},"FORBIDDEN":{"!type":"string"},"GONE":{"!type":"string"},"INTERNAL_SERVER_ERROR":{"!type":"string"},"ITEM_NOT_FOUND":{"!type":"string"},"ID_MALFORMED":{"!type":"string"},"NOT_ACCEPTABLE":{"!type":"string"},"NOT_ALLOWED":{"!type":"string"},"NOT_AUTHORIZED":{"!type":"string"},"SERVICE_UNAVAILABLE":{"!type":"string"},"SUBSCRIPTION_REQUIRED":{"!type":"string"},"UNEXPECTED_REQUEST":{"!type":"string"}}}}},"n":{"load":{},"onreadystatechange":{}},"dependencies":{"layers":{"!type":"[]"},"prefixes":{"!type":"[]"}},"value":{"length":{}},"token":{"1":{}},"pixelValues":{"1":{}},"l":{"style":{"height":{"!type":"string"}}},"r":{"style":{"height":{"!type":"string"},"left":{"!type":"string"}}},"b":{"style":{"width":{"!type":"string"},"top":{"!type":"string"}}},"bl":{"style":{"top":{"!type":"string"}}},"br":{"style":{"top":{"!type":"string"},"left":{"!type":"string"}}},"tr":{"style":{"left":{"!type":"string"}}},"node":{"className":{},"style":{"height":{}}},"dfd":{"ioArgs":{"frame":{"contentWindow":{"document":{}}}}},"frame":{"style":{"display":{"!type":"string"}},"contentWindow":{"document":{}}},"Number":{"MIN_VALUE":{}},"wrap":{"safeHTML":{},"safeCSS":{}}}

});  
