/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.preferences;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.repositories.NexusRepository;
import org.jboss.tools.maven.core.repositories.RemoteRepositoryManager;
import org.jboss.tools.maven.ui.internal.repositories.EditNexusRepositoryDialog;
import org.jboss.tools.maven.ui.preferences.AutoResizeTableLayout;

public class RemoteRepositoriesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer tableViewer;
    private Set<NexusRepository> nexusRepositories;
    private RemoteRepositoryManager remoteRepositoryManager;

    public void init(IWorkbench workbench) {
        this.remoteRepositoryManager = MavenCoreActivator.getDefault().getRepositoryManager();
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 4);
        label.setText("Remote repositories used for dependency identification (only Nexus repositories are supported).");
        Group group = new Group(composite, 0);
        GridData gd = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gd);
        layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        group.setText("Remote Repositories");
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)group, (int)2564);
        Table table = this.tableViewer.getTable();
        gd = new GridData(1808);
        gd.heightHint = 300;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{"Name", "URL"};
        int[] columnWidths = new int[]{200, 200};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tc = new TableColumn(table, 16384);
            tc.setText(columnNames[i]);
            tc.setWidth(columnWidths[i]);
            ++i;
        }
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(200, 200), new ColumnWeightData(200, 200)};
        AutoResizeTableLayout tableLayout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < layouts.length) {
            tableLayout.addColumnData(layouts[i2]);
            ++i2;
        }
        this.nexusRepositories = this.remoteRepositoryManager.getNexusRepositories();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new NexusRepositoryLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new NexusRepositoryContentProvider(this.nexusRepositories));
        this.tableViewer.setInput(this.nexusRepositories);
        for (NexusRepository nexusRepository : this.nexusRepositories) {
            this.tableViewer.setChecked((Object)nexusRepository, nexusRepository.isEnabled());
        }
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                NexusRepository repository;
                repository.setEnabled(!(repository = (NexusRepository)event.getElement()).isEnabled());
            }
        });
        this.createButtons((Composite)group, (TableViewer)this.tableViewer);
        return composite;
    }

    public void dispose() {
        super.dispose();
    }

    private void createButtons(Composite parent, final TableViewer viewer) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText("Add...");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditNexusRepositoryDialog dialog = new EditNexusRepositoryDialog(RemoteRepositoriesPreferencePage.this.getShell(), null);
                int ok = dialog.open();
                if (ok == 0) {
                    NexusRepository repository = dialog.getNexusRepository();
                    RemoteRepositoriesPreferencePage.this.nexusRepositories.add(repository);
                    viewer.refresh();
                    RemoteRepositoriesPreferencePage.this.tableViewer.setChecked((Object)repository, repository.isEnabled());
                }
                viewer.refresh();
            }
        });
        final Button editButton = new Button(buttonComposite, 8);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.setText("Edit...");
        editButton.setEnabled(false);
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                Object object;
                ISelection sel = viewer.getSelection();
                if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof NexusRepository) {
                    NexusRepository repository = (NexusRepository)object;
                    NexusRepository edit = new NexusRepository(repository.getName(), repository.getUrl(), repository.isEnabled());
                    EditNexusRepositoryDialog dialog = new EditNexusRepositoryDialog(RemoteRepositoriesPreferencePage.this.getShell(), edit);
                    int ok = dialog.open();
                    if (ok == 0) {
                        repository.setName(edit.getName());
                        repository.setUrl(edit.getUrl());
                        repository.setEnabled(edit.isEnabled());
                        viewer.refresh();
                        RemoteRepositoriesPreferencePage.this.tableViewer.setChecked((Object)repository, repository.isEnabled());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText("Remove");
        removeButton.setEnabled(false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                Object object;
                ISelection sel = viewer.getSelection();
                if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof NexusRepository) {
                    RemoteRepositoriesPreferencePage.this.nexusRepositories.remove(object);
                    viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button upButton = new Button(buttonComposite, 8);
        upButton.setLayoutData((Object)new GridData(768));
        upButton.setText("Up");
        upButton.setEnabled(false);
        final Button downButton = new Button(buttonComposite, 8);
        downButton.setLayoutData((Object)new GridData(768));
        downButton.setText("Down");
        downButton.setEnabled(false);
        upButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                Object object;
                ISelection sel = viewer.getSelection();
                if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof NexusRepository) {
                    NexusRepository selected = (NexusRepository)object;
                    NexusRepository[] reps = RemoteRepositoriesPreferencePage.this.nexusRepositories.toArray(new NexusRepository[0]);
                    int selectedIndex = -1;
                    int i = 0;
                    while (i < reps.length) {
                        NexusRepository rep = reps[i];
                        if (selected.equals(rep)) {
                            selectedIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (selectedIndex > 0) {
                        NexusRepository temp = reps[selectedIndex - 1];
                        reps[selectedIndex - 1] = selected;
                        reps[selectedIndex] = temp;
                        RemoteRepositoriesPreferencePage.this.nexusRepositories.clear();
                        NexusRepository[] nexusRepositoryArray = reps;
                        int n = reps.length;
                        int n2 = 0;
                        while (n2 < n) {
                            NexusRepository repository = nexusRepositoryArray[n2];
                            RemoteRepositoriesPreferencePage.this.nexusRepositories.add(repository);
                            ++n2;
                        }
                        viewer.refresh();
                        int newIndex = selectedIndex - 1;
                        downButton.setEnabled(newIndex < reps.length - 1);
                        upButton.setEnabled(newIndex > 0);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        downButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                Object object;
                ISelection sel = viewer.getSelection();
                if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof NexusRepository) {
                    NexusRepository selected = (NexusRepository)object;
                    NexusRepository[] reps = RemoteRepositoriesPreferencePage.this.nexusRepositories.toArray(new NexusRepository[0]);
                    int selectedIndex = -1;
                    int i = 0;
                    while (i < reps.length) {
                        NexusRepository rep = reps[i];
                        if (selected.equals(rep)) {
                            selectedIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (selectedIndex >= 0 && selectedIndex < reps.length) {
                        NexusRepository temp = reps[selectedIndex + 1];
                        reps[selectedIndex + 1] = selected;
                        reps[selectedIndex] = temp;
                        RemoteRepositoriesPreferencePage.this.nexusRepositories.clear();
                        NexusRepository[] nexusRepositoryArray = reps;
                        int n = reps.length;
                        int n2 = 0;
                        while (n2 < n) {
                            NexusRepository repository = nexusRepositoryArray[n2];
                            RemoteRepositoriesPreferencePage.this.nexusRepositories.add(repository);
                            ++n2;
                        }
                        viewer.refresh();
                        int newIndex = selectedIndex + 1;
                        downButton.setEnabled(newIndex < reps.length - 1);
                        upButton.setEnabled(newIndex > 0);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = viewer.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    Object object = selection.getFirstElement();
                    editButton.setEnabled(object instanceof NexusRepository);
                    removeButton.setEnabled(object instanceof NexusRepository);
                    upButton.setEnabled(false);
                    downButton.setEnabled(false);
                    if (object instanceof NexusRepository && RemoteRepositoriesPreferencePage.this.nexusRepositories.size() > 1) {
                        NexusRepository repository = (NexusRepository)object;
                        Iterator iterator = RemoteRepositoriesPreferencePage.this.nexusRepositories.iterator();
                        NexusRepository first = null;
                        if (iterator.hasNext()) {
                            first = (NexusRepository)iterator.next();
                        }
                        NexusRepository last = null;
                        while (iterator.hasNext()) {
                            last = (NexusRepository)iterator.next();
                        }
                        if (repository.equals(last)) {
                            upButton.setEnabled(true);
                        } else if (repository.equals(first)) {
                            downButton.setEnabled(true);
                        } else {
                            upButton.setEnabled(true);
                            downButton.setEnabled(true);
                        }
                    }
                } else {
                    editButton.setEnabled(false);
                    removeButton.setEnabled(false);
                    upButton.setEnabled(false);
                    downButton.setEnabled(false);
                }
            }
        });
    }

    protected void performApply() {
        MavenCoreActivator.getDefault();
        MavenCoreActivator.getPreferences();
        this.remoteRepositoryManager.setNexusRepositories(this.nexusRepositories);
        this.remoteRepositoryManager.saveNexusRepositories();
        MavenCoreActivator.getDefault().savePreferences();
        this.tableViewer.setInput(this.nexusRepositories);
        for (NexusRepository nexusRepository : this.nexusRepositories) {
            this.tableViewer.setChecked((Object)nexusRepository, nexusRepository.isEnabled());
        }
    }

    protected void performDefaults() {
        MavenCoreActivator.getPreferences();
        this.remoteRepositoryManager.setNexusRepositories(null);
        this.nexusRepositories = this.remoteRepositoryManager.getDefaultRepositories();
        this.remoteRepositoryManager.saveNexusRepositories();
        MavenCoreActivator.getDefault().savePreferences();
        this.tableViewer.setInput(this.nexusRepositories);
        for (NexusRepository nexusRepository : this.nexusRepositories) {
            this.tableViewer.setChecked((Object)nexusRepository, nexusRepository.isEnabled());
        }
        super.performDefaults();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public boolean performCancel() {
        this.remoteRepositoryManager.setNexusRepositories(null);
        return super.performCancel();
    }

    private class NexusRepositoryContentProvider
    implements IStructuredContentProvider {
        private Set<NexusRepository> repositories;

        public NexusRepositoryContentProvider(Set<NexusRepository> repositories) {
            this.repositories = repositories;
        }

        public Object[] getElements(Object inputElement) {
            return this.repositories.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.repositories = (Set)newInput;
        }
    }

    private class NexusRepositoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private NexusRepositoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof NexusRepository) {
                NexusRepository nr = (NexusRepository)element;
                if (columnIndex == 0) {
                    return nr.getName();
                }
                if (columnIndex == 1) {
                    return nr.getUrl();
                }
            }
            return null;
        }
    }
}

