/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.webapp.model;

import java.util.ArrayList;
import java.util.Set;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FWLoaderUtil
extends XModelObjectLoaderUtil {
    static final String ATTR_DENY_UNCOVERED_HTTP_METHODS = "deny-uncovered-http-methods";
    static final String ATTR_DISTRIBUTABLE = "distributable";
    static final String ATTR_OTHERS = "others";
    static final String ATTR_URL_PATTERN = "url-pattern";
    static final String ATTR_URL_PATTERNS = "url-patterns";
    static final String ATTR_HTTP_METHOD = "http-method";
    static final String ATTR_HTTP_METHODS = "http-methods";
    static final String ATTR_HTTP_METHOD_OMISSION = "http-method-omission";
    static final String ATTR_HTTP_METHOD_OMISSIONS = "http-method-omissions";
    boolean schema = false;

    FWLoaderUtil() {
    }

    protected Set<String> getAllowedChildren(XModelEntity entity) {
        Set children = super.getAllowedChildren(entity);
        if (entity.getName().startsWith("WebAppResourceCollection")) {
            children.add(ATTR_URL_PATTERN);
            children.add(ATTR_HTTP_METHOD);
            if ("WebAppResourceCollection30".equals(entity.getName())) {
                children.add(ATTR_HTTP_METHOD_OMISSION);
            }
        } else if ("WebAppServiceRef".equals(entity.getName())) {
            children.add("port-component-ref");
            children.add("handler");
        } else if ("WebAppFilterMapping24".equals(entity.getName())) {
            children.add("dispatcher");
        } else if (entity.getName().startsWith("FileWebApp")) {
            children.add(ATTR_DISTRIBUTABLE);
            children.add(ATTR_DENY_UNCOVERED_HTTP_METHODS);
        } else if (entity.getName().startsWith("WebAppAbsoluteOrdering")) {
            children.add("name");
            children.add(ATTR_OTHERS);
        } else if (entity.getName().equals("WebAppSessionConfig30")) {
            children.add("tracking-mode");
        }
        return children;
    }

    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if (v == null) {
            return false;
        }
        if (v.length() == 0 || v.equals(dv)) {
            XAttribute attr = entity.getAttribute(n);
            return attr != null && "always".equals(attr.getProperty("save"));
        }
        return super.isSaveable(entity, n, v, dv);
    }

    public String getAttribute(Element element, String xmlname, XAttribute attr) {
        if (ATTR_DISTRIBUTABLE.equals(xmlname)) {
            return XMLUtil.getUniqueChild((Element)element, (String)ATTR_DISTRIBUTABLE) != null ? "yes" : "no";
        }
        if (ATTR_DENY_UNCOVERED_HTTP_METHODS.equals(xmlname)) {
            return XMLUtil.getUniqueChild((Element)element, (String)ATTR_DENY_UNCOVERED_HTTP_METHODS) != null ? "yes" : "no";
        }
        if (ATTR_OTHERS.equals(xmlname)) {
            return XMLUtil.getUniqueChild((Element)element, (String)ATTR_OTHERS) != null ? "true" : "false";
        }
        if ("role-names".equals(xmlname)) {
            return this.loadArray(element, "role-name");
        }
        if ("names".equals(xmlname)) {
            return this.loadArray(element, "name");
        }
        if (ATTR_URL_PATTERNS.equals(xmlname)) {
            return this.loadArray(element, ATTR_URL_PATTERN);
        }
        if (ATTR_HTTP_METHODS.equals(xmlname)) {
            return this.loadArray(element, ATTR_HTTP_METHOD);
        }
        if (ATTR_HTTP_METHOD_OMISSIONS.equals(xmlname)) {
            return this.loadArray(element, ATTR_HTTP_METHOD_OMISSION);
        }
        if ("handlers".equals(xmlname)) {
            return this.loadArray(element, "handler");
        }
        if ("port-component-refs".equals(xmlname)) {
            return this.loadArray(element, "port-component-ref");
        }
        if ("dispatchers".equals(xmlname)) {
            return this.loadArray(element, "dispatcher");
        }
        if ("tracking-modes".equals(xmlname)) {
            return this.loadArray(element, "tracking-mode");
        }
        return super.getAttribute(element, xmlname, attr);
    }

    public void saveAttributes(Element element, XModelObject o) {
        super.saveAttributes(element, o);
        String entity = o.getModelEntity().getName();
        if ("WebAppErrorPage".equals(entity)) {
            this.eitherOr(element, "error-code", "exception-type");
        } else if (entity.startsWith(WebAppHelper.FILTER_ENTITY)) {
            this.eitherOr(element, ATTR_URL_PATTERN, "servlet-name");
        } else if (WebAppHelper.SERVLET_ENTITY.equals(entity) || WebAppHelper.SERVLET_30_ENTITY.equals(entity)) {
            this.eitherOr(element, "servlet-class", "jsp-file");
        }
        if (this.schema) {
            Element e;
            if (o.getModelEntity().getAttribute("description") != null && !o.getModelEntity().getName().startsWith("WebAppResourceCollection")) {
                this.makeChildrenFirst(element, new String[]{"description", "display-name", "icon"});
            }
            if ("WebAppEnvEntry".equals(o.getModelEntity().getName()) && (e = XMLUtilities.getUniqueChild((Element)element, (String)"env-entry-value")) != null) {
                element.removeChild(e);
                element.appendChild(e);
            }
        }
    }

    public void saveAttribute(Element element, String xmlname, String value) {
        if (ATTR_DISTRIBUTABLE.equals(xmlname)) {
            if ("yes".equals(value)) {
                XMLUtil.createElement((Element)element, (String)ATTR_DISTRIBUTABLE);
            }
        } else if (ATTR_DENY_UNCOVERED_HTTP_METHODS.equals(xmlname)) {
            if ("yes".equals(value)) {
                XMLUtil.createElement((Element)element, (String)ATTR_DENY_UNCOVERED_HTTP_METHODS);
            }
        } else if (ATTR_OTHERS.equals(xmlname)) {
            if ("true".equals(value)) {
                XMLUtil.createElement((Element)element, (String)ATTR_OTHERS);
            }
        } else if ("role-names".equals(xmlname)) {
            this.saveArray(element, "role-name", value);
        } else if ("names".equals(xmlname)) {
            this.saveArray(element, "name", value);
        } else if (ATTR_URL_PATTERNS.equals(xmlname)) {
            this.saveArray(element, ATTR_URL_PATTERN, value);
        } else if (ATTR_HTTP_METHODS.equals(xmlname)) {
            this.saveArray(element, ATTR_HTTP_METHOD, value);
        } else if (ATTR_HTTP_METHOD_OMISSIONS.equals(xmlname)) {
            this.saveArray(element, ATTR_HTTP_METHOD_OMISSION, value);
        } else if ("handlers".equals(xmlname)) {
            this.saveArray(element, "handler", value);
        } else if ("port-component-refs".equals(xmlname)) {
            this.saveArray(element, "port-component-ref", value);
        } else if ("dispatchers".equals(xmlname)) {
            this.saveArray(element, "dispatcher", value);
        } else if ("tracking-modes".equals(xmlname)) {
            this.saveArray(element, "tracking-mode", value);
        } else {
            super.saveAttribute(element, xmlname, value);
        }
    }

    public boolean saveChildren(Element element, XModelObject o) {
        String entity = o.getModelEntity().getName();
        if (entity.startsWith("FileWebApp")) {
            return this.saveWebAppChildren(element, o);
        }
        if (WebAppHelper.FILTER_MAPPING_24_ENTITY.equals(entity)) {
            return true;
        }
        if (entity.equals(WebAppHelper.SERVLET_ENTITY) || entity.equals(WebAppHelper.SERVLET_30_ENTITY)) {
            String[] attrs;
            super.saveChildren(element, o);
            String afterName = null;
            String[] cs = new String[]{"run-as", "security-role-ref", "multipart-config"};
            int i = 0;
            while (i < cs.length && afterName == null) {
                if (XMLUtilities.getChildren((Element)element, (String)cs[i]).length > 0) {
                    afterName = cs[i];
                }
                ++i;
            }
            String[] stringArray = attrs = new String[]{"load-on-startup", "enabled", "async-supported"};
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                if (o.getModelEntity().getAttribute(a) != null) {
                    this.moveChild(element, a, afterName);
                }
                ++n2;
            }
        } else {
            if (entity.startsWith("WebAppDataSource")) {
                boolean b = super.saveChildren(element, o);
                String afterName = null;
                XAttribute[] as = o.getModelEntity().getAttributes();
                boolean f = false;
                int i = 0;
                while (i < as.length) {
                    String n = as[i].getName();
                    if (!f && "login-timeout".equals(n)) {
                        f = true;
                    }
                    if (f && XMLUtilities.getUniqueChild((Element)element, (String)n) != null) {
                        afterName = n;
                        break;
                    }
                    if ("max-statements".equals(n)) break;
                    ++i;
                }
                if (afterName != null) {
                    this.moveChild(element, "property", afterName);
                }
                return b;
            }
            if (entity.startsWith("WebAppJMSConnectionFactory")) {
                boolean b = super.saveChildren(element, o);
                String afterName = null;
                XAttribute[] as = o.getModelEntity().getAttributes();
                boolean f = false;
                int i = 0;
                while (i < as.length) {
                    String n = as[i].getName();
                    if (!f && "transactional".equals(n)) {
                        f = true;
                    }
                    if (f && XMLUtilities.getUniqueChild((Element)element, (String)n) != null) {
                        afterName = n;
                        break;
                    }
                    if ("min-pool-size".equals(n)) break;
                    ++i;
                }
                if (afterName != null) {
                    this.moveChild(element, "property", afterName);
                }
                return b;
            }
            boolean b = super.saveChildren(element, o);
            if (o.getModelEntity().getAttribute("mapped-name") != null) {
                this.moveChild(element, "mapped-name", "injection-target");
            }
            if (o.getModelEntity().getAttribute("lookup-name") != null) {
                this.moveChild(element, "lookup-name", null);
            }
            if (o.getModelEntity().getAttribute("tracking-modes") != null) {
                this.moveChild(element, "tracking-mode", null);
            }
            return b;
        }
        return true;
    }

    protected void saveChildren(Element element, XModelObject o, String entity) {
        XModelObject[] os = o.getChildren(entity);
        int i = 0;
        while (i < os.length) {
            this.save(element, os[i]);
            ++i;
        }
    }

    private boolean saveWebAppChildren(Element element, XModelObject o) {
        XModelObject[] os = o.getChildrenForSave();
        boolean b = true;
        int i = 0;
        while (i < os.length) {
            String xmlname = os[i].getModelEntity().getXMLSubPath();
            if (xmlname == null || xmlname.length() == 0) {
                if (!super.saveChildren(element, os[i])) {
                    b = false;
                }
            } else if (!this.save(element, os[i])) {
                b = false;
            }
            ++i;
        }
        return b;
    }

    public void loadChildren(Element element, XModelObject o) {
        String entity = o.getModelEntity().getName();
        if (entity.startsWith("FileWebApp")) {
            FWLoaderUtil.addRequiredChildren((XModelObject)o, (boolean)true);
            XModelObject[] os = o.getChildren();
            int i = 0;
            while (i < os.length) {
                String xmlname = os[i].getModelEntity().getXMLSubPath();
                if (xmlname == null || xmlname.length() == 0) {
                    super.loadChildren(element, os[i]);
                }
                ++i;
            }
            super.loadChildren(element, o);
        } else {
            super.loadChildren(element, o);
        }
    }

    private void makeChildrenFirst(Element element, String[] names) {
        Element[] es = new Element[names.length + 1];
        int[] indices = new int[names.length + 1];
        int k = 0;
        while (k < indices.length) {
            indices[k] = -1;
            ++k;
        }
        NodeList l = element.getChildNodes();
        int i = 0;
        while (i < l.getLength()) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                int index = this.getIndex(n.getNodeName(), names);
                if (index < 0) {
                    index = names.length;
                }
                if (es[index] == null) {
                    es[index] = (Element)n;
                    int k2 = index - 1;
                    while (k2 >= 0) {
                        if (es[k2] == null && (indices[k2] > index || indices[k2] < 0)) {
                            indices[k2] = index;
                        }
                        --k2;
                    }
                }
            }
            ++i;
        }
        i = names.length - 1;
        while (i >= 0) {
            if (es[i] != null && indices[i] >= 0) {
                element.removeChild(es[i]);
                element.insertBefore(es[i], es[indices[i]]);
                int k3 = i - 1;
                while (k3 >= 0) {
                    if (es[k3] != null && indices[k3] > indices[i]) {
                        indices[k3] = indices[i];
                    }
                    --k3;
                }
            }
            --i;
        }
    }

    private int getIndex(String name, String[] names) {
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void moveChild(Element element, String child, String childAfter) {
        NodeList l = element.getChildNodes();
        ArrayList<Element> childE = null;
        Element childAfterE = null;
        int i = 0;
        while (i < l.getLength()) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                String name = n.getNodeName();
                if (child.equals(name)) {
                    if (childE == null) {
                        childE = new ArrayList<Element>();
                    }
                    childE.add((Element)n);
                } else if (name.equals(childAfter) && childAfterE == null) {
                    childAfterE = (Element)n;
                }
            }
            ++i;
        }
        if (childE != null) {
            for (Element c : childE) {
                element.removeChild(c);
                if (childAfterE != null) {
                    element.insertBefore(c, childAfterE);
                    continue;
                }
                element.appendChild(c);
            }
        }
    }

    public boolean save(Element parent, XModelObject o) {
        if (!this.needToSave(o)) {
            return true;
        }
        return super.save(parent, o);
    }

    boolean needToSave(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        if (entity.startsWith("WebAppSessionConfig") || "WebAppLoginConfig".equals(entity)) {
            return this.hasSetAttributes(o);
        }
        if ("WebAppWelcomFileList".equals(entity) || "WebAppLocaleEncodingMappingList".equals(entity)) {
            return o.getChildren().length > 0;
        }
        if (entity.startsWith("WebAppJspConfig")) {
            return o.getChildren().length > 0;
        }
        return true;
    }

    private boolean hasSetAttributes(XModelObject o) {
        XAttribute[] as = o.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() != 0 && !"NAME".equals(xml) && (v = o.getAttributeValue(as[i].getName())) != null && v.length() > 0 && !v.equals(as[i].getDefaultValue())) {
                return true;
            }
            ++i;
        }
        String finalComment = o.get("#final-comment");
        return finalComment != null && finalComment.length() > 0;
    }
}

