/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.validation;

import java.util.List;
import java.util.StringTokenizer;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.jboss.tools.jst.web.validation.Check;
import org.jboss.tools.jst.web.validation.WebXMLValidatorMessages;

public class CheckResource
extends Check {
    boolean acceptEmpty = true;
    String extensions = null;
    String extensionMessage = null;
    boolean canBeServlet = false;

    public CheckResource(ValidationErrorManager manager, String preference, String attr) {
        super(manager, preference, attr);
    }

    public CheckResource(ValidationErrorManager manager, String preference, String attr, boolean acceptEmpty, String extensions, String extensionMessage) {
        super(manager, preference, attr);
        this.acceptEmpty = acceptEmpty;
        this.extensions = extensions;
        this.extensionMessage = extensionMessage;
    }

    public CheckResource acceptServlet() {
        this.canBeServlet = true;
        return this;
    }

    @Override
    public void check(XModelObject object) {
        List<Object> list;
        XModelObject webRoot;
        String value;
        String actualValue = value = object.getAttributeValue(this.attr);
        XModel model = object.getModel();
        XModelObject xModelObject = webRoot = model == null ? null : FileSystemsHelper.getWebRoot((XModel)model);
        if (webRoot == null) {
            return;
        }
        if (this.canBeServlet) {
            if (value != null && value.indexOf("?") > 0) {
                value = value.substring(0, value.indexOf("?"));
            }
            if (this.isMappedToServlet(object, value)) {
                return;
            }
        }
        if ((list = WebPromptingProvider.getInstance().getList(model, "jsf.url.to.path", value, null)) != null && !list.isEmpty()) {
            value = list.get(0).toString();
        }
        if (value == null || value.trim().length() == 0) {
            if (!this.acceptEmpty) {
                this.fireEmpty(object, this.preference, this.attr);
            }
            return;
        }
        XModelObject o = null;
        for (Object v : list) {
            String valuei = v.toString();
            String value2 = valuei.startsWith("/") ? valuei.substring(1) : valuei;
            o = webRoot.getChildByPath(value2);
            if (o == null) continue;
            value = "/" + value2;
            break;
        }
        if (o == null) {
            Object v;
            v = value;
            if (list.size() > 1) {
                v = actualValue;
            }
            this.fireExists(object, this.preference, this.attr, (String)v);
        } else {
            boolean ok = this.checkExtensions(value);
            if (!ok && list != null) {
                for (Object v : list) {
                    ok = this.checkExtensions(v.toString());
                    if (ok) break;
                }
            }
            if (!ok) {
                this.fireExtension(object, this.preference, this.attr, value);
            }
        }
    }

    boolean checkExtensions(String value) {
        value = value.toLowerCase();
        if (this.extensions == null || this.extensions.trim().length() == 0) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(this.extensions, " ");
        while (st.hasMoreTokens()) {
            String ext = st.nextToken();
            if (!value.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    boolean isMappedToServlet(XModelObject o, String value) {
        XModelObject webxml = FileSystemsHelper.getFile((XModelObject)o);
        if (webxml == null) {
            return false;
        }
        XModelObject[] ms = WebAppHelper.getServletMappings(webxml);
        if (ms != null) {
            XModelObject[] xModelObjectArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                XModelObject m = xModelObjectArray[n2];
                String url = m.getAttributeValue("url-pattern");
                if (value != null && value.equals(url)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void fireEmpty(XModelObject object, String id, String attr) {
        this.fireMessage(object, WebXMLValidatorMessages.PATH_EMPTY, attr);
    }

    protected void fireExists(XModelObject object, String id, String attr, String value) {
        this.fireMessage(object, WebXMLValidatorMessages.PATH_NOT_EXISTS, attr, value);
    }

    protected void fireExtension(XModelObject object, String id, String attr, String value) {
        this.fireMessage(object, this.extensionMessage, attr, value);
    }
}

