/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.helpers;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.jst.web.context.RegisterServerContext;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.helpers.IWebProjectTemplate;
import org.jboss.tools.jst.web.project.helpers.ProjectTemplate;
import org.jboss.tools.jst.web.project.version.ProjectVersion;

public abstract class NewWebProjectContext {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_LOCATION = "location";
    public static final String ATTR_USE_DEFAULT_LOCATION = "use default path";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_TEMPLATE = "template";
    public static final String ATTR_SERVLET_VERSION = "servlet version";
    public static final String ATTR_REGISTER_WEB_CONTEXT = "register web context";
    public static final String PROPERTY_RUNTIME_TYPE = "runtimeType";
    protected IWebProjectTemplate template = this.createTemplate();
    protected ProjectTemplate projectTemplateEdit;
    protected IProject project;
    protected String projectLocation;
    protected String version;
    protected String servletVersion;
    protected String projectTemplate;
    protected RegisterServerContext registry;
    Map<String, String> prefs = new HashMap<String, String>();

    public NewWebProjectContext() {
        this.registry = new RegisterServerContext(RegisterServerContext.PROJECT_MODE_NEW);
        this.initRegistry();
    }

    protected abstract IWebProjectTemplate createTemplate();

    protected void initRegistry() {
        this.registry.init();
    }

    public IPath getLocationPath() {
        return new Path(this.projectLocation);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        if (this.project == null || !this.project.getName().equals(this.registry.getApplicationName())) {
            this.registry.setApplicationName(project.getName());
            this.registry.setProjectHandle(project);
        }
        this.project = project;
    }

    public Properties getActionProperties() {
        Properties result = new Properties();
        result.setProperty(ATTR_NAME, this.project.getName());
        result.setProperty(ATTR_LOCATION, this.projectLocation);
        result.setProperty(ATTR_VERSION, this.version);
        result.setProperty(ATTR_TEMPLATE, this.projectTemplate);
        result.setProperty(ATTR_SERVLET_VERSION, this.servletVersion);
        if (this.registry.getRuntime() != null) {
            result.setProperty(PROPERTY_RUNTIME_TYPE, this.registry.getRuntime().getRuntimeType().getId());
        }
        if (this.projectTemplateEdit != null) {
            result.put("preprocessingProperties", this.projectTemplateEdit.getProperties());
        }
        return result;
    }

    public void setProjectLocation(String value) {
        this.projectLocation = value;
    }

    public void setProjectTemplate(String value) {
        if (this.projectTemplate != null && this.projectTemplate.equals(value)) {
            return;
        }
        this.projectTemplate = value;
        this.projectTemplateEdit = this.template.getProjectTemplate(this.version, this.projectTemplate);
    }

    public void setServletVersion(String value) {
        this.servletVersion = value;
        this.registry.setServletVersion(value);
        if (this.version != null) {
            this.prefs.put(this.version, value);
        }
    }

    public String getServletVersion() {
        return this.servletVersion;
    }

    public RegisterServerContext getRegisterServerContext() {
        return this.registry;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        String pref;
        if (this.version != null && this.version.equals(value)) {
            return;
        }
        this.version = value;
        this.projectTemplateEdit = this.template.getProjectTemplate(this.version, this.projectTemplate);
        String sv = this.prefs.get(this.version);
        if (sv != null) {
            this.setServletVersion(sv);
        }
        if ((pref = this.projectTemplateEdit.getProjectVersion().getPreferredServletVersion()) != null && this.compareServletVersions(pref, this.servletVersion) > 0) {
            this.setServletVersion(pref);
        } else if (this.servletVersion != null) {
            this.prefs.put(this.version, this.servletVersion);
        }
    }

    public IWebProjectTemplate getTemplate() {
        return this.template;
    }

    public ProjectTemplate getProjectTemplate() {
        return this.projectTemplateEdit;
    }

    public String validateServletVersion() {
        if (this.projectTemplateEdit == null) {
            return null;
        }
        ProjectVersion v = this.projectTemplateEdit.getProjectVersion();
        if (v == null) {
            return null;
        }
        String min = v.getMinimalServletVersion();
        if (min == null) {
            min = v.getPreferredServletVersion();
        }
        if (min == null) {
            return null;
        }
        int c = this.compareServletVersions(min, this.servletVersion);
        if (c > 0) {
            return MessageFormat.format(WebUIMessages.NewWebProjectContext_ServletVersionMustBeAtLeast, min);
        }
        return null;
    }

    public int compareServletVersions(String sv1, String sv2) {
        String p2;
        if (sv1.equals(sv2)) {
            return 0;
        }
        if (sv1.length() == 0 || sv2.length() == 0) {
            return 0;
        }
        int i1 = sv1.indexOf(46);
        int i2 = sv2.indexOf(46);
        if (i1 < 0 || i2 < 0) {
            return sv1.compareTo(sv2);
        }
        String p1 = sv1.substring(0, i1);
        int r = p1.compareTo(p2 = sv2.substring(0, i2));
        if (r != 0) {
            return r;
        }
        return this.compareServletVersions(sv1.substring(i1 + 1), sv2.substring(i2 + 1));
    }
}

