/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.handlers;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.common.meta.action.impl.MultistepWizardStep;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.project.handlers.AddProjectTemplateSupport;

public class AddProjectTemplateResourcesStep
extends MultistepWizardStep {
    Set<String> excludedResources = new HashSet<String>();
    IProject root;

    public void reset() {
        this.root = null;
        this.excludedResources.clear();
    }

    public String getStepImplementingClass() {
        return "org.jboss.tools.jst.web.ui.wizards.project.AddProjectTemplateResourcesView";
    }

    public void init() {
        IProject p = ((AddProjectTemplateSupport)this.support).getSelectedProject();
        if (p == this.root) {
            return;
        }
        this.excludedResources.clear();
        this.root = p;
        if (this.root == null || !this.root.isOpen()) {
            return;
        }
        try {
            IResource[] rs = this.root.members();
            int i = 0;
            while (i < rs.length) {
                String n = rs[i].getName();
                if (n.startsWith(".") && !n.equals("org.jboss.tools.jst.web.xml")) {
                    this.excludedResources.add(rs[i].getFullPath().toString());
                }
                ++i;
            }
            IResource r = this.root.findMember("WebContent/WEB-INF/lib");
            if (r != null) {
                this.excludedResources.add(r.getFullPath().toString());
            }
            if ((r = this.root.findMember("WebContent/WEB-INF/classes")) != null) {
                this.excludedResources.add(r.getFullPath().toString());
            }
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    void matchResources(IContainer r, Set included) throws CoreException {
        String path = r.getFullPath().toString();
        if (!included.contains(path)) {
            this.excludedResources.add(path);
            return;
        }
        IResource[] rs = r.members();
        int i = 0;
        while (i < rs.length) {
            if (rs[i] instanceof IContainer) {
                this.matchResources((IContainer)rs[i], included);
            } else {
                path = rs[i].getFullPath().toString();
                if (!included.contains(path)) {
                    this.excludedResources.add(path);
                }
            }
            ++i;
        }
    }

    public Set getExcludedResources() {
        return this.excludedResources;
    }

    public void setSelectedResources(Set list) {
        this.excludedResources.clear();
        try {
            this.matchResources((IContainer)this.root, list);
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    Set<String> getExcludedFiles() {
        HashSet<String> set = new HashSet<String>();
        Iterator<String> it = this.excludedResources.iterator();
        while (it.hasNext()) {
            String path = it.next().toString();
            IResource r = this.root.getParent().findMember(path);
            if (r == null) continue;
            File f = r.getLocation().toFile();
            try {
                set.add(f.getCanonicalPath());
            }
            catch (IOException e) {
                WebModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return set;
    }

    public void copyProjectToTemplate(File target, File source, XModel model) {
        final Set<String> set = this.getExcludedFiles();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String path = null;
                try {
                    path = pathname.getCanonicalPath();
                }
                catch (IOException e) {
                    WebModelPlugin.getPluginLog().logError((Throwable)e);
                }
                return path != null && !set.contains(path);
            }
        };
        FileUtil.copyDir((File)source, (File)target, (boolean)true, (boolean)true, (boolean)true, (FileFilter)filter);
    }
}

