/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.tree;

import java.util.ArrayList;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.trees.FileSystemResourceTree;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class WebPagesTree
extends FileSystemResourceTree {
    protected XModelObject fsr;

    public XModelObject getRoot() {
        XModelObject r = FileSystemsHelper.getWebRoot((XModel)this.model);
        return r != null ? r : super.getRoot();
    }

    public XModelObject[] getChildren(XModelObject object) {
        if (!this.hasChildren(object)) {
            return new XModelObject[0];
        }
        ArrayList<XModelObject> l = new ArrayList<XModelObject>();
        XModelObject[] cs = object.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (this.accept(cs[i])) {
                l.add(cs[i]);
            }
            ++i;
        }
        return l.toArray(new XModelObject[0]);
    }

    public XModelObject getParent(XModelObject object) {
        return object == this.getRoot() ? null : object.getParent();
    }

    private boolean accept(XModelObject c) {
        if (c.getFileType() == 2) {
            String overlappedSystem;
            String overlapped = c.get("overlapped");
            if (overlapped != null && overlapped.length() > 0 && !"FileSystems/WEB-INF".equals(overlappedSystem = c.get("overlappedSystem"))) {
                return false;
            }
        } else if (c.getFileType() == 1) {
            String nm = c.getAttributeValue("name");
            if (nm.length() == 0) {
                return false;
            }
            if (!this.accepts0(c)) {
                return false;
            }
        }
        return true;
    }

    public boolean isSelectable(XModelObject object) {
        return object != null && (object.getFileType() == 1 || object.getFileType() == 2);
    }

    public String getPath(XModelObject o) {
        if (o == this.fsr) {
            return "";
        }
        String s = XModelObjectLoaderUtil.getResourcePath((XModelObject)o);
        String p = o.getPath();
        if (p == null) {
            return "";
        }
        int b = "FileSystems/".length();
        int e = p.length() - s.length();
        if (e < b) {
            return "";
        }
        p = p.substring(b, e);
        if (o.getFileType() == 2) {
            s = String.valueOf(s) + "/";
        }
        return s;
    }
}

