/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.helpers;

import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.WebProject;

public class TLDRegistrationHelper {
    public boolean isRegistered(XModel model, XModelObject file) {
        return this.getRegisteredObject(file) != null;
    }

    public void unregister(XModel model, String oldPath) {
        XModelObject t = this.getRegisteredObject(model, oldPath);
        if (t != null) {
            DefaultRemoveHandler.removeFromParent((XModelObject)t);
            XModelObject webxml = WebAppHelper.getWebApp(model);
            XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)webxml, null);
        }
    }

    private XModelObject getRegisteredObject(XModelObject file) {
        if (file == null) {
            return null;
        }
        String path = WebProject.getInstance(file.getModel()).getPathInWebRoot(file);
        return this.getRegisteredObject(file.getModel(), path);
    }

    private XModelObject getRegisteredObject(XModel model, String path) {
        if (path == null) {
            return null;
        }
        XModelObject webxml = WebAppHelper.getWebApp(model);
        if (webxml == null) {
            return null;
        }
        XModelObject[] sz = WebAppHelper.getTaglibs(webxml);
        int i = 0;
        while (i < sz.length) {
            String location = sz[i].getAttributeValue("taglib-location").replace('\\', '/');
            if (path.equalsIgnoreCase(location)) {
                return sz[i];
            }
            ++i;
        }
        return null;
    }
}

