/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.model.helpers.WebProcessStructureHelper;
import org.jboss.tools.jst.web.model.helpers.autolayout.AutoLayout;
import org.jboss.tools.jst.web.model.helpers.autolayout.Items;

public class AutolayoutWebProcessHandler
extends AbstractHandler {
    public boolean isEnabled(XModelObject object) {
        return object != null || object.isObjectEditable();
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        ServiceDialog d = object.getModel().getService();
        String mes = WebUIMessages.YOU_WANT_TO_REARRANGE_THE_DIAGRAM_ELEMENTS;
        String displayName = WizardKeys.getMenuItemDisplayName((XActionItem)this.action, (XModelEntity)(object == null ? null : object.getModelEntity()));
        int i = d.showDialog(displayName, mes, new String[]{WebUIMessages.OK, WebUIMessages.CANCEL}, null, 0);
        if (i != 0) {
            return;
        }
        AutoLayout a = new AutoLayout();
        a.setItems(this.getItemsInstance());
        a.setOverride(true);
        WebProcessStructureHelper h = new WebProcessStructureHelper();
        h.setNodeChangeListenerLock(object, true);
        long ts = object.getTimeStamp();
        try {
            a.setProcess(object);
        }
        finally {
            h.setNodeChangeListenerLock(object, false);
            if (object.getTimeStamp() != ts) {
                object.setModified(true);
                ((XModelImpl)object.getModel()).fireStructureChanged(object);
            }
        }
    }

    protected Items getItemsInstance() {
        String clsname = this.action.getProperty("items-class");
        return (Items)ModelFeatureFactory.getInstance().createFeatureInstance(clsname);
    }
}

