/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.ssh;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.ManageSSHKeysWizardPage;

public class NoSSHKeysWizard
extends Wizard {
    private Connection user;

    public NoSSHKeysWizard(Connection user) {
        this.user = user;
        this.setWindowTitle("No SSH Keys");
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new NoSSHKeysWizardPage(this.user, (IWizard)this));
    }

    private class NoSSHKeysWizardPage
    extends ManageSSHKeysWizardPage {
        NoSSHKeysWizardPage(Connection connection, IWizard wizard) {
            super("Add SSH Keys", "Please make sure you have an SSH public key uploaded to your OpenShift account " + connection.getUsername(), "NoSSHKeysPage", connection, wizard);
        }

        @Override
        protected void doCreateControls(Composite parent, DataBindingContext dbc) {
            Label dummyLabel = new Label(parent, 0);
            ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)dummyLabel)).notUpdatingParticipant()).to(BeanProperties.value((String)"hasSSHKey").observe((Object)this.getPageModel())).validatingAfterGet(new IValidator(){

                public IStatus validate(Object value) {
                    if (Boolean.TRUE.equals(value)) {
                        return ValidationStatus.ok();
                    }
                    return ValidationStatus.cancel((String)NLS.bind((String)"You have no SSH public keys in your OpenShift account\n{0} yet, please add your key(s) or\ncreate new one(s)", (Object)NoSSHKeysWizardPage.this.getPageModel().getConnection().getUsername()));
                }
            })).in(dbc);
            super.doCreateControls(parent, dbc);
        }
    }
}

