/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.snapshot;

import com.jcraft.jsch.Session;
import com.openshift.client.IApplication;
import com.openshift.internal.client.ApplicationSSHSession;
import com.openshift.internal.client.utils.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.express.internal.core.preferences.OpenShiftPreferences;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHSessionRepository;

public class RestoreSnapshotWizardModel
extends ObservablePojo {
    private String filepath;
    private boolean deploymentSnapshot;
    private boolean hotDeploy;
    private IApplication application;

    public RestoreSnapshotWizardModel(IApplication application) {
        this.application = application;
        this.filepath = this.getSnapshotFromPreferences(application, this.isDeploymentSnapshot());
    }

    public IApplication getApplication() {
        return this.application;
    }

    public String setFilepath(String filepath) {
        this.filepath = filepath;
        return this.filepath;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public boolean setDeploymentSnapshot(boolean deploymentSnapshot) {
        this.deploymentSnapshot = deploymentSnapshot;
        return this.deploymentSnapshot;
    }

    public boolean isDeploymentSnapshot() {
        return this.deploymentSnapshot;
    }

    public String restoreSnapshot(IProgressMonitor monitor) throws IOException {
        if (monitor.isCanceled()) {
            return null;
        }
        this.storeSnapshotToPreferences(this.filepath, this.deploymentSnapshot);
        Session session = SSHSessionRepository.getInstance().getSession(this.application);
        FileInputStream snapshotFileInputStream = new FileInputStream(new File(this.getFilepath()));
        InputStream saveResponse = null;
        saveResponse = this.isDeploymentSnapshot() ? new ApplicationSSHSession(this.application, session).restoreDeploymentSnapshot((InputStream)snapshotFileInputStream, this.hotDeploy) : new ApplicationSSHSession(this.application, session).restoreFullSnapshot((InputStream)snapshotFileInputStream);
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        StreamUtils.writeTo((InputStream)saveResponse, (OutputStream)byteArrayOut);
        return new String(byteArrayOut.toByteArray());
    }

    public boolean isHotDeploy() {
        return this.hotDeploy;
    }

    public boolean setHotDeploy(boolean hotDeploy) {
        this.hotDeploy = hotDeploy;
        return this.hotDeploy;
    }

    private void storeSnapshotToPreferences(String filepath, boolean deploymentSnapshot) {
        if (deploymentSnapshot) {
            OpenShiftPreferences.INSTANCE.saveDeploymentSnapshot(this.getApplication(), filepath);
        } else {
            OpenShiftPreferences.INSTANCE.saveFullSnapshot(this.getApplication(), filepath);
        }
    }

    private String getSnapshotFromPreferences(IApplication application, boolean deploymentSnapshot) {
        if (deploymentSnapshot) {
            return OpenShiftPreferences.INSTANCE.getDeploymentSnapshot(application);
        }
        return OpenShiftPreferences.INSTANCE.getFullSnapshot(application);
    }
}

