/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.environment;

import com.openshift.client.IApplication;
import com.openshift.client.IEnvironmentVariable;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.AbstractEnvironmentVariablesWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EnvironmentVariableItem;

public class EditEnvironmentVariablesWizardModel
extends AbstractEnvironmentVariablesWizardModel {
    private IApplication application;

    public EditEnvironmentVariablesWizardModel(IApplication application) {
        this.application = application;
    }

    @Override
    public void refreshEnvironmentVariables() {
        if (!this.isSupported()) {
            return;
        }
        this.application.refresh();
        this.loadEnvironmentVariables();
    }

    @Override
    public void loadEnvironmentVariables() {
        if (!this.isSupported()) {
            return;
        }
        this.clear();
        this.add(this.application);
    }

    private void add(IApplication application) {
        for (IEnvironmentVariable variable : application.getEnvironmentVariables().values()) {
            this.add(new EnvironmentVariableItem(variable.getName(), variable.getValue()));
        }
    }

    public IApplication getApplication() {
        return this.application;
    }

    @Override
    public boolean isSupported() {
        return this.application != null && this.application.canUpdateEnvironmentVariables() && this.application.canGetEnvironmentVariables();
    }

    @Override
    public String getHost() {
        if (this.application == null || this.application.getDomain() == null || this.application.getDomain().getUser() == null) {
            return "";
        }
        return this.application.getDomain().getUser().getServer();
    }
}

